<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CashRegisterList extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'cash_registers_list';

    protected $guarded = ['id'];
    
    public static function forDropdown($business_id, $location = null, $id = null)
    {
        if($location == null) {
            $all_cg = CashRegisterList::where('business_id', $business_id);
        } else {
            if($id == null) {
                $all_cg = CashRegisterList::where('business_id', $business_id)->where('location_id', $location);
            } else {
                $all_cg = CashRegisterList::where('business_id', $business_id)->where('location_id', $location)->where('id', $id);
            }
        }        
        $all_cg = $all_cg->pluck('name', 'id');
        return $all_cg;
    }
}
