<?php

namespace App\Console\Commands;

use App\AmazonSellerInventory;
use App\AmazonSellerInventoryTesting;
use App\Http\Controllers\AmazonController;
use App\Jobs\RequestInventoryJob;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class RequestInventoryReport extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'request:reportinventory';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Request Report Inventory Amazon';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            //code...
            $amazon_sellers = DB::table('amazon_sellers')->select('seller_id')->get();
            $delayStart = now(); // Mulai delay
            if($amazon_sellers) {
                DB::table('amazon_seller_inventories')->delete();
                foreach ($amazon_sellers as $key => $value) {                    
                    # code...
                    sleep(5);
                    $startTime = microtime(true);
                    app(AmazonController::class)->requestInventoryReport($value->seller_id);
                    $endTime = microtime(true); // Waktu selesai
                    $executionTime = $endTime - $startTime; // Hitung durasi dalam detik
                    \Log::info("Job finish Request Inventory Report Seller ID: {$value->seller_id} at {$executionTime} seconds.");

                    // sleep(2); // wait 2 minutes
                }
            } else {
                \Log::info("Amazon sellers are empty");
            }
        } catch (\Exception $e) {
            \Log::emergency('Error Cron Job Request Inventory Report. File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            exit($e->getMessage());
        }
    }
}
