<?php

namespace App\Exports;

use App\BusinessLocation;
use Maatwebsite\Excel\Concerns\FromArray;

class ImportProductTemplate implements FromArray
{
    public function array(): array
    {
        $business_id = request()->session()->get('user.business_id');
        
        $locations = BusinessLocation::where('business_id', $business_id)->orderBy('id')->get();        
        // set headers
        $template_import_product = [[
            'SKU (Leave blank to auto generate sku)', 'NAME', 'PRODUCT DESCRIPTION', 'BRAND', 'UNIT', 'CATEGORY', 'SUB-CATEGORY', 'PURCHASE PRICE', 'SELLING PRICE', 'EXPIRES IN', 'EXPIRY PERIOD UNIT (months/days)', 'PRODUCT TYPE (single or variable)', 'VARIATION NAME (Keep blank if product type is single)', 'VARIATION VALUES (| seperated values & blank if product type if single)', 'VARIATION SKUs (| seperated values & blank if product type if single)', 'MANAGE STOCK (1=yes 0=No)', 'PROFIT MARGIN','ALERT QUANTITY', 'RACK', 'ROW', 'POSITION', 'IMAGE', 'NOT FOR SELLING(1=yes 0=No)'
        ]];
        if($locations) {
            foreach ($locations as $key => $value) {
                # code...
                array_push($template_import_product[0], $value->name.' Qty');
            }
        } 
        // dd($template_import_product);
        return $template_import_product;
    }
}