<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\AmazonSeller;

class AmazonAuthController extends Controller
{
    /**
     * Redirect seller to Amazon authorization page.
     */
    public function redirectToAmazon()
    {
        // $appid = env('SP_API_CLIENT_APP_ID');
        // $redirectUri = urlencode(env('SP_API_REDIRECT_URI'));

        $amazonAuthUrl = "https://sellercentral.amazon.com/apps/authorize/consent?"
            . "application_id=" . env('SP_API_CLIENT_APP_ID')
            . "&version=beta"
            . "&state=" . csrf_token()
            . "&redirect_uri=" . urlencode(env('SP_API_REDIRECT_URI'));

        return redirect($amazonAuthUrl);
    }

    /**
     * Handle Amazon authorization callback.
     */
    public function handleCallback(Request $request)
    {
        Log::info('Amazon Callback Data:', $request->all());

        $sellerId = $request->query('selling_partner_id'); 
        $authCode = $request->query('spapi_oauth_code');

        if (!$sellerId || !$authCode) {
            return response()->json(['error' => 'Missing required parameters'], 400);
        }

        // Exchange auth code for a refresh token
        $refreshToken = '';
        $response = Http::asForm()->post('https://api.amazon.com/auth/o2/token', [
            'grant_type' => 'authorization_code',
            'code' => $authCode,
            'client_id' => env('SP_API_CLIENT_ID'),
            'client_secret' => env('SP_API_CLIENT_SECRET'),
            'redirect_uri' => env('SP_API_REDIRECT_URI'),
        ]);

        if ($response->successful()) {
            $refreshToken = $response->json()['refresh_token'] ?? null;
        }else {
            return response()->json(['message' => 'problem with the request'], $response->status());
        }

        // Store seller data
        // Check if seller exists and delete if it does
        $existingSeller = AmazonSeller::where('seller_id', $sellerId)->first();
        if ($existingSeller) {
            $existingSeller->delete();
        }
        $seller = AmazonSeller::create([
            'seller_id' => $sellerId,
            'auth_code' => $authCode,
            'refresh_token' => $refreshToken,
        ]);

        return response()->json(['message' => 'Seller registered successfully!', 'seller_id' => $seller->seller_id]);
    }

    public function showAuthorizationPage()
    {
        return view('amazon.authorize');
    }
}
