<?php

namespace App\Http\Controllers;

use AmazonPHP\SellingPartner\Configuration as SellingPartnerConfiguration;
use App\AiCreditTransactions;
use App\AmazonDashboardData;
use Illuminate\Support\Facades\Env;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\Curl;
use App\Business;
use App\Jobs\NewAmazonJob;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\Transaction;
use App\CompetitivePrices;
use App\Utils\ProductUtil;
use App\Variation;
use App\VariationLocationDetails;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use App\Services\AmazonSpApiService;
use App\AmazonSellerInventory;
use App\AmazonTable;
use App\Barcode;
use App\Jobs\ConvertAmazonToShopifyJob;
use App\Jobs\UpdateAmazonSellerInventoryJob;
use App\SellingPriceGroup;
use App\ShopifyTable;
use App\ShopifyUpdate;
use SellingPartnerApi\SellingPartnerApi;
use SellingPartnerApi\Enums\Endpoint;
use SellingPartnerApi\FeedType;
use SellingPartnerApi\Feeds;
use SellingPartnerApi\ReportDocumentEncryptionDetails;
use SellingPartnerApi\Helpers\FeedDocumentHelper;
use SellingPartnerApi\SellerApi;
use SellingPartnerApi\Seller\SellerConnector;
use SellingPartnerApi\Seller\CatalogItemsV0\Requests\ListCatalogItems;
use SellingPartnerApi\Seller\ListingsItemsV20210801\ListingsItemPatchRequest;
use Saloon\Contracts\ArrayStore;
use SellingPartnerApi\Model\ListingsItemsV20210801\PatchOperation;
use SellingPartnerApi\Seller\FeedsV20210630\Api as FeedsApi;
use SellingPartnerApi\Seller\ProductTypeDefinitionsV20200901\Api as ProductTypeDefinitionsApi;

use function PHPSTORM_META\map;
use DateTime;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use App\Services\KeepaService;
use Aws\AwsClient;
use Aws\Credentials\Credentials;
use Aws\Sdk;
use Aws\Signature\SignatureV4;
use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use Illuminate\Support\Facades\Storage;
use SellingPartnerApi\Seller\FeedsV20210630\Dto\CreateFeedSpecification;

use Saloon\Exceptions\Request\RequestException;
use Saloon\Exceptions\Request\Statuses\NotFoundException;

class AmazonController extends Controller
{
    protected $shopify;
    protected $shopify_udb;
    protected $productUtil;
    protected $amazonService;
    protected $spApi;
    public $product_locations;
    public $checkmarks;
    protected $connector;
    protected $DEBUG_MODE = true;

    protected $IsCompletedSameAsinSku = true;
    protected $IsCompletedSameAsinSkuNoDescription = true;
    protected $IsCompletedSameAsinAndSkuDoesNotExists = true;

    public function __construct(ShopifyController $shopify, ShopifyControllerUdb $shopify_udb, ProductUtil $productUtil, AmazonSpApiService $amazonService)
    {
        $this->shopify = $shopify;
        $this->shopify_udb = $shopify_udb;
        $this->productUtil = $productUtil;
        $this->amazonService = $amazonService;

        // $this->spApi = new SpApi([
        //     'access_key'    => env('SP_API_ACCESS_KEY'),
        //     'secret_key'    => env('SP_API_SECRET_KEY'),
        //     'client_id'     => env('SP_API_CLIENT_ID'),
        //     'client_secret' => env('SP_API_CLIENT_SECRET'),
        //     'refresh_token' => env('SP_API_REFRESH_TOKEN'),
        //     'region'        => env('SP_API_REGION'),
        // ]);


    }

    public static function isbn13ToIsbn10($isbn13)
    {
        if (strlen($isbn13) !== 13 || substr($isbn13, 0, 3) !== '978') {
            return null; // Invalid ISBN-13
        }

        $isbn10 = substr($isbn13, 3, 9); // Remove '978'
        $sum = 0;

        for ($i = 0; $i < 9; $i++) {
            $sum += ($i + 1) * intval($isbn10[$i]);
        }

        $checkDigit = $sum % 11;
        $isbn10 .= ($checkDigit === 10) ? 'X' : $checkDigit;

        return $isbn10;
    }

    public static function isbn10Toisbn13($isbn10)
    {
        // Pastikan hanya angka dan huruf 'X' yang valid dalam ISBN-10
        if (!preg_match('/^\d{9}[\dX]$/', $isbn10)) {
            return $isbn10; // Jika bukan ISBN-10, kembalikan input asli
        }
        // Pastikan hanya angka dan hapus karakter lain
        $isbn10 = preg_replace('/[^0-9X]/', '', $isbn10);

        // ISBN-10 harus memiliki 10 karakter
        if (strlen($isbn10) !== 10) {
            return $isbn10;
        }

        // Hilangkan checksum (karakter terakhir ISBN-10)
        $isbnBase = '978' . substr($isbn10, 0, 9);

        // Hitung checksum ISBN-13
        $checksum = 0;
        for ($i = 0; $i < 12; $i++) {
            $checksum += ($i % 2 === 0 ? 1 : 3) * $isbnBase[$i];
        }
        $checksum = (10 - ($checksum % 10)) % 10; // Modulo 10

        // Gabungkan dan kembalikan ISBN-13
        return $isbnBase . $checksum;
    }

    public function convertAmazonToShopify($vendor)
    {
        $row = 0;
        $asin = '';
        try {
            //code...
            // $amazon_table = AmazonTable::orderBy('asin')->get();
            // if (!empty($amazon_table)) {
                $convert_count = 0; 
                $arr_amazon_products = [];
                ShopifyUpdate::truncate();
                AmazonTable::where('status', '!=', 'deleted')->orderBy('asin')->chunk(1000, function ($amazon_table) use ($arr_amazon_products, $row, $vendor, $convert_count) {
                    foreach ($amazon_table as $key => $at) {
                        # code...
                        $row++;
                        $asin = $at->ASIN;
                        // $key_arr_amazon_product = array_search($at->ASIN, array_column($arr_amazon_products, 'barcode'));
                        $matches = array_filter($arr_amazon_products, function ($product) use ($at) {
                            return $product['barcode'] === $at->ASIN && $product['metafield_condition'] === $at->ItemCondition;
                        });
                        // if ($key_arr_amazon_product > -1) {
                        if ($matches) {
                            $key_arr_amazon_product = array_key_first($matches); // ambil index 
                            if ($arr_amazon_products[$key_arr_amazon_product]['metafield_condition'] == $at->ItemCondition) {
                                if ((float)$arr_amazon_products[$key_arr_amazon_product]['price'] > (float)$at->AmazonSellerInventoryPrice) {
                                    $arr_amazon_products[$key_arr_amazon_product]['price'] = $at->AmazonSellerInventoryPrice;
                                    $arr_amazon_products[$key_arr_amazon_product]['seller_sku'] = $at->SellerSku;
                                }
                                $arr_amazon_products[$key_arr_amazon_product]['qty'] = $arr_amazon_products[$key_arr_amazon_product]['qty'] + $at->CurrentQty;
                                array_push($arr_amazon_products[$key_arr_amazon_product]['products'], [
                                    'id' => $at->id,
                                    'store' => $at->store,
                                    'asin' => $at->ASIN,
                                    'itemCondition' => $at->ItemCondition,
                                    'sellerSku' => $at->SellerSku,
                                    'price' => number_format($at->AmazonSellerInventoryPrice - ($at->AmazonSellerInventoryPrice * (15/100)), 2, '.', ''),
                                    'qty' => $at->CurrentQty
                                ]);
                            } else {
                                $classification = $at->Classifications != '[]' ? json_decode($at->Classifications)[0]->displayName : 'gid://shopify/ProductTaxonomyNode/4134';
                                array_push($arr_amazon_products, [
                                    'title' => $at->Title,
                                    'description' => $at->description . ', ISBN13: ' . self::isbn10Toisbn13($at->ASIN) . ' ISBN10: ' . $at->ASIN . ' Material Type: ' . $at->Binding,
                                    'images' => $at->Images,
                                    'category' => $at->ClassificationRanks != '[]' ? json_decode($at->ClassificationRanks)[0]->title : $classification,
                                    'price' => number_format($at->AmazonSellerInventoryPrice - ($at->AmazonSellerInventoryPrice * (15/100)), 2, '.', ''),
                                    'seller_sku' => $at->SellerSku,
                                    'barcode' => $at->ASIN,
                                    'qty' => $at->status == 'Deleted' ? 0 : $at->CurrentQty,
                                    'metafield_description' => ', ISBN13: ' . self::isbn10Toisbn13($at->ASIN) . ' ISBN10: ' . $at->ASIN . ' Material Type: ' . $at->Binding,
                                    'metafield_title' => $at->Title,
                                    'metafield_edition' => null,
                                    'metafield_material_type' => $at->Binding,
                                    'metafield_format' => $at->Format,
                                    'metafield_condition' => $at->ItemCondition,
                                    'metafield_publisher' => $at->Authors,
                                    'metafield_publication_date' => $at->PublicationDate,
                                    'metafield_languange' => $at->Languages,
                                    'metafield_print_length' => $at->Pages,
                                    'metafield_isbn13' => self::isbn10Toisbn13($at->ASIN),
                                    'metafield_isbn10' => $at->ASIN,
                                    'collections' => $at->ClassificationRanks != '[]' ? $at->ClassificationRanks : $at->Classifications,
                                    'tags' => $at->ClassificationRanks != '[]' ? $at->ClassificationRanks : $at->Classifications,
                                    'vendor' => $vendor,
                                    'products' => [
                                        [
                                            'id' => $at->id,
                                            'store' => $at->store,
                                            'asin' => $at->ASIN,
                                            'itemCondition' => $at->ItemCondition,
                                            'sellerSku' => $at->SellerSku,
                                            'price' => $at->AmazonSellerInventoryPrice,
                                            'qty' => $at->CurrentQty,
                                            'status' => $at->status
                                        ]
                                    ]
                                ]);
                            }
                        } else {
                            $classification = $at->Classifications != '[]' ? json_decode($at->Classifications)[0]->displayName : 'gid://shopify/ProductTaxonomyNode/4134';
                            array_push($arr_amazon_products, [
                                'title' => $at->Title,
                                'description' => $at->description . ', ISBN13: ' . self::isbn10Toisbn13($at->ASIN) . ' ISBN10: ' . $at->ASIN . ' Material Type: ' . $at->Binding,
                                'images' => $at->Images,
                                'category' => $at->ClassificationRanks != '[]' ? json_decode($at->ClassificationRanks)[0]->title : $classification,
                                'price' => number_format($at->AmazonSellerInventoryPrice - ($at->AmazonSellerInventoryPrice * (15/100)), 2, '.', ''),
                                'seller_sku' => $at->SellerSku,
                                'barcode' => $at->ASIN,
                                'qty' => $at->status == 'Deleted' ? 0 : $at->CurrentQty,
                                'metafield_description' => ', ISBN13: ' . self::isbn10Toisbn13($at->ASIN) . ' ISBN10: ' . $at->ASIN . ' Material Type: ' . $at->Binding,
                                'metafield_title' => $at->Title,
                                'metafield_edition' => null,
                                'metafield_material_type' => $at->Binding,
                                'metafield_format' => $at->Format,
                                'metafield_condition' => $at->ItemCondition,
                                'metafield_publisher' => $at->Authors,
                                'metafield_publication_date' => $at->PublicationDate,
                                'metafield_languange' => $at->Languages,
                                'metafield_print_length' => $at->Pages,
                                'metafield_isbn13' => self::isbn10Toisbn13($at->ASIN),
                                'metafield_isbn10' => $at->ASIN,
                                'collections' => $at->ClassificationRanks != '[]' ? $at->ClassificationRanks : $at->Classifications,
                                'tags' => $at->ClassificationRanks != '[]' ? $at->ClassificationRanks : $at->Classifications,
                                'vendor' => $vendor,
                                // 'synced' => 1,
                                'products' => [
                                    [
                                        'id' => $at->id,
                                        'store' => $at->store,
                                        'asin' => $at->ASIN,
                                        'itemCondition' => $at->ItemCondition,
                                        'sellerSku' => $at->SellerSku,
                                        'price' => $at->AmazonSellerInventoryPrice,
                                        'qty' => $at->CurrentQty,
                                        'status' => $at->status
                                    ]
                                ]
                            ]);
                        }
                    }
                    // if ($this->DEBUG_MODE) Log::info("Done combine products. next save to shopify_update");                                   
                    /* $arr_data_shopify_update = [];
                    $arr_data_shopify_table = [];
                    foreach ($arr_amazon_products as $key => $aap) {
                        # code...
                        $formattedProduct = $aap;
                        $formattedProduct['products'] = json_encode($aap['products']);
    
                        // ShopifyTable::create($formattedProduct);
                        if (ShopifyTable::where('barcode', $aap['barcode'])->where('vendor', $vendor)->exists()) {
                            $shopify_table = ShopifyTable::where('barcode', $aap['barcode'])->first();
                            if ($shopify_table->price != $aap['price'] || $shopify_table->qty != $aap['qty']) {
                                $formattedProduct['update_or_create'] = 'update';
                                // ShopifyUpdate::create($formattedProduct);                            
                                $shopify_table->price = $aap['price'] ;
                                $shopify_table->qty = $aap['qty'];
                                $shopify_table->save();
                                array_push($arr_data_shopify_update, $formattedProduct);
                                if ($this->DEBUG_MODE) Log::info($aap['barcode'] . ' Inserted to shopify_update table status update.');
                                // if ($this->DEBUG_MODE) Log::info($aap['barcode']. ' Updated to shopify_table.');
                                $convert_count++;
                            }
                        } else {
                            $formattedProduct['update_or_create'] = 'create';
                            array_push($arr_data_shopify_update, $formattedProduct);
                            array_push($arr_data_shopify_table, $formattedProduct);
                            // ShopifyUpdate::create($formattedProduct);
                            // ShopifyTable::create($formattedProduct);
                            if ($this->DEBUG_MODE) Log::info($aap['barcode'] . ' Inserted to shopify_update table status create.');
                            // if ($this->DEBUG_MODE) Log::info($aap['barcode']. ' Inserted to shopify_table.');
                            $convert_count++;
                        }
                    }
                    ShopifyUpdate::create($arr_data_shopify_update);
                    ShopifyTable::create($arr_data_shopify_table); */
    
                    $arr_data_shopify_update = [];
                    $arr_data_shopify_table = [];
    
                    // Step 1: Extract all barcodes from input
                    $barcode = array_column($arr_amazon_products, 'barcode');                                                          
                    // Step 2: Load all existing ShopifyTable records for the given vendor & barcodes
                    $existingRecords = ShopifyTable::whereIn('barcode', $barcode)
                        ->where('vendor', $vendor)
                        ->get()
                        ->keyBy(function ($item) {
                            return $item->barcode . '|' . $item->metafield_condition;
                        });// Fast lookup                                        
                    foreach ($arr_amazon_products as $aap) {
                        $formattedProduct = $aap;        
                        $key = $aap['barcode'] . '|' . $aap['metafield_condition'];            
    
                        // if ($existingRecords->has($aap['seller_sku'])) {
                        //     $shopify_table = $existingRecords[$aap['seller_sku']];
    
                         if ($existingRecords->has($key)) {
                            $shopify_table = $existingRecords[$key];
                            // Check if update is needed
                            if ($shopify_table->price != $aap['price'] || $shopify_table->qty != $aap['qty']) {
                                $shopify_table->price = $aap['price'];
                                $shopify_table->qty = $aap['qty'];
                                $shopify_table->save(); // Update only if changed
    
                                $formattedProduct['products'] = json_encode($aap['products']);
                                $formattedProduct['vendor'] = $vendor; // Ensure this is set correctly
                                $formattedProduct['update_or_create'] = 'update';
                                $arr_data_shopify_update[] = $formattedProduct;
    
                                if ($this->DEBUG_MODE) Log::info($aap['seller_sku'] . ' updated.');
                            }
                        } else {
                            // New product: prepare for bulk insert
                            $arr_data_shopify_table[] = $formattedProduct;
                            $formattedProduct['products'] = json_encode($aap['products']);
                            $formattedProduct['vendor'] = $vendor; // Ensure this is set correctly
                            $formattedProduct['update_or_create'] = 'create';
                            $arr_data_shopify_update[] = $formattedProduct;
    
                            if ($this->DEBUG_MODE) Log::info($aap['seller_sku'] . ' inserted.');
                        }
    
                        // $convert_count++;
                    }                                                                
                    // Step 3: Bulk insert into ShopifyUpdate (assuming insert() works here)
                    if (!empty($arr_data_shopify_update)) {
                        // Step 1: Extract all barcodes from input
                        $barcode = array_column($arr_data_shopify_update, 'barcode');
                        // Step 2: Load all existing ShopifyTable records for the given vendor & barcodes
                        $store = env('SHOPIFY_URL');
                        if($vendor == 'UsedBookDepot') {
                            $store = env('USEDBOOKDEPOT_URL');
                        }
                        $existingShopifyRecords = DB::table('shopify_server_temp')->whereIn('barcode', $barcode)
                            ->where('store', $store)
                            ->get()
                            ->keyBy(function ($item) {
                                return $item->barcode . '|' . $item->condition;
                            });// Fast lookup 
                        $cleanedArray = array_filter(array_map(function ($aap) use ($existingShopifyRecords) {
                            // unset($item['products']);
                            $key = $aap['barcode'] . '|' .$aap['metafield_condition'];
                            if ($existingShopifyRecords->has($key) && $aap['update_or_create'] == 'create') {
                                return null;
                            }
                            return [
                                'title' => $aap['title'] ?? null,
                                'description' => $aap['description'] ?? null,
                                'images' => $aap['images'] ?? [],
                                'category' => $aap['category'] ?? null,
                                'seller_sku' => $aap['seller_sku'] ?? null,
                                'barcode' => $aap['barcode'] ?? null,
                                'price' => $aap['price'] ?? null,
                                'qty' => $aap['qty'] ?? 0,
                                'metafield_description' => $aap['metafield_description'] ?? null,
                                'metafield_title' => $aap['metafield_title'] ?? null,
                                'metafield_edition' => $aap['metafield_edition'] ?? null,
                                'metafield_material_type' => $aap['metafield_material_type'] ?? null,
                                'metafield_format' => $aap['metafield_format'] ?? null,
                                'metafield_condition' => $aap['metafield_condition'] ?? null,
                                'metafield_publisher' => $aap['metafield_publisher'] ?? [],
                                'metafield_publication_date' => $aap['metafield_publication_date'] ?? null,
                                'metafield_languange' => $aap['metafield_languange'] ?? [],
                                'metafield_print_length' => $aap['metafield_print_length'] ?? null,
                                'metafield_isbn13' => $aap['metafield_isbn13'] ?? null,
                                'metafield_isbn10' => $aap['metafield_isbn10'] ?? null,
                                'collections' => $aap['collections'] ?? [],
                                'vendor' => $aap['vendor'] ?? null,
                                'tags' => $aap['tags'] ?? [],
                                'products' => json_encode($aap['products'] ?? []),
                                'update_or_create' => $aap['update_or_create'] ?? null,
                                'synced' => 0,
                                'weight' => $aap['weight'] ?? null,
                                'product_type' => $aap['product_type'] ?? null,
                                'store' => $aap['vendor'] ?? null,
                                'created_at' => now(),
                                'updated_at' => now(),
                            ];
                        }, $arr_data_shopify_update));                        
                        $chunks = array_chunk($cleanedArray, 1000);                        
                        foreach ($chunks as $chunk) {                            
                            ShopifyUpdate::insert($chunk);                            
                        }

                        $convert_count = count($arr_data_shopify_update);
                    }
                    // Step 4: Bulk insert new products (if any)
                    // if (!empty($arr_data_shopify_table)) {
                    //     $cleanedArray = array_map(function ($aap) {
                    //         // unset($item['products']);
                    //         return [
                    //             'title' => $aap['title'] ?? null,
                    //             'description' => $aap['description'] ?? null,
                    //             'images' => $aap['images'] ?? [],
                    //             'category' => $aap['category'] ?? null,
                    //             'seller_sku' => $aap['seller_sku'] ?? null,
                    //             'barcode' => $aap['barcode'] ?? null,
                    //             'price' => $aap['price'] ?? null,
                    //             'qty' => $aap['qty'] ?? 0,
                    //             'metafield_description' => $aap['metafield_description'] ?? null,
                    //             'metafield_title' => $aap['metafield_title'] ?? null,
                    //             'metafield_edition' => $aap['metafield_edition'] ?? null,
                    //             'metafield_material_type' => $aap['metafield_material_type'] ?? null,
                    //             'metafield_format' => $aap['metafield_format'] ?? null,
                    //             'metafield_condition' => $aap['metafield_condition'] ?? null,
                    //             'metafield_publisher' => $aap['metafield_publisher'] ?? [],
                    //             'metafield_publication_date' => $aap['metafield_publication_date'] ?? null,
                    //             'metafield_languange' => $aap['metafield_languange'] ?? [],
                    //             'metafield_print_length' => $aap['metafield_print_length'] ?? null,
                    //             'metafield_isbn13' => $aap['metafield_isbn13'] ?? null,
                    //             'metafield_isbn10' => $aap['metafield_isbn10'] ?? null,
                    //             'collections' => $aap['collections'] ?? [],
                    //             'vendor' => $aap['vendor'] ?? null,
                    //             'tags' => $aap['tags'] ?? [],
                    //             'products' => json_encode($aap['products'] ?? []),
                    //             'synced' => 0,
                    //             'weight' => $aap['weight'] ?? null,
                    //             'product_type' => $aap['product_type'] ?? null,
                    //             'created_at' => now(),
                    //             'updated_at' => now(),
                    //         ];
                    //     }, $arr_data_shopify_update);
                        
                    //     $chunks = array_chunk($cleanedArray, 1000);
    
                    //     foreach ($chunks as $chunk) {
                    //         ShopifyTable::insert($chunk);
                    //     }                                                   
                    // }                
                });

                return [
                    'message' => 'Successfully convert to shopify table',
                    'count' => $convert_count,
                ];
            // } else {
            //     // return response()->json(['message' => 'Data not found.', 'count' => 0]);
            //     return [
            //         'message' => 'Data not found',
            //         'count' => 0
            //     ];
            // }
        } catch (\Exception $e) {
            //throw $th;            
            Log::error("Convert Amazon To Shopify Error: " . $e->getMessage());
            // return response()->json(['message' => $e->getMessage() . ' Line: ' . $e->getLine() . ' Row:' . $row . ' ASIN: ' . $asin]);
            return [
                'message' => $e->getMessage() . ' Line: ' . $e->getLine() . ' Row:' . $row . ' ASIN: ' . $asin,
                'count' => 0
            ];
        }
    }

    public function combineAmazonProducts($vendor)
    {
        $row = 0;
        $asin = '';
        try {
            //code...
            // $amazon_table = AmazonTable::orderBy('asin')->get();
            // if (!empty($amazon_table)) {
                $convert_count = 0; 
                $arr_amazon_products = [];
                DB::table('combine_amazon_table')->truncate();
                AmazonTable::where('status', '!=', 'deleted')->orderBy('asin')->chunk(1000, function ($amazon_table) use ($arr_amazon_products, $row, $vendor, $convert_count) {                    
                    foreach ($amazon_table as $key => $at) {
                        # code...
                        $row++;
                        $asin = $at->ASIN;
                        // $key_arr_amazon_product = array_search($at->ASIN, array_column($arr_amazon_products, 'barcode'));
                        $matches = array_filter($arr_amazon_products, function ($product) use ($at) {
                            return $product['barcode'] === $at->ASIN && $product['metafield_condition'] === $at->ItemCondition;
                        });
                        // if ($key_arr_amazon_product > -1) {
                        if ($matches) {
                            $key_arr_amazon_product = array_key_first($matches); // ambil index pertama                            
                            if ($arr_amazon_products[$key_arr_amazon_product]['metafield_condition'] == $at->ItemCondition) {
                                if ((float)$arr_amazon_products[$key_arr_amazon_product]['price'] > (float)$at->AmazonSellerInventoryPrice) {
                                    $arr_amazon_products[$key_arr_amazon_product]['price'] = $at->AmazonSellerInventoryPrice;
                                    $arr_amazon_products[$key_arr_amazon_product]['seller_sku'] = $at->SellerSku;
                                }
                                $arr_amazon_products[$key_arr_amazon_product]['qty'] = $arr_amazon_products[$key_arr_amazon_product]['qty'] + $at->CurrentQty;
                                array_push($arr_amazon_products[$key_arr_amazon_product]['products'], [
                                    'id' => $at->id,
                                    'store' => $at->store,
                                    'asin' => $at->ASIN,
                                    'itemCondition' => $at->ItemCondition,
                                    'sellerSku' => $at->SellerSku,
                                    'price' => number_format($at->AmazonSellerInventoryPrice - ($at->AmazonSellerInventoryPrice * (15/100)), 2, '.', ''),
                                    'qty' => $at->CurrentQty
                                ]);
                            } else {
                                $classification = $at->Classifications != '[]' ? json_decode($at->Classifications)[0]->displayName : 'gid://shopify/ProductTaxonomyNode/4134';
                                array_push($arr_amazon_products, [
                                    'title' => $at->Title,
                                    'description' => $at->description . ', ISBN13: ' . self::isbn10Toisbn13($at->ASIN) . ' ISBN10: ' . $at->ASIN . ' Material Type: ' . $at->Binding,
                                    'images' => $at->Images,
                                    'category' => $at->ClassificationRanks != '[]' ? json_decode($at->ClassificationRanks)[0]->title : $classification,
                                    'price' => number_format($at->AmazonSellerInventoryPrice - ($at->AmazonSellerInventoryPrice * (15/100)), 2, '.', ''),
                                    'seller_sku' => $at->SellerSku,
                                    'barcode' => $at->ASIN,
                                    'qty' => $at->status == 'Deleted' ? 0 : $at->CurrentQty,
                                    'metafield_description' => ', ISBN13: ' . self::isbn10Toisbn13($at->ASIN) . ' ISBN10: ' . $at->ASIN . ' Material Type: ' . $at->Binding,
                                    'metafield_title' => $at->Title,
                                    'metafield_edition' => null,
                                    'metafield_material_type' => $at->Binding,
                                    'metafield_format' => $at->Format,
                                    'metafield_condition' => $at->ItemCondition,
                                    'metafield_publisher' => $at->Authors,
                                    'metafield_publication_date' => $at->PublicationDate,
                                    'metafield_languange' => $at->Languages,
                                    'metafield_print_length' => $at->Pages,
                                    'metafield_isbn13' => self::isbn10Toisbn13($at->ASIN),
                                    'metafield_isbn10' => $at->ASIN,
                                    'collections' => $at->ClassificationRanks != '[]' ? $at->ClassificationRanks : $at->Classifications,
                                    'tags' => $at->ClassificationRanks != '[]' ? $at->ClassificationRanks : $at->Classifications,
                                    'vendor' => $vendor,
                                    'status' => $at->status,
                                    'products' => [
                                        [
                                            'id' => $at->id,
                                            'store' => $at->store,
                                            'asin' => $at->ASIN,
                                            'itemCondition' => $at->ItemCondition,
                                            'sellerSku' => $at->SellerSku,
                                            'price' => $at->AmazonSellerInventoryPrice,
                                            'qty' => $at->CurrentQty,
                                            'status' => $at->status
                                        ]
                                    ]
                                ]);
                            }
                        } else {
                            $classification = $at->Classifications != '[]' ? json_decode($at->Classifications)[0]->displayName : 'gid://shopify/ProductTaxonomyNode/4134';
                            array_push($arr_amazon_products, [
                                'title' => $at->Title,
                                'description' => $at->description . ', ISBN13: ' . self::isbn10Toisbn13($at->ASIN) . ' ISBN10: ' . $at->ASIN . ' Material Type: ' . $at->Binding,
                                'images' => $at->Images,
                                'category' => $at->ClassificationRanks != '[]' ? json_decode($at->ClassificationRanks)[0]->title : $classification,
                                'price' => number_format($at->AmazonSellerInventoryPrice - ($at->AmazonSellerInventoryPrice * (15/100)), 2, '.', ''),
                                'seller_sku' => $at->SellerSku,
                                'barcode' => $at->ASIN,
                                'qty' => $at->status == 'Deleted' ? 0 : $at->CurrentQty,
                                'metafield_description' => ', ISBN13: ' . self::isbn10Toisbn13($at->ASIN) . ' ISBN10: ' . $at->ASIN . ' Material Type: ' . $at->Binding,
                                'metafield_title' => $at->Title,
                                'metafield_edition' => null,
                                'metafield_material_type' => $at->Binding,
                                'metafield_format' => $at->Format,
                                'metafield_condition' => $at->ItemCondition,
                                'metafield_publisher' => $at->Authors,
                                'metafield_publication_date' => $at->PublicationDate,
                                'metafield_languange' => $at->Languages,
                                'metafield_print_length' => $at->Pages,
                                'metafield_isbn13' => self::isbn10Toisbn13($at->ASIN),
                                'metafield_isbn10' => $at->ASIN,
                                'collections' => $at->ClassificationRanks != '[]' ? $at->ClassificationRanks : $at->Classifications,
                                'tags' => $at->ClassificationRanks != '[]' ? $at->ClassificationRanks : $at->Classifications,
                                'vendor' => $vendor,
                                'status' => $at->status,                                
                                'products' => [
                                    [
                                        'id' => $at->id,
                                        'store' => $at->store,
                                        'asin' => $at->ASIN,
                                        'itemCondition' => $at->ItemCondition,
                                        'sellerSku' => $at->SellerSku,
                                        'price' => $at->AmazonSellerInventoryPrice,
                                        'qty' => $at->CurrentQty,
                                        'status' => $at->status
                                    ]
                                ]
                            ]);
                        }
                    }
                    

                    $cleanedArray = array_map(function ($aap) {
                        // unset($item['products']);
                        return [
                            'asin' => $aap['barcode'] ?? null,
                            'title' => $aap['title'] ?? null,
                            'sku' => $aap['seller_sku'] ?? null,
                            'condition' => $aap['metafield_condition'] ?? null,
                            'quantity' => $aap['qty'] ?? 0,                            
                            'status' => $aap['status'] ?? 0,                            
                            'created_at' => now(),
                            'updated_at' => now(),
                        ];
                    }, $arr_amazon_products);
                    DB::table('combine_amazon_table')->insert($cleanedArray);
                });

                return [
                    'message' => 'Successfully convert to shopify table',
                    'count' => $convert_count,
                ];
            // } else {
            //     // return response()->json(['message' => 'Data not found.', 'count' => 0]);
            //     return [
            //         'message' => 'Data not found',
            //         'count' => 0
            //     ];
            // }
        } catch (\Exception $e) {
            //throw $th;
            Log::error("Convert Amazon To Shopify Error: " . $e->getMessage());
            // return response()->json(['message' => $e->getMessage() . ' Line: ' . $e->getLine() . ' Row:' . $row . ' ASIN: ' . $asin]);
            return [
                'message' => $e->getMessage() . ' Line: ' . $e->getLine() . ' Row:' . $row . ' ASIN: ' . $asin,
                'count' => 0
            ];
        }
    }

    public function updateAmazonTable()
    {
        $amazon_seller_inventories_count = DB::table('amazon_seller_inventories')->orderBy('asin')->count();
        if ($this->DEBUG_MODE) Log::info("Start with " . $amazon_seller_inventories_count . " data");
        if ($this->DEBUG_MODE) Log::info("Start at " . date('Y-m-d H:i:s'));


        Cache::forget('updateAmazonTable');
        if (!Cache::has('updateAmazonTable')) {
            Cache::put('updateAmazonTable', [
                'completed' => 0,
                'total' => $amazon_seller_inventories_count,
            ], now()->addMinutes(30));
        }
        if ($this->DEBUG_MODE) Log::info(json_encode(Cache::get('updateAmazonTable')));
        $jobs = [];
        $batchSize = 100; // 20 request per batch
        $delayStart = now(); // Mulai delay
        DB::table('job_batches')->truncate();
        $update_result = $this->UpdateAmazonTableSameAsinSku();
        if($update_result == 'success') {
            $amazon_seller_inventories = DB::table('amazon_seller_inventories')->orderBy('asin');
            $amazon_seller_inventories->chunk($batchSize, function ($amazon, $batchIndex) use ($delayStart) {
                // $delay = $delayStart->addMinutes($batchIndex * 2); // Setiap batch ditunda 3 detik            
                $jobs = $amazon->map(fn($value) => (new NewAmazonJob($value)));
    
                Bus::batch($jobs)
                    ->name('Batch Sync Amazon')
                    ->onQueue('sync-amazon') // ⬅️ Ini yang penting!
                    ->then(function () {
                        // Cache::forget('updateAmazonTable');
                        // Cache::forget('requestInventoryReport');
                        // ConvertAmazonToShopifyJob::dispatch('CheapBookDepot');
                        // $this->convertAmazonToShopify('CheapBookDepot');
                        // if ($this->DEBUG_MODE) Log::info("All jobs finished, running convert amazon to shopify.");
                    })->dispatch();
            });
        }


        // Bus::batch($jobs)
        // ->then(function () {
        //     ConvertAmazonToShopifyJob::dispatch('CheapBookDepot');
        //     if ($this->DEBUG_MODE) Log::info("All jobs finished, running convert amazon to shopify.");
        // })
        // ->catch(function () {
        //     Log::error("Internal Server Error batch job.");
        // })
        // ->dispatch();

        // DB::table('ubdtx_temp')->orderBy('asin')->limit(10)->chunk($batchSize, function ($temps, $batchIndex) use ($delayStart) {
        //     $delay = $delayStart->addSecond(1); // Setiap batch ditunda 3 detik
        //     $temps->map(fn($temp) => 
        //         NewAmazonJob::dispatch($temp)->delay($delay)
        //     );
        // });

        return response()->json(['message' => 'Data is being processed in a queue. TEST']);
    }

    public function updateAmazonTest()
    {
        // Find records in amazon_seller_inventories that don't exist in amazon_table
        $missingInventories = DB::table('amazon_seller_inventories as asi')
            ->leftJoin('amazon_table as at', function ($join) {
                $join->on('asi.asin', '=', 'at.ASIN')
                    ->on('asi.seller_sku', '=', 'at.SellerSku');
            })
            ->whereNull('at.id')
            ->select([
                'asi.asin as ASIN',
                'asi.seller_sku as SellerSku',
                'asi.listing_id as ListingId',
                'asi.price',
                'asi.quantity as CurrentQty',
                'asi.item_condition as ItemCondition',
                'asi.status',
                'asi.seller_id as store',
            ])
            ->get();
        Log::info("Missing inventory count: " . count($missingInventories));

        Log::info("Missing inventories: " . json_encode(array_slice($missingInventories->toArray(), 0, 10)));

        return response()->json(['message' => 'updateAmazonTest finished']);
    }

    public function updateAmazonTableNew() //PALIGU
    {
        $uniqid = uniqid();
        Log::info("updateAmazonTableNew started at " . date('Y-m-d H:i:s') . " | Unique ID: " . $uniqid);
        try {
            $amazon_seller_inventories_count = DB::table('amazon_seller_inventories')->orderBy('asin')->count();
            if ($this->DEBUG_MODE) Log::info("Start with " . $amazon_seller_inventories_count . " data");
            if ($this->DEBUG_MODE) Log::info("Start at " . date('Y-m-d H:i:s'));

            //First - Same Asin & Sku Exists but price or quantity different (Amazon Seller Inventories to Amazon Table Update)
            $this->IsCompletedSameAsinSku = false;
            $response = $this->UpdateAmazonTableSameAsinSku();
            if ($response->getStatusCode() !== 200) {
                Log::error("Error processing UpdateAmazonTableSameAsinSku: " . $response->getContent());
                return response()->json(['error' => 'Error processing UpdateAmazonTableSameAsinSku'], 500);
            }
            if ($this->DEBUG_MODE) Log::info("updateAmazonTable - UpdateAmazonTableSameAsinSku Part done");

            // Wait for the UpdateAmazonTableSameAsinSku to be true before starting UpdateAmazonTableSameAsinSkuNoDescription. Max Wait time should be 30 minutes
            $maxWaitTime = 30 * 60; // 30 minutes in seconds
            $waitTime = 0;
            while (!$this->IsCompletedSameAsinSku && $waitTime < $maxWaitTime) {
                sleep(5); // Wait for 5 seconds before checking again
                $waitTime += 5;
                if ($this->DEBUG_MODE) Log::info("Waiting for UpdateAmazonTableSameAsinSku to complete. Waited: " . $waitTime  . " seconds");
            }
            if (!$this->IsCompletedSameAsinSku) {
                Log::error("UpdateAmazonTableSameAsinSku did not complete within the expected time.");
                return response()->json(['error' => 'UpdateAmazonTableSameAsinSku did not complete within the expected time.'], 500);
            }
            if ($this->DEBUG_MODE) Log::info("\n\n");
            //First Part Finished

            //Second - Same Asin & Sku Exists but No Description on Amazon Table (Keepa API)
            $this->IsCompletedSameAsinSkuNoDescription = false;
            $response = $this->UpdateAmazonTableSameAsinSkuNoDescription();
            if ($response->getStatusCode() !== 200) {
                Log::error("Error processing UpdateAmazonTableSameAsinSkuNoDescription: " . $response->getContent());
                return response()->json(['error' => 'Error processing UpdateAmazonTableSameAsinSkuNoDescription'], 500);
            }
            if ($this->DEBUG_MODE) Log::info("updateAmazonTable - UpdateAmazonTableSameAsinSkuNoDescription Part done");

            $waitTime = 0;
            while (!$this->IsCompletedSameAsinSkuNoDescription && $waitTime < $maxWaitTime) {
                sleep(5); // Wait for 5 seconds before checking again
                $waitTime += 5;
                if ($this->DEBUG_MODE) Log::info("Waiting for UpdateAmazonTableSameAsinSkuNoDescription to complete. Waited: " . $waitTime  . " seconds");
            }
            if (!$this->IsCompletedSameAsinSkuNoDescription) {
                Log::error("UpdateAmazonTableSameAsinSkuNoDescription did not complete within the expected time.");
                return response()->json(['error' => 'UpdateAmazonTableSameAsinSkuNoDescription did not complete within the expected time.'], 500);
            }
            if ($this->DEBUG_MODE) Log::info("\n\n");
            //Second Part Finished


            //Third - Same Asin and Seller Sku Does NOT Exists (Amazon API & Keepa API)
            $response = $this->UpdateAmazonTableSameAsinAndSkuDoesNotExists();
            if ($response->getStatusCode() !== 200) {
                Log::error("Error processing UpdateAmazonTableSameAsinAndSkuDoesNotExists: " . $response->getContent());
                return response()->json(['error' => 'Error processing UpdateAmazonTableSameAsinAndSkuDoesNotExists'], 500);
            }
            if ($this->DEBUG_MODE) Log::info("updateAmazonTable - UpdateAmazonTableSameAsinAndSkuDoesNotExists Part done");
            if ($this->DEBUG_MODE) Log::info("\n\n");
            //Third Part Finished

            return response()->json(['message' => 'updateAmazonTableNew Completed'], 200);
        } catch (\Exception $e) {
            Log::error("Error in updateAmazonTableNew: " . $e->getMessage() . " at Line: " . $e->getLine());
            return response()->json(['error' => 'Error in updateAmazonTableNew: ' . $e->getMessage()], 500);
        }
    }

    public function UpdateAmazonTableSameAsinSku()
    {
        $uniqid = uniqid();
        $startTime = microtime(true);
        if ($this->DEBUG_MODE) Log::info("UpdateAmazonTableSameAsinSku started at " . date('Y-m-d H:i:s') . " | Unique ID: " . $uniqid);
        try {

            // if we want to see how many records to be updated
            $matchingCount = DB::table('amazon_table AS atb')
                ->join('amazon_seller_inventories AS asi', function ($join) {
                    $join->on('atb.ASIN', '=', 'asi.asin')
                        ->on('atb.SellerSku', '=', 'asi.seller_sku');
                })
                ->whereRaw('
            (atb.CurrentQty IS NOT NULL AND asi.quantity IS NOT NULL AND CAST(atb.CurrentQty AS SIGNED) != CAST(asi.quantity AS SIGNED))
            OR (atb.AmazonSellerInventoryPrice IS NOT NULL AND asi.price IS NOT NULL AND CAST(atb.AmazonSellerInventoryPrice AS DECIMAL(10,2)) != CAST(asi.price AS DECIMAL(10,2)))
            ')->count();
            if ($this->DEBUG_MODE) Log::info("Number of records to be updated: " . $matchingCount);

            if ($matchingCount > 0) {
                $batchSize = 1000;
                do {
                    $updatedRows = DB::update("
                        UPDATE amazon_table atb
                        INNER JOIN amazon_seller_inventories asi 
                            ON atb.ASIN = asi.asin 
                            AND atb.SellerSku = asi.seller_sku
                        SET atb.CurrentQty = asi.quantity,
                            atb.AmazonSellerInventoryPrice = asi.price,
                            atb.Price = CONCAT(asi.price, ' USD')
                        WHERE 
                            ((atb.CurrentQty IS NOT NULL AND asi.quantity IS NOT NULL AND CAST(atb.CurrentQty AS SIGNED) != CAST(asi.quantity AS SIGNED))
                            OR (atb.AmazonSellerInventoryPrice IS NOT NULL AND asi.price IS NOT NULL AND CAST(atb.AmazonSellerInventoryPrice AS DECIMAL(10,2)) != CAST(asi.price AS DECIMAL(10,2))))
                        LIMIT $batchSize
                    ");
                    if ($this->DEBUG_MODE) Log::info("Updated rows in batch: " . $updatedRows);
                } while ($updatedRows > 0);
            } else {
                Log::info("UpdateAmazonTableSameAsinSku - No records to be updated.");
            }

            $endTime = microtime(true);
            $executionTime = ($endTime - $startTime);
            if ($this->DEBUG_MODE) Log::info("UpdateAmazonTableSameAsinSku Successfully finished. Execution time: " . $executionTime . " seconds");
            $this->IsCompletedSameAsinSku = true;
            // return response()->json(['success' => "UpdateAmazonTableSameAsinSku Successfully finished"], 200);
            return 'success';
        } catch (\Exception $e) {
            Log::error("Error in UpdateAmazonTable Part1: " . $e->getMessage() . " at Line: " . $e->getLine());
            return 'error';
            // return response()->json(['error' => 'Error in UpdateAmazonTable Part1: ' . $e->getMessage()], 500);
        }
    }

    public function UpdateAmazonTableSameAsinSkuNoDescription()
    {
        $uniqid = uniqid();
        $startTime = microtime(true);
        if ($this->DEBUG_MODE) Log::info("UpdateAmazonTableSameAsinSkuNoDescription started at " . date('Y-m-d H:i:s') . " | Unique ID: " . $uniqid);
        try {

            $recordsToProcess = DB::table('amazon_table AS atb')
                ->join('amazon_seller_inventories AS asi', function ($join) {
                    $join->on('atb.ASIN', '=', 'asi.asin')
                        ->on('atb.SellerSku', '=', 'asi.seller_sku');
                })
                ->where(function ($query) {
                    $query->whereNull('atb.description')
                        ->orWhere('atb.description', '=', '');
                })
                ->where(function ($query) {
                    $query->where('atb.keepa_description_check', 1)
                        ->orWhereNull('atb.keepa_description_check');
                })
                ->select('atb.id', 'atb.ASIN', 'atb.SellerSku')
                ->get()
                ->toArray();
            Log::info("UpdateAmazonTableSameAsinSkuNoDescription Records to process: " . count($recordsToProcess));

            foreach ($recordsToProcess as $record) {
                $response = $this->callApiKeepa($record->ASIN, $record->SellerSku);
                if ($response->getStatusCode() !== 200) {
                    Log::error("Error processing record: " . json_encode($record));
                    continue;
                }
                sleep(2);
            }

            $endTime = microtime(true);
            $executionTime = ($endTime - $startTime);
            if ($this->DEBUG_MODE) Log::info("UpdateAmazonTableSameAsinSkuNoDescription Successfully finished. Execution time: " . $executionTime . " seconds Unique ID: " . $uniqid);
            $this->IsCompletedSameAsinSkuNoDescription = true;
            return response()->json(['success' => "UpdateAmazonTableSameAsinSkuNoDescription Successfully finished"], 200);
        } catch (\Exception $e) {
            Log::error("Error in UpdateAmazonTableSameAsinSkuNoDescription: " . $e->getMessage() . " at Line: " . $e->getLine());
            return response()->json(['error' => 'Error in UpdateAmazonTableSameAsinSkuNoDescription: ' . $e->getMessage()], 500);
        }
    }

    public function UpdateAmazonTableSameAsinAndSkuDoesNotExists()
    {
        $uniqid = uniqid();
        if ($this->DEBUG_MODE) Log::info("UpdateAmazonTableSameAsinButNoSku started at " . date('Y-m-d H:i:s') . " | Unique ID: " . $uniqid);

        try {
            $recordsToProcess = DB::table('amazon_seller_inventories AS asi')
                ->whereNotExists(function ($query) {
                    $query->select(DB::raw(1))
                        ->from('amazon_table AS atb')
                        ->whereColumn('asi.asin', '=', 'atb.ASIN')
                        ->whereColumn('asi.seller_sku', '=', 'atb.SellerSku');
                })
                ->select('asi.id', 'asi.seller_id', 'asi.listing_id', 'asi.seller_sku', 'asi.price', 'asi.quantity', 'asi.item_condition', 'asi.asin')
                ->get()
                ->toArray();

            Log::info("Records not found in amazon_table: " . count($recordsToProcess));

            //Log::info(json_encode(array_slice($recordsToProcess, 0, 10)));

            foreach ($recordsToProcess as $record) {
                $response = $this->callApi($record);
                if ($response->getStatusCode() !== 200) {
                    Log::error("Error processing record: " . json_encode($record));
                    continue;
                }
                sleep(1);
            }

            foreach ($recordsToProcess as $record) {
                $response = $this->callApiKeepa($record->asin, $record->seller_sku);
                if ($response->getStatusCode() !== 200) {
                    Log::error("Error processing record: " . json_encode($record));
                    continue;
                }
                sleep(2);
            }

            Log::info("UpdateAmazonTableSameAsinButNoSku - Finished processing records. Unique ID: " . $uniqid);
            return response()->json(['success' => "UpdateAmazonTableSameAsinButNoSku Successfully finished"], 200);
        } catch (\Throwable $th) {
            Log::error("Error in UpdateAmazonTableSameAsinButNoSku: " . $th->getMessage() . " at Line: " . $th->getLine());
            return response()->json(['error' => 'Error in UpdateAmazonTableSameAsinButNoSku: ' . $th->getMessage()], 500);
        }
    }

    public function getApiKeepa($asin)
    {
        try {
            //code...
            $keepaService = new KeepaService();
            $keepaProduct = $keepaService->getProduct($asin);
            if (array_key_exists('products', $keepaProduct)) {
                $product = $keepaProduct['products'][0];

                return response()->json($product);
            }
        } catch (\Exception $e) {
            Log::error("Error in callApiKeepa: " . $e->getMessage() . " at Line: " . $e->getLine());
            return response()->json(['error' => 'Error in callApiKeepa: ' . $e->getMessage()], 500);
        }
    }

    public function getGraphImageKeepa($asin)
    {
        try {

            $keepaService = new KeepaService();
            $graphImageData = $keepaService->getGraphImage($asin);
            return $graphImageData;

            // return response()->json($graphImageData->body(), 200, [
            //     'Content-Type' => 'image/png',
            //     'Content-Disposition' => 'inline; filename="keepa_graph.png"',
            // ]);
            
        } catch (\Exception $e) {
            Log::error("Error in callApiKeepa: " . $e->getMessage() . " at Line: " . $e->getLine());
            return response()->json(['error' => 'Error in callApiKeepa: ' . $e->getMessage()], 500);
        }
    }

    private function callApiKeepa($asin, $sku)
    {
        try {
            $keepaService = new KeepaService();
            $keepaProduct = $keepaService->getProduct($asin);
            if (array_key_exists('products', $keepaProduct)) {
                $product = $keepaProduct['products'][0];

                $description = $product['description'] ?? null;
                if ($description) {
                    AmazonTable::where('ASIN', $asin)
                        ->where('SellerSku', $sku)
                        ->update([
                            'description' => $description
                        ]);
                    if ($this->DEBUG_MODE) Log::info($asin . " Description updated from keepa.");
                } else {
                    if ($this->DEBUG_MODE) Log::info($asin . " Description is null on keepa.");
                    AmazonTable::where('ASIN', $asin)
                        ->where('SellerSku', $sku)
                        ->update(['keepa_description_check' => 0]);
                    if ($this->DEBUG_MODE) Log::info($asin . " - " . $sku . " keepa_description_check set to 0.");
                }
            }
            return response()->json(['success' => $asin . " - " . $sku . " Description updated from keepa"], 200);
        } catch (\Exception $e) {
            Log::error("Error in callApiKeepa: " . $e->getMessage() . " at Line: " . $e->getLine());
            return response()->json(['error' => 'Error in callApiKeepa: ' . $e->getMessage()], 500);
        }
    }

    private function callApi($data)
    {
        //if ($this->DEBUG_MODE) Log::info("callApi started at " . date('Y-m-d H:i:s'));
        //if ($this->DEBUG_MODE) Log::info("callApi ASIN: " . $data->asin . " seller_id: " . $data->seller_id);
        try {
            $startTime = microtime(true);
            $results = $this->getProductDetails($data->asin, false, $data->seller_id);
            $itemCondition = [
                '-',
                'USED_LIKE_NEW',
                'USED_VERY_GOOD',
                'USED_GOOD',
                'USED_ACCEPTABLE',
                'COLLECTIBLE_LIKE_NEW*',
                'COLLECTIBLE_VERY_GOOD*',
                'COLLECTIBLE_GOOD*',
                'COLLECTIBLE_ACCEPTABLE*',
                'NOT_USED',
                'REFURBISHED',
                'NEW',
            ];

            $formattedProduct = [
                'store' => $data->seller_id,
                'ASIN' => $results['ASIN'],
                "Title" => $results['Title'],
                "Subjects" => $results['Subjects'],
                "Binding" => $results['Binding'],
                "Languages" => $results['Languages'],
                "Format" => $results['Format'],
                "ItemTypeKeyword" => $results['ItemTypeKeyword'],
                "Composer" => $results['Composer'],
                "PublicationDate" => $results['PublicationDate'],
                "Pages" => $results['Pages'],
                "BulletPoints" => $results['BulletPoints'],
                "Dimensions" => $results['Dimensions'],
                "Brand" => $results['Brand'],
                "TargetAudience" => $results['TargetAudience'],
                "Manufacturer" => $results['Manufacturer'],
                "Price" => $results['Price'],
                "Authors" => $results['Authors'],
                "Genre" => $results['Genre'],
                "Identifiers" => $results['Identifiers'],
                "Images" => $results['Images'],
                "ProductTypes" => $results['ProductTypes'],
                "Classifications" => $results['Classifications'],
                "ClassificationRanks" => $results['ClassificationRanks'],
                "DisplayGroupRanks" => $results['DisplayGroupRanks'],
                "ItemCondition" => $itemCondition[$data->item_condition],
                "CurrentQty" => $data->quantity,
                "AmazonSellerInventoryPrice" => $data->price,
                "SellerSku" => $data->seller_sku,
                "ListingId" => $data->listing_id,
            ];

            $formattedProduct = array_map(function ($value) {
                return is_array($value) ? json_encode($value) : $value;
            }, $formattedProduct);

            AmazonTable::create($formattedProduct);
            $endTime = microtime(true);
            $executionTime = ($endTime - $startTime);

            if ($this->DEBUG_MODE) Log::info($data->asin . " - " . $data->seller_sku . " Inserted to amazon_table in " . $executionTime . " seconds");
            return response()->json(['success' => $data->asin . " - " . $data->seller_sku . " Inserted to amazon_table"], 200);
        } catch (\Exception $e) {
            Log::error("Error in callApi: " . $e->getMessage() . " at Line: " . $e->getLine());
            return response()->json(['error' => 'Failed to insert product into amazon_table: ' . $e->getMessage()], 500);
        }
    }

    public function salesAndTrafficByDate($sellerId, $startDate, $endDate, $aggregateBy)
    {
        if ($this->DEBUG_MODE) Log::info("salesAndTrafficByDate Seller ID: " . $sellerId);

        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        $query = "
            query MyQuery {
                analytics_salesAndTraffic_2023_11_15 {
                    salesAndTrafficByDate(
                        aggregateBy: $aggregateBy,  # Remove quotes
                        endDate: \"$endDate\",
                        marketplaceIds: [\"ATVPDKIKX0DER\"],
                        startDate: \"$startDate\"
                    ) {
                        sales {
                            averageSalesPerOrderItem {
                            amount
                            }
                            averageSellingPrice {
                            amount
                            }
                            claimsAmount {
                            amount
                            }
                            orderedProductSales {
                            amount
                            }
                            ordersShipped
                            refundRate
                            totalOrderItems
                        }
                        traffic {
                            browserPageViews
                            buyBoxPercentage
                            feedbackReceived
                            mobileAppPageViews
                            negativeFeedbackReceived
                        }
                    }
                }
            }";


        try {
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
                'Content-Type' => 'application/json',
            ])->POST("https://sellingpartnerapi-na.amazon.com/dataKiosk/2023-11-15/queries", [
                "query" => $query
            ]);
            $data = json_decode($response->body(), true);
            return $this->getSalesAndTrafficQuery($sellerId, $data['queryId']);
        } catch (\Throwable $th) {
            Log::error("Error requesting salesAndTrafficByDate: " . $th->getMessage());
            return response()->json(['error' => 'Error requesting salesAndTrafficByDate']);
        }
    }

    function getSalesAndTrafficQuery($sellerId, $queryId)
    {
        if ($this->DEBUG_MODE) Log::info("getSalesAndTrafficQuery queryId: " . $queryId);

        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
                'Content-Type' => 'application/json',
            ])->GET("https://sellingpartnerapi-na.amazon.com/dataKiosk/2023-11-15/queries/$queryId");
            $data = json_decode($response->body(), true);

            if (!isset($data['dataDocumentId'])) {
                Log::info("getSalesAndTrafficQuery data is not ready yet. Waiting 30 seconds...");
                sleep(30);
                return $this->getSalesAndTrafficQuery($sellerId, $queryId);
            } else {
                //if dataDocumentId is available and processingStatus is "DONE" return dataDocumentId
                if ($data['processingStatus'] == 'DONE') {
                    return $this->getSalesAndTrafficDocument($sellerId, $data['dataDocumentId']);
                } else {
                    //if processingStatus is not "DONE" wait 30 seconds and try again
                    Log::info("getSalesAndTrafficQuery data is not ready yet. Waiting 30 seconds...");
                    sleep(30);
                    return $this->getSalesAndTrafficQuery($sellerId, $queryId);
                }
            }

            return response()->json($data);
        } catch (\Throwable $th) {
            Log::error("Error requesting getSalesAndTrafficQuery: " . $th->getMessage());
            return response()->json(['error' => 'Error requesting getSalesAndTrafficQuery']);
        }
    }

    function getSalesAndTrafficDocument($sellerId, $documentId)
    {
        if ($this->DEBUG_MODE) Log::info("getSalesAndTrafficDocument documentId: " . $documentId);

        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
                'Content-Type' => 'application/json',
            ])->GET("https://sellingpartnerapi-na.amazon.com/dataKiosk/2023-11-15/documents/$documentId");
            $data = json_decode($response->body(), true);
            return $this->downloadSalesAndTrafficDocument($data['documentUrl']);
        } catch (\Throwable $th) {
            Log::error("Error requesting getSalesAndTrafficDocument: " . $th->getMessage());
            return response()->json(['error' => 'Error requesting getSalesAndTrafficDocument']);
        }
    }

    function downloadSalesAndTrafficDocument($documentUrl)
    {
        try {
            $response = Http::get($documentUrl);
            $data = json_decode($response->body(), true);
            return response()->json($data);
        } catch (\Throwable $th) {
            Log::error("Error requesting downloadSalesAndTrafficDocument: " . $th->getMessage());
            return response()->json(['error' => 'Error requesting downloadSalesAndTrafficDocument']);
        }
    }

    public function checkSalesAndTrafficReport($sellerId, $startDate, $endDate, $aggregateBy)
    {
        $check_data = DB::table('sales_and_traffic_report')->where('seller_id', $sellerId)->first();
        if ($check_data) {
            return response()->json([
                'data' => $check_data,
                'coming_from' => 'database'
            ]);
        } else {
            $sales_traffic = $this->salesAndTrafficByDate($sellerId, $startDate, $endDate, $aggregateBy);
            if (array_key_exists('error', $sales_traffic->original)) {
            } else {
                DB::table('sales_and_traffic_report')->where('seller_id', $sellerId)->delete();

                DB::table('sales_and_traffic_report')->insert([
                    'seller_id' => $sellerId,
                    'ordered_product_sales' => $sales_traffic->original['sales']['orderedProductSales']['amount'],
                    'orders_shipped' => $sales_traffic->original['sales']['ordersShipped'],
                    'average_sales_per_order' => $sales_traffic->original['sales']['averageSalesPerOrderItem']['amount'],
                    'average_selling_price' => $sales_traffic->original['sales']['averageSellingPrice']['amount'],
                    'refund_rate' => $sales_traffic->original['sales']['refundRate'],
                    'browser_page_views' => $sales_traffic->original['traffic']['browserPageViews'],
                    'mobile_app_page_views' => $sales_traffic->original['traffic']['mobileAppPageViews'],
                    'buy_box_percentage' => $sales_traffic->original['traffic']['buyBoxPercentage'],
                    'feedback_received' => $sales_traffic->original['traffic']['feedbackReceived'],
                    'negative_feedback' => $sales_traffic->original['traffic']['negativeFeedbackReceived'],
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ]);
            }

            return response()->json([
                'data' => $sales_traffic->original,
                'coming_from' => 'API'
            ]);
        }
    }

    public function updateSellerListingQuantity(Request $request, $sellerId, $sku, $quantity)
    {
        // $check_credits = $this->check_or_create_ai_credit_transactions($request->all(), 'api', 'Update Listing Quantity');

        // if($check_credits != 'continue') {
        //     return response()->json(['error' => $check_credits]);
        // }

        if ($this->DEBUG_MODE) Log::info("updateSellerListingQuantity Seller ID: " . $sellerId);
        if ($this->DEBUG_MODE) Log::info("updateSellerListingQuantity Sku: " . $sku);

        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {
            //code...
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->patch("https://sellingpartnerapi-na.amazon.com/listings/2021-08-01/items/" . $sellerId . "/" . $sku . "?marketplaceIds=ATVPDKIKX0DER", [
                "productType" => "PRODUCT",
                "patches" => [
                    [
                        "op" => "replace",
                        "path" => "/attributes/fulfillment_availability",
                        "value" => [
                            [
                                "fulfillment_channel_code" => "DEFAULT",
                                "quantity" => (int) $quantity,
                                "marketplace_id" => "ATVPDKIKX0DER"
                            ]
                        ]
                    ]
                ]
            ]);
            $data = json_decode($response->body(), true);

            if ($this->DEBUG_MODE) Log::info("response updateSellerListingQuantity: " . $response->body());

            // if ($data['status'] == 'ACCEPTED') {
            //     AmazonTable::where('SellerSku', $sku)->update([
            //         'CurrentQty' => $quantity
            //     ]);
            // }

            return response()->json($data);
        } catch (\Throwable $th) {
            Log::error("Error requesting seller performance report: " . $th->getMessage());
            return response()->json(['error' => 'Failed to update seller listing quantity']);
        }
    }

    public function updateSellerListingPriceTest($sellerId, $sku, $price)
    {
        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }
        try {
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->patch("https://sellingpartnerapi-na.amazon.com/listings/2021-08-01/items/" . $sellerId . "/" . $sku . "?marketplaceIds=ATVPDKIKX0DER&issueLocale=en_US", [
                "productType" => "ABIS_BOOK",
                'patches' => [[
                    'op' => 'replace',
                    'path' => '/attributes/purchasable_offer',
                    'value' => [[
                        'marketplace_id' => 'ATVPDKIKX0DER',
                        'currency' => 'USD',
                        'our_price' => [[
                            'schedule' => [[
                                'value_with_tax' => 12.50
                            ]]
                        ]]
                    ]]
                ]]
            ]);

            $data = json_decode($response->body(), true);
            if ($this->DEBUG_MODE) Log::info("response updateSellerListingPriceTest: " . $response->body());

            return response()->json($data);
        } catch (\Throwable $th) {
            Log::error("Error requesting updateSellerListingPriceTest: " . $th->getMessage());
            return response()->json(['error' => 'Failed to update seller listing price']);
        }
    }

    public function updateSellerListingPrice(Request $request, $sellerId, $sku, $price)
    {
        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        $formattedPrice = (float) number_format((float) $price, 2, '.', '');

        if ($this->DEBUG_MODE) Log::info("updateSellerListingPrice Seller ID: " . $sellerId);
        if ($this->DEBUG_MODE) Log::info("updateSellerListingPrice Sku: " . $sku);
        if ($this->DEBUG_MODE) Log::info("updateSellerListingPrice Price: " . $formattedPrice);
        try {
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->patch("https://sellingpartnerapi-na.amazon.com/listings/2021-08-01/items/" . $sellerId . "/" . $sku . "?marketplaceIds=ATVPDKIKX0DER&issueLocale=en_US", [
                "productType" => "ABIS_BOOK",
                'patches' => [[
                    'op' => 'replace',
                    'path' => '/attributes/purchasable_offer',
                    'value' => [[
                        'marketplace_id' => 'ATVPDKIKX0DER',
                        'currency' => 'USD',
                        'our_price' => [[
                            'schedule' => [[
                                'value_with_tax' => $formattedPrice
                            ]]
                        ]]
                    ]]
                ]]
            ]);

            if ($response->successful()) {
                if ($this->DEBUG_MODE) Log::info("response updateSellerListingPrice: " . $response->body());
                // AmazonTable::where('SellerSku', $sku)->update([
                //     'Price' => number_format((float) $price,2,'.',','). 'USD',
                //     'AmazonSellerInventoryPrice' => number_format((float) $price,2,'.',',')
                // ]);
                return [
                    'success' => true,
                    'data' => $response->json()
                ];
            }
            //return response()->json($data);
            Log::error('Amazon SP API Error: ' . $response->body());

            return [
                'success' => false,
                'error' => $response->json() ?? $response->body()
            ];
        } catch (\Exception $e) {
            Log::error('Amazon SP API Exception: ' . $e->getMessage());

            return [
                'success' => false,
                'error' => $e->getMessage()
            ];
        }
    }

    // ADRI this is using feed but failed
    /* public function updateSellerListingPrice(Request $request, $sellerId, $sku, $price)
    {
        try {
            //code...  
            $formattedPrice = number_format($price, 2, '.', '');

            $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
            if (!$refreshToken) {
                if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
                return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
            }

            // Load AWS credentials from .env file            

            $spApi = new SellingPartnerApi(
                clientId: env('SP_API_CLIENT_ID'),
                clientSecret: env('SP_API_CLIENT_SECRET'),
                refreshToken: $refreshToken,
                endpoint: Endpoint::NA,
            );

            $connector = $spApi->seller();
            $feedApi = $connector->feedsV20210630();

            $response = $feedApi->createFeedDocument(
                new \SellingPartnerApi\Seller\FeedsV20210630\Dto\CreateFeedDocumentSpecification('text/xml; charset=UTF-8')
            );

            $data = json_decode($response, true);

            if (!isset($data['feedDocumentId'])) {
                if ($this->DEBUG_MODE) Log::error('Failed to create feed document. Response: ' . json_encode($data));
                return response()->json(['error' => 'Failed to create feed document'], 500);
            }

            $feedDocumentUrl = $data['url'];
            $feedDocumentId = $data['feedDocumentId'];
            if ($this->DEBUG_MODE) Log::info("Requested feed document with ID: " . $feedDocumentId);
            if ($this->DEBUG_MODE) Log::info("Requested feed document url: " . $feedDocumentUrl);

            $skuConvert = htmlspecialchars($sku, ENT_QUOTES, 'UTF-8');
            $formattedPriceConvert = htmlspecialchars($formattedPrice, ENT_QUOTES, 'UTF-8');
            $sellerIdConvert = htmlspecialchars($sellerId, ENT_QUOTES, 'UTF-8');
            $xml = <<<XML
            <?xml version="1.0" encoding="utf-8"?>
            <AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                            xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">
                <Header>
                    <DocumentVersion>1.01</DocumentVersion>
                    <MerchantIdentifier>{$sellerIdConvert}</MerchantIdentifier>
                </Header>
                <MessageType>Price</MessageType>
                <Message>
                    <MessageID>1</MessageID>
                    <Price>
                        <SKU>{$skuConvert}</SKU>
                        <StandardPrice currency="USD">{$formattedPriceConvert}</StandardPrice>
                    </Price>
                </Message>
            </AmazonEnvelope>
            XML;

            // ✅ 1. Convert to UTF-8 cleanly (important to avoid Malformed UTF-8 error)
            $cleanXml = mb_convert_encoding($xml, 'UTF-8', 'UTF-8');

            // ✅ 2. GZIP compress
            $gzippedXml = gzencode($cleanXml);
            // dd(mb_detect_encoding($gzippedXml, mb_list_encodings(), true));

            $uploadResponse = Http::withHeaders([
                'Content-Type' => 'application/octet-stream',
            ])->put($feedDocumentUrl, $gzippedXml);

            // Step 3.3: Check upload result
            // if (!$uploadResponse->successful()) {
            //     if ($this->DEBUG_MODE) Log::error('Failed to upload feed document: ' . $uploadResponse->body());
            //     return response()->json(['error' => 'Failed to upload feed document'], 500);
            // }

            if ($this->DEBUG_MODE) Log::info("Uploaded feed document successfully.");

            $createFeedRequest = new CreateFeedSpecification(
                feedType: 'POST_PRODUCT_PRICING_DATA',
                marketplaceIds: [env('AMAZON_MARKETPLACE_ID')],
                inputFeedDocumentId: $feedDocumentId
            );

            $feedResponse = $feedApi->createFeed($createFeedRequest);

            $feedId = $feedResponse->getFeedId();

            if ($this->DEBUG_MODE) Log::info("Created feed with ID: " . $feedId);

            // return response()->json([
            //     'success' => true,
            //     'error' => '',
            //     'feedId' => $feedId
            // ]);

        } catch (\Exception $e) {
            Log::error('Amazon SP API Exception: ' . $e->getMessage());

            return response()->json([
                'success' => false,
                'error' => $e->getMessage()
            ]);
        }
    } */

    public function updateSellerListingCondition(Request $request, $sellerId, $sku, $condition)
    {
        // $check_credits = $this->check_or_create_ai_credit_transactions($request->all(), 'api', 'Update Listing Quantity');

        // if($check_credits != 'continue') {
        //     return response()->json(['error' => $check_credits]);
        // }
        if ($this->DEBUG_MODE) Log::info("updateSellerListingCondition Seller ID: " . $sellerId);

        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {
            //code...
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->patch("https://sellingpartnerapi-na.amazon.com/listings/2021-08-01/items/" . $sellerId . "/" . $sku . "?marketplaceIds=ATVPDKIKX0DER", [
                "productType" => "PRODUCT",
                "patches" => [
                    [
                        "op" => "replace",
                        "path" => "/attributes/condition_type",
                        "value" => [
                            [
                                "value" => $condition,
                                "marketplace_id" => "ATVPDKIKX0DER"
                            ]
                        ]
                    ]
                ]
            ]);
            $data = json_decode($response->body(), true);

            if ($this->DEBUG_MODE) Log::info("response updateSellerListingCondition: " . $response->body());

            // if ($data['status'] == 'ACCEPTED') {
            //     if ($condition == 'new_not_used') {
            //         $condition = 'NOT_USED';
            //     }
            //     if ($condition == 'refurbished_refurbished') {
            //         $condition = 'REFURBISHED';
            //     }
            //     if ($condition == 'new_new') {
            //         $condition = 'NEW';
            //     }
            //     AmazonTable::where('SellerSku', $sku)->update([
            //         'ItemCondition' => strtoupper($condition)
            //     ]);
            // }

            return response()->json($data);
        } catch (\Throwable $th) {
            Log::error("Error requesting seller performance report: " . $th->getMessage());
            return response()->json(['error' => 'Failed to update seller listing condition']);
        }
    }

    public function getProductDetailsNew($sellerId)
    {
        if ($this->DEBUG_MODE) Log::info("getProductDetailsNew Seller ID: " . $sellerId);

        $asins = AmazonTable::where('store', $sellerId)->select('ASIN')->limit(45)->pluck('ASIN')->toArray(); // Will be updated. asins will come with parameters here.
        // Log::info("getProductDetailsNew ASINs count: " . count($asins));
        // Log::info("getProductDetailsNew ASINs: " . implode(',', $asins));
        // Log::info("\n\n");

        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {
            $startTime = microtime(true);
            $chunks = array_chunk($asins, 20);
            $products = [];
            foreach ($chunks as $chunk) {
                //Log::info("Processing chunk: " . implode(',', $chunk));
                $response = Http::withHeaders([
                    'x-amz-access-token' => $accessToken,
                ])->get("https://sellingpartnerapi-na.amazon.com/catalog/2022-04-01/items", [
                    'marketplaceIds' => 'ATVPDKIKX0DER',
                    'identifiers' => implode(',', $chunk),
                    'identifiersType' => 'ASIN',
                    'pageSize' => 20,
                    'includedData' => 'attributes,classifications,dimensions,relationships,identifiers,images,productTypes,salesRanks,summaries'
                ]);
                $data = json_decode($response->body(), true);
                //Log::info("ASINs in data: " . implode(',', array_column($data['items'], 'asin')));
                $products = array_merge($products, $data['items']);

                usleep(15000); // Sleep for 15 milliseconds
            }
            //return response()->json(['success' => 'getProductDetailsNew Completed'], 200);
            $endTime = microtime(true);
            $executionTime = ($endTime - $startTime);
            if ($this->DEBUG_MODE) Log::info("getProductDetailsNew Execution time: " . $executionTime . " seconds");

            return response()->json($products);
        } catch (\Throwable $th) {
            Log::error("Error requesting getProductDetails: " . $th->getMessage());
            return response()->json(['error' => 'Failed to get product details']);
        }
    }

    public function getProductDetailByISBN($isbn, $sellerId, Request $request)
    {
        // $check_credits = $this->check_or_create_ai_credit_transactions($request->all(), 'api', 'Find in amazon');

        // if ($check_credits != 'continue') {
        //     return response()->json(['error' => $check_credits]);
        // }
        if ($this->DEBUG_MODE) Log::info("getProductDetailsByISBN Seller ID: " . $sellerId);

        Log::info("getProductDetailsByISBN ISBN: " . $isbn . " getting access token");
        $accessToken = $this->checkAmazonAccessToken($sellerId);
        Log::info("getProductDetailsByISBN access token: " . $accessToken);

        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->get("https://sellingpartnerapi-na.amazon.com/catalog/2022-04-01/items", [
                'marketplaceIds' => 'ATVPDKIKX0DER',
                'identifiers' => $isbn,
                'identifiersType' => 'ISBN',
                'pageSize' => 20,
                'includedData' => 'attributes,classifications,dimensions,relationships,identifiers,images,productTypes,salesRanks,summaries'
            ]);
            $data = json_decode($response->body(), true);
            return response()->json($data);
        } catch (\Throwable $th) {
            Log::error("Error requesting getProductDetailsByISBN: " . $th->getMessage());
            return response()->json(['error' => 'Failed to get product details by ISBN']);
        }
    }

    public static function getProductDetails($asin, $barcode_scan, $sellerId)
    {

        $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
        if (!$refreshToken) {
            Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
            return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
        }
        $spApi = new SellingPartnerApi(clientId: env('SP_API_CLIENT_ID'), clientSecret: env('SP_API_CLIENT_SECRET'), refreshToken: $refreshToken, endpoint: Endpoint::NA);
        $connector = $spApi->seller();
        $catalogApi = $connector->catalogItemsV20220401();

        if ($barcode_scan && $barcode_scan != 'null') {

            if (strlen($asin) === 13 && in_array(substr($asin, 0, 3), ['978', '979'])) {
                $asin = self::isbn13ToIsbn10($asin);
            }
            //$asin = '0933029225';
            $response = $catalogApi->searchCatalogItems(
                identifiers: [$asin],
                identifiersType: 'ISBN',
                marketplaceIds: ['ATVPDKIKX0DER'],
                includedData: ['attributes,classifications,relationships, identifiers,images,productTypes,salesRanks,summaries']
            );
            $data = json_decode($response, true);
            $asin = $data['items'][0]['asin'] ?? null;
            $item_name = $data['items'][0]['attributes']['item_name'][0]['value'] ?? null;
            if (array_key_exists('subject', $data['items'][0]['attributes'])) {
                $subjects = array_map(fn($subject) => $subject['value'], $data['items'][0]['attributes']['subject'] ?? []);
            }
            $binding = $data['items'][0]['attributes']['binding'][0]['value'] ?? null;
            if (array_key_exists('language', $data['items'][0]['attributes'])) {
                $languages = array_map(fn($lang) => $lang['value'], $data['items'][0]['attributes']['language'] ?? []);
            }
            $format = $data['items'][0]['attributes']['format'][0]['value'] ?? null;
            $item_type_keyword = $data['items'][0]['attributes']['item_type_keyword'][0]['value'] ?? null;
            $composer = $data['items'][0]['attributes']['composer'][0]['value'] ?? null;
            if (array_key_exists('artist', $data['items'][0]['attributes'])) {
                $artist = array_map(fn($artist) => $artist['value'], $data['items'][0]['attributes']['artist'] ?? []);
            }
            $release_date = $data['items'][0]['attributes']['street_date'][0]['value'] ?? null;
            $pages = $data['items'][0]['attributes']['pages'][0]['value'] ?? null;
            if (array_key_exists('bullet_point', $data['items'][0]['attributes'])) {
                $bullet_points = array_map(fn($bullet_point) => $bullet_point['value'], $data['items'][0]['attributes']['bullet_point'] ?? []);
            }
            $dimensions = $data['items'][0]['attributes']['item_dimensions'][0] ?? [];
            $brand = $data['items'][0]['attributes']['brand'][0]['value'] ?? null;
            $target_audience = $data['items'][0]['attributes']['target_audience'][0]['value'] ?? null;
            $manufacturer = $data['items'][0]['attributes']['manufacturer'][0]['value'] ?? null;
            $list_price = $data['items'][0]['attributes']['list_price'][0]['value'] ?? null;
            $currency = $data['items'][0]['attributes']['list_price'][0]['currency'] ?? null;
            if (array_key_exists('author', $data['items'][0]['attributes'])) {
                $authors = array_map(fn($author) => $author['value'], $data['items'][0]['attributes']['author'] ?? []);
            }
            if (array_key_exists('genre', $data['items'][0]['attributes'])) {
                $genres = array_map(fn($genre) => $genre['value'], $data['items'][0]['attributes']['genre'] ?? []);
            }
            $publication_date = $data['items'][0]['attributes']['publication_date'][0]['value'] ?? null;
            $identifiers = $data['items'][0]['identifiers'][0]['identifiers'] ?? [];
            $images = $data['items'][0]['images'][0]['images'] ?? null;
            $productTypes = $data['items'][0]['productTypes'][0]['productType'] ?? [];
            $classifications = $data['items'][0]['classifications'][0]['classifications'] ?? [];
            $classificationRanks = $data['items'][0]['salesRanks'][0]['classificationRanks'] ?? [];
            $displayGroupRanks = $data['items'][0]['salesRanks'][0]['displayGroupRanks'] ?? [];

            $existsInDb = AmazonSellerInventory::where('asin', $asin)->exists();

            $result = [
                'ASIN' => $asin,
                'Title' => $item_name,
                'Subjects' => $subjects,
                'Binding' => $binding,
                'Languages' => $languages,
                'Format' => $format,
                'ItemTypeKeyword' => $item_type_keyword,
                'Composer' => $composer,
                'PublicationDate' => $publication_date,
                'ReleaseDate' => $release_date,
                'Pages' => $pages,
                'BulletPoints' => $bullet_points,
                'Dimensions' => $dimensions,
                'Brand' => $brand,
                'TargetAudience' => $target_audience,
                'Manufacturer' => $manufacturer,
                'Price' => $list_price . ' ' . $currency,
                'Authors' => $authors,
                'Genre' => $genres,
                'Identifiers' => $identifiers,
                'Images' => $images,
                'ProductTypes' => $productTypes,
                'Classifications' => $classifications,
                'ClassificationRanks' => $classificationRanks,
                'DisplayGroupRanks' => $displayGroupRanks,
                'ExistsInDb' => $existsInDb
            ];

            return $result;
        } else {
            try {
                $response = $catalogApi->getCatalogItem(
                    asin: $asin,
                    marketplaceIds: ['ATVPDKIKX0DER'],
                    includedData: ['attributes,classifications,relationships, identifiers,images,productTypes,salesRanks,summaries']
                );

                $data = json_decode($response, true);
                $asin = $data['asin'] ?? null;
                $item_name = $data['attributes']['item_name'][0]['value'] ?? null;
                $subjects = array_map(fn($subject) => $subject['value'], $data['attributes']['subject'] ?? []);
                $binding = $data['attributes']['binding'][0]['value'] ?? null;
                $languages = array_map(fn($lang) => $lang['value'] ?? null, $data['attributes']['language'] ?? []);
                $format = $data['attributes']['format'][0]['value'] ?? null;
                $item_type_keyword = $data['attributes']['item_type_keyword'][0]['value'] ?? null;
                $composer = $data['attributes']['composer'][0]['value'] ?? null;
                $artist = array_map(fn($artist) => $artist['value'], $data['attributes']['artist'] ?? []);
                $release_date = $data['attributes']['street_date'][0]['value'] ?? null;
                $pages = $data['attributes']['pages'][0]['value'] ?? null;
                $bullet_points = array_map(fn($bullet_point) => $bullet_point['value'], $data['attributes']['bullet_point'] ?? []);
                $dimensions = $data['attributes']['item_dimensions'][0] ?? [];
                $brand = $data['attributes']['brand'][0]['value'] ?? null;
                $target_audience = $data['attributes']['target_audience'][0]['value'] ?? null;
                $manufacturer = $data['attributes']['manufacturer'][0]['value'] ?? null;
                $list_price = $data['attributes']['list_price'][0]['value'] ?? null;
                $currency = $data['attributes']['list_price'][0]['currency'] ?? null;
                $authors = array_map(fn($author) => $author['value'], $data['attributes']['author'] ?? []);
                $genres = array_map(
                    fn($genre) =>
                    array_key_exists('value', $genre) ? $genre['value'] : null,
                    $data['attributes']['genre'] ?? []
                );
                $publication_date = $data['attributes']['publication_date'][0]['value'] ?? null;
                $identifiers = $data['identifiers'][0]['identifiers'] ?? [];
                $images = $data['images'][0]['images'] ?? null;
                $productTypes = $data['productTypes'][0]['productType'] ?? [];
                $classifications = $data['classifications'][0]['classifications'] ?? [];
                $classificationRanks = $data['salesRanks'][0]['classificationRanks'] ?? [];
                $displayGroupRanks = $data['salesRanks'][0]['displayGroupRanks'] ?? [];

                $result = [
                    'ASIN' => $asin,
                    'Title' => $item_name,
                    'Subjects' => $subjects,
                    'Binding' => $binding,
                    'Languages' => $languages,
                    'Format' => $format,
                    'ItemTypeKeyword' => $item_type_keyword,
                    'Composer' => $composer,
                    'PublicationDate' => $publication_date,
                    'ReleaseDate' => $release_date,
                    'Pages' => $pages,
                    'BulletPoints' => $bullet_points,
                    'Dimensions' => $dimensions,
                    'Brand' => $brand,
                    'TargetAudience' => $target_audience,
                    'Manufacturer' => $manufacturer,
                    'Price' => $list_price . ' ' . $currency,
                    'Authors' => $authors,
                    'Genre' => $genres,
                    'Identifiers' => $identifiers,
                    'Images' => $images,
                    'ProductTypes' => $productTypes,
                    'Classifications' => $classifications,
                    'ClassificationRanks' => $classificationRanks,
                    'DisplayGroupRanks' => $displayGroupRanks
                ];

                return $result;
            } catch (NotFoundException $e) {
                // Handle specifically a 404 error
                $errorResponse = $e->getResponse()->json();
                return $errorResponse;
            } catch (RequestException $e) {
                // Handle other request-related exceptions
                $errorResponse = $e->getResponse()->json();
                return $errorResponse;
            }
        }
    }

    public function getSellerListing($sellerId, $sku)
    {
        $spApi = new SellingPartnerApi(clientId: env('SP_API_CLIENT_ID'), clientSecret: env('SP_API_CLIENT_SECRET'), refreshToken: env('ART_TX_REFRESH_TOKEN'), endpoint: Endpoint::NA);
        $connector = $spApi->seller();

        $listingApi = $connector->listingsItemsV20210801();
        $response = $listingApi->getListingsItem(
            sellerId: $sellerId,
            sku: $sku,
            marketplaceIds: ['ATVPDKIKX0DER'],
            includedData: ['summaries']
        );
        $data = json_decode($response, true);
        return $data;
    }

    public function requestSellerPerformanceReport($sellerId, Request $request)
    {
        $check_credits = $this->check_or_create_ai_credit_transactions($request->all(), 'api', 'Update Dashboard');

        if ($check_credits != 'continue') {
            return response()->json(['error' => $check_credits]);
        }
        if ($this->DEBUG_MODE) Log::info("requestSellerPerformanceReport Seller ID: " . $sellerId);

        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {

            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->post("https://sellingpartnerapi-na.amazon.com/reports/2021-06-30/reports", [
                "reportType" => "GET_V2_SELLER_PERFORMANCE_REPORT",
                "marketplaceIds" => ["ATVPDKIKX0DER"]
            ]);
            $data = json_decode($response->body(), true);
            //Get report ID first
            $reportId = $data['reportId'];
            if ($this->DEBUG_MODE) Log::info("requestSellerPerformanceReport ID: " . $reportId);

            //Get report document ID by using report ID
            $reportDocumentId = $this->checkRequestedReportDocument($reportId, $sellerId);
            if ($this->DEBUG_MODE) Log::info("requestSellerPerformanceReport Document ID: " . $reportDocumentId);

            //Download report content by using report document ID
            $reportContent = $this->downloadReadyReport($reportDocumentId, $sellerId);

            $lateShipmentRate = $reportContent['performanceMetrics'][0]["lateShipmentRate"]["rate"];
            $lateShipmenttargetValue = $reportContent['performanceMetrics'][0]["lateShipmentRate"]["targetValue"];
            $orderDefectRateAfnTargetValue = $reportContent['performanceMetrics'][0]["orderDefectRate"]["afn"]["targetValue"];
            $orderDefectRateAfnRate = $reportContent['performanceMetrics'][0]["orderDefectRate"]["afn"]["rate"];
            $orderDefectRateMfnTargetValue = $reportContent['performanceMetrics'][0]["orderDefectRate"]["mfn"]["targetValue"];
            $orderDefectRateMfnRate = $reportContent['performanceMetrics'][0]["orderDefectRate"]["mfn"]["rate"];
            $onTimeDeliveryRateTargetValue = $reportContent['performanceMetrics'][0]["onTimeDeliveryRate"]["targetValue"];
            $onTimeDeliveryRate = $reportContent['performanceMetrics'][0]["onTimeDeliveryRate"]["rate"];

            $report = [
                'lateShipmentRate' => $lateShipmentRate,
                'lateShipmenttargetValue' => $lateShipmenttargetValue,
                'orderDefectRateAfnTargetValue' => $orderDefectRateAfnTargetValue,
                'orderDefectRateAfnRate' => $orderDefectRateAfnRate,
                'orderDefectRateMfnTargetValue' => $orderDefectRateMfnTargetValue,
                'orderDefectRateMfnRate' => $orderDefectRateMfnRate,
                'onTimeDeliveryRateTargetValue' => $onTimeDeliveryRateTargetValue,
                'onTimeDeliveryRate' => $onTimeDeliveryRate,
                'updated_at' => date('Y-m-d H:i'),
                'last_date_updated_at' => date('Y-m-d'),
            ];

            AmazonDashboardData::where('seller_id', $sellerId)->delete();
            AmazonDashboardData::create([
                'seller_id' => $sellerId,
                'performance_metrics' => json_encode($report)
            ]);

            return response()->json($report);
        } catch (\Throwable $th) {
            Log::error("Error requesting seller performance report: " . $th->getMessage());
            return response()->json(['error' => 'Failed to request seller performance report']);
        }
    }

    function downloadReadyReport($reportId, $sellerId)
    {
        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {
            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->get("https://sellingpartnerapi-na.amazon.com/reports/2021-06-30/documents/$reportId");

            $reportFile = json_decode($response->body(), true);
            if ($this->DEBUG_MODE) Log::info('reportFile: ');
            if ($this->DEBUG_MODE) Log::info($reportFile);

            $reportData = $this->extractReportContent($reportFile);
            return $reportData;

            //return ['success' => 'Amazon Seller Inventory Updated'];
        } catch (\Exception $e) {
            if ($this->DEBUG_MODE) Log::error("Error fetching report document: " . $e->getMessage());
            return ['error' => 'Failed to fetch report document'];
        }
    }

    public function requestInventoryReport(Request $request, $sellerId)
    {
        if ($this->DEBUG_MODE) Log::info("Seller ID: " . $sellerId);
        if ($sellerId == 'A13Y3JSUKFVTQ5') {
            Cache::forget('requestInventoryReport');
        }
        // Cache::forget('requestInventoryReport');
        if (!Cache::has('requestInventoryReport')) {
            Cache::forget('updateAmazonTable');
            $total_amazon_sellers = DB::table('amazon_sellers')->count();
            Cache::put('requestInventoryReport', [
                'completed' => 0,
                'total' => $total_amazon_sellers,
            ], now()->addMinutes(30));
        }

        //We need to retrieve refresh_token from amazon_sellers table with $sellerId first
        $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
        if (!$refreshToken) {
            if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
            return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
        }

        $spApi = new SellingPartnerApi(
            clientId: env('SP_API_CLIENT_ID'),
            clientSecret: env('SP_API_CLIENT_SECRET'),
            refreshToken: $refreshToken,
            endpoint: Endpoint::NA
        );

        $connector = $spApi->seller();
        $listingApi = $connector->reportsV20210630();

        $response = $listingApi->createReport(
            new \SellingPartnerApi\Seller\ReportsV20210630\Dto\CreateReportSpecification(
                // 'GET_MERCHANT_LISTINGS_DATA_BACK_COMPAT',
                'GET_MERCHANT_LISTINGS_ALL_DATA',
                ['ATVPDKIKX0DER'],
            )
        );

        $data = json_decode($response, true);
        if (!isset($data['reportId'])) {
            if ($this->DEBUG_MODE) Log::error('Failed to create report. Response: ' . json_encode($data));
            return response()->json(['error' => 'Failed to create report'], 500);
        }

        $reportId = $data['reportId'];
        if ($this->DEBUG_MODE) Log::info("Requested report with ID: " . $reportId);

        // I should wait for report processing
        $reportDocumentId = null;
        $maxAttempts = 20;
        $attempts = 0;

        while (is_null($reportDocumentId) && $attempts < $maxAttempts) {
            sleep(30);
            $reportDocumentId = $this->getReportStatus($reportId, $refreshToken);
            $attempts++;

            if (is_null($reportDocumentId)) {
                if ($this->DEBUG_MODE) Log::info("Waiting for report to be ready... Attempt $attempts");
            } else {
                if ($this->DEBUG_MODE) Log::info("Report is ready! Report Document ID: " . $reportDocumentId);
                break;
            }
        }

        if (is_null($reportDocumentId)) {
            if ($this->DEBUG_MODE) Log::error('Report generation timed out.');
            return response()->json(['message' => 'Report generation timed out.'], 500);
        }

        // I will get report document
        try {

            $accessToken = $this->checkAmazonAccessToken($sellerId);
            if (!$accessToken) {
                return ['error' => 'Failed to get access token'];
            }

            if ($this->DEBUG_MODE) Log::info('accessToken received');
            try {
                $response = Http::withHeaders([
                    'x-amz-access-token' => $accessToken,
                ])->get("https://sellingpartnerapi-na.amazon.com/reports/2021-06-30/documents/$reportDocumentId");

                $reportFile = json_decode($response->body(), true);
                if ($this->DEBUG_MODE) Log::info('reportFile: ');
                if ($this->DEBUG_MODE) Log::info($reportFile);

                $reportData = $this->extractReportContent($reportFile);

                $records = [];
                foreach ($reportData as $item) {
                    $records[] = [
                        'listing_id' => $item['listing-id'],
                        'seller_id' => $sellerId,
                        'seller_sku' => $item['seller-sku'],
                        'price' => $item['price'],
                        'quantity' => empty($item['quantity']) ? 0 : $item['quantity'],
                        'item_condition' => $item['item-condition'],
                        'asin' => $item['asin1'],
                        'status' => $item['status'],
                        'updated_at' => now(), // Required for upsert
                        'created_at' => now()
                    ];
                }

                AmazonSellerInventory::where('seller_id', $sellerId)->delete();

                $chunks = array_chunk($records, 1000);
                foreach ($chunks as $chunk) {
                    AmazonSellerInventory::upsert($chunk, ['listing_id'], ['seller_id', 'seller_sku', 'price', 'quantity', 'item_condition', 'asin', 'status']);
                }
                if ($this->DEBUG_MODE) Log::info('Amazon Seller Inventory Updated');

                // Bus::chain([
                //     new UpdateAmazonSellerInventoryJob(), // ✅ Step 1: Update Amazon Seller Inventory
                //     // new ConvertAmazonToShopifyJob('CheapBookDepot') // ✅ Step 2: Convert Amazon to Shopify
                //     // new ProductCreateGraphQLJob($request) // ✅ Step 3: Send Product to Shopify
                // ])->catch(function ($e) {
                //     Log::error("Job chain failed: " . $e->getMessage());
                // })->dispatch();                    

                // app(shopifyController::class)->productCreateGraphQl();
                // if ($this->DEBUG_MODE) Log::info("send to shopify finished");
                $current = Cache::get("requestInventoryReport");
                $current['completed']++;
                Cache::put("requestInventoryReport", $current, now()->addMinutes(30));
                return response()->json(['success' => 'Amazon Seller Inventory Updated'], 200);
            } catch (\Exception $e) {
                if ($this->DEBUG_MODE) Log::error("Amazon Report Fetch Error: " . $e->getMessage());
                return ['error' => 'Failed to fetch report'];
            }
        } catch (\Exception $e) {
            if ($this->DEBUG_MODE) Log::error("Error fetching report document: " . $e->getMessage());
            return response()->json(['error' => 'Failed to fetch report document'], 500);
        }
    }

    public function requestAllInventoryReport($sellerId)
    {
        Log::info("requestAllInventoryReport Seller ID: " . $sellerId);
        //AmazonSellerInventory::truncate();

        //We need to retrieve refresh_token from amazon_sellers table with $sellerId first
        $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
        if (!$refreshToken) {
            if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
            return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
        }

        $spApi = new SellingPartnerApi(
            clientId: env('SP_API_CLIENT_ID'),
            clientSecret: env('SP_API_CLIENT_SECRET'),
            refreshToken: $refreshToken,
            endpoint: Endpoint::NA
        );

        $connector = $spApi->seller();
        $listingApi = $connector->reportsV20210630();

        $response = $listingApi->createReport(
            new \SellingPartnerApi\Seller\ReportsV20210630\Dto\CreateReportSpecification(
                'GET_MERCHANT_LISTINGS_ALL_DATA',
                ['ATVPDKIKX0DER'],
                ['newReport' => 'true'] // Attempt to force a fresh report
            )
        );

        $data = json_decode($response, true);
        if (!isset($data['reportId'])) {
            if ($this->DEBUG_MODE) Log::error('Failed to create report. Response: ' . json_encode($data));
            return response()->json(['error' => 'Failed to create report'], 500);
        }

        $reportId = $data['reportId'];
        if ($this->DEBUG_MODE) Log::info("Requested report with ID: " . $reportId);

        // I should wait for report processing
        $reportDocumentId = null;
        $maxAttempts = 20;
        $attempts = 0;

        while (is_null($reportDocumentId) && $attempts < $maxAttempts) {
            sleep(30);
            $reportDocumentId = $this->getReportStatus($reportId, $refreshToken);
            $attempts++;

            if (is_null($reportDocumentId)) {
                if ($this->DEBUG_MODE) Log::info("Waiting for report to be ready... Attempt $attempts");
            } else {
                if ($this->DEBUG_MODE) Log::info("Report is ready! Report Document ID: " . $reportDocumentId);
                break;
            }
        }

        if (is_null($reportDocumentId)) {
            if ($this->DEBUG_MODE) Log::error('Report generation timed out.');
            return response()->json(['message' => 'Report generation timed out.'], 500);
        }

        // I will get report document
        try {

            $accessToken = $this->checkAmazonAccessToken($sellerId);
            if (!$accessToken) {
                return ['error' => 'Failed to get access token'];
            }

            if ($this->DEBUG_MODE) Log::info('accessToken received');
            try {
                $response = Http::withHeaders([
                    'x-amz-access-token' => $accessToken,
                ])->get("https://sellingpartnerapi-na.amazon.com/reports/2021-06-30/documents/$reportDocumentId");

                $reportFile = json_decode($response->body(), true);
                if ($this->DEBUG_MODE) Log::info('reportFile: ');
                if ($this->DEBUG_MODE) Log::info($reportFile);
                $reportData = $this->extractReportContent($reportFile);

                $records = [];
                foreach ($reportData as $item) {
                    $records[] = [
                        'listing_id' => $item['listing-id'],
                        'seller_id' => $sellerId,
                        'seller_sku' => $item['seller-sku'],
                        'price' => $item['price'],
                        'quantity' => empty($item['quantity']) ? 0 : $item['quantity'],
                        'item_condition' => $item['item-condition'],
                        'asin' => $item['asin1'],
                        'updated_at' => now(), // Required for upsert
                        'created_at' => now()
                    ];
                }
                $chunks = array_chunk($records, 1000);
                foreach ($chunks as $chunk) {
                    AmazonSellerInventory::upsert($chunk, ['listing_id'], ['seller_id', 'seller_sku', 'price', 'quantity', 'item_condition', 'asin']);
                }
                if ($this->DEBUG_MODE) Log::info('Amazon Seller Inventory Updated');

                return response()->json(['success' => 'Amazon Seller Inventory Updated'], 200);
            } catch (\Exception $e) {
                if ($this->DEBUG_MODE) Log::error("Amazon Report Fetch Error: " . $e->getMessage());
                return ['error' => 'Failed to fetch report'];
            }
        } catch (\Exception $e) {
            if ($this->DEBUG_MODE) Log::error("Error fetching report document: " . $e->getMessage());
            return response()->json(['error' => 'Failed to fetch report document'], 500);
        }
    }

    public function displayInventoryReport($sellerId)
    {
        Log::info("displayInventoryReport Seller ID: " . $sellerId);

        $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
        if (!$refreshToken) {
            if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
            return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
        }

        $spApi = new SellingPartnerApi(
            clientId: env('SP_API_CLIENT_ID'),
            clientSecret: env('SP_API_CLIENT_SECRET'),
            refreshToken: $refreshToken,
            endpoint: Endpoint::NA
        );

        $connector = $spApi->seller();
        $listingApi = $connector->reportsV20210630();

        $response = $listingApi->createReport(
            new \SellingPartnerApi\Seller\ReportsV20210630\Dto\CreateReportSpecification(
                'GET_MERCHANT_LISTINGS_DATA',
                ['ATVPDKIKX0DER'],
                ['newReport' => 'true'] // Attempt to force a fresh report
            )
        );

        $data = json_decode($response, true);
        if (!isset($data['reportId'])) {
            if ($this->DEBUG_MODE) Log::error('Failed to create report. Response: ' . json_encode($data));
            return response()->json(['error' => 'Failed to create report'], 500);
        }

        $reportId = $data['reportId'];
        if ($this->DEBUG_MODE) Log::info("Requested report with ID: " . $reportId);

        $reportDocumentId = null;
        $maxAttempts = 20;
        $attempts = 0;

        while (is_null($reportDocumentId) && $attempts < $maxAttempts) {
            sleep(30);
            $reportDocumentId = $this->getReportStatus($reportId, $refreshToken);
            $attempts++;

            if (is_null($reportDocumentId)) {
                if ($this->DEBUG_MODE) Log::info("Waiting for report to be ready... Attempt $attempts");
            } else {
                if ($this->DEBUG_MODE) Log::info("Report is ready! Report Document ID: " . $reportDocumentId);
                break;
            }
        }

        if (is_null($reportDocumentId)) {
            if ($this->DEBUG_MODE) Log::error('Report generation timed out.');
            return response()->json(['message' => 'Report generation timed out.'], 500);
        }

        // I will get report document
        try {

            $accessToken = $this->checkAmazonAccessToken($sellerId);
            if (!$accessToken) {
                return ['error' => 'Failed to get access token'];
            }

            if ($this->DEBUG_MODE) Log::info('accessToken received');
            try {
                $response = Http::withHeaders([
                    'x-amz-access-token' => $accessToken,
                ])->get("https://sellingpartnerapi-na.amazon.com/reports/2021-06-30/documents/$reportDocumentId");

                $reportFile = json_decode($response->body(), true);
                if ($this->DEBUG_MODE) Log::info('reportFile: ');
                if ($this->DEBUG_MODE) Log::info($reportFile);
                $reportData = $this->extractReportContent($reportFile);
                return $reportData;

                $records = [];
                foreach ($reportData as $item) {
                    $records[] = [
                        'listing_id' => $item['listing-id'],
                        'seller_id' => $sellerId,
                        'seller_sku' => $item['seller-sku'],
                        'price' => $item['price'],
                        'quantity' => empty($item['quantity']) ? 0 : $item['quantity'],
                        'item_condition' => $item['item-condition'],
                        'asin' => $item['asin1'],
                        'updated_at' => now(), // Required for upsert
                        'created_at' => now()
                    ];
                }
                return $records;
            } catch (\Exception $e) {
                if ($this->DEBUG_MODE) Log::error("Amazon Report Fetch Error: " . $e->getMessage());
                return ['error' => 'Failed to fetch report'];
            }
        } catch (\Exception $e) {
            if ($this->DEBUG_MODE) Log::error("Error fetching report document: " . $e->getMessage());
            return response()->json(['error' => 'Failed to fetch report document'], 500);
        }
    }

    function extractReportContent($reportDocument)
    {
        if ($this->DEBUG_MODE) Log::info('extractReportContent');
        try {

            $response = Http::get($reportDocument['url']);

            if (!$response->successful()) {
                if ($this->DEBUG_MODE) Log::error('Failed to download report', ['response' => $response->body()]);
                return ['error' => 'Failed to download report file'];
            }

            $compressedContent = $response->body();

            if ($reportDocument['compressionAlgorithm'] === 'GZIP') {
                $decompressedContent = gzdecode($compressedContent);
            } else {
                $decompressedContent = $compressedContent;
            }

            $encoding = mb_detect_encoding($decompressedContent, ['UTF-8', 'ISO-8859-1', 'Windows-1252'], true);
            $decompressedContent = mb_convert_encoding($decompressedContent, 'UTF-8', $encoding);
            // $decompressedContent = mb_convert_encoding($decompressedContent, 'UTF-8', 'auto');
            $rows = array_filter(explode("\n", trim($decompressedContent))); // I tried to remove empty lines, let's see if it works
            if (empty($rows)) {
                return ['error' => 'Report is empty'];
            }

            if (strpos($rows[0], 'performanceMetrics') !== false) {
                if ($this->DEBUG_MODE) Log::info('performanceMetrics report detected');
                return json_decode($rows[0], true);
            }

            $headers = str_getcsv(array_shift($rows), "\t"); // First row as headers
            $data = [];

            foreach ($rows as $row) {
                $values = str_getcsv($row, "\t");

                if (count($values) === count($headers)) {
                    $data[] = array_combine($headers, $values);
                } else {
                    if ($this->DEBUG_MODE) Log::warning('Skipping malformed row due to column mismatch', ['row' => $row]);
                }
            }

            return $data;
        } catch (\Exception $e) {
            if ($this->DEBUG_MODE) Log::error('Amazon Report Processing Error: ' . $e->getMessage());
            return ['error' => 'Failed to process report'];
        }
    }

    function checkRequestedReportDocument($reportId, $sellerId)
    {
        $reportDocumentId = null;
        $maxAttempts = 20;
        $attempts = 0;

        while (is_null($reportDocumentId) && $attempts < $maxAttempts) {
            sleep(30);
            $reportDocumentId = $this->getReportStatusV2($reportId, $sellerId);
            $attempts++;

            if (is_null($reportDocumentId)) {
                if ($this->DEBUG_MODE) Log::info("Waiting for report to be ready... Attempt $attempts");
            } else {
                if ($this->DEBUG_MODE) Log::info("Report is ready! Report Document ID: " . $reportDocumentId);
                break;
            }
        }

        if (is_null($reportDocumentId)) {
            if ($this->DEBUG_MODE) Log::error('Report generation timed out.');
            return response()->json(['message' => 'Report generation timed out.'], 500);
        }

        return $reportDocumentId;
    }



    function getReportStatusV2($reportId, $sellerId)
    {
        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }

        try {

            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->get("https://sellingpartnerapi-na.amazon.com/reports/2021-06-30/reports/{$reportId}");

            $data = json_decode($response->body(), true);
            $processingStatus = $data['processingStatus'] ?? null;
            if ($processingStatus == 'DONE') {
                return $data['reportDocumentId'];
            } else {
                return null;
            }
        } catch (\Throwable $th) {
            Log::error("Error requesting seller performance report: " . $th->getMessage());
            return ['error' => 'Failed to request seller performance report'];
        }
    }

    function getReportStatus($reportId, $refreshToken)
    {
        if ($this->DEBUG_MODE) Log::info("Inside get report status");
        $spApi = new SellingPartnerApi(clientId: env('SP_API_CLIENT_ID'), clientSecret: env('SP_API_CLIENT_SECRET'), refreshToken: $refreshToken, endpoint: Endpoint::NA);
        $connector = $spApi->seller();
        $reportStatus = $connector->reportsV20210630()->getReport($reportId);
        $data = json_decode($reportStatus, true);
        $processingStatus = $data['processingStatus'] ?? null;
        if ($this->DEBUG_MODE) Log::info($processingStatus);
        if ($processingStatus == 'DONE') {
            return $data['reportDocumentId'];
        } else {
            return null;
        }
    }

    public function getLatestFeedDocument($sellerId)
    {
        Log::info("getLatestFeedDocument Seller ID: " . $sellerId);

        $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
        if (!$refreshToken) {
            if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
            return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
        }

        $spApi = new SellingPartnerApi(
            clientId: env('SP_API_CLIENT_ID'),
            clientSecret: env('SP_API_CLIENT_SECRET'),
            refreshToken: $refreshToken,
            endpoint: Endpoint::NA
        );

        $connector = $spApi->seller();
        $feedApi = $connector->feedsV20210630();

        $response = $feedApi->getFeeds(
            marketplaceIds: ['ATVPDKIKX0DER'],
            feedTypes: ['JSON_LISTINGS_FEED']
        );

        $data = json_decode($response, true);
        return $data;
        $feedId = $data['feeds'][0]['resultFeedDocumentId'];
        Log::info("FeedDocumentId retrieved: " . $data['feeds'][0]['resultFeedDocumentId']);

        $feedApiDocumentApi = $connector->feedsV20210630();
        $response = $feedApiDocumentApi->getFeedDocument(feedDocumentId: $feedId);
        // $tempData = json_decode($response, true);
        // return $tempData;
        $documentUrl = $response->json('url');

        if ($documentUrl) {

            // Fetch the document content
            $documentContent = file_get_contents($documentUrl);
            if ($documentContent === false) {
                Log::error("Failed to retrieve feed document content from URL: " . $documentUrl);
                return response()->json(['error' => 'Failed to retrieve feed document content'], 500);
            }

            // Decode content if compression is indicated
            if ($response->json('compressionAlgorithm') !== null && $response->json('compressionAlgorithm') === 'GZIP') {
                $documentContent = gzdecode($documentContent);
                if ($documentContent === false) {
                    Log::error("Failed to decode GZIP feed document for Feed ID: " . $feedId);
                    return response()->json(['error' => 'Failed to decode GZIP feed document'], 500);
                }
            }

            return response()->json(['feedDocument' => $documentContent]);
        } else {
            Log::error("Feed document URL not found for Feed ID: " . $feedId);
            return response()->json(['error' => 'Feed document URL not found'], 500);
        }
    }

    function getCompetitiveSummary($sellerId, $asin)
    {
        try {
            $accessToken = $this->checkAmazonAccessToken($sellerId);
            if (!$accessToken) {
                return ['error' => 'Failed to get access token'];
            }

            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->post("https://sellingpartnerapi-na.amazon.com/batches/products/pricing/2022-05-01/items/competitiveSummary", [
                "requests" => [
                    [
                        "asin" => $asin,
                        "marketplaceId" => "ATVPDKIKX0DER",
                        "includedData" => [
                            "featuredBuyingOptions",
                            "referencePrices",
                            "lowestPricedOffers"
                        ],
                        "lowestPricedOffersInputs" => [
                            [
                                "itemCondition" => "New",
                                "offerType" => "Consumer"
                            ],
                            [
                                "itemCondition" => "Used",
                                "offerType" => "Consumer"
                            ],
                            [
                                "itemCondition" => "Refurbished",
                                "offerType" => "Consumer"
                            ]
                        ],
                        "uri" => "/products/pricing/2022-05-01/items/competitiveSummary",
                        "method" => "GET"
                    ]
                ]
            ]);

            $decode = json_decode($response->body(), true);
            // return $decode;
            $featuredOffers = $decode['responses'][0]['body']['featuredBuyingOptions'] ?? [];
            $newOffers = $decode['responses'][0]['body']['lowestPricedOffers'][0]['offers'] ?? [];
            $usedOffers = $decode['responses'][0]['body']['lowestPricedOffers'][1]['offers'] ?? [];

            $data = [
                'featuredOffers' => $featuredOffers,
                'newOffers' => $newOffers,
                'usedOffers' => $usedOffers
            ];

            return $data;
        } catch (\Exception $e) {
            if ($this->DEBUG_MODE) Log::error("Amazon Competitive Summary Fetch Error: " . $e->getMessage());
            return ['error' => 'Failed to fetch competitive summary'];
        }
    }

    function getFeaturedOfferExpectedPriceBatch($sellerId, $sellerSku)
    {
        try {
            $accessToken = $this->checkAmazonAccessToken($sellerId);
            if (!$accessToken) {
                return ['error' => 'Failed to get access token'];
            }

            $response = Http::withHeaders([
                'x-amz-access-token' => $accessToken,
            ])->post("https://sellingpartnerapi-na.amazon.com/batches/products/pricing/2022-05-01/offer/featuredOfferExpectedPrice", [
                "requests" => [
                    [
                        "sku" => $sellerSku,
                        "marketplaceId" => "ATVPDKIKX0DER",
                        "uri" => "/products/pricing/2022-05-01/offer/featuredOfferExpectedPrice",
                        "method" => "GET"
                    ]
                ]
            ]);

            $data = json_decode($response->body(), true);
            return $data;
        } catch (\Exception $e) {
            if ($this->DEBUG_MODE) Log::error("Amazon Competitive Summary Fetch Error: " . $e->getMessage());
            return ['error' => 'Failed to fetch competitive summary'];
        }
    }

    function getAmazonAccessToken($refreshToken)
    {
        $clientId = env('SP_API_CLIENT_ID');
        $clientSecret = env('SP_API_CLIENT_SECRET');

        $url = 'https://api.amazon.com/auth/o2/token';

        $response = Http::asForm()->post($url, [
            'grant_type'    => 'refresh_token',
            'refresh_token' => $refreshToken,
            'client_id'     => $clientId,
            'client_secret' => $clientSecret,
        ]);

        if ($response->successful()) {
            $data = $response->json();
            if ($this->DEBUG_MODE) Log::info('Amazon Access Token Retrieved Successfully');
            return $data['access_token'];
        } else {
            if ($this->DEBUG_MODE) Log::error('Failed to get Amazon Access Token', ['response' => $response->body()]);
            return null;
        }
    }

    function checkAmazonAccessToken($sellerId)
    {
        if ($this->DEBUG_MODE) Log::info("checkAmazonAccessToken Seller ID: " . $sellerId);
        $accessTokenRecord = DB::table('amazon_access_tokens')->where('seller_id', $sellerId)->orderBy('updated_at', 'desc')->first();
        $accessToken = '';

        if ($accessTokenRecord && Carbon::parse($accessTokenRecord->updated_at)->addMinutes(60)->isFuture()) {
            if ($this->DEBUG_MODE) Log::info('accessToken not expired');
            $accessToken = $accessTokenRecord->access_token;
        } else {
            if ($this->DEBUG_MODE) Log::info('accessToken not exists or expired');

            $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
            if (!$refreshToken) {
                if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
                return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
            }

            $accessToken = $this->getAmazonAccessToken($refreshToken);
            if (!$accessToken) {
                return ['error' => 'Failed to get access token'];
            }
            DB::table('amazon_access_tokens')->updateOrInsert(
                ['seller_id' => $sellerId],
                ['access_token' => $accessToken, 'updated_at' => now()]
            );
        }

        if ($this->DEBUG_MODE) Log::info('accessToken: ' . $accessToken);
        return $accessToken;
    }

    public function getOrders()
    {
        $orders = $this->amazonService->getOrders();
        return response()->json($orders);
    }

    public function getProducts()
    {
        // $products = $this->amazonService->1();
        // return response()->json($products);
        $marketplaceId = 'ATVPDKIKX0DER'; // Example Marketplace ID
        $sku = 'example_sku'; // Replace with the actual SKU
        $asin = 'B00006HAZ4'; // Replace with the actual ASIN

        //$response = $this->amazonService->fetchProductDetails($sku, null, $marketplaceId); // Using SKU
        // Or
        $response = $this->amazonService->fetchProductDetails($asin, $marketplaceId); // Using ASIN

        dd($response); // Dump and die to inspect the response
    }

    public function tableProducts(Request $request, $sellerId)
    {
        $query = AmazonTable::leftJoin('competitive_prices as cp', function ($join) {
            $join->on('cp.asin', '=', 'amazon_table.asin')
                ->on('cp.seller_id', '=', 'amazon_table.store'); // Tambahkan kondisi kedua
        })->leftJoin('print_labels_queue as plq', function ($join) {
            $join->on('plq.reference_id', '=', 'amazon_table.id')
                ->where('plq.user_id', auth()->user()->id);
        })->select(
            'amazon_table.id',
            DB::raw("
                JSON_UNQUOTE(JSON_EXTRACT(Images, '$[0].link')) as image,
                amazon_table.ASIN as asin,
                Title as title,
                (CASE 
                    WHEN ClassificationRanks is null or ClassificationRanks = '[]' THEN JSON_UNQUOTE(JSON_EXTRACT(Classifications, '$[0].displayName'))
                    ELSE JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].title'))
                END) as category,
                AmazonSellerInventoryPrice as current_price, 
                COALESCE(CurrentQty,0) as current_qty,
                Brand as brand,
                Manufacturer as manufacturer,
                JSON_UNQUOTE(JSON_EXTRACT(DisplayGroupRanks, '$[0].websiteDisplayGroup')) as productGroup,
                ProductTypes as type,
                Binding as binding,
                amazon_table.store,
                cp.id as competitive_price_id,
                SellerSku as sku,
                AmazonSellerInventoryPrice as price, 
                COALESCE(CurrentQty,0) as qty,
                ItemCondition as item_condition,
                (case 
                    when ASCII(LEFT(amazon_table.ASIN, 1)) BETWEEN 65 AND 90
                    OR ASCII(LEFT(amazon_table.ASIN, 1)) BETWEEN 97 AND 122 then amazon_table.ASIN
                    else CONCAT('978', LEFT(amazon_table.ASIN, 9), 
                    MOD(10 - MOD(
                        (9 * 1) +  -- '9' from '978' prefix
                        (7 * 3) +  -- '7' from '978' prefix
                        (8 * 1) +  -- '8' from '978' prefix
                        (SUBSTRING(amazon_table.ASIN, 1, 1) * 3) + 
                        (SUBSTRING(amazon_table.ASIN, 2, 1) * 1) + 
                        (SUBSTRING(amazon_table.ASIN, 3, 1) * 3) + 
                        (SUBSTRING(amazon_table.ASIN, 4, 1) * 1) + 
                        (SUBSTRING(amazon_table.ASIN, 5, 1) * 3) + 
                        (SUBSTRING(amazon_table.ASIN, 6, 1) * 1) + 
                        (SUBSTRING(amazon_table.ASIN, 7, 1) * 3) + 
                        (SUBSTRING(amazon_table.ASIN, 8, 1) * 1) + 
                        (SUBSTRING(amazon_table.ASIN, 9, 1) * 3),
                    10), 10)
                ) end) as isbn13,
                status,
                (CASE
                    WHEN synced = 0 THEN 'No'
                    ELSE 'Yes'
                END) as sync,
                plq.reference_id,
                plq.user_id,
                coalesce(label_price,0) as label_price
            "),
        );
        
        if($sellerId != 'all') {
            $query->where('amazon_table.store', $sellerId);
        }

        $recordsTotal = $query->count();

        if ($request->category) {
            $query->where(DB::raw("JSON_UNQUOTE(JSON_EXTRACT(Classifications, '$[0].displayName'))"), $request->category);
        }

        if ($request->status) {
            $query->where('status', $request->status);
        }

        if ($request->synced === 0 || $request->synced === '0') {
            $query->where('synced', '=', 0);
        } else if ($request->synced == 1) {
            $query->where('synced', '=', 1);
        }

        // **Filter Data (Pencarian)**
        if (!empty($request->search['value'])) {
            $search = $request->search['value'];
            $query->whereRaw("((amazon_table.Title like ? or amazon_table.SellerSku like ? or amazon_table.ASIN like ? or 
            (CASE                    
            WHEN ClassificationRanks is null
            or ClassificationRanks = '[]' THEN JSON_UNQUOTE(JSON_EXTRACT(Classifications, '$[0].displayName'))
            ELSE JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].title'))
            END) like ?) 
            or (case 
                    when ASCII(LEFT(amazon_table.ASIN, 1)) BETWEEN 65 AND 90
                    OR ASCII(LEFT(amazon_table.ASIN, 1)) BETWEEN 97 AND 122 then amazon_table.ASIN
                    else CONCAT('978', LEFT(amazon_table.ASIN, 9), 
                    MOD(10 - MOD(
                        (9 * 1) +  -- '9' from '978' prefix
                        (7 * 3) +  -- '7' from '978' prefix
                        (8 * 1) +  -- '8' from '978' prefix
                        (SUBSTRING(amazon_table.ASIN, 1, 1) * 3) + 
                        (SUBSTRING(amazon_table.ASIN, 2, 1) * 1) + 
                        (SUBSTRING(amazon_table.ASIN, 3, 1) * 3) + 
                        (SUBSTRING(amazon_table.ASIN, 4, 1) * 1) + 
                        (SUBSTRING(amazon_table.ASIN, 5, 1) * 3) + 
                        (SUBSTRING(amazon_table.ASIN, 6, 1) * 1) + 
                        (SUBSTRING(amazon_table.ASIN, 7, 1) * 3) + 
                        (SUBSTRING(amazon_table.ASIN, 8, 1) * 1) + 
                        (SUBSTRING(amazon_table.ASIN, 9, 1) * 3),
                    10), 10)
                ) end) like ?)", array_fill(0, 5, "%$search%"));
        }
        
        // **Hitung Total Data Setelah Filter**
        $recordsFiltered = $query->count();

        // **Sorting**
        if (!empty($request->order)) {
            $columnIndex = $request->order[0]['column']; // Index kolom
            $columnName = $request->columns[$columnIndex]['data']; // Nama kolom
            $columnSortOrder = $request->order[0]['dir']; // 'asc' atau 'desc'
            if ($columnName) {
                if (intval($request->draw) == 1) {
                    $query->orderBy('amazon_table.id', 'desc');
                } else {
                    $query->orderBy($columnName, $columnSortOrder);
                }
            }
        } else {
            $query->orderBy('amazon_table.id', 'desc');
        }

        $products = $query->orderBy('amazon_table.id', 'desc')->offset($request->start)
            ->limit($request->length)
            ->get();

        // dd($recordsTotal, $recordsFiltered);

        // **Response JSON**
        return response()->json([
            "draw" => intval($request->draw),
            "recordsTotal" => $recordsTotal,   // Total tanpa filter
            "recordsFiltered" => $recordsFiltered,  // Total dengan filter
            "data" => $products
        ]);
    }

    public function previewProduct($id)
    {
        try {
            $product = AmazonTable::leftJoin('competitive_prices as cp', function ($join) {
                $join->on('cp.asin', '=', 'amazon_table.asin')
                    ->on('cp.seller_id', '=', 'amazon_table.store'); // Tambahkan kondisi kedua
            })->select(
                'amazon_table.id',
                DB::raw("
                    JSON_UNQUOTE(JSON_EXTRACT(Images, '$[0].link')) as image,
                    amazon_table.ASIN as asin,
                    Title as title,
                    description,
                    (CASE 
                        WHEN ClassificationRanks is null or ClassificationRanks = '[]' THEN JSON_UNQUOTE(JSON_EXTRACT(Classifications, '$[0].displayName'))
                        ELSE JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].title'))
                    END) as category,
                    AmazonSellerInventoryPrice as current_price, 
                    COALESCE(CurrentQty,0) as current_qty,
                    Brand as brand,
                    Manufacturer as manufacturer,
                    JSON_UNQUOTE(JSON_EXTRACT(DisplayGroupRanks, '$[0].websiteDisplayGroup')) as productGroup,
                    ProductTypes as type,
                    Binding as binding,
                    SellerSku as seller_sku,
                    store,
                    ItemCondition as itemCondition,
                    Pages as numberOfPages,
                    ItemTypeKeyword as itemTypeKeyword,
                    cp.new_prices,
                    cp.used_prices,
                    DATE_FORMAT(cp.updated_at, '%m/%d/%Y %H:%i') as updated_at_competitive_price
                "),
            )->where('amazon_table.id', $id)->first();

            // $competitiveSummary = $this->getCompetitiveSummary($product->store, $product->asin);

            return view('business.partials.view-amazon-modal')->with(compact(
                'product',
                // 'competitiveSummary'
            ));
        } catch (\Exception $e) {
            Log::emergency('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
        }
    }

    public function labels(Request $request, $id)
    {
        if (! auth()->user()->can('product.print_labels')) {
            abort(403, 'Unauthorized action.');
        }
        $business_id = $request->session()->get('user.business_id');
        if ($id == 'multiple') {
            $products = DB::table('amazon_table')->whereIn('id', $request->products)->get();
            foreach ($products as $product) {
                $getClassificationRankFirst = collect(DB::select("
                    select JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].title')) as classificationRank,
                        JSON_UNQUOTE(JSON_EXTRACT(Classifications, '$[0].displayName')) as classification
                    from amazon_table 
                    where id = ?
                ", [$product->id]))->first();
                $classificationRankExtract = $this->extractWords($getClassificationRankFirst->classificationRank, 10); // up to 10 words
                if (!empty($classificationRankExtract)) {
                    $whereCategoryCode = '';
                    foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                        if (strtolower($classificationRank) == 'childrens') {
                            $classificationRank = "children\'s";
                        } else if (strtolower($classificationRank) == 'mens') {
                            $classificationRank = "men\'s";
                        }
                        $classificationRank = strtolower($classificationRank);
                        # code...
                        if ($keyClassificationRank == 0) {
                            $whereCategoryCode .= "(lower(category_name) LIKE '%" . $classificationRank . "%'";
                        } else if (count($classificationRankExtract) != ($keyClassificationRank + 1)) {
                            $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%'";
                        } else {
                            $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%')";
                        }

                        if (count($classificationRankExtract) == 1) {
                            $whereCategoryCode .= ")";
                        }
                    }
                    // foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                    //     # code...
                    //     if($keyClassificationRank == 0) {
                    //         $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
                    //     } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                    //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
                    //     } else {
                    //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
                    //     }
                    // }

                    $getCategoryCode = collect(DB::select("
                        SELECT category_code, category_name
                        FROM amazon_category_code
                        WHERE " . $whereCategoryCode . "
                        ORDER BY LENGTH(category_name) ASC
                        LIMIT 1;
                    "))->first();

                    if ($getCategoryCode) {
                        $product->category_code_selected = $getCategoryCode ? $getCategoryCode->category_code : '0-0';
                        $product->category_name_selected = $getCategoryCode ? $getCategoryCode->category_name : '';
                    } else {
                        $classificationRankExtract = $this->extractWords($getClassificationRankFirst->classification, 10); // up to 10 words                                
                        if (!empty($classificationRankExtract)) {
                            $whereCategoryCode = '';
                            foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                                # code...
                                if (strtolower($classificationRank) == 'childrens') {
                                    $classificationRank = "children\'s";
                                } else if (strtolower($classificationRank) == 'mens') {
                                    $classificationRank = "men\'s";
                                }
                                $classificationRank = strtolower($classificationRank);
                                if ($keyClassificationRank == 0) {
                                    $whereCategoryCode .= "(lower(category_name) LIKE '%" . $classificationRank . "%'";
                                } else if (count($classificationRankExtract) != ($keyClassificationRank + 1)) {
                                    $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%'";
                                } else {
                                    $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%')";
                                }

                                if (count($classificationRankExtract) == 1) {
                                    $whereCategoryCode .= ")";
                                }
                            }
                            // foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                            //     # code...
                            //     if($keyClassificationRank == 0) {
                            //         $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
                            //     } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                            //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
                            //     } else {
                            //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
                            //     }
                            // }

                            $getCategoryCode = collect(DB::select("
                                SELECT category_code, category_name
                                FROM amazon_category_code
                                WHERE " . $whereCategoryCode . "
                                ORDER BY LENGTH(category_name) ASC
                                LIMIT 1;
                            "))->first();

                            if ($getCategoryCode) {
                                $product->category_code_selected = $getCategoryCode ? $getCategoryCode->category_code : '0-0';
                                $product->category_name_selected = $getCategoryCode ? $getCategoryCode->category_name : '';
                            } else {
                                $product->category_code_selected = '0-0';
                                $product->category_name_selected = '';
                            }
                        } else {
                            $product->category_code_selected = '0-0';
                            $product->category_name_selected = '';
                        }
                    }
                } else {
                    $classificationRankExtract = $this->extractWords($getClassificationRankFirst->classification, 10); // up to 10 words                                                    
                    if (!empty($classificationRankExtract)) {
                        $whereCategoryCode = '';
                        foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                            # code...
                            if (strtolower($classificationRank) == 'childrens') {
                                $classificationRank = "children\'s";
                            } else if (strtolower($classificationRank) == 'mens') {
                                $classificationRank = "men\'s";
                            }
                            $classificationRank = strtolower($classificationRank);
                            if ($keyClassificationRank == 0) {
                                $whereCategoryCode .= "(lower(category_name) LIKE '%" . $classificationRank . "%'";
                            } else if (count($classificationRankExtract) != ($keyClassificationRank + 1)) {
                                $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%'";
                            } else {
                                $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%')";
                            }

                            if (count($classificationRankExtract) == 1) {
                                $whereCategoryCode .= ")";
                            }
                        }
                        // foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                        //     # code...
                        //     if($keyClassificationRank == 0) {
                        //         $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
                        //     } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                        //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
                        //     } else {
                        //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
                        //     }
                        // }

                        $getCategoryCode = collect(DB::select("
                            SELECT category_code, category_name
                            FROM amazon_category_code
                            WHERE " . $whereCategoryCode . "
                            ORDER BY LENGTH(category_name) ASC
                            LIMIT 1;
                        "))->first();

                        if ($getCategoryCode) {
                            $product->category_code_selected = $getCategoryCode ? $getCategoryCode->category_code : '0-0';
                            $product->category_name_selected = $getCategoryCode ? $getCategoryCode->category_name : '';
                        } else {
                            $product->category_code_selected = '0-0';
                            $product->category_name_selected = '';
                        }
                    } else {
                        $product->category_code_selected = '0-0';
                        $product->category_name_selected = '';
                    }
                }

                $getHistoryPrint = DB::table('barcode_print_history')->where('seller_sku', $product->SellerSku)->first();

                $product->history_print = null;
                if ($getHistoryPrint) {
                    // $utcTime = Carbon::createFromFormat('Y-m-d H:i:s', $getHistoryPrint->updated_at, 'UTC');
                    // $texasTime = $utcTime->setTimezone('America/Chicago');
                    // $product->history_print = $texasTime->format('m/d/Y H:i');
                    $product->history_print = date('m/d/Y H:i', strtotime($getHistoryPrint->updated_at));
                }
            }
        } else {
            $products = DB::table('amazon_table')->where('id', $id)->get();
            $getClassificationRankFirst = collect(DB::select("
                select JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].title')) as classificationRank, 
                JSON_UNQUOTE(JSON_EXTRACT(Classifications, '$[0].displayName')) as classification
                from amazon_table 
                where id = ?
            ", [$id]))->first();

            $classificationRankExtract = $this->extractWords($getClassificationRankFirst->classificationRank, 10); // up to 10 words                    
            if (!empty($classificationRankExtract)) {
                $whereCategoryCode = '';
                foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                    # code...
                    if (strtolower($classificationRank) == 'childrens') {
                        $classificationRank = "children\'s";
                    } else if (strtolower($classificationRank) == 'mens') {
                        $classificationRank = "men\'s";
                    }
                    $classificationRank = strtolower($classificationRank);
                    if ($keyClassificationRank == 0) {
                        $whereCategoryCode .= "(lower(category_name) LIKE '%" . $classificationRank . "%'";
                    } else if (count($classificationRankExtract) != ($keyClassificationRank + 1)) {
                        $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%'";
                    } else {
                        $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%')";
                    }
                    if (count($classificationRankExtract) == 1) {
                        $whereCategoryCode .= ")";
                    }
                }

                // foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                //     # code...
                //     if($keyClassificationRank == 0) {
                //         $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
                //     } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
                //     } else {
                //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
                //     }
                // }

                $getCategoryCode = collect(DB::select("
                    SELECT category_code, category_name
                    FROM amazon_category_code
                    WHERE " . $whereCategoryCode . "
                    ORDER BY LENGTH(category_name) ASC
                    LIMIT 1;
                "))->first();


                if ($getCategoryCode) {
                    $products[0]->category_code_selected = $getCategoryCode ? $getCategoryCode->category_code : '0-0';
                    $products[0]->category_name_selected = $getCategoryCode ? $getCategoryCode->category_name : '';
                } else {
                    $classificationRankExtract = $this->extractWords($getClassificationRankFirst->classification, 10); // up to 10 words                                        
                    if (!empty($classificationRankExtract)) {
                        $whereCategoryCode = '';
                        foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                            # code...
                            if (strtolower($classificationRank) == 'childrens') {
                                $classificationRank = "children\'s";
                            } else if (strtolower($classificationRank) == 'mens') {
                                $classificationRank = "men\'s";
                            }
                            $classificationRank = strtolower($classificationRank);
                            if ($keyClassificationRank == 0) {
                                $whereCategoryCode .= "(lower(category_name) LIKE '%" . $classificationRank . "%'";
                            } else if (count($classificationRankExtract) != ($keyClassificationRank + 1)) {
                                $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%'";
                            } else {
                                $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%')";
                            }

                            if (count($classificationRankExtract) == 1) {
                                $whereCategoryCode .= ")";
                            }
                        }
                        // foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                        //     # code...
                        //     if($keyClassificationRank == 0) {
                        //         $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
                        //     } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                        //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
                        //     } else {
                        //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
                        //     }
                        // }

                        $getCategoryCode = collect(DB::select("
                            SELECT category_code, category_name
                            FROM amazon_category_code
                            WHERE " . $whereCategoryCode . "
                            ORDER BY LENGTH(category_name) ASC
                            LIMIT 1;
                        "))->first();
                        if ($getCategoryCode) {
                            $products[0]->category_code_selected = $getCategoryCode ? $getCategoryCode->category_code : '0-0';
                            $products[0]->category_name_selected = $getCategoryCode ? $getCategoryCode->category_name : '';
                        } else {
                            $products[0]->category_code_selected = '0-0';
                            $products[0]->category_name_selected = '';
                        }
                    } else {
                        $products[0]->category_code_selected = '0-0';
                        $products[0]->category_name_selected = '';
                    }
                }
            } else {
                $classificationRankExtract = $this->extractWords($getClassificationRankFirst->classification, 10); // up to 10 words                                                        
                if (!empty($classificationRankExtract)) {
                    $whereCategoryCode = '';
                    foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                        # code...
                        if ($keyClassificationRank == 0) {
                            $whereCategoryCode .= "(lower(category_name) LIKE '%" . $classificationRank . "%'";
                        } else if (count($classificationRankExtract) != ($keyClassificationRank + 1)) {
                            $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%'";
                        } else {
                            $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%')";
                        }

                        if (count($classificationRankExtract) == 1) {
                            $whereCategoryCode .= ")";
                        }
                    }
                    // foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                    //     # code...
                    //     if($keyClassificationRank == 0) {
                    //         $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
                    //     } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                    //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
                    //     } else {
                    //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
                    //     }
                    // }

                    $getCategoryCode = collect(DB::select("
                        SELECT category_code, category_name
                        FROM amazon_category_code
                        WHERE " . $whereCategoryCode . "
                        ORDER BY LENGTH(category_name) ASC
                        LIMIT 1;
                    "))->first();

                    if ($getCategoryCode) {
                        $products[0]->category_code_selected = $getCategoryCode ? $getCategoryCode->category_code : '0-0';
                        $products[0]->category_name_selected = $getCategoryCode ? $getCategoryCode->category_name : '';
                    } else {
                        $products[0]->category_code_selected = '0-0';
                        $products[0]->category_name_selected = '';
                    }
                } else {
                    $products[0]->category_code_selected = '0-0';
                    $products[0]->category_name_selected = '';
                }
            }

            $getHistoryPrint = DB::table('barcode_print_history')->where('seller_sku', $products[0]->SellerSku)->first();
            $products[0]->history_print = null;
            if ($getHistoryPrint) {
                // $utcTime = Carbon::createFromFormat('Y-m-d H:i:s', $getHistoryPrint->updated_at, 'UTC');
                // $texasTime = $utcTime->setTimezone('America/Chicago');
                // $products[0]->history_print = $texasTime->format('m/d/Y H:i');
                $products[0]->history_print = date('m/d/Y H:i', strtotime($getHistoryPrint->updated_at));
            }
        }

        //get price groups
        $price_groups = [];
        if (! empty($purchase_id) || ! empty($product_id)) {
            $price_groups = SellingPriceGroup::where('business_id', $business_id)
                ->active()
                ->pluck('name', 'id');
        }

        $barcode_settings = Barcode::where('business_id', $business_id)
            ->orWhereNull('business_id')
            ->select(DB::raw('CONCAT(name, ", ", COALESCE(description, "")) as name, id, is_default'))
            ->get();
        $default = $barcode_settings->where('is_default', 1)->first();
        $barcode_settings = $barcode_settings->pluck('name', 'id');
        $information_labels = DB::table('information_labels')->get()->toArray();
        $category_code = DB::table("amazon_category_code")->orderBy(DB::raw("
            CAST(SUBSTRING_INDEX(category_code, '.', 1) AS UNSIGNED),
            CAST(SUBSTRING_INDEX(category_code, '.', -1) AS UNSIGNED)
        "))->get()->toArray();

        return view('business.partials.amazon_labels_show')
            ->with(compact('products', 'barcode_settings', 'default', 'price_groups', 'information_labels', 'category_code'));
    }

    public function labelsPreview(Request $request)
    {
        try {
            //code...                        
            $rule_based = $request->get('rule_based');
            $products = $request->get('products');

            $product_title = $request->get('product_title');
            $product_title = $product_title ? $product_title : '';

            $product_price = $request->get('product_price');
            $product_price = $product_price ? $product_price : 0;

            //Log::info('labelsPreview product_price:    '.$product_price);
            Log::info('labelsPreview products: ' . json_encode($products));
            $print = $request->get('print');
            //Log::info('labelsPreview print: '.json_encode($print));
            $barcode_setting = $request->get('barcode_setting');
            $business_id = $request->session()->get('user.business_id');
            $barcode_details = Barcode::find($barcode_setting);
            $barcode_details->stickers_in_one_sheet = $barcode_details->is_continuous ? $barcode_details->stickers_in_one_row : $barcode_details->stickers_in_one_sheet;
            $barcode_details->paper_height = $barcode_details->is_continuous ? $barcode_details->height : $barcode_details->paper_height;
            if ($barcode_details->stickers_in_one_row == 1) {
                $barcode_details->col_distance = 0;
                $barcode_details->row_distance = 0;
            }
            // if($barcode_details->is_continuous){
            //     $barcode_details->row_distance = 0;
            // }            
            $business_name = $request->session()->get('business.name');

            $product_details_page_wise = [];
            $total_qty = 0;
            foreach ($products as $value) {
                Log::info('labelsPreview value: ' . json_encode($value));
                // $details = Keepa::find($value['product_id']);
                DB::table('print_labels_queue')->where('reference_id', $value['product_id'])->where('reference_table', 'amazon_table')->delete();
                $details = AmazonTable::find($value['product_id']);
                //Log::info('labelsPreview seller_sku: '.$details->seller_sku);                
                // $product_title = DB::table('amazon_table')
                //     ->where('SellerSku', $details->seller_sku)
                //     ->value('Title');
                // $getClassificationRankFirst = collect(DB::select("
                //     select JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].title')) as classificationRank
                //     from amazon_table 
                //     where id = ?
                // ", [$value['product_id']]))->first();
                // $classificationRankExtract = $this->extractWords($getClassificationRankFirst->classificationRank, 10); // up to 10 words                

                // if(!empty($classificationRankExtract)) {
                //     $whereCategoryCode = '';
                //     foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                //         # code...
                //         if($keyClassificationRank == 0) {
                //             $whereCategoryCode .= "(lower(category_name) LIKE '%".$classificationRank."%'";
                //         } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                //             $whereCategoryCode .= " AND lower(category_name) LIKE '%".$classificationRank."%'";
                //         } else {
                //             $whereCategoryCode .= " AND lower(category_name) LIKE '%".$classificationRank."%')";
                //         }
                //     }
                //     foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                //         # code...
                //         if($keyClassificationRank == 0) {
                //             $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
                //         } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                //             $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
                //         } else {
                //             $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
                //         }
                //     }

                //     $getCategoryCode = collect(DB::select("
                //         SELECT category_code, category_name
                //         FROM amazon_category_code
                //         WHERE ".$whereCategoryCode."
                //         ORDER BY LENGTH(category_name) ASC
                //         LIMIT 1;
                //     "))->first();

                //     $details->category_code = $getCategoryCode->category_code;
                // } else {
                //     $details->category_code = '0-0';
                // }

                if (! empty($value['exp_date'])) {
                    $details->exp_date = $value['exp_date'];
                }
                if (! empty($value['packing_date'])) {
                    $details->packing_date = $value['packing_date'];
                }
                if (! empty($value['lot_number'])) {
                    $details->lot_number = $value['lot_number'];
                }

                $details->product_title = $value['product_title'];
                $details->category_code = explode('|', $value['category_code'])[0];
                // $details->product_price = $product_price;
                if ($rule_based == 'true') {
                    // $data = [
                    //     ['value' => '.20', 'price' => 2.99],
                    //     ['value' => '.40', 'price' => 4.99],
                    //     ['value' => '.70', 'price' => 7.99],
                    //     ['value' => '.90', 'price' => 9.99],
                    //     ['value' => '.12', 'price' => 12.99],
                    //     ['value' => '.14', 'price' => 14.99],
                    // ];
                    $data = DB::table('rule_base_print_settings')->get();
                    $explode_price = explode('.', $value['price']);
                    $price = $value['price'];
                    foreach ($data as $k => $p) {
                        # code...
                        $compare_price = explode('.', $p->decimal_point);
                        if (count($explode_price) > 1) {
                            if ('.' . str_pad($compare_price[1], 2, '0', STR_PAD_RIGHT) == '.' . $explode_price[1]) {
                                $price = $p->price_on_print_label;
                            }
                        }
                    }
                    $details->product_price = $price;
                } else {
                    $details->product_price = $value['price'];
                }

                if ($request->get('labels_checked')) {
                    AmazonTable::where('id', $value['product_id'])->update([
                        'label_price' => $details->product_price
                    ]);
                }

                if (DB::table('barcode_print_history')->where('seller_sku', $details->SellerSku)->exists()) {
                    DB::table('barcode_print_history')->where('seller_sku', $details->SellerSku)->update([
                        'category_code' => str_replace('|', ' - ', $value['category_code']),
                        'label_price' => $details->product_price,
                        'updated_at' => Carbon::now('America/Chicago')
                    ]);
                } else {
                    DB::table('barcode_print_history')->insert([
                        'seller_sku' => $details->SellerSku,
                        'product_title' => $value['product_title'],
                        'category_code' => str_replace('|', ' - ', $value['category_code']),
                        'label_price' => $details->product_price,
                        'user_id' => auth()->user()->id,
                        'created_at' => Carbon::now('America/Chicago'),
                        'updated_at' => Carbon::now('America/Chicago'),
                    ]);
                }

                $details->barcode_type = 'C128';

                Log::info('labelsPreview details: ' . json_encode($details));

                for ($i = 0; $i < $value['quantity']; $i++) {
                    $page = intdiv($total_qty, $barcode_details->stickers_in_one_sheet);

                    if ($total_qty % $barcode_details->stickers_in_one_sheet == 0) {
                        $product_details_page_wise[$page] = [];
                    }

                    $product_details_page_wise[$page][] = $details;
                    $total_qty++;
                }
            }
            $margin_top = $barcode_details->is_continuous ? 0 : $barcode_details->top_margin * 1;
            $margin_left = $barcode_details->is_continuous ? 0 : $barcode_details->left_margin * 1;
            $paper_width = $barcode_details->paper_width * 1;
            $paper_height = $barcode_details->paper_height * 1;

            $i = 0;
            $len = count($product_details_page_wise);
            $is_first = false;
            $is_last = false;

            //$original_aspect_ratio = 4;//(w/h)
            $factor = (($barcode_details->width / $barcode_details->height)) / ($barcode_details->is_continuous ? 2 : 4);
            $html = '';
            foreach ($product_details_page_wise as $page => $page_products) {
                if ($i == 0) {
                    $is_first = true;
                }

                if ($i == $len - 1) {
                    $is_last = true;
                }

                $output = view('business.partials.amazon_labels_preview')
                    ->with(compact('print', 'page_products', 'business_name', 'barcode_details', 'margin_top', 'margin_left', 'paper_width', 'paper_height', 'is_first', 'is_last', 'factor'))->render();
                print_r($output);

                // return view('business.partials.amazon_labels_preview')
                //             ->with(compact('print', 'page_products', 'business_name', 'barcode_details', 'margin_top', 'margin_left', 'paper_width', 'paper_height', 'is_first', 'is_last', 'factor'));
                //$mpdf->WriteHTML($output);

                // if($i < $len - 1){
                //     // '', '', '', '', '', '', $margin_left, $margin_left, $margin_top, $margin_top, '', '', '', '', '', '', 0, 0, 0, 0, '', [$barcode_details->paper_width*1, $barcode_details->paper_height*1]
                //     $mpdf->AddPage();
                // }

                $i++;
            }

            print_r('<script>window.print()</script>');
            exit;
        } catch (\Exception $e) {
            //throw $th;
            // \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = __('lang_v1.barcode_label_error');
            return $output . ' ' . $e->getMessage() . ' ' . $e->getLine();
        }
    }

    function extractWords($string, $count = null)
    {
        // Safety: Check for empty or non-string input
        if (!is_string($string) || trim($string) === '') {
            return []; // or return '', depending on your use case
        }

        // Remove all parenthesis content, e.g., (Books), (Movies & TV), etc.
        // $string = str_replace('(Books)', '', $string);
        $string = preg_replace('/\([^)]*\)/', '', $string);

        // Clean unwanted characters (keep letters, numbers, spaces)
        $clean = preg_replace('/[^\p{L}\p{N}\s]/u', '', $string);

        // Split into words
        $words = preg_split('/\s+/', trim($clean));

        // Remove empty values just in case
        $words = array_filter($words);

        // Handle no valid words found
        if (empty($words)) {
            return []; // or return '', depending on what you need
        }

        // Limit the number of words if requested
        if ($count !== null) {
            $words = array_slice($words, 0, $count);
        }

        return $words;
    }

    public function updateListingModal($store, $sku, $title, Request $request)
    {
        try {
            $type = $request->type;
            $old_qty = $request->old_qty;
            $old_price = $request->old_price;
            $old_condition = $request->old_condition;
            return view('business.partials.update_listing_quantity')->with(compact(
                'store',
                'sku',
                'title',
                'old_qty',
                'old_price',
                'old_condition',
                'type',
            ));
        } catch (\Exception $e) {
            Log::emergency('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
        }
    }

    public function popupSelectedItems(Request $request)
    {
        try {
            //code...
            $selected_rows = $request->selected_rows;
            $seller_id = $request->seller_id;

            $data = AmazonTable::select("id", "ASIN", "Title", "SellerSku", "Price", "CurrentQty")->whereIn('id', $selected_rows)->get()->toArray();

            return view('business.partials.popup_selected_items')->with(compact(
                'data',
                'seller_id',
            ));
        } catch (\Exception $e) {
            //throw $th;
            // Log::emergency('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
            return response()->json('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
        }
    }

    public function popupFindInAmazon(Request $request)
    {
        try {
            //code...            
            return view('business.partials.popup_find_in_amazon');
        } catch (\Exception $e) {
            //throw $th;
            // Log::emergency('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
            return response()->json('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
        }
    }

    public function updateOnAllAmazon(Request $request)
    {
        try {
            //code...
            $products = $request->products;
            $seller_id = $request->seller_id;
            $quantity = [];
            $price = [];
            $results = [];
            if (!empty($products)) {
                foreach ($products as $product) {
                    # code...
                    if ($product['old_quantity'] != $product['quantity']) {
                        $quantity[] = $this->updateSellerListingQuantity($request, $seller_id, $product['sku'], $product['quantity']);
                        sleep(2);
                    }
                    if ($product['old_price'] != $product['price']) {
                        $price[] = $this->updateSellerListingPrice($request, $seller_id, $product['sku'], $product['price']);
                        sleep(2);
                    }
                }
                array_push($results, $quantity);
                array_push($results, $price);
                return response()->json([
                    'rc' => 200,
                    'msg' => 'Successfully update products',
                    'results' =>  $results
                ]);
            } else {
                return response()->json([
                    'rc' => 500,
                    'msg' => 'Data not found!'
                ]);
            }
        } catch (\Exception $e) {
            //throw $th;
            return response()->json([
                'rc' => 500,
                'msg' => 'File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage()
            ]);
        }
    }

    public function createCompetitiveSummaryToDb(Request $request)
    {
        $check_credits = $this->check_or_create_ai_credit_transactions($request->all(), 'api', 'VH-AI Competitive Prices');

        if ($check_credits != 'continue') {
            return response()->json(['error' => $check_credits]);
        }

        $competitiveSummary = $this->getCompetitiveSummary($request->seller_id, $request->asin);

        CompetitivePrices::where('seller_id', $request->seller_id)->where('asin', $request->asin)->delete();
        if (!empty($competitiveSummary)) {
            CompetitivePrices::create([
                'seller_id' => $request->seller_id,
                'asin' => $request->asin,
                'new_prices' => json_encode($competitiveSummary['newOffers']),
                'used_prices' => json_encode($competitiveSummary['usedOffers']),
            ]);

            return response()->json(['message' => 'Competitive Prices created successfully!']);
        } else {
            return response()->json(['message' => 'Competitive Prices data not found!']);
        }
    }

    public function fetchProductDetails($asin)
    {
        // $products = $this->amazonService->getProducts();
        // return response()->json($products);
        //$marketplaceId = 'ATVPDKIKX0DER,A2EUQ1WTGCTBG2'; // Example Marketplace ID
        //$sku = 'example_sku'; // Replace with the actual SKU
        //$asin = 'B00006HAZ4'; // Replace with the actual ASIN

        //$response = $this->amazonService->fetchProductDetails($sku, null, $marketplaceId); // Using SKU
        // Or
        $response = $this->amazonService->fetchProductDetails($asin); // Using ASIN
        dd($response); // Dump and die to inspect the response
    }



    //
    public function auth(Request $request)
    {

        $this->product_locations = array($request->input('product_locations'));
        $product_locations = array($request->input('product_locations'));
        if (empty($product_locations)) {
            return response()->json([
                'message' => 'Location must be selected',
                'data' => null
            ]);
        }

        $this->checkmarks = $request->input('checkmarks');
        $checkmarks = $request->input('checkmarks');
        // dd($checkmarks);
        if (empty($checkmarks)) {
            return response()->json([
                'message' => 'Please Selected Sync Item First',
                'data' => null
            ]);
        }

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('marketplace_settings')->first();

        $array_response = [
            'rc' => 200,
            'msg' => null
        ];

        $marketplace_settings = json_decode($business->marketplace_settings);
        if ($marketplace_settings->amazon_api_url && $marketplace_settings->amazon_api_access_token && $marketplace_settings->amazon_api_key && $marketplace_settings->amazon_api_secret) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $AMAZON_URL = $marketplace_settings->amazon_api_url;
            // $AMAZON_CRED = getenv("AMAZON_CRED");        
            $AMAZON_CRED = $marketplace_settings->amazon_api_access_token;
            $AMAZON_ID = $marketplace_settings->amazon_api_key;
            $AMAZON_KEY = $marketplace_settings->amazon_api_secret;
        } else {
            $AMAZON_URL = 'https://23.96.106.223:9091/api';
        }

        try {
            //code...
            $msg = null;

            $data = $this->get_data($AMAZON_URL, 'A2NODI4BBRA1B1');
            $products = $this->save_products($data, 'A2NODI4BBRA1B1', 'USED BOOK DEPOT');
            if ($products['rc'] == 200) {
                $msg = 'USED BOOK DEPOT Success';
            } else {
                $msg = 'USED BOOK DEPOT Data not found';
            }
            if ($products['rc'] == 200) {
                // $json_data2 = file_get_contents(public_path('A7YLKH07FY1LY.txt')); 
                // $data2 = json_decode($json_data2);
                $data2 = $this->get_data($AMAZON_URL, 'A7YLKH07FY1LY');
                $products2 = $this->save_products($data2, 'A7YLKH07FY1LY', 'The Art of Savings');
                if ($products2['rc'] == 200) {
                    $msg .= ', The Art of Savings Success';
                } else {
                    $msg .= ', The Art of Savings Data not found';
                }
                if ($products['rc'] == 200) {
                    // $json_data3 = file_get_contents(public_path('A13Y3JSUKFVTQ5.txt')); 
                    // $data3 = json_decode($json_data3);
                    $data3 = $this->get_data($AMAZON_URL, 'A13Y3JSUKFVTQ5');
                    $products3 = $this->save_products($data3, 'A13Y3JSUKFVTQ5', 'Pharos Bookstore');
                    if ($products3['rc'] == 200) {
                        $msg .= ', Pharos Bookstore Success';
                    } else {
                        $msg .= ', Pharos Bookstore Data not found';
                    }
                }
            }

            $array_response['msg'] = $msg;
            $body['amazon_checkbox'] = json_encode($checkmarks);
            $business = Business::find($business_id);
            $business->fill($body);
            $business->save();
            if ($array_response['rc'] == 200) {
                return response()->json([
                    'message' => 'Recevied Data ' . $msg,
                    'data' => null
                ]);
            } else {
                return response()->json([
                    'message' => 'Data Not Found',
                    'data' => null
                ]);
            }
        } catch (\Exception $err) {
            //throw $th;
            return response()->json([
                'message' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        }
    }

    public function get_data($url, $seller_id)
    {
        $ch = curl_init();

        // curl_setopt($ch, CURLOPT_URL, $url.'/inventory/sellerid='.$seller_id);        
        curl_setopt($ch, CURLOPT_URL, 'https://23.96.106.223:9091/api/Inventory?sellerid=' . $seller_id);
        curl_setopt($ch, CURLOPT_ENCODING, "");
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = 'Content-Type: application/json';

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        return json_decode($result, true);
    }

    public function save_products($data, $seller_id, $name)
    {
        DB::beginTransaction();
        $business_id = request()->session()->get('user.business_id');
        $business = Business::find($business_id);
        $amazon_checkbox = json_decode($business->amazon_checkbox);
        $checkmarks_arr = [];
        foreach ($amazon_checkbox as $key => $val) {
            array_push($checkmarks_arr, $val->value);
        }
        /* $checkProductLocation = Product::join('variation_location_details as vld', 'vld.product_id', '=', 'products.id')
            ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id')
            ->whereNotNull('products.amazon_id')
            ->where('products.amazon_seller_id', $seller_id)
            ->select('products.id', 'products.name', 'bl.id as location_id', 'vld.variation_id')
            ->first();
        if(!empty($checkProductLocation)) {
            $deleteTransactions = DB::select("delete transactions from transactions join products on products.id = transactions.opening_stock_product_id and transactions.location_id = ? where products.amazon_id is not null", [$checkProductLocation->location_id]);                    
            $deleteVariationLocationDetails = DB::select("delete variation_location_details from variation_location_details join products on products.id = variation_location_details.product_id and variation_location_details.location_id = ? where products.amazon_id is not null", [$checkProductLocation->location_id]);                  
            DB::select("delete purchase_lines from purchase_lines join products on products.id = purchase_lines.product_id where products.amazon_id is not null");          
            DB::select("delete product_locations from product_locations join products on products.id = product_locations.product_id where products.amazon_id is not null");          
            DB::select("delete variations from variations join products on products.id = variations.product_id where products.amazon_id is not null");          
            DB::select("delete from products where amazon_id is not null");
        } */

        if ($data) {
            $no = 0;
            $arr = [];
            $status = '';
            try {
                //code...
                foreach ($data as $key => $value) {
                    # code...
                    $checkProduct = Product::where('amazon_id', $value['productId'])->whereNull('shopify_id')->first();
                    if ($checkProduct == null) {
                        $product = new Product();
                        if (in_array("name", $checkmarks_arr)) {
                            $product->name = $value['name'];
                        }
                        if (in_array("sku", $checkmarks_arr)) {
                            $product->sku = $value['sku'];
                        }
                        if (in_array("barcode", $checkmarks_arr)) {
                            $product->barcode = $value['sku'];
                        }
                        $product->type = 'single';
                        if (in_array("product_description", $checkmarks_arr)) {
                            $product->product_description = $value['description'];
                        }
                        $product->amazon_id = $value['productId'];
                        $product->amazon_seller_id = $seller_id;
                        $product->amazon_name = $name;
                        $product->amazon_asin = $value['asin1'];
                        $product->business_id = $business_id;
                        $product->enable_stock = 1;
                        $product->created_by = auth()->user()->id;
                        $product->save();

                        $product_variation = new ProductVariation();
                        $product_variation->name = "Default";
                        $product_variation->product_id = $product->id;
                        $product_variation->is_dummy = 0;
                        $product_variation->save();

                        $variation = new Variation();
                        $variation->name = 'Variation';
                        $variation->sub_sku = $value['sku'];
                        $variation->product_id = $product->id;
                        $variation->product_variation_id = $product_variation->id;
                        if (in_array('default_sell_price', $checkmarks_arr)) {
                            $variation->default_sell_price = $value['price'];
                            $variation->sell_price_inc_tax = $value['price'];
                        }
                        $variation->save();

                        $vld = new VariationLocationDetails();
                        $vld->product_id = $product->id;
                        $vld->product_variation_id = $product_variation->id;
                        $vld->variation_id = $variation->id;
                        $vld->location_id = 1;
                        $vld->qty_available = $value['quantity'];
                        $vld->save();

                        $transaction = new Transaction();
                        $transaction->business_id = $business_id;
                        $transaction->location_id = 1;
                        $transaction->type = 'opening_stock';
                        $transaction->status = 'received';
                        $transaction->is_quotation = 0;
                        $transaction->payment_status = 'paid';
                        $transaction->transaction_date = Carbon::now();
                        $transaction->total_before_tax = 0;
                        $transaction->tax_amount = 0;
                        $transaction->discount_amount = 0;
                        $transaction->rp_redeemed = 0;
                        $transaction->rp_redeemed_amount = 0;
                        $transaction->shipping_charges = 0;
                        $transaction->is_export = 0;
                        $transaction->round_off_amount = 0;
                        $transaction->additional_expense_value_1 = 0;
                        $transaction->additional_expense_value_2 = 0;
                        $transaction->additional_expense_value_3 = 0;
                        $transaction->additional_expense_value_4 = 0;
                        $transaction->final_total = 0;
                        $transaction->is_direct_sale = 0;
                        $transaction->is_suspend = 0;
                        $transaction->exchange_rate = 1;
                        $transaction->opening_stock_product_id = $product->id;
                        $transaction->created_by = auth()->user()->id;
                        $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                        $transaction->is_created_from_api = 1;
                        $transaction->rp_earned = 0;
                        $transaction->is_recurring = 0;

                        $transaction->save();

                        $purchase_lines = new PurchaseLine();
                        $purchase_lines->transaction_id = $transaction->id;
                        $purchase_lines->product_id = $product->id;
                        $purchase_lines->variation_id = $variation->id;
                        $purchase_lines->quantity = $value['quantity'];
                        $purchase_lines->purchase_price = 0;
                        $purchase_lines->save();
                    } else {
                        $product = Product::find($checkProduct->id);
                        if (in_array("name", $checkmarks_arr)) {
                            $product->name = $value['name'];
                        }
                        if (in_array("sku", $checkmarks_arr)) {
                            $product->sku = $value['sku'];
                        }
                        if (in_array("barcode", $checkmarks_arr)) {
                            $product->barcode = $value['sku'];
                        }
                        if (in_array("product_description", $checkmarks_arr)) {
                            $product->product_description = $value['description'];
                        }
                        // $product->name = $value['name'];
                        // $product->sku = $value['sku'];
                        $product->type = 'single';
                        // $product->product_description = $value['description'];
                        $product->amazon_id = $value['productId'];
                        $product->amazon_seller_id = $seller_id;
                        $product->amazon_name = $name;
                        $product->amazon_asin = $value['asin1'];
                        $product->business_id = $business_id;
                        $product->enable_stock = 1;
                        $product->created_by = auth()->user()->id;
                        $product->save();

                        $product_variation = ProductVariation::where('product_id', $product->id)->first();
                        $product_variation->name = "Default";
                        $product_variation->product_id = $product->id;
                        $product_variation->is_dummy = 0;
                        $product_variation->save();

                        $variation = Variation::where('product_id', $product->id)->where('product_variation_id', $product_variation->id)->first();
                        $variation->name = 'Variation';
                        $variation->sub_sku = $value['sku'];
                        $variation->product_id = $product->id;
                        $variation->product_variation_id = $product_variation->id;
                        if (in_array('default_sell_price', $checkmarks_arr)) {
                            $variation->default_sell_price = $value['price'];
                            $variation->sell_price_inc_tax = $value['price'];
                        }
                        $variation->save();

                        $vld = VariationLocationDetails::where('product_id', $product->id)->where('product_variation_id', $product_variation->id)->where('variation_id', $variation->id)->first();
                        $vld->product_id = $product->id;
                        $vld->product_variation_id = $product_variation->id;
                        $vld->variation_id = $variation->id;
                        $vld->location_id = 1;
                        $vld->qty_available = $value['quantity'];
                        $vld->save();

                        $purchase_lines = PurchaseLine::where('product_id', $product->id)->where('variation_id', $variation->id)->first();
                        $purchase_lines->product_id = $product->id;
                        $purchase_lines->variation_id = $variation->id;
                        $purchase_lines->quantity = $value['quantity'];
                        $purchase_lines->purchase_price = 0;
                        $purchase_lines->save();
                    }
                }
                DB::commit();
                return [
                    'rc' => 200,
                    'msg' => "Success"
                ];
            } catch (\Throwable $th) {
                //throw $th;                
                DB::rollBack();
                return [
                    'rc' => 500,
                    'msg' => "Something went wrong"
                ];
            }
        } else {
            return [
                'rc' => 500,
                'msg' => "Data not found"
            ];
        }
    }

    public function update_products($data, $seller_id, $name)
    {

        $business_id = request()->session()->get('user.business_id');
        /*
        if($data) {
            DB::beginTransaction();
            try {
                // UPDATE Queries
                DB::commit();
                return [
                    'rc' => 200,
                    'msg' => "Success"
                ];
            } catch (Exception $th) {
                DB::rollBack();
                return [
                    'rc' => 500,
                    'msg' => $th->getMessage()
                ];
            }   
            DB::commit();         
        }  else {        
            return [
                'rc' => 500,
                'msg' => "Data not found"
            ];   
        }
        */
    }

    public function syncWithEcommerce(Request $request, $seller_id)
    {
        $data = $request->all();
        // $seller_id = $request->get('seller_id');        
        $business_id = auth()->user()->business_id;
        $business = Business::find($business_id);
        $e_commerce = json_decode($business->e_commerce_settings);
        $e_commerce_settings = json_decode($business->e_commerce_settings);
        // dd($e_commerce);
        $default_e_commerce = '';
        if ($e_commerce->big_commerce_enable == 1) {
            $default_e_commerce = 'bigcommerce';
        } else if ($e_commerce->shopify_enable == 1) {
            $default_e_commerce = 'shopify';
        } else if ($e_commerce->woo_commerce_enable) {
            $default_e_commerce = 'woocomerrce';
        }
        $amazon_option = json_decode($business->amazon_option);
        $create_option = false;
        $update_option = false;
        if ($amazon_option) {
            if (property_exists($amazon_option, 'second_option')) {
                if (!empty($amazon_option->second_option)) {
                    foreach ($amazon_option->second_option as $key => $value) {
                        # code...
                        if ($value == '21') {
                            $create_option = true;
                        } else if ($value == '24') {
                            $update_option = true;
                        }
                    }
                }
            }
        }

        if (!empty($data)) {

            $product_insert_array = [];
            $product_update_array = [];
            $set_product_shopify_insert_array = [];
            $set_product_shopify_update_array = [];
            $inventory_item_id = null;
            $location_id = null;
            $available = null;
            $message = [];

            foreach ($data as $key => $value) {
                // this is for demo or other servers except server ubd
                // $prd = Product::where('sku', $value['sku'])->where('shopify_id', $value['productId'])->first();
                $prd = Product::where('sku', $value['sku'])->whereNotNull('amazon_id')->first();
                // this is for server udb
                // $prd = Product::where('sku', $value['sku'])->where('used_book_id', $value['productId'])->orWhere('cheap_book_id', $value['productId])->first();

                if ($prd == null) {
                    array_push($product_insert_array, $value);
                    // array_push($message,  [
                    //     'type' => 'Insert',
                    //     'product' => $value['sku']
                    // ]);
                } else {
                    array_push($product_update_array, $value);
                    // array_push($message,  [
                    //     'type' => 'Update',
                    //     'product' => $value['sku']
                    // ]);
                }

                $prd_shopify = Product::where('sku', $value['sku'])->whereNotNull('shopify_id')->first();
                // dd($prd, $prd_shopify);
                if ($prd_shopify == null) {
                    if ($create_option) {
                        array_push($set_product_shopify_insert_array, [
                            'id' => $value['productId'],
                            'title' => $value['name'],
                            "body_html" => $value['description'],
                            "vendor" => null,
                            "product_type" => null,
                            "created_at" => date('Y-m-dTH:i:s'),
                            "handle" => null,
                            "updated_at" => date('Y-m-dTH:i:s'),
                            "published_at" => null,
                            "template_suffix" => null,
                            "status" => "active",
                            "published_scope" => "web",
                            "tags" => "",
                            "admin_graphql_api_id" => "gid://shopify/Product/" . $value['productId'],
                            "variants" => [
                                [
                                    "id" => $value['listingId'],
                                    "product_id" => $value['productId'],
                                    "title" => "Default Title",
                                    "price" => $value['price'],
                                    "sku" => $value['sku'],
                                    "position" => 1,
                                    "inventory_policy" => "deny",
                                    "compare_at_price" => null,
                                    "fulfillment_service" => "manual",
                                    "inventory_management" => "shopify",
                                    "option1" => "Default Title",
                                    "option2" => null,
                                    "option3" => null,
                                    "created_at" => date('Y-m-dTH:i:s'),
                                    "updated_at" => date('Y-m-dTH:i:s'),
                                    "taxable" => true,
                                    "barcode" => null,
                                    "grams" => 0,
                                    "image_id" => null,
                                    "weight" => 0,
                                    "weight_unit" => "lb",
                                    "inventory_item_id" => $value['listingId'],
                                    "inventory_quantity" => $value['quantity'],
                                    "old_inventory_quantity" => $value['quantity'],
                                    "presentment_prices" => [
                                        "price" => [
                                            "amount" => $value['price'],
                                            "currency_code" => "USD"
                                        ],
                                        "compare_at_price" => null
                                    ],
                                    "requires_shipping" => true,
                                    "admin_graphql_api_id" => "gid://shopify/ProductVariant/" . $value["listingId"]
                                ]
                            ],
                            "options" => [
                                [
                                    "id" => $value['listingId'],
                                    "product_id" => $value['productId'],
                                    "name" => "Title",
                                    "position" => 1,
                                    "values" => [
                                        "Default Title"
                                    ]
                                ]
                            ],
                            "images" => [],
                            "image" => null
                        ]);
                    }
                } else {
                    if ($update_option) {
                        $get_product = $this->productUtil->getDetalProductShopify($prd_shopify->shopify_id, $e_commerce_settings);
                        $inventory_item_id = $get_product['variants'][0]['inventory_item_id'];
                        $available = $value['quantity'];
                        $get_location = $this->productUtil->getInventoryLevelsShopify($inventory_item_id, $e_commerce_settings);
                        if (!empty($get_location)) {
                            $location_id = $get_location[0]['location_id'];
                        }
                        array_push($set_product_shopify_update_array, [
                            'id' => $prd_shopify->shopify_id,
                            'title' => $value['name'],
                            "body_html" => $value['description'],
                            "vendor" => $get_product['vendor'],
                            "product_type" => $get_product['product_type'],
                            "created_at" => date('Y-m-dTH:i:s'),
                            "handle" => $get_product['handle'],
                            "updated_at" => date('Y-m-dTH:i:s'),
                            "published_at" => $get_product['published_at'],
                            "template_suffix" => $get_product['template_suffix'],
                            "status" => "active",
                            "published_scope" => "web",
                            "tags" => $get_product['tags'],
                            "admin_graphql_api_id" => "gid://shopify/Product/" . $prd_shopify->shopify_id,
                            "variants" => [
                                [
                                    "id" => $get_product['variants'][0]['id'],
                                    "product_id" => $prd_shopify->shopify_id,
                                    "title" => "Default Title",
                                    "price" => $value['price'],
                                    "sku" => $value['sku'],
                                    "position" => 1,
                                    "inventory_policy" => "deny",
                                    "compare_at_price" => $get_product['variants'][0]['compare_at_price'],
                                    "fulfillment_service" => "manual",
                                    "inventory_management" => "shopify",
                                    "option1" => "Default Title",
                                    "option2" => $get_product['variants'][0]['option2'],
                                    "option3" => $get_product['variants'][0]['option3'],
                                    "created_at" => date('Y-m-dTH:i:s'),
                                    "updated_at" => date('Y-m-dTH:i:s'),
                                    "taxable" => true,
                                    "barcode" => $value['sku'],
                                    "grams" => $get_product['variants'][0]['grams'],
                                    "image_id" => $get_product['variants'][0]['image_id'],
                                    "weight" => $get_product['variants'][0]['weight'],
                                    "weight_unit" => "lb",
                                    "inventory_item_id" => $get_product['variants'][0]['inventory_item_id'],
                                    "inventory_quantity" => $value['quantity'],
                                    "old_inventory_quantity" => $get_product['variants'][0]['old_inventory_quantity'],
                                    "presentment_prices" => [
                                        "price" => [
                                            "amount" => $value['price'],
                                            "currency_code" => "USD"
                                        ],
                                        "compare_at_price" => null
                                    ],
                                    "requires_shipping" => true,
                                    "admin_graphql_api_id" => "gid://shopify/ProductVariant/" . $get_product['variants'][0]['id']
                                ]
                            ],
                            "options" => [
                                [
                                    "id" => $get_product['options'][0]['id'],
                                    "product_id" => $prd_shopify->shopify_id,
                                    "name" => "Title",
                                    "position" => 1,
                                    "values" => [
                                        "Default Title"
                                    ]
                                ]
                            ],
                            "images" => $get_product['images'],
                            "image" => $get_product['image'],
                            "inventory_item_id" => $get_product['variants'][0]['inventory_item_id'],
                            "location_id" => $location_id,
                            "available" => $value['quantity'],
                        ]);
                    }
                }
            }

            // dd('seller_id: '.$seller_id, $product_insert_array, $product_update_array);

            if (!empty($product_insert_array)) {
                $this->save_products($product_insert_array, $seller_id, null);
            }

            if (!empty($product_update_array)) {
                $this->save_products($product_update_array, $seller_id, null);
            }

            $checkmarks = [["name" => "checkmarks_amazon[]", "value" => "name"], ["name" => "checkmarks_amazon[]", "value" => "product_description"], ["name" => "checkmarks_amazon[]", "value" => "category_id"], ["name" => "checkmarks_amazon[]", "value" => "brand_id"], ["name" => "checkmarks_amazon[]", "value" => "sku"], ["name" => "checkmarks_amazon[]", "value" => "barcode"], ["name" => "checkmarks_amazon[]", "value" => "default_sell_price"]];
            if (!empty($set_product_shopify_insert_array)) { //INSERT NEW PRODUCTS
                if ($create_option) {
                    // except ubd
                    // $this->shopify->saveProducts($set_product_shopify_insert_array, null, [1], $checkmarks, $request);
                    $this->shopify->createUpdateProducts($request, $set_product_shopify_insert_array, 'create');

                    // for ubd
                    // $this->shopify_udb->saveProducts($set_product_shopify_insert_array, null, [1], $checkmarks, $request->store, $request);
                    // $this->shopify_udb->createUpdateProducts($request, $set_product_shopify_insert_array, 'create');
                }
            }

            if (!empty($set_product_shopify_update_array)) { //UPDATE PRODUCTS
                if ($update_option) {
                    // $this->shopify->saveProducts($set_product_shopify_update_array, null, [1], $checkmarks, $request);
                    $this->shopify->createUpdateProducts($request, $set_product_shopify_update_array, 'update');
                }
            }


            $insert_count = count($product_insert_array);
            $update_count = count($product_update_array);


            return response([
                'product_inserted' => $insert_count,
                'product_updated' => $update_count
            ], 200);
        } else {
            return response([
                'message' => 'Data not found'
            ], 500);
        }
    }


    public function checkDashboard($sellerId, Request $request)
    {
        $check_data = AmazonDashboardData::where('seller_id', $sellerId)
            ->select("amazon_dashboard_data.*", DB::raw("DATE_FORMAT(updated_at, '%Y-%m-%d %H:%i') as updated_at_format, DATE_FORMAT(updated_at, '%Y-%m-%d') as last_date_updated_at"))->orderBy('id', 'desc')->first();
        if ($check_data) {
            return response()->json([
                'performance_metrics' => json_decode($check_data->performance_metrics),
                'inventory_metrics' => json_decode($check_data->inventory_metrics),
                'updated_at' => $check_data->updated_at_format,
                'last_date_updated_at' => $check_data->last_date_updated_at,
                'coming_from' => 'database'
            ]);
        } else {
            $performance_metrics = $this->requestSellerPerformanceReport($sellerId, $request);
            if (array_key_exists('error', $performance_metrics->original)) {
                $performance_metrics_json = $performance_metrics->original;
            } else {
                AmazonDashboardData::where('seller_id', $sellerId)->delete();

                AmazonDashboardData::create([
                    'seller_id' => $sellerId,
                    'performance_metrics' => json_encode($performance_metrics->original)
                ]);
                $performance_metrics_json = $performance_metrics->original;
            }

            return response()->json([
                'performance_metrics' => $performance_metrics_json,
                'inventory_metrics' => null,
                'updated_at' => date('Y-m-d H:i:s'),
                'last_date_updated_at' => date('Y-m-d'),
                'coming_from' => 'api'
            ]);
        }
    }

    public function check_or_create_ai_credit_transactions($data, $transaction_type, $descripition)
    {
        $get_last_credit = AiCreditTransactions::whereIn('transaction_type', ['purchase', 'usage'])->orderBy('id', 'desc')->first();
        if ($get_last_credit) {
            if ($get_last_credit->remaining_credits >= ($data['credit'] * -1)) {
                $ai_credit_transaction = new AiCreditTransactions();
                $ai_credit_transaction->user_id = auth()->user()->id;
                $ai_credit_transaction->transaction_type = 'usage';
                $ai_credit_transaction->credits = $data['credit'];
                $ai_credit_transaction->remaining_credits = $get_last_credit->remaining_credits + $data['credit'];
                $ai_credit_transaction->description = $descripition;
                $ai_credit_transaction->save();

                return 'continue';
            } else {
                return 'Doesn\'t have enough credits for using this transaction';
            }
        } else {
            return 'Doesn\'t have enough credits for using this transaction';
        }
    }

    public function checkJobStatus()
    {
        $job = DB::table('jobs')->count();
        if ($job > 0) {
            if ($this->DEBUG_MODE) Log::info("jobs still processing.");
            return response()->json([
                'status' => 'processing'
            ]);
        } else {
            if ($this->DEBUG_MODE) Log::info("jobs completed.");
            return response()->json([
                'status' => 'completed'
            ]);
        }
    }

    public function checkSyncProgress()
    {
        $progressRequestInventoryReport = Cache::get('requestInventoryReport');
        $requestInventoryReportTotal = 0;
        $requestInventoryReportComplete = 0;
        if ($progressRequestInventoryReport) {
            $requestInventoryReportTotal = $progressRequestInventoryReport['total'];
            $requestInventoryReportComplete = $progressRequestInventoryReport['completed'];
        }
        $progressupdateAmazonTable = Cache::get('updateAmazonTable');
        $updateAmazonTableTotal = 0;
        $updateAmazonTableComplete = 0;
        if ($progressupdateAmazonTable) {
            $updateAmazonTableTotal = $progressupdateAmazonTable['total'];
            $updateAmazonTableComplete = $progressupdateAmazonTable['completed'];
            if ($progressupdateAmazonTable['completed'] >= $progressupdateAmazonTable['total']) {
                DB::select("
                    UPDATE amazon_table a
                    LEFT JOIN amazon_seller_inventories asi
                    ON a.ASIN = asi.asin AND a.SellerSku = asi.seller_sku
                    SET a.status = 'deleted'
                    WHERE asi.id IS NULL;
                ");
                Cache::forget('requestInventoryReport');
                Cache::forget('updateAmazonTable');
            }
        }

        return response()->json([
            'requestInventoryReportTotal' => $requestInventoryReportTotal,
            'requestInventoryReportComplete' => $requestInventoryReportComplete,
            'updateAmazonTableTotal' => $updateAmazonTableTotal,
            'updateAmazonTableComplete' => $updateAmazonTableComplete,
        ]);
    }

    public function addProgressTest()
    {
        if (!Cache::has('requestInventoryReport')) {
            Cache::put('requestInventoryReport', [
                'completed' => 0,
                'total' => 3,
            ], now()->addMinutes(30));
        }
        $current = Cache::get("requestInventoryReport");
        $current['completed']++;
        Cache::put("requestInventoryReport", $current, now()->addMinutes(30));
        if ($current['completed'] >= $current['total']) {
            if (!Cache::has('updateAmazonTable')) {
                Cache::put('updateAmazonTable', [
                    'completed' => 0,
                    'total' => 35,
                ], now()->addMinutes(30));
            }

            $current = Cache::get("updateAmazonTable");
            $current['completed']++;
            Cache::put("updateAmazonTable", $current, now()->addMinutes(30));

            if ($current['completed'] >= $current['total']) {
                Cache::forget('requestInventoryReport');
                Cache::forget('updateAmazonTable');
            }
        }

        return response()->json([
            'cache1' => json_encode(Cache::get('requestInventoryReport')),
            'cache2' => json_encode(Cache::get('updateAmazonTable')),
        ]);
    }

    public function createAmazonProduct(Request $request)
    {
        $amazon_sellers = DB::table('amazon_sellers')->pluck('seller_name', 'seller_id');
        $amazon_product_binding = DB::table('amazon_product_binding')->pluck('name', 'name');
        $amazon_product_group = DB::table('amazon_product_group')->pluck('name', DB::raw("CONCAT(recommended_browse_node,'-', xml_tag, '-', name)"));
        $amazon_product_types = DB::table('amazon_product_types')->limit(30)->pluck('display_name', 'name');
        $amazon_product_item_type = DB::table('amazon_product_item_type')->pluck('name', 'name');
        $classifications = collect(DB::select("
            SELECT jt.displayName as id, jt.displayName as text
            FROM amazon_table AS t,
            JSON_TABLE(
            t.classifications,
            '$[*]'
            COLUMNS (
                displayName VARCHAR(255) PATH '$.displayName'
            )
            ) AS jt
            GROUP BY jt.displayName
            ORDER BY jt.displayName
            LIMIT 10
        "))->map(function ($item) {
            return [
                'id' => $item->id,
                'text' => htmlspecialchars($item->text, ENT_QUOTES, 'UTF-8')
            ];
        });
        $itemCondition = [
            'New' => 'NEW',
            'UsedLikeNew' => 'USED_LIKE_NEW',
            'UsedVeryGood' => 'USED_VERY_GOOD',
            'UsedGood' => 'USED_GOOD',
            'UsedAcceptable' => 'USED_ACCEPTABLE',
            'CollectibleLikeNew' => 'COLLECTIBLE_LIKE_NEW*',
            'CollectibleVeryGood' => 'COLLECTIBLE_VERY_GOOD*',
            'CollectibleGood' => 'COLLECTIBLE_GOOD*',
            'CollectibleAcceptable' => 'COLLECTIBLE_ACCEPTABLE*',
            'Refurbished' => 'REFURBISHED',
            'Club' => 'CLUB',
        ];
        return view('business.partials.amazon_create_product')->with(compact(
            'amazon_sellers',
            'amazon_product_binding',
            'itemCondition',
            'amazon_product_group',
            'amazon_product_types',
            'amazon_product_item_type',
            'classifications'
        ));
    }

    public function createNewAmazonProductFeed(Request $request)
    {
        $data = DB::table('amazon_table')->where('id', 105674)->first();
        $identifiers = json_decode($data->Identifiers);
        $identifiers = json_decode($identifiers);
        $isbn = null;
        if ($identifiers) {
            if ($identifiers[0]->identifiers) {
                foreach ($identifiers[0]->identifiers as $identifier) {
                    if ($identifier->identifierType == 'EAN') {
                        $isbn = $identifier->identifier;
                    }
                }
            }
        }

        $launchdate = date('Y-m-dTH:i:s', strtotime($data->created_at));
        $store = $data->store;
        $sku = $data->SellerSku;
        $title = $data->Title;
        $brand = $data->Brand ? $data->Brand : 'Unbranded';
        $description = $data->description;
        $bullet_points = json_decode($data->BulletPoints);
        $manufacturer = $data->Manufacturer;
        $price = $data->AmazonSellerInventoryPrice;
        $itemTypeKeyword = $data->ItemTypeKeyword;
        $binding = $data->Binding;
        $pages = $data->Pages;
        $product_group = json_decode($data->DisplayGroupRanks);
        if ($product_group) {
            $title_product_group = $product_group[0]->title;
            $explode_title_product_group = explode('-', $title_product_group);
            $product_group_choosen = null;
            $recommended_browse_node_choosen = null;
            $xml_tag_product_group_choosen = null;
            if (count($explode_title_product_group) > 1) {
                $product_group_choosen = $explode_title_product_group[2];
                $xml_tag_product_group_choosen = $explode_title_product_group[1];
                $close_xml_tag_product_group_choosen = str_replace("<", "</", $explode_title_product_group[1]);
                $recommended_browse_node_choosen = $explode_title_product_group[0];
            }
        }
        $isAdultProduct = $data->is_adult_product == 0 ? 'false' : 'true';
        $condition = $data->ItemCondition;
        $image = json_decode($data->Images);
        $mainImage = null;
        if ($image) {
            $mainImage = $image[0]->link;
        }
        $productType = $data->ProductTypes;
        $product_type_tag = '<Books>';
        $product_type_close_tag = '</Books>';
        if ($productType) {
            $product_type_tag = '<' . $data->ProductTypes . '>';
            $product_type_close_tag = str_replace("<", "</", $product_type_tag);
        }
        $author = $data->Authors;
        $publication_date = $data->PublicationDate ? $data->PublicationDate : date('Y-m-d', strtotime($launchdate));
        $languages = $data->Languages;

        $xmlContent = <<<XML
        <?xml version="1.0" encoding="UTF-8"?>
        <AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                        xsi:noNamespaceSchemaLocation="amznenvelope.xsd">
            <Header>
                <DocumentVersion>1.01</DocumentVersion>
                <MerchantIdentifier>$store</MerchantIdentifier>
            </Header>
            <MessageType>Product</MessageType>
            <Message>
                <MessageID>1</MessageID>
                <OperationType>Update</OperationType>
                <Product>
                    <SKU>$sku</SKU>

                    <StandardProductID>
                        <Type>ISBN</Type>
                        <Value>$isbn</Value> <!-- ISBN-13 -->
                    </StandardProductID>

                    <ProductTaxCode>A_GEN_NOTAX</ProductTaxCode>

                    <LaunchDate>$launchdate</LaunchDate>

                    <DescriptionData>
                        <Title>$title</Title>
                        <Brand>$brand</Brand>
                        <Description>$description</Description>
        XML;
        if ($bullet_points) {
            foreach ($bullet_points as $bp) {
                $xmlContent .= <<<XML
                    <BulletPoint>$bp</BulletPoint>                                
                XML;
            }
        }
        $xmlContent .= <<<XML
                        <Manufacturer>$manufacturer</Manufacturer>
                        <Publisher>$manufacturer</Publisher>
                        <MSRP currency="USD">$price</MSRP>
                        <ItemType>$itemTypeKeyword</ItemType>
                        <Binding>$binding</Binding>
                        <NumberOfPages>$pages</NumberOfPages>
                        <ProductGroup>$product_group_choosen</ProductGroup>
                        <RecommendedBrowseNode>$recommended_browse_node_choosen</RecommendedBrowseNode> <!-- Example node for Books -->
                        <IsAdultProduct>$isAdultProduct</IsAdultProduct>
                        <Condition>$condition</Condition>
                        <ItemCondition>$condition</ItemCondition>

                        <!-- Images -->
                        <MainImage>
                            <URL>$mainImage</URL>
                        </MainImage>
                    </DescriptionData>

                    <ProductData>
                        $xml_tag_product_group_choosen
                            <ProductType>
                                $product_type_tag
                                    <Author>$author</Author>
                                    <Binding>$binding</Binding>
                                    <NumberOfPages>$pages</NumberOfPages>
                                    <PublicationDate>$publication_date</PublicationDate>
                                    <Manufacturer>$manufacturer</Manufacturer>
                                    <Language>
                                        <Name>$languages</Name>
                                        <Type>Published</Type>
                                    </Language>\n
        XML;

        $classifications = json_decode($data->Classifications);
        if ($classifications) {
            $xmlContent .= <<<XML
                <Classifications>\n
            XML;
            foreach ($classifications as $classification) {
                # code...
                $classificationName = $classification->displayName;
                $xmlContent .= <<<XML
                    <Audience>$classificationName</Audience>\n                                       
                XML;
            }
            $xmlContent .= <<<XML
                </Classifications>\n
            XML;
        }

        $subjects = json_decode($data->Subjects);
        if ($subjects) {
            foreach ($subjects as $key => $subject) {
                # code...
                if (!empty($subject) && !preg_match('/^_+$/', $subject)) {
                    $xmlContent .= <<<XML
                        <Subject>$subject</Subject>\n
                    XML;
                }
            }
        }

        $xmlContent .= <<<XML
                                $product_type_close_tag
                            </ProductType>
                        $close_xml_tag_product_group_choosen
                    </ProductData>
                </Product>
            </Message>
        </AmazonEnvelope>
        XML;

        $refreshToken = DB::table('amazon_sellers')->where('seller_id', $data->store)->value('refresh_token');
        if (!$refreshToken) {
            if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $data->store);
            return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
        }

        $config = new SellingPartnerApi(
            clientId: env('SP_API_CLIENT_ID'),
            clientSecret: env('SP_API_CLIENT_SECRET'),
            refreshToken: $refreshToken,
            endpoint: Endpoint::NA
        );

        $feedsApi = new FeedsApi($config);

        // Step 1: Create Feed Document
        $response = $feedsApi->createFeedDocument(
            new \SellingPartnerApi\Seller\FeedsV20210630\Dto\CreateFeedDocumentSpecification('text/xml; charset=UTF-8')
        );

        $documentResponse = json_decode($response, true);

        return $documentResponse;

        if ($this->DEBUG_MODE) Log::info('document response: ');
        if ($this->DEBUG_MODE) Log::info($documentResponse);

        $feedDocumentId = $documentResponse['feedDocumentId'];
        $uploadUrl = $documentResponse['url'];

        // Step 2: Upload XML to Amazon
        $client = new Client();
        $response = $client->put($uploadUrl, [
            'headers' => ['Content-Type' => 'text/xml; charset=UTF-8'],
            'body' => $xmlContent,
        ]);

        $statusCode = $response->getStatusCode();
        if ($statusCode != 200) {
            Log::error('Upload failed with status code: ' . $statusCode);
            Log::error('Response body: ' . (string) $response->getBody());
            Log::error('Response body: ' . (string) $response->getBody());
        } else {
            Log::info('Upload successful.');
        }


        // Step 3: Submit Feed
        $feedResponse = $feedsApi->createFeed(
            new \SellingPartnerApi\Seller\FeedsV20210630\Dto\CreateFeedSpecification(
                'POST_PRODUCT_DATA',
                [env('AMAZON_MARKETPLACE_ID')],
                $feedDocumentId,
            )
        );

        if ($this->DEBUG_MODE) Log::info('create a feed response: ');
        if ($this->DEBUG_MODE) Log::info($feedResponse);

        return $feedResponse;
    }

    public function getFeedStatus($feedId, $sellerId)
    {
        $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
        if (!$refreshToken) {
            if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
            return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
        }

        $config = new SellingPartnerApi(
            clientId: env('SP_API_CLIENT_ID'),
            clientSecret: env('SP_API_CLIENT_SECRET'),
            refreshToken: $refreshToken,
            endpoint: Endpoint::NA,
        );

        $feedsApi = new FeedsApi($config);

        $result = $feedsApi->getFeed($feedId);

        return $result->json();
    }

    public function getAllProductTypes($sellerId)
    {
        $refreshToken = DB::table('amazon_sellers')->where('seller_id', $sellerId)->value('refresh_token');
        if (!$refreshToken) {
            if ($this->DEBUG_MODE) Log::error('Failed to retrieve refresh token for seller ID: ' . $sellerId);
            return response()->json(['error' => 'Failed to retrieve refresh token'], 500);
        }

        $config = new SellingPartnerApi(
            clientId: env('SP_API_CLIENT_ID'),
            clientSecret: env('SP_API_CLIENT_SECRET'),
            refreshToken: $refreshToken,
            endpoint: Endpoint::NA,
        );


        $api = new ProductTypeDefinitionsApi($config);

        $result = $api->searchDefinitionsProductTypes([env('AMAZON_MARKETPLACE_ID')]);
        $data = $result->json();
        if (!empty($data['productTypes'])) {
            $productTypesArray = [];
            foreach ($data['productTypes'] as $key => $value) {
                # code...           
                array_push($productTypesArray, [
                    'name' => $value['name'],
                    'display_name' => $value['displayName'],
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s')
                ]);
            }
            DB::table('amazon_product_types')->insert($productTypesArray);
            return response()->json(['message' => "Save product types to database"]);
        } else {
            return response()->json(['message' => "Product types not found"]);
        }
    }

    public function getListingItems($sellerId)
    {
        $accessToken = $this->checkAmazonAccessToken($sellerId);
        if (!$accessToken) {
            return ['error' => 'Failed to get access token'];
        }
        $response = Http::withHeaders([
            'x-amz-access-token' => $accessToken,
        ])->get("https://sellingpartnerapi-na.amazon.com/listings/2021-08-01/items/" . $sellerId . "?marketplaceIds=ATVPDKIKX0DER");
        $data = json_decode($response->body(), true);
        return $data;
    }

    public function SearchClassification(Request $request)
    {
        $term = $request->q;
        $classifications = collect(DB::select("
            SELECT jt.displayName as id, jt.displayName as text
            FROM amazon_table AS t,
            JSON_TABLE(
            t.classifications,
            '$[*]'
            COLUMNS (
                displayName VARCHAR(255) PATH '$.displayName'
            )
            ) AS jt
            WHERE jt.displayName like '%$term%'
            GROUP BY jt.displayName
            ORDER BY jt.displayName
            LIMIT 10
        "))->map(function ($item) {
            return [
                'id' => $item->id,
                'text' => htmlspecialchars($item->text, ENT_QUOTES, 'UTF-8')
            ];
        });

        return response()->json($classifications);
    }

    public function SearchProductTypes(Request $request)
    {
        $term = $request->q;
        $results = DB::table('amazon_product_types')->where('display_name', 'like', "%$term%")
            ->select('name as id', 'display_name as text')
            ->limit(30)
            ->get();

        return response()->json($results);
    }

    public function StoreProduct(Request $request)
    {
        try {
            //code...
            $dimensions = [
                'width' => [],
                'height' => [],
                'length' => []
            ];
            if ($request->width) {
                $dimensions['width'] = [
                    'unit' => 'inches',
                    'value' => $request->width
                ];
            }
            if ($request->height) {
                $dimensions['height'] = [
                    'unit' => 'inches',
                    'value' => $request->height
                ];
            }
            if ($request->length) {
                $dimensions['length'] = [
                    'unit' => 'inches',
                    'value' => $request->length
                ];
            }

            $identifiers = json_decode($request->identifiers);

            $image = null;
            if ($request->hasFile('image')) {
                $dimensions = getimagesize($request->file('image')->getRealPath());
                $width = $dimensions[0];
                $height = $dimensions[1];

                // Buat URL akses publik
                $path = $request->file('image')->store('images', 'public');
                $url = asset(Storage::url($path));
                $image = [
                    [
                        'variant' => 'MAIN',
                        'link' => $url,
                        'height' => $height,
                        'width' => $width
                    ]
                ];

                $image = json_encode($image);
            }

            $classificationsArray = [];
            if ($request->classifications) {
                foreach ($request->classifications as $key => $value) {
                    # code...
                    if ($value) {
                        array_push($classificationsArray, [
                            'displayName' => $value
                        ]);
                    }
                }

                $classifications = json_encode($classificationsArray);
            } else {
                $classifications = json_encode([]);
            }

            $displayGroupRanks = [];
            if ($request->product_group) {
                array_push($displayGroupRanks, [
                    'title' => $request->product_group
                ]);
            }

            DB::beginTransaction();
            foreach ($request->store as $key => $store) {
                # code...
                $formattedProduct = [
                    'store' => $store,
                    'ASIN' => $request->asin,
                    'Title' => $request->title,
                    'Subjects' => json_encode($request->subjects),
                    'Binding' => $request->binding,
                    'Languages' => $request->languages,
                    'Format' => $request->format,
                    'ItemTypeKeyword' => $request->itemTypeKeyword,
                    'Composer' => $request->composer,
                    'PublicationDate' => $request->publication_date,
                    'Pages' => $request->number_of_pages,
                    'BulletPoints' => json_encode($request->bullet_points),
                    'Dimensions' => json_encode($dimensions),
                    'Brand' => $request->brand,
                    'TargetAudience' => $request->target_audience,
                    'Manufacturer' => $request->manufacturer,
                    'Price' => $request->price . ' USD',
                    'Authors' => $request->author,
                    'Genre' => json_encode([]),
                    'Identifiers' => json_encode($request->identifiers),
                    'Images' => $image,
                    'ProductTypes' => $request->product_type,
                    'Classifications' => $classifications,
                    'ClassificationRanks' => json_encode([]),
                    'DisplayGroupRanks' => json_encode($displayGroupRanks),
                    'ItemCondition' => $request->condition,
                    'CurrentQty' => $request->qty,
                    'AmazonSellerInventoryPrice' => $request->price,
                    'SellerSku' => $request->sku,
                    'description' => $request->product_description,
                    'status' => $request->status,
                    'is_adult_product' => $request->is_adult_product,
                ];
                AmazonTable::create($formattedProduct);
            }
            DB::commit();
            $output = [
                'success' => 1,
                'msg' => __('product.product_added_success'),
            ];
            return redirect('marketplace-integration')->with('status', $output);
        } catch (\Exception $e) {
            //throw $th;
            DB::rollBack();
            \Log::emergency('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());

            $output = [
                'success' => 0,
                // 'msg' => __('messages.something_went_wrong'),
                'msg' => 'Line:' . $e->getLine() . 'Message:' . $e->getMessage(),
            ];

            return redirect('e-commerce-integration')->with('status', $output);
        }
    }

    public function getProductsList()
    {
        if (request()->ajax()) {            
            $search_term = request()->input('term', '');
            $location_id = request()->input('location_id', null);
            $check_qty = request()->input('check_qty', true) == 'false' ? false : true;            
            $price_group_id = request()->input('price_group', null);
            $business_id = request()->session()->get('user.business_id');
            $not_for_selling = request()->get('not_for_selling', null);
            $price_group_id = request()->input('price_group', '');
            $product_types = request()->get('product_types', []);
            
            $search_fields = request()->get('search_fields', ['name', 'sku']);
            if (in_array('sku', $search_fields)) {
                $search_fields[] = 'sub_sku';
            }

            $result = $this->productUtil->filterProductAmazon($business_id, $search_term, $location_id, $not_for_selling, $price_group_id, $product_types, $search_fields, $check_qty);                        
            // dd($result);
            return json_encode($result);
        }
    }
}
