<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\User;
use Illuminate\Support\Facades\Log;
use DB;

class ApiController extends Controller
{
    //
    public function login(Request $request)
    {   
        $user = User::where('username', $request->username)->first();

        if (! $user) {     
            return response()->json(['message' => 'Invalid credentials'], 401);
        }

        if (! \Hash::check($request->password, $user->password)) {            
            return response()->json(['message' => 'Invalid credentials'], 401);
        }

        $user->tokens()->delete(); // delete all previous tokens
        $token = $user->createToken('api-token')->plainTextToken;

        return response()->json([
            'access_token' => $token,
            'token_type' => 'Bearer',
        ]);
    }

    public function getGraphImageKeepa($asin)
    {
        return app('App\Services\KeepaService')->getGraphImage($asin);
        // return response($response->body(), 200, [
        //     'Content-Type' => $response->header('Content-Type'),
        //     'Content-Disposition' => 'inline; filename="keepa_graph.png"',
        // ]);
        // $graphImage = base64_encode($response->getContent());
        
        // if($graphImage) {
        //     $graphImage = 'data:image/png;base64,'.$graphImage;
        // } else {
        //     $graphImage = '';
        // }
        // return response()->json([
        //     'graphImage' => $graphImage,
        // ]);
    }

    public function submit_data(Request $request)
    {
        if($request->type) {
            if($request->type == 'vhbookz_scan') {
                if($request->ISBN) {
                    $amazon_seller = DB::table('amazon_sellers')->select('seller_id')->first();
                    $check_on_table = DB::select("
                        select *
                        from amazon_table
                        where (case 
                            when ASCII(LEFT(amazon_table.ASIN, 1)) BETWEEN 65 AND 90
                            OR ASCII(LEFT(amazon_table.ASIN, 1)) BETWEEN 97 AND 122 then amazon_table.ASIN
                            else CONCAT('978', LEFT(amazon_table.ASIN, 9), 
                            MOD(10 - MOD(
                                (9 * 1) +  -- '9' from '978' prefix
                                (7 * 3) +  -- '7' from '978' prefix
                                (8 * 1) +  -- '8' from '978' prefix
                                (SUBSTRING(amazon_table.ASIN, 1, 1) * 3) + 
                                (SUBSTRING(amazon_table.ASIN, 2, 1) * 1) + 
                                (SUBSTRING(amazon_table.ASIN, 3, 1) * 3) + 
                                (SUBSTRING(amazon_table.ASIN, 4, 1) * 1) + 
                                (SUBSTRING(amazon_table.ASIN, 5, 1) * 3) + 
                                (SUBSTRING(amazon_table.ASIN, 6, 1) * 1) + 
                                (SUBSTRING(amazon_table.ASIN, 7, 1) * 3) + 
                                (SUBSTRING(amazon_table.ASIN, 8, 1) * 1) + 
                                (SUBSTRING(amazon_table.ASIN, 9, 1) * 3),
                            10), 10)
                        ) end) = ?
                    ", [$request->ISBN]);

                    if(!empty($check_on_table)) {       
                        $classificationRanksDecode = json_decode($check_on_table[0]->ClassificationRanks);
                        $imagesDecode = json_decode($check_on_table[0]->Images);
                        $authorsDecode = json_decode($check_on_table[0]->Authors);

                        $authors = '';
                        if(!empty($authorsDecode)) {
                            foreach($authorsDecode as $author) {
                                $authors.= $author.' ';
                            }
                        }

                        $image = '';
                        if(!empty($imagesDecode)) {
                            $image = $imagesDecode[0]->link;
                        }
                        
                        $salesRank = 0;
                        $category = '';
                        if(!empty($classificationRanksDecode)) {
                            $salesRank = $classificationRanksDecode[0]->rank;
                            $category = $classificationRanksDecode[0]->title;
                        }
                        return response()->json([
                            'title' => $check_on_table[0]->Title,
                            'author' => $authors,
                            'image' => $image,
                            'category' => $category,
                            'salesRank' => $salesRank,
                        ]);
                    } else {                        
                        # code...                            
                        $request->merge(['credit' => 0]);
                        $response = app(AmazonController::class)->getProductDetailByISBN($request->ISBN, $amazon_seller->seller_id, $request);
//                      $response_keepa = app(AmazonController::class)->getGraphImageKeepaByISBN($request->ISBN);
                        
                        $result = json_decode($response->getContent(), true);
                        //$result_keepa = json_decode($response_keepa->getContent(), true);
                        //Log::info('result keepa: '.json_encode($result_keepa));
                        
                        if(!empty($result)) {
                            if(array_key_exists('errors', $result)) {
                                return $result;
                            } else if($result['items']) {
                                $items = $result['items'][0];
                                $price = '';
                                if(!empty($items['attributes']['list_price'])) {
                                    $price = $items['attributes']['list_price'][0]['value'];
                                }
                                $authors = '';
                                if(!empty($items['attributes']['author'])) {
                                    foreach ($items['attributes']['author'] as $author) {
                                        # code...
                                        $authors = $author['value'].' ';
                                    }
                                }
                                $image = '';
                                if(!empty($items['images'])) {
                                    if(!empty($items['images'][0]['images'])) {
                                        $image = $items['images'][0]['images'][0]['link'];
                                    }
                                }

                                $category = '';
                                $salesRank = 0;
                                if(!empty($items['salesRanks'])) {
                                    if(!empty($items['salesRanks'][0]['classificationRanks'])) {
                                        $category = $items['salesRanks'][0]['classificationRanks'][0]['title'];
                                        $salesRank = $items['salesRanks'][0]['classificationRanks'][0]['rank'];
                                    }
                                }

                                // Log::info('items[asin]: '.$items['asin']);
                                // $getGraphImageKeepa = app(AmazonController::class)->getGraphImageKeepa($items['asin']);
                                // $graphImage = $graphImage = base64_encode($getGraphImageKeepa->getContent());
                                
                                // if($graphImage) {
                                //     $graphImage = 'data:image/png;base64,'.$graphImage;
                                // } else {
                                //     $graphImage = '';
                                // }
                                // Log::info('graphImage: '.$graphImage);

                                return response()->json([
                                    'title' => $items['summaries'][0]['itemName'],
                                    'author' => $authors,
                                    'image' => $image,
                                    'category' => $category,
                                    'salesRank' => $salesRank,
                                    'price' => $price,
                                    'asin' => $items['asin'],
                                ]);                                                        
                            }                                           
                        } else {
                            return response()->json([
                                'result' => 'Your Request Has Been Received'
                            ]);
                        }
                    }
                } else {
                    return response()->json([
                        'result' => 'Your Request Has Been Received'
                    ]);
                }
            } else {
                return response()->json([
                    'result' => 'Your Request Has Been Received'
                ]);
            }
        } else {
            return response()->json([
                'result' => 'Your Request Has Been Received'
            ]);
        }
    }

    public function logout(Request $request)
    {
        $request->user()->currentAccessToken()->delete();

        return response()->json([
            'message' => 'Logged out successfully',
        ]);
    }
}
