<?php

namespace App\Http\Controllers;

use App\BrandBigcommerce;
use App\Brands;
use App\Business;
use App\Category;
use App\CategoryBigcommerce;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\Transaction;
use App\Variation;
use App\VariationLocationDetails;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BigCommerceController extends Controller
{
    // get all product
    public function auth(Request $request) 
    {        
        // dd($request->all());
        $product_locations = array($request->input('product_locations'));                
        if(empty($product_locations)) {
            return response()->json([
                'message' => 'Location must be selected',
                'data' => null
            ]);
        }
        $checkmarks = $request->input('checkmarks');
        if(empty($checkmarks)) {
            return response()->json([
                'message' => 'Please Selected Sync Item First',
                'data' => null
            ]);
        }
        $array_empty = [];
        $array_insert = [];
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

        $e_commerce_settings = json_decode($business->e_commerce_settings);

        if($e_commerce_settings->big_commerce_api_url && $e_commerce_settings->big_commerce_api_access_token) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $BIGCOMMERCE_URL = $e_commerce_settings->big_commerce_api_url;
            // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
            $BIGCOMMERCE_CRED = $e_commerce_settings->big_commerce_api_access_token;        
          } else {
            return 'Url and Access Token Big Commerce Not Found';
          }
        // $BIGCOMMERCE_URL = 'https://api.bigcommerce.com/stores/101aucvlze/v3/catalog/products';
        // $BIGCOMMERCE_CRED = 'gt99sc2cnssvyd8bubndz29jimtuw5w';
        try {
            //code...
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                CURLOPT_URL => $BIGCOMMERCE_URL . '/catalog/products?limit=200',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "Accept: application/json",
                    "Content-Type: application/json",
                    "X-Auth-Token: " . $BIGCOMMERCE_CRED
                )
            
                )
            );           

            $response = curl_exec($curl);

            if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                print_r($error_msg);
                // $log = fopen('../sample/sresult.json','a');
                // fwrite($log,"\ncurl_error81\n");
                // fclose($log);
            }

            $parsedResponse = json_decode($response);
            // dd($parsedResponse);            
            $products = json_decode(json_encode($parsedResponse->data), true);
            // var_dump($BIGCOMMERCE_URL.'?limit=5&page='.$parsedResponse->meta->pagination->current_page);

            // return $products;
            $responseSaveProducts = $this->saveProducts($products, $product_locations, $array_empty, $checkmarks);
            // dd($responseSaveProducts);
            // return $responseSaveProducts;
            array_push($array_insert, $responseSaveProducts);
            // var_dump($responseSaveProducts);                  
            // array_push($array_insert, $responseSaveProducts);
            $no = 1;
            if($parsedResponse) {
                while ($parsedResponse->meta->pagination->current_page !== $parsedResponse->meta->pagination->total_pages) 
                {
                //   var_dump($parsedResponse->meta->pagination->current_page, $parsedResponse->meta->pagination->total_pages);
                  curl_setopt($curl, CURLOPT_URL, $BIGCOMMERCE_URL.'/catalog/products?limit=200&page='.($parsedResponse->meta->pagination->current_page+1));
                  $parsedResponse->products = [];
                  $nextPage = NULL;
                //   var_dump($BIGCOMMERCE_URL.'?limit=5&page='.($parsedResponse->meta->pagination->current_page + 1));
      
                  $response = curl_exec($curl);
                  $parsedResponse = json_decode($response);
                  
                  if (curl_errno($curl)) {
                      $error_msg = curl_error($curl);
                      print_r($error_msg);
                    //   $log = fopen('../sample/sresult.json','a');
                    //   fwrite($log,"\ncurl_error102\n");
                    //   fclose($log);
                  } else {
                      //$result = array_merge($result, $parsedResponse->products);
                      $products = json_decode(json_encode($parsedResponse->data), true);
                      //echo "Product count : " . count($products) . "\n";                  
                      $responseSaveProducts = $this->saveProducts($products, $product_locations, $array_empty, $checkmarks);
                    //   var_dump($responseSaveProducts);                  
                      array_push($array_insert, $responseSaveProducts);
                    //   dd($array_empty, $array_empty[count($array_empty)-1]);
                      sleep(2);
                  }
                };
            }
  
            // curl_close($curl);                  
            $body['big_commerce_checkbox'] = json_encode($checkmarks);
            $business = Business::find($business_id);         
            $business->fill($body);
            $business->save();            
            if(is_array($array_insert)) {
                return response()->json([
                    'message' => 'Recevied Data Success',
                    'data' => $array_insert
                ]);
            } else {        
                return response()->json([
                    'message' => $array_insert,
                    'data' => null
                ]);
            }
            
            curl_close($curl);

        } catch (\Exception $err) {
            //throw $th;
            // return $err->getMessage();
            return response()->json([
                'message' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        }
    }

    public function saveProducts($products, $product_locations, $arr, $checkmarks)
    {        
        DB::beginTransaction();
        $business_id = request()->session()->get('user.business_id');        
        $checkProductLocation = Product::join('variation_location_details as vld', 'vld.product_id', '=', 'products.id')
        ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id')
        ->whereNotNull('products.big_commerce_id')
        ->select('products.id', 'products.name', 'bl.id as location_id', 'vld.variation_id')
        ->first();
        if(!empty($checkProductLocation) && $checkProductLocation->location_id != $product_locations[0]) {
            $deleteTransactions = DB::select("delete transactions from transactions join products on products.id = transactions.opening_stock_product_id and transactions.location_id = ? where products.big_commerce_id is not null", [$checkProductLocation->location_id]);                    
            $deleteVariationLocationDetails = DB::select("delete variation_location_details from variation_location_details join products on products.id = variation_location_details.product_id and variation_location_details.location_id = ? where products.big_commerce_id is not null", [$checkProductLocation->location_id]);                  
            DB::select("delete purchase_lines from purchase_lines join products on products.id = purchase_lines.product_id where products.big_commerce_id is not null");          
            DB::select("delete product_locations from product_locations join products on products.id = product_locations.product_id where products.big_commerce_id is not null");          
            DB::select("delete variations from variations join products on products.id = variations.product_id where products.big_commerce_id is not null");          
            DB::select("delete from products where big_commerce_id is not null");
        }
        if($products) {
            
            $no = 0;            
            $status = '';
            try {
                //code...
                foreach ($products as $key => $value) {
                    // dd($value);
                    # code...
                    $checkProduct = Product::where('big_commerce_id', $value['id'])->first();
                    $getBrandId = $value['brand_id'];
                    $getBrand = $this->getBrandAPI($getBrandId);
                    if($getBrand == 1) {
                        $idBrandBigCommerce = null;
                        $nameBrand = null;
                    } else {
                        $idBrandBigCommerce = $getBrand['data']['id'];
                        $nameBrand = $getBrand['data']['name'];
                    }
    
                    if($nameBrand) {
                        $checkBrand = Brands::whereRaw("lower(name) = ?", $nameBrand)->where('business_id', $business_id)->first();
                        if($checkBrand == null) {
                            $b = new Brands();
                            $b->business_id = $business_id;
                            $b->name = $nameBrand;
                            $b->description = null;
                            $b->created_by = auth()->user()->id;
                            $b->id = $idBrandBigCommerce;
                            $b->save();
    
                            $brandId = $b->id;
                        } else {                 
                            // $b = Brands::find($checkBrand->id);
                            // $b->big_commerce_id = $idBrandBigCommerce;
                            // $b->save();       
                            $brandId = $checkBrand->id;
                        }
                    } else {
                        $brandId = null;
                    }
                    // dd($value['categories'][0]);
                    $getCategoryId = $value['categories'][0];
                    $getCategory = $this->getCategoryAPI($getCategoryId);
                    if($getCategory == 1) {
                        $idCategoryBigCommerce = null;
                        $nameCategory = null;
                    } else {
                        $idCategoryBigCommerce = $getCategory['data']['id'];
                        $nameCategory = $getCategory['data']['name'];
                    }
                    // dd($getCategory);
                    if($nameCategory) {
                        $checkCategory = Category::whereRaw("lower(name) = ?", $nameCategory)->where('business_id', $business_id)->first();
                        // dd($checkCategory);
                        if($checkCategory == null) {
                            $c = new Category();
                            $c->name = $nameCategory;
                            $c->business_id = $business_id;
                            $c->parent_id = 0;
                            $c->created_by = auth()->user()->id;
                            $c->category_type = 'product';
                            $c->id = $idCategoryBigCommerce;
                            $c->save();
                            $categoryId = $c->id;
                        } else {  
                            // $c = Category::find($checkCategory->id);
                            // $c->big_commerce_id = $idCategoryBigCommerce;
                            // $c->save();
                            $categoryId = $checkCategory->id;
                        }
                    }  else {
                        $categoryId = null;
                    }
                    if($checkProduct == null) {
                        $getProductVariantId = $value['base_variant_id'];
                        $getProductVariant = $this->getProductVariantAPI($getProductVariantId, $value['id']);
                        $p = new Product();
                        $p->name = $value['name'];
                        $p->business_id = $business_id;
                        if($getProductVariant == 1) {
                            $p->type = 'single';
                        } else {
                            $p->type = 'variable';
                        }
                        $p->enable_stock = 1;
                        $p->tax_type = 'exclusive';
                        // $p->unit_id = $unitId;
                        $p->brand_id = $brandId;
                        $p->category_id = $categoryId;
                        $p->alert_quantity = 1;
                        $p->sku = $value['sku'] ? $value['sku'] : ' ';
                        $p->barcode = $value['sku'] ? $value['sku'] : ' ';
                        $p->created_by = auth()->user()->id;
                        $p->product_description = $value['description'];
                        $p->big_commerce_id = $value['id'];
                        $getImage = $this->getImageAPI($value['id']);
                        if($getImage) {
                            $p->image = $getImage[0]['url_standard'];
                        }
                        $p->save();
    
                        if(! empty($product_locations)) {
                            $p->product_locations()->sync($product_locations);
                        }
                        
                        // dd($getProductVariant);
                        if($getProductVariant == 1) {
                            $nameProductVariant = 'Default';
                            $variantSku = '';
                            $default_sell_price = 0;
                            $nameProductVariant = 'Default';
                            $variantSku = '';
                            // $default_sell_price = 0;
                            $pv = new ProductVariation();
                            $pv->name = $nameProductVariant;
                            $pv->product_id = $p->id;
                            $pv->is_dummy = 0;
                            $pv->created_at = Carbon::now();
                            $pv->save();
        
                            $v = new Variation();
                            $v->name = $nameProductVariant;
                            $v->product_id = $p->id;
                            $v->sub_sku = $variantSku;
                            $v->product_variation_id = $pv->id;
                            $v->default_sell_price = $value['price'] ? $value['price'] : $value['calculated_price'];
                            $v->sell_price_inc_tax = $value['price'] ? $value['price'] : $value['calculated_price'];
                            $v->save();
        
                            if(! empty($product_locations)) {
                                if(count($product_locations) > 1) {
                                    $qty_divide = $value['inventory_level'] / 1;
                                    foreach ($product_locations as $val) {
                                    # code...
                                    $vld = new VariationLocationDetails();
                                    $vld->product_id = $p->id;
                                    $vld->product_variation_id = $pv->id;
                                    $vld->variation_id = $v->id;
                                    $vld->location_id = $val;
                                    $vld->qty_available = $qty_divide;
                                    $vld->save();
        
                                    $transaction = new Transaction();
                                    $transaction->business_id = $business_id;
                                    $transaction->location_id = $val;
                                    $transaction->type = 'opening_stock';
                                    $transaction->status = 'received';
                                    $transaction->is_quotation = 0;
                                    $transaction->payment_status = 'paid';
                                    $transaction->transaction_date = Carbon::now();
                                    $transaction->total_before_tax = 0;
                                    $transaction->tax_amount = 0;
                                    $transaction->discount_amount = 0;
                                    $transaction->rp_redeemed = 0;
                                    $transaction->rp_redeemed_amount = 0;
                                    $transaction->shipping_charges = 0;
                                    $transaction->is_export = 0;
                                    $transaction->round_off_amount = 0;
                                    $transaction->additional_expense_value_1 = 0;
                                    $transaction->additional_expense_value_2 = 0;
                                    $transaction->additional_expense_value_3 = 0;
                                    $transaction->additional_expense_value_4 = 0;
                                    $transaction->final_total = 0;
                                    $transaction->is_direct_sale = 0;
                                    $transaction->is_suspend = 0;
                                    $transaction->exchange_rate = 1;
                                    $transaction->opening_stock_product_id = $p->id;
                                    $transaction->created_by = auth()->user()->id;
                                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                    $transaction->is_created_from_api = 1;
                                    $transaction->rp_earned = 0;
                                    $transaction->is_recurring = 0;
        
                                    $transaction->save();
        
                                    $purchase_lines = new PurchaseLine();
                                    $purchase_lines->transaction_id = $transaction->id;
                                    $purchase_lines->product_id = $p->id;
                                    $purchase_lines->variation_id = $v->id;
                                    $purchase_lines->quantity = $qty_divide;
                                    $purchase_lines->purchase_price = 0;
                                    $purchase_lines->save();
                                    }
                                } else {
                                    $vld = new VariationLocationDetails();
                                    $vld->product_id = $p->id;
                                    $vld->product_variation_id = $pv->id;
                                    $vld->variation_id = $v->id;
                                    $vld->location_id = $product_locations[0];
                                    $vld->qty_available = $value['inventory_level'];
                                    $vld->save();
        
                                    $transaction = new Transaction();
                                    $transaction->business_id = $business_id;
                                    $transaction->location_id = $product_locations[0];
                                    $transaction->type = 'opening_stock';
                                    $transaction->status = 'received';
                                    $transaction->is_quotation = 0;
                                    $transaction->payment_status = 'paid';
                                    $transaction->transaction_date = Carbon::now();
                                    $transaction->total_before_tax = 0;
                                    $transaction->tax_amount = 0;
                                    $transaction->discount_amount = 0;
                                    $transaction->rp_redeemed = 0;
                                    $transaction->rp_redeemed_amount = 0;
                                    $transaction->shipping_charges = 0;
                                    $transaction->is_export = 0;
                                    $transaction->round_off_amount = 0;
                                    $transaction->additional_expense_value_1 = 0;
                                    $transaction->additional_expense_value_2 = 0;
                                    $transaction->additional_expense_value_3 = 0;
                                    $transaction->additional_expense_value_4 = 0;
                                    $transaction->final_total = 0;
                                    $transaction->is_direct_sale = 0;
                                    $transaction->is_suspend = 0;
                                    $transaction->exchange_rate = 1;
                                    $transaction->opening_stock_product_id = $p->id;
                                    $transaction->created_by = auth()->user()->id;
                                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                    $transaction->is_created_from_api = 1;
                                    $transaction->rp_earned = 0;
                                    $transaction->is_recurring = 0;
        
                                    $transaction->save();
        
                                    $purchase_lines = new PurchaseLine();
                                    $purchase_lines->transaction_id = $transaction->id;
                                    $purchase_lines->product_id = $p->id;
                                    $purchase_lines->variation_id = $v->id;
                                    $purchase_lines->quantity = $value['inventory_level'];
                                    $purchase_lines->purchase_price = 0;
                                    $purchase_lines->save();
                                }
                            }
                        } else {
                            if($getProductVariant) {
                                foreach ($getProductVariant['data'] as $kVariant => $vVariant) {
                                    # code...
                                    if($vVariant['option_values']) {
                                        // dd($getProductVariant['data'][0]);
                                        $nameProductVariant = '';
                                        foreach ($vVariant['option_values'] as $kOption => $vOption) {
                                            # code...
                                            if($vOption['option_id'] === '108') {
                                                $nameProductVariant.= $vOption['label'].' ';
                                            } else if($vOption['option_id'] === '109') {
                                                $nameProductVariant.= $vOption['label'];
                                            } else {
                                                $nameProductVariant.= $vOption['label'].' ';
                                            }
                                        }
                                    } else {
                                        $nameProductVariant = 'Default';
                                    }
                                    
                                    
                                    $variantSku =  $vVariant['sku'];
                                    // $default_sell_price = $getProductVariant['data'][0]['calculated_price'];
                                    $pv = new ProductVariation();
                                    $pv->name = $nameProductVariant;
                                    $pv->product_id = $p->id;
                                    $pv->is_dummy = 0;
                                    $pv->created_at = Carbon::now();
                                    $pv->save();
                
                                    $v = new Variation();
                                    $v->name = $nameProductVariant;
                                    $v->product_id = $p->id;
                                    $v->sub_sku = $variantSku;
                                    $v->product_variation_id = $pv->id;
                                    $v->default_sell_price = $vVariant['price'] ? $vVariant['price'] : $vVariant['calculated_price'];
                                    $v->sell_price_inc_tax = $vVariant['price'] ? $vVariant['price'] : $vVariant['calculated_price'];
                                    $v->save();
                
                                    if(! empty($product_locations)) {
                                        if(count($product_locations) > 1) {
                                          $qty_divide = $vVariant['inventory_level'] / 1;
                                          foreach ($product_locations as $val) {
                                            # code...
                                            $vld = new VariationLocationDetails();
                                            $vld->product_id = $p->id;
                                            $vld->product_variation_id = $pv->id;
                                            $vld->variation_id = $v->id;
                                            $vld->location_id = $val;
                                            $vld->qty_available = $qty_divide;
                                            $vld->save();
                
                                            $transaction = new Transaction();
                                            $transaction->business_id = $business_id;
                                            $transaction->location_id = $val;
                                            $transaction->type = 'opening_stock';
                                            $transaction->status = 'received';
                                            $transaction->is_quotation = 0;
                                            $transaction->payment_status = 'paid';
                                            $transaction->transaction_date = Carbon::now();
                                            $transaction->total_before_tax = 0;
                                            $transaction->tax_amount = 0;
                                            $transaction->discount_amount = 0;
                                            $transaction->rp_redeemed = 0;
                                            $transaction->rp_redeemed_amount = 0;
                                            $transaction->shipping_charges = 0;
                                            $transaction->is_export = 0;
                                            $transaction->round_off_amount = 0;
                                            $transaction->additional_expense_value_1 = 0;
                                            $transaction->additional_expense_value_2 = 0;
                                            $transaction->additional_expense_value_3 = 0;
                                            $transaction->additional_expense_value_4 = 0;
                                            $transaction->final_total = 0;
                                            $transaction->is_direct_sale = 0;
                                            $transaction->is_suspend = 0;
                                            $transaction->exchange_rate = 1;
                                            $transaction->opening_stock_product_id = $p->id;
                                            $transaction->created_by = auth()->user()->id;
                                            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                            $transaction->is_created_from_api = 1;
                                            $transaction->rp_earned = 0;
                                            $transaction->is_recurring = 0;
                
                                            $transaction->save();
                
                                            $purchase_lines = new PurchaseLine();
                                            $purchase_lines->transaction_id = $transaction->id;
                                            $purchase_lines->product_id = $p->id;
                                            $purchase_lines->variation_id = $v->id;
                                            $purchase_lines->quantity = $qty_divide;
                                            $purchase_lines->purchase_price = 0;
                                            $purchase_lines->save();
                                          }
                                        } else {
                                          $vld = new VariationLocationDetails();
                                          $vld->product_id = $p->id;
                                          $vld->product_variation_id = $pv->id;
                                          $vld->variation_id = $v->id;
                                          $vld->location_id = $product_locations[0];
                                          $vld->qty_available = $vVariant['inventory_level'];
                                          $vld->save();
                
                                          $transaction = new Transaction();
                                            $transaction->business_id = $business_id;
                                            $transaction->location_id = $product_locations[0];
                                            $transaction->type = 'opening_stock';
                                            $transaction->status = 'received';
                                            $transaction->is_quotation = 0;
                                            $transaction->payment_status = 'paid';
                                            $transaction->transaction_date = Carbon::now();
                                            $transaction->total_before_tax = 0;
                                            $transaction->tax_amount = 0;
                                            $transaction->discount_amount = 0;
                                            $transaction->rp_redeemed = 0;
                                            $transaction->rp_redeemed_amount = 0;
                                            $transaction->shipping_charges = 0;
                                            $transaction->is_export = 0;
                                            $transaction->round_off_amount = 0;
                                            $transaction->additional_expense_value_1 = 0;
                                            $transaction->additional_expense_value_2 = 0;
                                            $transaction->additional_expense_value_3 = 0;
                                            $transaction->additional_expense_value_4 = 0;
                                            $transaction->final_total = 0;
                                            $transaction->is_direct_sale = 0;
                                            $transaction->is_suspend = 0;
                                            $transaction->exchange_rate = 1;
                                            $transaction->opening_stock_product_id = $p->id;
                                            $transaction->created_by = auth()->user()->id;
                                            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                            $transaction->is_created_from_api = 1;
                                            $transaction->rp_earned = 0;
                                            $transaction->is_recurring = 0;
                
                                            $transaction->save();
                
                                            $purchase_lines = new PurchaseLine();
                                            $purchase_lines->transaction_id = $transaction->id;
                                            $purchase_lines->product_id = $p->id;
                                            $purchase_lines->variation_id = $v->id;
                                            $purchase_lines->quantity = $vVariant['inventory_level'];
                                            $purchase_lines->purchase_price = 0;
                                            $purchase_lines->save();
                                        }
                                    }
                                }
                            } else {
                                $nameProductVariant = 'Default';
                                $variantSku = '';
                                // $default_sell_price = 0;
                                $pv = new ProductVariation();
                                $pv->name = $nameProductVariant;
                                $pv->product_id = $p->id;
                                $pv->is_dummy = 0;
                                $pv->created_at = Carbon::now();
                                $pv->save();
            
                                $v = new Variation();
                                $v->name = $nameProductVariant;
                                $v->product_id = $p->id;
                                $v->sub_sku = $variantSku;
                                $v->product_variation_id = $pv->id;
                                $v->default_sell_price = $value['price'] ? $value['price'] : $value['calculated_price'];
                                $v->sell_price_inc_tax = $value['price'] ? $value['price'] : $value['calculated_price'];
                                $v->save();
            
                                if(! empty($product_locations)) {
                                    if(count($product_locations) > 1) {
                                      $qty_divide = $value['inventory_level'] / 1;
                                      foreach ($product_locations as $val) {
                                        # code...
                                        $vld = new VariationLocationDetails();
                                        $vld->product_id = $p->id;
                                        $vld->product_variation_id = $pv->id;
                                        $vld->variation_id = $v->id;
                                        $vld->location_id = $val;
                                        $vld->qty_available = $qty_divide;
                                        $vld->save();
            
                                        $transaction = new Transaction();
                                        $transaction->business_id = $business_id;
                                        $transaction->location_id = $val;
                                        $transaction->type = 'opening_stock';
                                        $transaction->status = 'received';
                                        $transaction->is_quotation = 0;
                                        $transaction->payment_status = 'paid';
                                        $transaction->transaction_date = Carbon::now();
                                        $transaction->total_before_tax = 0;
                                        $transaction->tax_amount = 0;
                                        $transaction->discount_amount = 0;
                                        $transaction->rp_redeemed = 0;
                                        $transaction->rp_redeemed_amount = 0;
                                        $transaction->shipping_charges = 0;
                                        $transaction->is_export = 0;
                                        $transaction->round_off_amount = 0;
                                        $transaction->additional_expense_value_1 = 0;
                                        $transaction->additional_expense_value_2 = 0;
                                        $transaction->additional_expense_value_3 = 0;
                                        $transaction->additional_expense_value_4 = 0;
                                        $transaction->final_total = 0;
                                        $transaction->is_direct_sale = 0;
                                        $transaction->is_suspend = 0;
                                        $transaction->exchange_rate = 1;
                                        $transaction->opening_stock_product_id = $p->id;
                                        $transaction->created_by = auth()->user()->id;
                                        $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                        $transaction->is_created_from_api = 1;
                                        $transaction->rp_earned = 0;
                                        $transaction->is_recurring = 0;
            
                                        $transaction->save();
            
                                        $purchase_lines = new PurchaseLine();
                                        $purchase_lines->transaction_id = $transaction->id;
                                        $purchase_lines->product_id = $p->id;
                                        $purchase_lines->variation_id = $v->id;
                                        $purchase_lines->quantity = $qty_divide;
                                        $purchase_lines->purchase_price = 0;
                                        $purchase_lines->save();
                                      }
                                    } else {
                                      $vld = new VariationLocationDetails();
                                      $vld->product_id = $p->id;
                                      $vld->product_variation_id = $pv->id;
                                      $vld->variation_id = $v->id;
                                      $vld->location_id = $product_locations[0];
                                      $vld->qty_available = $value['inventory_level'];
                                      $vld->save();
            
                                      $transaction = new Transaction();
                                        $transaction->business_id = $business_id;
                                        $transaction->location_id = $product_locations[0];
                                        $transaction->type = 'opening_stock';
                                        $transaction->status = 'received';
                                        $transaction->is_quotation = 0;
                                        $transaction->payment_status = 'paid';
                                        $transaction->transaction_date = Carbon::now();
                                        $transaction->total_before_tax = 0;
                                        $transaction->tax_amount = 0;
                                        $transaction->discount_amount = 0;
                                        $transaction->rp_redeemed = 0;
                                        $transaction->rp_redeemed_amount = 0;
                                        $transaction->shipping_charges = 0;
                                        $transaction->is_export = 0;
                                        $transaction->round_off_amount = 0;
                                        $transaction->additional_expense_value_1 = 0;
                                        $transaction->additional_expense_value_2 = 0;
                                        $transaction->additional_expense_value_3 = 0;
                                        $transaction->additional_expense_value_4 = 0;
                                        $transaction->final_total = 0;
                                        $transaction->is_direct_sale = 0;
                                        $transaction->is_suspend = 0;
                                        $transaction->exchange_rate = 1;
                                        $transaction->opening_stock_product_id = $p->id;
                                        $transaction->created_by = auth()->user()->id;
                                        $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                        $transaction->is_created_from_api = 1;
                                        $transaction->rp_earned = 0;
                                        $transaction->is_recurring = 0;
            
                                        $transaction->save();
            
                                        $purchase_lines = new PurchaseLine();
                                        $purchase_lines->transaction_id = $transaction->id;
                                        $purchase_lines->product_id = $p->id;
                                        $purchase_lines->variation_id = $v->id;
                                        $purchase_lines->quantity = $value['inventory_level'];
                                        $purchase_lines->purchase_price = 0;
                                        $purchase_lines->save();
                                    }
                                }
                            }
                        }
                        
                        
                        $no++;
                        $status = 1;
                        array_push($arr, [
                            'number' => $no,
                            'status' => $status
                        ]);
                    } else {
                        $checkmarks_arr = [];                    
                        foreach ($checkmarks as $key => $val) {
                            array_push($checkmarks_arr, $val['value']);     
                        }                   
                            # code...
                            // dd(in_array("default_sell_price", $val));
                            $nameProduct =  $checkProduct->name == $value['name'] ? $checkProduct->name : $value['name'];
                            $brand_id =  $checkProduct->brand_id == $brandId ? $checkProduct->brand_id : $brandId;
                            $category_id = $checkProduct->category_id == $categoryId ? $checkProduct->category_id : $categoryId;
                            $description = $checkProduct->product_description == $value['description'] ? $checkProduct->product_description : $value['description'];            
                            $valueSku = $value['sku'] ? $value['sku'] : ' ';
                            $sku = $checkProduct->sku == $valueSku ? $checkProduct->sku : $valueSku;
                            $valueBarcode = $value['sku'] ? $value['sku'] : ' ';
                            $barcode = $checkProduct->barcode == $valueBarcode ? $checkProduct->barcode : $valueBarcode;
                            $getImage = $this->getImageAPI($value['id']);
                            $image = null;
                            if($getImage) {
                                $image = $checkProduct->image == $getImage[0]['url_standard'] ? $checkProduct->image : $getImage[0]['url_standard'];
                            }
        
                            $getProductVariant = $this->getProductVariantAPI(null, $value['id']);
                            // dd($getProductVariant);
                            $statusVariation = null;
                            if($getProductVariant == 1) {
                                $nameProductVariant = 'Default';
                                $checkVariation = Variation::where('product_id', $checkProduct->id)->first();
                                if($checkVariation) {
                                    $nameVariation = $checkVariation->name == $nameProductVariant ? $checkVariation->name : $nameProductVariant;
                                    $subSku = $checkVariation->sub_sku == $value['sku'] ? $checkVariation->sub_sku : $value['sku'];
                                    $getPrice = $value['price'] ? $value['price'] : $value['calculated_price'];
                                    $price = $checkVariation->default_sell_price == $getPrice ? $checkVariation->default_sell_price : $getPrice;
                                    
                                    $variation = Variation::find($checkVariation->id);
                                    $variation->name = $nameVariation;
                                    $variation->sub_sku = $subSku;
                                    if(in_array("default_sell_price", $val)) {
                                        $variation->default_sell_price = $price;
                                        $variation->sell_price_inc_tax = $price;
                                    }
                                    
                                    $variation->save();
                                    
                                    $statusVariation = $variation->wasChanged();
                                }
                            } else {
                                if($getProductVariant) {
                                    /* if(array_key_exists('option_values', $getProductVariant['data'][0])) {
                                        if($getProductVariant['data'][0]['option_values']) {
                                            $nameProductVariant = $getProductVariant['data'][0]['option_values'][0]['label'];
                                        } else {
                                            $nameProductVariant = 'DUMMY';
                                        }
                                    } else {
                                        $nameProductVariant = 'DUMMY';
                                    } */                                
                                    foreach ($getProductVariant['data'] as $kVariant => $vVariant) {
                                        # code...
                                        if($vVariant['option_values']) {
                                            // dd($getProductVariant['data'][0]);
                                            $nameProductVariant = '';
                                            foreach ($vVariant['option_values'] as $kOption => $vOption) {
                                                # code...                                            
                                                if($vOption['option_id'] === '108') {
                                                    $nameProductVariant.= $vOption['label'].' ';
                                                } else if($vOption['option_id'] === '109') {
                                                    $nameProductVariant.= $vOption['label'];
                                                } else {
                                                    $nameProductVariant.= $vOption['label'].' ';
                                                }
                                            }
                                        } else {
                                            $nameProductVariant = 'Default';
                                        }                                    
    
                                        // $nameProductVariant = 'DUMMY';
                                        $checkVariation = Variation::where('sub_sku', $vVariant['sku'])->first();
                                        
                                        if($checkVariation) {
                                            $nameVariation = $checkVariation->name == $nameProductVariant ? $checkVariation->name : $nameProductVariant;
                                            $subSku = $checkVariation->sub_sku == $vVariant['sku'] ? $checkVariation->sub_sku : $vVariant['sku'];
                                            $getPrice = $vVariant['price'] ? $vVariant['price'] : $vVariant['calculated_price'];
                                            $price = $checkVariation->default_sell_price == $getPrice ? $checkVariation->default_sell_price : $getPrice;
                                            
                                            $variation = Variation::find($checkVariation->id);
                                            $variation->name = $nameVariation;
                                            $variation->sub_sku = $subSku;
                                            if(in_array("default_sell_price", $checkmarks_arr)) {
                                                $variation->default_sell_price = $price;
                                                $variation->sell_price_inc_tax = $price;
                                            }
                                            
                                            $variation->save();
                                            $statusVariation = $variation->wasChanged();
                                        } else {
                                            $variantSku =  $vVariant['sku'];
                                            // $default_sell_price = $getProductVariant['data'][0]['calculated_price'];
                                            $pv = new ProductVariation();
                                            $pv->name = $nameProductVariant;
                                            $pv->product_id = $checkProduct->id;
                                            $pv->is_dummy = 0;
                                            $pv->created_at = Carbon::now();
                                            $pv->save();
                        
                                            $v = new Variation();
                                            $v->name = $nameProductVariant;
                                            $v->product_id = $checkProduct->id;
                                            $v->sub_sku = $variantSku;
                                            $v->product_variation_id = $pv->id;
                                            $v->default_sell_price = $vVariant['price'] ? $vVariant['price'] : $vVariant['calculated_price'];
                                            $v->sell_price_inc_tax = $vVariant['price'] ? $vVariant['price'] : $vVariant['calculated_price'];
                                            $v->save();
                        
                                            if(! empty($product_locations)) {
                                                if(count($product_locations) > 1) {
                                                foreach ($product_locations as $val) {
                                                    # code...
                                                    $vld = new VariationLocationDetails();
                                                    $vld->product_id = $checkProduct->id;
                                                    $vld->product_variation_id = $pv->id;
                                                    $vld->variation_id = $v->id;
                                                    $vld->location_id = $val;
                                                    $vld->qty_available = $vVariant['inventory_level'];
                                                    $vld->save();
                        
                                                    $transaction = new Transaction();
                                                    $transaction->business_id = $business_id;
                                                    $transaction->location_id = $val;
                                                    $transaction->type = 'opening_stock';
                                                    $transaction->status = 'received';
                                                    $transaction->is_quotation = 0;
                                                    $transaction->payment_status = 'paid';
                                                    $transaction->transaction_date = Carbon::now();
                                                    $transaction->total_before_tax = 0;
                                                    $transaction->tax_amount = 0;
                                                    $transaction->discount_amount = 0;
                                                    $transaction->rp_redeemed = 0;
                                                    $transaction->rp_redeemed_amount = 0;
                                                    $transaction->shipping_charges = 0;
                                                    $transaction->is_export = 0;
                                                    $transaction->round_off_amount = 0;
                                                    $transaction->additional_expense_value_1 = 0;
                                                    $transaction->additional_expense_value_2 = 0;
                                                    $transaction->additional_expense_value_3 = 0;
                                                    $transaction->additional_expense_value_4 = 0;
                                                    $transaction->final_total = 0;
                                                    $transaction->is_direct_sale = 0;
                                                    $transaction->is_suspend = 0;
                                                    $transaction->exchange_rate = 1;
                                                    $transaction->opening_stock_product_id = $checkProduct->id;
                                                    $transaction->created_by = auth()->user()->id;
                                                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                                    $transaction->is_created_from_api = 1;
                                                    $transaction->rp_earned = 0;
                                                    $transaction->is_recurring = 0;
                        
                                                    $transaction->save();
                        
                                                    $purchase_lines = new PurchaseLine();
                                                    $purchase_lines->transaction_id = $transaction->id;
                                                    $purchase_lines->product_id = $checkProduct->id;
                                                    $purchase_lines->variation_id = $v->id;
                                                    $purchase_lines->quantity = $vVariant['inventory_level'];
                                                    $purchase_lines->purchase_price = 0;
                                                    $purchase_lines->save();
                                                }
                                                } else {
                                                $vld = new VariationLocationDetails();
                                                $vld->product_id = $checkProduct->id;
                                                $vld->product_variation_id = $pv->id;
                                                $vld->variation_id = $v->id;
                                                $vld->location_id = $product_locations[0];
                                                $vld->qty_available = $vVariant['inventory_level'];
                                                $vld->save();
                        
                                                $transaction = new Transaction();
                                                    $transaction->business_id = $business_id;
                                                    $transaction->location_id = $product_locations[0];
                                                    $transaction->type = 'opening_stock';
                                                    $transaction->status = 'received';
                                                    $transaction->is_quotation = 0;
                                                    $transaction->payment_status = 'paid';
                                                    $transaction->transaction_date = Carbon::now();
                                                    $transaction->total_before_tax = 0;
                                                    $transaction->tax_amount = 0;
                                                    $transaction->discount_amount = 0;
                                                    $transaction->rp_redeemed = 0;
                                                    $transaction->rp_redeemed_amount = 0;
                                                    $transaction->shipping_charges = 0;
                                                    $transaction->is_export = 0;
                                                    $transaction->round_off_amount = 0;
                                                    $transaction->additional_expense_value_1 = 0;
                                                    $transaction->additional_expense_value_2 = 0;
                                                    $transaction->additional_expense_value_3 = 0;
                                                    $transaction->additional_expense_value_4 = 0;
                                                    $transaction->final_total = 0;
                                                    $transaction->is_direct_sale = 0;
                                                    $transaction->is_suspend = 0;
                                                    $transaction->exchange_rate = 1;
                                                    $transaction->opening_stock_product_id = $checkProduct->id;
                                                    $transaction->created_by = auth()->user()->id;
                                                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                                    $transaction->is_created_from_api = 1;
                                                    $transaction->rp_earned = 0;
                                                    $transaction->is_recurring = 0;
                        
                                                    $transaction->save();
                        
                                                    $purchase_lines = new PurchaseLine();
                                                    $purchase_lines->transaction_id = $transaction->id;
                                                    $purchase_lines->product_id = $checkProduct->id;
                                                    $purchase_lines->variation_id = $v->id;
                                                    $purchase_lines->quantity = $vVariant['inventory_level'];
                                                    $purchase_lines->purchase_price = 0;
                                                    $purchase_lines->save();
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    $nameProductVariant = 'Default';
                                    $checkVariation = Variation::where('sub_sku', $value['sku'])->first();
                                    $statusVariation = null;
                                    if($checkVariation) {
                                        $nameVariation = $checkVariation->name == $nameProductVariant ? $checkVariation->name : $nameProductVariant;
                                        $subSku = $checkVariation->sub_sku == $value['sku'] ? $checkVariation->sub_sku : $value['sku'];
                                        $getPrice = $value['price'] ? $value['price'] : $value['calculated_price'];
                                        $price = $checkVariation->default_sell_price == $getPrice ? $checkVariation->default_sell_price : $getPrice;
                                        
                                        $variation = Variation::find($checkVariation->id);
                                        $variation->name = $nameVariation;
                                        $variation->sub_sku = $subSku;
                                        if(in_array("default_sell_price", $checkmarks_arr)) {
                                            $variation->default_sell_price = $price;
                                            $variation->sell_price_inc_tax = $price;
                                        }
                                        
                                        $variation->save();
                                        $statusVariation = $variation->wasChanged();
                                    }
                                }
                            }
        
    
                            /* $checkProductQty = VariationLocationDetails::where('product_id', $checkProduct->id)->get()->toArray();
                            $qtyChanged = null;
                            if(empty($checkProductQty)) {
                                if($product_locations) {                
                                // if(count($product_locations) != count($checkProductQty)) {
                                    // VariationLocationDetails::where('product_id', $checkProduct->id)->delete();
                                    if(! empty($product_locations)) {
                                        $productVariation = ProductVariation::where('product_id', $checkProduct->id)->select('id')->first();
                                        if(count($product_locations) > 1) {
                                            foreach ($product_locations as $val) {
                                                # code...
                                                $vld = new VariationLocationDetails();
                                                $vld->product_id = $checkProduct->id;
                                                $vld->product_variation_id = $productVariation->id;
                                                $vld->variation_id = $checkVariation->id;
                                                $vld->location_id = $val;
                                                $vld->qty_available = $value['inventory_level'];
                                                $vld->save();
    
                                                $checkPurcasheLine = PurchaseLine::where('variation_id', $variation->id)->first();
                                                if($checkPurcasheLine == null) {
                                                    $transaction = new Transaction();
                                                    $transaction->business_id = $business_id;
                                                    $transaction->location_id = $product_locations[0];
                                                    $transaction->type = 'opening_stock';
                                                    $transaction->status = 'received';
                                                    $transaction->is_quotation = 0;
                                                    $transaction->payment_status = 'paid';
                                                    $transaction->transaction_date = Carbon::now();
                                                    $transaction->total_before_tax = 0;
                                                    $transaction->tax_amount = 0;
                                                    $transaction->discount_amount = 0;
                                                    $transaction->rp_redeemed = 0;
                                                    $transaction->rp_redeemed_amount = 0;
                                                    $transaction->shipping_charges = 0;
                                                    $transaction->is_export = 0;
                                                    $transaction->round_off_amount = 0;
                                                    $transaction->additional_expense_value_1 = 0;
                                                    $transaction->additional_expense_value_2 = 0;
                                                    $transaction->additional_expense_value_3 = 0;
                                                    $transaction->additional_expense_value_4 = 0;
                                                    $transaction->final_total = 0;
                                                    $transaction->is_direct_sale = 0;
                                                    $transaction->is_suspend = 0;
                                                    $transaction->exchange_rate = 1;
                                                    $transaction->opening_stock_product_id = $checkProduct->id;
                                                    $transaction->created_by = auth()->user()->id;
                                                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                                    $transaction->is_created_from_api = 1;
                                                    $transaction->rp_earned = 0;
                                                    $transaction->is_recurring = 0;
    
                                                    $transaction->save();
    
                                                    $purchase_lines = new PurchaseLine();
                                                    $purchase_lines->transaction_id = $transaction->id;
                                                    $purchase_lines->product_id = $checkProduct->id;
                                                    $purchase_lines->variation_id = $variation->id;
                                                    $purchase_lines->quantity = $value['inventory_level'];
                                                    $purchase_lines->purchase_price = 0;
                                                    $purchase_lines->save();
                                                } else {
                                                    $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                                    $purchase_lines->quantity = $value['inventory_level'];
                                                    $purchase_lines->save();
                                                }
                                            }
                                        } else {
                                            $vld = new VariationLocationDetails();
                                            $vld->product_id = $checkProduct->id;
                                            $vld->product_variation_id = $productVariation->id;
                                            $vld->variation_id = $checkVariation->id;
                                            $vld->location_id = $product_locations[0];
                                            $vld->qty_available = $value['inventory_level'];
                                            $vld->save();
                                            $checkPurcasheLine = PurchaseLine::where('variation_id', $variation->id)->first();
                                            if($checkPurcasheLine == null) {
                                                $transaction = new Transaction();
                                                $transaction->business_id = $business_id;
                                                $transaction->location_id = $product_locations[0];
                                                $transaction->type = 'opening_stock';
                                                $transaction->status = 'received';
                                                $transaction->is_quotation = 0;
                                                $transaction->payment_status = 'paid';
                                                $transaction->transaction_date = Carbon::now();
                                                $transaction->total_before_tax = 0;
                                                $transaction->tax_amount = 0;
                                                $transaction->discount_amount = 0;
                                                $transaction->rp_redeemed = 0;
                                                $transaction->rp_redeemed_amount = 0;
                                                $transaction->shipping_charges = 0;
                                                $transaction->is_export = 0;
                                                $transaction->round_off_amount = 0;
                                                $transaction->additional_expense_value_1 = 0;
                                                $transaction->additional_expense_value_2 = 0;
                                                $transaction->additional_expense_value_3 = 0;
                                                $transaction->additional_expense_value_4 = 0;
                                                $transaction->final_total = 0;
                                                $transaction->is_direct_sale = 0;
                                                $transaction->is_suspend = 0;
                                                $transaction->exchange_rate = 1;
                                                $transaction->opening_stock_product_id = $checkProduct->id;
                                                $transaction->created_by = auth()->user()->id;
                                                $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                                $transaction->is_created_from_api = 1;
                                                $transaction->rp_earned = 0;
                                                $transaction->is_recurring = 0;
    
                                                $transaction->save();
    
                                                $purchase_lines = new PurchaseLine();
                                                $purchase_lines->transaction_id = $transaction->id;
                                                $purchase_lines->product_id = $checkProduct->id;
                                                $purchase_lines->variation_id = $variation->id;
                                                $purchase_lines->quantity = $value['inventory_level'];
                                                $purchase_lines->purchase_price = 0;
                                                $purchase_lines->save();
                                            } else {
                                                $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                                $purchase_lines->quantity = $value['inventory_level'];
                                                $purchase_lines->save();
                                            }
                                        }
                                    }
                                // }
                                }                         
                            } else {
                                foreach ($checkProductQty as $kQty => $vQty) {
                                # code...
                                if($vQty['qty_available'] != $value['inventory_level']) {
                                    $vld = VariationLocationDetails::find($vQty['id']);
                                    $vld->qty_available = $value['inventory_level'];
                                    $vld->save();
                                    $qtyChanged = $vld->wasChanged();
                                    $checkPurcasheLine = PurchaseLine::where('variation_id', $variation->id)->first();
                                    if($checkPurcasheLine == null) {
                                        $transaction = new Transaction();
                                        $transaction->business_id = $business_id;
                                        $transaction->location_id = $product_locations[0];
                                        $transaction->type = 'opening_stock';
                                        $transaction->status = 'received';
                                        $transaction->is_quotation = 0;
                                        $transaction->payment_status = 'paid';
                                        $transaction->transaction_date = Carbon::now();
                                        $transaction->total_before_tax = 0;
                                        $transaction->tax_amount = 0;
                                        $transaction->discount_amount = 0;
                                        $transaction->rp_redeemed = 0;
                                        $transaction->rp_redeemed_amount = 0;
                                        $transaction->shipping_charges = 0;
                                        $transaction->is_export = 0;
                                        $transaction->round_off_amount = 0;
                                        $transaction->additional_expense_value_1 = 0;
                                        $transaction->additional_expense_value_2 = 0;
                                        $transaction->additional_expense_value_3 = 0;
                                        $transaction->additional_expense_value_4 = 0;
                                        $transaction->final_total = 0;
                                        $transaction->is_direct_sale = 0;
                                        $transaction->is_suspend = 0;
                                        $transaction->exchange_rate = 1;
                                        $transaction->opening_stock_product_id = $checkProduct->id;
                                        $transaction->created_by = auth()->user()->id;
                                        $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                        $transaction->is_created_from_api = 1;
                                        $transaction->rp_earned = 0;
                                        $transaction->is_recurring = 0;
    
                                        $transaction->save();
    
                                        $purchase_lines = new PurchaseLine();
                                        $purchase_lines->transaction_id = $transaction->id;
                                        $purchase_lines->product_id = $checkProduct->id;
                                        $purchase_lines->variation_id = $variation->id;
                                        $purchase_lines->quantity = $value['inventory_level'];
                                        $purchase_lines->purchase_price = 0;
                                        $purchase_lines->save();
                                    } else {
                                        $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                        $purchase_lines->quantity = $value['inventory_level'];
                                        $purchase_lines->save();
                                    }
                                } 
                                }
                            } */
    
                            $qtyChanged = null;
                            if($product_locations) {                
                              // if(count($product_locations) != count($checkProductQty)) {
                                // VariationLocationDetails::where('product_id', $checkProduct->id)->delete();
                                if(! empty($product_locations)) {
                                  $productVariation = ProductVariation::where('product_id', $checkProduct->id)->select('id')->first();                    
                                  foreach ($product_locations as $locval) {                      
                                      # code...
                                      $checkProductQty = VariationLocationDetails::where('product_id', $checkProduct->id)->where('location_id', $locval)->first();
                                      $qty_divide = $value['inventory_level'] / count($product_locations);                                  
                                      if($checkProductQty) {
                                        if($checkProductQty->qty_available != $qty_divide) {
                                          $vld = VariationLocationDetails::find($checkProductQty->id);
                                          $vld->qty_available = $qty_divide;
                                          $vld->save();                                      
                                          if($vld->wasChanged()) {
                                            $qtyChanged = 1;
                                          }
                                          $checkPurcasheLine = PurchaseLine::where('variation_id', $checkProductQty->variation_id)->first();                            
                                          if($checkPurcasheLine == null) {
                                            $transaction = new Transaction();
                                            $transaction->business_id = $business_id;
                                            $transaction->location_id = $locval;
                                            $transaction->type = 'opening_stock';
                                            $transaction->status = 'received';
                                            $transaction->is_quotation = 0;
                                            $transaction->payment_status = 'paid';
                                            $transaction->transaction_date = Carbon::now();
                                            $transaction->total_before_tax = 0;
                                            $transaction->tax_amount = 0;
                                            $transaction->discount_amount = 0;
                                            $transaction->rp_redeemed = 0;
                                            $transaction->rp_redeemed_amount = 0;
                                            $transaction->shipping_charges = 0;
                                            $transaction->is_export = 0;
                                            $transaction->round_off_amount = 0;
                                            $transaction->additional_expense_value_1 = 0;
                                            $transaction->additional_expense_value_2 = 0;
                                            $transaction->additional_expense_value_3 = 0;
                                            $transaction->additional_expense_value_4 = 0;
                                            $transaction->final_total = 0;
                                            $transaction->is_direct_sale = 0;
                                            $transaction->is_suspend = 0;
                                            $transaction->exchange_rate = 1;
                                            $transaction->opening_stock_product_id = $checkProduct->id;
                                            $transaction->created_by = auth()->user()->id;
                                            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                            $transaction->is_created_from_api = 1;
                                            $transaction->rp_earned = 0;
                                            $transaction->is_recurring = 0;
                  
                                            $transaction->save();
                  
                                            $purchase_lines = new PurchaseLine();
                                            $purchase_lines->transaction_id = $transaction->id;
                                            $purchase_lines->product_id = $checkProduct->id;
                                            $purchase_lines->variation_id = $variation->id;
                                            $purchase_lines->quantity = $qty_divide;
                                            $purchase_lines->purchase_price = 0;
                                            $purchase_lines->save();
                                          } else {
                                            $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                            $purchase_lines->quantity = $qty_divide;
                                            $purchase_lines->save();
                                          }
                                        }
                                      } else {
                                        $vld = new VariationLocationDetails();
                                        $vld->product_id = $checkProduct->id;
                                        $vld->product_variation_id = $productVariation->id;
                                        $vld->variation_id = $checkVariation->id;
                                        $vld->location_id = $locval;
                                        $vld->qty_available = $qty_divide;
                                        $vld->save();
                                  
                                        $transaction = new Transaction();
                                        $transaction->business_id = $business_id;
                                        $transaction->location_id = $locval;
                                        $transaction->type = 'opening_stock';
                                        $transaction->status = 'received';
                                        $transaction->is_quotation = 0;
                                        $transaction->payment_status = 'paid';
                                        $transaction->transaction_date = Carbon::now();
                                        $transaction->total_before_tax = 0;
                                        $transaction->tax_amount = 0;
                                        $transaction->discount_amount = 0;
                                        $transaction->rp_redeemed = 0;
                                        $transaction->rp_redeemed_amount = 0;
                                        $transaction->shipping_charges = 0;
                                        $transaction->is_export = 0;
                                        $transaction->round_off_amount = 0;
                                        $transaction->additional_expense_value_1 = 0;
                                        $transaction->additional_expense_value_2 = 0;
                                        $transaction->additional_expense_value_3 = 0;
                                        $transaction->additional_expense_value_4 = 0;
                                        $transaction->final_total = 0;
                                        $transaction->is_direct_sale = 0;
                                        $transaction->is_suspend = 0;
                                        $transaction->exchange_rate = 1;
                                        $transaction->opening_stock_product_id = $checkProduct->id;
                                        $transaction->created_by = auth()->user()->id;
                                        $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                        $transaction->is_created_from_api = 1;
                                        $transaction->rp_earned = 0;
                                        $transaction->is_recurring = 0;
                                        $transaction->save();
                
                                        $purchase_lines = new PurchaseLine();
                                        $purchase_lines->transaction_id = $transaction->id;
                                        $purchase_lines->product_id = $checkProduct->id;
                                        $purchase_lines->variation_id = $variation->id;
                                        $purchase_lines->quantity = $qty_divide;
                                        $purchase_lines->purchase_price = 0;
                                        $purchase_lines->save();    
                                        
                                        $no++;
                                        $status = 1;
                                        array_push($arr, [
                                            'number' => $no,
                                            'status' => $status
                                        ]);
                                      }                       
                                  }                    
                                }
                              // }
                            }  
                            
                            /* $product = Product::where('big_commerce_id', $value['id'])->update([
                                'product_description' => $description,
                                // 'brand_id' => $brand_id,
                                // 'alert_quantity' => $alert_qty,
                                'name' => $nameProduct,
                                // 'category_id' => $category_id,
                                'sku' => $sku,
                                'barcode' => $barcode,
                            ]); */
                            
                            $product = Product::find($checkProduct->id);
                            if(in_array("product_description", $checkmarks_arr)) {
                                $product->product_description = $description;
                            }                    
                            if(in_array("name", $checkmarks_arr)) {
                                $product->name = $nameProduct;
                            }
                            if(in_array("category_id", $checkmarks_arr)) {
                                $product->category_id = $category_id;
                            }
                            if(in_array("brand_id", $checkmarks_arr)) {
                                $product->brand_id = $brand_id;
                            }
                            if(in_array("sku", $checkmarks_arr)) {
                                $product->sku = $sku;
                            }
                            if(in_array("barcode", $checkmarks_arr)) {
                                $product->barcode = $barcode;
                            }
                            if($image) {
                                $product->image = $image;
                            }
                            $product->save();
                            
                            // dd($product->wasChanged());
                            
                            if(! empty($product_locations)) {
                                $checkProduct->product_locations()->sync($product_locations);
                            }
                            
                            if($product->wasChanged() || $statusVariation) {
                                $no++;
                                $status = 2;
                                array_push($arr, [
                                    'number' => $no,
                                    'status' => $status
                                ]);
                            }
                        // }                    
                    }
                }
                DB::commit();
                return $arr;            
            } catch (\Exception $err) {
                //throw $th;
                DB::rollBack();
                // return $err->getMessage();
                return __('messages.something_went_wrong');                   
            }            
            
        } else {
            $no = 0;
            // $arr = [];
            return $arr;
        }
    }

    public function getCategoryAPI($category_id)
    {
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

        $e_commerce_settings = json_decode($business->e_commerce_settings);

        if($e_commerce_settings->shopify_api_url && $e_commerce_settings->shopify_api_access_token) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $BIGCOMMERCE_URL = $e_commerce_settings->big_commerce_api_url;
            // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
            $BIGCOMMERCE_CRED = $e_commerce_settings->big_commerce_api_access_token;        
        } else {
            return 'Url and Access Token Big Commerce Not Found';
        }
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $BIGCOMMERCE_URL. "/catalog/categories/". $category_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: application/json",
                "X-Auth-Token: ".$BIGCOMMERCE_CRED
            ],
        ]);

        $response = curl_exec($curl);        
        $parsedResponse = json_decode($response);
        $data = json_decode(json_encode($parsedResponse), true);
        if($data) {
            if(array_key_exists('status', $data)) {
                return 1;
            } else {
                return $data; 
            }
        } else {
            return 1;
        }
        
        $err = curl_error($curl);
        curl_close($curl);
        
        return $data;
    }

    public function getBrandAPI($brand_id)
    {
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

        $e_commerce_settings = json_decode($business->e_commerce_settings);

        if($e_commerce_settings->shopify_api_url && $e_commerce_settings->shopify_api_access_token) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $BIGCOMMERCE_URL = $e_commerce_settings->big_commerce_api_url;
            // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
            $BIGCOMMERCE_CRED = $e_commerce_settings->big_commerce_api_access_token;        
        } else {
            return 'Url and Access Token Big Commerce Not Found';
        }
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $BIGCOMMERCE_URL. "/catalog/brands/". $brand_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: application/json",
                "X-Auth-Token: ".$BIGCOMMERCE_CRED
            ],
        ]);

        $response = curl_exec($curl);        
        $parsedResponse = json_decode($response);
        $data = json_decode(json_encode($parsedResponse), true);
        if(array_key_exists('status', $data)) {
            return 1;
        } else {
            return $data; 
        }
        
        $err = curl_error($curl);
        curl_close($curl);
        
        return $data;
    }

    public function getProductVariantAPI($variant_id, $product_id)
    {
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

        $e_commerce_settings = json_decode($business->e_commerce_settings);

        if($e_commerce_settings->shopify_api_url && $e_commerce_settings->shopify_api_access_token) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $BIGCOMMERCE_URL = $e_commerce_settings->big_commerce_api_url;
            // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
            $BIGCOMMERCE_CRED = $e_commerce_settings->big_commerce_api_access_token;        
        } else {
            return 'Url and Access Token Big Commerce Not Found';
        }
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $BIGCOMMERCE_URL. "/catalog/products/".$product_id."/variants",
            // CURLOPT_URL => $BIGCOMMERCE_URL. "/catalog/variants",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: application/json",
                "X-Auth-Token: ".$BIGCOMMERCE_CRED
            ],
        ]);

        $response = curl_exec($curl);        
        $parsedResponse = json_decode($response);
        // dd($parsedResponse);
        $data = json_decode(json_encode($parsedResponse), true);
        if(array_key_exists('status', $data)) {
            return 1;
        } else {
            return $data; 
        }
        
        $err = curl_error($curl);
        curl_close($curl);
        
        return $data;
    }

    public function getImageAPI($product_id) 
    {
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

        $e_commerce_settings = json_decode($business->e_commerce_settings);

        if($e_commerce_settings->shopify_api_url && $e_commerce_settings->shopify_api_access_token) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $BIGCOMMERCE_URL = $e_commerce_settings->big_commerce_api_url;
            // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
            $BIGCOMMERCE_CRED = $e_commerce_settings->big_commerce_api_access_token;        
        } else {
            return 'Url and Access Token Big Commerce Not Found';
        }
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $BIGCOMMERCE_URL. "/catalog/products/".$product_id."/images",
            // CURLOPT_URL => $BIGCOMMERCE_URL. "/catalog/variants",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "Accept: application/json",
                "Content-Type: application/json",
                "X-Auth-Token: ".$BIGCOMMERCE_CRED
            ],
        ]);

        $response = curl_exec($curl);        
        $parsedResponse = json_decode($response);
        // dd($parsedResponse);
        $images = json_decode(json_encode($parsedResponse), true);
        if(empty($images->data)) {
            return null;
        }                
        // if($images) {}
        
        $err = curl_error($curl);
        curl_close($curl);
        
        return $images;
    }
}
