<?php

namespace App\Http\Controllers;

use App\cardtransactions;
use App\BusinessLocation;
use Illuminate\Http\Request;
use Datatables;
use Illuminate\Support\Facades\DB;

class CardTransactionsController extends Controller
{
    
    public function getCardTransactionsReport(Request $request) {

        // if (! auth()->user()->can('card_transactions_report.view')) {
        //     abort(403, 'Unauthorized action.');
        // }

        $business_id = $request->session()->get('user.business_id');
        if ($request->ajax()) {
            
            $query = CardTransactions
                ::leftJoin('transactions', 'cardtransactions.invoiceid', '=', DB::raw('transactions.invoice_no collate utf8mb4_general_ci'))
                ->join('business_locations', 'business_locations.id', '=', 'transactions.location_id')
                ->select(
                    'cardtransactions.name',
                    'retref',
                    'resptext',
                    'authcode',
                    'amount',
                    'expiry',
                    'applicationLabel',
                    'entrymode',
                    'transactions.transaction_date',
                    'merchid',
                    'transactions.location_id',
                    'business_locations.name as locations'
                );
                // ->orderBy('transaction_sell_lines.created_at', 'desc');

            
            $start_date = $request->get('start_date');
            $end_date = $request->get('end_date');
            if (! empty($start_date) && ! empty($end_date)) {
                $query->where('transactions.transaction_date', '>=', $start_date)
                    ->where('transactions.transaction_date', '<=', $end_date);
            }

            if( !empty($request->get('search_retref'))) {
               $query->where('retref', 'like', '%'.$request->get('search_retref').'%');
            }

            if( !empty($request->get('location_id'))) {
               $query->where('transactions.location_id', $request->get('location_id'));
            }
        
            return Datatables::of($query)
                ->editColumn('customer_name', function ($row) {
                    return $row->customer_name;
                })
                 ->editColumn('reference_number', function ($row) {
                    return $row->reference_number;
                 })
                 ->editColumn('resptext', function ($row) {
                    return $row->resptext;
                 })
                 ->editColumn('authcode', function ($row) {
                    return $row->authcode;
                 })
                 ->editColumn('amount', function ($row) {
                    return number_format($row->amount, 2);
                 })
                 ->editColumn('expiry', function ($row) {
                    return $row->expiry;
                 })
                 ->editColumn('card_type', function ($row) {
                    return $row->card_type;
                 })
                 ->editColumn('entrymode', function ($row) {
                    return $row->entrymode;
                 })
                 ->editColumn('transaction_date', function ($row) {
                    return $row->transaction_date;
                 })
                 ->editColumn('merchid', function ($row) {
                  return $row->merchid;
               })
                ->make(true);
        }

        $business_locations = BusinessLocation::forDropdown($business_id);
        return view('report.card_transactions_report')
            ->with(compact('business_locations'));

    }
}
