<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\GoogleBooksService;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class GoogleBooksController extends Controller
{
    protected $googleBooksService;

    public function __construct(GoogleBooksService $googleBooksService)
    {
        $this->googleBooksService = $googleBooksService;
    }

    public function getBook($asin)
    {
        $asins_from_db = DB::table('amazon_table')->take(100)->pluck('asin');
        $count = 0;
        foreach ($asins_from_db as $asin_db) {
            
            $bookData = $this->googleBooksService->getBookByISBN($asin_db);

            if (isset($bookData['items'])) {
                foreach ($bookData['items'] as $items) {
                    if (isset($items['volumeInfo']['industryIdentifiers']) && isset($items['volumeInfo']['description'])) {
                        if ($items['volumeInfo']['industryIdentifiers'][0]['identifier'] == $asin_db && isset($items['volumeInfo']['description'])) {
                            $count++;
                            // Log::info('count: ' . $count);
                            // Log::info('Match found!!');
                            // Log::info($items['volumeInfo']['industryIdentifiers'][0]['identifier'] . '<br>');
                            // Log::info($items['volumeInfo']['description'] . '<br>');

                            // $book = [
                            //     'title' => $items['volumeInfo']['title'] ?? null,
                            //     'description' => $items['volumeInfo']['description'] ?? null,
                            //     'printType' => $items['volumeInfo']['printType'] ?? null,
                            //     'categories' => $items['volumeInfo']['categories'] ?? [],
                            // ];
                            // return response()->json($book);
                        }
                    }
                }
            }
        }
        Log::info('count: ' . $count);

        /*
        $bookData = $this->googleBooksService->getBookByISBN($asin);
        return $bookData;
        //print_r($bookData['items']);
        
    
    
        //print($bookData['items']['volumeInfo']['description']);
        foreach ($bookData['items'] as $items) {
            // if (isset($items['volumeInfo']['description'])) {
            //     print($items['volumeInfo']['title'] . ' - ' . $items['volumeInfo']['description'] . '<br>');
            // }else{
            //     print($items['volumeInfo']['title'] .' Does Not have a description');
            // }
            
            //echo json_encode($items['volumeInfo'], JSON_PRETTY_PRINT);
            // if (isset($items['volumeInfo']['description'])) {
            //     Log::info('Description exists for ASIN: ' . $asin);
            // }
            //print($items['volumeInfo']['industryIdentifiers'][0]['identifier'] . '<br>');
            //if(isset($items['volumeInfo']['description'])) print($items['volumeInfo']['industryIdentifiers'][0]['identifier'] . ' - ' . $items['volumeInfo']['description'] . '<br>');
            
            if ($items['volumeInfo']['industryIdentifiers'][0]['identifier'] == $asin && isset($items['volumeInfo']['description'])) {
                print('Match found!!');
                print($items['volumeInfo']['industryIdentifiers'][0]['identifier'] . '<br>');
                print($items['volumeInfo']['description'] . '<br>');
                Log::info('Google Book Service - identifier: ' . $items['volumeInfo']['industryIdentifiers'][0]['identifier']);
                Log::info('Google Book Service - description: ' . $items['volumeInfo']['description']);
                $book = [
                    'title' => $items['volumeInfo']['title'] ?? null,
                    'description' => $items['volumeInfo']['description'] ?? null,
                    'printType' => $items['volumeInfo']['printType'] ?? null,
                    'categories' => $items['volumeInfo']['categories'] ?? [],
                ];
                return response()->json($book);
            }else {
                print('NOT found');
            }
                
        }
        */

        //return response()->json(['message' => 'Book not found'], 404);

    }
}
