<?php

namespace App\Http\Controllers;

use App\Barcode;
use Illuminate\Http\Request;
use App\Services\KeepaService;
use App\Imports\KeepaImport;
use App\Keepa;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;
use App\Jobs\AmazonQueueJob;
use App\SellingPriceGroup;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class KeepaController extends Controller
{

    protected $keepaService;

    public function __construct(KeepaService $keepaService)
    {
        $this->keepaService = $keepaService;
    }

    public function getAllProductsFromDB($store, Request $request){
        $query = Keepa::select(
            'id',
            'image',
            'asin',
            'title',
            'brand',
            'category',
            'manufacturer',
            'productGroup',
            'type',
            'binding',
            'current_price',
            DB::raw('coalesce(current_qty, 0) as current_qty')
        )->where('store', $store);

        $recordsTotal = $query->count();

        if($request->category) {
            $query->where('category', $request->category);
        }

        // **Filter Data (Pencarian)**
        if (!empty($request->search['value'])) {
            $search = $request->search['value'];
            $query->whereRaw("(title like '%$search%' or asin like '%$search%' or category like '%$search%')");
        }

        // **Hitung Total Data Setelah Filter**
        $recordsFiltered = $query->count();

        // **Sorting**
        if (!empty($request->order)) {
            $columnIndex = $request->order[0]['column']; // Index kolom
            $columnName = $request->columns[$columnIndex]['data']; // Nama kolom
            $columnSortOrder = $request->order[0]['dir']; // 'asc' atau 'desc'
            if($columnName) {
                if(intval($request->draw) == 1) {
                    $query->orderBy('asin', 'desc');
                } else {
                    $query->orderBy($columnName, $columnSortOrder);
                }
            }
        } else {
            $query->orderBy('asin', 'desc');
        }

        $products = $query->offset($request->start)
            ->limit($request->length)
            ->get();
        
        // dd($recordsTotal, $recordsFiltered);

        // **Response JSON**
        return response()->json([
            "draw" => intval($request->draw),
            "recordsTotal" => $recordsTotal,   // Total tanpa filter
            "recordsFiltered" => $recordsFiltered,  // Total dengan filter
            "data" => $products
        ]);
        // $limit = $request->get('length') ? $request->get('length') : 25;
        // $offset = $request->get('start') ? $request->get('start') : 0;
        // $search = $request->get('search') ? $request->get('search')['value'] : '';
        // $totalRecords = Keepa::count();
        // if($search) {
        //     $products = Keepa::select(
        //         'image',
        //         'asin',
        //         'title',
        //         'brand',
        //         'category',
        //         'manufacturer',
        //         'productGroup',
        //         'type',
        //         'binding',
        //         'current_price',
        //         'current_qty'
        //     )->where('store', $store)
        //     ->whereRaw("(title like '%$search%' or asin like '%$search%' or category like '%$search%')")
        //     // ->limit($limit)
        //     // ->offset($offset)
        //     ->get();
        // } else {
        //     $products = Keepa::select(
        //         'image',
        //         'asin',
        //         'title',
        //         'brand',
        //         'category',
        //         'manufacturer',
        //         'productGroup',
        //         'type',
        //         'binding',
        //         'current_price',
        //         'current_qty'
        //     )->where('store', $store)
        //     ->limit($limit)
        //     ->offset($offset)
        //     ->get();
        // }        
        // $filteredRecords = $products->count();
        // // return Datatables::of($products)
        // //     ->addIndexColumn()
        // //     ->make(true);
        // // return $products;
        // return response()->json([
        //     "draw" => intval($request->draw),
        //     "recordsTotal" => $totalRecords,
        //     "recordsFiltered" => $filteredRecords,
        //     "data" => $products
        // ]);
    }

    public function import(Request $request) {
        // if($request->hasFile('amazon_file')) {
        //     Log::info("start import to keepa at");
        //     Log::info(date('d-m-Y H:i:s'));
        //     Excel::import(new KeepaImport, $request->file('amazon_file'));
        //     return response()->json(['message' => 'Data is being processed in a queue.']);
        // } else {
        //     return response()->json(['message' => 'Excel .xlsx not found.']);
        // }

        // if($request->hasFile('amazon_file')) {
            // $file = $request->file('amazon_file');
            // $parsed_array = Excel::toArray([], $file);
            //Remove header row
            // $imported_data = array_splice($parsed_array[0], 1);      
                      
            /* $imported_data = DB::table('ubdtx_temp')->get()->toArray(); 
            $chunks = array_chunk($imported_data, 100);
            $counter = 0;
            Log::info("start at ". date('Y-m-d H:i:s'));
            Log::info('total data from excel is '. count($imported_data));
            $jobs = [];
            foreach ($chunks as $index => $chunk) {
                // AmazonQueueJob::dispatch($item)->delay(now()->addMinutes($index));                                            
                $jobs[] = new AmazonQueueJob($chunk);
            }

            Bus::batch($jobs)
            ->then(function () {
                Log::info("All batches have been processed.");
            })
            ->catch(function () {
                Log::error("There was a failed batch.");
            })
            ->dispatch(); */

            $batchSize = 500; // 20 request per batch
            $delayStart = now(); // Mulai delay
            $amazon_table = DB::table('amazon_table')->orderBy('id');
            $amazon_table->chunk($batchSize, function ($users, $batchIndex) use ($delayStart) {
                // $delay = $delayStart->addMinutes($batchIndex * 2); // Setiap batch ditunda 3 detik
                $jobs = $users->map(fn($user) => (new AmazonQueueJob($user)));

                Bus::batch($jobs)->dispatch();
            });

            return response()->json(['message' => 'Data is being processed in a queue.']);
        // }
    }

    public function getProduct($store, $asin, $req)
    {
        // ADRI
        $all_request = $req;
        // PALIGU 
        $productData = $this->keepaService->getProduct($asin);

        // Check if product data is available
        $itemCondition = [
            '-',
            'USED_LIKE_NEW',
            'USED_VERY_GOOD',
            'USED_GOOD',
            'USED_ACCEPTABLE',
            'COLLECTIBLE_LIKE_NEW*',
            'COLLECTIBLE_VERY_GOOD*',
            'COLLECTIBLE_GOOD*',
            'COLLECTIBLE_ACCEPTABLE*',
            'NOT_USED',
            'REFURBISHED',
            'NEW',
        ];
        if (!isset($productData['products']) || empty($productData['products'])) {
            Log::info("Product {$asin} not found");
            $formattedProduct = [
                'store' => $store,
                'asin' => $all_request->asin,
                'title' => $all_request->title,
                // 'description' => $all_request[1],
                // 'shortDescription' => $all_request[1],
                // 'image' => $all_request[7],
                // 'productType' => $all_request[7],
                'current_price' => $all_request->price ?? 'N/A',
                'current_qty' => $all_request->quantity ?? 'N/A',
                'listing_id' => $all_request->listing_id,
                'seller_sku' => $all_request->seller_sku,
                'itemCondition' => $itemCondition[$all_request->item_condition]
            ];

            // if (!empty($formattedProduct) && !Keepa::where('asin', $formattedProduct['asin'])->exists()) {
            if (!empty($formattedProduct)) {
                $formattedProduct = array_map(function($value) {
                    return is_array($value) ? json_encode($value) : $value;
                }, $formattedProduct);
                Keepa::create($formattedProduct);
                Log::info("Job process done. Product not found {$asin} saved to db from excel");
            }
            return response()->json(['error' => 'Product not found'], 404);
        }        
        Log::info("Product {$asin} found");
        
        $tokensLeft = $productData['tokensLeft'];
        $refillIn = $productData['refillIn'];
        $tokensConsumed = $productData['tokensConsumed'];
        
        // Extract product details
        $product = $productData['products'][0];

        $formattedProduct = [   
            'store' => $store,
            'asin' => $product['asin'],
            'title' => $product['title'],
            'brand' => $product['brand'] ?? 'Unknown',
            'category' => $product['categoryTree'][0]['name'] ?? 'Unknown',
            'image' => explode(',', $product['imagesCSV'])[0] ?? null,
            'current_price' => $all_request->price ?? 'N/A',
            'current_qty' => $all_request->quantity ?? 'N/A',
            // 'current_price' => $product['data']['price']['current'] ?? 'N/A',
            'highest_price' => $product['data']['price']['highest'] ?? 'N/A',
            'lowest_price' => $product['data']['price']['lowest'] ?? 'N/A',
            'productType' => $product['productType'] ?? null,
            'domainId' => $product['domainId'] ?? null,
            'trackingSince' => $product['trackingSince'] ?? null,
            'listedSince' => $product['listedSince'] ?? null,
            'lastUpdate' => $product['lastUpdate'] ?? null,
            'lastRatingUpdate' => $product['lastRatingUpdate'] ?? null,
            'lastPriceChange' => $product['lastPriceChange'] ?? null,
            'lastEbayUpdate' => $product['lastEbayUpdate'] ?? null,
            'lastStockUpdate' => $product['lastStockUpdate'] ?? null,
            'rootCategory' => $product['rootCategory'] ?? null,
            'categories' => $product['categories'] ?? [],
            'parentAsin' => $product['parentAsin'] ?? null,
            'parentAsinHistory' => $product['parentAsinHistory'] ?? [],
            'frequentlyBoughtTogether' => $product['frequentlyBoughtTogether'] ?? [],
            'eanList' => $product['eanList'] ?? [],
            'upcList' => $product['upcList'] ?? [],
            'manufacturer' => $product['manufacturer'] ?? null,
            'brandStoreName' => $product['brandStoreName'] ?? null,
            'brandStoreUrl' => $product['brandStoreUrl'] ?? null,
            'brandStoreUrlName' => $product['brandStoreUrlName'] ?? null,
            'productGroup' => $product['productGroup'] ?? null,
            'type' => $product['type'] ?? null,
            'partNumber' => $product['partNumber'] ?? null,
            'binding' => $product['binding'] ?? null,
            'scent' => $product['scent'] ?? null,
            'shortDescription' => $product['shortDescription'] ?? null,
            'activeIngredients' => $product['activeIngredients'] ?? null,
            'specialIngredients' => $product['specialIngredients'] ?? null,
            'itemForm' => $product['itemForm'] ?? null,
            'itemTypeKeyword' => $product['itemTypeKeyword'] ?? null,
            'recommendedUsesForProduct' => $product['recommendedUsesForProduct'] ?? null,
            'pattern' => $product['pattern'] ?? null,
            'specificUsesForProduct' => $product['specificUsesForProduct'] ?? [],
            'businessDiscount' => $product['businessDiscount'] ?? null,
            'lastBusinessDiscountUpdate' => $product['lastBusinessDiscountUpdate'] ?? null,
            'safetyWarning' => $product['safetyWarning'] ?? null,
            'productBenefit' => $product['productBenefit'] ?? null,
            'batteriesRequired' => $product['batteriesRequired'] ?? null,
            'batteriesIncluded' => $product['batteriesIncluded'] ?? null,
            'targetAudienceKeyword' => $product['targetAudienceKeyword'] ?? null,
            'style' => $product['style'] ?? null,
            'includedComponents' => $product['includedComponents'] ?? null,
            'material' => $product['material'] ?? null,
            'numberOfItems' => $product['numberOfItems'] ?? null,
            'numberOfPages' => $product['numberOfPages'] ?? null,
            'publicationDate' => $product['publicationDate'] ?? null,
            'releaseDate' => $product['releaseDate'] ?? null,
            'contributors' => $product['contributors'] ?? [],
            'languages' => $product['languages'] ?? [],
            'model' => $product['model'] ?? null,
            'color' => $product['color'] ?? null,
            'size' => $product['size'] ?? null,
            'edition' => $product['edition'] ?? null,
            'format' => $product['format'] ?? null,
            'features' => $product['features'] ?? [],
            'description' => $product['description'] ?? null,
            'hazardousMaterials' => $product['hazardousMaterials'] ?? [],
            'packageHeight' => $product['packageHeight'] ?? null,
            'packageLength' => $product['packageLength'] ?? null,
            'packageWidth' => $product['packageWidth'] ?? null,
            'packageWeight' => $product['packageWeight'] ?? null,
            'packageQuantity' => $product['packageQuantity'] ?? null,
            'itemHeight' => $product['itemHeight'] ?? null,
            'itemLength' => $product['itemLength'] ?? null,
            'itemWidth' => $product['itemWidth'] ?? null,
            'itemWeight' => $product['itemWeight'] ?? null,
            'availabilityAmazon' => $product['availabilityAmazon'] ?? null,
            'availabilityAmazonDelay' => $product['availabilityAmazonDelay'] ?? [],
            'buyBoxEligibleOfferCounts' => $product['buyBoxEligibleOfferCounts'] ?? [],
            'competitivePriceThreshold' => $product['competitivePriceThreshold'] ?? null,
            'suggestedLowerPrice' => $product['suggestedLowerPrice'] ?? null,
            'ebayListingIds' => $product['ebayListingIds'] ?? [],
            'isAdultProduct' => $product['isAdultProduct'] ?? null,
            'isHeatSensitive' => $product['isHeatSensitive'] ?? null,
            'isMerchOnDemand' => $product['isMerchOnDemand'] ?? null,
            'isHaul' => $product['isHaul'] ?? null,
            'launchpad' => $product['launchpad'] ?? null,
            'audienceRating' => $product['audienceRating'] ?? null,
            'ingredients' => $product['ingredients'] ?? null,
            'urlSlug' => $product['urlSlug'] ?? null,
            'returnRate' => $product['returnRate'] ?? null,
            'newPriceIsMAP' => $product['newPriceIsMAP'] ?? null,
            'isEligibleForTradeIn' => $product['isEligibleForTradeIn'] ?? null,
            'isEligibleForSuperSaverShipping' => $product['isEligibleForSuperSaverShipping'] ?? null,
            'fbaFees' => $product['fbaFees'] ?? null,
            'variableClosingFee' => $product['variableClosingFee'] ?? null,
            'referralFeePercentage' => $product['referralFeePercentage'] ?? null,
            'variations' => $product['variations'] ?? [],
            'coupon' => $product['coupon'] ?? [],
            'couponHistory' => $product['couponHistory'] ?? [],
            'promotions' => $product['promotions'] ?? [],
            'unitCount' => $product['unitCount'] ?? null,
            'stats' => $product['stats'] ?? null,
            // 'salesRankReference' => $product['salesRankReference'] ?? null,
            // 'salesRankReferenceHistory' => $product['salesRankReferenceHistory'] ?? [],
            // 'salesRanks' => $product['salesRanks'] ?? null,
            'salesRankReference' => null,
            'salesRankReferenceHistory' => [],
            'salesRanks' => null,
            'lastSoldUpdate' => $product['lastSoldUpdate'] ?? null,
            'monthlySold' => $product['monthlySold'] ?? null,
            'monthlySoldHistory' => $product['monthlySoldHistory'] ?? [],
            'rentalDetails' => $product['rentalDetails'] ?? null,
            'rentalSellerId' => $product['rentalSellerId'] ?? null,
            'rentalPrices' => $product['rentalPrices'] ?? null,
            'reviews' => $product['reviews'] ?? null,
            'offers' => $product['offers'] ?? [],
            'liveOffersOrder' => $product['liveOffersOrder'] ?? [],
            'buyBoxSellerIdHistory' => $product['buyBoxSellerIdHistory'] ?? [],
            'buyBoxUsedHistory' => $product['buyBoxUsedHistory'] ?? [],
            'isRedirectASIN' => $product['isRedirectASIN'] ?? null,
            'isSNS' => $product['isSNS'] ?? null,
            'offersSuccessful' => $product['offersSuccessful'] ?? null,
            // 'csv' => $product['csv'] ?? [],
            'csv' => null,
            'listing_id' => $all_request->listing_id,
            'seller_sku' => $all_request->seller_sku,
            'itemCondition' => $itemCondition[$all_request->item_condition],
        ];        
        //check if any error or empty and save it to database if not exists
        // if (!empty($formattedProduct) && !Keepa::where('asin', $formattedProduct['asin'])->exists()) {
        if (!empty($formattedProduct)) {
            $formattedProduct = array_map(function($value) {
                return is_array($value) ? json_encode($value) : $value;
            }, $formattedProduct);
            Keepa::create($formattedProduct);
            Log::info("Job process done. Product {$asin} saved to db from keepa");
        }
        
        //return response()->json($formattedProduct);
        return response()->json($productData);
    }

    public function auth(Request $request)
    {
        // Our authentication logic can be here (if necessary)
    }

    public function getKeepaProduct($store, $asin) 
    {
        $productData = $this->keepaService->getProduct($asin);
        $product = $productData['products'][0];
        
        // Exclude "email"
        $excludedKeys = ["csv"];
        $result = array_diff_key($product, array_flip($excludedKeys));
        $excludedKeys = ["salesRanks"];
        $result = array_diff_key($result, array_flip($excludedKeys));
        
        
        // $formattedProduct = [   
        //     'store' => $store,
        //     'asin' => $product['asin'],
        //     'title' => $product['title'],
        //     'brand' => $product['brand'] ?? 'Unknown',
        //     'category' => $product['categoryTree'][0]['name'] ?? 'Unknown',
        //     'image' => explode(',', $product['imagesCSV'])[0] ?? null,
        //     // 'current_price' => $product['data']['price']['current'] ?? 'N/A',
        //     'highest_price' => $product['data']['price']['highest'] ?? 'N/A',
        //     'lowest_price' => $product['data']['price']['lowest'] ?? 'N/A',
        //     'productType' => $product['productType'] ?? null,
        //     'domainId' => $product['domainId'] ?? null,
        //     'trackingSince' => $product['trackingSince'] ?? null,
        //     'listedSince' => $product['listedSince'] ?? null,
        //     'lastUpdate' => $product['lastUpdate'] ?? null,
        //     'lastRatingUpdate' => $product['lastRatingUpdate'] ?? null,
        //     'lastPriceChange' => $product['lastPriceChange'] ?? null,
        //     'lastEbayUpdate' => $product['lastEbayUpdate'] ?? null,
        //     'lastStockUpdate' => $product['lastStockUpdate'] ?? null,
        //     'rootCategory' => $product['rootCategory'] ?? null,
        //     'categories' => $product['categories'] ?? [],
        //     'parentAsin' => $product['parentAsin'] ?? null,
        //     'parentAsinHistory' => $product['parentAsinHistory'] ?? [],
        //     'frequentlyBoughtTogether' => $product['frequentlyBoughtTogether'] ?? [],
        //     'eanList' => $product['eanList'] ?? [],
        //     'upcList' => $product['upcList'] ?? [],
        //     'manufacturer' => $product['manufacturer'] ?? null,
        //     'brandStoreName' => $product['brandStoreName'] ?? null,
        //     'brandStoreUrl' => $product['brandStoreUrl'] ?? null,
        //     'brandStoreUrlName' => $product['brandStoreUrlName'] ?? null,
        //     'productGroup' => $product['productGroup'] ?? null,
        //     'type' => $product['type'] ?? null,
        //     'partNumber' => $product['partNumber'] ?? null,
        //     'binding' => $product['binding'] ?? null,
        //     'scent' => $product['scent'] ?? null,
        //     'shortDescription' => $product['shortDescription'] ?? null,
        //     'activeIngredients' => $product['activeIngredients'] ?? null,
        //     'specialIngredients' => $product['specialIngredients'] ?? null,
        //     'itemForm' => $product['itemForm'] ?? null,
        //     'itemTypeKeyword' => $product['itemTypeKeyword'] ?? null,
        //     'recommendedUsesForProduct' => $product['recommendedUsesForProduct'] ?? null,
        //     'pattern' => $product['pattern'] ?? null,
        //     'specificUsesForProduct' => $product['specificUsesForProduct'] ?? [],
        //     'businessDiscount' => $product['businessDiscount'] ?? null,
        //     'lastBusinessDiscountUpdate' => $product['lastBusinessDiscountUpdate'] ?? null,
        //     'safetyWarning' => $product['safetyWarning'] ?? null,
        //     'productBenefit' => $product['productBenefit'] ?? null,
        //     'batteriesRequired' => $product['batteriesRequired'] ?? null,
        //     'batteriesIncluded' => $product['batteriesIncluded'] ?? null,
        //     'targetAudienceKeyword' => $product['targetAudienceKeyword'] ?? null,
        //     'style' => $product['style'] ?? null,
        //     'includedComponents' => $product['includedComponents'] ?? null,
        //     'material' => $product['material'] ?? null,
        //     'numberOfItems' => $product['numberOfItems'] ?? null,
        //     'numberOfPages' => $product['numberOfPages'] ?? null,
        //     'publicationDate' => $product['publicationDate'] ?? null,
        //     'releaseDate' => $product['releaseDate'] ?? null,
        //     'contributors' => $product['contributors'] ?? [],
        //     'languages' => $product['languages'] ?? [],
        //     'model' => $product['model'] ?? null,
        //     'color' => $product['color'] ?? null,
        //     'size' => $product['size'] ?? null,
        //     'edition' => $product['edition'] ?? null,
        //     'format' => $product['format'] ?? null,
        //     'features' => $product['features'] ?? [],
        //     'description' => $product['description'] ?? null,
        //     'hazardousMaterials' => $product['hazardousMaterials'] ?? [],
        //     'packageHeight' => $product['packageHeight'] ?? null,
        //     'packageLength' => $product['packageLength'] ?? null,
        //     'packageWidth' => $product['packageWidth'] ?? null,
        //     'packageWeight' => $product['packageWeight'] ?? null,
        //     'packageQuantity' => $product['packageQuantity'] ?? null,
        //     'itemHeight' => $product['itemHeight'] ?? null,
        //     'itemLength' => $product['itemLength'] ?? null,
        //     'itemWidth' => $product['itemWidth'] ?? null,
        //     'itemWeight' => $product['itemWeight'] ?? null,
        //     'availabilityAmazon' => $product['availabilityAmazon'] ?? null,
        //     'availabilityAmazonDelay' => $product['availabilityAmazonDelay'] ?? [],
        //     'buyBoxEligibleOfferCounts' => $product['buyBoxEligibleOfferCounts'] ?? [],
        //     'competitivePriceThreshold' => $product['competitivePriceThreshold'] ?? null,
        //     'suggestedLowerPrice' => $product['suggestedLowerPrice'] ?? null,
        //     'ebayListingIds' => $product['ebayListingIds'] ?? [],
        //     'isAdultProduct' => $product['isAdultProduct'] ?? null,
        //     'isHeatSensitive' => $product['isHeatSensitive'] ?? null,
        //     'isMerchOnDemand' => $product['isMerchOnDemand'] ?? null,
        //     'isHaul' => $product['isHaul'] ?? null,
        //     'launchpad' => $product['launchpad'] ?? null,
        //     'audienceRating' => $product['audienceRating'] ?? null,
        //     'ingredients' => $product['ingredients'] ?? null,
        //     'urlSlug' => $product['urlSlug'] ?? null,
        //     'returnRate' => $product['returnRate'] ?? null,
        //     'newPriceIsMAP' => $product['newPriceIsMAP'] ?? null,
        //     'isEligibleForTradeIn' => $product['isEligibleForTradeIn'] ?? null,
        //     'isEligibleForSuperSaverShipping' => $product['isEligibleForSuperSaverShipping'] ?? null,
        //     'fbaFees' => $product['fbaFees'] ?? null,
        //     'variableClosingFee' => $product['variableClosingFee'] ?? null,
        //     'referralFeePercentage' => $product['referralFeePercentage'] ?? null,
        //     'variations' => $product['variations'] ?? [],
        //     'coupon' => $product['coupon'] ?? [],
        //     'couponHistory' => $product['couponHistory'] ?? [],
        //     'promotions' => $product['promotions'] ?? [],
        //     'unitCount' => $product['unitCount'] ?? null,
        //     'stats' => $product['stats'] ?? null,
        //     // 'salesRankReference' => $product['salesRankReference'] ?? null,
        //     // 'salesRankReferenceHistory' => $product['salesRankReferenceHistory'] ?? [],
        //     // 'salesRanks' => $product['salesRanks'] ?? null,
        //     'salesRankReference' => null,
        //     'salesRankReferenceHistory' => [],
        //     'salesRanks' => null,
        //     'lastSoldUpdate' => $product['lastSoldUpdate'] ?? null,
        //     'monthlySold' => $product['monthlySold'] ?? null,
        //     'monthlySoldHistory' => $product['monthlySoldHistory'] ?? [],
        //     'rentalDetails' => $product['rentalDetails'] ?? null,
        //     'rentalSellerId' => $product['rentalSellerId'] ?? null,
        //     'rentalPrices' => $product['rentalPrices'] ?? null,
        //     'reviews' => $product['reviews'] ?? null,
        //     'offers' => $product['offers'] ?? [],
        //     'liveOffersOrder' => $product['liveOffersOrder'] ?? [],
        //     'buyBoxSellerIdHistory' => $product['buyBoxSellerIdHistory'] ?? [],
        //     'buyBoxUsedHistory' => $product['buyBoxUsedHistory'] ?? [],
        //     'isRedirectASIN' => $product['isRedirectASIN'] ?? null,
        //     'isSNS' => $product['isSNS'] ?? null,
        //     'offersSuccessful' => $product['offersSuccessful'] ?? null,
        //     'csv' => $product['csv'] ?? [],
        // ];

        return response()->json($result);
    }

    public function view($id) 
    {

        try {
            $product = Keepa::where('id', $id)->findOrFail($id);
            return view('business.partials.view-amazon-modal')->with(compact(
                'product',
            ));
        } catch (\Exception $e) {
            Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());
        }
    }

    public function allKeepaCategories($category)
    {
        $categories = $this->keepaService->getAllCategories($category);
        return $categories;
    }

    public function updateProduct($store, $asin, $req) 
    {
        $productData = $this->keepaService->getProduct($asin);
        $product = $productData['products'][0];
        
        // Exclude "email"
        $excludedKeys = ["csv"];
        $result = array_diff_key($product, array_flip($excludedKeys));
        $excludedKeys = ["salesRanks"];
        $result = array_diff_key($result, array_flip($excludedKeys));
        $itemCondition = [
            '-',
            'USED_LIKE_NEW',
            'USED_VERY_GOOD',
            'USED_GOOD',
            'USED_ACCEPTABLE',
            'COLLECTIBLE_LIKE_NEW*',
            'COLLECTIBLE_VERY_GOOD*',
            'COLLECTIBLE_GOOD*',
            'COLLECTIBLE_ACCEPTABLE*',
            'NOT_USED',
            'REFURBISHED',
            'NEW',
        ];
        Keepa::where('asin', $req->asin)->where('seller_sku', $req->seller_sku)->update([
            'current_price' => $req->price,
            'current_qty' => $req->quantity,
            'itemCondition' => $itemCondition[$req->item_condition],
            'categoryTree' => $result['categoryTree'],
            'edition' => $result['edition'],
            'format' => $result['format'],
        ]);

        return response()->json($result);
    } 

    public function labels(Request $request, $id) 
    {
        if (! auth()->user()->can('product.print_labels')) {
            abort(403, 'Unauthorized action.');
        }
        $business_id = $request->session()->get('user.business_id');
        //$products = Keepa::where('id',$id)->get();
        $products = DB::table('amazon_table')->where('SellerSku', $id)->get();

        //get price groups
        $price_groups = [];
        if (! empty($purchase_id) || ! empty($product_id)) {
            $price_groups = SellingPriceGroup::where('business_id', $business_id)
                                    ->active()
                                    ->pluck('name', 'id');
        }

        $barcode_settings = Barcode::where('business_id', $business_id)
                                ->orWhereNull('business_id')
                                ->select(DB::raw('CONCAT(name, ", ", COALESCE(description, "")) as name, id, is_default'))
                                ->get();
        $default = $barcode_settings->where('is_default', 1)->first();
        $barcode_settings = $barcode_settings->pluck('name', 'id');
        $information_labels = DB::table('information_labels')->get()->toArray();

        return view('business.partials.amazon_labels_show')
            ->with(compact('products', 'barcode_settings', 'default', 'price_groups', 'information_labels'));
    }

    public function labelsPreview(Request $request)
    {
        try {
            //code...
            $products = $request->get('products');

            $product_title = $request->get('product_title');
            $product_title = $product_title ? $product_title : '';

            $product_price = $request->get('product_price');
            $product_price = $product_price ? $product_price : 0;

            //Log::info('labelsPreview product_price: '.$product_price);
            Log::info('labelsPreview products: '.json_encode($products));
            $print = $request->get('print');
            //Log::info('labelsPreview print: '.json_encode($print));
            $barcode_setting = $request->get('barcode_setting');
            $business_id = $request->session()->get('user.business_id');
            $barcode_details = Barcode::find($barcode_setting);
            $barcode_details->stickers_in_one_sheet = $barcode_details->is_continuous ? $barcode_details->stickers_in_one_row : $barcode_details->stickers_in_one_sheet;
            $barcode_details->paper_height = $barcode_details->is_continuous ? $barcode_details->height : $barcode_details->paper_height;
            if ($barcode_details->stickers_in_one_row == 1) {
                $barcode_details->col_distance = 0;
                $barcode_details->row_distance = 0;
            }
            // if($barcode_details->is_continuous){
            //     $barcode_details->row_distance = 0;
            // }

            $business_name = $request->session()->get('business.name');

            $product_details_page_wise = [];
            $total_qty = 0;
            foreach ($products as $value) {
                Log::info('labelsPreview value: '.json_encode($value));
                $details = Keepa::find($value['product_id']);
                
                //Log::info('labelsPreview seller_sku: '.$details->seller_sku);

                // $product_title = DB::table('amazon_table')
                //     ->where('SellerSku', $details->seller_sku)
                //     ->value('Title');
                
                
                if (! empty($value['exp_date'])) {
                    $details->exp_date = $value['exp_date'];
                }
                if (! empty($value['packing_date'])) {
                    $details->packing_date = $value['packing_date'];
                }
                if (! empty($value['lot_number'])) {
                    $details->lot_number = $value['lot_number'];
                }

                $details->product_title = $product_title;
                $details->product_price = $product_price;
                $details->barcode_type = 'C128';

                Log::info('labelsPreview details: '.json_encode($details));

                for ($i = 0; $i < $value['quantity']; $i++) {
                    $page = intdiv($total_qty, $barcode_details->stickers_in_one_sheet);

                    if ($total_qty % $barcode_details->stickers_in_one_sheet == 0) {
                        $product_details_page_wise[$page] = [];
                    }

                    $product_details_page_wise[$page][] = $details;
                    $total_qty++;
                }
            }

            $margin_top = $barcode_details->is_continuous ? 0 : $barcode_details->top_margin * 1;
            $margin_left = $barcode_details->is_continuous ? 0 : $barcode_details->left_margin * 1;
            $paper_width = $barcode_details->paper_width * 1;
            $paper_height = $barcode_details->paper_height * 1;

            $i = 0;
            $len = count($product_details_page_wise);
            $is_first = false;
            $is_last = false;

            //$original_aspect_ratio = 4;//(w/h)
            $factor = (($barcode_details->width / $barcode_details->height)) / ($barcode_details->is_continuous ? 2 : 4);
            $html = '';
            foreach ($product_details_page_wise as $page => $page_products) {
                if ($i == 0) {
                    $is_first = true;
                }

                if ($i == $len - 1) {
                    $is_last = true;
                }

                $output = view('business.partials.amazon_labels_preview')
                            ->with(compact('print', 'page_products', 'business_name', 'barcode_details', 'margin_top', 'margin_left', 'paper_width', 'paper_height', 'is_first', 'is_last', 'factor'))->render();
                print_r($output);

                // return view('business.partials.amazon_labels_preview')
                //             ->with(compact('print', 'page_products', 'business_name', 'barcode_details', 'margin_top', 'margin_left', 'paper_width', 'paper_height', 'is_first', 'is_last', 'factor'));
                //$mpdf->WriteHTML($output);

                // if($i < $len - 1){
                //     // '', '', '', '', '', '', $margin_left, $margin_left, $margin_top, $margin_top, '', '', '', '', '', '', 0, 0, 0, 0, '', [$barcode_details->paper_width*1, $barcode_details->paper_height*1]
                //     $mpdf->AddPage();
                // }

                $i++;
            }

            print_r('<script>window.print()</script>');
            exit;
        } catch (\Exception $e) {
            //throw $th;
            \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = __('lang_v1.barcode_label_error');
        }        
    }
}
