<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class KeepaWebhookController extends Controller
{
    public function handleWebhook(Request $request)
    {
        // Log incoming request for debugging
        Log::info('Keepa Webhook Received:', $request->all());

        // Verify Keepa API Key (Optional: If Keepa sends a secret key for security)
        $keepaApiKey = config('services.keepa.api_key'); // Store API key in config/services.php
        if ($request->header('Authorization') !== 'Bearer ' . $keepaApiKey) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }

        // Process Keepa Webhook Notification
        $data = $request->all();

        // Example: Extracting important fields (modify based on actual response)
        if (!isset($data['asin'])) {
            return response()->json(['error' => 'Invalid data'], 400);
        }

        $asin = $data['asin'];
        $price = $data['price'] ?? null;
        $timestamp = now();

        // You can store this data in the database
        Log::info("Keepa Webhook - ASIN: $asin, Price: $price, Time: $timestamp");

        return response()->json(['message' => 'Webhook received successfully'], 200);
    }
}
