<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class MobileBarcodeScanner extends Controller
{
    public function showScanPage()
    {
        return view('barcode.mobile-scan');
    }

    public function processBarcode(Request $request)
    {
        $request->validate([
            'barcode' => 'required|string',
        ]);

        $barcode = $request->input('barcode');
        Log::info('Barcode scanned: ' . $barcode);

        return response()->json([
            'success' => true,
            'message' => 'Barcode scanned: ' . $barcode
        ]);
        
    }
}
