<?php

namespace App\Http\Controllers;

use App\Business;
use App\Category;
use App\Contact;
use App\Expense;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\Transaction;
use App\Variation;
use App\VariationLocationDetails;
use Carbon\Carbon;
use DateInterval;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use QuickBooksOnline\API\Core\OAuth\OAuth2\OAuth2LoginHelper;
use QuickBooksOnline\API\DataService\DataService;
use QuickBooksOnline\API\Exception\ServiceException;

class QuickBooksController extends Controller
{
    private $OAuth2LoginHelper;
    private $product_locations;
    // get oauth2 token
    public function auth(Request $request) 
    {                
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings', 'refresh_token_quickbooks', 'expired_token_quickbooks')->first();               
        $this->product_locations = array($request->input('product_locations')); 
        /* if(empty($product_locations)) {
          return response()->json([
            'message' => 'Location must be selected',
            'data' => null
          ]);
        } */
        try {
            $accounting_settings = json_decode($business->accounting_settings);

            if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret && $accounting_settings->quickbooks_api_access_token) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
            // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
            $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
            $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
            $Quickbooks_TOKEN = $accounting_settings->quickbooks_api_access_token;        
            if(strtotime(date('Y-m-d H:i:s')) >= strtotime($business->refresh_token_quickbooks)) {
                $oauth2LoginHelper = new OAuth2LoginHelper($Quickbooks_KEY,$Quickbooks_SECRET);            
                $accessTokenObj = $oauth2LoginHelper->
                                    refreshAccessTokenWithRefreshToken($business->refresh_token_quickbooks);            
                $accessTokenValue = $accessTokenObj->getAccessToken();
                $Quickbooks_TOKEN = $accessTokenValue;
                $refreshTokenValue = $accessTokenObj->getRefreshToken();
                $minutes_to_add = 60;

                $time = new DateTime();
                $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));

                $stamp = $time->format('Y-m-d H:i');
                $accounting_settings->quickbooks_api_access_token = $accessTokenValue;
                Business::where('id', $business_id)->update([
                    'accounting_settings' => json_encode($accounting_settings),
                    'refresh_token_quickbooks' => $refreshTokenValue,
                    'expired_token_quickbooks' => $stamp
                ]);
            }
            } else {
            return 'Url and Access Token Shopify Not Found';
            }
            
            $data = $this->get_data($request, 'expense', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            $data_customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            $data_invoices = $this->get_data($request, 'invoice', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            $data_products = $this->get_data($request, 'item', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            DB::beginTransaction();        
            //code...
            $save_data = $this->save_data($data['Rows'], $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            $save_customer = $this->save_customer($data_customer['QueryResponse'], $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            $save_invoices = $this->save_invoices($data_invoices['QueryResponse'], $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            $save_products = $this->save_products($data_products['QueryResponse'], $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            DB::commit();
            if($save_products['rc'] == 200) {
                return response()->json([
                    'message' => 'Recevied Data Success',
                    // 'data' => $save_data['array_insert']
                    'data' => []
                ]);                
            } else {
                return response()->json([
                    'message' => $save_products['msg'],
                    'data' => []
                ]);
            }
        } catch (\Exception $err) {
            //throw $th;                           
            DB::rollBack();
            return response()->json([
                'message' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        } catch (ServiceException $qb) {
            //throw $th;            
            // DB::rollBack();
            $b = Business::find($business_id);
            $b->refresh_token_quickbooks = null;
            $b->expired_token_quickbooks = null;
            $b->save();
            DB::commit();
            return response()->json([
                'rc' => 500,
                'msg' => $qb->getMessage()
            ]);
        }      
        // return $authorizationCodeUrl;
        
        /* how to get token */
        // $accessTokenObj = $OAuth2LoginHelper->exchangeAuthorizationCodeForToken("AB11689737277WNXUAq8AYuJksIoyLPalK6VxDxu0XJaxOuKUR", "4620816365318733720");
        // $dataService->updateOAuth2Token($accessTokenObj);
        // $accessTokenValue = $accessTokenObj->getAccessToken();
        // $refreshTokenValue = $accessTokenObj->getRefreshToken();        
    }

    public function get_data(Request $request, $type, $url, $client_id, $client_secret, $token) 
    {        
        if($type == 'expense') {
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                CURLOPT_URL => $url.'/reports/TransactionList?minorversion=65&start_date=1900-01-01&end_date='.date('Y-m-d'),
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: Bearer '. $token
                )
            
                )
            );

            $response = curl_exec($curl);
            $parseResponse = json_decode($response, true);
            // dd($parseResponse);
            return $parseResponse;
        } else if($type == 'Customer' || $type == 'invoice' || $type == 'item' || $type == 'taxrate' || $type == 'term' || $type == 'Account' || $type == 'paymentmethod' || $type == 'vendor') {            
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                CURLOPT_URL => $url.'/query?minorversion=65',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_POST => 1,
                CURLOPT_POSTFIELDS => "Select * from ".$type." startposition 1 maxresults 1000",
                CURLOPT_RETURNTRANSFER => 1,
                CURLOPT_HTTPHEADER => array(
                    'Accept: application/json',
                    'Content-Type: application/text',
                    'Authorization: Bearer '. $token
                )
            
                )
            );

            $response = curl_exec($curl);
            $parseResponse = json_decode($response, true);                   
            return $parseResponse;            
        } else if($type == 'get_invoice') {            
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_URL => $url.'/invoice/'.$request->id.'?minorversion=65',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,                                
                    CURLOPT_RETURNTRANSFER => 1,
                    CURLOPT_HTTPHEADER => array(
                        'Accept: application/json',
                        'Content-Type: application/json',
                        'Authorization: Bearer '. $token
                    )                
                )
            );

            $response = curl_exec($curl);
            $parseResponse = json_decode($response, true);                   
            return $parseResponse;
        } else if($type == 'refundreceipt') {            
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_URL => $url.'/refundreceipt/'.$request->id.'?minorversion=65',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,                                
                    CURLOPT_RETURNTRANSFER => 1,
                    CURLOPT_HTTPHEADER => array(
                        'Accept: application/json',
                        'Content-Type: application/json',
                        'Authorization: Bearer '. $token
                    )                
                )
            );

            $response = curl_exec($curl);
            $parseResponse = json_decode($response, true);                   
            return $parseResponse;
        } else if($type == 'payment' || $type == 'creditmemo' || $type == 'estimate' || $type == 'purchase' || $type == 'purchaseorder' || $type == 'bill' || $type == 'payment' || $type == 'salesreceipt') {
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_URL => $url.'/'.$type.'/'.$request->id.'?minorversion=65',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,                                
                    CURLOPT_RETURNTRANSFER => 1,
                    CURLOPT_HTTPHEADER => array(
                        'Accept: application/json',
                        'Content-Type: application/json',
                        'Authorization: Bearer '. $token
                    )                
                )
            );

            $response = curl_exec($curl);
            $parseResponse = json_decode($response, true);                   
            return $parseResponse;
        }
    }

    public function get_vendor($id, $url, $client_id, $client_secret, $token)
    {
        // dd($id);
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $url.'/vendor/'.$id.'?minorversion=65',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                /* CURLOPT_POSTFIELDS => [
                    "id" => $id,
                    "SyncToken" => "1"
                ], */
                CURLOPT_HTTPHEADER => array(
                    'Accept: application/json',
                    'Content-Type: application/json',
                    'Authorization: Bearer '.$token
                )    
            )
        );

        $response = curl_exec($curl);        
        $parseResponse = json_decode($response, true);
        return $parseResponse;
    }

    public function save_data($data, $url, $client_id, $client_secret, $token) 
    {        
        $no = 0;
        $arr = [];
        $status = '';
        if(array_key_exists('Row', $data)) {            
            DB::table('expense')->delete();
            foreach ($data['Row'] as $key => $value) {
                # code...   
                /* if($value['ColData'][1]['value'] == 'Purchase Order' || $value['ColData'][1]['value'] == 'Bill' || $value['ColData'][1]['value'] == 'Bill' || str_contains($value['ColData'][1]['value'], 'Bill Payment') || str_contains($value['ColData'][1]['value'], 'Credit Card') || $value['ColData'][1]['value'] == 'Check' || str_contains($value['ColData'][1]['value'], 'Expense')) { */
                    $balance = 0;                
                    $arr_data = [];
                    if($value['ColData'][1]['value'] == 'Bill') {
                        request()->request->add(['id' => $value['ColData'][1]['id']]);
                        $bill = $this->get_data(request(), 'bill', $url, $client_id, $client_secret, $token);
                        if(array_key_exists('Bill', $bill)) {
                            $balance = $bill['Bill']['Balance'];
                        }
                    }                
                    $arr_data = [
                        'id_vendor' => $value['ColData'][1]['id'],
                        'date' => $value['ColData'][0]['value'],
                        'transaction_type' => $value['ColData'][1]['value'],
                        'num' => $value['ColData'][2]['value'],
                        'posting' => $value['ColData'][3]['value'],
                        'name' => $value['ColData'][4]['value'],
                        'memo' => $value['ColData'][5]['value'],
                        'account' => $value['ColData'][6]['value'],
                        'split' => $value['ColData'][7]['value'],
                        'amount' => $value['ColData'][8]['value'],
                        'balance' => $balance                 
                    ];
                    
                    // $check_expense = Expense::where('id_vendor', $value['ColData'][4]['id'])->first();                
                    // if($check_expense == null) {
                        Expense::create($arr_data);
                        $no++;
                        $status = 1;
                        array_push($arr, [
                            'number' => $no,
                            'status' => $status
                        ]);
                    // } 
                    /* else {                    
                        if($value['ColData'][4]['id']) {
                            $expense = Expense::where('id_vendor', $value['ColData'][4]['id'])->first();
                            $expense_changed = Expense::find($expense->id);
                            $expense_changed->date = $arr_data['date'];
                            $expense_changed->transaction_type = $arr_data['transaction_type'];
                            $expense_changed->num = $arr_data['num'];
                            $expense_changed->posting = $arr_data['posting'];
                            $expense_changed->name = $arr_data['name'];
                            $expense_changed->memo = $arr_data['memo'];
                            $expense_changed->account = $arr_data['account'];
                            $expense_changed->split = $arr_data['split'];
                            $expense_changed->amount = $arr_data['amount'];
                            $expense_changed->balance = $arr_data['balance'];
                            $expense_changed->save();
                            if($expense_changed->wasChanged()) {
                                $no++;
                                $status = 2;
                                array_push($arr, [
                                    'number' => $no,
                                    'status' => $status,                        
                                ]);
                            }
                        } else {
                            Expense::create($arr_data);
                            $no++;
                            $status = 1;
                            array_push($arr, [
                                'number' => $no,
                                'status' => $status
                            ]);
                        }
                    } */
                // }             
            }

            return [
                'rc' => 200,
                'msg' => 'Success',
                'array_insert' => $arr
            ];
        } else {
            return [
                'rc' => 500,
                'msg' => 'Data not found',
                'array_insert' => $arr
            ];
        }
    }

    public function save_customer($data, $url, $client_id, $client_secret, $token)
    {
        $no = 0;
        $arr = [];
        $status = '';
        $business_id = request()->session()->get('user.business_id');
        if(array_key_exists('Customer', $data)) {            
            DB::select("delete from contacts where type = 'customer_quickbooks' and business_id = ".$business_id."");
            foreach ($data['Customer'] as $key => $value) {
                # code...                                
                $balance = 0;                
                $arr_data = [];
                $generate_contact_id = Contact::max('contact_id');
                $generate_contact_id = Contact::selectRaw('max(substr(contact_id, -1, 1)) as max_number')->first();
                $explode_name = explode(' ', $value['FullyQualifiedName']);
                $arr_data = [
                    'name' => $value['FullyQualifiedName'],
                    'business_id' => $business_id,
                    'type' => 'customer_quickbooks',
                    'first_name' => $explode_name[0],
                    'middle_name' => array_key_exists('1', $explode_name) ? $explode_name[1] : null,
                    'last_name' => array_key_exists('2', $explode_name) ? $explode_name[2] : null,
                    'contact_id' => $generate_contact_id->max_number + 1,
                    'contact_status' => 'active',
                    'mobile' => array_key_exists('PrimaryPhone', $value) ? $value['PrimaryPhone']['FreeFormNumber'] : rand(999999999999,10),
                    'created_by' => auth()->user()->id,
                    'balance' => $value['Balance'],
                    'address_line_1' => array_key_exists('BillAddr', $value) ? $value['BillAddr']['Line1'] : null,
                    'email' => array_key_exists('PrimaryEmailAddr', $value) ? $value['PrimaryEmailAddr']['Address']: null,
                ];
                
                Contact::create($arr_data);
                $no++;
                $status = 1;
                array_push($arr, [
                    'number' => $no,
                    'status' => $status
                ]);               
            }

            return [
                'rc' => 200,
                'msg' => 'Success',
                'array_insert' => $arr
            ];
        } else {
            return [
                'rc' => 500,
                'msg' => 'Data not found',
                'array_insert' => $arr
            ];
        }
    }

    public function save_invoices($data, $url, $client_id, $client_secret, $token)
    {
        $no = 0;
        $arr = [];
        $status = '';
        $business_id = request()->session()->get('user.business_id');
        if(array_key_exists('Invoice', $data)) {            
            DB::select("delete from invoice_quickbooks");
            foreach ($data['Invoice'] as $key => $value) {
                # code...                                
                $balance = 0;                
                $arr_data = [];                                
                $arr_data = [
                    'invoice_no' => $value['DocNumber'],
                    'products' => json_encode($value['Line']),
                    'txn_date' => $value['TxnDate'],
                    'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,
                    'linked_txn' => json_encode($value['LinkedTxn']),
                    'tax_details' => json_encode($value['TxnTaxDetail']),
                    'customer_ref' => json_encode($value['CustomerRef']),
                    'customer_memo' => array_key_exists('CustomerMemo', $value) ? $value['CustomerMemo']['value'] : null,
                    'free_from_address' => $value['FreeFormAddress'],
                    'due_date' => $value['DueDate'],
                    'total_amt' => $value['TotalAmt'],
                    'sync_token' => $value['SyncToken'],
                    'apply_tax_after_discount' => $value['ApplyTaxAfterDiscount'],
                    'print_status' => $value['PrintStatus'],
                    'email_status' => $value['EmailStatus'],
                    'email' => array_key_exists('BillEmail', $value) ? $value['BillEmail']['Address'] : null,
                    'balance' => $value['Balance'],
                    'invoice_id' => $value['Id']
                ];
                
                DB::table('invoice_quickbooks')->insert($arr_data);
                $no++;
                $status = 1;
                array_push($arr, [
                    'number' => $no,
                    'status' => $status
                ]);               
            }

            return [
                'rc' => 200,
                'msg' => 'Success',
                'array_insert' => $arr
            ];
        } else {
            return [
                'rc' => 500,
                'msg' => 'Data not found',
                'array_insert' => $arr
            ];
        }
    }

    public function save_products($data, $url, $client_id, $client_secret, $token)
    {
        $no = 0;
        $arr = [];
        $status = '';
        $business_id = request()->session()->get('user.business_id');
        if(array_key_exists('Item', $data)) {                        
            foreach ($data['Item'] as $key => $value) {                
                //code...
                # code...                                
                $balance = 0;                
                $arr_data = [];                    
                
                if($value['Type'] == 'Inventory' || $value['Type'] == 'Service' || $value['Type'] == "NonInventory") {
                    $category = null;
                    if(array_key_exists('ParentRef', $value)) {
                        $check_category = Category::where('quickbooks_id', $value['ParentRef']['value'])->first();
                        $category = $check_category->id;
                    }
                    $randomNumber = rand(999999999999, 10);
                    $arr_data = [
                        'Product' => [
                            'name' => $value['Name'],
                            'sku' => $value['Sku'] ?? ' ',  
                            'product_description' => $value['Description'] ?? null,                        
                            'alert_quantity' => $value['ReorderPoint'] ?? 1,
                            'category_id' => $category,
                            'is_inactive' => $value['Active'] == true ? 0 : 1,
                            'created_at' => Carbon::now(),
                            'type' => $value['Type'],
                            'quickbooks_id' => $value['Id'],
                            'income_account_ref' => array_key_exists('IncomeAccountRef', $value) ? json_encode($value['IncomeAccountRef']) : null,
                            'tax_type' => $value['Taxable'] == false ? 'exclusive' : 'inclusive',
                            'business_id' => $business_id,
                            'created_by' => auth()->user()->id
                        ],
                        'ProductVariation' => [
                            'name' => 'default',
                            'product_id' => null
                        ],
                        'Variation' => [
                            'name' => 'variation',
                            'sub_sku' => $value['Sku'] ?? null,
                            'default_purchase_price' => $value['PurchaseCost'],
                            'dpp_inc_tax' => $value['PurchaseCost'],
                            'default_sell_price' => $value['UnitPrice'],
                            'sell_price_inc_tax' => $value['UnitPrice'],
                            'created_at' => Carbon::now(),
                            'product_id' => null,
                            'product_variation_id' => null                              
                        ],
                        'VariationDetails' => [
                            'location_id' => $this->product_locations[0],
                            'qty_available' => $value['TrackQtyOnHand'] == false ? 0 : $value['QtyOnHand'],
                            'product_id' => null,                            
                            'product_variation_id' => null,  
                            'variation_id' => null  
                        ]
                    ];
                } else if($value['Type'] == "Category") {
                    $check_category = Category::where('quickbooks_id', $value['Id'])->first();
                    if($check_category == null) {
                        $category = new Category();
                        $category->name = $value['Name'];
                        $category->business_id = $business_id;
                        $category->description = $value['FullyQualifiedName'];
                        $category->quickbooks_id = $value['Id'];
                        $category->created_by = auth()->user()->id;
                        $category->save();        
                    }                    
                    $arr_data = [];
                } else if($value['Type'] == 'Group') {
                    // still confuse how to get it, because need 2 API for get this bundle group product
                    continue;                    
                } else {
                    continue;
                }
                
                if(!empty($arr_data)) {
                    $this->save_product($arr_data, $business_id);
                }
                $no++;
                $status = 1;
                array_push($arr, [
                    'number' => $no,
                    'status' => $status
                ]);                               
            }

            return [
                'rc' => 200,
                'msg' => 'Success',
                'array_insert' => $arr
            ];
        } else {
            return [
                'rc' => 500,
                'msg' => 'Data not found',
                'array_insert' => $arr
            ];
        }
    }

    public function save_product($data, $business_id) 
    {        
        //code...        
        $check_product = Product::where('quickbooks_id',$data['Product']['quickbooks_id'])->first();
        if($check_product == null) {
            $product = Product::create($data['Product']);

            $data['ProductVariation']['product_id'] = $product->id;
            $product_variation = ProductVariation::create($data['ProductVariation']);

            $data['Variation']['product_variation_id'] = $product_variation->id;
            $data['Variation']['product_id'] = $product->id;
            $variation = Variation::create($data['Variation']);

            $data['VariationDetails']['product_id'] = $product->id;
            $data['VariationDetails']['product_variation_id'] = $product_variation->id;
            $data['VariationDetails']['variation_id'] = $variation->id;
            $variation_details = VariationLocationDetails::create($data['VariationDetails']);

            $transaction = new Transaction();
            $transaction->business_id = $business_id;
            $transaction->location_id = $variation_details->location_id;
            $transaction->type = 'opening_stock';
            $transaction->status = 'received';
            $transaction->is_quotation = 0;
            $transaction->payment_status = 'paid';
            $transaction->transaction_date = Carbon::now();
            $transaction->total_before_tax = 0;
            $transaction->tax_amount = 0;
            $transaction->discount_amount = 0;
            $transaction->rp_redeemed = 0;
            $transaction->rp_redeemed_amount = 0;
            $transaction->shipping_charges = 0;
            $transaction->is_export = 0;
            $transaction->round_off_amount = 0;
            $transaction->additional_expense_value_1 = 0;
            $transaction->additional_expense_value_2 = 0;
            $transaction->additional_expense_value_3 = 0;
            $transaction->additional_expense_value_4 = 0;
            $transaction->final_total = 0;
            $transaction->is_direct_sale = 0;
            $transaction->is_suspend = 0;
            $transaction->exchange_rate = 1;
            $transaction->opening_stock_product_id = $product->id;
            $transaction->created_by = auth()->user()->id;
            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
            $transaction->is_created_from_api = 1;
            $transaction->rp_earned = 0;
            $transaction->is_recurring = 0;

            $transaction->save();

            $purchase_lines = new PurchaseLine();
            $purchase_lines->transaction_id = $transaction->id;
            $purchase_lines->product_id = $product->id;
            $purchase_lines->variation_id = $variation->id;
            $purchase_lines->quantity = $variation_details->qty_available;
            $purchase_lines->purchase_price = $variation->default_purchase_price;
            $purchase_lines->save();
        }

        return true;                                  
    }

    public function getUrlTokenQb(Request $request)
    {        
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings')->first();

        $array_empty = [];
        $array_insert = [];

        $accounting_settings = json_decode($business->accounting_settings);

        if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret) {
          // $SHOPIFY_URL = getenv("SHOPIFY_URL");
          $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
          // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
          $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
          $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
        } else {
          return 'Url and Access Token Shopify Not Found';
        }
                
        $redirect_url = "https://demo.virtualhills.com/get-authorization-code";
        if($_SERVER['SERVER_NAME'] == '127.0.0.1') {
            $redirect_url = "http://127.0.0.1:8000/get-authorization-code";
        } else if($_SERVER['SERVER_NAME'] == 'sevendepot.virtualhills.com') {
            $redirect_url = "https://sevendepot.virtualhills.com/get-authorization-code";
        } else if($_SERVER['SERVER_NAME'] == 'id4u.virtualhills.com') {
            $redirect_url = "https://id4u.virtualhills.com/get-authorization-code";
        } else if($_SERVER['SERVER_NAME'] == 'trendicala.virtualhills.com') {
            $redirect_url = "https://trendicala.virtualhills.com/get-authorization-code";
        }
        
        $dataService = DataService::Configure(array(
            'auth_mode' => 'oauth2',
            'ClientID' => $Quickbooks_KEY,
            'ClientSecret' => $Quickbooks_SECRET,
            'RedirectURI' => $redirect_url,
            'scope' => "com.intuit.quickbooks.accounting",
            'baseUrl' => "Development"
        ));        
        $OAuth2LoginHelper = $dataService->getOAuth2LoginHelper();
        $authorizationCodeUrl = $OAuth2LoginHelper->getAuthorizationCodeURL();        

        return $authorizationCodeUrl;
    }

    public function getAuthorizationCode(Request $request)
    {                        
        // dd($request->all());
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings')->first();

        $array_empty = [];
        $array_insert = [];

        $accounting_settings = json_decode($business->accounting_settings);
        
        if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret) {
          // $SHOPIFY_URL = getenv("SHOPIFY_URL");
          $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
          // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
          $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
          $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
        } else {
          return 'Url and Access Token Shopify Not Found';
        }
              
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://oauth.platform.intuit.com/oauth2/v1/tokens/bearer');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=authorization_code&code=".$request->code."&redirect_uri=https://demo.virtualhills.com/get-authorization-code");

        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Authorization: Basic '.base64_encode($Quickbooks_KEY.':'.$Quickbooks_SECRET);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        
        $response = json_decode($result, true);        
        curl_close($ch);
        if(array_key_exists('error', $response)) {
            $error_description = array_key_exists('error_description', $response) ? $response['error_description'] : "null";
            $msg = 'Error: ' .$response['error'] . ' <br> Error Description: ' . $error_description;
            $accounting_settings->quickbooks_api_access_token = null;
            Business::where('id', $business_id)->update([
                'accounting_settings' => json_encode($accounting_settings),
                'refresh_token_quickbooks' => null,
                'expired_token_quickbooks' => null
            ]);
            return "<script>localStorage.setItem('quickbooks_token', JSON.stringify({rc: 500, msg: '".$msg."', token: null}));window.close();</script>";
        } else {
            $minutes_to_add = 60;
    
            $time = new DateTime();
            $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
            $stamp = $time->format('Y-m-d H:i');
            $accounting_settings->quickbooks_api_access_token = $response['access_token'];
            Business::where('id', $business_id)->update([
                'accounting_settings' => json_encode($accounting_settings),
                'refresh_token_quickbooks' => $response['refresh_token'],
                'expired_token_quickbooks' => $stamp
            ]);
            
            return "<script>localStorage.setItem('quickbooks_token', JSON.stringify({rc: 200, msg: null, token: '".$response['access_token']."'}));window.close();</script>";
        }
        

    }

    public function voidDeleteQuickbooks($id, $sync_token, Request $request)
    {
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings', 'refresh_token_quickbooks', 'expired_token_quickbooks')->first();

        $accounting_settings = json_decode($business->accounting_settings);

        try {
            //code...
            if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret && $accounting_settings->quickbooks_api_access_token) {
                // $SHOPIFY_URL = getenv("SHOPIFY_URL");
                $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
                // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
                $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
                $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
                $Quickbooks_TOKEN = $accounting_settings->quickbooks_api_access_token;        
                if(strtotime(date('Y-m-d H:i:s')) >= strtotime($business->refresh_token_quickbooks)) {
                    $oauth2LoginHelper = new OAuth2LoginHelper($Quickbooks_KEY,$Quickbooks_SECRET);            
                    $accessTokenObj = $oauth2LoginHelper->
                                        refreshAccessTokenWithRefreshToken($business->refresh_token_quickbooks);
                    $accessTokenValue = $accessTokenObj->getAccessToken();
                    $Quickbooks_TOKEN = $accessTokenValue;
                    $refreshTokenValue = $accessTokenObj->getRefreshToken();
                    $minutes_to_add = 60;
        
                    $time = new DateTime();
                    $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
        
                    $stamp = $time->format('Y-m-d H:i');
                    $accounting_settings->quickbooks_api_access_token = $accessTokenValue;
                    Business::where('id', $business_id)->update([
                        'accounting_settings' => json_encode($accounting_settings),
                        'refresh_token_quickbooks' => $refreshTokenValue,
                        'expired_token_quickbooks' => $stamp
                    ]);
                }
            } else {
                return 'Url and Access Token Quickbooks Not Found';
            }
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                CURLOPT_URL => $Quickbooks_URL.'/invoice?operation='.$request->type,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_POST => 1,
                CURLOPT_POSTFIELDS => json_encode(array(
                    'Id' => $id,
                    'SyncToken' => $sync_token
                )),
                CURLOPT_RETURNTRANSFER => 1,
                CURLOPT_HTTPHEADER => array(
                    'Accept: application/json',
                    'Content-Type: application/json',
                    'Authorization: Bearer '. $Quickbooks_TOKEN
                )
            
                )
            );

            $response = curl_exec($curl);
            $parseResponse = json_decode($response, true);                                 
            
            if($request->type == 'void') {
                if(array_key_exists('Invoice', $parseResponse)) {
                    $value = $parseResponse['Invoice'];
                    $arr_data_invoice = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : 'Voided',                
                        'due_date' => $value['DueDate'],
                        'total_amt' => 0,
                        'sync_token' => $value['SyncToken'],                
                        'balance' => 0
                    ];
                    $arr_data_expense = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : 'Voided',                                            
                        'memo' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : 'Voided',                                            
                        'amount' => 0,
                        'sync_token' => $value['SyncToken'],                
                        'balance' => 0
                    ];
                    
                    
                    DB::table('invoice_quickbooks')->where('invoice_id', $id)->update($arr_data_invoice);
                    DB::table('expense')->where('id_vendor', $id)->update($arr_data_expense);
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Void invoice successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                }                
            } else {                
                DB::table('invoice_quickbooks')->where('invoice_id', $id)->delete();
                DB::table('expense')->where('id_vendor', $id)->delete();
                return response()->json([
                    'rc' => 1,
                    'msg' => 'Delete invoice successfully'
                ]);
            }
            
        } catch (\QuickBooksOnline\API\Exception\ServiceException $se) {
            //throw $th;               
            if($se->getCode() == 400) {
                return response()->json([
                    'rc' => 500,
                    'msg' => $se->getMessage()
                ]);
            } else {
                return response()->json([
                    'rc' => 500,
                    // 'msg' => 'Something went wrong, please contact VHPOS'
                    'msg' => $se->getMessage()
                ]);
            }
        } catch(\Throwable $th) {            
            return response()->json([
                'rc' => 500,
                'msg' => 'Something went wrong, please contact VHPOS'
                // 'msg' => $th->getMessage()
            ]);
        } catch(\Exception $e) {            
            return response()->json([
                'rc' => 500,
                'msg' => 'Something went wrong, please contact VHPOS'
                // 'msg' => $e->getMessage()
            ]);
        }              
    }

    public function voidDeleteAllSalesQuickbooks($id, $sync_token, Request $request)
    {

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings', 'refresh_token_quickbooks', 'expired_token_quickbooks')->first();

        $accounting_settings = json_decode($business->accounting_settings);

        try {
            //code...
            if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret && $accounting_settings->quickbooks_api_access_token) {
                // $SHOPIFY_URL = getenv("SHOPIFY_URL");
                $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
                // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
                $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
                $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
                $Quickbooks_TOKEN = $accounting_settings->quickbooks_api_access_token;        
                if(strtotime(date('Y-m-d H:i:s')) >= strtotime($business->refresh_token_quickbooks)) {
                    $oauth2LoginHelper = new OAuth2LoginHelper($Quickbooks_KEY,$Quickbooks_SECRET);            
                    $accessTokenObj = $oauth2LoginHelper->
                                        refreshAccessTokenWithRefreshToken($business->refresh_token_quickbooks);
                    $accessTokenValue = $accessTokenObj->getAccessToken();
                    $Quickbooks_TOKEN = $accessTokenValue;
                    $refreshTokenValue = $accessTokenObj->getRefreshToken();
                    $minutes_to_add = 60;
        
                    $time = new DateTime();
                    $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
        
                    $stamp = $time->format('Y-m-d H:i');
                    $accounting_settings->quickbooks_api_access_token = $accessTokenValue;
                    Business::where('id', $business_id)->update([
                        'accounting_settings' => json_encode($accounting_settings),
                        'refresh_token_quickbooks' => $refreshTokenValue,
                        'expired_token_quickbooks' => $stamp
                    ]);
                }
            } else {
                return 'Url and Access Token Shopify Not Found';
            }
            if($request->type == "Invoice") {                
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                    CURLOPT_URL => $Quickbooks_URL.'/invoice?operation='.$request->voidordelete,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_POST => 1,
                    CURLOPT_POSTFIELDS => json_encode(array(
                        'Id' => $id,
                        'SyncToken' => $sync_token
                    )),
                    CURLOPT_RETURNTRANSFER => 1,
                    CURLOPT_HTTPHEADER => array(
                        'Accept: application/json',
                        'Content-Type: application/json',
                        'Authorization: Bearer '. $Quickbooks_TOKEN
                    )
                
                    )
                );

                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);                                 
                // dd($parseResponse);
                if($request->voidordelete == 'void') {
                    if(array_key_exists('Invoice', $parseResponse)) {
                        $value = $parseResponse['Invoice'];
                        $arr_data_invoice = [                
                            'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : 'Voided',                
                            'due_date' => $value['DueDate'],
                            'total_amt' => 0,
                            'sync_token' => $value['SyncToken'],                
                            'balance' => 0
                        ];
                        $arr_data_expense = [                
                            'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : 'Voided',                                            
                            'memo' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : 'Voided',                                            
                            'amount' => 0,
                            'sync_token' => $value['SyncToken'],                
                            'balance' => 0
                        ];
                        
                        
                        DB::table('invoice_quickbooks')->where('invoice_id', $id)->update($arr_data_invoice);
                        DB::table('expense')->where('id_vendor', $id)->update($arr_data_expense);
                        return response()->json([
                            'rc' => 1,
                            'msg' => 'Void invoice successfully'
                        ]);
                    } else if(array_key_exists('Fault', $parseResponse)) {
                        /* if($parseResponse['Fault']['Error'][0]['code'] == '5010') {
                            return $this->voidDeleteAllSalesQuickbooks($id, $sync_token + 1, $request);
                        } else { */
                            return response()->json([
                                'rc' => 500,
                                'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                            ]);                
                        // }
                    } else {
                        return response()->json([
                            'rc' => 500,
                            'msg' => "Problem with quickbooks"
                        ]);
                    }                
                } else {
                    DB::table('invoice_quickbooks')->where('invoice_id', $id)->delete();
                    DB::table('expense')->where('id_vendor', $id)->delete();
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Delete invoice successfully'
                    ]);
                }
            } else if($request->type == "Sales Receipt" || $request->type == 'Refund' || $request->type == 'Payment' || $request->type == 'Credit Memo' || $request->type == 'Estimate') {
                $type = 'salesreceipt';
                if($request->type == 'Refund') {
                    $type = 'refundreceipt';
                }
                if($request->voidordelete == 'void') {
                    if($request->type == 'Sales Receipt') {
                        $curl = curl_init();
                        curl_setopt_array(
                            $curl,
                            array(
                            CURLOPT_URL => $Quickbooks_URL.'/salesreceipt?include='.$request->voidordelete.'&minorversion=65',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_POST => 1,
                            CURLOPT_POSTFIELDS => json_encode(array(
                                'Id' => $id,
                                'SyncToken' => $sync_token,
                                'sparse' => true
                            )),
                            CURLOPT_RETURNTRANSFER => 1,
                            CURLOPT_HTTPHEADER => array(
                                'Accept: application/json',
                                'Content-Type: application/json',
                                'Authorization: Bearer '. $Quickbooks_TOKEN
                            )
                        
                            )
                        );
                    } else if($request->type == 'Refund') {
                        // $request->request->add(['id' => $id]);                                                                                
                        // dd($data);
                        $curl = curl_init();
                        curl_setopt_array(
                            $curl,
                            array(
                            CURLOPT_URL => $Quickbooks_URL.'/refundreceipt?&minorversion=65',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_POST => 1,
                            /* CURLOPT_POSTFIELDS => '{
                                "domain": "QBO",
                                "sparse": false,
                                "Id": "'.$id.'",
                                "SyncToken": "'.$SyncToken.'",
                                "MetaData": {
                                    "CreateTime": "'.$CreateTime.'",
                                    "LastUpdatedTime": "'.$LastUpdatedTime.'"
                                },
                                "CustomField": [
                                    {
                                        "DefinitionId": "1",
                                        "Name": "Crew #",
                                        "Type": "StringType"
                                    }
                                ],
                                "DocNumber": "'.$DocNumber.'",
                                "TxnDate": "'.$TxnDate.'",
                                "CurrencyRef": {
                                    "value": "USD",
                                    "name": "United States Dollar"
                                },
                                "PrivateNote": "'.$PrivateNote.'",
                                "Line": [
                                    {
                                        "Id": "1",
                                        "LineNum": 1,
                                        "Description": "For testing and this product will be deleted",
                                        "Amount": 0,
                                        "DetailType": "SalesItemLineDetail",
                                        "SalesItemLineDetail": {
                                            "ItemRef": {
                                                "value": "20",
                                                "name": "Delete:Product delete"
                                            },
                                            "Qty": 0,
                                            "ItemAccountRef": {
                                                "value": "79",
                                                "name": "Sales of Product Income"
                                            },
                                            "TaxCodeRef": {
                                                "value": "TAX"
                                            }
                                        }
                                    },
                                    {
                                        "Amount": 0,
                                        "DetailType": "SubTotalLineDetail",
                                        "SubTotalLineDetail": {}
                                    }
                                ],
                                "TxnTaxDetail": {
                                    "TxnTaxCodeRef": {
                                        "value": "3"
                                    },
                                    "TotalTax": 0,
                                    "TaxLine": [
                                        {
                                            "Amount": 0,
                                            "DetailType": "TaxLineDetail",
                                            "TaxLineDetail": {
                                                "TaxRateRef": {
                                                    "value": "1"
                                                },
                                                "PercentBased": true,
                                                "TaxPercent": 7.1,
                                                "NetAmountTaxable": 0
                                            }
                                        },
                                        {
                                            "Amount": 0,
                                            "DetailType": "TaxLineDetail",
                                            "TaxLineDetail": {
                                                "TaxRateRef": {
                                                    "value": "2"
                                                },
                                                "PercentBased": true,
                                                "TaxPercent": 2,
                                                "NetAmountTaxable": 0
                                            }
                                        }
                                    ]
                                },
                                "CustomerRef": {
                                    "value": "60",
                                    "name": "ismail"
                                },
                                "CustomerMemo": {
                                    "value": "Thank you for your business and have a great day!"
                                },
                                "FreeFormAddress": false,
                                "TotalAmt": 0,
                                "ApplyTaxAfterDiscount": false,
                                "PrintStatus": "NotSet",
                                "BillEmail": {
                                    "Address": "ismail@mail.com"
                                },
                                "Balance": 0,
                                "PaymentMethodRef": {
                                    "value": "1",
                                    "name": "Cash"
                                },
                                "DepositToAccountRef": {
                                    "value": "81",
                                    "name": "Inventory Asset"
                                }
                            }', */
                            CURLOPT_POSTFIELDS => json_encode($request->data),
                            CURLOPT_RETURNTRANSFER => 1,
                            CURLOPT_HTTPHEADER => array(
                                'Accept: application/json',
                                'Content-Type: application/json',
                                'Authorization: Bearer '. $Quickbooks_TOKEN
                            )
                        
                            )
                        );

                        $response = curl_exec($curl);
                        $parseResponse = json_decode($response, true); 
                        
                        if(array_key_exists('RefundReceipt', $parseResponse)) {
                            $value = $parseResponse['RefundReceipt'];
                            $arr_data = [                
                                'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                                // 'due_date' => $value['DueDate'],
                                'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                                'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                                'balance' => $value['Balance'] ? $value['Balance'] : 0,
                                'memo' => 'Voided'
                            ];
                            
                            DB::table('expense')->where('id_vendor', $id)->update($arr_data);
                            return response()->json([
                                'rc' => 1,
                                'msg' => 'Void '.$request->type.' successfully'
                            ]);
                        } else if(array_key_exists('Fault', $parseResponse)) {
                            if($parseResponse['Fault']['Error'][0]['code'] == '5010') {
                                return $this->voidDeleteAllSalesQuickbooks($id, $sync_token + 1, $request);
                            } else {
                                return response()->json([
                                    'rc' => 500,
                                    'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                                ]);                
                            }                
                        } else {
                            return response()->json([
                                'rc' => 500,
                                'msg' => "Problem with quickbooks"
                            ]);
                        }                         
                    } else if($request->type == 'Payment') {
                        $curl = curl_init();
                        curl_setopt_array(
                            $curl,
                            array(
                            CURLOPT_URL => $Quickbooks_URL.'/payment?operation=update&include=void&minorversion=65',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_POST => 1,
                            CURLOPT_POSTFIELDS => json_encode(array(
                                "SyncToken" => $sync_token,
                                "Id" => $id,
                                "sparse" => true
                            )),
                            CURLOPT_RETURNTRANSFER => 1,
                            CURLOPT_HTTPHEADER => array(
                                'Accept: application/json',
                                'Content-Type: application/json',
                                'Authorization: Bearer '. $Quickbooks_TOKEN
                            )
                        
                            )
                        );

                        $response = curl_exec($curl);
                        $parseResponse = json_decode($response, true); 
                        
                        if(array_key_exists('Payment', $parseResponse)) {
                            $value = $parseResponse['Payment'];
                            $arr_data = [                
                                'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                                // 'due_date' => $value['DueDate'],
                                'amount' => $value['TotalAmt'],
                                'sync_token' => $value['SyncToken'],                
                                'balance' => 0,
                                'memo' => 'Voided'
                            ];
                            
                            DB::table('expense')->where('id_vendor', $id)->update($arr_data);
                            return response()->json([
                                'rc' => 1,
                                'msg' => 'Void '.$request->type.' successfully'
                            ]);
                        } else if(array_key_exists('Fault', $parseResponse)) {
                            if($parseResponse['Fault']['Error'][0]['code'] == '5010') {
                                return $this->voidDeleteAllSalesQuickbooks($id, $sync_token + 1, $request);
                            } else {
                                return response()->json([
                                    'rc' => 500,
                                    'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                                ]);                
                            }                
                        } else {
                            return response()->json([
                                'rc' => 500,
                                'msg' => "Problem with quickbooks"
                            ]);
                        }
                    } else if($request->type == 'Credit Memo') {
                        $curl = curl_init();
                        curl_setopt_array(
                            $curl,
                            array(
                            CURLOPT_URL => $Quickbooks_URL.'/creditmemo?&minorversion=65',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_POST => 1,
                            CURLOPT_POSTFIELDS => json_encode($request->data),
                            CURLOPT_RETURNTRANSFER => 1,
                            CURLOPT_HTTPHEADER => array(
                                'Accept: application/json',
                                'Content-Type: application/json',
                                'Authorization: Bearer '. $Quickbooks_TOKEN
                            )
                        
                            )
                        );

                        $response = curl_exec($curl);
                        $parseResponse = json_decode($response, true); 
                        
                        if(array_key_exists('CreditMemo', $parseResponse)) {
                            $value = $parseResponse['CreditMemo'];
                            $arr_data = [                
                                'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                                // 'due_date' => $value['DueDate'],
                                'amount' => $value['TotalAmt'],
                                'sync_token' => $value['SyncToken'],                
                                'balance' => $value['Balance'],
                                'memo' => 'Voided'
                            ];
                            
                            DB::table('expense')->where('id_vendor', $id)->update($arr_data);
                            return response()->json([
                                'rc' => 1,
                                'msg' => 'Void '.$request->type.' successfully'
                            ]);
                        } else if(array_key_exists('Fault', $parseResponse)) {
                            if($parseResponse['Fault']['Error'][0]['code'] == '5010') {
                                return $this->voidDeleteAllSalesQuickbooks($id, $sync_token + 1, $request);
                            } else {
                                return response()->json([
                                    'rc' => 500,
                                    'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                                ]);                
                            }                
                        } else {
                            return response()->json([
                                'rc' => 500,
                                'msg' => "Problem with quickbooks"
                            ]);
                        }
                    } else if($request->type == 'Estimate') {
                        $curl = curl_init();
                        curl_setopt_array(
                            $curl,
                            array(
                            CURLOPT_URL => $Quickbooks_URL.'/estimate?&minorversion=65',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_POST => 1,
                            CURLOPT_POSTFIELDS => json_encode($request->data),
                            CURLOPT_RETURNTRANSFER => 1,
                            CURLOPT_HTTPHEADER => array(
                                'Accept: application/json',
                                'Content-Type: application/json',
                                'Authorization: Bearer '. $Quickbooks_TOKEN
                            )
                        
                            )
                        );

                        $response = curl_exec($curl);
                        $parseResponse = json_decode($response, true); 
                        
                        if(array_key_exists('Estimate', $parseResponse)) {
                            $value = $parseResponse['Estimate'];
                            $arr_data = [                
                                'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                                // 'due_date' => $value['DueDate'],
                                'amount' => $value['TotalAmt'],
                                'sync_token' => $value['SyncToken'],                
                                // 'balance' => $value['Balance'],
                                'memo' => 'Voided'
                            ];
                            
                            DB::table('expense')->where('id_vendor', $id)->update($arr_data);
                            return response()->json([
                                'rc' => 1,
                                'msg' => 'Void '.$request->type.' successfully'
                            ]);
                        } else if(array_key_exists('Fault', $parseResponse)) {
                            if($parseResponse['Fault']['Error'][0]['code'] == '5010') {
                                return $this->voidDeleteAllSalesQuickbooks($id, $sync_token + 1, $request);
                            } else {
                                return response()->json([
                                    'rc' => 500,
                                    'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                                ]);                
                            }                
                        } else {
                            return response()->json([
                                'rc' => 500,
                                'msg' => "Problem with quickbooks"
                            ]);
                        }
                    }
                } else if($request->voidordelete == 'delete') {
                    if($request->type == 'Refund') {
                        $typeUrl = 'refundreceipt';
                    } else {
                        $typeUrl = str_replace(' ', '', $request->type);
                        $typeUrl = strtolower($typeUrl);
                    }
                    $curl = curl_init();
                    curl_setopt_array(
                        $curl,
                        array(
                        CURLOPT_URL => $Quickbooks_URL.'/'.$typeUrl.'?operation=delete&minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode(array(
                            'Id' => $id,
                            'SyncToken' => $sync_token,
                        )),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )
                    
                        )
                    );
                }

                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);                                                 
                if($request->voidordelete == 'void') {
                    if(array_key_exists('SalesReceipt', $parseResponse)) {
                        $value = $parseResponse['SalesReceipt'];
                        $arr_data = [                
                            'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                            'due_date' => $value['DueDate'],
                            'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                            'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                            'balance' => $value['Balance'] ? $value['Balance'] : 0,
                        ];
                        
                        DB::table('expense')->where('id_vendor', $id)->update($arr_data);
                        return response()->json([
                            'rc' => 1,
                            'msg' => 'Void '.$request->type.' successfully'
                        ]);
                    } else if(array_key_exists('Fault', $parseResponse)) {
                        if($parseResponse['Fault']['Error'][0]['code'] == '5010') {
                            return $this->voidDeleteAllSalesQuickbooks($id, $sync_token + 1, $request);
                        } else {
                            return response()->json([
                                'rc' => 500,
                                'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                            ]);                
                        }                
                    } else {
                        return response()->json([
                            'rc' => 500,
                            'msg' => "Problem with quickbooks"
                        ]);
                    }                
                } else {                                        
                    if(array_key_exists($request->type, $parseResponse)) {
                        $data = $parseResponse[$request->type];
                        if($data['status'] == 'Deleted') {
                            DB::table('expense')->where('id_vendor', $id)->delete();
                            return response()->json([
                                'rc' => 1,
                                'msg' => 'Delete '.$request->type.' successfully'
                            ]);
                        } else {
                            return response()->json([
                                'rc' => 1,
                                'msg' => 'Delete '.$request->type.' '.$data['status']
                            ]);
                        }
                    } else if(array_key_exists('Fault', $parseResponse)) {
                        if($parseResponse['Fault']['Error'][0]['code'] == '5010') {
                            return $this->voidDeleteAllSalesQuickbooks($id, $sync_token + 1, $request);
                        } else {
                            return response()->json([
                                'rc' => 500,
                                'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                            ]);                
                        }                
                    } else {
                        return response()->json([
                            'rc' => 500,
                            'msg' => "Problem with quickbooks"
                        ]);
                    } 
                }
            } else {
                return response()->json([
                    'rc' => 400,
                    'msg' => 'Under construction'
                ]);
            }
            
        } catch (\QuickBooksOnline\API\Exception\ServiceException $se) {
            //throw $th;               
            if($se->getCode() == 400) {
                return response()->json([
                    'rc' => 500,
                    'msg' => $se->getMessage()
                ]);
            } else {
                return response()->json([
                    'rc' => 500,
                    // 'msg' => 'Something went wrong, please contact VHPOS'
                    'msg' => $se->getMessage()
                ]);
            }
        } catch(\Throwable $th) {            
            return response()->json([
                'rc' => 500,
                // 'msg' => 'Something went wrong, please contact VHPOS'
                'msg' => $th->getMessage()
            ]);
        } catch(\Exception $e) {            
            return response()->json([
                'rc' => 500,
                // 'msg' => 'Something went wrong, please contact VHPOS'
                'msg' => $e->getMessage()
            ]);
        }              
    }

    public function viewEditInvoiceQb(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings', 'refresh_token_quickbooks', 'expired_token_quickbooks')->first();

        try {
            $accounting_settings = json_decode($business->accounting_settings);

            if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret && $accounting_settings->quickbooks_api_access_token) {
                // $SHOPIFY_URL = getenv("SHOPIFY_URL");
                $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
                // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
                $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
                $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
                $Quickbooks_TOKEN = $accounting_settings->quickbooks_api_access_token;        
                if(strtotime(date('Y-m-d H:i:s')) >= strtotime($business->refresh_token_quickbooks)) {
                    $oauth2LoginHelper = new OAuth2LoginHelper($Quickbooks_KEY,$Quickbooks_SECRET);            
                    $accessTokenObj = $oauth2LoginHelper->
                                        refreshAccessTokenWithRefreshToken($business->refresh_token_quickbooks);
                    $accessTokenValue = $accessTokenObj->getAccessToken();
                    $Quickbooks_TOKEN = $accessTokenValue;
                    $refreshTokenValue = $accessTokenObj->getRefreshToken();
                    $minutes_to_add = 60;
        
                    $time = new DateTime();
                    $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
        
                    $stamp = $time->format('Y-m-d H:i');
                    $accounting_settings->quickbooks_api_access_token = $accessTokenValue;
                    Business::where('id', $business_id)->update([
                        'accounting_settings' => json_encode($accounting_settings),
                        'refresh_token_quickbooks' => $refreshTokenValue,
                        'expired_token_quickbooks' => $stamp
                    ]);
                }
            } else {
                return 'Url and Access Token Quickbooks Not Found';
            }
        
            //code...
            // $customer = Contact::where('type', 'customer_quickbooks')->where('business_id', $business_id)->get();
            $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            $invoice = $this->get_data($request, 'get_invoice', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            $taxrate = $this->get_data($request, 'taxrate', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);    
            $term = $this->get_data($request, 'term', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);    
            $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();
            if(array_key_exists('Invoice', $invoice)) {
                return response()->json([
                    'rc' => 1,
                    'customer' => $customer['QueryResponse']['Customer'],
                    'invoice' => $invoice['Invoice'],
                    'taxrate' => $taxrate['QueryResponse']['TaxRate'],
                    'term' => $term['QueryResponse']['Term'],
                    'product' => $product
                ]); 
            } else {
                return response()->json([
                    'rc' => 500,
                    'msg' => 'Data not found'
                ]);
            }
        } catch (ServiceException $qb) {
            //throw $th;
            $b = Business::find($business_id);
            $b->refresh_token_quickbooks = null;
            $b->expired_token_quickbooks = null;
            $b->save();
            return response()->json([
                'rc' => 500,
                'msg' => $qb->getMessage()
            ]);
        } catch (\Exception $err) {
            //throw $th;                           
            return response()->json([
                'message' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        } 
    }

    public function getAllSalesDataQb($id, $sync_token, Request $request)
    {
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings', 'refresh_token_quickbooks', 'expired_token_quickbooks')->first();

        $accounting_settings = json_decode($business->accounting_settings);
        
        //code...
        if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret && $accounting_settings->quickbooks_api_access_token) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
            // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
            $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
            $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
            $Quickbooks_TOKEN = $accounting_settings->quickbooks_api_access_token;        
            if(strtotime(date('Y-m-d H:i:s')) >= strtotime($business->refresh_token_quickbooks)) {
                $oauth2LoginHelper = new OAuth2LoginHelper($Quickbooks_KEY,$Quickbooks_SECRET);            
                $accessTokenObj = $oauth2LoginHelper->
                                    refreshAccessTokenWithRefreshToken($business->refresh_token_quickbooks);
                $accessTokenValue = $accessTokenObj->getAccessToken();
                $Quickbooks_TOKEN = $accessTokenValue;
                $refreshTokenValue = $accessTokenObj->getRefreshToken();
                $minutes_to_add = 60;
    
                $time = new DateTime();
                $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
    
                $stamp = $time->format('Y-m-d H:i');
                $accounting_settings->quickbooks_api_access_token = $accessTokenValue;
                Business::where('id', $business_id)->update([
                    'accounting_settings' => json_encode($accounting_settings),
                    'refresh_token_quickbooks' => $refreshTokenValue,
                    'expired_token_quickbooks' => $stamp
                ]);
            }
        } else {
            return 'Url and Access Token Shopify Not Found';
        }

        $request->request->add(['id' => $id]);
        if($request->type == 'Refund') {
            $get_data = $this->get_data($request, 'refundreceipt', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);            
            if(array_key_exists('RefundReceipt', $get_data)) {
                $data = $get_data['RefundReceipt'];
                $data['PrivateNote'] = 'Voided';
                $data['SyncToken'] = $data['SyncToken'];
                foreach ($data['Line'] as $key => $value) {
                    # code...
                    if($data['Line'][$key]['DetailType'] == 'SalesItemLineDetail') {
                        $data['Line'][$key]['Amount'] = "0";
                        $data['Line'][$key]['SalesItemLineDetail']['Qty'] = "0";
                        // $data['Line'][$key]['SalesItemLineDetail']['UnitPrice'] = "0";
                    } else if($data['Line'][$key]['DetailType'] == 'SubTotalLineDetail') {
                        $data['Line'][$key]['Amount'] = "0";
                    } else if($data['Line'][$key]['DetailType'] == 'DiscountLineDetail') {
                        $data['Line'][$key]['DiscountLineDetail']['PercentBased'] = "0";
                        $data['Line'][$key]['DiscountLineDetail']['DiscountPercent'] = "0";
                        $data['Line'][$key]['Amount'] = "0";
                    }
                }    
                
                if(array_key_exists('TaxLine', $data['TxnTaxDetail'])) {
                    foreach($data['TxnTaxDetail']['TaxLine'] as $key1 => $value1) {
                        if($value1['DetailType'] == 'TaxLineDetail') {
                            $data['TxnTaxDetail']['TaxLine'][$key1]['Amount'] = "0";
                            $data['TxnTaxDetail']['TaxLine'][$key1]['TaxLineDetail']['NetAmountTaxable'] = "0";
                        }
                    }
                }
                                                            
                $data['TxnTaxDetail']['TotalTax'] = "0";
                $data['Balance'] = "0";
                $data['TotalAmt'] = "0";
                return response()->json([
                    'rc' => 1,
                    'data' => json_encode($data)
                ]);
            } else {
                return response()->json([
                    'rc' => 500,
                    'msg' => 'Data not found'
                ]); 
            }
        } else if($request->type == 'Payment') {
            $get_data = $this->get_data($request, 'payment', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
            if(array_key_exists('Payment', $get_data)) {
                $data = $get_data['Payment'];
                $data['TotalAmt'] = 0;
                $data['UnappliedAmt'] = 0;
                $data['PrivateNote'] = "Voided";
                if($data['Line']) {
                    $data['Line'][0]['Amount'] = 0;
                }
                return response()->json([
                    'rc' => 1,
                    'data' => json_encode($data)
                ]);
            }
        } else if($request->type == 'Credit Memo') {
            $get_data = $this->get_data($request, 'creditmemo', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);            
            if(array_key_exists('CreditMemo', $get_data)) {
                $data = $get_data['CreditMemo'];
                $data['PrivateNote'] = 'Voided';
                $data['SyncToken'] = $data['SyncToken'];
                foreach ($data['Line'] as $key => $value) {
                    # code...
                    if($data['Line'][$key]['DetailType'] == 'SalesItemLineDetail') {
                        $data['Line'][$key]['Amount'] = "0";
                        $data['Line'][$key]['SalesItemLineDetail']['Qty'] = "0";
                        // $data['Line'][$key]['SalesItemLineDetail']['UnitPrice'] = "0";
                    } else if($data['Line'][$key]['DetailType'] == 'SubTotalLineDetail') {
                        $data['Line'][$key]['Amount'] = "0";
                    } else if($data['Line'][$key]['DetailType'] == 'DiscountLineDetail') {
                        $data['Line'][$key]['DiscountLineDetail']['PercentBased'] = "0";
                        $data['Line'][$key]['DiscountLineDetail']['DiscountPercent'] = "0";
                        $data['Line'][$key]['Amount'] = "0";
                    }
                }    
                
                if(array_key_exists('TaxLine', $data['TxnTaxDetail'])) {
                    foreach($data['TxnTaxDetail']['TaxLine'] as $key1 => $value1) {
                        if($value1['DetailType'] == 'TaxLineDetail') {
                            $data['TxnTaxDetail']['TaxLine'][$key1]['Amount'] = "0";
                            $data['TxnTaxDetail']['TaxLine'][$key1]['TaxLineDetail']['NetAmountTaxable'] = "0";
                        }
                    }
                }
                                                            
                $data['TxnTaxDetail']['TotalTax'] = "0";
                $data['Balance'] = "0";
                $data['TotalAmt'] = "0";
                return response()->json([
                    'rc' => 1,
                    'data' => json_encode($data)
                ]);
            } else {
                return response()->json([
                    'rc' => 500,
                    'msg' => 'Data not found'
                ]); 
            }
        } else if($request->type == 'Estimate') {
            $get_data = $this->get_data($request, 'estimate', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);            
            if(array_key_exists('Estimate', $get_data)) {
                $data = $get_data['Estimate'];
                $data['PrivateNote'] = 'Voided';
                $data['SyncToken'] = $data['SyncToken'];
                foreach ($data['Line'] as $key => $value) {
                    # code...
                    if($data['Line'][$key]['DetailType'] == 'SalesItemLineDetail') {
                        $data['Line'][$key]['Amount'] = "0";
                        $data['Line'][$key]['SalesItemLineDetail']['Qty'] = "0";
                        // $data['Line'][$key]['SalesItemLineDetail']['UnitPrice'] = "0";
                    } else if($data['Line'][$key]['DetailType'] == 'SubTotalLineDetail') {
                        $data['Line'][$key]['Amount'] = "0";
                    } else if($data['Line'][$key]['DetailType'] == 'DiscountLineDetail') {
                        $data['Line'][$key]['DiscountLineDetail']['PercentBased'] = "0";
                        $data['Line'][$key]['DiscountLineDetail']['DiscountPercent'] = "0";
                        $data['Line'][$key]['Amount'] = "0";
                    }
                }    
                
                if(array_key_exists('TaxLine', $data['TxnTaxDetail'])) {
                    foreach($data['TxnTaxDetail']['TaxLine'] as $key1 => $value1) {
                        if($value1['DetailType'] == 'TaxLineDetail') {
                            $data['TxnTaxDetail']['TaxLine'][$key1]['Amount'] = "0";
                            $data['TxnTaxDetail']['TaxLine'][$key1]['TaxLineDetail']['NetAmountTaxable'] = "0";
                        }
                    }
                }
                                                            
                $data['TxnTaxDetail']['TotalTax'] = "0";
                $data['Balance'] = "0";
                $data['TotalAmt'] = "0";
                return response()->json([
                    'rc' => 1,
                    'data' => json_encode($data)
                ]);
            } else {
                return response()->json([
                    'rc' => 500,
                    'msg' => 'Data not found'
                ]); 
            }
        } else {
            return response()->json([
                'rc' => 500,
                'msg' => 'Data not found'
            ]);
        }
    }

    public function updateInvoiceQb(Request $request)
    {        
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings', 'refresh_token_quickbooks', 'expired_token_quickbooks')->first();

        try {
            $accounting_settings = json_decode($business->accounting_settings);

            if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret && $accounting_settings->quickbooks_api_access_token) {
                // $SHOPIFY_URL = getenv("SHOPIFY_URL");
                $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
                // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
                $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
                $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
                $Quickbooks_TOKEN = $accounting_settings->quickbooks_api_access_token;        
                if(strtotime(date('Y-m-d H:i:s')) >= strtotime($business->refresh_token_quickbooks)) {
                    $oauth2LoginHelper = new OAuth2LoginHelper($Quickbooks_KEY,$Quickbooks_SECRET);            
                    $accessTokenObj = $oauth2LoginHelper->
                                        refreshAccessTokenWithRefreshToken($business->refresh_token_quickbooks);
                    $accessTokenValue = $accessTokenObj->getAccessToken();
                    $Quickbooks_TOKEN = $accessTokenValue;
                    $refreshTokenValue = $accessTokenObj->getRefreshToken();
                    $minutes_to_add = 60;
        
                    $time = new DateTime();
                    $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
        
                    $stamp = $time->format('Y-m-d H:i');
                    $accounting_settings->quickbooks_api_access_token = $accessTokenValue;
                    Business::where('id', $business_id)->update([
                        'accounting_settings' => json_encode($accounting_settings),
                        'refresh_token_quickbooks' => $refreshTokenValue,
                        'expired_token_quickbooks' => $stamp
                    ]);
                }
            } else {
                return 'Url and Access Token Quickbooks Not Found';
            }
            
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_URL => $Quickbooks_URL.'/invoice?minorversion=65',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_POST => 1,
                    CURLOPT_POSTFIELDS => json_encode($request->data),
                    CURLOPT_RETURNTRANSFER => 1,
                    CURLOPT_HTTPHEADER => array(
                        'Accept: application/json',
                        'Content-Type: application/json',
                        'Authorization: Bearer '. $Quickbooks_TOKEN
                    )            
                )
            );

            $response = curl_exec($curl);
            $parseResponse = json_decode($response, true);                   
            if(array_key_exists('Invoice', $parseResponse)) {  
                $value = $parseResponse['Invoice'];                
                $arr_data = [                
                    'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                    'due_date' => $value['DueDate'],
                    'total_amt' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                    'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                    'balance' => $value['Balance'] ? $value['Balance'] : 0,
                    'customer_ref' => json_encode($value['CustomerRef']),
                    'txn_date' => $value["TxnDate"],
                ];
                
                DB::table('invoice_quickbooks')->where('invoice_id', $value['Id'])->update($arr_data);  
                $arr_data2 = [                
                    'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                    'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                    'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                    'balance' => $value['Balance'] ? $value['Balance'] : 0,
                    'name' => $value["CustomerRef"]['name'],
                    'date' => $value["TxnDate"],
                ];
                
                DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                return response()->json([
                    'rc' => 1,
                    'msg' => 'Update invoice successfully'
                ]);
            } else if(array_key_exists('Fault', $parseResponse)) {                
                return response()->json([
                    'rc' => 500,
                    'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                ]);                                
            } else {
                return response()->json([
                    'rc' => 500,
                    'msg' => "Problem with quickbooks"
                ]);
            } 
        } catch (ServiceException $qb) {
            //throw $th;
            $b = Business::find($business_id);
            $b->refresh_token_quickbooks = null;
            $b->expired_token_quickbooks = null;
            $b->save();
            return response()->json([
                'rc' => 500,
                'msg' => $qb->getMessage()
            ]);
        } catch (\Exception $err) {
            //throw $th;           \                
            return response()->json([
                'msg' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        } 
    }

    public function updateAllSalesQb(Request $request)
    {        
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings', 'refresh_token_quickbooks', 'expired_token_quickbooks')->first();

        try {
            $accounting_settings = json_decode($business->accounting_settings);

            if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret && $accounting_settings->quickbooks_api_access_token) {
                // $SHOPIFY_URL = getenv("SHOPIFY_URL");
                $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
                // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
                $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
                $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
                $Quickbooks_TOKEN = $accounting_settings->quickbooks_api_access_token;        
                if(strtotime(date('Y-m-d H:i:s')) >= strtotime($business->refresh_token_quickbooks)) {
                    $oauth2LoginHelper = new OAuth2LoginHelper($Quickbooks_KEY,$Quickbooks_SECRET);            
                    $accessTokenObj = $oauth2LoginHelper->
                                        refreshAccessTokenWithRefreshToken($business->refresh_token_quickbooks);
                    $accessTokenValue = $accessTokenObj->getAccessToken();
                    $Quickbooks_TOKEN = $accessTokenValue;
                    $refreshTokenValue = $accessTokenObj->getRefreshToken();
                    $minutes_to_add = 60;
        
                    $time = new DateTime();
                    $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
        
                    $stamp = $time->format('Y-m-d H:i');
                    $accounting_settings->quickbooks_api_access_token = $accessTokenValue;
                    Business::where('id', $business_id)->update([
                        'accounting_settings' => json_encode($accounting_settings),
                        'refresh_token_quickbooks' => $refreshTokenValue,
                        'expired_token_quickbooks' => $stamp
                    ]);
                }
            } else {
                return 'Url and Access Token Quickbooks Not Found';
            }
            
            if($request->type == 'Expense' || $request->type == 'Check') {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/purchase?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );
    
                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);                                   
                if(array_key_exists('Purchase', $parseResponse)) {  
                    $value = $parseResponse['Purchase'];                                
                    $arr_data2 = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                        'balance' => 0,
                        'num' => array_key_exists('DocNumber', $value) ? $value['DocNumber'] : null,
                        'name' => $value["EntityRef"]['name'],
                        'date' => $value["TxnDate"],
                    ];
                    
                    DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update '.$request->type.' successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                } 
            } else if($request->type == 'Purchase Order') {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/purchaseorder?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );
    
                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);                                   
                if(array_key_exists('PurchaseOrder', $parseResponse)) {  
                    $value = $parseResponse['PurchaseOrder'];                                
                    $arr_data2 = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                        'balance' => 0,
                        'num' => array_key_exists('DocNumber', $value) ? $value['DocNumber'] : null,
                        'name' => array_key_exists('VendorRef', $value) ? $value["VendorRef"]['name'] : null,
                        'date' => $value["TxnDate"],
                    ];
                    
                    DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update '.$request->type.' successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                } 
            } else if($request->type == 'Bill') {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/bill?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );
    
                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);                                   
                if(array_key_exists('Bill', $parseResponse)) {  
                    $value = $parseResponse['Bill'];                                
                    $arr_data2 = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                        'balance' => $value["Balance"],
                        'num' => array_key_exists('DocNumber', $value) ? $value['DocNumber'] : null,
                        'name' => array_key_exists('VendorRef', $value) ? $value["VendorRef"]['name'] : null,
                        'date' => $value["TxnDate"],
                        'due_date' => $value['DueDate'],
                    ];
                    
                    DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update '.$request->type.' successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                } 
            } else if($request->type == 'Bill Payment') {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/billpayment?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );
    
                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);     
                                   
                if(array_key_exists('BillPayment', $parseResponse)) {  
                    $value = $parseResponse['BillPayment'];                                
                    $account = array_key_exists('CheckPayment', $value) ? $value['CheckPayment'] : [];
                    $data = $request->data;
                    $arr_data = [
                        'balance' => 0
                    ];
                    DB::table('expense')->where('id_vendor', $data['Line'][0]['LinkedTxn'][0]['TxnId'])->update($arr_data);                    
                    $arr_data2 = [                
                        'date' => $value["TxnDate"],
                        'transaction_type' => 'Bill Payment',                                                
                        'num' => array_key_exists('DocNumber', $value) ? $value['DocNumber'] : null,
                        'name' => array_key_exists('VendorRef', $value) ? $value["VendorRef"]['name'] : null,                        
                        'memo' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'account' =>  array_key_exists('BankAccountRef', $account) ? $value['CheckPayment']['BankAccountRef']['name'] : null, 
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'balance' => array_key_exists('Balance', $value) ? $value['Balance'] : 0,
                        'id_vendor' => $value['Id'],
                        'sync_token' => array_key_exists('SyncToken', $value) ? $value['SyncToken'] : 0,                
                        'balance' => 0,
                    ]; 
                    
                    DB::table('expense')->insert($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update '.$request->type.' successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                }
            } else if($request->type == 'Payment') {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/payment?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );
    
                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);                                   
                if(array_key_exists('Payment', $parseResponse)) {  
                    $value = $parseResponse['Payment'];                                
                    $arr_data2 = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                                        
                        'num' => array_key_exists('PaymentRefNum', $value) ? $value['PaymentRefNum'] : null,
                        'name' => array_key_exists('CustomerRef', $value) ? $value["CustomerRef"]['name'] : null,
                        'date' => $value["TxnDate"],
                    ];
                    
                    DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update '.$request->type.' successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                } 
            } else if($request->type == "Sales Receipt") {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/salesreceipt?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );

                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);
                // dd($parseResponse);                   
                if(array_key_exists('SalesReceipt', $parseResponse)) {  
                    $value = $parseResponse['SalesReceipt'];                
                    $arr_data2 = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                        'balance' => $value['Balance'] ? $value['Balance'] : 0,
                        'name' => $value["CustomerRef"]['name'],
                        'date' => $value["TxnDate"],
                        'num' => array_key_exists('DocNumber', $value) ? $value['DocNumber'] : null
                    ];
                    
                    DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update Sales Receipt Successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                }
            } else if($request->type == "Credit Memo") {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/creditmemo?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );

                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);
                // dd($parseResponse);                   
                if(array_key_exists('CreditMemo', $parseResponse)) {  
                    $value = $parseResponse['CreditMemo'];                
                    $arr_data2 = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                        'balance' => $value['Balance'] ? $value['Balance'] : 0,
                        'name' => $value["CustomerRef"]['name'],
                        'date' => $value["TxnDate"],
                        'num' => array_key_exists('DocNumber', $value) ? $value['DocNumber'] : null
                    ];
                    
                    DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update Credit Memo Successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                }
            } else if($request->type == 'Estimate') {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/estimate?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );

                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);
                // dd($parseResponse);                   
                if(array_key_exists('Estimate', $parseResponse)) {  
                    $value = $parseResponse['Estimate'];                
                    $arr_data2 = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                        // 'balance' => $value['Balance'] ? $value['Balance'] : 0,
                        'name' => $value["CustomerRef"]['name'],
                        'date' => $value["TxnDate"],
                        'num' => array_key_exists('DocNumber', $value) ? $value['DocNumber'] : null
                    ];
                    
                    DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update Estimate Successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                }
            } else if($request->type == 'Refund') {
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $Quickbooks_URL.'/refundreceipt?minorversion=65',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POST => 1,
                        CURLOPT_POSTFIELDS => json_encode($request->data),
                        CURLOPT_RETURNTRANSFER => 1,
                        CURLOPT_HTTPHEADER => array(
                            'Accept: application/json',
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $Quickbooks_TOKEN
                        )            
                    )
                );

                $response = curl_exec($curl);
                $parseResponse = json_decode($response, true);
                // dd($parseResponse);                   
                if(array_key_exists('RefundReceipt', $parseResponse)) {  
                    $value = $parseResponse['RefundReceipt'];                
                    $arr_data2 = [                
                        'private_note' => array_key_exists('PrivateNote', $value) ? $value['PrivateNote'] : null,                
                        'amount' => $value['TotalAmt'] ? $value['TotalAmt'] : 0,
                        'sync_token' => $value['SyncToken'] ? $value['SyncToken'] : 0,                
                        'balance' => $value['Balance'] ? $value['Balance'] : 0,
                        'name' => $value["CustomerRef"]['name'],
                        'date' => $value["TxnDate"],
                        'num' => array_key_exists('DocNumber', $value) ? $value['DocNumber'] : null
                    ];
                    
                    DB::table('expense')->where('id_vendor', $value['Id'])->update($arr_data2);  
                    return response()->json([
                        'rc' => 1,
                        'msg' => 'Update Refund Successfully'
                    ]);
                } else if(array_key_exists('Fault', $parseResponse)) {                
                    return response()->json([
                        'rc' => 500,
                        'msg' => $parseResponse['Fault']['Error'][0]['Detail']
                    ]);                                
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Problem with quickbooks"
                    ]);
                }
            } else {
                return response()->json([
                    'rc' => 500,
                    'msg' => 'Under Construction'
                ]);
            }
        } catch (ServiceException $qb) {
            //throw $th;
            $b = Business::find($business_id);
            $b->refresh_token_quickbooks = null;
            $b->expired_token_quickbooks = null;
            $b->save();
            
            return response()->json([
                'rc' => 500,
                'msg' => $qb->getMessage()
            ]);
        } catch (\Exception $err) {
            //throw $th;                           
            return response()->json([
                'msg' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        } 
    }

    public function viewEditAllSalesQb(Request $request)
    {        
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('accounting_settings', 'refresh_token_quickbooks', 'expired_token_quickbooks')->first();

        try {
            $accounting_settings = json_decode($business->accounting_settings);

            if($accounting_settings->quickbooks_api_url && $accounting_settings->quickbooks_api_key && $accounting_settings->quickbooks_api_secret && $accounting_settings->quickbooks_api_access_token) {
                // $SHOPIFY_URL = getenv("SHOPIFY_URL");
                $Quickbooks_URL = $accounting_settings->quickbooks_api_url;
                // $Quickbooks_CRED = getenv("Quickbooks_CRED");        
                $Quickbooks_KEY = $accounting_settings->quickbooks_api_key;        
                $Quickbooks_SECRET = $accounting_settings->quickbooks_api_secret;        
                $Quickbooks_TOKEN = $accounting_settings->quickbooks_api_access_token;        
                if(strtotime(date('Y-m-d H:i:s')) >= strtotime($business->refresh_token_quickbooks)) {
                    $oauth2LoginHelper = new OAuth2LoginHelper($Quickbooks_KEY,$Quickbooks_SECRET);            
                    $accessTokenObj = $oauth2LoginHelper->
                                        refreshAccessTokenWithRefreshToken($business->refresh_token_quickbooks);
                    $accessTokenValue = $accessTokenObj->getAccessToken();
                    $Quickbooks_TOKEN = $accessTokenValue;
                    $refreshTokenValue = $accessTokenObj->getRefreshToken();
                    $minutes_to_add = 60;
        
                    $time = new DateTime();
                    $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
        
                    $stamp = $time->format('Y-m-d H:i');
                    $accounting_settings->quickbooks_api_access_token = $accessTokenValue;
                    Business::where('id', $business_id)->update([
                        'accounting_settings' => json_encode($accounting_settings),
                        'refresh_token_quickbooks' => $refreshTokenValue,
                        'expired_token_quickbooks' => $stamp
                    ]);
                }
            } else {
                return 'Url and Access Token Quickbooks Not Found';
            }

            if($request->type == 'Expense') {
                $purchase = $this->get_data($request, 'purchase', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $paymentmethod = $this->get_data($request, 'paymentmethod', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);            
                $vendor = $this->get_data($request, 'vendor', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();                
                if(array_key_exists('Purchase', $purchase)) {
                    return response()->json([
                        'rc' => 1,                        
                        'purchase' => $purchase['Purchase'],                                                
                        'product' => $product,
                        'account' => $account['QueryResponse']['Account'],
                        'payment_method' => $paymentmethod['QueryResponse']['PaymentMethod'],
                        'vendor' => $vendor['QueryResponse']['Vendor'],
                        'customer' => $customer['QueryResponse']['Customer'],
                    ]); 
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => 'Data not found, please do sync quickbooks data again'
                    ]);
                }
            } else if($request->type == 'Purchase Order') {
                $purchase = $this->get_data($request, 'purchaseorder', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $vendor = $this->get_data($request, 'vendor', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);         
                $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();                       
                if(array_key_exists('PurchaseOrder', $purchase)) {
                    return response()->json([
                        'rc' => 1,
                        'purchase_order' => $purchase['PurchaseOrder'],
                        'vendor' => $vendor['QueryResponse']['Vendor'],
                        'customer' => $customer['QueryResponse']['Customer'],
                        'account' => $account["QueryResponse"]['Account'],
                        'product' => $product
                    ]);
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => "Data not found, please do sync quickbooks data again"
                    ]);
                }
            } else if($request->type == 'Check') {
                $vendor = $this->get_data($request, 'vendor', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $purchase = $this->get_data($request, 'purchase', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);     
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);    
                $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();                
                if(array_key_exists('Purchase', $purchase)) {
                    return response()->json([
                        'rc' => 1,                        
                        'purchase' => $purchase['Purchase'],                                                
                        'product' => $product,
                        'account' => $account['QueryResponse']['Account'],
                        'vendor' => $vendor['QueryResponse']['Vendor'],
                        'customer' => $customer['QueryResponse']['Customer'],
                    ]); 
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => 'Data not found, please do sync quickbooks data again'
                    ]);
                }
            } else if($request->type == 'Bill' || $request->type == 'Bill Payment') {
                $vendor = $this->get_data($request, 'vendor', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $term = $this->get_data($request, 'term', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);    
                $bill = $this->get_data($request, 'bill', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);     
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);    
                $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();                
                if(array_key_exists('Bill', $bill)) {
                    return response()->json([
                        'rc' => 1,                        
                        'bill' => $bill['Bill'],                                                
                        'product' => $product,
                        'term' => $term['QueryResponse']['Term'],
                        'vendor' => $vendor['QueryResponse']['Vendor'],
                        'customer' => $customer['QueryResponse']['Customer'],
                        'account' => $account['QueryResponse']['Account'],
                    ]); 
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => 'Data not found, please do sync quickbooks data again'
                    ]);
                }
            } else if($request->type == 'Payment') {
                $payment = $this->get_data($request, 'payment', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $paymentmethod = $this->get_data($request, 'paymentmethod', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $invoice = DB::table('invoice_quickbooks')->get();
                if(array_key_exists('Payment', $payment)) {
                    return response()->json([
                        'rc' => 1,                        
                        'payment' => $payment['Payment'],                                                
                        'invoice' => $invoice,                        
                        'customer' => $customer['QueryResponse']['Customer'],
                        'account' => $account['QueryResponse']['Account'],
                        'payment_method' => $paymentmethod['QueryResponse']['PaymentMethod'],
                    ]); 
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => 'Data not found, please do sync quickbooks data again'
                    ]);
                }
            } else if($request->type == 'Sales Receipt') {
                $sales_receipt = $this->get_data($request, 'salesreceipt', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $paymentmethod = $this->get_data($request, 'paymentmethod', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $taxrate = $this->get_data($request, 'taxrate', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();

                if(array_key_exists('SalesReceipt', $sales_receipt)) {
                    return response()->json([
                        'rc' => 1,                        
                        'sales_receipt' => $sales_receipt['SalesReceipt'],                                                
                        'product' => $product,                        
                        'customer' => $customer['QueryResponse']['Customer'],
                        'account' => $account['QueryResponse']['Account'],
                        'taxrate' => $taxrate['QueryResponse']['TaxRate'],
                        'payment_method' => $paymentmethod['QueryResponse']['PaymentMethod']
                    ]); 
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => 'Data not found, please do sync quickbooks data again'
                    ]);
                }
            } else if($request->type == 'Credit Memo') {
                $creditmemo = $this->get_data($request, 'creditmemo', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $paymentmethod = $this->get_data($request, 'paymentmethod', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $taxrate = $this->get_data($request, 'taxrate', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();

                if(array_key_exists('CreditMemo', $creditmemo)) {
                    return response()->json([
                        'rc' => 1,                        
                        'creditmemo' => $creditmemo['CreditMemo'],                                                
                        'product' => $product,                        
                        'customer' => $customer['QueryResponse']['Customer'],
                        'account' => $account['QueryResponse']['Account'],
                        'taxrate' => $taxrate['QueryResponse']['TaxRate'],
                        'payment_method' => $paymentmethod['QueryResponse']['PaymentMethod']
                    ]); 
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => 'Data not found, please do sync quickbooks data again'
                    ]);
                }
            } else if($request->type == 'Estimate') {
                $estimate = $this->get_data($request, 'estimate', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $paymentmethod = $this->get_data($request, 'paymentmethod', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                // $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $taxrate = $this->get_data($request, 'taxrate', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();

                if(array_key_exists('Estimate', $estimate)) {
                    return response()->json([
                        'rc' => 1,                        
                        'estimate' => $estimate['Estimate'],                                                
                        'product' => $product,                        
                        'customer' => $customer['QueryResponse']['Customer'],
                        // 'account' => $account['QueryResponse']['Account'],
                        'taxrate' => $taxrate['QueryResponse']['TaxRate'],
                        'payment_method' => $paymentmethod['QueryResponse']['PaymentMethod']
                    ]); 
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => 'Data not found, please do sync quickbooks data again'
                    ]);
                }
            } else if($request->type == 'Refund') {
                $refund = $this->get_data($request, 'refundreceipt', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $customer = $this->get_data($request, 'Customer', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $paymentmethod = $this->get_data($request, 'paymentmethod', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $account = $this->get_data($request, 'Account', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $taxrate = $this->get_data($request, 'taxrate', $Quickbooks_URL, $Quickbooks_KEY, $Quickbooks_SECRET, $Quickbooks_TOKEN);
                $product = Product::whereNotNull('quickbooks_id')->join('variations as v', 'v.product_id', '=', 'products.id')->select('products.name', 'products.quickbooks_id', 'v.default_sell_price', 'products.product_description')->get();

                if(array_key_exists('RefundReceipt', $refund)) {
                    return response()->json([
                        'rc' => 1,                        
                        'refund' => $refund['RefundReceipt'],                                                
                        'product' => $product,                        
                        'customer' => $customer['QueryResponse']['Customer'],
                        'account' => $account['QueryResponse']['Account'],
                        'taxrate' => $taxrate['QueryResponse']['TaxRate'],
                        'payment_method' => $paymentmethod['QueryResponse']['PaymentMethod']
                    ]); 
                } else {
                    return response()->json([
                        'rc' => 500,
                        'msg' => 'Data not found, please do sync quickbooks data again'
                    ]);
                }
            } else {                
                return response()->json([
                    'rc' => 500,
                    'msg' => 'Under Construction'
                ]);
            }

        } catch (ServiceException $qb) {
            //throw $th;
            $b = Business::find($business_id);
            $b->refresh_token_quickbooks = null;
            $b->expired_token_quickbooks = null;
            $b->save();
            return response()->json([
                'rc' => 500,
                'msg' => $qb->getMessage()
            ]);
        } catch (\Exception $err) {
            //throw $th;                           
            return response()->json([
                // 'message' => $err->getMessage(),
                'message' => 'Something went wrong, please try with sync quickbooks data again',
                'rc' => 500
            ]);
        } 
    }
}
