<?php

namespace App\Http\Controllers;

use App\Barcode;
use App\Brands;
use App\Business;
use App\Category;
use App\Jobs\CreateAmazonToShopifyJob;
use App\Jobs\GetShopifyProductJob;
use App\Jobs\ProcessShopifyStoreJob;
use App\Jobs\ShopifyUpdateJob;
use App\Jobs\UpdateHandleJob;
use App\Jobs\UpdatePrice15PercentShopifyJobs;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\SellingPriceGroup;
use App\ShopifyTable;
use App\ShopifyUpdate;
use App\Transaction;
use App\Unit;
use App\Utils\ProductUtil;
use App\Variation;
use App\VariationLocationDetails;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class ShopifyController extends Controller
{

    protected $productUtil;
    public function __construct(ProductUtil $productUtil) {
      $this->productUtil = $productUtil;
    }

    public function auth(Request $request)
    {        
        $product_locations = array($request->input('product_locations')); 
        if(empty($product_locations)) {
          return response()->json([
            'message' => 'Location must be selected',
            'data' => null
          ]);
        }       
        $checkmarks = $request->input('checkmarks');
        if(empty($checkmarks)) {
            return response()->json([
                'message' => 'Please Selected Sync Item First',
                'data' => null
            ]);
        }
        
        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

        $array_empty = [];
        $array_insert = [];

        $e_commerce_settings = json_decode($business->e_commerce_settings);
        // dd($e_commerce_settings)
        if($e_commerce_settings->shopify_api_url && $e_commerce_settings->shopify_api_access_token) {
          // $SHOPIFY_URL = getenv("SHOPIFY_URL");
          $SHOPIFY_URL = $e_commerce_settings->shopify_api_url;
          // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
          $SHOPIFY_CRED = $e_commerce_settings->shopify_api_access_token;        
        } else {
          return 'Url and Access Token Shopify Not Found';
        }
        // dd($SHOPIFY_URL, $SHOPIFY_CRED);
        try 
        {
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                CURLOPT_URL => $SHOPIFY_URL . "/admin/api/2022-10/products.json?limit=200",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'X-Shopify-Access-Token: ' . $SHOPIFY_CRED
                )
            
                )
            );
            
            // call back function to parse Headers and get Next Page Link
            curl_setopt(
              $curl,
              CURLOPT_HEADERFUNCTION,
              function($curl, $header) use (&$nextPage) {
                  $len = strlen($header);
                  $header = explode(':', $header, 2);

                  if (count($header) < 2) // ignore invalid headers
                  return $len;

                  if (trim($header[0]) === "Link" && strpos($header[1], 'next') !== false) {
                      $links = explode(',', $header[1], 2);

                      $link = count($links) === 2 ? $links[1] : $links[0];
                      if (preg_match('/<(.*?)>/', $link, $match) === 1) $nextPage = $match[1];
                  }

                  return $len;
              }
            );

            $response = curl_exec($curl);            

            if (curl_errno($curl)) {
              $error_msg = curl_error($curl);
              print_r($error_msg);
              $log = fopen('../sample/sresult.json','a');
              fwrite($log,"\ncurl_error81\n");
              fclose($log);
            }

            $parsedResponse = json_decode($response);            
            $products = json_decode(json_encode($parsedResponse->products), true);
            // dd($products[0]);
            // return $products;
            $randomNumber = $this->generateRandomString(10);            
            // dd($products); 
            // return $products;       
            $responseSaveProducts = $this->saveProducts($products, $randomNumber, $product_locations, $checkmarks, $request);  
            array_push($array_insert, $responseSaveProducts); 
            // var_dump()       


          while ($nextPage !== NULL) 
          {
            // dd($nextPage, CURLOPT_URL, $curl);
            curl_setopt($curl, CURLOPT_URL, $nextPage);
            $parsedResponse->products = [];
            $nextPage = NULL;

            $response = curl_exec($curl);
            $parsedResponse = json_decode($response);
            
            if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                print_r($error_msg);
                // $log = fopen('../sample/sresult.json','a');
                // fwrite($log,"\ncurl_error102\n");
                // fclose($log);
            } else {
                //$result = array_merge($result, $parsedResponse->products);
                $products = json_decode(json_encode($parsedResponse->products), true);
                //echo "Product count : " . count($products) . "\n";
                $randomNumber = $this->generateRandomString(10); 
                $responseSaveProducts = $this->saveProducts($products, $randomNumber, $product_locations, $checkmarks, $request);
                array_push($array_insert, $responseSaveProducts);
                sleep(2);
            }
          };

          curl_close($curl);
          // return $products;                    
          $body['shopify_checkbox'] = json_encode($checkmarks);  
          $business = Business::find($business_id);         
          $business->fill($body);
          $business->save();
          if($array_insert) {
            return response()->json([
                'message' => 'Recevied Data Success',
                'data' => $array_insert
            ]);
          } else {
              return response()->json([
                  'message' => 'Data Not Found',
                  'data' => null
              ]);
          }
            
        } catch (Exception $err) {
          return response()->json([
            'message' => $err->getMessage(),
            // 'message' => __('messages.something_went_wrong'),
            'data' => null
          ]);
        }

    }

    public static function saveProducts($products, $randomNumber, $product_locations, $checkmarks, Request $request, $amazon_id = null) 
    {                        
      DB::beginTransaction();
      $business_id = request()->session()->get('user.business_id');
      if(empty($checkmarks)) {
        $business = Business::find($business_id);
        $checkmarks = json_decode($business->shopify_checkbox);  
        /* $checkmarks_arr = [];
        foreach ($shopify_checkbox as $key => $val) {
          array_push($checkmarks_arr, $val->value);
        } */
      }                  
      /* $checkProductLocation = Product::join('variation_location_details as vld', 'vld.product_id', '=', 'products.id')
      ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id')
      ->whereNotNull('products.shopify_id')
      ->select('products.id', 'products.name', 'bl.id as location_id', 'vld.variation_id')
      ->first();
      if(!empty($checkProductLocation) && $checkProductLocation->location_id != $product_locations[0]) {
          $deleteTransactions = DB::select("delete transactions from transactions join products on products.id = transactions.opening_stock_product_id and transactions.location_id = ? where products.shopify_id is not null", [$checkProductLocation->location_id]);                    
          $deleteVariationLocationDetails = DB::select("delete variation_location_details from variation_location_details join products on products.id = variation_location_details.product_id and variation_location_details.location_id = ? where products.shopify_id is not null", [$checkProductLocation->location_id]);                  
          DB::select("delete purchase_lines from purchase_lines join products on products.id = purchase_lines.product_id where products.shopify_id is not null");          
          DB::select("delete product_locations from product_locations join products on products.id = product_locations.product_id where products.shopify_id is not null");          
          DB::select("delete variations from variations join products on products.id = variations.product_id where products.shopify_id is not null");          
          DB::select("delete from products where shopify_id is not null");
      } */
      if($products) {
        $no = 0;
        $arr = [];
        $status = '';        
        try {         
          $checkmarks_arr = []; 
          foreach ($checkmarks as $key => $val) {            
            if(is_array($val)) {
              array_push($checkmarks_arr, $val['value']);
            } else {
              array_push($checkmarks_arr, $val->value);
            }
          } 
          //code...
          foreach ($products as $key => $value) {                           
            //echo "Coming product shopify id : " . $value['id'] . ' - ';
            
            # code...
            $brandId = null;
            if(in_array('brand_id', $checkmarks_arr)) {
              if($value['vendor']) {
                $checkBrand = Brands::whereRaw("lower(name) = ?", $value['vendor'])->where('business_id', $business_id)->first();
                if($checkBrand == null) {
                  $b = new Brands();
                  $b->business_id = $business_id;
                  $b->name = $value['vendor'];
                  $b->description = null;
                  $b->created_by = auth()->user()->id;
                  $b->save();
      
                  $brandId = $b->id;
                } else {
                  $brandId = $checkBrand->id;
                }
              }
            }
  
            if(in_array('category_id', $checkmarks_arr)) {
              $categoryId = null;
              if($value['product_type']) {
                $checkCategory = Category::whereRaw("lower(name) = ?", $value['product_type'])->where('business_id', $business_id)->first();
                if($checkCategory == null) {
                  $c = new Category();
                  $c->name = $value['product_type'];
                  $c->business_id = $business_id;
                  $c->parent_id = 0;
                  $c->created_by = auth()->user()->id;
                  $c->category_type = 'product';
                  $c->save();
                  $categoryId = $c->id;
                } else {  
                  $categoryId = $checkCategory->id;
                }
              }
            }
  
            $unitId = null;
            if( $value['variants']) {
              $checkUnit = Unit::whereRaw("lower(actual_name) = ?", $value['variants'][0]['weight_unit'])->where('business_id', $business_id)->first();
              if($checkUnit == null) {
                $u = new Unit();
                $u->business_id = $business_id;
                $u->actual_name = $value['variants'][0]['weight_unit'];
                $u->short_name = $value['variants'][0]['weight_unit'];
                $u->created_by = auth()->user()->id;
                $u->save();
                $unitId = $u->id;
              } else {
                $unitId = $checkUnit->id;
              }     
            }
            
            $checkProduct = Product::where('shopify_id', $value['id'])->first();
            if($checkProduct == null) {
              $p = new Product();
              if(in_array('name', $checkmarks_arr)) {
                $p->name = $value['title'];
              }
              $p->business_id = $business_id;
              $p->type = 'single';
              $p->enable_stock = 1;
              $p->tax_type = 'exclusive';
              $p->unit_id = $unitId;
              $p->brand_id = $brandId;
              $p->category_id = $categoryId;
              $p->alert_quantity = 1;
              if(in_array('sku', $checkmarks_arr)) {
                $p->sku = $value['variants'][0]['sku'] ? $value['variants'][0]['sku'] : ' ';
              }
              if(in_array('barcode', $checkmarks_arr)) {
                $p->barcode = $value['variants'][0]['barcode'] ? $value['variants'][0]['barcode'] : ' ';
              }
              $p->created_by = auth()->user()->id;
              if(in_array('product_description', $checkmarks_arr)) {
                $p->product_description = $value['body_html'];
              }
              $p->shopify_id = $value['id'];
              if($amazon_id) {
                $p->amazon_id = $amazon_id;
              }
              $p->image = $value['image'] ? $value['image']['src'] : null;
              $p->save();
  
              if(! empty($product_locations)) {
                $p->product_locations()->sync($product_locations);
              }
  
              $pv = new ProductVariation();
              $pv->name = $value['variants'][0]['title'];
              $pv->product_id = $p->id;
              $pv->is_dummy = 0;
              $pv->created_at = Carbon::now();
              $pv->save();
  
              $v = new Variation();
              $v->name = $value['variants'][0]['title'];
              $v->product_id = $p->id;
              $v->sub_sku = $value['variants'][0]['sku'];
              $v->product_variation_id = $pv->id;
              if(in_array('default_sell_price', $checkmarks_arr)) {
                $v->default_sell_price = $value['variants'][0]['price'];
                $v->sell_price_inc_tax = $value['variants'][0]['price'];
              }
              $v->save();
              
              if(! empty($product_locations)) {
                if(count($product_locations) > 1) {
                  $qty_divide = $value['variants'][0]['inventory_quantity'] / 1;
                  foreach ($product_locations as $val) {
                    # code...
                    $vld = new VariationLocationDetails();
                    $vld->product_id = $p->id;
                    $vld->product_variation_id = $pv->id;
                    $vld->variation_id = $v->id;
                    $vld->location_id = $val;
                    $vld->qty_available = $qty_divide;
                    $vld->save();
  
                    $transaction = new Transaction();
                    $transaction->business_id = $business_id;
                    $transaction->location_id = $val;
                    $transaction->type = 'opening_stock';
                    $transaction->status = 'received';
                    $transaction->is_quotation = 0;
                    $transaction->payment_status = 'paid';
                    $transaction->transaction_date = Carbon::now();
                    $transaction->total_before_tax = 0;
                    $transaction->tax_amount = 0;
                    $transaction->discount_amount = 0;
                    $transaction->rp_redeemed = 0;
                    $transaction->rp_redeemed_amount = 0;
                    $transaction->shipping_charges = 0;
                    $transaction->is_export = 0;
                    $transaction->round_off_amount = 0;
                    $transaction->additional_expense_value_1 = 0;
                    $transaction->additional_expense_value_2 = 0;
                    $transaction->additional_expense_value_3 = 0;
                    $transaction->additional_expense_value_4 = 0;
                    $transaction->final_total = 0;
                    $transaction->is_direct_sale = 0;
                    $transaction->is_suspend = 0;
                    $transaction->exchange_rate = 1;
                    $transaction->opening_stock_product_id = $p->id;
                    $transaction->created_by = auth()->user()->id;
                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                    $transaction->is_created_from_api = 1;
                    $transaction->rp_earned = 0;
                    $transaction->is_recurring = 0;
  
                    $transaction->save();
  
                    $purchase_lines = new PurchaseLine();
                    $purchase_lines->transaction_id = $transaction->id;
                    $purchase_lines->product_id = $p->id;
                    $purchase_lines->variation_id = $v->id;
                    $purchase_lines->quantity = $qty_divide;
                    $purchase_lines->purchase_price = 0;
                    $purchase_lines->save();
                  }
                } else {
                  $vld = new VariationLocationDetails();
                  $vld->product_id = $p->id;
                  $vld->product_variation_id = $pv->id;
                  $vld->variation_id = $v->id;
                  $vld->location_id = $product_locations[0];
                  $vld->qty_available = $value['variants'][0]['inventory_quantity'];
                  $vld->save();
  
                  $transaction = new Transaction();
                  $transaction->business_id = $business_id;
                  $transaction->location_id = $product_locations[0];
                  $transaction->type = 'opening_stock';
                  $transaction->status = 'received';
                  $transaction->is_quotation = 0;
                  $transaction->payment_status = 'paid';
                  $transaction->transaction_date = Carbon::now();
                  $transaction->total_before_tax = 0;
                  $transaction->tax_amount = 0;
                  $transaction->discount_amount = 0;
                  $transaction->rp_redeemed = 0;
                  $transaction->rp_redeemed_amount = 0;
                  $transaction->shipping_charges = 0;
                  $transaction->is_export = 0;
                  $transaction->round_off_amount = 0;
                  $transaction->additional_expense_value_1 = 0;
                  $transaction->additional_expense_value_2 = 0;
                  $transaction->additional_expense_value_3 = 0;
                  $transaction->additional_expense_value_4 = 0;
                  $transaction->final_total = 0;
                  $transaction->is_direct_sale = 0;
                  $transaction->is_suspend = 0;
                  $transaction->exchange_rate = 1;
                  $transaction->opening_stock_product_id = $p->id;
                  $transaction->created_by = auth()->user()->id;
                  $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                  $transaction->is_created_from_api = 1;
                  $transaction->rp_earned = 0;
                  $transaction->is_recurring = 0;
  
                  $transaction->save();
  
                  $purchase_lines = new PurchaseLine();
                  $purchase_lines->transaction_id = $transaction->id;
                  $purchase_lines->product_id = $p->id;
                  $purchase_lines->variation_id = $v->id;
                  $purchase_lines->quantity = $value['variants'][0]['inventory_quantity'];
                  $purchase_lines->purchase_price = 0;
                  $purchase_lines->save();
                }
              }
  
              $no++;
              $status = 1;
              array_push($arr, [
                  'number' => $no,
                  'status' => $status
              ]);
            } else {            
              $checkmarks_arr = [];
              foreach ($checkmarks as $key => $val) {
                if(is_array($val)) {
                  array_push($checkmarks_arr, $val['value']);
                } else {
                  array_push($checkmarks_arr, $val->value);
                }
              }              
              
                $nameProduct =  $checkProduct->name == $value['title'] ? $checkProduct->name : $value['title'];
                $brand_id =  $checkProduct->brand_id == $brandId ? $checkProduct->brand_id : $brandId;
                $category_id = $checkProduct->category_id == $categoryId ? $checkProduct->category_id : $categoryId;
                $alert_qty = $checkProduct->alert_quantity == $value['variants'][0]['inventory_quantity'] ? $checkProduct->alert_quantity : $value['variants'][0]['inventory_quantity'];
                $description = $checkProduct->product_description == $value['body_html'] ? $checkProduct->product_description : $value['body_html'];            
                $valueSku = $value['variants'][0]['sku'] ? $value['variants'][0]['sku'] : ' ';
                $sku = $checkProduct->sku == $valueSku ? $checkProduct->sku : $valueSku;
                $valueBarcode = $value['variants'][0]['barcode'] ? $value['variants'][0]['barcode'] : ' ';
                $barcode = $checkProduct->barcode == $valueBarcode ? $checkProduct->barcode : $valueBarcode;
                $image = $value['image'] ? $value['image']['src'] : null;           
                
                $checkVariation = Variation::where('product_id', $checkProduct->id)->first(); 
                $statusVariation = null;                             
                if($checkVariation) {
                  $nameVariation = $checkVariation->name == $value['variants'][0]['title'] ? $checkVariation->name : $value['variants'][0]['title'];
                  $subSku = $checkVariation->sub_sku == $value['variants'][0]['sku'] ? $checkVariation->sub_sku : $value['variants'][0]['sku'];
                  $price = $checkVariation->default_sell_price == $value['variants'][0]['price'] ? $checkVariation->default_sell_price : $value['variants'][0]['price'];
      
                  /* $variation = Variation::where('product_id', $checkProduct->id)->update([
                    'name' => $nameVariation,
                    'sub_sku' => $subSku,
                    'default_sell_price' => $price,
                    'sell_price_inc_tax' => $price
                  ]); */
  
                  $variation = Variation::find($checkVariation->id);
                  $variation->name = $nameVariation;
                  $variation->sub_sku = $subSku;
                  if(in_array("default_sell_price", $checkmarks_arr)) {
                      $variation->default_sell_price = $price;
                      $variation->sell_price_inc_tax = $price;
                  }
                  
                  $variation->save();

                  $statusVariation = $variation->wasChanged();
                  
                }
                
                if($product_locations) {                
                  // if(count($product_locations) != count($checkProductQty)) {
                    // VariationLocationDetails::where('product_id', $checkProduct->id)->delete();
                    if(! empty($product_locations)) {
                      $productVariation = ProductVariation::where('product_id', $checkProduct->id)->select('id')->first();                    
                      foreach ($product_locations as $locval) {                      
                          # code...
                          $checkProductQty = VariationLocationDetails::where('product_id', $checkProduct->id)->where('location_id', $locval)->first();                        
                          $qty_divide = $value['variants'][0]['inventory_quantity'] / 1;
                          if($checkProductQty) {                                                    
                            if($checkProductQty->qty_available != $qty_divide) {
                              $vld = VariationLocationDetails::find($checkProductQty->id);
                              $vld->qty_available = $qty_divide;
                              $vld->save();               

                              $checkPurcasheLine = PurchaseLine::where('variation_id', $checkProductQty->variation_id)->where('product_id', $checkProduct->id)->first();
                              if($checkPurcasheLine == null) {
                                $transaction = new Transaction();
                                $transaction->business_id = $business_id;
                                $transaction->location_id = $locval;
                                $transaction->type = 'opening_stock';
                                $transaction->status = 'received';
                                $transaction->is_quotation = 0;
                                $transaction->payment_status = 'paid';
                                $transaction->transaction_date = Carbon::now();
                                $transaction->total_before_tax = 0;
                                $transaction->tax_amount = 0;
                                $transaction->discount_amount = 0;
                                $transaction->rp_redeemed = 0;
                                $transaction->rp_redeemed_amount = 0;
                                $transaction->shipping_charges = 0;
                                $transaction->is_export = 0;
                                $transaction->round_off_amount = 0;
                                $transaction->additional_expense_value_1 = 0;
                                $transaction->additional_expense_value_2 = 0;
                                $transaction->additional_expense_value_3 = 0;
                                $transaction->additional_expense_value_4 = 0;
                                $transaction->final_total = 0;
                                $transaction->is_direct_sale = 0;
                                $transaction->is_suspend = 0;
                                $transaction->exchange_rate = 1;
                                $transaction->opening_stock_product_id = $checkProduct->id;
                                $transaction->created_by = auth()->user()->id;
                                $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                $transaction->is_created_from_api = 1;
                                $transaction->rp_earned = 0;
                                $transaction->is_recurring = 0;
      
                                $transaction->save();
      
                                $purchase_lines = new PurchaseLine();
                                $purchase_lines->transaction_id = $transaction->id;
                                $purchase_lines->product_id = $checkProduct->id;
                                $purchase_lines->variation_id = $variation->id;
                                $purchase_lines->quantity = $qty_divide;
                                $purchase_lines->purchase_price = 0;
                                $purchase_lines->save();
                              } else {                                
                                $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                $purchase_lines->exp_date = null;
                                $purchase_lines->quantity = $qty_divide;
                                $purchase_lines->save();
                              }
                            }
                          } else {                     
                            /* $getTransactionPurchaseLinesLast = PurchaseLine::join('transactions as t', 't.id', '=', 'purchase_lines.transaction_id')
                                    ->where('purchase_lines.product_id', $checkProduct->id)
                                    ->where('purchase_lines.variation_id', $checkVariation->id)
                                    ->where('t.type', '=', 'opening_stock')
                                    ->where('t.business_id', $business_id)
                                    ->where('t.location_id', '<>', $locval)
                                    ->select('purchase_lines.*')
                                    ->orderBy('t.created_at', 'desc')->first();                                                    
                            if($getTransactionPurchaseLinesLast) {
                              $purchase_lines = PurchaseLine::find($getTransactionPurchaseLinesLast->id);
                              $purchase_lines->exp_date = Carbon::now()->subDays(30);
                              $purchase_lines->save();
                            } */   
                             
                            $vld = new VariationLocationDetails();
                            $vld->product_id = $checkProduct->id;
                            $vld->product_variation_id = $productVariation->id;
                            $vld->variation_id = $checkVariation->id;
                            $vld->location_id = $locval;
                            $vld->qty_available = $qty_divide;
                            $vld->save();
                      
                            $transaction = new Transaction();
                            $transaction->business_id = $business_id;
                            $transaction->location_id = $locval;
                            $transaction->type = 'opening_stock';
                            $transaction->status = 'received';
                            $transaction->is_quotation = 0;
                            $transaction->payment_status = 'paid';
                            $transaction->transaction_date = Carbon::now();
                            $transaction->total_before_tax = 0;
                            $transaction->tax_amount = 0;
                            $transaction->discount_amount = 0;
                            $transaction->rp_redeemed = 0;
                            $transaction->rp_redeemed_amount = 0;
                            $transaction->shipping_charges = 0;
                            $transaction->is_export = 0;
                            $transaction->round_off_amount = 0;
                            $transaction->additional_expense_value_1 = 0;
                            $transaction->additional_expense_value_2 = 0;
                            $transaction->additional_expense_value_3 = 0;
                            $transaction->additional_expense_value_4 = 0;
                            $transaction->final_total = 0;
                            $transaction->is_direct_sale = 0;
                            $transaction->is_suspend = 0;
                            $transaction->exchange_rate = 1;
                            $transaction->opening_stock_product_id = $checkProduct->id;
                            $transaction->created_by = auth()->user()->id;
                            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                            $transaction->is_created_from_api = 1;
                            $transaction->rp_earned = 0;
                            $transaction->is_recurring = 0;
                            $transaction->save();
    
                            $purchase_lines = new PurchaseLine();
                            $purchase_lines->transaction_id = $transaction->id;
                            $purchase_lines->product_id = $checkProduct->id;
                            $purchase_lines->variation_id = $variation->id;
                            $purchase_lines->quantity = $qty_divide;
                            $purchase_lines->purchase_price = 0;
                            $purchase_lines->save();                                                      
                          }                       
                      }                    
                    }
                  // }
                }                                       
  
                // $product = Product::where('shopify_id', $value['id'])->update([
                //   'product_description' => $description,
                //   'brand_id' => $brand_id,
                //   'alert_quantity' => $alert_qty,
                //   'name' => $nameProduct,
                //   'category_id' => $category_id,
                //   'sku' => $sku,
                //   'barcode' => $barcode,
                // ]);    
  
                $product = Product::find($checkProduct->id);              
                $product->alert_quantity = $alert_qty;              
                if(in_array("product_description", $checkmarks_arr)) {
                  $product->product_description = $description;
                }                    
                if(in_array("name", $checkmarks_arr)) {
                    $product->name = $nameProduct;
                }
                if(in_array("category_id", $checkmarks_arr)) {
                    $product->category_id = $category_id;
                }
                if(in_array("brand_id", $checkmarks_arr)) {
                    $product->brand_id = $brand_id;
                }
                if(in_array("sku", $checkmarks_arr)) {
                    $product->sku = $sku;
                }
                if(in_array("barcode", $checkmarks_arr)) {
                    $product->barcode = $barcode;
                }
                if($image) {
                  $product->image = $image;
                }
                $product->save();
                
                
                if($product->wasChanged() || $statusVariation) {                  
                  $no++;
                  $status = 2;
                  array_push($arr, [
                    'number' => $no,
                    'status' => $status,
                    'product_changed' => $product->wasChanged(),
                    'statusVariation' => $statusVariation,
                    'product_name' => $value['title'],
                    'shopify_id' => $value['id']
                  ]);
                }
  
                if(! empty($product_locations)) {
                  $checkProduct->product_locations()->sync($product_locations);
                }        
              // }
            }
            
          }
          DB::commit();
          return $arr;
        } catch (\Exception $err) {
          //throw $th;
          // dd($err);
          DB::rollBack();
          $error = 'File:'.$err->getFile().', Line:'.$err->getLine().', Message:'.$err->getMessage();
          Storage::disk('docs')->put('update_product_failed_'.date('YmdHis').'.txt', $error);
          // return $err->getMessage();
          return response()->json([
            'message' => 'File:'.$err->getFile().', Line:'.$err->getLine().', Message:'.$err->getMessage(),
            // 'message' => __('messages.something_went_wrong'),
            'data' => null
          ]);
        }
        // return 'Received Data Success';
      } else {        
        $arr = [];
        return $arr;
        // return 'Data Not Found';
      }
    }

    private static function generateRandomString($length = 10) {
      // $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
      $characters = '0123456789';
      $charactersLength = strlen($characters);
      $randomString = '';
      for ($i = 0; $i < $length; $i++) {
          $randomString .= $characters[random_int(0, $charactersLength - 1)];
      }
      return $randomString;
    }

    public function createUpdateProducts(Request $request, $products, $type) {      
      $business_id = request()->session()->get('user.business_id');
      $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

      $array_empty = [];
      $array_insert = [];

      $e_commerce_settings = json_decode($business->e_commerce_settings);
      // dd($e_commerce_settings)
      if($e_commerce_settings->shopify_api_url && $e_commerce_settings->shopify_api_access_token) {
        // $SHOPIFY_URL = getenv("SHOPIFY_URL");
        $SHOPIFY_URL = $e_commerce_settings->shopify_api_url;
        // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
        $SHOPIFY_CRED = $e_commerce_settings->shopify_api_access_token;        
      } else {
        return 'Url and Access Token Shopify Not Found';
      }
      try {
        //code...
        if($type == 'create') {
          foreach ($products as $product) {
            # code...
            // dd(array('product' => $product));
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                CURLOPT_URL => $SHOPIFY_URL . "/admin/api/2022-10/products.json",                                                                                             
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_POST => 1,
                CURLOPT_POSTFIELDS => json_encode(array(
                  'product' => $product
                )),
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'X-Shopify-Access-Token: ' . $SHOPIFY_CRED
                )
            
                )
            );
            $response = curl_exec($curl);            
            $parsedResponse = json_decode($response, true);            
            // $shopify_product = json_decode(json_encode($parsedResponse['product']), true);            
            // $checkmarks = [["name" => "checkmarks_amazon[]","value" => "name"],["name" => "checkmarks_amazon[]","value" => "product_description"],["name" => "checkmarks_amazon[]","value" => "category_id"],["name" => "checkmarks_amazon[]","value" => "brand_id"],["name" => "checkmarks_amazon[]","value" => "sku"],["name" => "checkmarks_amazon[]","value" => "barcode"],["name" => "checkmarks_amazon[]","value" => "default_sell_price"]];

            $this->saveProducts($parsedResponse, null, [1], [], $request, $product['id']);            
            curl_close($curl);

          }
        } else {
          // dd($products);
          foreach ($products as $product) {              
            // dd($SHOPIFY_URL . "/admin/api/2022-10/products/".$product['id'].".json");        
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                  array(
                  CURLOPT_URL => $SHOPIFY_URL . "/admin/api/2022-10/products/".$product['id'].".json",                                                                                             
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => "",
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 0,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => "PUT",
                  CURLOPT_POSTFIELDS => json_encode(array(
                    'product' => $product
                  )),
                  CURLOPT_HTTPHEADER => array(
                      'Content-Type: application/json',
                      'X-Shopify-Access-Token: ' . $SHOPIFY_CRED
                  )              
                )
              );
              $response = curl_exec($curl); 
              $parsedResponse = json_decode($response, true);     
              curl_close($curl);
              // $checkmarks = [["name" => "checkmarks_amazon[]","value" => "name"],["name" => "checkmarks_amazon[]","value" => "product_description"],["name" => "checkmarks_amazon[]","value" => "category_id"],["name" => "checkmarks_amazon[]","value" => "brand_id"],["name" => "checkmarks_amazon[]","value" => "sku"],["name" => "checkmarks_amazon[]","value" => "barcode"],["name" => "checkmarks_amazon[]","value" => "default_sell_price"]];
              $this->saveProducts($parsedResponse, null, [1], [], $request, $product['id']);                
              $productShopify = Product::join('variations as v', 'v.product_id', '=', 'products.id')
                ->where('shopify_id', $parsedResponse['product']['id'])
                ->select('products.id', 'v.id as variation_id')
                ->first();
              
              $variation = Variation::where('id', $productShopify->variation_id)
                            ->where('product_id', $productShopify->id)
                            ->first();
              //Add quantity in VariationLocationDetails
              $variation_location_d = VariationLocationDetails::where('variation_id', $variation->id)
                  ->where('product_id',  $productShopify->id)
                  ->where('product_variation_id', $variation->product_variation_id)
                  ->where('location_id', 1)
                  ->first();

              if (empty($variation_location_d)) {
                $variation_location_d = new VariationLocationDetails();
                $variation_location_d->variation_id = $variation->id;
                $variation_location_d->product_id = $productShopify->id;
                $variation_location_d->location_id = 1;
                $variation_location_d->product_variation_id = $variation->product_variation_id;
                $variation_location_d->qty_available = 0;
              }
              $variation_location_d->qty_available = $product['available'];
              $variation_location_d->save();
              
              $this->productUtil->postInventoryLevelsShopify($product['inventory_item_id'], $product['location_id'], $product['available'], $e_commerce_settings);
          }
        }        
        return true;
      } catch (\Throwable $th) {
        throw $th;            
        
        return false;
      }
    } 
    
    // failed test 
    // public function webhookJson(Request $request) {
    //     try {          
    //       // dd($request->all()[0]);
    //         //code...
    //         $business_id = request()->session()->get('user.business_id');
    //         $business = Business::where('id', $business_id)->select('e_commerce_settings')->first();

    //         $array_empty = [];
    //         $array_insert = [];

    //         $e_commerce_settings = json_decode($business->e_commerce_settings);
    //         // dd($e_commerce_settings)
    //         if($e_commerce_settings->shopify_api_url && $e_commerce_settings->shopify_api_access_token) {
    //           // $SHOPIFY_URL = getenv("SHOPIFY_URL");
    //           $SHOPIFY_URL = $e_commerce_settings->shopify_api_url;
    //           $SHOPIFY_SECRET = $e_commerce_settings->shopify_api_secret;
    //           // $SHOPIFY_CRED = getenv("SHOPIFY_CRED");        
    //           $SHOPIFY_CRED = $e_commerce_settings->shopify_api_access_token;        
    //         } else {
    //           return response([
    //               'messages' => 'Url and Access Token Shopify Not Found'
    //           ], 500);
    //         }

    //         /* define('CLIENT_SECRET', $SHOPIFY_SECRET);
    //         function verify_webhook($data, $hmac_header)
    //         {
    //           $calculated_hmac = base64_encode(hash_hmac('sha256', $data, CLIENT_SECRET, true));
    //           return hash_equals($calculated_hmac, $hmac_header);
    //         }

    //         $hmac_header = $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
    //         $data = file_get_contents('php://input');
    //         $verified = verify_webhook($data, $hmac_header);
    //         dd($verified);
    //         error_log('Webhook verified: '.var_export($verified, true)); // Check error.log to see the result
    //         if ($verified) {
    //           # Process webhook payload
    //           # ...
    //         } else {
    //           http_response_code(401);
    //         } */
    //         /* $data = array(
    //           "webhoook" => [
    //             "topic" => "product/create",
    //             "address" => "https://demo.virtualhills.com/api/shopify-webhook",
    //             "format" => "json"
    //           ]
    //         ); */

    //         $curl = curl_init();
    //         curl_setopt_array(
    //           $curl,
    //           array(
    //             CURLOPT_URL => $SHOPIFY_URL . "/admin/api/2022-10/webhooks.json",
    //             CURLOPT_RETURNTRANSFER => true,
    //             CURLOPT_ENCODING => "",
    //             CURLOPT_MAXREDIRS => 10,
    //             CURLOPT_TIMEOUT => 0,
    //             CURLOPT_FOLLOWLOCATION => true,
    //             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //             // CURLOPT_POST => 1,
    //             // CURLOPT_POSTFIELDS => $request->all()[0],
    //             CURLOPT_CUSTOMREQUEST => "GET",
    //             CURLOPT_HTTPHEADER => array(
    //                 // 'Content-Type: application/json',
    //                 'X-Shopify-Access-Token: '. $SHOPIFY_CRED,
    //                 // 'X-Shopify-Hmac-Sha256: a2f5db9d641ccbfb748973dcb06bd8351466081fb0f1a459ecfd6a8e9650558c',
    //                 // 'X-Shopify-API-Version: 2023-07'
    //             )            
    //           )
    //         );
    //         $response = curl_exec($curl);
    //         curl_close($curl);
    //         return response([
    //           'result' => json_decode($response)
    //         ], 200);            
    //     } catch (\Throwable $th) {
    //       //throw $th;
    //       return response([
    //         'messages' => $th->getMessage()
    //       ], 500);
    //     }
    // }

    // product create by Adri
    public function shopifyWebhook(Request $request) {
      try {                  
        //code...                    
        $business_id = request()->session()->get('user.business_id');
        $business = Business::find($business_id);
        $shopify_sync_settings = json_decode($business->shopify_sync_settings);
        if(property_exists($shopify_sync_settings, 'three')) {
          if($shopify_sync_settings->three == 1) {
            // $checkmarks = [["name" => "checkmarks_amazon[]","value" => "name"],["name" => "checkmarks_amazon[]","value" => "product_description"],["name" => "checkmarks_amazon[]","value" => "category_id"],["name" => "checkmarks_amazon[]","value" => "brand_id"],["name" => "checkmarks_amazon[]","value" => "sku"],["name" => "checkmarks_amazon[]","value" => "barcode"],["name" => "checkmarks_amazon[]","value" => "default_sell_price"]];
            $checkmarks = json_decode($business->shopify_checkbox);
            $this->saveProducts(array($request->all()), null, [1], $checkmarks, $request);
          }
        } 
        $contents = $request->all();                
        Storage::disk('docs')->put('content_product_create_success_'.date('YmdHis').'.txt', json_encode($contents));
      } catch (\Throwable $th) {
        Storage::disk('docs')->put('content_product_create_failed_'.date('YmdHis').'.txt', $th->getMessage());
        //throw $th;
        return response([
          'messages' => $th->getMessage()
        ], 500);
      }
    }

    // product update by Adri
    public function shopifyProductUpdateWebhook(Request $request)
    {
      try {                  
        //code...     
        $business_id = request()->session()->get('user.business_id');
        $business = Business::find($business_id);
        $shopify_sync_settings = json_decode($business->shopify_sync_settings);
        if(property_exists($shopify_sync_settings, 'four')) {
          if($shopify_sync_settings->four == 1) {
            // $checkmarks = [["name" => "checkmarks_amazon[]","value" => "name"],["name" => "checkmarks_amazon[]","value" => "product_description"],["name" => "checkmarks_amazon[]","value" => "category_id"],["name" => "checkmarks_amazon[]","value" => "brand_id"],["name" => "checkmarks_amazon[]","value" => "sku"],["name" => "checkmarks_amazon[]","value" => "barcode"],["name" => "checkmarks_amazon[]","value" => "default_sell_price"]];
            $checkmarks = json_decode($business->shopify_checkbox);
            $this->saveProducts(array($request->all()), null, [1], $checkmarks, $request);
          }
        }                       
        $contents = $request->all();                
        Storage::disk('docs')->put('content_product_update_success_'.date('YmdHis').'.txt', json_encode($contents));
      } catch (\Throwable $th) {
        Storage::disk('docs')->put('content_product_update_failed_'.date('YmdHis').'.txt', $th->getMessage());
        //throw $th;
        return response([
          'messages' => $th->getMessage()
        ], 500);
      }
    }

    // order create by Adri
    public function shopifyOrderWebhook(Request $request)
    {
      try {
        //code...        
        $contents = $request->all();                
        $business_id = request()->session()->get('user.business_id');
        $business = Business::find($business_id);
        $shopify_sync_settings = json_decode($business->shopify_sync_settings);
        if(property_exists($shopify_sync_settings, 'one')) {
          if($shopify_sync_settings->one == 1) {
            $product_shopify_id = $contents['line_items'][0]['product_id'];
            $quantity = $contents['line_items'][0]['quantity'];
            $sku = $contents['line_items'][0]['sku'];

            $product = Product::join('variations as v', 'v.product_id', '=', 'products.id')              
              ->where('sku', $sku)->where('shopify_id', $product_shopify_id)
              ->select('products.id', 'v.id as variation_id')
              ->first();
            
            $variation = Variation::where('id', $product->variation_id)
                          ->where('product_id', $product->id)
                          ->first();
            //Add quantity in VariationLocationDetails
            $variation_location_d = VariationLocationDetails::where('variation_id', $variation->id)
                ->where('product_id',  $product->id)
                ->where('product_variation_id', $variation->product_variation_id)
                ->where('location_id', 1)
                ->first();

            if (empty($variation_location_d)) {
              $variation_location_d = new VariationLocationDetails();
              $variation_location_d->variation_id = $variation->id;
              $variation_location_d->product_id = $product->id;
              $variation_location_d->location_id = 1;
              $variation_location_d->product_variation_id = $variation->product_variation_id;
              $variation_location_d->qty_available = 0;
            }
            $variation_location_d->qty_available -= $quantity;
            $variation_location_d->save();
          }
        }       
        Storage::disk('docs')->put('content_order_create_success_'.date('YmdHis').'.txt', json_encode($contents));
      } catch (\Throwable $th) {
        //throw $th;
        Storage::disk('docs')->put('content_order_create_failed_'.date('YmdHis').'.txt', $th->getMessage());
        //throw $th;
        return response([
          'messages' => $th->getMessage()
        ], 500);
      }
    }

    public function getShopifyTable(Request $request)
    {
      if (request()->ajax()) {      
        $query = ShopifyTable::select(
          'shopify_table.*',
          DB::raw("
              JSON_UNQUOTE(JSON_EXTRACT(Images, '$[0].link')) as image,
              (case
                when synced = 0 THEN 'NO'
                else 'YES'
              end) as sync,
              COALESCE((select 	 	
                name 
              from product_taxonomy_shopify
              where taxonomy_id = category), category) as correct_category
          "),
        );        

        if ($request->category) {
          $query->where('(CASE
                WHEN pts.name is null then shopify_table.category
                ELSE pts.name
              END)','=', $request->category);
        }

        if ($request->locations) {
          $query->where('vendor','=', $request->locations);
        }
        
        if ($request->synced === 0 || $request->synced === '0') {
          $query->where('synced','=', 0);
        } else if($request->synced == 1) {          
          $query->where('synced','=', 1);
        }

        $recordsTotal = $query->count();

        if (!empty($request->search['value'])) {
          $search = $request->search['value'];
          $query->whereRaw("
            vendor like '%$search%' or title like '%$search%' or barcode like '%$search%' or seller_sku like '%$search%' or (CASE
                WHEN pts.name is null then shopify_table.category
                ELSE pts.name
              END) like '%$search%'
          ");
        }

        $recordsFiltered = $query->count();

        // **Sorting**
        if (!empty($request->order)) {
            $columnIndex = $request->order[0]['column']; // Index kolom
            $columnName = $request->columns[$columnIndex]['data']; // Nama kolom
            $columnSortOrder = $request->order[0]['dir']; // 'asc' atau 'desc'
            if ($columnName) {
                if (intval($request->draw) == 1) {
                    $query->orderBy('shopify_table.id', 'desc');
                } else {
                    $query->orderBy($columnName, $columnSortOrder);
                }
            }
        } else {
            $query->orderBy('shopify_table.id', 'desc');
        }
        
        $products = $query->orderBy('shopify_table.id', 'desc')->offset($request->start)
            ->limit($request->length)
            ->get();        
        // dd($recordsTotal, $recordsFiltered);

        // **Response JSON**
        return response()->json([
            "draw" => intval($request->draw),
            "recordsTotal" => $recordsTotal,   // Total tanpa filter
            "recordsFiltered" => $recordsFiltered,  // Total dengan filter
            "data" => $products
        ]);
        // return DataTables::of($query)->make(true);
      }
    }

    public function getPreview(Request $request, $id)
    {
      try {
        $product = ShopifyTable::select(
            '*',
            DB::raw("
                JSON_UNQUOTE(JSON_EXTRACT(images, '$[0].link')) as image,
                COALESCE((select 	 	
                  name 
                from product_taxonomy_shopify
                where taxonomy_id = category), category) as category
            "),            
        )->where('id', $id)->first();
        return view('business.partials.view-shopify-modal')->with(compact(
            'product',
        ));
      } catch (\Exception $e) {
          \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());
      }
    }

    public function getTaxonomyCategories($afterCursor = null, $childrenOf = null)
    {
        $afterPart = $afterCursor ? 'after: "' . $afterCursor . '",' : '';
        $childrenOf = $childrenOf ? 'childrenOf: "'.$childrenOf.'"' : '';
        // $childrenOf = "childrenOf: 4133";
        // $childrenOf = null;
        $query = <<<GRAPHQL
        {
          productTaxonomyNodes(first: 250, $afterPart, $childrenOf) {
            edges {
              node {
                id
                name
                fullName
              }
            }
            pageInfo {
              hasNextPage
              endCursor
            }
          }
        }
        GRAPHQL;

        $response = Http::withHeaders([
            'X-Shopify-Access-Token' => env('SHOPIFY_CRED'),
            'Content-Type' => 'application/json',
        ])->post(env('SHOPIFY_URL')."/admin/api/unstable/graphql.json", [
            'query' => $query,
        ]);

        return $response->json();
    }

    public function getAllTaxonomyCategories()
    {
        $allCategories = [];
        $afterCursor = null;              # code...
        $table_product_taxonomy = DB::table('product_taxonomy_shopify')->where('level', 4)->get()->toArray();                  
        $responses = [];
        if(!empty($table_product_taxonomy)) {
          foreach ($table_product_taxonomy as $k => $t) {
            # code...
            $reponses[] = $this->getTaxonomy($afterCursor, $allCategories, $t->taxonomy_id, ($t->level+1));
          }
        }  else {
          $responses[] = $this->getTaxonomy($afterCursor, $allCategories, null, null);
        }           
                  
        return $responses;
    }

    public function getTaxonomy($afterCursor, $allCategories, $childrenOf, $level) {
      do {
        $response = $this->getTaxonomyCategories($afterCursor, $childrenOf);
        $categories = $response['data']['productTaxonomyNodes']['edges'] ?? [];
        $allCategories = array_merge($allCategories, $categories);

        $hasNextPage = $response['data']['productTaxonomyNodes']['pageInfo']['hasNextPage'] ?? false;

        $afterCursor = $hasNextPage ? $response['data']['productTaxonomyNodes']['pageInfo']['endCursor'] : null;
      } while ($hasNextPage);

      if(!empty($allCategories)) {
        $createTaxonomyArray = [];
        foreach ($allCategories as $key => $value) {
          # code... 
          array_push($createTaxonomyArray, [
            'taxonomy_id' => $value['node']['id'],
            'name' => $value['node']['name'],
            'fullName' => $value['node']['fullName'],
            'parent_id' => $childrenOf,
            'level' => $level
          ]);
        };
        DB::table('product_taxonomy_shopify')->insert($createTaxonomyArray);
        return $createTaxonomyArray;
      }
    }
    
    public function createShopifyProducts($products)
    {        
        $shopifyUrl = env('SHOPIFY_URL');
        $accessToken = env('SHOPIFY_CRED');

        $query = <<<'GRAPHQL'
        mutation productCreate($input: ProductInput!) {
          productCreate(input: $input) {
            userErrors {
              field
              message
            }
            product {
              id
              title
              handle
              descriptionHtml
              productType
              vendor
              tags
              status
              variants(first: 10) {
                edges {
                  node {
                    id
                    title
                    price
                    sku
                  }
                }
              }
              metafields(first: 10) {
                edges {
                  node {
                    namespace
                    key
                    value
                  }
                }
              }
            }            
          }
        }
        GRAPHQL;

        $responses = [];
        $totalSuccessfully = 0;

        foreach ($products as $product) {
            $startTime = microtime(true);
            \Log::info("Start save product shopify ".$product['title']);
            $variables = [
                'input' => [
                    'title' => $product['title'],
                    'handle' => $product['handle'],
                    'descriptionHtml' => $product['descriptionHtml'],
                    'vendor' => $product['vendor'],
                    'tags' => $product['tags'],
                    'status' => 'ACTIVE',
                    'variants' => array_map(function ($variant) {
                        return [
                            'title' => $variant['title'],
                            'price' => $variant['price'],
                            'sku' => $variant['sku'],
                            'barcode' => $variant['barcode'],
                            'inventoryQuantities' => [
                                [
                                    'locationId' => $variant['locationId'],
                                    'availableQuantity' => (int)$variant['quantity']
                                ]
                            ],
                            'inventoryItem' => [
                              'tracked' => true
                            ]
                        ];
                    }, $product['variants']),
                    'productCategory' => [
                      'productTaxonomyNodeId' => (string)$product['productCategory']                      
                    ],
                    // 'images' => array_map(function ($imageUrl) {
                    //     return ['src' => $imageUrl];
                    // }, $product['images']),
                    'metafields' => array_map(function ($metafield) {
                        return [
                            'namespace' => $metafield['namespace'],
                            'key' => $metafield['key'],
                            'value' => $metafield['value'],
                            'type' => $metafield['type']
                        ];
                    }, $product['metafields'])
                ]
            ];

            $response = Http::withHeaders([
                'X-Shopify-Access-Token' => $accessToken,
                'Content-Type' => 'application/json',
            ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
                'query' => $query,
                'variables' => $variables
            ]);            
            
            // \Log::info("Response save product shopify ".$product['title']);
            
            $productResult = $response->json();
            
            if (!isset($productResult['data']['productCreate']['product']['id'])) {
              // return ['error' => 'Product creation failed', 'response' => $productResult];
              \Log::info("Product ".$product['title']." creation failed");
              continue;
            }
            \Log::info($productResult['data']['productCreate']['product']['id']. ' - '. $product['title']);
            
            $productId = $productResult['data']['productCreate']['product']['id'];            

            foreach ($product['images'] as $images) {
              $imageMutation = <<<'GRAPHQL'
              mutation productCreateMedia($productId: ID!, $media: [CreateMediaInput!]!) {
                productCreateMedia(productId: $productId, media: $media) {
                  media {
                    alt
                    mediaContentType
                    status
                  }
                  mediaUserErrors {
                    field
                    message
                  }
                  product {
                    id
                    title
                  }
                }
              }
              GRAPHQL;

              $imageVariables = [
                  'media' => array_map(function ($src) {
                        return [
                            'alt' => 'Image',
                            'mediaContentType' => 'IMAGE',
                            'originalSource' => $src
                        ];
                  }, $images),
                  'productId' => $productId,
              ];

              $imageResponse = Http::withHeaders([
                  'X-Shopify-Access-Token' => $accessToken,
                  'Content-Type' => 'application/json',
              ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
                  'query' => $imageMutation,
                  'variables' => $imageVariables
              ]);

              $imageResult = $imageResponse->json();
              // \Log::info("Response save image product shopify ".$product['title']. " image Src: ".$images[0]);
              // \Log::info($imageResponse->body());
            }

            // Step 2: Check or Create Collections
            $collectionIds = [];
            $collections = explode(',', $product['tags']);
            foreach ($collections as $collectionTitle) {
                // Step 2.1: Search for existing collection
                $searchCollectionQuery = <<<'GRAPHQL'
                query($title: String!) {
                  collections(first: 10, query: $title) {
                    edges {
                      node {
                        id
                        title                      
                      }
                    }
                  }
                }
                GRAPHQL;

                $searchCollectionVariables = ['title' => 'title:'.$collectionTitle];

                $searchResponse = Http::withHeaders([
                    'X-Shopify-Access-Token' => $accessToken,
                    'Content-Type' => 'application/json',
                ])->post("{$shopifyUrl}/admin/api/2024-04/graphql.json", [
                    'query' => $searchCollectionQuery,
                    'variables' => $searchCollectionVariables
                ]);

                $searchResult = $searchResponse->json();
                // \Log::info("Done search collection product shopify by title ".$collectionTitle);
                // \Log::info($searchResponse->body());
                $exactCollection = collect($searchResult['data']['collections']['edges'])
                  ->firstWhere('node.title', $collectionTitle);
                // $existingCollection = $searchResult['data']['collectionByHandle']['id'] ?? null;
                $existingCollection = $exactCollection['node']['id'] ?? null;

                if ($existingCollection) {
                    // Collection already exists, use its ID
                    $collectionIds[] = $existingCollection;
                    // \Log::info("Done get collection product shopify ".$product['title']. " collection: ".$existingCollection.'-'.$collectionTitle);
                } else {
                    // Step 2.2: Create new collection
                    $createCollectionMutation = <<<'GRAPHQL'
                    mutation collectionCreate($input: CollectionInput!) {
                      collectionCreate(input: $input) {
                        collection {
                          id
                          title
                        }
                        userErrors {
                          field
                          message
                        }
                      }
                    }
                    GRAPHQL;
                    
                    $createCollectionVariables = ['input' => ['title' => $collectionTitle]];

                    $createCollectionResponse = Http::withHeaders([
                        'X-Shopify-Access-Token' => $accessToken,
                        'Content-Type' => 'application/json',
                    ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
                        'query' => $createCollectionMutation,
                        'variables' => $createCollectionVariables
                    ]);

                    $createCollectionResult = $createCollectionResponse->json();
                    // \Log::info("Response save collection product shopify ".$product['title']. " collection: ".$collectionTitle);
                    // \Log::info($createCollectionResponse->body());

                    if (isset($createCollectionResult['data']['collectionCreate']['collection']['id'])) {
                        $collectionIds[] = $createCollectionResult['data']['collectionCreate']['collection']['id'];
                    }
                }
            }

            // Step 3: Add Product to Each Collection
            foreach ($collectionIds as $collectionId) {
                $addProductMutation = <<<'GRAPHQL'
                mutation collectionAddProductsV2($id: ID!, $productIds: [ID!]!) {
                  collectionAddProductsV2(id: $id, productIds: $productIds) {
                    job {
                      done
                      id
                    }
                    userErrors {
                      field
                      message
                    }
                  }
                }
                GRAPHQL;

                $addProductVariables = [
                    'id' => $collectionId,
                    'productIds' => [$productId]
                ];

                $addProductResponse = Http::withHeaders([
                    'X-Shopify-Access-Token' => $accessToken,
                    'Content-Type' => 'application/json',
                ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
                    'query' => $addProductMutation,
                    'variables' => $addProductVariables
                ]);

                $addProductResult = $addProductResponse->json();
                // \Log::info("Done save product to collection shopify ".$product['title']. " productId: ".$productId." collection: ".$collectionId. "");
                // \Log::info($addProductResponse);
            }

            $endTime = microtime(true); // Waktu selesai
            $executionTime = $endTime - $startTime; // Hitung durasi dalam detik
            \Log::info("Save Product Shopify Successfully {$product['title']} at {$executionTime} seconds.");
            $responses[] = $response->body();
            $totalSuccessfully++;
        }
                  
        return [
          'total' => $totalSuccessfully,
          'response' => $responses
        ];
    }

    public function productCreateGraphQl() 
    {
       $location = $this->locationShopify();

       $products = DB::select("
          WITH RECURSIVE category_tree AS (
              SELECT 
                  id,
                  JSON_UNQUOTE(JSON_EXTRACT(collections, '$[0].displayName')) AS category_name,
                  JSON_UNQUOTE(JSON_EXTRACT(collections, '$[0].classificationId')) AS category_id,
                  JSON_EXTRACT(collections, '$[0].parent') AS parent_data,
                  -- Start assuming the current category is the last parent
                  JSON_UNQUOTE(JSON_EXTRACT(collections, '$[0].displayName')) AS last_parent_name
              FROM shopify_table
              UNION ALL
              SELECT 
                  ct.id,
                  ct.category_name,
                  ct.category_id,
                  JSON_EXTRACT(ct.parent_data, '$.parent') AS parent_data,
                  CASE 
                      WHEN ct.parent_data IS NOT NULL 
                      THEN JSON_UNQUOTE(JSON_EXTRACT(ct.parent_data, '$.displayName')) 
                      ELSE ct.last_parent_name
                  END AS last_parent_name
              FROM category_tree ct
              WHERE ct.parent_data IS NOT NULL
          )
          SELECT 
              CONCAT(\"product\", ROW_NUMBER() OVER (ORDER BY barcode DESC)) AS handle,
              st.title,
              st.description AS description,
              st.vendor,
              (CASE 
                WHEN ct.last_parent_name like '%Apps & Games%' THEN 'gid://shopify/ProductTaxonomyNode/5180'                
                WHEN ct.last_parent_name like '%Arts, Crafts & Sewing%' THEN 'gid://shopify/ProductTaxonomyNode/356'                
                WHEN ct.last_parent_name like '%Books%' THEN 'gid://shopify/ProductTaxonomyNode/4134'                
                WHEN ct.last_parent_name like '%CDs & Vinyl%' THEN 'gid://shopify/ProductTaxonomyNode/13599'                
                WHEN ct.last_parent_name like '%Clothing, Shoes & Jewelry%' THEN 'gid://shopify/ProductTaxonomyNode/331'                
                WHEN ct.last_parent_name like '%Electronics%' THEN 'gid://shopify/ProductTaxonomyNode/1267'                
                WHEN ct.last_parent_name like '%Gift Cards%' THEN 'gid://shopify/ProductTaxonomyNode/5582'                
                WHEN ct.last_parent_name like '%Home & Kitchen%' THEN 'gid://shopify/ProductTaxonomyNode/3429'                
                WHEN ct.last_parent_name like '%Movies & TV%' THEN 'gid://shopify/ProductTaxonomyNode/4140'                
                WHEN ct.last_parent_name like '%Musical Instruments%' THEN 'gid://shopify/ProductTaxonomyNode/727'                
                WHEN ct.last_parent_name like '%Office Products%' THEN 'gid://shopify/ProductTaxonomyNode/4163'                
                WHEN ct.last_parent_name like '%Patio, Lawn & Garden%' THEN 'gid://shopify/ProductTaxonomyNode/3819'                
                WHEN ct.last_parent_name like '%Pet Supplies%' THEN 'gid://shopify/ProductTaxonomyNode/3'                
                WHEN ct.last_parent_name like '%Software%' THEN 'gid://shopify/ProductTaxonomyNode/4342'                
                WHEN ct.last_parent_name like '%Sports & Outdoors%' THEN 'gid://shopify/ProductTaxonomyNode/4719'                
                WHEN ct.last_parent_name like '%Tools & Home Improvement%' THEN 'gid://shopify/ProductTaxonomyNode/14301'                
                WHEN ct.last_parent_name like '%Toys & Games%' THEN 'gid://shopify/ProductTaxonomyNode/5178'                
                WHEN ct.last_parent_name like '%Video Games%' THEN 'gid://shopify/ProductTaxonomyNode/1684'                
                ELSE null
              END) as category,    
              st.tags AS tags,   
              ct.last_parent_name as collection,
              1 as published,
              'Title' as option1_name,
              'Default Title' as option1_value,
              st.seller_sku as variant_sku,
              0 as variant_grams,
              'shopify' as variant_inventory_tracker,
              qty as variant_inventory_qty,
              'continue' as variant_inventory_policy,
              'manual' as variant_fullfilment_service,
              price as variant_price,
              1 as variant_require_shipping,
              1 as variant_taxable,
              barcode as variant_barcode,
              (CASE 
                WHEN JSON_UNQUOTE(JSON_EXTRACT(images, '$[0].link')) is null THEN '[{\"variant\":\"MAIN\",\"link\":\"https://ubdtx.virtualhills.com/img/no_img.png\",\"height\":1500,\"width\":1500}]'
                ELSE images
              END) as image_src,
              1 as image_position,
              metafield_condition,
              metafield_description,
              metafield_edition,
              metafield_format,
              metafield_isbn10,
              metafield_isbn13,
              REPLACE(REPLACE((metafield_languange), '[', ''), ']', '') as metafield_languange,
              metafield_print_length,
              metafield_material_type,
              metafield_publication_date,
              REPLACE(REPLACE((metafield_publisher), '[', ''), ']', '') as metafield_publisher,
              metafield_title,
              'lb' as variant_weight_unit,              
              'active' as status
          FROM shopify_table st
          LEFT JOIN category_tree ct ON st.id = ct.id
          WHERE ct.parent_data IS NULL -- Ensures we only get the root parent category
          Order by barcode
       ");       

       if(!empty($products)) {
        $responses = [];
        $chunks = array_chunk($products, 10);
        $totalSuccessfully = 0;
        foreach ($chunks as $keyChunk => $chunk) {
          # code...
          $arr_products = [];
          foreach ($chunk as $key => $product) {
            # code...
            $arr_images = [];
            $images = json_decode($product->image_src);            
            foreach ($images as $img) {
              # code...
              array_push($arr_images, [$img->link]);
            }

            array_push($arr_products, [
              'title' => $product->title,
              'handle' => $product->handle,
              'descriptionHtml' => $product->description,
              'vendor' => $product->vendor,
              'tags' => $this->extractTags($product->tags),
              'variants' => [
                  [
                      'title' => 'Default Variant',
                      'price' => $product->variant_price,
                      'sku' => $product->variant_sku,
                      'barcode' => $product->variant_barcode,
                      'locationId' => $location['id'],
                      'quantity' => $product->variant_inventory_qty
                  ],
              ],
              'metafields' => [
                  [
                      'namespace' => 'global',
                      'key' => 'description',
                      'value' => $product->description,
                      'type' => 'multi_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'title',
                      'value' => $product->metafield_title,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'edition',
                      'value' => $product->metafield_edition,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'materialtype',
                      'value' => $product->metafield_material_type,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'format',
                      'value' => $product->metafield_format,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'condition',
                      'value' => $product->metafield_condition,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'publisher',
                      'value' => $product->metafield_publisher,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'custom',
                      'key' => 'publication_date',
                      'value' => $product->metafield_publication_date,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'languange',
                      'value' => explode(',',$product->metafield_languange)[0],
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'length',
                      'value' => $product->metafield_print_length,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'isbn13',
                      'value' => $product->metafield_isbn13,
                      'type' => 'single_line_text_field'
                  ],
                  [
                      'namespace' => 'global',
                      'key' => 'isbn10',
                      'value' => $product->metafield_isbn10,
                      'type' => 'single_line_text_field'
                  ],
              ],
              'images' => $arr_images,
              'productCategory' => $product->category,
            ]);
          }

          // using job
          CreateAmazonToShopifyJob::dispatch($arr_products, $keyChunk);
          
          // run directly from url
          /* $response = $this->createShopifyProducts($arr_products);
          $responses[] = $response['response'];
          $totalSuccessfully = $totalSuccessfully + $response['total'];
          \Log::info("How many product send to shopify on batch ".($keyChunk+1)." successfully: ".$response['total']); */
        }
        // response from run directly from url
        /* \Log::info("How many product send to shopify successfully: ".$totalSuccessfully);
        return $responses; */
        return response()->json(['message' => "processing create shopify product graphql using job"]);
       } else {
        return response()->json(['message' => 'Data not found!']);
       }
    }

    public function locationShopify($store)
    {
      $query = <<<'GRAPHQL'
        query {
          locations(first: 10) {
            edges {
              node {
                id
                name
              }
            }
          }
        }
        GRAPHQL;

      $response = Http::withHeaders([
        // 'X-Shopify-Access-Token' => env('SHOPIFY_CRED'),
        'X-Shopify-Access-Token' => $store['store_cred'],
        'Content-Type' => 'application/json',
      // ])->post(env('SHOPIFY_URL') . "/admin/api/2024-01/graphql.json", [
      ])->post($store['store_url'] . "/admin/api/2024-01/graphql.json", [
          'query' => $query
      ]);

      $respon = $response->json();
      return $response['data']['locations']['edges'][0]['node'];
    }

    public function extractTags($json)
    {
        $tags = [];
    
        // Convert JSON string to array (if not already an array)
        if (is_string($json)) {
            $json = json_decode($json, true);
        }
    
        // Recursive function to get all displayNames
        $getTags = function ($node) use (&$getTags, &$tags) {
            if (isset($node['displayName'])) {
                $tags[] = $node['displayName'];
            } else if (isset($node['title'])) {
                $tags[] = $node['title'];
            }
            if (isset($node['parent'])) {
                $getTags($node['parent']);
            }
        };
    
        // Loop through JSON and extract tags
        foreach ($json as $item) {
            $getTags($item);
        }

        $tags_string = '';
        foreach ($tags as $kt => $t) {
          # code...
          if(($kt+1) == count($tags)) {
            $tags_string .= $t;
          } else {
            $tags_string .= $t.',';
          }
        }
        return $tags_string;
        // return array_unique($tags); // Remove duplicates
    }

    public function getProduct($afterCursor = null, $store = [])
    {
        $afterPart = $afterCursor ? 'after: "' . $afterCursor . '",' : '';
        // $childrenOf = "childrenOf: 4133";
        // $childrenOf = null;
        // with collections
        /* $query = <<<GRAPHQL
        {
          products(first: 250, $afterPart) {
            edges {
              node {
                id
                title
                variants(first: 10) {
                  edges {
                    node  {
                      id,
                      barcode
                    }
                  }
                }
                collections(first: 100) {
                  edges {
                    node {
                      id
                      title
                    }
                  }
                }
              }
            }
            pageInfo {
              hasNextPage
              endCursor
            }
          }
        }
        GRAPHQL; */

        // without collections
        $query = <<<GRAPHQL
        {
          products(first: 250, $afterPart) {
            edges {
              node {
                id
                handle
                title
                metafield(namespace: "global", key: "condition") {
                  key
                  value
                }
                variants(first: 10) {
                  edges {
                    node  {
                      id,
                      barcode,
                      sku,
                      price,
                      inventoryQuantity,
                      inventoryItem {
                        id                        
                      }
                    }
                  }
                }
              }
            }
            pageInfo {
              hasNextPage
              endCursor
            }
          }
        }
        GRAPHQL;

        $shopify_url = !empty($store) ? $store['store_url'] : env('SHOPIFY_URL');
        $shopify_cred = !empty($store) ? $store['store_cred'] : env('SHOPIFY_CRED');
        $response = Http::withHeaders([
            'X-Shopify-Access-Token' => $shopify_cred,
            'Content-Type' => 'application/json',
        ])->post($shopify_url."/admin/api/2024-01/graphql.json", [
            'query' => $query,
        ]);
        return $response->json();
    }

    public function getAllShopifyProducts($store)
    {      
      // 'collections' => json_encode($edge['node']['collections'])
      $allCategories = [];
      $afterCursor = null;
      DB::table('shopify_server_temp')->where('store', $store['store_url'])->delete();

      do {
          // Fetch products using GraphQL
          $response = $this->getProduct($afterCursor, $store);
          $products = $response['data']['products']['edges'] ?? [];

          $batchInsert = [];

          foreach ($products as $edge) {                  
              $batchInsert[] = [
                  'shopify_id' => $edge['node']['id'],
                  'title' => $edge['node']['title'],
                  'handle' => $edge['node']['handle'],
                  'barcode' => $edge['node']['variants']['edges'][0]['node']['barcode'] ?? null,
                  'sku' => $edge['node']['variants']['edges'][0]['node']['sku'] ?? null,
                  'variant_id' => $edge['node']['variants']['edges'][0]['node']['id'] ?? null,
                  'inventory_item_id' => $edge['node']['variants']['edges'][0]['node']['inventoryItem']['id'] ?? null,
                  'quantity' => $edge['node']['variants']['edges'][0]['node']['inventoryQuantity'] ?? null,
                  'price' => $edge['node']['variants']['edges'][0]['node']['price'] ?? null,
                  'store' => $store['store_url'],
                  'condition' => $edge['node']['metafield']['value'] ?? null
              ];
              
              // Dispatch to queue (Optional)
              // GetShopifyProductJob::dispatch($edge);
          }

          // Bulk insert for better performance
          if (!empty($batchInsert)) {
              DB::table('shopify_server_temp')->insert($batchInsert);
          }

          $hasNextPage = $response['data']['products']['pageInfo']['hasNextPage'] ?? false;
          $afterCursor = $hasNextPage ? $response['data']['products']['pageInfo']['endCursor'] : null;

          // Prevent hitting Shopify API limits
          usleep(1000000); // 500ms delay
      } while ($hasNextPage);

      return response()->json(['message' => 'Get All Shopify Products Processing...']);
    }

    // Function to update product price
    public function updateShopifyProductPrice($sku, $price, $store)
    {
        $getVariantId = $this->getVariantAndInventoryItemIdBySku($sku, $store);      
        if($getVariantId['variantId']) {
          $response = $this->updateProductPrice($getVariantId['variantId'], $price, $store);
          if(!array_key_exists('errors', $response)) {
            ShopifyTable::where('seller_sku', $sku)->update([
              'price' => $price
            ]);
          }
          Log::info("Response Update Price Product Shopify Sku: ".$sku);
          Log::info(json_encode($response));
          return response()->json($response);
        } else {
          return response()->json('Sku not found!');
        }
    }

    // Function to update product quantity
    public function updateShopifyProductQuantity($sku, $quantity, $store)
    {
      $getInventoryItemId = $this->getVariantAndInventoryItemIdBySku($sku, $store);    
      $location = $this->locationShopify($store);        
      if($getInventoryItemId['inventoryItemId'] && $location) {
        $response = $this->updateProductQuantity($getInventoryItemId['inventoryItemId'], $quantity, $location['id'], $store);
        if(!array_key_exists('errors', $response)) {
          ShopifyTable::where('seller_sku', $sku)->update([
            'qty' => $quantity
          ]);
        }
        Log::info("Response Update Quantity Product Shopify Sku: ".$sku);
        Log::info(json_encode($response));
        return response()->json($response);
      } else {
        return response()->json('Sku not found!');
      }
    }

    // Function to update product price
    public function updateProductPrice($variantId, $newPrice, $store)
    {
        $query = <<<'GRAPHQL'
        mutation productVariantUpdate($input: ProductVariantInput!) {
            productVariantUpdate(input: $input) {
                productVariant {
                    id
                    price
                }
                userErrors {
                    field
                    message
                }
            }
        }
        GRAPHQL;       

        $variables = [
            'input' => [              
              'id' => $variantId,
              'price' => (string) $newPrice,                
            ]
        ];

        return $this->makeGraphQLRequest($query, $variables, $store);
    }

    // Function to update product quantity
    public function updateProductQuantity($inventoryItemId, $qtyChange, $locationId, $store)
    {
        // $query = <<<'GRAPHQL'
        // mutation inventoryAdjustQuantities($input: InventoryAdjustQuantitiesInput!) {
        //   inventoryAdjustQuantities(input: $input) {
        //     inventoryAdjustmentGroup {
        //       createdAt
        //       reason
        //       changes {
        //         delta
        //         name
        //       }
        //     }
        //     userErrors {
        //       field
        //       message
        //     }
        //   }
        // }
        // GRAPHQL;
        $query = <<<'GRAPHQL'
        mutation inventorySetOnHandQuantities($input: InventorySetOnHandQuantitiesInput!) {
          inventorySetOnHandQuantities(input: $input) {
            inventoryAdjustmentGroup {
              createdAt
              reason
              changes {
                delta
                name
              }
            }
            userErrors {
              field
              message
            }
          }
        }
        GRAPHQL;

        $variables = [
          "input" => [
          //   // "name" => "available",
            "reason" => "correction",
          //   // 'changes' => [
          //   //     'inventoryItemId' => $inventoryItemId,
          //   //     'locationId' => $locationId,
          //   //     'delta' => (int) $qtyChange,
          //   // ]
            'setQuantities' => [
                'inventoryItemId' => $inventoryItemId,
                'locationId' => $locationId,
                'quantity' => (int) $qtyChange,
            ]
          ]
        ];
                
        return $this->makeGraphQLRequest($query, $variables, $store);
    }

    // Helper function to send GraphQL requests
    public function makeGraphQLRequest($query, $variables, $store)
    {
        $shopifyUrl = !empty($store) ? $store['store_url'] : env('SHOPIFY_URL');
        $accessToken = !empty($store) ? $store['store_cred'] : env('SHOPIFY_CRED');
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            // 'X-Shopify-Access-Token' => env('SHOPIFY_CRED'),
            'X-Shopify-Access-Token' => $accessToken,
        // ])->post(env('SHOPIFY_URL')."/admin/api/2024-07/graphql.json", [
        ])->post($shopifyUrl."/admin/api/2024-07/graphql.json", [
            'query' => $query,
            'variables' => $variables
        ]);
        
        Log::info("Responses Query");
        Log::info(json_encode($response->json()));
        return $response->json();
    }

    public function getVariantAndInventoryItemIdBySku($sku, $store)
    {
      $shopifyUrl = !empty($store) ? $store['store_url'] : env('SHOPIFY_URL');
      $accessToken = !empty($store) ? $store['store_cred'] : env('SHOPIFY_CRED');
      $query = <<<GRAPHQL
      {
        productVariants(first: 10, query: "sku:$sku") {
          edges {
            node {
              id
              title
              sku
              barcode
              inventoryItem {
                id
              }
              product {
                id
                title
              }
            }
          }
        }
      }
      GRAPHQL;

      $response = Http::withHeaders([
          // 'X-Shopify-Access-Token' => env('SHOPIFY_CRED'),
          'X-Shopify-Access-Token' => $accessToken,
          'Content-Type' => 'application/json',
      // ])->post(env('SHOPIFY_URL')."/admin/api/2024-01/graphql.json", [
      ])->post($shopifyUrl."/admin/api/2024-01/graphql.json", [
          'query' => $query,
      ]);

      $data = $response->json();

      // Extract the first variant (if exists)
      $variantNode = $data['data']['productVariants']['edges'][0]['node'] ?? null;

      if ($variantNode) {
          $variantId = $variantNode['id'];
          $inventoryItemId = $variantNode['inventoryItem']['id'];

          // $query = <<<GRAPHQL
          // {
          //   inventoryLevels(first: 1, inventoryItemIds: ["{$inventoryItemId}"]) {
          //     edges {
          //       node {
          //         id
          //         available
          //         location {
          //           id
          //           name
          //         }
          //       }
          //     }
          //   }
          // }
          // GRAPHQL;

          // $response = Http::withHeaders([
          //     'X-Shopify-Access-Token' => env('SHOPIFY_CRED'),
          //     'Content-Type' => 'application/json',
          // ])->post(env('SHOPIFY_URL')."/admin/api/2024-01/graphql.json", [
          //     'query' => $query,
          // ]);

          // $data = $response->json();
          // $inventoryLevelId = $data['data']['inventoryLevels']['edges'][0]['node']['id'] ?? null;
          // Use or return these values as needed
      } else {
          // Handle not found
          $variantId = null;
          $inventoryItemId = null;
          // $inventoryLevelId = null;
      }

      return [
        'variantId' => $variantId,
        'inventoryItemId' => $inventoryItemId,
        // 'inventoryLevelId' => $inventoryLevelId,
      ];
    }

    public function labels(Request $request, $id)
    {
      if (! auth()->user()->can('product.print_labels')) {
        abort(403, 'Unauthorized action.');
      }
      $business_id = $request->session()->get('user.business_id');
      if ($id == 'multiple') {
          $products = DB::table('shopify_table')->whereIn('id', $request->products)->get();
          foreach ($products as $product) {
              $classificationRankExtract = $this->extractWords($product->category, 10); // up to 10 words                

              if (!empty($classificationRankExtract)) {
                  $whereCategoryCode = '';
                  foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                      # code...
                      if ($keyClassificationRank == 0) {
                          $whereCategoryCode .= "(lower(category_name) LIKE '%" . $classificationRank . "%'";
                      } else if (count($classificationRankExtract) != ($keyClassificationRank + 1)) {
                          $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%'";
                      } else {
                          $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%')";
                      }

                      if (count($classificationRankExtract) == 1) {
                          $whereCategoryCode .= ")";
                      }
                  }

                  $getCategoryCode = collect(DB::select("
                      SELECT category_code, category_name
                      FROM amazon_category_code
                      WHERE " . $whereCategoryCode . "
                      ORDER BY LENGTH(category_name) ASC
                      LIMIT 1;
                  "))->first();
                  
                  $product->category_code_selected = $getCategoryCode ? $getCategoryCode->category_code : '0-0';
                  $product->category_name_selected = $getCategoryCode ? $getCategoryCode->category_name : '';                
              } else {
                $product->category_code_selected = '0-0';
                $product->category_name_selected = '';
              }
          }
      } else {
          $products = DB::table('shopify_table')->where('id', $id)->get();

          $classificationRankExtract = $this->extractWords($products[0]->category, 10); // up to 10 words                    
          if (!empty($classificationRankExtract)) {
              $whereCategoryCode = '';
              foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                  # code...
                  if ($keyClassificationRank == 0) {
                      $whereCategoryCode .= "(lower(category_name) LIKE '%" . $classificationRank . "%'";
                  } else if (count($classificationRankExtract) != ($keyClassificationRank + 1)) {
                      $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%'";
                  } else {
                      $whereCategoryCode .= " AND lower(category_name) LIKE '%" . $classificationRank . "%')";
                  }
                  if (count($classificationRankExtract) == 1) {
                      $whereCategoryCode .= ")";
                  }
              }
              // foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
              //     # code...
              //     if($keyClassificationRank == 0) {
              //         $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
              //     } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
              //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
              //     } else {
              //         $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
              //     }
              // }

              $getCategoryCode = collect(DB::select("
                  SELECT category_code, category_name
                  FROM amazon_category_code
                  WHERE " . $whereCategoryCode . "
                  ORDER BY LENGTH(category_name) ASC
                  LIMIT 1;
              "))->first();
              $products[0]->category_code_selected = $getCategoryCode ? $getCategoryCode->category_code : '0-0';
              $products[0]->category_name_selected = $getCategoryCode ? $getCategoryCode->category_name : '';            
          } else {      
            $products[0]->category_code_selected = '0-0';
            $products[0]->category_name_selected = '';
          }
      }


      //get price groups
      $price_groups = [];
      if (! empty($purchase_id) || ! empty($product_id)) {
          $price_groups = SellingPriceGroup::where('business_id', $business_id)
              ->active()
              ->pluck('name', 'id');
      }

      $barcode_settings = Barcode::where('business_id', $business_id)
          ->orWhereNull('business_id')
          ->select(DB::raw('CONCAT(name, ", ", COALESCE(description, "")) as name, id, is_default'))
          ->get();
      $default = $barcode_settings->where('is_default', 1)->first();
      $barcode_settings = $barcode_settings->pluck('name', 'id');
      $information_labels = DB::table('information_labels')->get()->toArray();
      $category_code = DB::table("amazon_category_code")->get()->toArray();

      return view('business.partials.shopify_label_show')
          ->with(compact('products', 'barcode_settings', 'default', 'price_groups', 'information_labels', 'category_code'));
    }

    public function labelsPreview(Request $request)
    {
        try {
            //code...
            $rule_based = $request->get('rule_based');
            $products = $request->get('products');

            $product_title = $request->get('product_title');
            $product_title = $product_title ? $product_title : '';

            $product_price = $request->get('product_price');
            $product_price = $product_price ? $product_price : 0;

            //Log::info('labelsPreview product_price:    '.$product_price);
            Log::info('labelsPreview products: ' . json_encode($products));
            $print = $request->get('print');
            //Log::info('labelsPreview print: '.json_encode($print));
            $barcode_setting = $request->get('barcode_setting');
            $business_id = $request->session()->get('user.business_id');
            $barcode_details = Barcode::find($barcode_setting);
            $barcode_details->stickers_in_one_sheet = $barcode_details->is_continuous ? $barcode_details->stickers_in_one_row : $barcode_details->stickers_in_one_sheet;
            $barcode_details->paper_height = $barcode_details->is_continuous ? $barcode_details->height : $barcode_details->paper_height;
            if ($barcode_details->stickers_in_one_row == 1) {
                $barcode_details->col_distance = 0;
                $barcode_details->row_distance = 0;
            }
            // if($barcode_details->is_continuous){
            //     $barcode_details->row_distance = 0;
            // }            
            $business_name = $request->session()->get('business.name');

            $product_details_page_wise = [];
            $total_qty = 0;
            foreach ($products as $value) {
                Log::info('labelsPreview value: ' . json_encode($value));
                // $details = Keepa::find($value['product_id']);
              
                DB::table('print_labels_queue')->where('reference_id', $value['product_id'])->where('reference_table', 'shopify_table')->delete();
                $details = ShopifyTable::find($value['product_id']);
                //Log::info('labelsPreview seller_sku: '.$details->seller_sku);

                // $product_title = DB::table('amazon_table')
                //     ->where('SellerSku', $details->seller_sku)
                //     ->value('Title');
                // $getClassificationRankFirst = collect(DB::select("
                //     select JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].title')) as classificationRank
                //     from amazon_table 
                //     where id = ?
                // ", [$value['product_id']]))->first();
                // $classificationRankExtract = $this->extractWords($getClassificationRankFirst->classificationRank, 10); // up to 10 words                

                // if(!empty($classificationRankExtract)) {
                //     $whereCategoryCode = '';
                //     foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                //         # code...
                //         if($keyClassificationRank == 0) {
                //             $whereCategoryCode .= "(lower(category_name) LIKE '%".$classificationRank."%'";
                //         } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                //             $whereCategoryCode .= " AND lower(category_name) LIKE '%".$classificationRank."%'";
                //         } else {
                //             $whereCategoryCode .= " AND lower(category_name) LIKE '%".$classificationRank."%')";
                //         }
                //     }
                //     foreach ($classificationRankExtract as $keyClassificationRank => $classificationRank) {
                //         # code...
                //         if($keyClassificationRank == 0) {
                //             $whereCategoryCode .= " OR (lower(category_name) LIKE '%".$classificationRank."%'";
                //         } else if(count($classificationRankExtract) != ($keyClassificationRank+1)) {
                //             $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%'";
                //         } else {
                //             $whereCategoryCode .= " OR lower(category_name) LIKE '%".$classificationRank."%')";
                //         }
                //     }

                //     $getCategoryCode = collect(DB::select("
                //         SELECT category_code, category_name
                //         FROM amazon_category_code
                //         WHERE ".$whereCategoryCode."
                //         ORDER BY LENGTH(category_name) ASC
                //         LIMIT 1;
                //     "))->first();

                //     $details->category_code = $getCategoryCode->category_code;
                // } else {
                //     $details->category_code = '0-0';
                // }

                if (! empty($value['exp_date'])) {
                    $details->exp_date = $value['exp_date'];
                }
                if (! empty($value['packing_date'])) {
                    $details->packing_date = $value['packing_date'];
                }
                if (! empty($value['lot_number'])) {
                    $details->lot_number = $value['lot_number'];
                }

                $details->product_title = $value['product_title'];
                $details->category_code = $value['category_code'];
                // $details->product_price = $product_price;
                // $details->product_price = $value['price'];
                if($rule_based == 'true') {
                  // $data = [
                  //     ['value' => '.20', 'price' => 2.99],
                  //     ['value' => '.40', 'price' => 4.99],
                  //     ['value' => '.70', 'price' => 7.99],
                  //     ['value' => '.90', 'price' => 9.99],
                  //     ['value' => '.12', 'price' => 12.99],
                  //     ['value' => '.14', 'price' => 14.99],
                  // ];
                  $data = DB::table('rule_base_print_settings')->get();                    
                    $explode_price = explode('.', $value['price']);                    
                    $price = $value['price'];
                    foreach ($data as $k => $p) {
                        # code...
                        $compare_price = explode('.', $p->decimal_point);     
                        if(count($explode_price) > 1) {
                          if('.'.str_pad($compare_price[1], 2, '0', STR_PAD_RIGHT) == '.'.$explode_price[1]) {
                              $price = $p->price_on_print_label;
                          }
                        }                   
                    }
                    $details->product_price = $price;
                } else {
                    $details->product_price = $value['price'];
                }
                $details->barcode_type = 'C128';

                Log::info('labelsPreview details: ' . json_encode($details));

                for ($i = 0; $i < $value['quantity']; $i++) {
                    $page = intdiv($total_qty, $barcode_details->stickers_in_one_sheet);

                    if ($total_qty % $barcode_details->stickers_in_one_sheet == 0) {
                        $product_details_page_wise[$page] = [];
                    }

                    $product_details_page_wise[$page][] = $details;
                    $total_qty++;
                }
            }
            $margin_top = $barcode_details->is_continuous ? 0 : $barcode_details->top_margin * 1;
            $margin_left = $barcode_details->is_continuous ? 0 : $barcode_details->left_margin * 1;
            $paper_width = $barcode_details->paper_width * 1;
            $paper_height = $barcode_details->paper_height * 1;

            $i = 0;
            $len = count($product_details_page_wise);
            $is_first = false;
            $is_last = false;

            //$original_aspect_ratio = 4;//(w/h)
            $factor = (($barcode_details->width / $barcode_details->height)) / ($barcode_details->is_continuous ? 2 : 4);
            $html = '';
            foreach ($product_details_page_wise as $page => $page_products) {
                if ($i == 0) {
                    $is_first = true;
                }

                if ($i == $len - 1) {
                    $is_last = true;
                }

                $output = view('business.partials.amazon_labels_preview')
                    ->with(compact('print', 'page_products', 'business_name', 'barcode_details', 'margin_top', 'margin_left', 'paper_width', 'paper_height', 'is_first', 'is_last', 'factor'))->render();
                print_r($output);

                // return view('business.partials.amazon_labels_preview')
                //             ->with(compact('print', 'page_products', 'business_name', 'barcode_details', 'margin_top', 'margin_left', 'paper_width', 'paper_height', 'is_first', 'is_last', 'factor'));
                //$mpdf->WriteHTML($output);

                // if($i < $len - 1){
                //     // '', '', '', '', '', '', $margin_left, $margin_left, $margin_top, $margin_top, '', '', '', '', '', '', 0, 0, 0, 0, '', [$barcode_details->paper_width*1, $barcode_details->paper_height*1]
                //     $mpdf->AddPage();
                // }

                $i++;
            }

            print_r('<script>window.print()</script>');
            exit;
        } catch (\Exception $e) {
            //throw $th;
            // \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());          
            $output = __('lang_v1.barcode_label_error');
            return $output . ' ' . $e->getMessage();
        }
    }

    function extractWords($string, $count = null)
    {
        // Safety: Check for empty or non-string input
        if (!is_string($string) || trim($string) === '') {
            return []; // or return '', depending on your use case
        }

        // Remove all parenthesis content, e.g., (Books), (Movies & TV), etc.
        // $string = str_replace('(Books)', '', $string);
        $string = preg_replace('/\([^)]*\)/', '', $string);

        // Clean unwanted characters (keep letters, numbers, spaces)
        $clean = preg_replace('/[^\p{L}\p{N}\s]/u', '', $string);

        // Split into words
        $words = preg_split('/\s+/', trim($clean));

        // Remove empty values just in case
        $words = array_filter($words);

        // Handle no valid words found
        if (empty($words)) {
            return []; // or return '', depending on what you need
        }

        // Limit the number of words if requested
        if ($count !== null) {
            $words = array_slice($words, 0, $count);
        }

        return $words;
    }

    public function updateProductModal($sku, Request $request)
    {
      try {
          $type = $request->type;
          $data = ShopifyTable::where('seller_sku', $sku)->first();
          return view('business.partials.update_shopify_product_modal')->with(compact(
              'sku',
              'data',
              'type'
          ));
      } catch (\Exception $e) {
          Log::emergency('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
      }
    }

    public function popupSelectedItems(Request $request)
    {
      try {
        //code...
        $selected_rows = $request->selected_rows;

        $data = ShopifyTable::select("id", "barcode", "title", "seller_sku", "price", "qty")->whereIn('id', $selected_rows)->get()->toArray();

        return view('business.partials.shopify_popup_selected_items')->with(compact(
            'data',
        ));
      } catch (\Exception $e) {
          //throw $th;
          // Log::emergency('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
          return response()->json('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());
      }
    }

    public function updateOnAllShopify(Request $request)
    {
        try {
            //code...
            $products = $request->products;
            $seller_id = $request->seller_id;  
            $quantity = [];          
            $price = [];          
            $results = [];
            if (!empty($products)) {
                foreach ($products as $product) {
                    # code...
                    if($product['old_quantity'] != $product['quantity']) {
                        $quantity[] = $this->updateShopifyProductQuantity($product['sku'], $product['quantity'], []);
                        sleep(2);                        
                    }
                    if($product['old_price'] != $product['price']) {
                        $price[] = $this->updateShopifyProductPrice($product['sku'], $product['price'], []);
                        sleep(2);                        
                    }
                }
                array_push($results, $quantity);
                array_push($results, $price);
                return response()->json([
                    'rc' => 200,
                    'msg' => 'Successfully update products',
                    'results' =>  $results
                ]);
            } else {
                return response()->json([
                    'rc' => 500,
                    'msg' => 'Data not found!'
                ]);
            }
        } catch (\Exception $e) {
            //throw $th;
            return response()->json([
                'rc' => 500,
                'msg' => 'File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage()
            ]);
        }
    }

    public function fetchShopifyCollections($after = null, $store)
    {
        $after = $after ? 'after: "' . $after . '",' : '';
        $query = <<<GRAPHQL
          query {
            collections(first: 250, $after) {
              edges {
                cursor
                node {
                  id
                  title
                  handle
                }
              }
              pageInfo {
                hasNextPage
              }
            }
          }
        GRAPHQL;

        $shopify_url = !empty($store) ? $store['store_url'] : env('SHOPIFY_URL');
        $shopify_cred = !empty($store) ? $store['store_cred'] : env('SHOPIFY_CRED');
        $response = Http::withHeaders([
            'X-Shopify-Access-Token' => $shopify_cred,
            'Content-Type' => 'application/json',
        ])->post($shopify_url. "/admin/api/2024-07/graphql.json", [
            'query' => $query,
        ]);

        return $response->json('data.collections');
    }
    
    public function getAllShopifyCollections($store)
    {
        $allCollections = collect();
        $after = null;

        DB::table('shopify_collections')->where('store', $store['store_url'])->delete();
        do {
            $result = $this->fetchShopifyCollections($after, $store);
            $edges = $result['edges'];
            $batchInsert = [];

            foreach ($edges as $edge) {
                $batchInsert[] = [
                    'collection_id' => $edge['node']['id'],
                    'collection_name' => $edge['node']['title'],
                    'handle' => $edge['node']['handle'],
                    'store' => !empty($store) ? $store['store_url'] : env('SHOPIFY_URL')
                ];
                
                // Dispatch to queue (Optional)
                // GetShopifyProductJob::dispatch($edge);
            }

            // Bulk insert for better performance
            if (!empty($batchInsert)) {
                DB::table('shopify_collections')->insert($batchInsert);
            }
            // $allCollections = $allCollections->merge(collect($edges)->pluck('node'));
            $after = end($edges)['cursor'] ?? null;

            // Prevent hitting Shopify API limits
            usleep(500000); // 500ms delay
        } while ($result['pageInfo']['hasNextPage']);

        return $allCollections;
    }

    public function createShopifyProduct()
    {
      $productTaxonomyNodes = DB::table('product_taxonomy_shopify')->limit(10)->pluck('name', 'taxonomy_id');
      $collections = DB::table('shopify_collections')->limit(10)->pluck('collection_name', DB::raw('CONCAT(collection_id, \'-\', collection_name) as collection_id'));
      $itemCondition = [
        '-' => '-',
        'USED_LIKE_NEW' =>'USED_LIKE_NEW',
        'USED_VERY_GOOD' => 'USED_VERY_GOOD',
        'USED_GOOD' => 'USED_GOOD',
        'USED_ACCEPTABLE' => 'USED_ACCEPTABLE',
        'COLLECTIBLE_LIKE_NEW*' => 'COLLECTIBLE_LIKE_NEW*',
        'COLLECTIBLE_VERY_GOOD*' => 'COLLECTIBLE_VERY_GOOD*',
        'COLLECTIBLE_GOOD*' => 'COLLECTIBLE_GOOD*',
        'COLLECTIBLE_ACCEPTABLE*' => 'COLLECTIBLE_ACCEPTABLE*',
        'NOT_USED' => 'NOT_USED',
        'REFURBISHED' => 'REFURBISHED',
        'NEW' => 'NEW',
      ];
      return view('business.partials.shopify_create_product')->with(compact(
        'collections', 'productTaxonomyNodes', 'itemCondition'
      ));
    }

    public function searchCategory(Request $request)
    {
      $term = $request->q;
      $results = DB::table('product_taxonomy_shopify')->where('name', 'like', "%$term%")
        ->select('taxonomy_id as id', 'name as text')
        ->limit(10)
        ->get();

      return response()->json($results);
    }

    public function SearchCollections(Request $request)
    {
      $term = $request->q;

      $results = DB::table('shopify_collections')->where('collection_name', 'like', "%$term%")
        ->select(DB::raw('CONCAT(collection_id, \'-\', collection_name) as id'), 'collection_name as text')
        ->limit(10)
        ->get();

      return response()->json($results);

    }

    public function StoreProduct(Request $request)
    {
      if (! auth()->user()->can('product.create')) {
        abort(403, 'Unauthorized action.');
      }
      try {        
        //code...          
        // dd($request->all());             
        $collections = [];
        $tags = [];
        if(!empty($request->input('collections'))) {
          foreach ($request->input('collections') as $collection) {
            if($collections) {
              $split_collection = explode('-', $collection);
              # code...
              array_push($collections, [
                "displayName" => $split_collection[0]
              ]);
              array_push($tags, [
                "displayName" => $split_collection[1]
              ]);
            }
          }

          $collections = json_encode($collections);
          $tags = json_encode($tags);
        } else {
          $collections = json_encode($collections);
          $tags = json_encode($tags);
        }

        $image = null;
        if($request->hasFile('image')) {
          $dimensions = getimagesize($request->file('image')->getRealPath());
          $width = $dimensions[0];
          $height = $dimensions[1];

          // Buat URL akses publik
          $path = $request->file('image')->store('images', 'public');            
          $url = asset(Storage::url($path));
          $image = [
            [
              'variant' => 'MAIN',
              'link' => $url,
              'height' => $height,
              'width' => $width
            ]
          ];

          $image = json_encode($image);
        }

        $formattedProduct = [
          'title' => $request->input('name'),
          'description' => $request->input('product_description'). ', Material Type: '. $request->input('metafield_material_type'). ' ISBN13: '.$request->input('metafield_isbn13'). ' ISBN10: '. $request->input('metafield_isbn10'),
          'images' => $image,
          'category' => $request->input('category_id'),
          'seller_sku' => $request->input('sku'),
          'barcode' => $request->input('barcode'),
          'price' => $request->input('price'),
          'qty' => $request->input('qty'),
          'metafield_description' => $request->input('product_description'),
          'metafield_title' => $request->input('name'),
          'metafield_edition' => $request->input('metafield_edition'),
          'metafield_material_type' => $request->input('metafield_material_type'),
          'metafield_format' => $request->input('metafield_format'),
          'metafield_condition' => $request->input('metafield_condition'),
          'metafield_publisher' => $request->input('metafield_publisher'),
          'metafield_publisher' => $request->input('metafield_publisher'),
          'metafield_publication_date' => $request->input('metafield_publication_date'),
          'metafield_languange' => $request->input('metafield_languange'),
          'metafield_print_length' => $request->input('metafield_print_length'),
          'metafield_isbn13' => $request->input('metafield_isbn13'),
          'metafield_isbn10' => $request->input('metafield_isbn10'),
          'collections' => $collections,
          'tags' => $tags,
          'vendor' => json_encode($request->input('vendor')),
          'weight' => $request->input('weight_lb'),
          'product_type' => $request->input('product_type'),
          'products' => json_encode([]),
          'synced' => 0
        ];

        DB::beginTransaction(); 
        ShopifyTable::create($formattedProduct);
        DB::commit();
        $output = ['success' => 1,
            'msg' => __('product.product_added_success'),
        ];
        return redirect('e-commerce-integration')->with('status', $output);
      } catch (\Exception $e) {
        //throw $th;
        DB::rollBack();
        \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

        $output = ['success' => 0,
            'msg' => __('messages.something_went_wrong'),
        ];

        return redirect('e-commerce-integration')->with('status', $output);
      }


    }

    public function SendToShopify(Request $request)
    {
      $shopify_table = ShopifyTable::whereIn('id', $request->selected_rows)->get();
      if(!empty($shopify_table)) {
        $arr_products = [];
        foreach ($shopify_table as $product) {
          $vendor = json_decode($product->vendor);
          $location = $this->locationShopify($vendor ? $vendor[0] : '');
          # code...
          $arr_images = [];
          $images = json_decode($product->images);            
          if($images) {
            foreach ($images as $img) {
              # code...
              array_push($arr_images, [$img->link]);
            }
          }
            
          array_push($arr_products, [
            'id' => $product->id,
            'title' => $product->title,
            'handle' => str_replace(' ','', strtolower($product->title)),
            'descriptionHtml' => $product->description,
            'vendor' => $vendor ? $vendor[0] : '',
            'productType' => $product->product_type,
            'collections' => $this->extractTags($product->collections),
            'tags' => $this->extractTags($product->tags),
            'variants' => [
                [
                    'title' => 'Default Variant', 
                    'price' => $product->price,
                    'sku' => $product->seller_sku,
                    'barcode' => $product->barcode,
                    'locationId' => $location['id'],
                    'quantity' => $product->qty,
                    'weight' => $product->weight,
                ],
            ],
            'metafields' => [
                [
                    'namespace' => 'global',
                    'key' => 'description',
                    'value' => $product->description,
                    'type' => 'multi_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'title',
                    'value' => $product->metafield_title,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'edition',
                    'value' => $product->metafield_edition,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'materialtype',
                    'value' => $product->metafield_material_type,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'format',
                    'value' => $product->metafield_format,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'condition',
                    'value' => $product->metafield_condition,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'publisher',
                    'value' => $product->metafield_publisher,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'custom',
                    'key' => 'publication_date',
                    'value' => $product->metafield_publication_date,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'languange',
                    'value' => explode(',',$product->metafield_languange)[0],
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'length',
                    'value' => $product->metafield_print_length,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'isbn13',
                    'value' => $product->metafield_isbn13,
                    'type' => 'single_line_text_field'
                ],
                [
                    'namespace' => 'global',
                    'key' => 'isbn10',
                    'value' => $product->metafield_isbn10,
                    'type' => 'single_line_text_field'
                ],
            ],
            'images' => $arr_images,
            'productCategory' => $product->category,
          ]);
        }                

        $results = $this->sendToShopifyUsingGraphQl($arr_products);
        return response()->json([
          'rc' => 200,
          'rm' => 'Successfully',
          'data' => $results
        ]);
      } else {
        return response()->json([
          'rc' => 500,
          'rm' => 'Data not found!'
        ]);
      }          
    }

    public function sendToShopifyUsingGraphQl($products) 
    {
      try {
        //code...
        $results = [];
        foreach ($products as $key => $product) {
          // dd($product);
          # code...
          $productId = $this->productCreateMutationGraphQl($product, []);
          if($product['images']) {          
            $this->imagesMutationGraphQl($product['images'], $productId, []);
          }
          if($product['collections']) {
            $this->addProductToCollection($product['collections'], $productId);
          }
          array_push($results, [
            'product' => $product['title'],
            'productId' => $productId,
          ]);
          ShopifyTable::where('id', $product['id'])->update(['synced' => 1]);
        }

        return $results;
      } catch (\Exception $e) {
        //throw $th;
        return ['error' => $e->getMessage()];
      }
    }

    public function productCreateMutationGraphQl($product, $store)
    {
      $shopifyUrl = !empty($store) ? $store['store_url'] : env('SHOPIFY_URL');
      $accessToken = !empty($store) ? $store['store_cred'] : env('SHOPIFY_CRED');

      $query = <<<'GRAPHQL'
      mutation productCreate($input: ProductInput!) {
        productCreate(input: $input) {
          userErrors {
            field
            message
          }
          product {
            id
            title
            handle
            descriptionHtml
            productType
            vendor
            tags
            status
            variants(first: 10) {
              edges {
                node {
                  id
                  title
                  price
                  sku
                }
              }
            }
            metafields(first: 10) {
              edges {
                node {
                  namespace
                  key
                  value
                }
              }
            }
          }            
        }
      }
      GRAPHQL;

      $responses = [];
      $totalSuccessfully = 0;

      // foreach ($products as $product) {
      $startTime = microtime(true);
      \Log::info("Start save product shopify ".$product['title']);
      $variables = [
          'input' => [
              'title' => $product['title'],
              'handle' => $product['handle'],
              'descriptionHtml' => $product['descriptionHtml'],
              'vendor' => $product['vendor'],
              'tags' => $product['tags'],
              'status' => 'ACTIVE',
              'productType' => $product['productType'],
              'variants' => array_map(function ($variant) {
                  return [
                      'title' => $variant['title'],
                      'price' => $variant['price'],
                      'sku' => $variant['sku'],
                      'barcode' => $variant['barcode'],
                      'inventoryQuantities' => [
                          [
                              'locationId' => $variant['locationId'],
                              'availableQuantity' => (int)$variant['quantity']
                          ]
                      ],
                      'inventoryItem' => [
                        'tracked' => true,
                        'measurement' => [
                          'weight' => [
                            'unit' => 'POUNDS',
                            'value' => (float) $variant['weight']
                          ]
                        ]
                      ]
                  ];
              }, $product['variants']),
              'productCategory' => [
                'productTaxonomyNodeId' => (string)$product['productCategory']                      
              ],
              // 'images' => array_map(function ($imageUrl) {
              //     return ['src' => $imageUrl];
              // }, $product['images']),
              'metafields' => array_map(function ($metafield) {
                  return [
                      'namespace' => $metafield['namespace'],
                      'key' => $metafield['key'],
                      'value' => $metafield['value'],
                      'type' => $metafield['type']
                  ];
              }, $product['metafields'])
          ]
      ];

      $response = Http::withHeaders([
          'X-Shopify-Access-Token' => $accessToken,
          'Content-Type' => 'application/json',
      ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
          'query' => $query,
          'variables' => $variables
      ]);            
      
      // \Log::info("Response save product shopify ".$product['title']);
      
      $productResult = $response->json();
      // \Log::info("productResult");
      // \Log::info($productResult);
      if (!isset($productResult['data']['productCreate']['product']['id'])) {
        // return ['error' => 'Product creation failed', 'response' => $productResult];
        \Log::info("Product ".$product['title']." creation failed");
        return null;
        // continue;
      }
      \Log::info($productResult['data']['productCreate']['product']['id']. ' - '. $product['title']);
      
      $productId = $productResult['data']['productCreate']['product']['id'];
      return $productId;
    }

    public function imagesMutationGraphQl($product_images, $productId, $store)
    {
      $shopifyUrl = !empty($store) ? $store['store_url'] : env('SHOPIFY_URL');
      $accessToken = !empty($store) ? $store['store_cred'] : env('SHOPIFY_CRED');
      $results = [];
      foreach ($product_images as $images) {
        $imageMutation = <<<'GRAPHQL'
        mutation productCreateMedia($productId: ID!, $media: [CreateMediaInput!]!) {
          productCreateMedia(productId: $productId, media: $media) {
            media {
              alt
              mediaContentType
              status
            }
            mediaUserErrors {
              field
              message
            }
            product {
              id
              title
            }
          }
        }
        GRAPHQL;

        $imageVariables = [
            'media' => array_map(function ($src) {
                  return [
                      'alt' => 'Image',
                      'mediaContentType' => 'IMAGE',
                      'originalSource' => $src
                  ];
            }, $images),
            'productId' => $productId,
        ];

        $imageResponse = Http::withHeaders([
            'X-Shopify-Access-Token' => $accessToken,
            'Content-Type' => 'application/json',
        ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
            'query' => $imageMutation,
            'variables' => $imageVariables
        ]);

        $imageResult = $imageResponse->json();
        // \Log::info("Response save image product shopify ".$product['title']. " image Src: ".$images[0]);
        // \Log::info($imageResponse->body());

        // return $imageResult;
        array_push($results, $imageResult);
      }

      return $results;
    }

    public function addProductToCollection($collections, $productId, $store = [])
    {
      $shopifyUrl = !empty($store) ? $store['store_url'] : env('SHOPIFY_URL');
      $accessToken = !empty($store) ? $store['store_cred'] : env('SHOPIFY_CRED');
      // Step 3: Add Product to Each Collection
      $collections = explode(',', $collections);      
      foreach ($collections as $collectionId) {
        if($collectionId) {
          $addProductMutation = <<<'GRAPHQL'
          mutation collectionAddProductsV2($id: ID!, $productIds: [ID!]!) {
            collectionAddProductsV2(id: $id, productIds: $productIds) {
              job {
                done
                id
              }
              userErrors {
                field
                message
              }
            }
          }
          GRAPHQL;
  
          $addProductVariables = [
              'id' => $collectionId,
              'productIds' => [$productId]
          ];
            
          $addProductResponse = Http::withHeaders([
              'X-Shopify-Access-Token' => $accessToken,
              'Content-Type' => 'application/json',
          ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
              'query' => $addProductMutation,
              'variables' => $addProductVariables
          ]);
  
          $addProductResult = $addProductResponse->json();
          // \Log::info("Done save product to collection shopify ".$product['title']. " productId: ".$productId." collection: ".$collectionId. "");
          \Log::info("add collection to product response");
          \Log::info($addProductResponse);
        }
      }
    }

    public function addProductRankBelowTenThousandsToCollectionBestSellers()
    {
      $stores = [
        [
          'store_name' => 'UsedBookDepot',
          'store_url' => env('USEDBOOKDEPOT_URL'),
          'store_cred' => env('USEDBOOKDEPOT_CRED')
        ], 
        // [
        //   'store_name' => 'CheapBookDepot',
        //   'store_url' => env('SHOPIFY_URL'),
        //   'store_cred' => env('SHOPIFY_CRED')
        // ]        
      ];
      foreach ($stores as $key => $store) {
        $getCollectionBestSellerId = DB::table('shopify_collections')
          ->whereRaw('UPPER(collection_name) = ?', ['BEST SELLERS'])
          ->where('store', $store['store_url'])
          ->select('collection_id', 'collection_name')
          ->first();
        
        /* $getRankBelowTenThousands = DB::select("
          select sst.shopify_id, amazon_table.Title,
            JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].title')) as rank_title,
            JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].rank')) as rank
          from amazon_table
          join shopify_server_temp sst on 
            sst.barcode = amazon_table.ASIN 
          where ClassificationRanks != '[]'
            and JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].rank')) < 10000
          LIMIT 7042 OFFSET 26417;
        "); */

        $getRankBelowTenThousands = DB::select("
          WITH filtered_amazon AS (
            SELECT 
              ASIN,
              SellerSku, 
              JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].rank')) AS rank
            FROM amazon_table
            WHERE ClassificationRanks != '[]'
              and status = 'Active'
              and JSON_UNQUOTE(JSON_EXTRACT(ClassificationRanks, '$[0].rank')) < 10000
          )
          SELECT   
            sst.shopify_id,
            sst.title,
            fa.ASIN,
            fa.SellerSku,
            fa.rank
          FROM shopify_server_temp sst
          JOIN filtered_amazon fa ON fa.SellerSku = sst.sku and fa.ASIN = sst.barcode 
          WHERE 
            fa.rank < 10000
            AND sst.store = ?;
        ", [$store['store_url']]);

        if(!empty($getRankBelowTenThousands)) {
          $shopifyUrl = $store ? $store['store_url'] : env('SHOPIFY_URL');
          $accessToken = $store ? $store['store_cred'] : env('SHOPIFY_CRED'); 
          $failed = 0;
          $success = 0;
          $failedArray = [];
          $total = count($getRankBelowTenThousands); 
          foreach ($getRankBelowTenThousands as $key => $value) {
            # code...
            $addProductMutation = <<<'GRAPHQL'
              mutation collectionAddProductsV2($id: ID!, $productIds: [ID!]!) {
                collectionAddProductsV2(id: $id, productIds: $productIds) {
                  job {
                    done
                    id
                  }
                  userErrors {
                    field
                    message
                  }
                }
              }
              GRAPHQL;

              $addProductVariables = [
                'id' => $getCollectionBestSellerId->collection_id,
                'productIds' => [$value->shopify_id]
              ];

              $addProductResponse = Http::withHeaders([
                  'X-Shopify-Access-Token' => $accessToken,
                  'Content-Type' => 'application/json',
              ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
                  'query' => $addProductMutation,
                  'variables' => $addProductVariables
              ]);

              $addProductResult = $addProductResponse->json();                        
              // Log::info($addProductResult);
              if(array_key_exists('errors', $addProductResult)) {
                if ($addProductResult['errors'][0]['message'] === 'Throttled') {
                    sleep(2); // delay sebelum retry
                }
              }

              if(array_key_exists('data', $addProductResult)) {
                $success = $success + 1;
              } else {              
                $failed = $failed + 1;
                array_push($failedArray, $value->shopify_id);
              }
          }

          return response()->json([
            'message' => 'Result add product to collection',
            'total_product' => $total,
            'success' => $success,
            'failed' => $failed,
            'failedArray' => $failedArray
          ]);
        } else {
          return response()->json(['message' => 'Data rank below 10.000 not found!']);        
        }
      }
    }

    public function addProductHaveRareToCollectionRareBooks()
    {
      $stores = [
        [
          'store_name' => 'UsedBookDepot',
          'store_url' => env('USEDBOOKDEPOT_URL'),
          'store_cred' => env('USEDBOOKDEPOT_CRED')
        ], 
        // [
        //   'store_name' => 'CheapBookDepot',
        //   'store_url' => env('SHOPIFY_URL'),
        //   'store_cred' => env('SHOPIFY_CRED')
        // ]        
      ];
      foreach ($stores as $key => $store) {
        # code...
        $getCollectionBestSellerId = DB::table('shopify_collections')
          ->whereRaw('UPPER(collection_name) = ?', ['RARE BOOKS'])
          ->where('store', $store['store_url'])
          ->select('collection_id', 'collection_name')
          ->first();
        
        $getRankBelowTenThousands = DB::select("
          select sst.shopify_id, sst.title, sst.sku 
          from shopify_server_temp sst 
          where upper(sst.sku) like '%RARE%'
            and store = ?
        ", [$store['store_url']]);
        
  
        if(!empty($getRankBelowTenThousands)) {
          $shopifyUrl = $store ? $store['store_url'] : env('SHOPIFY_URL');
          $accessToken = $store ? $store['store_cred'] : env('SHOPIFY_CRED');        
          $failed = 0;
          $success = 0;
          $total = count($getRankBelowTenThousands); 
          foreach ($getRankBelowTenThousands as $key => $value) {
            # code...
            $addProductMutation = <<<'GRAPHQL'
              mutation collectionAddProductsV2($id: ID!, $productIds: [ID!]!) {
                collectionAddProductsV2(id: $id, productIds: $productIds) {
                  job {
                    done
                    id
                  }
                  userErrors {
                    field
                    message
                  }
                }
              }
              GRAPHQL;
  
              $addProductVariables = [
                  'id' => $getCollectionBestSellerId->collection_id,
                  'productIds' => [$value->shopify_id]
              ];
              
                $addProductResponse = Http::withHeaders([
                    'X-Shopify-Access-Token' => $accessToken,
                    'Content-Type' => 'application/json',
                ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
                    'query' => $addProductMutation,
                    'variables' => $addProductVariables
                ]);
  
                $addProductResult = $addProductResponse->json();                        
                
                if(array_key_exists('errors', $addProductResult)) {
                  if ($addProductResult['errors'][0]['message'] === 'Throttled') {
                      sleep(2); // delay sebelum retry
                  }
                }            
  
              if(array_key_exists('data', $addProductResult)) {
                $success = $success + 1;
              } else {              
                $failed = $failed + 1;
              }
          }
  
          return response()->json([
            'message' => 'Result add product to collection',
            'total_product' => $total,
            'success' => $success,
            'failed' => $failed 
          ]);
        } else {
          return response()->json(['message' => 'Data sku have rare not found!']);        
        }
      }
    }

    public function addProductHaveSignToCollectionSignedBooks()
    {
      $stores = [
        [
          'store_name' => 'UsedBookDepot',
          'store_url' => env('USEDBOOKDEPOT_URL'),
          'store_cred' => env('USEDBOOKDEPOT_CRED')
        ], 
        // [
        //   'store_name' => 'CheapBookDepot',
        //   'store_url' => env('SHOPIFY_URL'),
        //   'store_cred' => env('SHOPIFY_CRED')
        // ]        
      ];
      foreach ($stores as $key => $store) {
        # code...
        $getCollectionBestSellerId = DB::table('shopify_collections')
          ->whereRaw('UPPER(collection_name) = ?', ['SIGNED BOOKS'])
          ->where('store', $store['store_url'])
          ->select('collection_id', 'collection_name')
          ->first();
        
        $getRankBelowTenThousands = DB::select("
          select sst.shopify_id, sst.title, sst.sku 
          from shopify_server_temp sst 
          where upper(sst.sku) like '%SIGN%'
            and store = ?
        ", [$store['store_url']]);
        
  
        if(!empty($getRankBelowTenThousands)) {
          $shopifyUrl = $store ? $store['store_url'] : env('SHOPIFY_URL');
          $accessToken = $store ? $store['store_cred'] : env('SHOPIFY_CRED');       
          $failed = 0;
          $success = 0;
  
          $collectionId = $getCollectionBestSellerId->collection_id;
  
          // Extract only shopify_id from results
          $allProductIds = collect($getRankBelowTenThousands)->pluck('shopify_id');
  
          // Chunk into max 250 per API call
          $chunks = $allProductIds->chunk(250);
  
          $addProductMutation = <<<'GRAPHQL'
          mutation collectionAddProductsV2($id: ID!, $productIds: [ID!]!) {
            collectionAddProductsV2(id: $id, productIds: $productIds) {
              job {
                done
                id
              }
              userErrors {
                field
                message
              }
            }
          }
          GRAPHQL;
  
          foreach ($chunks as $chunk) {
            $addProductVariables = [
                'id' => $collectionId,
                'productIds' => $chunk->values()->all()
            ];
  
            $addProductResponse = Http::withHeaders([
                'X-Shopify-Access-Token' => $accessToken,
                'Content-Type' => 'application/json',
            ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
                'query' => $addProductMutation,
                'variables' => $addProductVariables
            ]);
  
            $result = $addProductResponse->json();
  
            if (!empty($result['data']['collectionAddProductsV2']['userErrors'])) {
                $failed++;
                // Log::error('Add to collection failed', ['errors' => $result['data']['collectionAddProductsV2']['userErrors']]);
            } else {
                $success++;
                // Log::info('Chunk added successfully', ['jobId' => $result['data']['collectionAddProductsV2']['job']['id'] ?? null]);
            }
  
            sleep(1);
          }
  
          return response()->json([
              'message' => 'Completed adding products to collection',
              'chunks_success' => $success,
              'chunks_failed' => $failed,
              'total_products' => count($allProductIds)
          ]);
  
        } else {
          return response()->json(['message' => 'Data sku have sign not found!']);        
        }
      }
    }

    public function sendProductToAllShopify()
    {
      $stores = [
        [
          'store_short_name' => 'ubd',
          'store_name' => 'UsedBookDepot',
          'store_url' => env('USEDBOOKDEPOT_URL'),
          'store_cred' => env('USEDBOOKDEPOT_CRED')
        ], 
        [
          'store_short_name' => 'cbd',
          'store_name' => 'CheapBookDepot',
          'store_url' => env('SHOPIFY_URL'),
          'store_cred' => env('SHOPIFY_CRED')
        ]        
      ];

      $responses = [];
      foreach ($stores as $key => $store) {
        # code...        
        $convertAmazonToShopify = app(AmazonController::class)->convertAmazonToShopify($store['store_name']);            
            
        array_push($responses, [          
          [
            'store' => $store['store_name'],
            'convert_response' => $convertAmazonToShopify['message'],
            'convert_count' => $convertAmazonToShopify['count'],                
          ]
        ]);
        
        Log::info("Responses Convert Amazon To Shopify");
        Log::info($responses);
        $location = $this->locationShopify($store);
        Log::info("location");
        Log::info($location);
        $getProductTaxonomyNodes = DB::table('product_taxonomy_shopify')->select('taxonomy_id', 'name')->get()->toArray();
        Log::info("getProductTaxonomyNodes");        
        // $this->getAllCollectionsAndProductsShopify($store['store_short_name']);
        // Log::info("getAllCollectionsAndProductsShopify");   
        
        Log::info("getAllShopifyProducts");  
        $getAllShopifyProducts = DB::table('shopify_server_temp')
        ->select('sku', 'barcode', 'variant_id', 'inventory_item_id')
        ->where('store', $store['store_url'])
        ->get();      
        $getAllShopifyProductsMap = $getAllShopifyProducts->keyBy(function ($item) {
            return $item->sku . '|' . $item->barcode;
        });
        // $getAllShopifyProducts = DB::table('shopify_server_temp')->select('sku', 'barcode', 'variant_id', 'inventory_item_id')->where('store', $store['store_url'])->get();  
        
        Log::info("Shopify Update");
        // comment old code
        /* ShopifyUpdate::where('vendor', $store['store_name'])->where('synced', 0)->chunk(1000, function ($productsChunk) use ($store, $responses, $location, $getProductTaxonomyNodes, $getAllShopifyProductsMap) {
          Log::info("On product chunks");          
          if(!empty($productsChunk)) {          
            $arr_products = [];
            foreach ($productsChunk as $key => $product) {
              # code...
              // $arr_images = [];
              // $images = json_decode($product->images);            
              // if($images) {
              //   foreach ($images as $img) {
              //     # code...
              //     array_push($arr_images, [$img->link]);
              //   }
              // }
              $arr_images = collect(json_decode($product->images, true))
              ->pluck('link')
              ->map(fn($link) => [$link])
              ->all();
              
              $vendor = $product->vendor;   
              $taxonomyid = 'gid://shopify/ProductTaxonomyNode/4134';
              $taxonomyname = 'Books';
              $highestSimilarity = 0;
              foreach ($getProductTaxonomyNodes as $key => $category) {
                # code...
                if (stripos($product->category, $category->name) !== false || stripos($category->name, $product->category) !== false) {
                    // $highestSimilarity = $percent;
                    $taxonomyid = $category->taxonomy_id;
                    $taxonomyname = $category->name;
                }
              }     
              
              $inventoryItemId = null;
              $variantId = null;
              $key = $product->seller_sku . '|' . $product->barcode;
              $match = $getAllShopifyProductsMap->get($key);

              if ($match) {
                  $inventoryItemId = $match->inventory_item_id;
                  $variantId = $match->variant_id;
              }
  
              array_push($arr_products, [
                'id' => $product->id,
                'title' => $product->title,
                'handle' => str_replace([' '],['-'], strtolower($product->title)),
                'descriptionHtml' => $product->description,
                'vendor' => $vendor,
                'productType' => $product->product_type,
                'collections' => $this->extractTags($product->collections),
                'tags' => $this->extractTags($product->tags),
                'variants' => [
                    [
                        'title' => 'Default Variant', 
                        'price' => $product->price,
                        'sku' => $product->seller_sku,
                        'barcode' => $product->barcode,
                        'locationId' => $location['id'],
                        'quantity' => $product->qty,
                        'weight' => $product->weight,
                    ],
                ],
                'metafields' => [
                    [
                        'namespace' => 'global',
                        'key' => 'description',
                        'value' => $product->description,
                        'type' => 'multi_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'title',
                        'value' => $product->metafield_title,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'edition',
                        'value' => $product->metafield_edition,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'materialtype',
                        'value' => $product->metafield_material_type,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'format',
                        'value' => $product->metafield_format,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'condition',
                        'value' => $product->metafield_condition,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'publisher',
                        'value' => $product->metafield_publisher,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'custom',
                        'key' => 'publication_date',
                        'value' => $product->metafield_publication_date,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'languange',
                        'value' => explode(',',$product->metafield_languange)[0],
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'length',
                        'value' => $product->metafield_print_length,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'isbn13',
                        'value' => $product->metafield_isbn13,
                        'type' => 'single_line_text_field'
                    ],
                    [
                        'namespace' => 'global',
                        'key' => 'isbn10',
                        'value' => $product->metafield_isbn10,
                        'type' => 'single_line_text_field'
                    ],
                ],
                'images' => $arr_images,
                'productCategory' => $taxonomyid,
                'update_or_create' => $product->update_or_create,
                'inventoryItemId' => $inventoryItemId,
                'variantId' => $variantId,
              ]);            
            }
            
            $results = [];
            Log::info("On Process Shopify Store Job");
            foreach ($arr_products as $key => $arr_product) {            
              # code...            
              ProcessShopifyStoreJob::dispatch($arr_product, $store);
            }
  
            array_push($responses[0], ['sendProductToShopifyJob' => 'start']);
          }
        }); */        
        // ProcessShopifyStoreJob::dispatch($store);
        ShopifyUpdate::where('vendor', $store['store_name'])->where('update_or_create', 'update')->where('synced', 0)->chunk(1000, function($productChunks) use ($store, $responses, $location, $getAllShopifyProductsMap) {
          Log::info("On product chunks Update");          
          if(!empty($productChunks)) {                        
            $chunks = array_chunk($productChunks->toArray(), 9);
            
            foreach ($chunks as $chunk) {              
              ShopifyUpdateJob::dispatch($chunk, $store, $location, $getAllShopifyProductsMap);
            }
          }
        });

        // ShopifyUpdate::where('vendor', $store['store_name'])->where('update_or_create', 'create')->where('synced', 0)->chunk(1000, function ($productsChunk) use ($store, $responses, $location, $getProductTaxonomyNodes, $getAllShopifyProductsMap) {
        //   Log::info("On product chunks Create");          
        //   if(!empty($productsChunk)) {          
        //     $arr_products = [];
        //     foreach ($productsChunk as $key => $product) {
        //       # code...
        //       // $arr_images = [];
        //       // $images = json_decode($product->images);            
        //       // if($images) {
        //       //   foreach ($images as $img) {
        //       //     # code...
        //       //     array_push($arr_images, [$img->link]);
        //       //   }
        //       // }
        //       $arr_images = collect(json_decode($product->images, true))
        //       ->pluck('link')
        //       ->map(fn($link) => [$link])
        //       ->all();
              
        //       $vendor = $product->vendor;   
        //       $taxonomyid = 'gid://shopify/ProductTaxonomyNode/4134';
        //       $taxonomyname = 'Books';
        //       $highestSimilarity = 0;
        //       foreach ($getProductTaxonomyNodes as $key => $category) {
        //         # code...
        //         if (stripos($product->category, $category->name) !== false || stripos($category->name, $product->category) !== false) {
        //             // $highestSimilarity = $percent;
        //             $taxonomyid = $category->taxonomy_id;
        //             $taxonomyname = $category->name;
        //         }
        //       }     
              
        //       $inventoryItemId = null;
        //       $variantId = null;
        //       $key = $product->seller_sku . '|' . $product->barcode;
        //       $match = $getAllShopifyProductsMap->get($key);

        //       if ($match) {
        //           $inventoryItemId = $match->inventory_item_id;
        //           $variantId = $match->variant_id;
        //       }
  
        //       array_push($arr_products, [
        //         'id' => $product->id,
        //         'title' => $product->title,
        //         'handle' => str_replace([' '],['-'], strtolower($product->title)),
        //         'descriptionHtml' => $product->description,
        //         'vendor' => $vendor,
        //         'productType' => $product->product_type,
        //         'collections' => $this->extractTags($product->collections),
        //         'tags' => $this->extractTags($product->tags),
        //         'variants' => [
        //             [
        //                 'title' => 'Default Variant', 
        //                 'price' => $product->price,
        //                 'sku' => $product->seller_sku,
        //                 'barcode' => $product->barcode,
        //                 'locationId' => $location['id'],
        //                 'quantity' => $product->qty,
        //                 'weight' => $product->weight,
        //             ],
        //         ],
        //         'metafields' => [
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'description',
        //                 'value' => $product->description,
        //                 'type' => 'multi_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'title',
        //                 'value' => $product->metafield_title,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'edition',
        //                 'value' => $product->metafield_edition,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'materialtype',
        //                 'value' => $product->metafield_material_type,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'format',
        //                 'value' => $product->metafield_format,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'condition',
        //                 'value' => $product->metafield_condition,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'publisher',
        //                 'value' => $product->metafield_publisher,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'custom',
        //                 'key' => 'publication_date',
        //                 'value' => $product->metafield_publication_date,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'languange',
        //                 'value' => explode(',',$product->metafield_languange)[0],
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'length',
        //                 'value' => $product->metafield_print_length,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'isbn13',
        //                 'value' => $product->metafield_isbn13,
        //                 'type' => 'single_line_text_field'
        //             ],
        //             [
        //                 'namespace' => 'global',
        //                 'key' => 'isbn10',
        //                 'value' => $product->metafield_isbn10,
        //                 'type' => 'single_line_text_field'
        //             ],
        //         ],
        //         'images' => $arr_images,
        //         'productCategory' => $taxonomyid,
        //         'update_or_create' => $product->update_or_create,
        //         'inventoryItemId' => $inventoryItemId,
        //         'variantId' => $variantId,
        //       ]);            
        //     }
            
        //     $results = [];
        //     Log::info("On Process Shopify Store Job");
        //     foreach ($arr_products as $key => $arr_product) {            
        //       # code...            
        //       ProcessShopifyStoreJob::dispatch($arr_product, $store);
        //     }
  
        //     array_push($responses[0], ['sendProductToShopifyJob' => 'start']);
        //   }
        // });
      }


      return $responses;
    }

    public function createNewCollection($store, $collectionTitle)
    {
      $accessToken = !empty($store) ? $store['store_cred'] : env("SHOPIFY_CRED");
      $shopifyUrl = !empty($store) ? $store['store_url'] : env("SHOPIFY_URL");
      // Step 2.2: Create new collection
      $createCollectionMutation = <<<'GRAPHQL'
      mutation collectionCreate($input: CollectionInput!) {
        collectionCreate(input: $input) {
          collection {
            id
            title
          }
          userErrors {
            field
            message
          }
        }
      }
      GRAPHQL;
      
      $createCollectionVariables = ['input' => ['title' => $collectionTitle]];

      $createCollectionResponse = Http::withHeaders([
          'X-Shopify-Access-Token' => $accessToken,
          'Content-Type' => 'application/json',
      ])->post("{$shopifyUrl}/admin/api/2024-01/graphql.json", [
          'query' => $createCollectionMutation,
          'variables' => $createCollectionVariables
      ]);

      $createCollectionResult = $createCollectionResponse->json();
      // \Log::info("Response save collection product shopify ".$product['title']. " collection: ".$collectionTitle);
      \Log::info("Create collection response");
      \Log::info($createCollectionResponse->body());

      if (isset($createCollectionResult['data']['collectionCreate']['collection']['id'])) {
        return $createCollectionResult['data']['collectionCreate']['collection']['id'];
      } else {
        return null;
      }
    }

    public function getAllCollectionsAndProductsShopify($store)
    {
      if($store == 'ubd') {
        $store_array = [
          'store_name' => 'UsedBookDepot',
          'store_url' => env('USEDBOOKDEPOT_URL'),
          'store_cred' => env('USEDBOOKDEPOT_CRED')
        ]; 
      } else {
        $store_array = [
          'store_name' => 'CheapBookDepot',
          'store_url' => env('SHOPIFY_URL'),
          'store_cred' => env('SHOPIFY_CRED')
        ];        
      }   
      
      // $this->getAllShopifyCollections($store_array);
      $this->getAllShopifyProducts($store_array);

      return response()->json(['message' => 'Get All Shopify Collections And Products Successfully']);
    }

    public function updateHandleProductShopify($store)
    {
      if($store == 'ubd') {
        $store_array = [
          'store_name' => 'UsedBookDepot',
          'store_url' => env('USEDBOOKDEPOT_URL'),
          'store_cred' => env('USEDBOOKDEPOT_CRED')
        ]; 
      } else {
        $store_array = [
          'store_name' => 'CheapBookDepot',
          'store_url' => env('SHOPIFY_URL'),
          'store_cred' => env('SHOPIFY_CRED')
        ];        
      }   
      
      $products = DB::table('shopify_server_temp')
        ->select('shopify_id', 'title', 'id')
        ->where('store', $store_array['store_url'])
        // ->where('id', '>', '254254')
        // ->limit(5)
        ->orderBy('id')
        ->get();
      
      if(!empty($products)) {
        $responses = [];
        $success = 0;
        $failed = 0;
        foreach ($products as $key => $product) {
          # code...
          // Log::info("Product number: ".($key+1). ', id: '.$product->id);
          $handle = str_replace([' '],['-'], strtolower($product->title));                    
          UpdateHandleJob::dispatch(($key+1), $product->id, $product->shopify_id, $product->title, $handle, $store_array)->onQueue('update-handle');          
          // $response = $this->updateHandleShopify($product->shopify_id, $handle, $store_array);          
          
        }
        return response()->json([
          'message' => 'Processing Update Handle Jobs'
        ]);
      } else {
        return response()->json(['message' => 'Shopify Products Not Found']);
      }
    }

    public function updateHandleShopify($productId, $handle, $store) 
    {
      $query = <<<'GRAPHQL'
      mutation productUpdate($input: ProductInput!) {
          productUpdate(input: $input) {
              product {
                  id
                  handle
              }
              userErrors {
                  field
                  message
              }
          }
      }
      GRAPHQL;

      $variables = [
          'input' => [
              'id' => $productId,
              'handle' => (string) $handle,
          ]
      ];

      return $this->makeGraphQLRequest($query, $variables, $store);
    }

    public function testGraphQlBulkPrice(Request $request, $store) {
      if($store == 'ubd') {
        $store_array = [
          'store_name' => 'UsedBookDepot',
          'store_url' => env('USEDBOOKDEPOT_URL'),
          'store_cred' => env('USEDBOOKDEPOT_CRED')
        ]; 
      } else {
        $store_array = [
          'store_name' => 'CheapBookDepot',
          'store_url' => env('SHOPIFY_URL'),
          'store_cred' => env('SHOPIFY_CRED')
        ];        
      }   
      $data = [
        [
          // 'id' => 'gid://shopify/ProductVariant/45909284356259',
          // 'price' => '65.45',
          // 'price' => '3.99'
          'id' => 'gid://shopify/InventoryItem/48000535920803',
          // 'qty' => 2,
          'qty' => 3,
        ],
        [
          // 'id' => 'gid://shopify/ProductVariant/45909284389027',
          // 'price' => '83.30'
          // 'price' => '3.99'
          'id' => 'gid://shopify/InventoryItem/48000535953571',
          // 'qty' => 1
          'qty' => 2
        ],
        [
          // 'id' => 'gid://shopify/ProductVariant/45909284651171',
          // 'price' => '33.41'
          // 'price' => '3.99'
          'id' => 'gid://shopify/InventoryItem/48000536215715',
          'qty' => 1
        ],
        [
          // 'id' => 'gid://shopify/ProductVariant/45909284683939',
          // 'price' => '19.23'
          'id' => 'gid://shopify/InventoryItem/48000536248483',
          'qty' => 1
        ],
        [
          // 'id' => 'gid://shopify/ProductVariant/45909284716707',
          // 'price' => '74.80'
          'id' => 'gid://shopify/InventoryItem/48000536281251',
          'qty' => 0
        ],
        [
          // 'id' => 'gid://shopify/ProductVariant/45909284749475',
          // 'price' => '41.65'
          'id' => 'gid://shopify/InventoryItem/48000536314019',
          'qty' => 0
        ],
        [
          // 'id' => 'gid://shopify/ProductVariant/45909285011619',
          // 'price' => '83.30'
          'id' => 'gid://shopify/InventoryItem/48000536576163',
          'qty' => 1
        ],
        [
          // 'id' => 'gid://shopify/ProductVariant/45909285044387',
          // 'price' => '112.88'
          'id' => 'gid://shopify/InventoryItem/48000536608931',
          'qty' => 1
        ],
        [
          // 'id' => 'gid://shopify/ProductVariant/45909285077155',
          // 'price' => '40.80'
          'id' => 'gid://shopify/InventoryItem/48000536641699',
          'qty' => 1
        ],        
      ];

      $mutations = [];
      $location = $this->locationShopify($store_array);
      foreach ($data as $key => $product) {
          $gid = $product['id']; // Make sure it's in GID format
          // $price = $product['price'];
          $qty = $product['qty'];

          // $mutations[] = <<<GRAPHQL
          // v{$key}: productVariantUpdate(input: {id: "{$gid}", price: "{$price}"}) {
          //     productVariant {
          //         id
          //         price
          //     }
          //     userErrors {
          //         field
          //         message
          //     }
          // }
          // GRAPHQL;
          // $setQuantitiesString = '[{inventoryItemId: "' . $gid . '", locationId: "' . $location . '", quantity: ' . (int) $qty . '}]';
          $mutation = <<<GRAPHQL
            v{$key}: inventorySetOnHandQuantities(input: {
              reason: "correction",
              setQuantities: [{
                inventoryItemId: "{$gid}",
                locationId: "{$location}",
                quantity: {$qty}
              }]
            }) {
              inventoryAdjustmentGroup {
                createdAt
                reason
                changes {
                  delta
                  name
                }
              }
              userErrors {
                field
                message
              }
            }
            GRAPHQL;

          $mutations[] = $mutation;
      }

      $mutationBody = implode("\n", $mutations);

      // Wrap with full mutation block
      $query = <<<GRAPHQL
      mutation {
          {$mutationBody}
      }
      GRAPHQL;
      Log::info($query);
      $response = $this->makeGraphQLRequest($query, null, $store_array);
      // sleep(1);
      // $response2 = $this->makeGraphQLRequest($query, null, $store_array);

      return [
        $response,
        // $response2
      ];
    }

    public function testGraphQlBulk(Request $request, $store)
    {
        // Determine store credentials
        if ($store === 'ubd') {
            $store_array = [
                'store_name' => 'UsedBookDepot',
                'store_url' => env('USEDBOOKDEPOT_URL'),
                'store_cred' => env('USEDBOOKDEPOT_CRED')
            ];
        } else {
            $store_array = [
                'store_name' => 'CheapBookDepot',
                'store_url' => env('SHOPIFY_URL'),
                'store_cred' => env('SHOPIFY_CRED')
            ];
        }

        // Sample inventory data
        $data = [
            ['id' => 'gid://shopify/InventoryItem/48000535920803', 'qty' => 3],
            ['id' => 'gid://shopify/InventoryItem/48000535953571', 'qty' => 3],
            ['id' => 'gid://shopify/InventoryItem/48000536215715', 'qty' => 3], // 1
            ['id' => 'gid://shopify/InventoryItem/48000536248483', 'qty' => 3], // 1
            ['id' => 'gid://shopify/InventoryItem/48000536281251', 'qty' => 3],
            ['id' => 'gid://shopify/InventoryItem/48000536314019', 'qty' => 3],
            ['id' => 'gid://shopify/InventoryItem/48000536576163', 'qty' => 3],
            ['id' => 'gid://shopify/InventoryItem/48000536608931', 'qty' => 3],
            ['id' => 'gid://shopify/InventoryItem/48000536641699', 'qty' => 3],
        ];

        // Get location ID
        $location = $this->locationShopify($store_array);
        
        if (!$location) {
            return response()->json(['error' => 'Shopify location ID not found'], 500);
        }

        $chunks = array_chunk($data, 10); // Max 10 per request to stay within API budget
        $responses = [];

        foreach ($chunks as $batchIndex => $batch) {
            $mutations = [];

            foreach ($batch as $key => $product) {
                $gid = $product['id'];
                $qty = (int) $product['qty'];

                $mutations[] = <<<GRAPHQL
            v{$key}: inventorySetOnHandQuantities(input: {
              reason: "correction",
              setQuantities: [{
                inventoryItemId: "{$gid}",
                locationId: "{$location['id']}",
                quantity: {$qty}
              }]
            }) {
              inventoryAdjustmentGroup {
                createdAt
                reason
                changes {
                  delta
                  name
                }
              }
              userErrors {
                field
                message
              }
            }
            GRAPHQL;
                    }

                    $mutationBody = implode("\n", $mutations);

                    $query = <<<GRAPHQL
            mutation {
                {$mutationBody}
            }
            GRAPHQL;
            
            Log::info("GraphQL Mutation Batch {$batchIndex}:");
            Log::info($query);

            $response = $this->makeGraphQLRequest($query, null, $store_array);

            if (isset($response['errors'])) {
                Log::error("GraphQL Errors:", $response['errors']);
            }

            $responses[] = $response;

            // Optional: pause to avoid hitting rate limit
            sleep(1);
        }

        return $responses;
    }

    public function updatePrice15Percent(Request $request, $store) 
    {
        if ($store == 'ubd') {
            $store_array = [
                'store_name' => 'UsedBookDepot',
                'store_url' => env('USEDBOOKDEPOT_URL'),
                'store_cred' => env('USEDBOOKDEPOT_CRED')
            ]; 
        } else {
            $store_array = [
                'store_name' => 'CheapBookDepot',
                'store_url' => env('SHOPIFY_URL'),
                'store_cred' => env('SHOPIFY_CRED')
            ];        
        }   

        $data = DB::table('shopify_server_temp')->where('store', $store_array['store_url'])->get();
        

        // Chunk into groups of 8
        $chunks = $data->chunk(8);
        $responses = [];

        foreach ($chunks as $chunkIndex => $chunk) {
            $mutations = [];
            
            UpdatePrice15PercentShopifyJobs::dispatch($chunk->toArray(), $store_array);            
        }

        return response()->json(['msg' => "Processing Update 15% less to shopify"]);
    }    
  }


  
