<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use App\Vhai;
use OpenAI;
use OpenAI\Client;


class VhAiController extends Controller
{
    public function index()
    {
        return view('vhai.index');
    }

    public function ask(Request $request)
    {
        $prompt = $request->input('prompt'); // -> prompt from the user
        $mode = $request->input('mode');
        

        //if prompt already exists in the database, we should return the answer directly
        //and we need to decide what will be the matching criteria 
        //to decide if a similar prompt exists in the database

        // $vhai = Vhai::where('prompt', $prompt)->first();
        // if ($vhai) { // -> if prompt exists in the database
        //     //response logic here will be here

        //     return $vhai->answer;
        // }


        //if prompt does not exist in the database

        //response logic here will be here
        //for e.g. if the promtpt is about creating a report,
        //then we should check if the report is already created and return the report
        //if the report is not created, then we should give related report structure to openai and ask about the query
        //then we should create a view for the report by using the query and return the report
        //after that we should ask the user if the report is correct or not

        /*
        $answer = $this->askToVhAi($prompt);
        Vhai::create([
            'prompt' => $prompt,
            'answer' => $answer,
            'date' => now(),
        ]);
        */

        //$answer = $this->findClosestMatch2($prompt);
        //$answer = $this->generateEmbeddings();


        if ($mode == "Report Mode") {
            $answer = $this->getClosestMatch($prompt);
            //$prompt is $bestMatch->id . ' - ' . $bestMatch->answer; we need to extract the id from the prompt
            $id = explode(" - ", $answer)[0];
            $answer = explode(" - ", $answer)[1];
        } else {
            $answer = $this->askToVhAi2($prompt);
            return response()->json(['status' => 'success', 'data' => 'chat', 'prompt' => $prompt, 'answer' => $answer]);
        }


        //$promptType = $this->classifyUserPrompt($prompt);

        // if ($promptType == "data_request") {
        //     $answer = $this->getClosestMatch($prompt);
        // } else {
        //     $answer = $this->askToVhAi2($prompt);
        //     return response()->json(['status' => 'success', 'data' => 'chat', 'prompt' => $prompt, 'answer' => $answer]);
        // }

        try {
            //We need to Sanitize the Query
            //We need to check if the query is a select query
            //We need to check if the query is a valid query
            //We need to check if the query is a safe query
            //We need to check if the query is a read-only query
            //for e.g. 
            //if (!preg_match('/^SELECT /i', trim($query))){
            //eturn response()->json(['error' => 'Only SELECT queries are allowed.']);
            //}


            try {
                $results = DB::select($answer);
                return response()->json(['status' => 'success', 'data' => $results, 'prompt' => $prompt, 'answer' => $answer, 'id' => $id]);
            } catch (\Exception $e) {
                return response()->json(['error' => 'Invalid query or database error: ' . $e->getMessage()]);
            }
        } catch (\Exception $e) {
            return response()->json(['error' => 'Invalid query or database error: ' . $e->getMessage()]);
        }

        return $answer;


        //return $this->askToVhAi($prompt);
    }

    function classifyUserPrompt($prompt)
    {
        $dataKeywords = [
            'show',
            'fetch',
            'retrieve',
            'get',
            'list',
            'find',
            'display',
            'load',
            'extract',
            'pull',
            'return',
            'query',
            'table',
            'record',
            'row',
            'column',
            'database',
            'schema',
            'dataset',
            'entry',
            'index',
            'values',
            'report',
            'summary',
            'statistics',
            'analytics',
            'trend',
            'chart',
            'graph',
            'insights',
            'export',
            'filter',
            'sort',
            'order by',
            'group by',
            'where',
            'condition',
            'between',
            'greater than',
            'less than',
            'sales',
            'revenue',
            'customer',
            'transaction',
            'order',
            'inventory',
            'stock',
            'price',
            'profit',
            'loss',
            'latest',
            'yesterday',
            'today',
            'last week',
            'last month',
            'this year',
            'past',
            'since',
            'before',
            'after',
            'count',
            'sum',
            'average',
            'max',
            'min',
            'total',
            'percentage',
            'rate',
            'compare',
            'growth',
            'sync',
            'update',
            'refresh',
            'fetch from',
            'connect to',
            'import',
            'export',
            'API',
            'endpoint'
        ];


        $promptLower = strtolower($prompt);

        foreach ($dataKeywords as $word) {
            if (strpos($promptLower, $word) !== false) {
                return "data_request";
            } else {
                return "chat_request";
            }
        }

        return "unknown"; // Default if it doesn’t match
    }

    function getClosestMatch($userPrompt)
    {
        //if prompt exists in the database, return the answer directly
        // $vhai = Vhai::where('prompt', $userPrompt)->first();
        // if ($vhai) {
        //     return $vhai->answer;
        // }


        $client = OpenAI::client(env('OPENAI_API_KEY'));
        $response = $client->embeddings()->create([
            'model' => 'text-embedding-ada-002',
            'input' => $userPrompt,
        ]);
        $userEmbedding = $response['data'][0]['embedding'];
        return $this->findMostSimilar($userEmbedding);
    }

    function findMostSimilar($userEmbedding)
    {
        $prompts = DB::table('vhai')->select('id', 'prompt', 'answer', 'embedding')->get();
        $bestMatch = null;
        $highestSimilarity = -1;

        foreach ($prompts as $prompt) {
            $embedding = json_decode($prompt->embedding, true);
            $similarity = $this->cosineSimilarity($userEmbedding, $embedding);

            if ($similarity > $highestSimilarity) {
                $highestSimilarity = $similarity;
                $bestMatch = $prompt;
            }
        }

        //return $bestMatch->prompt . ' - ' . $bestMatch->answer;
        //I want to return answer and id
        return $bestMatch->id . ' - ' . $bestMatch->answer; 
        //return $bestMatch->answer;
    }

    function cosineSimilarity($vecA, $vecB)
    {
        $dotProduct = 0.0;
        $normA = 0.0;
        $normB = 0.0;

        for ($i = 0; $i < count($vecA); $i++) {
            $dotProduct += $vecA[$i] * $vecB[$i];
            $normA += pow($vecA[$i], 2);
            $normB += pow($vecB[$i], 2);
        }

        return $dotProduct / (sqrt($normA) * sqrt($normB));
    }

    private function generateEmbeddings()
    {
        $client = OpenAI::client(env('OPENAI_API_KEY'));

        $prompts = DB::table('vhai')->whereNull('embedding')->get();

        foreach ($prompts as $prompt) {
            $response = $client->embeddings()->create([
                'model' => 'text-embedding-ada-002',
                'input' => $prompt->prompt,
            ]);

            $embedding = json_encode($response['data'][0]['embedding']);

            DB::table('vhai')
                ->where('id', $prompt->id)
                ->update(['embedding' => $embedding]);
        }

        //$this->info('Embeddings generated successfully.');
        return 'Embeddings generated successfully.';
    }

    private function findClosestMatch($prompt)
    {
        $prompts = DB::table('vhai')->select('id', 'prompt', 'answer')->get();

        $bestMatch = null;
        $bestScore = 0;

        foreach ($prompts as $entry) {
            similar_text($prompt, $entry->prompt, $percent);
            if ($percent > $bestScore) {
                $bestScore = $percent;
                $bestMatch = $entry;
            }
        }

        if ($bestMatch) {
            $answer = $bestMatch->id . ' - ' . $bestMatch->answer . ' - ' . $bestMatch->prompt;
            return $answer;
            //return $bestMatch->answer;
            //return $bestMatch->prompt;
        } else {
            return "No relevant answer found.";
        }
    }

    private function findClosestMatch2($prompt)
    {
        $closestMatch = DB::table('vhai')
            ->select('id', 'prompt', 'answer', DB::raw("MATCH(prompt) AGAINST(? IN NATURAL LANGUAGE MODE) AS relevance"))
            ->whereRaw("MATCH(prompt) AGAINST(? IN NATURAL LANGUAGE MODE)", [$prompt, $prompt])
            ->orderByDesc('relevance')
            ->first();

        if ($closestMatch) {
            //return $closestMatch->answer;
            return $closestMatch->id . ' - ' . $closestMatch->answer . ' - ' . $closestMatch->prompt;
        } else {
            return "No relevant answer found.";
        }
    }

    private function calculateSimilarity($str1, $str2)
    {
        if ($str1 === '' && $str2 === '') {
            return 100;
        }

        $str1 = strtolower($str1);
        $str2 = strtolower($str2);

        $maxScore = 0;
        $minLength = min(strlen($str1), strlen($str2));

        for ($i = 0; $i < $minLength; $i++) {
            for ($j = 0; $j < $minLength; $j++) {
                if ($str1[$i] !== $str2[$j]) {
                    break;
                }

                $currentMatch = 0;
                while (isset($str1[$i + $currentMatch]) && isset($str2[$j + $currentMatch])) {
                    if ($str1[$i + $currentMatch] === $str2[$j + $currentMatch]) {
                        $currentMatch++;
                    } else {
                        break;
                    }
                }

                if ($currentMatch > 0) {
                    $maxScore = max($maxScore, $currentMatch * 50);
                }
            }
        }

        return min($maxScore, 100);
    }

    private function askToVhAi($prompt)
    {
        //if user prompt is about database, then we should provide the database schema to openai
        //and ask for the query
        //please prepare the database schema and uncomment the following line

        $schema = "database name: ultimate_db
        tables:
        brands(id, business_id, name, description, created_by, deleted_at, created_at, updated_at, big_commerce_id, woo_commerce_id, cheap_book_id, used_book_id)
        categories(id, name, business_id, short_code, parent_id, created_by, category_type, description, slug, deleted_at, created_at, updated_at, big_commerce_id, woo_commerce_id, quickbooks_id, cheap_book_id, used_book_id)
        products(id, name, business_id, `type`, unit_id, secondary_unit_id, sub_unit_ids, brand_id, category_id, sub_category_id, tax, tax_type, enable_stock, alert_quantity, sku, barcode_type, expiry_period, expiry_period_type, enable_sr_no, weight, product_custom_field1, product_custom_field2, product_custom_field3, product_custom_field4, image, product_description, created_by, preparation_time_in_minutes, warranty_id, is_inactive, not_for_selling, created_at, updated_at, shopify_id, barcode, big_commerce_id, woo_commerce_id, walmart_id, quickbooks_id, income_account_ref, amazon_id, amazon_name, amazon_asin, amazon_seller_id, cheap_book_shopify_id, cheap_book_barcode, amazon_categories)
        product_locations(product_id, location_id)
        product_variations(id, variation_template_id, name, product_id, is_dummy, created_at, updated_at)
        cash_denominations(id, business_id, amount, total_count, model_type, model_id, created_at, updated_at)
        cash_drawer_openings(id, date_time, business_id, created_by, reason, deleted_at, created_at, updated_at)
        cash_register_transactions(id, cash_register_id, amount, pay_method, `type`, transaction_type, transaction_id, created_at, updated_at, cash_register_list_id)
        cash_registers(id, business_id, location_id, user_id, status, closed_at, closing_amount, total_card_slips, total_cheques, denominations, closing_note, created_at, updated_at, cash_register_list_id, close_by)
        cash_registers_list(id, business_id, location_id, name, created_at, updated_at)
        contacts(id, business_id, `type`, supplier_business_name, name, prefix, first_name, middle_name, last_name, email, contact_id, contact_status, tax_number, city, state, country, address_line_1, address_line_2, zip_code, dob, mobile, landline, alternate_number, pay_term_number, pay_term_type, credit_limit, created_by, converted_by, converted_on, balance, total_rp, total_rp_used, total_rp_expired, is_default, shipping_address, shipping_custom_field_details, is_export, export_custom_field_1, export_custom_field_2, export_custom_field_3, export_custom_field_4, export_custom_field_5, export_custom_field_6, `position`, customer_group_id, crm_source, crm_life_stage, custom_field1, custom_field2, custom_field3, custom_field4, custom_field5, custom_field6, custom_field7, custom_field8, custom_field9, custom_field10, deleted_at, created_at, updated_at, notes)
        customer_groups(id, business_id, name, amount, price_calculation_type, selling_price_group_id, created_by, created_at, updated_at)
        expense(id, `date`, transaction_type, num, posting, name, memo, account, split, balance, amount, id_vendor, deleted_at, request_body, private_note, sync_token, due_date)
        expense_categories(id, name, business_id, code, parent_id, deleted_at, created_at, updated_at)
        purchase_lines(id, transaction_id, product_id, variation_id, quantity, secondary_unit_quantity, pp_without_discount, discount_percent, purchase_price, purchase_price_inc_tax, item_tax, tax_id, purchase_requisition_line_id, purchase_order_line_id, quantity_sold, quantity_adjusted, quantity_returned, po_quantity_purchased, mfg_quantity_used, mfg_date, exp_date, lot_number, sub_unit_id, created_at, updated_at)
        sales_order_history(id, business_id, product_id, transaction_id, created_at, updated_at)
        selling_price_groups(id, name, description, business_id, is_active, deleted_at, created_at, updated_at)
        tax_rates(id, business_id, name, amount, is_tax_group, for_tax_group, created_by, deleted_at, created_at, updated_at)
        ";
        $openAiPrompt = "Based on the following database schema: $schema\nGenerate a MySQL query for the user's request: \"$prompt\".";

        $response = Http::withoutVerifying()
            ->withHeaders([
                'Authorization' => 'Bearer ' . config('openai.api_key'),
                'Content-Type' => 'application/json',
            ])->post('https://api.openai.com/v1/chat/completions', [
                "model" => "gpt-3.5-turbo",
                "messages" => [[
                    "role" => "user",
                    "content" => $openAiPrompt
                ]],
                "max_tokens" => 1000
            ]);
        return $response->json()['choices'][0]['message']['content'];
    }

    private function askToVhAi2($prompt)
    {
        $response = Http::withoutVerifying()
            ->withHeaders([
                'Authorization' => 'Bearer ' . config('openai.api_key'),
                'Content-Type' => 'application/json',
            ])->post('https://api.openai.com/v1/chat/completions', [
                "model" => "gpt-3.5-turbo",
                "messages" => [[
                    "role" => "user",
                    "content" => $prompt
                ]],
                "max_tokens" => 1000
            ]);
        return $response->json()['choices'][0]['message']['content'];
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'prompt' => 'required|string|max:255',
            'answer' => 'required|string',
            'date'   => 'required|date',
        ]);

        $vhai = Vhai::create($validatedData);
        return response()->json(['message' => 'Record added successfully', 'data' => $vhai]);
    }

    public function show($id)
    {
        $vhai = Vhai::find($id);

        if (!$vhai) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        return response()->json($vhai);
    }

    // Update a specific record
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'prompt' => 'sometimes|required|string|max:255',
            'answer' => 'sometimes|required|string',
            'date'   => 'sometimes|required|date',
        ]);

        $vhai = Vhai::find($id);

        if (!$vhai) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $vhai->update($validatedData);
        return response()->json(['message' => 'Record updated successfully', 'data' => $vhai]);
    }

    // Delete a specific record
    public function destroy($id)
    {
        $vhai = Vhai::find($id);

        if (!$vhai) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $vhai->delete();
        return response()->json(['message' => 'Record deleted successfully']);
    }
}
