<?php

namespace App\Http\Controllers;

use App\Brands;
use App\Business;
use App\Category;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\Transaction;
use App\Unit;
use App\Variation;
use App\VariationLocationDetails;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WalmartController extends Controller
{
    //
    public function auth(Request $request)
    {
        $product_locations = array($request->input('product_locations')); 
        if(empty($product_locations)) {
          return response()->json([
            'message' => 'Location must be selected',
            'data' => null
          ]);
        }       
        
        $checkmarks = $request->input('checkmarks');
        if(empty($checkmarks)) {
            return response()->json([
                'message' => 'Please Selected Sync Item First',
                'data' => null
            ]);
        }

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('marketplace_settings')->first();

        $array_empty = [];
        $array_insert = [];

        $marketplace_settings = json_decode($business->marketplace_settings);

        if($marketplace_settings->walmart_api_url && $marketplace_settings->walmart_api_access_token && $marketplace_settings->walmart_api_key && $marketplace_settings->walmart_api_secret) {
          // $SHOPIFY_URL = getenv("SHOPIFY_URL");
          $WALMART_URL = $marketplace_settings->walmart_api_url;
          // $WALMART_CRED = getenv("WALMART_CRED");        
          $WALMART_CRED = $marketplace_settings->walmart_api_access_token;        
          $WALMART_ID = $marketplace_settings->walmart_api_key;        
          $WALMART_KEY = $marketplace_settings->walmart_api_secret;        
        } else {
          return 'Url and Access Token Walmart Not Found';
        }

        try {
            //code...                    
            $get_token = $this->authorization($WALMART_URL, $WALMART_CRED, $WALMART_ID, $WALMART_KEY);            
            if(array_key_exists('access_token', $get_token)) {                    
                $session_token = $get_token['access_token'];
                $products = $this->get_all_items($WALMART_URL, $session_token, $WALMART_ID, $WALMART_KEY, '*');
                if($products['totalItems'] > 0) {
                    $responseSaveProducts = $this->saveProducts($products['ItemResponse'], $product_locations, $array_empty, $checkmarks, $WALMART_URL, $session_token, $WALMART_ID, $WALMART_KEY);
                    array_push($array_insert, $responseSaveProducts);
                    if(array_key_exists('nextCursor', $get_token)) {
                        $products = $this->get_all_items($WALMART_URL, $session_token, $WALMART_ID, $WALMART_KEY, $get_token['nextCursor']);
                        $responseSaveProducts = $this->saveProducts($products['ItemResponse'], $product_locations, $array_empty, $checkmarks, $WALMART_URL, $session_token, $WALMART_ID, $WALMART_KEY);
                        array_push($array_insert, $responseSaveProducts);                        
                    }
                }
            }                

            $body['walmart_checkbox'] = json_encode($checkmarks);
            $business = Business::find($business_id);         
            $business->fill($body);
            $business->save();            
            if(is_array($array_insert)) {
                return response()->json([
                    'message' => 'Recevied Data Success',
                    'data' => $array_insert
                ]);
            } else {        
                return response()->json([
                    'message' => $array_insert,
                    'data' => null
                ]);
            }
        } catch (\Exception $err) {
            //throw $th;
            // dd($err);
            return response()->json([
                'message' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        }
    }

    public static function authorization($url, $auth, $correlation_id, $key_name) 
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url.'/v3/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");

        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = 'Wm_qos.Correlation_id: '. $correlation_id;
        $headers[] = 'Wm_svc.Name: '. $key_name;
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Authorization: ' . $auth;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        return json_decode($result, true);
    }

    public static function get_all_items($url, $token, $correlation_id, $key_name, $next_cursor = '*') 
    {        
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url.'/v3/items?nextCursor='.$next_cursor);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');


        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = 'Wm_sec.Access_token: '.$token;
        $headers[] = 'Wm_qos.Correlation_id: '.$correlation_id;
        $headers[] = 'Wm_svc.Name: '.$key_name;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        return json_decode($result, true);
    }

    public function get_inventory($url, $token, $correlation_id, $key_name, $sku)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url.'/v3/inventory?sku='.$sku);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');


        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = 'Wm_sec.Access_token: '.$token;
        $headers[] = 'Wm_qos.Correlation_id: '.$correlation_id;
        $headers[] = 'Wm_svc.Name: '.$key_name;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        // dd(json_decode($result, true));
        return json_decode($result, true);
    }

    public function saveProducts($products, $product_locations, $arr_empty = [], $checkmarks, $WALMART_URL, $session_token, $WALMART_ID, $WALMART_KEY) 
    {        
      DB::beginTransaction();
      $business_id = request()->session()->get('user.business_id');
      $checkProductLocation = Product::join('variation_location_details as vld', 'vld.product_id', '=', 'products.id')
      ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id')
      ->whereNotNull('products.walmart_id')
      ->select('products.id', 'products.name', 'bl.id as location_id', 'vld.variation_id')
      ->first();
      if(!empty($checkProductLocation) && $checkProductLocation->location_id != $product_locations[0]) {
          $deleteTransactions = DB::select("delete transactions from transactions join products on products.id = transactions.opening_stock_product_id and transactions.location_id = ? where products.walmart_id is not null", [$checkProductLocation->location_id]);                    
          $deleteVariationLocationDetails = DB::select("delete variation_location_details from variation_location_details join products on products.id = variation_location_details.product_id and variation_location_details.location_id = ? where products.walmart_id is not null", [$checkProductLocation->location_id]);                  
          DB::select("delete purchase_lines from purchase_lines join products on products.id = purchase_lines.product_id where products.walmart_id is not null");          
          DB::select("delete product_locations from product_locations join products on products.id = product_locations.product_id where products.walmart_id is not null");          
          DB::select("delete variations from variations join products on products.id = variations.product_id where products.walmart_id is not null");          
          DB::select("delete from products where walmart_id is not null");
      }
      if($products) {
        $no = 0;
        $arr = [];
        $status = '';        
        try {
          //code...
          foreach ($products as $key => $value) {            
            //echo "Coming product shopify id : " . $value['id'] . ' - ';
            
            $brand_walmart = str_replace(['[',']',], ['',''], $value['shelf']);
            # code...
            $checkBrand = Brands::whereRaw("lower(name) = ?", $brand_walmart)->where('business_id', $business_id)->first();
            if($checkBrand == null) {
              $b = new Brands();
              $b->business_id = $business_id;
              $b->name = $brand_walmart;
              $b->description = null;
              $b->created_by = auth()->user()->id;
              $b->save();
  
              $brandId = $b->id;
            } else {
              $brandId = $checkBrand->id;
            }
  
            $checkCategory = Category::whereRaw("lower(name) = ?", $value['productType'])->where('business_id', $business_id)->first();
            if($checkCategory == null) {
              $c = new Category();
              $c->name = $value['productType'];
              $c->business_id = $business_id;
              $c->parent_id = 0;
              $c->created_by = auth()->user()->id;
              $c->category_type = 'product';
              $c->save();
              $categoryId = $c->id;
            } else {  
              $categoryId = $checkCategory->id;
            }
  
            $get_qty = $this->get_inventory($WALMART_URL, $session_token, $WALMART_ID, $WALMART_KEY, $value['sku']);
            $unitId = 1;    
            if(array_key_exists('quantity', $get_qty)) {
                $checkUnit = Unit::whereRaw("lower(actual_name) = ?", $get_qty['quantity']['unit'])->where('business_id', $business_id)->first();
                if($checkUnit == null) {
                  $u = new Unit();
                  $u->business_id = $business_id;
                  $u->actual_name = $get_qty['quantity']['unit'];
                  $u->short_name = $get_qty['quantity']['unit'];
                  $u->created_by = auth()->user()->id;
                  $u->save();
                  $unitId = $u->id;
                } else {
                  $unitId = $checkUnit->id;
                } 
            } else {
                $get_qty = [
                    'sku' => $value['sku'],
                    'quantity' => [
                        'unit' => 'Pcs',
                        'amount' => 0
                    ]
                ];
            }
            
            $checkProduct = Product::where('walmart_id', $value['upc'])->first();
            if($checkProduct == null) {
              $p = new Product();
              $p->name = $value['productName'];
              $p->business_id = $business_id;
              $p->type = 'single';
              $p->enable_stock = 1;
              $p->tax_type = 'exclusive';
              $p->unit_id = $unitId;
              $p->brand_id = $brandId;
              $p->category_id = $categoryId;
              $p->alert_quantity = 1;
              $p->sku = $value['sku'];
              $p->barcode = $value['sku'];
              $p->created_by = auth()->user()->id;
              $p->product_description = $value['productName'];
              $p->walmart_id = $value['upc'];
            //   $p->image = $value['image'] ? $value['image']['src'] : null;
              $p->save();
  
              if($product_locations) {                
                $p->product_locations()->sync($product_locations);
              }
  
              $pv = new ProductVariation();
              $pv->name = 'default_variant';
              $pv->product_id = $p->id;
              $pv->is_dummy = 0;
              $pv->created_at = Carbon::now();
              $pv->save();
  
              $v = new Variation();
              $v->name = 'default_variant';
              $v->product_id = $p->id;
              $v->sub_sku = $value['sku'];
              $v->product_variation_id = $pv->id;
              $v->default_sell_price = $value['price'] ? $value['price']['amount'] : 0;
              $v->sell_price_inc_tax = $value['price'] ? $value['price']['amount'] : 0;
              $v->save();
                                          
              if($product_locations) {
                /* if(count($product_locations) > 1) {
                //   $qty_divide = $value['variants'][0]['inventory_quantity'] / 1;
                  $get_qty = $this->get_inventory($WALMART_URL, $session_token, $WALMART_ID, $WALMART_KEY, $value['sku']);                  
                  foreach ($product_locations as $val) {
                    # code...
                    $vld = new VariationLocationDetails();
                    $vld->product_id = $p->id;
                    $vld->product_variation_id = $pv->id;
                    $vld->variation_id = $v->id;
                    $vld->location_id = $val;
                    $vld->qty_available = $qty_divide;
                    $vld->save();
  
                    $transaction = new Transaction();
                    $transaction->business_id = $business_id;
                    $transaction->location_id = $val;
                    $transaction->type = 'opening_stock';
                    $transaction->status = 'received';
                    $transaction->is_quotation = 0;
                    $transaction->payment_status = 'paid';
                    $transaction->transaction_date = Carbon::now();
                    $transaction->total_before_tax = 0;
                    $transaction->tax_amount = 0;
                    $transaction->discount_amount = 0;
                    $transaction->rp_redeemed = 0;
                    $transaction->rp_redeemed_amount = 0;
                    $transaction->shipping_charges = 0;
                    $transaction->is_export = 0;
                    $transaction->round_off_amount = 0;
                    $transaction->additional_expense_value_1 = 0;
                    $transaction->additional_expense_value_2 = 0;
                    $transaction->additional_expense_value_3 = 0;
                    $transaction->additional_expense_value_4 = 0;
                    $transaction->final_total = 0;
                    $transaction->is_direct_sale = 0;
                    $transaction->is_suspend = 0;
                    $transaction->exchange_rate = 1;
                    $transaction->opening_stock_product_id = $p->id;
                    $transaction->created_by = auth()->user()->id;
                    $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                    $transaction->is_created_from_api = 1;
                    $transaction->rp_earned = 0;
                    $transaction->is_recurring = 0;
  
                    $transaction->save();
  
                    $purchase_lines = new PurchaseLine();
                    $purchase_lines->transaction_id = $transaction->id;
                    $purchase_lines->product_id = $p->id;
                    $purchase_lines->variation_id = $v->id;
                    $purchase_lines->quantity = $qty_divide;
                    $purchase_lines->purchase_price = 0;
                    $purchase_lines->save();
                  }
                } else { */                                               
                  $vld = new VariationLocationDetails();
                  $vld->product_id = $p->id;
                  $vld->product_variation_id = $pv->id;
                  $vld->variation_id = $v->id;
                  $vld->location_id = $product_locations[0];
                  $vld->qty_available = $get_qty['quantity']['amount'];
                  $vld->save();
  
                  $transaction = new Transaction();
                  $transaction->business_id = $business_id;
                  $transaction->location_id = $product_locations[0];
                  $transaction->type = 'opening_stock';
                  $transaction->status = 'received';
                  $transaction->is_quotation = 0;
                  $transaction->payment_status = 'paid';
                  $transaction->transaction_date = Carbon::now();
                  $transaction->total_before_tax = 0;
                  $transaction->tax_amount = 0;
                  $transaction->discount_amount = 0;
                  $transaction->rp_redeemed = 0;
                  $transaction->rp_redeemed_amount = 0;
                  $transaction->shipping_charges = 0;
                  $transaction->is_export = 0;
                  $transaction->round_off_amount = 0;
                  $transaction->additional_expense_value_1 = 0;
                  $transaction->additional_expense_value_2 = 0;
                  $transaction->additional_expense_value_3 = 0;
                  $transaction->additional_expense_value_4 = 0;
                  $transaction->final_total = 0;
                  $transaction->is_direct_sale = 0;
                  $transaction->is_suspend = 0;
                  $transaction->exchange_rate = 1;
                  $transaction->opening_stock_product_id = $p->id;
                  $transaction->created_by = auth()->user()->id;
                  $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                  $transaction->is_created_from_api = 1;
                  $transaction->rp_earned = 0;
                  $transaction->is_recurring = 0;
  
                  $transaction->save();
  
                  $purchase_lines = new PurchaseLine();
                  $purchase_lines->transaction_id = $transaction->id;
                  $purchase_lines->product_id = $p->id;
                  $purchase_lines->variation_id = $v->id;
                  $purchase_lines->quantity = $get_qty['quantity']['amount'];
                  $purchase_lines->purchase_price = 0;
                  $purchase_lines->save();
                // }
              }
  
              $no++;
              $status = 1;
              array_push($arr, [
                  'number' => $no,
                  'status' => $status
              ]);
            }
            else {            
              $checkmarks_arr = [];
              foreach ($checkmarks as $key => $val) {
                array_push($checkmarks_arr, $val['value']);
              }
              
                $nameProduct =  $checkProduct->name == $value['productName'] ? $checkProduct->name : $value['productName'];
                $brand_id =  $checkProduct->brand_id == $brandId ? $checkProduct->brand_id : $brandId;
                $category_id = $checkProduct->category_id == $categoryId ? $checkProduct->category_id : $categoryId;
                $alert_qty = 1;
                $description = $checkProduct->product_description == $value['productName'] ? $checkProduct->product_description : $value['productName'];            
                $valueSku = $value['sku'] ? $value['sku'] : ' ';
                $sku = $checkProduct->sku == $valueSku ? $checkProduct->sku : $valueSku;
                $valueBarcode = $value['sku'] ? $value['sku'] : ' ';
                $barcode = $checkProduct->barcode == $valueBarcode ? $checkProduct->barcode : $valueBarcode;
                // $image = $value['image'] ? $value['image']['src'] : null;           
                
                $checkVariation = Variation::where('product_id', $checkProduct->id)->first(); 
                $statusVariation = null;                             
                if($checkVariation) {
                  $nameVariation = $checkVariation->name == 'default_variant' ? $checkVariation->name : 'default_variant';
                  $subSku = $checkVariation->sub_sku == $value['sku'] ? $checkVariation->sub_sku : $value['sku'];
                  $price = $checkVariation->default_sell_price == $value['price']['amount'] ? $checkVariation->default_sell_price : $value['price']['amount'];
      
                  /* $variation = Variation::where('product_id', $checkProduct->id)->update([
                    'name' => $nameVariation,
                    'sub_sku' => $subSku,
                    'default_sell_price' => $price,
                    'sell_price_inc_tax' => $price
                  ]); */
  
                  $variation = Variation::find($checkVariation->id);
                  $variation->name = $nameVariation;
                  $variation->sub_sku = $subSku;
                  if(in_array("default_sell_price", $checkmarks_arr)) {
                      $variation->default_sell_price = $price;
                      $variation->sell_price_inc_tax = $price;
                  }
                  
                  $variation->save();

                  $statusVariation = $variation->wasChanged();
                  
                }
                
                if($product_locations) {                
                  // if(count($product_locations) != count($checkProductQty)) {
                    // VariationLocationDetails::where('product_id', $checkProduct->id)->delete();
                    if(! empty($product_locations)) {
                      $productVariation = ProductVariation::where('product_id', $checkProduct->id)->select('id')->first();                    
                      foreach ($product_locations as $locval) {                      
                          # code...
                          $checkProductQty = VariationLocationDetails::where('product_id', $checkProduct->id)->where('location_id', $locval)->first();                        
                          $qty_divide = $get_qty['quantity']['amount'] / 1;
                          if($checkProductQty) {                                                    
                            if($checkProductQty->qty_available != $qty_divide) {
                              $vld = VariationLocationDetails::find($checkProductQty->id);
                              $vld->qty_available = $qty_divide;
                              $vld->save();               

                              $checkPurcasheLine = PurchaseLine::where('variation_id', $checkProductQty->variation_id)->where('product_id', $checkProduct->id)->first();
                              if($checkPurcasheLine == null) {
                                $transaction = new Transaction();
                                $transaction->business_id = $business_id;
                                $transaction->location_id = $locval;
                                $transaction->type = 'opening_stock';
                                $transaction->status = 'received';
                                $transaction->is_quotation = 0;
                                $transaction->payment_status = 'paid';
                                $transaction->transaction_date = Carbon::now();
                                $transaction->total_before_tax = 0;
                                $transaction->tax_amount = 0;
                                $transaction->discount_amount = 0;
                                $transaction->rp_redeemed = 0;
                                $transaction->rp_redeemed_amount = 0;
                                $transaction->shipping_charges = 0;
                                $transaction->is_export = 0;
                                $transaction->round_off_amount = 0;
                                $transaction->additional_expense_value_1 = 0;
                                $transaction->additional_expense_value_2 = 0;
                                $transaction->additional_expense_value_3 = 0;
                                $transaction->additional_expense_value_4 = 0;
                                $transaction->final_total = 0;
                                $transaction->is_direct_sale = 0;
                                $transaction->is_suspend = 0;
                                $transaction->exchange_rate = 1;
                                $transaction->opening_stock_product_id = $checkProduct->id;
                                $transaction->created_by = auth()->user()->id;
                                $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                                $transaction->is_created_from_api = 1;
                                $transaction->rp_earned = 0;
                                $transaction->is_recurring = 0;
      
                                $transaction->save();
      
                                $purchase_lines = new PurchaseLine();
                                $purchase_lines->transaction_id = $transaction->id;
                                $purchase_lines->product_id = $checkProduct->id;
                                $purchase_lines->variation_id = $variation->id;
                                $purchase_lines->quantity = $qty_divide;
                                $purchase_lines->purchase_price = 0;
                                $purchase_lines->save();
                              } else {                                
                                $purchase_lines = PurchaseLine::find($checkPurcasheLine->id);
                                $purchase_lines->exp_date = null;
                                $purchase_lines->quantity = $qty_divide;
                                $purchase_lines->save();
                              }
                            }
                          } else {                     
                            /* $getTransactionPurchaseLinesLast = PurchaseLine::join('transactions as t', 't.id', '=', 'purchase_lines.transaction_id')
                                    ->where('purchase_lines.product_id', $checkProduct->id)
                                    ->where('purchase_lines.variation_id', $checkVariation->id)
                                    ->where('t.type', '=', 'opening_stock')
                                    ->where('t.business_id', $business_id)
                                    ->where('t.location_id', '<>', $locval)
                                    ->select('purchase_lines.*')
                                    ->orderBy('t.created_at', 'desc')->first();                                                    
                            if($getTransactionPurchaseLinesLast) {
                              $purchase_lines = PurchaseLine::find($getTransactionPurchaseLinesLast->id);
                              $purchase_lines->exp_date = Carbon::now()->subDays(30);
                              $purchase_lines->save();
                            } */   
                             
                            $vld = new VariationLocationDetails();
                            $vld->product_id = $checkProduct->id;
                            $vld->product_variation_id = $productVariation->id;
                            $vld->variation_id = $checkVariation->id;
                            $vld->location_id = $locval;
                            $vld->qty_available = $qty_divide;
                            $vld->save();
                      
                            $transaction = new Transaction();
                            $transaction->business_id = $business_id;
                            $transaction->location_id = $locval;
                            $transaction->type = 'opening_stock';
                            $transaction->status = 'received';
                            $transaction->is_quotation = 0;
                            $transaction->payment_status = 'paid';
                            $transaction->transaction_date = Carbon::now();
                            $transaction->total_before_tax = 0;
                            $transaction->tax_amount = 0;
                            $transaction->discount_amount = 0;
                            $transaction->rp_redeemed = 0;
                            $transaction->rp_redeemed_amount = 0;
                            $transaction->shipping_charges = 0;
                            $transaction->is_export = 0;
                            $transaction->round_off_amount = 0;
                            $transaction->additional_expense_value_1 = 0;
                            $transaction->additional_expense_value_2 = 0;
                            $transaction->additional_expense_value_3 = 0;
                            $transaction->additional_expense_value_4 = 0;
                            $transaction->final_total = 0;
                            $transaction->is_direct_sale = 0;
                            $transaction->is_suspend = 0;
                            $transaction->exchange_rate = 1;
                            $transaction->opening_stock_product_id = $checkProduct->id;
                            $transaction->created_by = auth()->user()->id;
                            $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                            $transaction->is_created_from_api = 1;
                            $transaction->rp_earned = 0;
                            $transaction->is_recurring = 0;
                            $transaction->save();
    
                            $purchase_lines = new PurchaseLine();
                            $purchase_lines->transaction_id = $transaction->id;
                            $purchase_lines->product_id = $checkProduct->id;
                            $purchase_lines->variation_id = $variation->id;
                            $purchase_lines->quantity = $qty_divide;
                            $purchase_lines->purchase_price = 0;
                            $purchase_lines->save();                                                      
                          }                       
                      }                    
                    }
                  // }
                }                                       
  
                // $product = Product::where('shopify_id', $value['id'])->update([
                //   'product_description' => $description,
                //   'brand_id' => $brand_id,
                //   'alert_quantity' => $alert_qty,
                //   'name' => $nameProduct,
                //   'category_id' => $category_id,
                //   'sku' => $sku,
                //   'barcode' => $barcode,
                // ]);    
  
                $product = Product::find($checkProduct->id);              
                $product->alert_quantity = $alert_qty;              
                if(in_array("product_description", $checkmarks_arr)) {
                  $product->product_description = $description;
                }                    
                if(in_array("name", $checkmarks_arr)) {
                    $product->name = $nameProduct;
                }
                if(in_array("category_id", $checkmarks_arr)) {
                    $product->category_id = $category_id;
                }
                if(in_array("brand_id", $checkmarks_arr)) {
                    $product->brand_id = $brand_id;
                }
                if(in_array("sku", $checkmarks_arr)) {
                    $product->sku = $sku;
                }
                if(in_array("barcode", $checkmarks_arr)) {
                    $product->barcode = $barcode;
                }
                /* if($image) {
                  $product->image = $image;
                } */
                $product->save();
                
                
                if($product->wasChanged() || $statusVariation) {                  
                  $no++;
                  $status = 2;
                  array_push($arr, [
                    'number' => $no,
                    'status' => $status,
                    'product_changed' => $product->wasChanged(),
                    'statusVariation' => $statusVariation,
                    'product_name' => $value['productName'],
                    'walmart_id' => $value['upc']
                  ]);
                }
  
                if(! empty($product_locations)) {
                  $checkProduct->product_locations()->sync($product_locations);
                }        
              // }
            }
            
          }
          DB::commit();
        //   dd($arr);
          return $arr;
        } catch (\Exception $err) {
          //throw $th;
          DB::rollBack();
        //   dd($err);
          // return $err->getMessage();
          return response()->json([
            'message' => $err->getMessage(),
            // 'message' => __('messages.something_went_wrong'),
            'data' => null
          ]);
        }
        // return 'Received Data Success';
      } else {        
        $arr = [];
        return $arr;
        // return 'Data Not Found';
      }
    }
}
