<?php

namespace App\Imports;

use App\Keepa;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use App\Jobs\AmazonQueueJob;
use Illuminate\Support\Facades\Log;

class KeepaImport implements ToModel, WithChunkReading, WithStartRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        static $rowIndex = 1; // Mulai dari 1 jika ada header
        $currentIndex = $rowIndex++;
        AmazonQueueJob::dispatch($row)->delay(now()->addMinutes($currentIndex));
    }

    // Tentukan ukuran chunk (misal 100 baris per job)
    public function chunkSize(): int
    {
        return 50;
    }

    public function startRow(): int
    {
        return 2; // Mulai dari baris ke-2 (melewati header)
    }
}
