<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\RateLimiter;
use App\Http\Controllers\KeepaController;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Request;
use Carbon\Carbon;
use App\Keepa;
use App\Services\KeepaService;
use App\ShopifyTable;
use App\AmazonTable;

class AmazonQueueJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    // Tambahkan timeout agar tidak lebih dari 5 menit
    protected $data;
    protected $DEBUG_MODE = true;
    // public $timeout; // 300 detik = 5 menit
    // public $counter;

    public function __construct($data)
    {
        //
        $this->data = $data;
    }


    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(): void
    {
        // $key = 'process-data-rate-limit';

        // if (RateLimiter::tooManyAttempts($key, 20)) {
        //     Log::warning("Job delayed because it reached the ASIN rate limit {$this->data[16]}");
        //     $this->release(60); // Tunda job selama 1 menit
        //     return;
        // }        

        // RateLimiter::hit($key, 60); // Tambah counter selama 60 detik

        // Hitung jumlah job yang sudah dijalankan
        // $processedJobs = $this->counter++;

        if ($this->batch() && $this->batch()->cancelled()) {
            return; // Stop processing jika batch dibatalkan
        }

        // $startTimeBatch = microtime(true);        
        // Log::info("Batch Id: ".($this->batch() ? $this->batch()->id : 'N/A'));
        // foreach ($this->data as $key => $data) {
            // Log::info("Records: " .($key+1))
            $startTime = microtime(true);
            $keepaService = new KeepaService();
            $keepa = Keepa::where('asin', $this->data->ASIN)->first();
            if($keepa) {                
                $shopify = ShopifyTable::where('barcode', $this->data->ASIN)->first(); 
                ShopifyTable::where('barcode', $this->data->ASIN)->update([
                    'description' => $keepa->description.', ISBN13: '.$shopify->metafield_isbn13.' ISBN10: '.$shopify->metafield_isbn10.' Material Type: '.$shopify->metafield_material_type,
                    'metafield_description' => $keepa->description
                ]); 
    
                AmazonTable::where('id', $this->data->id)->update([
                    'description' => $keepa->description
                ]);
                $endTime = microtime(true); // Waktu selesai
                $executionTime = $endTime - $startTime; // Hitung durasi dalam detik
                if ($this->DEBUG_MODE) Log::info("Job finish successfully update description from keepa table ASIN {$this->data->ASIN} on amazon, shopify and keepa table at {$executionTime} seconds.");
            } else {                
                sleep(2);
                $keepaProduct = $keepaService->getProduct($this->data->ASIN);
                if(array_key_exists('products', $keepaProduct)) {
                    $product = $keepaProduct['products'][0];
                    
                    $description = $product['description'] ?? null;
                    if(Keepa::where('asin', $this->data->ASIN)->exists()) {
                        Keepa::where('asin', $this->data->ASIN)->where('seller_sku', $this->data->SellerSku)->update([
                            'description' => $description
                        ]);                        
                    } else {
                        Keepa::create([
                            'store' => $this->data->store,
                            'asin' => $this->data->ASIN,
                            'seller_sku' => $this->data->SellerSku,
                            'description' => $description
                        ]);
                    }            
        
                    $shopify = ShopifyTable::where('barcode', $this->data->ASIN)->first(); 
                    ShopifyTable::where('barcode', $this->data->ASIN)->update([
                        'description' => $description.', ISBN13: '.$shopify->metafield_isbn13.' ISBN10: '.$shopify->metafield_isbn10.' Material Type: '.$shopify->metafield_material_type,
                        'metafield_description' => $description
                    ]); 
        
                    AmazonTable::where('id', $this->data->id)->update([
                        'description' => $description
                    ]);
    
                    $endTime = microtime(true); // Waktu selesai
                    $executionTime = $endTime - $startTime; // Hitung durasi dalam detik
                    if ($this->DEBUG_MODE) Log::info("Job finish successfully update description from keepa API ASIN {$this->data->ASIN} on amazon, shopify and keepa table at {$executionTime} seconds.");
                } else {
                    if ($this->DEBUG_MODE) Log::info("Data not found ". $this->data->ASIN);
                }
            }

            // if(Keepa::where('asin', $this->data->asin)->exists()) {
            //     if(Keepa::where('seller_sku', $this->data->seller_sku)->exists()) {
            //         Log::info("Update asin: ". $this->data->asin. " Seller SKU: ". $this->data->seller_sku);
            //         Keepa::where('asin', $this->data->asin)->where('seller_sku', $this->data->seller_sku)->update([
            //             'listing_id' => $this->data->listing_id,
            //             'seller_sku' => $this->data->seller_sku,
            //             'current_price' => $this->data->price,
            //             'current_qty' => $this->data->quantity
            //         ]);
            //     } else {
            //         app(KeepaController::class)->getProduct('A2NODI4BBRA1B1', $this->data->asin, $this->data);
            //     }
            // } else {
            //     app(KeepaController::class)->getProduct('A2NODI4BBRA1B1', $this->data->asin, $this->data);
            // }        
        // }
        
        // $endTimeBatch = microtime(true); // Waktu selesai
        // $executionTimeBatch = $endTimeBatch - $startTimeBatch; // Hitung durasi dalam detik
        // Log::info("Finish batch Id: ".($this->batch() ? $this->batch()->id : 'N/A')."Processed " . count($this->data) . " records at {$executionTimeBatch} seconds.");
    }
}
