<?php

namespace App\Jobs;

use App\Http\Controllers\AmazonController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Queue;

class ConvertAmazonToShopifyJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $vendor;
    protected $DEBUG_MODE = true;
    public function __construct($vendor)
    {
        //
        $this->vendor = $vendor;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //                
        app(AmazonController::class)->convertAmazonToShopify($this->vendor);
        if ($this->DEBUG_MODE) Log::info("Conver Amazon To Shopify Finished");        
    }
}
