<?php

namespace App\Jobs;

use App\Http\Controllers\ShopifyController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class CreateAmazonToShopifyJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

    protected $populate_products;
    protected $batch;
    protected $DEBUG_MODE = true;

    public function __construct($populate_products, $batch)
    {
        //
        $this->populate_products = $populate_products;
        $this->batch = $batch;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(): void
    {
        //
        $startTime = microtime(true);
        $response = app(ShopifyController::class)->createShopifyProducts($this->populate_products);
        $responses[] = $response['response'];
        if ($this->DEBUG_MODE) Log::info("How many product send to shopify on batch ".($this->batch+1)." successfully: ".$response['total']);
    }
}
