<?php

namespace App\Jobs;

use App\AmazonTable;
use App\Http\Controllers\AmazonController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\RateLimiter;
use App\Http\Controllers\KeepaController;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Request;
use Carbon\Carbon;
use App\Keepa;
use App\Services\KeepaService;
use Illuminate\Support\Facades\DB;

class NewAmazonJob implements ShouldQueue
{
  use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;
  
  /**
   * Create a new job instance.
   *
   * @return void
   */
  // Tambahkan timeout agar tidak lebih dari 5 menit
  protected $data;
  protected $DEBUG_MODE = true;
  // public $queue = 'sycn-amazon';
  // public $timeout; // 300 detik = 5 menit
  // public $counter;

  public function __construct($data)
  {
    //
    $this->data = $data;
  }

  /**
   * Execute the job.
   *
   * @return void
   */
  public function handle(): void
  {
    $startTime = microtime(true);
    $data = $this->data;
    
    if (AmazonTable::where('ASIN', $data->asin)->exists()) {
      if ($this->DEBUG_MODE) Log::info($data->asin . " Asin Exists in amazon table");
      if (AmazonTable::where('SellerSku', $data->seller_sku)->exists()) {
        // if ($this->DEBUG_MODE) Log::info($data->seller_sku . " Seller Sku Exists in amazon table");
        // AmazonTable::where('ASIN', $data->asin)->where('SellerSku', $data->seller_sku)->update([
        //   'AmazonSellerInventoryPrice' => $data->price,
        //   'CurrentQty' => $data->quantity,
        //   'Price' => $data->price . ' USD',
        //   'status' => $data->status,
        //   'synced' => 1,
        // ]);
        // if ($this->DEBUG_MODE) Log::info("Item in amazon table price and qty updated " . $data->asin);
        $amazon_table_data = AmazonTable::where('ASIN', $data->asin)->where('SellerSku', $data->seller_sku)->select('description')->first();
        if($amazon_table_data) {
          if ($amazon_table_data->description) {
          } else {
            if ($this->DEBUG_MODE) Log::info("After update qty and price, there is no description " . $data->asin);
            $this->callApiKeepa($data->asin, $data->seller_sku);
          }
        }
        if ($this->DEBUG_MODE) Log::info($data->asin . " Successfully updated from AmazonSellerInventory");
        $endTime = microtime(true); // Waktu selesai
        $executionTime = $endTime - $startTime; // Hitung durasi dalam detik
        if ($this->DEBUG_MODE) Log::info("Job finish ASIN {$data->asin} at {$executionTime} seconds.");
      } else {
        if ($this->DEBUG_MODE) Log::info("ASIN {$data->asin} exists but Seller Sku {$data->seller_sku} not exists in amazon table.");
        sleep(1); // Requeue with a delay of 5 seconds        
        if ($this->DEBUG_MODE) Log::info("Delay 1 second");
        $this->callApi($data);        
        if ($this->DEBUG_MODE) Log::info($data->asin . " Successfully inserted With Amazon API");
        $endTime = microtime(true); // Waktu selesai
        $executionTime = $endTime - $startTime; // Hitung durasi dalam detik
        if ($this->DEBUG_MODE) Log::info("Job finish ASIN {$data->asin} at {$executionTime} seconds.");
      }
    } else {
      if ($this->DEBUG_MODE) Log::info("ASIN {$data->asin} not exists in amazon table.");
      sleep(1); // Requeue with a delay of 5 seconds         
      if ($this->DEBUG_MODE) Log::info("Delay 1 second");
      $this->callApi($data);      
      $endTime = microtime(true); // Waktu selesai
      $executionTime = $endTime - $startTime; // Hitung durasi dalam detik
      if ($this->DEBUG_MODE) Log::info("Job finish ASIN {$data->asin} at {$executionTime} seconds.");
    }

    if (Cache::has('updateAmazonTable')) {
      $current = Cache::get("updateAmazonTable");
      // if ($this->DEBUG_MODE) Log::info($current);
      $current['completed']++;
      if ($this->DEBUG_MODE) Log::info('data count: '.$current['completed']);
      Cache::put("updateAmazonTable", $current, now()->addMinutes(30));
    }
  }

  private function callApi()
  {
    $data = $this->data;
    $results = app(AmazonController::class)->getProductDetails($data->asin, false, $data->seller_id);
    if(array_key_exists('errors', $results)) {
      if ($this->DEBUG_MODE) Log::info($data->asin . " Not found on amazon api catalog item");
      return true;
    } else {
      $itemCondition = [
        '-',
        'USED_LIKE_NEW',
        'USED_VERY_GOOD',
        'USED_GOOD',
        'USED_ACCEPTABLE',
        'COLLECTIBLE_LIKE_NEW*',
        'COLLECTIBLE_VERY_GOOD*',
        'COLLECTIBLE_GOOD*',
        'COLLECTIBLE_ACCEPTABLE*',
        'NOT_USED',
        'REFURBISHED',
        'NEW',
      ];
  
      $formattedProduct = [
        'store' => $data->seller_id,
        'ASIN' => $results['ASIN'],
        "Title" => $results['Title'],
        "Subjects" => $results['Subjects'],
        "Binding" => $results['Binding'],
        "Languages" => $results['Languages'],
        "Format" => $results['Format'],
        "ItemTypeKeyword" => $results['ItemTypeKeyword'],
        "Composer" => $results['Composer'],
        "PublicationDate" => $results['PublicationDate'],
        "Pages" => $results['Pages'],
        "BulletPoints" => $results['BulletPoints'],
        "Dimensions" => $results['Dimensions'],
        "Brand" => $results['Brand'],
        "TargetAudience" => $results['TargetAudience'],
        "Manufacturer" => $results['Manufacturer'],
        "Price" => $results['Price'],
        "Authors" => $results['Authors'],
        "Genre" => $results['Genre'],
        "Identifiers" => $results['Identifiers'],
        "Images" => $results['Images'],
        "ProductTypes" => $results['ProductTypes'],
        "Classifications" => $results['Classifications'],
        "ClassificationRanks" => $results['ClassificationRanks'],
        "DisplayGroupRanks" => $results['DisplayGroupRanks'],
        "ItemCondition" => $itemCondition[$data->item_condition],
        "CurrentQty" => $data->quantity,
        "AmazonSellerInventoryPrice" => $data->price,
        "SellerSku" => $data->seller_sku,
        "ListingId" => $data->listing_id,
        "status" => $data->status,
        "synced" => 1,
      ];
  
      $formattedProduct = array_map(function ($value) {
        return is_array($value) ? json_encode($value) : $value;
      }, $formattedProduct);
      AmazonTable::create($formattedProduct);
      if ($this->DEBUG_MODE) Log::info($data->asin . " Successfully inserted With Amazon API");
  
      $this->callApiKeepa($data->asin, $data->seller_sku);
      return true;
    }
  }

  // private function callApiKeepa($asin, $sku)
  // {
  //   try {
  //     if ($this->DEBUG_MODE) Log::info($asin . " Keepa update started.");
  //     $amazon_table = AmazonTable::where('ASIN', $asin)->where('SellerSku', $sku)->first();
  //     if($amazon_table->keepa_description_check == 1 || $amazon_table->keepa_description_check == null) {        
  //       if ($this->DEBUG_MODE) Log::info($asin . " keepa description check 172 " . $amazon_table->keepa_description_check);      
  //       //code...
  //       $keepaService = new KeepaService();
  //       $keepaProduct = $keepaService->getProduct($asin);
        
  //       if (array_key_exists('products', $keepaProduct)) {
  //         $product = $keepaProduct['products'][0];
  
  //         $description = $product['description'] ?? null;
  //         if ($description) {
  //           if ($this->DEBUG_MODE) Log::info($asin . " Description updated from keepa.");
  //         } else {
  //           AmazonTable::where('ASIN', $asin)->where('SellerSku', $sku)->update([
  //             'keepa_description_check' => 0
  //           ]);
  //           if ($this->DEBUG_MODE) Log::info($asin . " Description is null on keepa.");
  //         }
  //         AmazonTable::where('ASIN', $asin)->where('SellerSku', $sku)->update([
  //           'description' => $description
  //         ]);
  //       }
  //       sleep(2);
  //     } else {
  //       if ($this->DEBUG_MODE) Log::info($asin . " keepa description check 195 " . $amazon_table->keepa_description_check);
  //       return true;
  //     }
  //   } catch (\Exception $e) {
  //     //throw $th;
  //     if ($this->DEBUG_MODE) Log::info("Error keepa description ".$e->getMessage(). ' Line: '. $e->getLine());
  //   }      
  // }

  private function callApiKeepa($asin, $sku)
  {
      try {
          if ($this->DEBUG_MODE) Log::info("$asin Keepa update started.");

          $amazon_table = AmazonTable::where('ASIN', $asin)
              ->where('SellerSku', $sku)
              ->first();

          $check = $amazon_table->keepa_description_check;

          if ($check === 0) {
              if ($this->DEBUG_MODE) Log::info("$asin keepa description check 216 $check");
              return true;
          }

          if ($this->DEBUG_MODE) Log::info("$asin keepa description check 220 $check");

          $keepaService = new KeepaService();
          $keepaProduct = $keepaService->getProduct($asin);

          if (array_key_exists('products', $keepaProduct)) {
              $product = $keepaProduct['products'][0];
              $description = $product['description'] ?? null;

              if ($description) {
                  if ($this->DEBUG_MODE) Log::info("$asin Description updated from keepa.");
              } else {
                  AmazonTable::where('ASIN', $asin)
                      ->where('SellerSku', $sku)
                      ->update(['keepa_description_check' => 0]);

                  if ($this->DEBUG_MODE) Log::info("$asin Description is null on keepa.");
              }

              AmazonTable::where('ASIN', $asin)
                  ->where('SellerSku', $sku)
                  ->update(['description' => $description]);
          }

          sleep(2);
      } catch (\Exception $e) {
          if ($this->DEBUG_MODE) {
              Log::info("Error keepa description ".$e->getMessage().' Line: '.$e->getLine());
          }
      }
  }

}
