<?php

namespace App\Jobs;

use App\Http\Controllers\AmazonController;
use App\Http\Controllers\ShopifyController;
use App\ShopifyTable;
use App\ShopifyUpdate;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ProcessShopifyStoreJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $product;
    protected $store;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(array $product, array $store)
    {
        //
        $this->product = $product;
        $this->store = $store;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
        $arr_product = $this->product;
        $store = $this->store;
        if($arr_product['update_or_create'] == 'update') {
            // Log::info("Update Product Price ". $arr_product['title']. " variantId: ". $arr_product['variantId']. " Price: ". $arr_product['variants'][0]['price']);
            // app(ShopifyController::class)->updateProductPrice($arr_product['variantId'], $arr_product['variants'][0]['price'], $store);
            // Log::info("Update Product Quantity ". $arr_product['title']. " inventortItemId: ". $arr_product['inventoryItemId']. ' Quantity: '. $arr_product['variants'][0]['quantity']. ' Location: '.$arr_product['variants'][0]['locationId']);
            // app(ShopifyController::class)->updateProductQuantity($arr_product['inventoryItemId'], $arr_product['variants'][0]['quantity'], $arr_product['variants'][0]['locationId'], $store);
            // array_push($results, [
            // 'product' => $arr_product['title'],
            // 'msg' => 'updated',
            // ]);
        } else {
            $productId = app(ShopifyController::class)->productCreateMutationGraphQl($arr_product, $store);
            if($arr_product['images']) {          
                app(ShopifyController::class)->imagesMutationGraphQl($arr_product['images'], $productId, $store);
            }
            
            if($arr_product['collections']) {
            $collections = array_map('trim', explode(',', $arr_product['collections'])); // split & trim
            $existingCollections = DB::table('shopify_collections')
                ->whereIn('collection_name', $collections)
                ->where('store', $store['store_url'])
                ->get()
                ->keyBy('collection_name'); // keyed by name for fast lookup
            $collections = explode(',', $arr_product['collections']);    
            $collection_id = null;  
            $collection_ids = [];
            foreach ($collections as $key => $collection) {
                # code...                  
                // $collectionFromDb = DB::table('shopify_collections')->where('collection_name', '=', $collection)->first();
                // if($collectionFromDb) {
                //     // $highestSimilarity = $percent;
                //     $collection_id = $collectionFromDb->collection_id;
                // }                               
                // if($collection_id) {
                //   $collection_ids .= $collection_id.',';
                // } else {
                //   $createNewCollectionId = $this->createNewCollection($store, $collection);
                //   DB::table('shopify_collections')->insert([
                //     'collection_id' => $createNewCollectionId,
                //     'collection_name' => $collection,
                //     'handle' => strtolower($collection),
                //     'store' => $store['store_url']
                //   ]);
                //   $collection_ids .= $createNewCollectionId.',';
                // }
                if (isset($existingCollections[$collection]) || $collection == 'Subjects') {
                    // collection exists, get id
                    if($collection == 'Subjects') {
                    if($store['store_url'] == 'https://used-book-depot-com.myshopify.com') {
                        $collection_ids[] = 'gid://shopify/Collection/319268847779';
                    } else {
                        $collection_ids[] = $existingCollections[$collection]->collection_id;
                    }
                    } else if($collection == 'Food & Wine') {
                    if($store['store_url'] == 'https://used-book-depot-com.myshopify.com') {
                        $collection_ids[] = 'gid://shopify/Collection/319312003235';
                    } else {
                        $collection_ids[] = $existingCollections[$collection]->collection_id;
                    }
                    } else {
                    $collection_ids[] = $existingCollections[$collection]->collection_id;
                    }
                } else {
                    // collection doesn't exist, create new ID and prepare insert
                    $newCollectionId = app(ShopifyController::class)->createNewCollection($store, $collection);
                    $collection_ids[] = $newCollectionId;
                    
                    DB::table('shopify_collections')->insert(
                    [
                        'collection_id' => $newCollectionId,
                        'collection_name' => $collection,
                        'handle' => strtolower($collection),
                        'store' => $store['store_url'],
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]
                    );

                    Log::info('Save new collection id to shopify_collections');
                }
            }                    

            $collection_ids_string = implode(',', $collection_ids);
            
            app(ShopifyController::class)->addProductToCollection($collection_ids_string, $productId, $store);
            }
            // array_push($results, [
            // 'product' => $arr_product['title'],
            // 'productId' => $productId,
            // 'msg' => 'created'
            // ]);
        }
        // if($product['collections']) {
        //   $this->addProductToCollection($product['collections'], $productId);
        // }
        ShopifyTable::where('id', $arr_product['id'])->update(['synced' => 1]);
        ShopifyUpdate::where('id', $arr_product['id'])->update(['synced' => 1]);
        sleep(1);
    }
}
