<?php

namespace App\Jobs;

use App\Http\Controllers\ShopifyController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class ShopifyUpdateJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $products;
    protected $store;
    protected $location;
    protected $getAllShopifyProductsMap;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(array $products, array $store, array $location, object $getAllShopifyProductsMap)
    {
        //
        $this->products = $products;
        $this->store = $store;
        $this->location = $location;
        $this->getAllShopifyProductsMap = $getAllShopifyProductsMap;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
        $arr_products = $this->products;
        $store = $this->store;
        $location = $this->location;
        $getAllShopifyProductsMap = $this->getAllShopifyProductsMap;
        $mutations_price = [];
        $mutations_quantity = [];        
        foreach ($arr_products as $key_product => $product) {
            # code...
            $inventoryItemId = null;
            $variantId = null;
            $key = $product['seller_sku'] . '|' . $product['barcode'];
            $match = $getAllShopifyProductsMap->get($key);
            if ($match) {
                $inventoryItemId = $match->inventory_item_id;
                $variantId = $match->variant_id;
            }                            

            if($variantId) {
                $mutations_price[] = <<<GRAPHQL
                v{$key_product}: productVariantUpdate(input: {id: "{$variantId}", price: "{$product['price']}"}) {
                    productVariant {
                        id
                        price
                    }
                    userErrors {
                        field
                        message
                    }
                }
                GRAPHQL;
            }

            if($inventoryItemId) {
                $qty = (int) $product['qty'];
    
                $mutations_quantity[] = <<<GRAPHQL
                v{$key_product}: inventorySetOnHandQuantities(input: {
                    reason: "correction",
                    setQuantities: [{
                        inventoryItemId: "{$inventoryItemId}",
                        locationId: "{$location['id']}",
                        quantity: {$qty}
                    }]
                    }) {
                    inventoryAdjustmentGroup {
                        createdAt
                        reason
                        changes {
                        delta
                        name
                        }
                    }
                    userErrors {
                        field
                        message
                    }
                }
                GRAPHQL;
            }
                    
        }

        $mutationBodyPrice = implode("\n", $mutations_price);

        // Wrap with full mutation block
        $queryPrice = <<<GRAPHQL
        mutation {
            {$mutationBodyPrice}
        }
        GRAPHQL;
        Log::info("queryPrice");
        Log::info($queryPrice);
        app(ShopifyController::class)->makeGraphQLRequest($queryPrice, null, $store);
        sleep(1);

        $mutationBodyQty = implode("\n", $mutations_quantity);
        // Wrap with full mutation block
        $queryQty = <<<GRAPHQL
        mutation {
            {$mutationBodyQty}
        }
        GRAPHQL;
        Log::info("queryQty");
        Log::info($queryQty);
        app(ShopifyController::class)->makeGraphQLRequest($queryQty, null, $store);        
    }
}
