<?php

namespace App\Jobs;

use App\Http\Controllers\ShopifyController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class UpdateHandleJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $key;
    protected $product_id;
    protected $shopify_id;
    protected $handle;
    protected $title;
    protected $store;
    public function __construct($key, $product_id, $shopify_id, $title, $handle, $store)
    {
        //
        $this->key = $key;
        $this->product_id = $product_id;
        $this->shopify_id = $shopify_id;
        $this->handle = $handle;
        $this->title = $title;
        $this->store = $store;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
        Log::info("Product number: ".$this->key. ', id: '.$this->product_id);
        $response = app(ShopifyController::class)->updateHandleShopify($this->shopify_id, $this->handle, $this->store);
        if(array_key_exists('errors', $response)) {
            if ($response['errors'][0]['message'] === 'Throttled') {
                sleep(2); // delay sebelum retry
            }
        }            

        Log::info("response update handle product shopify id: ". $this->shopify_id. " title: ". $this->title);
        Log::info(json_encode($response));
    }
}
