<?php

namespace App\Jobs;

use App\Http\Controllers\ShopifyController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class UpdatePrice15PercentShopifyJobs implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $products;
    protected $store;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(array $products, array $store)
    {
        //
        $this->products = $products;        
        $this->store = $store;        
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
        $arr_products = $this->products;
        $store = $this->store;
        $mutations_price = [];        
        foreach ($arr_products as $key_product => $product) {
            # code...                        
            $variantId = $product->variant_id;                                
            $compareAtPrice = $product->price;                                
            $price = $product->price - ($product->price * 15/10);                                

            if($variantId) {
                $mutations_price[] = <<<GRAPHQL
                v{$key_product}: productVariantUpdate(input: {id: "{$variantId}", price: "{$price}", compareAtPrice: "{$compareAtPrice}"}) {
                    productVariant {
                        id
                        price
                    }
                    userErrors {
                        field
                        message
                    }
                }
                GRAPHQL;
            }           
        }

        $mutationBodyPrice = implode("\n", $mutations_price);

        // Wrap with full mutation block
        $queryPrice = <<<GRAPHQL
        mutation {
            {$mutationBodyPrice}
        }
        GRAPHQL;
        Log::info("queryPrice");
        Log::info($queryPrice);
        app(ShopifyController::class)->makeGraphQLRequest($queryPrice, null, $store);
        sleep(1);
    }
}
