<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ModelHasPermissions extends Model
{
    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['model_id', 'model_type'];

    protected $table = 'model_has_permissions';

    public $timestamps = false;

    public function permissions()
    {
        return $this->hasMany(\App\Permission::class, 'id', 'permission_id');
    }
}
