<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class GoogleBooksService
{
    protected $apiKey;

    public function __construct()
    {
        $this->apiKey = env('GOOGLE_BOOKS_API_KEY');
    }

    public function getBookByISBN($isbn)
    {
        $response = Http::get("https://www.googleapis.com/books/v1/volumes", [
            'q' => "{$isbn}",
            'key' => $this->apiKey
        ]);

        return $response->json();
    }
}
