<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class KeepaService
{
    protected $apiKey;
    protected $baseUrl;

    public function __construct()
    {
        $this->apiKey = config('services.keepa.api_key');
        $this->baseUrl = config('services.keepa.base_url');
    }

    public function getProduct($asin)
    {
        $response = Http::get($this->baseUrl . 'product', [
            'key' => $this->apiKey,
            'domain' => 1,
            'asin' => $asin,
        ]);

        return $response->json();
    }

    public function getGraphImage($asin)
    {
        Log::info('KeepaService getGraphImage called with ASIN: ' . $asin);
        $response = Http::get($this->baseUrl . 'graphimage', [
            'key' => $this->apiKey,
            'domain' => 1,
            'asin' => $asin,
        ]);
        // No need to log the binary image data; just return the image response.
        // Log::info('KeepaService getGraphImage response: ' . $response->body());
        // Check if the response is successful
        if (!$response->successful()) {
            Log::error('KeepaService getGraphImage error: ' . $response->body());
            return response()->json(['error' => 'Failed to fetch graph image'], 500);
        }
        // Check if the response is a valid image
        if (strpos($response->header('Content-Type'), 'image/') !== 0) {
            Log::error('KeepaService getGraphImage invalid image response: ' . $response->body());
            return response()->json(['error' => 'Invalid image response'], 500);
        }
        
        return response($response->body(), 200, [
            'Content-Type' => $response->header('Content-Type'),
            'Content-Disposition' => 'inline; filename="keepa_graph.png"',
        ]);

        // return response()->json($response->body(), 200, [
        //     'Content-Type' => 'image/png',
        //     'Content-Disposition' => 'inline; filename="keepa_graph.png"',
        // ]);

        //Log::info('KeepaService getGraphImage response: ' . $response->body());

        //return $response->json();
    }    

    public function getAsins($store)
    {
        $response = Http::get($this->baseUrl . 'seller', [
            'key' => $this->apiKey,
            'domain' => 1,
            'type' => 'csv',
            'storefront' => 1,
            'seller' => $store,
        ]);

        return $response->body();
    }
}
