@extends('layouts.auth2')

@section('title', __('lang_v1.reset_password'))

@section('content')
<div class="login-form col-mdlogin-hp col-login-hp right-col-content">
    <div class="login-form-box">
    <form  method="POST" action="{{ route('password.email') }}">
        {{ csrf_field() }}
         <div class="form-group has-feedback {{ $errors->has('email') ? ' has-error' : '' }}">
            <input id="email" type="email" class="form-email-submit" name="email" value="{{ old('email') }}" required autofocus placeholder="@lang('lang_v1.email_address')">
            <span class="fa fa-envelope form-control-feedback"></span>
            @if ($errors->has('email'))
                <span class="help-block">
                    <strong>{{ $errors->first('email') }}</strong>
                </span>
            @endif
        </div>
        <br>
        <div class="form-group">
            <button type="submit" class="btn-login-submit">
                <a href="/login">Cancel</a>
            </button>
            <button type="submit" class="btn-rest-login-submit">
                @lang('lang_v1.send_password_reset_link')
            </button>
        </div>
    </form>
    </div>
</div>
@endsection