@extends('layouts.app')
@section('title', __('barcode.barcodes'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('barcode.barcodes')
        <small>@lang('barcode.manage_your_barcodes')</small>
    </h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => __('barcode.all_your_barcode')])                
        @slot('tool')                                             
            <div class="box-tools">                                
                <a class="btn btn-block btn-primary" href="{{action([\App\Http\Controllers\BarcodeController::class, 'create'])}}">
                <i class="fa fa-plus"></i> @lang('barcode.add_new_setting')</a>
            </div>
            <div class="box-tools" style="margin-right: 10px;">
                <a class="btn btn-block btn-primary" href="javascript:void(0);" onclick="popupRuleBaseSettings(event)">@lang('barcode.rule_based_print_settings')</a>
            </div>                               
        @endslot
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="barcode_table">
                <thead>
                    <tr>
                        <th>@lang('barcode.setting_name')</th>
                        <th>@lang('barcode.setting_description')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>
<!-- /.content -->
@stop
@section('javascript')
<script type="text/javascript">
    $(document).ready( function(){
        var barcode_table = $('#barcode_table').DataTable({
            processing: true,
            serverSide: true,
            buttons:[],
            ajax: '/barcodes',
            bPaginate: false,
            columnDefs: [ {
                "targets": 2,
                "orderable": false,
                "searchable": false
            } ]
        });
        $(document).on('click', 'button.delete_barcode_button', function(){
            swal({
              title: LANG.sure,
              text: LANG.confirm_delete_barcode,
              icon: "warning",
              buttons: true,
              dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    var href = $(this).data('href');
                    var data = $(this).serialize();

                    $.ajax({
                        method: "DELETE",
                        url: href,
                        dataType: "json",
                        data: data,
                        success: function(result){
                            if(result.success === true){
                                toastr.success(result.msg);
                                barcode_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
        $(document).on('click', 'button.set_default', function(){
            var href = $(this).data('href');
            var data = $(this).serialize();

            $.ajax({
                method: "get",
                url: href,
                dataType: "json",
                data: data,
                success: function(result){
                    if(result.success === true){
                        toastr.success(result.msg);
                        barcode_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                }
            });
        });
    });

    function popupRuleBaseSettings(e) {
        const baseUrl = window.location.origin;
        e.preventDefault();
        $.ajax({
            url: baseUrl + '/barcodes/popup-rule-based-settings',            
            dataType: 'html',
            success: function(result) {
                // console.log(result);
                $('.view_modal')
                    .html(result)
                    .modal('show');
            },
        });
    }

    function addRuleBasedPrintSettings() {
        var row_count = $('#row_count').val();
        var new_row = parseInt(row_count) + 1;

        $('#rule_based_print_settings_rows').append(`        
            <section id="row_rule_based${new_row}">
                <div class="col-lg-6">
                    <div class="form-group">
                        {!! Form::label('decimal_point', __('barcode.decimal_point') . '') !!}
                        {!! Form::text('rule_based[${new_row}][decimal_point]', null, ['class' => 'form-control', '']); !!}
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="form-group">
                        {!! Form::label('price_on_print_label', __('barcode.price_on_print_label') . '') !!}
                        <div class="input-group">
                        {!! Form::text('rule_based[${new_row}][price_on_print_label]', null, ['class' => 'form-control', '']); !!}
                        <span class="input-group-btn">
                            <button type="button" class="btn btn-default bg-white btn-flat btn-modal" title="Remove subject" onclick="removeRuleBasedPrintSettings('#row_rule_based${new_row}')"><i class="fa fa-times-circle text-danger fa-lg"></i></button>
                        </span>
                        </div>                  
                    </div>
                </div>
            </section>
        `);

        $('#row_count').val(new_row);
    }

    function removeRuleBasedPrintSettings(row) {
        $(row).remove();
    }

    function submitRuleBased(e) {
        e.preventDefault();
        $('form#rule_based_print_settings_form').submit();
    }
</script>
@endsection