@extends('layouts.app')
@section('title', __( 'lang_v1.dashboard' ))
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang( 'lang_v1.dashboard' )
        <!-- <small>@lang( 'user.manage_users' )</small> -->
    </h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary credit-table', 'title' => __( 'business.remaining_credit' ). ': '.$remaining_credit_now])
    <div class="table-responsive">
        <button type="submit" class="btn btn-primary" id="barcode_scanner">Barcode Scanner</button>
    </div>
    @endcomponent

    <div class="row">
        <div class="col-md-8">
            @component('components.widget', ['class' => 'box-primary credit-table', 'title' => __( 'business.remaining_credit' ). ': '.$remaining_credit_now])
            {{-- @can('user.create') --}}
            @slot('tool')
            <div class="box-tools">
                <a class="btn btn-block btn-primary"
                    href="#">
                    <i class="fa fa-plus"></i> @lang( 'messages.add' )</a>
            </div>
            @endslot
            {{-- @endcan --}}
            {{-- @can('user.view') --}}
            <h3>VH-AI Transactions</h3>
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dashboard_table">
                    <thead>
                        <tr>
                            <th class="credit-table-th-medium">@lang( 'user.name' )</th>
                            <th class="credit-table-th-medium">@lang( 'business.transaction_type' )</th>
                            <th class="credit-table-th-medium">@lang( 'business.credit' )</th>
                            <th class="credit-table-th-medium">@lang( 'business.remaining_credit' )</th>
                            <th class="credit-table-th-medium">@lang( 'business.description' )</th>
                            <th class="credit-table-th-medium">@lang( 'business.transaction_time' )</th>
                        </tr>
                    </thead>
                </table>
            </div>
            {{-- @endcan --}}
            @endcomponent
        </div>

        <div class="col-md-3" style="background-color: #c3d8ea;>
            @component('components.widget', ['class' => 'box-primary credit-table', 'style' => 'background-color: #d4e1ed;'])
            
            <div class=" panel-group" id="accordion">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h4 class="panel-title text-center">
                        <a data-toggle="collapse" data-parent="#accordion" href="#collapseOne">
                            @lang('business.refresh_credits')
                        </a>
                    </h4>
                </div>
                <div id="collapseOne" class="panel-collapse collapse">
                    <div class="panel-body">
                        <form action="" method="POST">
                            @csrf
                            <div class="form-group">
                                <label for="credit_amount">@lang('business.credit_amount')</label>
                                <input type="number" class="form-control" id="credit_amount" name="credit_amount" required>
                            </div>
                            <div class="form-group">
                                <label for="first_name">@lang('business.first_name')</label>
                                <input type="text" class="form-control" id="first_name" name="first_name" required>
                            </div>
                            <div class="form-group">
                                <label for="last_name">@lang('business.last_name')</label>
                                <input type="text" class="form-control" id="last_name" name="last_name" required>
                            </div>
                            <div class="form-group">
                                <label for="address">@lang('business.address')</label>
                                <input type="text" class="form-control" id="address" name="address" required>
                            </div>
                            <div class="form-group">
                                <label for="zip_code">@lang('business.zip_code')</label>
                                <input type="text" class="form-control" id="zip_code" name="zip_code" required>
                            </div>
                            <div class="form-group">
                                <label for="payment_method">@lang('business.payment_method')</label>
                                <select class="form-control" id="payment_method" name="payment_method" required>
                                    <option value="" disabled selected>@lang('business.select_payment_method')</option>
                                    <option value="credit_card">@lang('business.credit_card')</option>
                                    <option value="paypal">@lang('business.paypal')</option>
                                </select>
                            </div>
                            <div id="credit_card_details" style="display: none;">
                                <div class="form-group">
                                    <label for="credit_card_number">@lang('business.credit_card_number')</label>
                                    <input type="text" class="form-control" id="credit_card_number" name="credit_card_number">
                                </div>
                                <div class="form-group">
                                    <label for="valid_date_month">@lang('business.valid_date_month')</label>
                                    <input type="text" class="form-control" id="valid_date_month" name="valid_date_month" placeholder="MM" style="display: inline-block; width: 48%;">
                                    <label for="valid_date_year" style="display: inline-block; width: 48%; margin-left: 4%;">@lang('business.valid_date_year')</label>
                                    <input type="text" class="form-control" id="valid_date_year" name="valid_date_year" placeholder="YYYY" style="display: inline-block; width: 48%;">
                                </div>
                                <div class="form-group">
                                    <label for="ccv">@lang('business.ccv')</label>
                                    <input type="text" class="form-control" id="ccv" name="ccv">
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary" id="submit_button">@lang('business.pay')</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <script>
            document.getElementById('payment_method').addEventListener('change', function() {
                var creditCardDetails = document.getElementById('credit_card_details');
                var submitButton = document.getElementById('submit_button');

                if (this.value === 'credit_card') {
                    creditCardDetails.style.display = 'block';
                    submitButton.textContent = '@lang('
                    business.pay ')';
                } else if (this.value === 'paypal') {
                    creditCardDetails.style.display = 'none';
                    submitButton.textContent = '@lang('
                    business.continue_with_paypal ')';
                } else {
                    creditCardDetails.style.display = 'none';
                    submitButton.textContent = '@lang('
                    business.pay ')';
                }
            });
        </script>
        @endcomponent
    </div>
    </div>



    <div class="modal fade user_modal" tabindex="-1" role="dialog"
        aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->
<style>
    .credit-table {
        width: 100% !important;
    }

    .credit-table-th-medium {
        background-color: #f4f4f4 !important;
        color: #333 !important;
        width: 10% !important;
    }

    .content-header h1 {
        color: #3c8dbc;
        font-size: 24px;
    }

    .box-tools .btn-primary {
        background-color: #00a65a;
        border-color: #008d4c;
    }

    .table-responsive {
        margin-top: 20px;
        width: 100%;
    }

    .table thead th {
        background-color: #f4f4f4;
        color: #333;
    }
</style>
@stop
@section('javascript')
<script type="text/javascript">
    //Roles table
    $(document).ready(function() {
        var barcodeScannerButton = document.getElementById('barcode_scanner');
        barcodeScannerButton.addEventListener('click', function(event) {
            event.preventDefault();
            window.location.href = '/barcode/scan';
        });
        
        var users_table = $('#dashboard_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '/dashboard-vhomni',
            dom: '<lrf<t>ip',
            lengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, 'All']
            ],
            "columns": [{
                    "data": "name"
                },
                {
                    "data": "transaction_type"
                },
                {
                    "data": "credits"
                },
                {
                    "data": "remaining_credits"
                },
                {
                    "data": "description"
                },
                {
                    "data": "transaction_time"
                }
            ]
        });
    });
</script>
@endsection