@extends('layouts.app')
@section('title', __('lang_v1.omni_channel_services'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('lang_v1.omni_channel_services')</h1>
    <br>
    {{-- @include('layouts.partials.search_settings') --}}
</section>

<!-- Main content -->
<section class="content">
{!! Form::open(['url' => action([\App\Http\Controllers\OmniChannelServicesController::class, 'postOmniSettings']), 'method' => 'post', 'id' => 'omni_edit_form',
    'files' => true ]) !!}
    <div class="row">
        <div class="col-xs-12">
       <!--  <pos-tab-container> -->
        <div class="col-xs-12 pos-tab-container">
            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 pos-tab-menu">
                <div class="list-group">
                    {{-- @if ($e_commerce_default['big_commerce_enable'] == 1 || 
                            ($e_commerce_default['shopify_enable'] == 0 
                            && $e_commerce_default['woo_commerce_enable'] == 0 
                            && $e_commerce_default['magento_enable'] == 0)
                        )
                        <a href="#" class="list-group-item text-center active" onclick="getShowBtn('bigcommerce')">@lang('lang_v1.big_commerce')</a>
                    @else                            
                        <a href="#" class="list-group-item text-center" onclick="getShowBtn('bigcommerce')">@lang('lang_v1.big_commerce')</a>
                    @endif --}}
                    <a href="#" class="list-group-item text-center {{$e_commerce_default['shopify_enable'] == 1 ? 'active' : '' }}" onclick="getShowBtn('shopify')">@lang('lang_v1.shopify')</a>
                    {{-- <a href="#" class="list-group-item text-center {{$e_commerce_default['woo_commerce_enable'] == 1 ? 'active' : '' }}" onclick="getShowBtn('woocommerce')">@lang('lang_v1.woo_commerce')</a>
                    <a href="#" class="list-group-item text-center {{$e_commerce_default['magento_enable'] == 1 ? 'active' : '' }}" onclick="getShowBtn('magento')">@lang('lang_v1.magento')</a> --}}
                </div>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 pos-tab">
                <!-- tab 1 start -->
                {{-- @include('business.partials.settings_big_commerce')
                <div id="collapseFilterBigCommerce" class="panel-collapse active collapse " aria-expanded="true">
                    <div class="box-body">                                                      
                        <input type="checkbox" name="sync_settings_bigcommerce[one]" class="input-checkbox" value="1" id="sync_settings_bigcommerce_1">&nbsp;Update vhpos when an order created on BigCommerce
                        <br>
                        <input type="checkbox" name="sync_settings_bigcommerce[two]" class="input-checkbox" value="1" id="sync_settings_bigcommerce_2">&nbsp;Update BigCommerce when a product sold on vhpos
                        <br>
                        <input type="checkbox" name="sync_settings_bigcommerce[three]" class="input-checkbox" value="1" id="sync_settings_bigcommerce_3">&nbsp;Create a product on vhpos when a product is created on BigCommerce                            
                        <br>
                        <input type="checkbox" name="sync_settings_bigcommerce[four]" class="input-checkbox" value="1" id="sync_settings_bigcommerce_4">&nbsp;Update vhpos when a product is updated on BigCommerce            
                        <br>                                                                        
                        <input type="checkbox" name="sync_settings_bigcommerce[five]" class="input-checkbox" value="1" id="sync_settings_bigcommerce_5">&nbsp;Update BigCommerce when a product is update on vhpos                                                                                   
                    </div>
                </div> --}}
                <!-- tab 1 end -->
                <!-- tab 2 start -->
                @include('business.partials.settings_shopify')                
                <div id="collapseFilterShopify" class="panel-collapse collapse " aria-expanded="true">
                    <div class="box-body">                                                      
                        <input type="checkbox" name="sync_settings_shopify[one]" class="input-checkbox" value="1" id="sync_settings_shopify_1" @if($shopify_sync_settings) @if(property_exists($shopify_sync_settings, 'one')) @if ($shopify_sync_settings->one == 1)
                            checked
                        @endif @endif @endif>&nbsp;Update vhpos when an order created on Shopify
                        <br>
                        <input type="checkbox" name="sync_settings_shopify[two]" class="input-checkbox" value="1" id="sync_settings_shopify_2"
                        @if($shopify_sync_settings) @if(property_exists($shopify_sync_settings, 'two')) @if ($shopify_sync_settings->two == 1)
                            checked
                        @endif @endif @endif 
                        >&nbsp;Update Shopify when a product sold on vhpos
                        <br>
                        <input type="checkbox" name="sync_settings_shopify[three]" class="input-checkbox" value="1" id="sync_settings_shopify_3" 
                        @if($shopify_sync_settings) @if(property_exists($shopify_sync_settings, 'three')) @if ($shopify_sync_settings->three == 1)
                            checked
                        @endif @endif @endif>&nbsp;Create a product on vhpos when a product is created on Shopify                            
                        <br>
                        <input type="checkbox" name="sync_settings_shopify[four]" class="input-checkbox" value="1" id="sync_settings_shopify_4"
                        @if($shopify_sync_settings) @if(property_exists($shopify_sync_settings, 'four')) @if ($shopify_sync_settings->four == 1)
                            checked
                        @endif @endif @endif>&nbsp;Update vhpos when a product is updated on Shopify            
                        <br>                                                                        
                        <input type="checkbox" name="sync_settings_shopify[five]" class="input-checkbox" value="1" id="sync_settings_shopify_5"
                        @if($shopify_sync_settings) @if(property_exists($shopify_sync_settings, 'five')) @if ($shopify_sync_settings->five == 1)
                            checked
                        @endif @endif @endif>&nbsp;Update Shopify when a product is update on vhpos                                                                                   
                    </div>
                </div>
                {{-- @include('business.partials.settings_shopify_udb') --}}
                <!-- tab 2 end -->
                <!-- tab 3 start -->
                {{-- @include('business.partials.settings_woo_commerce')
                <div id="collapseFilterWooCommerce" class="panel-collapse active collapse " aria-expanded="true">
                    <div class="box-body">                                                      
                        <input type="checkbox" name="sync_settings_woocommerce[one]" class="input-checkbox" value="1" id="sync_settings_woocommerce_1">&nbsp;Update vhpos when an order created on WooCommerce
                        <br>
                        <input type="checkbox" name="sync_settings_woocommerce[two]" class="input-checkbox" value="1" id="sync_settings_woocommerce_2">&nbsp;Update WooCommerce when a product sold on vhpos
                        <br>
                        <input type="checkbox" name="sync_settings_woocommerce[three]" class="input-checkbox" value="1" id="sync_settings_woocommerce_3">&nbsp;Create a product on vhpos when a product is created on WooCommerce                            
                        <br>
                        <input type="checkbox" name="sync_settings_woocommerce[four]" class="input-checkbox" value="1" id="sync_settings_woocommerce_4">&nbsp;Update vhpos when a product is updated on WooCommerce            
                        <br>                                                                        
                        <input type="checkbox" name="sync_settings_woocommerce[five]" class="input-checkbox" value="1" id="sync_settings_woocommerce_5">&nbsp;Update WooCommerce when a product is update on vhpos                                                                                   
                    </div>
                </div> --}}
                <!-- tab 3 end -->
                <!-- tab 4 start -->
                {{-- @include('business.partials.settings_magento') --}}
                <!-- tab 4 end -->
            </div>
        </div>
        </div>
    </div>    
    <div class="row">
        <div class="col-sm-12">
            <button class="btn btn-danger pull-right" type="button" id="update_settings_btn">@lang('business.update_settings')</button>
            {{-- <button type="button" class="btn btn-primary btn-flat pull-right" id="shopify_test_btn">@lang('lang_v1.sync_shopify_data')</button>
            <button type="button" class="btn btn-primary btn-flat pull-right" id="bigcommerce_test_btn">@lang('lang_v1.sync_bigcommerce_data')</button>
            <button type="button" class="btn btn-primary btn-flat pull-right" id="woocommerce_test_btn">@lang('lang_v1.sync_woocommerce_data')</button> --}}
        </div>
    </div>
    <div class="row" style="margin-top: 20px;">        
        {{-- <div class="col-sm-12 bigcommerce_table">
            <table class="table table-bordered table-striped hide-footer" id="bigcommerce_table" style="width: 100%;">
                <thead>
                    <tr>                    
                        <th><input type="checkbox" id="select-all-row" data-table-id="bigcommerce_table"></th>
                        <th>&nbsp;</th>                    
                        <th>@lang('messages.action')</th>
                        <th>@lang('sale.product')</th>
                        <th>@lang('business.business_location') @show_tooltip(__('lang_v1.product_business_location_tooltip'))</th>
                        @can('access_default_selling_price')                      
                            <th>@lang('lang_v1.selling_price')</th>
                        @endcan
                        <th>@lang('report.total_stock')</th>
                        <th>@lang('product.category')</th>
                        <th>@lang('product.brand')</th>
                        <th>@lang('product.sku')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <div style="display: flex; width: 100%;">
                                @can('product.delete')
                                    <form></form>
                                    {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDestroy']), 'method' => 'post', 'id' => 'mass_delete_form_bigcommerce' ]); !!}
                                    {!! Form::hidden('selected_rows', null, ['id' => 'selected_rows_bigcommerce']); !!}
                                    {!! Form::submit(__('lang_v1.delete_selected'), array('class' => 'btn btn-xs btn-danger', 'id' => 'delete-selected-bigcommerce')); !!}
                                    {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))
                                @endcan
                
                                
                                    @can('product.update')
                                    
                                        @if(config('constants.enable_product_bulk_edit'))
                                            &nbsp;
                                            {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'bulkEdit']), 'method' => 'post', 'id' => 'bulk_edit_form' ]) !!}
                                            {!! Form::hidden('selected_products', null, ['id' => 'selected_products_for_edit']); !!}
                                            <button type="submit" class="btn btn-xs btn-primary" id="edit-selected"> <i class="fa fa-edit"></i>{{__('lang_v1.bulk_edit')}}</button>
                                            {!! Form::close() !!}
                                        @endif
                                        &nbsp;
                                        <button type="button" class="btn btn-xs btn-success update_product_location" data-type="add">@lang('lang_v1.add_to_location')</button>
                                        &nbsp;
                                        <button type="button" class="btn btn-xs bg-navy update_product_location" data-type="remove">@lang('lang_v1.remove_from_location')</button>
                                    @endcan
                                
                                &nbsp;
                                {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]); !!}
                                {!! Form::hidden('selected_products', null, ['id' => 'selected_products']); !!}
                                {!! Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')); !!}
                                {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))                            
                            </div>
                        </td>
                    </tr>
                </tfoot>
            </table>            
        </div> --}}    
        <div class="col-sm-12 shopify_table">
            <!-- @component('components.filters', ['title' => __('report.filters')]) -->
            <div class="box @if(!empty($class)) {{$class}} @else box-solid @endif" id="accordion">
                <div class="box-header with-border" style="cursor: pointer;">
                    <h3 class="box-title">
                        <a data-toggle="collapse" data-parent="#accordion" href="#collapseFilterShopify2">
                            @php $title= __('report.filters') . " (click here to open/close filters)"; @endphp
                            @if(!empty($icon)) {!! $icon !!} @else <i class="fa fa-filter" aria-hidden="true"></i> @endif {{$title ?? ''}}
                        </a>
                    </h3>                    
                </div>
                @php
                //if(isMobile()) { //PALIGU
                $closed = true;
                //}
                @endphp
                <div id="collapseFilterShopify2" class="panel-collapse active collapse @if(empty($closed)) in @endif" aria-expanded="true">
                    <div class="box-body">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="">@lang('business.business_locations') :</label>
                                <select class="filtervh" id="shopify_list_filter_location" style="width:100%" placeholder="@lang('lang_v1.all')">
                                    <option value="">@lang('lang_v1.all')</option>
                                    <option value="CheapBookDepot">Cheap Book Depot</option>
                                    <option value="UsedBookDepot">Used Book Depot</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="">@lang('product.category') :</label>
                                <select class="filtervh" id="shopify_list_filter_category" style="width:100%" placeholder="@lang('lang_v1.all')">
                                    <option value="">@lang('lang_v1.all')</option>
                                    @if(!empty($category_dropdown))
                                        @foreach ($category_dropdown as $item)
                                            <option value="{{ $item }}">{{ $item }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="">@lang('product.synced') :</label>
                                <select class="filtervh" id="shopify_list_filter_sync" style="width:100%" placeholder="@lang('lang_v1.all')">
                                    <option value="">@lang('lang_v1.all')</option>
                                    <option value="1">YES</option>
                                    <option value="0">NO</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>         
            @can('product.create')                            
                <a class="btn btn-primary pull-right" href="{{action([\App\Http\Controllers\ShopifyController::class, 'createShopifyProduct'])}}">
                            <i class="fa fa-plus"></i> @lang('product.add_product')</a>
                <br><br>
            @endcan
            <!-- @endcomponent -->
            <table class="table table-bordered table-striped ajax_view hide-footer jode" id="shopify_table" style="width: 100%;">
                <thead>
                    <tr>                
                        <th><input type="checkbox" id="select-all-row" data-table-id="shopify_table"></th>    
                        <th style="width: 20px" ;>@lang('messages.action')</th>
                        <th>@lang('lang_v1.image')</th>    
                        <!-- <th>@lang('messages.action')</th> -->
                        <th>@lang('sale.product')</th>
                        <th>@lang('business.business_location') @show_tooltip(__('lang_v1.product_business_location_tooltip'))</th>
                        @can('access_default_selling_price')                      
                            <th>@lang('lang_v1.selling_price')</th>
                        @endcan
                        <th>@lang('report.total_stock')</th>
                        <th>@lang('product.category')</th>
                        <th>@lang('product.barcode')</th>
                        <th>@lang('product.sku')</th>
                        <th>@lang('product.synced')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <button type="button" style="display: none" class="btn btn-xs btn-primary" id="label-queue" onclick="popupPrintLabelsQueue(event)"> <i class="fa fa-barcode"></i> {{__('barcode.print_queue_items')}} <span id="total_label_queue"></span></button>
                            <button type="button" class="btn btn-xs btn-primary" id="label-selected" onclick="printLabelMultiple(event)"> <i class="fa fa-barcode"></i> {{__('barcode.print_labels')}}</button>                                        
                            <button type="button" class="btn btn-xs btn-primary" id="qty-selected" onclick="popupSelectedItems(event)"> <i class="fa fa-database"></i> {{__('product.update_products')}}</button>        
                            <button type="button" class="btn btn-xs btn-primary" id="qty-selected" onclick="syncSelected(event)"> <i class="fa fa-sync"></i> {{__('product.sync_selected')}}</button>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>    
        {{-- <div class="col-sm-12 woocommerce_table">
            <table class="table table-bordered table-striped ajax_view hide-footer" id="woocommerce_table" style="width: 100%;">
                <thead>
                    <tr>                    
                        <th><input type="checkbox" id="select-all-row" data-table-id="woocommerce_table"></th>
                        <th>&nbsp;</th>           
                        <th>@lang('messages.action')</th>         
                        <th>@lang('sale.product')</th>
                        <th>@lang('business.business_location') @show_tooltip(__('lang_v1.product_business_location_tooltip'))</th>
                        @can('access_default_selling_price')                      
                            <th>@lang('lang_v1.selling_price')</th>
                        @endcan
                        <th>@lang('report.total_stock')</th>
                        <th>@lang('product.category')</th>
                        <th>@lang('product.brand')</th>
                        <th>@lang('product.sku')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <div style="display: flex; width: 100%;">
                                @can('product.delete')
                                    {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDestroy']), 'method' => 'post', 'id' => 'mass_delete_form_woocommerce' ]); !!}
                                    {!! Form::hidden('selected_rows', null, ['id' => 'selected_rows_woocommerce']); !!}
                                    {!! Form::submit(__('lang_v1.delete_selected'), array('class' => 'btn btn-xs btn-danger', 'id' => 'delete-selected-woocommerce')); !!}
                                    {!! Form::close(); !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))
                                @endcan
                
                                
                                    @can('product.update')
                                    
                                        @if(config('constants.enable_product_bulk_edit'))
                                            &nbsp;
                                            {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'bulkEdit']), 'method' => 'post', 'id' => 'bulk_edit_form' ]) !!}
                                            {!! Form::hidden('selected_products', null, ['id' => 'selected_products_for_edit']); !!}
                                            <button type="submit" class="btn btn-xs btn-primary" id="edit-selected"> <i class="fa fa-edit"></i>{{__('lang_v1.bulk_edit')}}</button>
                                            {!! Form::close() !!}
                                        @endif
                                        &nbsp;
                                        <button type="button" class="btn btn-xs btn-success update_product_location" data-type="add">@lang('lang_v1.add_to_location')</button>
                                        &nbsp;
                                        <button type="button" class="btn btn-xs bg-navy update_product_location" data-type="remove">@lang('lang_v1.remove_from_location')</button>
                                    @endcan
                                
                                &nbsp;
                                {!! Form::open(['url' => action([\App\Http\Controllers\ProductController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]) !!}
                                {!! Form::hidden('selected_products', null, ['id' => 'selected_products']); !!}
                                {!! Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')) !!}
                                {!! Form::close() !!} @show_tooltip(__('lang_v1.deactive_product_tooltip'))                                
                            </div>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div> --}}        
    </div>
{!! Form::close() !!}
</section>
<!-- /.content -->
@stop
@section('javascript')
<script type="text/javascript">
    var defaultTab = '';
    var shopify_enable = 0;
    var wooenable = 0;
    var magento_enable = 0;     
    const baseUrl = window.location.origin;
    $(document).on('change', '#shopify_list_filter_sync', function() {
        shopify_table.ajax.reload()
    });
    $(document).on('change', '#shopify_list_filter_location', function() {
        shopify_table.ajax.reload()
    });
    $(document).on('change', '#shopify_list_filter_category', function() {
        shopify_table.ajax.reload()
    });
    $(document).ready(function() {
        Pace.stop();
        var total_queue = localStorage.getItem('total_queue');
        if(total_queue > 0) {
            $('#label-queue').css('display', 'inline-block');
            $('#total_label_queue').html('(' + total_queue + ')');
        } else {
            $('#label-queue').css('display', 'none');
            $('#total_label_queue').html('(0)');
        }
        $('.select2.select2-container').css('width', '100%');
        $('#main-footer').css('display', 'none')
        var bigenable = $("input[type='radio'][name='big_commerce_enable']:checked").val()        
        if(bigenable == '1') {
            // console.log(bigenable == '1')
            if(bigenable == '1') {
                // bigcommerce
                $('#big_commerce_api_url').css('display', 'block')
                $('#big_commerce_api_access_token').css('display', 'block')
                $('#big_commerce_api_key').css('display', 'block')
                $('#big_commerce_api_secret').css('display', 'block')
                $("#big_commerce_space").addClass('col-sm-3')
                $("#location_big_commerce").css('display', 'block')
                $('#shopify_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'none')
                
                $('#shopify_api_url').css('display', 'none')
                $('#shopify_api_access_token').css('display', 'none')
                $('#shopify_api_key').css('display', 'none')
                $('#shopify_api_secret').css('display', 'none')
                // $('#shopify_space').removeClass('col-sm-3')   
                $('#location_shopify').css('display', 'none')         
                // $('#shopify_test_btn').css('display', 'none')
                // $('#bigcommerce_test_btn').css('display', 'none')
                
                $('#woo_commerce_api_url').css('display', 'none')
                $('#woo_commerce_api_access_token').css('display', 'none')
                $('#woo_commerce_api_key').css('display', 'none')
                $('#woo_commerce_api_secret').css('display', 'none')
                // $('#woo_commerce_space').removeClass('col-sm-3')
                // $('#shopify_test_btn').css('display', 'none')
                // $('#bigcommerce_test_btn').css('display', 'none')
                // $('#woo_commerce_enable').prop('checked', false);
                
                $('#magento_api_url').css('display', 'none')
                $('#magento_api_access_token').css('display', 'none')
                $('#magento_api_key').css('display', 'none')
                $('#magento_api_secret').css('display', 'none')
                // $('#magento_space').removeClass('col-sm-3')
                $('#shopify_test_btn').css('display', 'none')
                // $('#bigcommerce_test_btn').css('display', 'none')
                
                // get_input_data(bigenable, 'bigcommerce')
                $('#bigcommerce_test_btn').css('display', 'block')                
            } else {
                // big commerce
                $('#big_commerce_api_url').css('display', 'none')
                $('#big_commerce_api_access_token').css('display', 'none')
                $('#big_commerce_api_key').css('display', 'none')
                $('#big_commerce_api_secret').css('display', 'none')
                $("#big_commerce_space").removeClass('col-sm-3')
                // $("#location_big_commerce").css('display', 'none')
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')                             
                $('#woocommerce_test_btn').css('display', 'none')                             
            }

            // getShowBtn('bigcommerce')
            // $('#bigcommerce_enable').prop('checked', true);            
            $('#magento_space').addClass('col-sm-3')
            $('#woo_commerce_space').addClass('col-sm-3')
            $('.bigcommerce_table').removeClass('hide')
            $('.shopify_table').addClass('hide')
            $('.woocommerce_table').addClass('hide')

            defaultTab = 'bigcommerce';
        } else {
            shopifyenable = $("input[type='radio'][name='shopify_enable']:checked").val()
            if(shopifyenable == '1') {
                if(shopifyenable == '1') {
                    // shopify
                    $('#shopify_api_url').css('display', 'block')
                    $('#shopify_api_access_token').css('display', 'block')
                    $('#shopify_api_key').css('display', 'block')
                    $('#shopify_api_secret').css('display', 'block')
                    // $('#shopify_space').addClass('col-sm-3')            
                    $('#location_shopify').css('display', 'block')            
                    $('#shopify_test_btn').css('display', 'block')
                    $('#bigcommerce_test_btn').css('display', 'none')
                    $('#woocommerce_test_btn').css('display', 'none')

                    $('#big_commerce_api_url').css('display', 'none')
                    $('#big_commerce_api_access_token').css('display', 'none')
                    $('#big_commerce_api_key').css('display', 'none')
                    $('#big_commerce_api_secret').css('display', 'none')
                    // $('#big_commerce_space').removeClass('col-sm-3')   
                    $('#location_big_commerce').css('display', 'none')         
                    // $('#big_commerce_test_btn').css('display', 'none')
                    // $('#bigcommerce_test_btn').css('display', 'none')

                    $('#woo_commerce_api_url').css('display', 'none')
                    $('#woo_commerce_api_access_token').css('display', 'none')
                    $('#woo_commerce_api_key').css('display', 'none')
                    $('#woo_commerce_api_secret').css('display', 'none')
                    // $('#woo_commerce_space').removeClass('col-sm-3')
                    $('#shopify_test_btn').css('display', 'none')
                    // $('#bigcommerce_test_btn').css('display', 'none')
                    // $('#woo_commerce_enable').prop('checked', false);

                    $('#magento_api_url').css('display', 'none')
                    $('#magento_api_access_token').css('display', 'none')
                    $('#magento_api_key').css('display', 'none')
                    $('#magento_api_secret').css('display', 'none')
                    // $('#magento_space').removeClass('col-sm-3')
                    // $('#shopify_test_btn').css('display', 'none')
                    // $('#bigcommerce_test_btn').css('display', 'none')

                } else {
                    // shopify
                    $('#shopify_api_url').css('display', 'none')
                    $('#shopify_api_access_token').css('display', 'none')
                    $('#shopify_api_key').css('display', 'none')
                    $('#shopify_api_secret').css('display', 'none')
                    $('#shopify_space').removeClass('col-sm-3')   
                    $('#location_shopify').css('display', 'none')         
                    $('#shopify_test_btn').css('display', 'none')
                    $('#bigcommerce_test_btn').css('display', 'none')
                    $('#woocommerce_test_btn').css('display', 'none')
                    // $('#shopify_enable').prop('checked', false);
                }

                // getShowBtn('shopify')
                
                $('#magento_space').addClass('col-sm-3')
                $('#woo_commerce_space').addClass('col-sm-3')
                $('.bigcommerce_table').addClass('hide')
                $('.shopify_table').removeClass('hide')
                $('.woocommerce_table').addClass('hide')
                
            defaultTab = 'shopify';
            } else {
                wooenable = $("input[type='radio'][name='woo_commerce_enable']:checked").val()
                if(wooenable == '1') {                    
                    if(wooenable == '1') {
                        // woo commerce
                        $('#woo_commerce_api_url').css('display', 'block')
                        $('#woo_commerce_api_access_token').css('display', 'block')
                        $('#woo_commerce_api_key').css('display', 'block')
                        $('#woo_commerce_api_secret').css('display', 'block')
                        // $('#woo_commerce_space').addClass('col-sm-3')
                        $('#shopify_test_btn').css('display', 'none')
                        $('#bigcommerce_test_btn').css('display', 'none')
                        $('#woocommerce_test_btn').css('display', 'block')

                        $('#shopify_api_url').css('display', 'none')
                        $('#shopify_api_access_token').css('display', 'none')
                        $('#shopify_api_key').css('display', 'none')
                        $('#shopify_api_secret').css('display', 'none')
                        // $('#shopify_space').removeClass('col-sm-3')   
                        $('#location_shopify').css('display', 'none')         
                        // $('#shopify_test_btn').css('display', 'none')
                        // $('#bigcommerce_test_btn').css('display', 'none')

                        $('#big_commerce_api_url').css('display', 'none')
                        $('#big_commerce_api_access_token').css('display', 'none')
                        $('#big_commerce_api_key').css('display', 'none')
                        $('#big_commerce_api_secret').css('display', 'none')
                        // $('#big_commerce_space').removeClass('col-sm-3')
                        // $('#shopify_test_btn').css('display', 'none')
                        // $('#bigcommerce_test_btn').css('display', 'none')
                        // $('#big_commerce_enable').prop('checked', false);

                        $('#magento_api_url').css('display', 'none')
                        $('#magento_api_access_token').css('display', 'none')
                        $('#magento_api_key').css('display', 'none')
                        $('#magento_api_secret').css('display', 'none')
                        // $('#magento_space').removeClass('col-sm-3')
                        // $('#shopify_test_btn').css('display', 'none')
                        // $('#bigcommerce_test_btn').css('display', 'none')
            
                    } else {
                        // woo commerce
                        $('#woo_commerce_api_url').css('display', 'none')
                        $('#woo_commerce_api_access_token').css('display', 'none')
                        $('#woo_commerce_api_key').css('display', 'none')
                        $('#woo_commerce_api_secret').css('display', 'none')
                        $('#woo_commerce_space').removeClass('col-sm-3')
                        $('#shopify_test_btn').css('display', 'none')
                        $('#bigcommerce_test_btn').css('display', 'none')
                        $('#woocommerce_test_btn').css('display', 'none')
                        // $('#woo_commerce_enable').prop('checked', false);
                    }

                    // getShowBtn('woo_commerce')
                    $('#magento_space').addClass('col-sm-3')
                    $('#woo_commerce_space').addClass('col-sm-3')

                    $('.bigcommerce_table').addClass('hide')
                    $('.shopify_table').addClass('hide')
                    $('.woocommerce_table').removeClass('hide')
                    
                    defaultTab = 'woo_commerce';
                } else {
                    magentoenable = $("input[type='radio'][name='magento_enable']:checked").val()
                    if(magentoenable == '1') {
                        // magento
                        $('#magento_api_url').css('display', 'block')
                        $('#magento_api_access_token').css('display', 'block')
                        $('#magento_api_key').css('display', 'block')
                        $('#magento_api_secret').css('display', 'block')
                        // $('#magento_space').addClass('col-sm-3')
                        // $('#shopify_test_btn').css('display', 'none')
                        // $('#bigcommerce_test_btn').css('display', 'none')

                        $('#shopify_api_url').css('display', 'none')
                        $('#shopify_api_access_token').css('display', 'none')
                        $('#shopify_api_key').css('display', 'none')
                        $('#shopify_api_secret').css('display', 'none')
                        // $('#shopify_space').removeClass('col-sm-3')   
                        $('#location_shopify').css('display', 'none')         
                        // $('#shopify_test_btn').css('display', 'none')
                        // $('#bigcommerce_test_btn').css('display', 'none')

                        $('#woo_commerce_api_url').css('display', 'none')
                        $('#woo_commerce_api_access_token').css('display', 'none')
                        $('#woo_commerce_api_key').css('display', 'none')
                        $('#woo_commerce_api_secret').css('display', 'none')
                        // $('#woo_commerce_space').removeClass('col-sm-3')
                        $('#shopify_test_btn').css('display', 'none')
                        // $('#bigcommerce_test_btn').css('display', 'none')
                        // $('#woo_commerce_enable').prop('checked', false);

                        $('#big_commerce_api_url').css('display', 'none')
                        $('#big_commerce_api_access_token').css('display', 'none')
                        $('#big_commerce_api_key').css('display', 'none')
                        $('#big_commerce_api_secret').css('display', 'none')
                        // $('#big_commerce_space').removeClass('col-sm-3')
                        $('#shopify_test_btn').css('display', 'none')
                        $('#bigcommerce_test_btn').css('display', 'none')
                        $('#woocommerce_test_btn').css('display', 'none')
            
                    } else {
                        // magento
                        $('#magento_api_url').css('display', 'none')
                        $('#magento_api_access_token').css('display', 'none')
                        $('#magento_api_key').css('display', 'none')
                        $('#magento_api_secret').css('display', 'none')
                        $('#magento_space').removeClass('col-sm-3')
                        $('#shopify_test_btn').css('display', 'none')
                        $('#bigcommerce_test_btn').css('display', 'none')
                        $('#woocommerce_test_btn').css('display', 'none')
                        // $('#magento_enable').prop('checked', false);
                    }                    

                    // getShowBtn('magento')
                    $('.bigcommerce_table').addClass('hide')
                    $('.shopify_table').addClass('hide')
                    $('.woocommerce_table').addClass('hide')
                    defaultTab = 'magento';
                }
            }
        }

        shopify_table = $('#shopify_table').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [[1, 'asc']],
            pageLength: 15,
            lengthMenu: [15, 25, 50, 100],
            // scrollY: "75vh",
            // scrollX: true,
            // scrollCollapse: true                    
            "ajax": {
                "url": "/shopify/products",
                data: function(d) {
                    d.synced = $('#shopify_list_filter_sync').val()
                    d.category = $('#shopify_list_filter_category').val()
                    d.locations = $('#shopify_list_filter_location').val()
                }, 
            },                                     
            columnDefs: [ {
                "targets": [0, 1, 2],
                "orderable": false,
                "searchable": false
            }],
            columns: [                
                // { data: 'mass_delete', orderable: false, searchable: false},
                {
                    data: null,
                    orderable: false,
                    searchable: false,
                    width: '10px',
                    render: function(data) {
                        return '<input type="checkbox" class="row-select" value="'+data.id+'">'
                    }
                },
                {
                    data: null,
                    orderable: false,
                    searchable: false,
                    width: '20px',
                    render: function(data) {
                        return `<div class="btn-group"><button type="button" class="btn btn-info dropdown-toggle btn-xs" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"> </i><span class="caret"></span><span class="sr-only">Toggle Dropdown</span></button><ul class="dropdown-menu dropdown-menu-left" role="menu">
                            <li><a href="${baseUrl + '/shopify/labels/' + data.id}" data-toggle="tooltip" title="${LANG.label_help}"><i class="fa fa-barcode"></i> ${LANG.labels}</a></li>    
                            <li><a href="javascript:void(0)" onclick="addToPrintQueue(event, ${data.id})" data-toggle="tooltip" title="${LANG.add_to_print_queue}"><i class="fa fa-barcode"></i> ${LANG.add_to_print_queue}</a></li>    
                            <li><a href="javascript:void(0)" onclick="updateProductModal('${data.seller_sku}', 'qty')"><i class="fa fa-database"></i> ${LANG.update_listing_quantity}</a></li>    
                            <li><a href="javascript:void(0)" onclick="updateProductModal('${data.seller_sku}', 'price')"><i class="fa fa-database"></i> ${LANG.update_listing_price}</a></li>
                        </ul></div>`;
                    }
                },
                {
                    data: 'image',
                    name: 'image',
                    render: function(data, type, row) {
                        //console.log('Image data:', data);
                        //return data || 'N/A';
                        var image = data ? data : "{{ asset('img/no_img.png') }} "
                        return '<div style="display: flex;"><img src="' + image + '" alt="Product image" class="product-thumbnail-small"></div>';
                    }
                },   
                // { data: 'action', name: 'action', orderable: false, searchable: false},             
                { data: 'title', name: 'title'  },
                { data: 'vendor', name: 'vendor'},
                { data: 'price', name: 'price', searchable: false},
                { data: 'qty', searchable: false},
                { data: 'correct_category', name: 'correct_category'},
                { data: 'barcode', name: 'barcode'},                    
                { data: 'seller_sku', name: 'seller_sku'},                    
                { data: 'sync', name: 'sync'},                    
            ],
            createdRow: function(row, data, dataIndex) {
                $(row).attr('data-href', baseUrl + '/shopify/product/preview/modal/' + data.id); // Menambahkan atribut data-id
                $( row ).find('td:eq(0)').attr('class', 'selectable_td');
            },
        })

        bigcommerce_table = $('#bigcommerce_table').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [[1, 'asc']],
            // scrollY: "75vh",
            // scrollX: true,
            // scrollCollapse: true                    
            "ajax": {
                "url": "/products?vhomni_type=bigcommerce",
            },                          
            columnDefs: [ {
                "targets": [0, 1, 2],
                "orderable": false,
                "searchable": false
            }],
            columns: [                
                { data: 'mass_delete', orderable: false, searchable: false},
                { data: 'image_vhomni', name: 'products.image_vhomni', orderable: false, searchable: false},   
                { data: 'action', name: 'action', orderable: false, searchable: false},             
                { data: 'product', name: 'products.name'  },
                { data: 'product_locations', name: 'product_locations'},
                @can('access_default_selling_price')
                    { data: 'selling_price', name: 'max_price', searchable: false},
                @endcan
                { data: 'current_stock', searchable: false},
                { data: 'category', name: 'c1.name'},
                { data: 'brand', name: 'brands.name'},                    
                { data: 'sku', name: 'products.sku'},                    
            ],
        })

        woocommerce_table = $('#woocommerce_table').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [[1, 'asc']],
            // scrollY: "75vh",
            // scrollX: true,
            // scrollCollapse: true                    
            "ajax": {
                "url": "/products?vhomni_type=woocommerce",
            },                          
            columnDefs: [ {
                "targets": [0, 1],
                "orderable": false,
                "searchable": false
            }],
            columns: [                
                { data: 'mass_delete', orderable: false, searchable: false},
                { data: 'image_vhomni', name: 'products.image_vhomni', orderable: false, searchable: false},
                { data: 'action', name: 'action', orderable: false, searchable: false},                
                { data: 'product', name: 'products.name'  },
                { data: 'product_locations', name: 'product_locations'},
                @can('access_default_selling_price')
                    { data: 'selling_price', name: 'max_price', searchable: false},
                @endcan
                { data: 'current_stock', searchable: false},
                { data: 'category', name: 'c1.name'},
                { data: 'brand', name: 'brands.name'},                    
                { data: 'sku', name: 'products.sku'},                    
            ],
        })

        $('table#shopify_table tbody').on('click', 'a.delete-product', function(e){
            e.preventDefault();
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    var href = $(this).attr('href');
                    $.ajax({
                        method: "DELETE",
                        url: href,
                        dataType: "json",
                        beforeSend: function() {
                            $('#pos-loader').css('display', 'inline-flex')
                        },
                        success: function(result){
                            $('#pos-loader').css('display', 'none')
                            if(result.success == true){
                                toastr.success(result.msg);
                                shopify_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
        $('table#bigcommerce_table tbody').on('click', 'a.delete-product', function(e){
            e.preventDefault();
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    var href = $(this).attr('href');
                    $.ajax({
                        method: "DELETE",
                        url: href,
                        dataType: "json",
                        beforeSend: function() {
                            $('#pos-loader').css('display', 'inline-flex')
                        },
                        success: function(result){
                            $('#pos-loader').css('display', 'none')
                            if(result.success == true){
                                toastr.success(result.msg);
                                bigcommerce_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
        $('table#woocommerce_table tbody').on('click', 'a.delete-product', function(e){
            e.preventDefault();
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    var href = $(this).attr('href');
                    $.ajax({
                        method: "DELETE",
                        url: href,
                        dataType: "json",
                        beforeSend: function() {
                            $('#pos-loader').css('display', 'inline-flex')
                        },
                        success: function(result){
                            $('#pos-loader').css('display', 'none')
                            if(result.success == true){
                                toastr.success(result.msg);
                                woocommerce_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });        

        /* if($('.list-group-item.active').text() == 'Shopify') {
            if(shopifyenable == '1') {
                $('#shopify_test_btn').css('display', 'block')
            } else {
                $('#shopify_test_btn').css('display', 'none')
            }
        } */

        /* if($('.list-group-item.active').text() == 'BigCommerce') {
            if(bigenable == '1') {
                $('#bigcommerce_test_btn').css('display', 'block')
            } else {
                $('#bigcommerce_test_btn').css('display', 'none')
            }
        } */

        if(defaultTab == 'bigcommerce') {
            $("#shopify_enable[value='0']").prop('checked', true).trigger('change');
            $("#woo_commerce_enable[value='0']").prop('checked', true).trigger('change');
            $("#magento_enable[value='0']").prop('checked', true).trigger('change');
            $('#bigcommerce_test_btn').css('display', 'block')  
            $('.bigcommerce_table').removeClass('hide')
            $('.shopify_table').addClass('hide')
            $('.woocommerce_table').addClass('hide')
        } else if(defaultTab == 'shopify') {
            $("#big_commerce_enable[value='0']").prop('checked', true).trigger('change');
            $("#woo_commerce_enable[value='0']").prop('checked', true).trigger('change');
            $("#magento_enable[value='0']").prop('checked', true).trigger('change');
            $('#shopify_test_btn').css('display', 'block')
            $('.bigcommerce_table').addClass('hide')
            $('.shopify_table').removeClass('hide')
            $('.woocommerce_table').addClass('hide')  
        } else if(defaultTab == 'woo_commerce') {
            $("#shopify_enable[value='0']").prop('checked', true).trigger('change');
            $("#big_commerce_enable[value='0']").prop('checked', true).trigger('change');
            $("#magento_enable[value='0']").prop('checked', true).trigger('change');
            $('#woocommerce_test_btn').css('display', 'block')  
            $('.bigcommerce_table').addClass('hide')
            $('.shopify_table').addClass('hide')
            $('.woocommerce_table').removeClass('hide')
        } else {
            $("#big_commerce_enable[value='0']").prop('checked', true).trigger('change');
            $("#woo_commerce_enable[value='0']").prop('checked', true).trigger('change');
            $("#magento_enable[value='0']").prop('checked', true).trigger('change');
            $('.bigcommerce_table').addClass('hide')
            $('.shopify_table').addClass('hide')
            $('.woocommerce_table').addClass('hide')
        }
    }) 

    $('#delete-selected-shopify').on('click', function(e){
        e.preventDefault();
        var selected_rows = getSelectedRows();        
        if(selected_rows.length > 0){
            $('input#selected_rows_shopify').val(selected_rows);
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {      
                    $('#pos-loader').css('display', 'inline-flex');              
                    $('form#mass_delete_form_shopify').submit();
                }
            });
        } else{
            $('input#selected_rows_shopify').val('');
            swal('@lang("lang_v1.no_row_selected")');
        }    
    });

    $(document).on('click', '#delete-selected-bigcommerce', function(e){
        e.preventDefault();
        var selected_rows = getSelectedRows();
        
        if(selected_rows.length > 0){
            $('input#selected_rows_bigcommerce').val(selected_rows);
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $('#pos-loader').css('display', 'inline-flex');
                    $('form#mass_delete_form_bigcommerce').submit();
                }
            });
        } else{
            $('input#selected_rows_bigcommerce').val('');
            swal('@lang("lang_v1.no_row_selected")');
        }    
    });

    $(document).on('click', '#delete-selected-woocommerce', function(e){
        e.preventDefault();
        var selected_rows = getSelectedRows();
        
        if(selected_rows.length > 0){
            $('input#selected_rows_woocommerce').val(selected_rows);
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $('#pos-loader').css('display', 'inline-flex');
                    $('form#mass_delete_form_woocommerce').submit();
                }
            });
        } else{
            $('input#selected_rows_woocommerce').val('');
            swal('@lang("lang_v1.no_row_selected")');
        }    
    });

    function getShowBtn(tipe) {              
        // console.log(tipe)
        if(tipe == 'shopify' && $("#shopify_enable[value='1']").is(':checked')) {                          
            $('#shopify_test_btn').css('display', 'block')
            $('#bigcommerce_test_btn').css('display', 'none')
            $('#woocommerce_test_btn').css('display', 'none')
            $('.bigcommerce_table').addClass('hide')
            $('.shopify_table').removeClass('hide')
            $('.woocommerce_table').addClass('hide')
        } else if(tipe == 'bigcommerce' && $("#big_commerce_enable[value='1']").is(':checked')) {                
            $('#bigcommerce_test_btn').css('display', 'block')
            $('#shopify_test_btn').css('display', 'none')
            $('#woocommerce_test_btn').css('display', 'none')
            $('.bigcommerce_table').removeClass('hide')
            $('.shopify_table').addClass('hide')
            $('.woocommerce_table').addClass('hide')
        } else if(tipe == 'woocommerce' && $("#woo_commerce_enable[value='1']").is(':checked')) {
            // console.log('block')
            $('#bigcommerce_test_btn').css('display', 'none')
            $('#shopify_test_btn').css('display', 'none')
            $('#woocommerce_test_btn').css('display', 'block')
            $('.bigcommerce_table').addClass('hide')
            $('.shopify_table').addClass('hide')
            $('.woocommerce_table').removeClass('hide')
        } else {
            $('#bigcommerce_test_btn').css('display', 'none')
            $('#shopify_test_btn').css('display', 'none')
            $('#woocommerce_test_btn').css('display', 'none')
            $('.bigcommerce_table').addClass('hide')
            $('.shopify_table').addClass('hide')
            $('.woocommerce_table').addClass('hide')
        }
    }

    $('#shopify_test_btn').click(function () {
        //PALIGU
        // console.log('shopify test');
        $.ajax({
            method: 'GET',
            url: '/check-location-have-products',
            dataType: 'json',
            data: {
                location_id: $('#product_locations_shopify').val(),
                type: 'shopify'
            },
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex')
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none')
                if(result.rc == 1) {
                    swal({
                        title: 'Information',
                        text: "If you change SHOPIFY product location from "+result.location+" to "+$('#product_locations_shopify').find('option:selected').text()+", all product in "+result.location+" will be moved to "+$('#product_locations_shopify').find('option:selected').text()+"?",
                        icon: 'info',
                        buttons: {
                            cancel: "No",
                            confirm: "Yes"
                        }, 
                    }).then((confirmed) => {
                        if(confirmed) {
                            sync_shopify();
                        }
                    })
                } else if(result.rc == 2) {
                    swal({
                        title: 'Information',
                        text: result.rm,
                        icon: 'info',
                        // button: false,
                    })
                } else {                    
                    sync_shopify();
                }
            }
        }).fail(function(xhr, status, q) {
            Pace.stop();
            $('#pos-loader').css('display', 'none')
            // consoole.log(xhr.responseText)
            swal({
                title: 'Information',
                text: xhr.responseText,
                icon: 'info',
                // button: false,
            })
        });
    });

    function sync_shopify() {
        swal({
            title: 'Information',
            text: 'This Process May Take littler longer than regular sync process, Please do not CLOSE or REFRESH your browser during this process.',
            icon: 'info',
            buttons: {
                cancel: "CANCEL",
                confirm: "START SYNC"
            },                      
        }).then((confirmed) => {
            if (confirmed) {   
                $.ajax({
                    method: 'GET',
                    url: '/shopify-auth',
                    dataType: 'json',
                    data: {
                        product_locations: $('#product_locations_shopify').val(),
                        checkmarks: $("input[name='checkmarks_shopify[]']:checked").serializeArray()
                    },
                    beforeSend: function() {
                        $('#pos-loader').css('display', 'inline-flex')
                        // swal('Information', 'This process may take litle bit long time, please do not close or refresh the browser', 'info')
                    },
                    success: function (result) {
                        Pace.stop();
                        $('#pos-loader').css('display', 'none')
                        // console.log(result)
                        var message = '<p>'+result.message;
                        var icon = 'info'
                        var title = 'Information'
                        if(result.data) {
                            var inserted = 0;
                            var updated = 0;
                            $.each(result.data, function(k, v) {
                                $.each(v, function(k1, v1) {
                                    // console.log(v1)
                                    if(v1.status == 2) {
                                        updated++;
                                    } else {
                                        inserted++;
                                    }                        
                                })
                            })
    
                            message+= '<br>' + inserted + ' Products Imported and Created <br>' + updated + ' Products Updated and Synced</p>';
    
                            icon = 'success'
                            title = 'Success'
                        } 
                        var msg = document.createElement('div');
                        msg.innerHTML = message;
                        swal({
                            title: title,                            
                            content: msg,
                            icon: icon,
                            // buttons: true,
                            dangerMode: true,
                        })               
                        shopify_table.ajax.reload();
                    },
                }).fail(function(xhr, status, q) {
                    Pace.stop();
                    $('#pos-loader').css('display', 'none')
                    // alert(xhr.responseText)            
                    swal({
                        title: 'Information',
                        text: xhr.responseText,
                        icon: 'info',
                        // buttons: false,
                    })
                });
                //Commented by Paligu
            }
        });
    }

    $('#bigcommerce_test_btn').click(function () {
        $.ajax({
            method: 'GET',
            url: '/check-location-have-products',
            dataType: 'json',
            data: {
                location_id: $('#product_locations_big_commerce').val(),
                type: 'bigcommerce'
            },
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex')
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none')
                if(result.rc == 1) {
                    swal({
                        title: 'Information',
                        text: "If you change BIGCOMMERCE product location from "+result.location+" to "+$('#product_locations_big_commerce').find('option:selected').text()+", all product in "+result.location+" will be moved to "+$('#product_locations_big_commerce').find('option:selected').text()+"?",
                        icon: 'info',
                        buttons: {
                            cancel: "No",
                            confirm: "Yes"
                        }, 
                    }).then((confirmed) => {
                        if(confirmed) {
                            sync_bigcommerce();
                        }
                    })
                } else if(result.rc == 2) {
                    swal({
                        title: 'Information',
                        text: result.rm,
                        icon: 'info',
                        // button: false,
                    })
                } else {                    
                    sync_bigcommerce();
                }
            }
        }).fail(function(xhr, status, q) {
            Pace.stop();
            $('#pos-loader').css('display', 'none')
            // consoole.log(xhr.responseText)
            swal({
                title: 'Information',
                text: xhr.responseText,
                icon: 'info',
                // button: false,
            })
        });
    });

    function sync_bigcommerce() {
        //ADRI
        // console.log('shopify test');
        swal({
            title: 'Information',
            text: 'This Process May Take littler longer than regular sync process, Please do not CLOSE or REFRESH your browser during this process.',
            icon: 'info',
            buttons: {
                cancel: "CANCEL",
                confirm: "START SYNC"
            },                      
        }).then((confirmed) => {
            if (confirmed) {    
                $.ajax({
                    method: 'GET',
                    url: '/bigcommerce-auth',
                    dataType: 'json',
                    data: {
                        product_locations: $('#product_locations_big_commerce').val(),
                        checkmarks: $("input[name='checkmarks_bigcommerce[]']:checked").serializeArray()
                    },
                    beforeSend: function() {
                        $('#pos-loader').css('display', 'inline-flex')
                        // swal('Information', 'This process may take litle bit long time, please do not close or refresh the browser', 'info')
                    },
                    success: function (result) {                        
                        Pace.stop();
                        $('#pos-loader').css('display', 'none')
                        // console.log(result) 
                        var message = '<p>'+result.message;
                        var icon = 'info'
                        var title = 'Information'
                        if(result.data) {
                            var inserted = 0;
                            var updated = 0;
                            $.each(result.data, function(k, v) {
                                $.each(v, function(k1, v1) {
                                    console.log(v1)
                                    if(v1.status == 2) {
                                        updated++;
                                    } else {
                                        inserted++;
                                    }                        
                                })
                            })

                            message+= '<br>' + inserted + ' Products Imported and Created <br>' + updated + ' Products Updated and Synced</p>';

                            icon = 'success'
                            title = 'Success'
                        } 
                        var msg = document.createElement('div');
                        msg.innerHTML = message;
                        swal({
                            title: title,                            
                            content: msg,
                            icon: icon,
                            // buttons: true,
                            dangerMode: true,
                        })           
                        bigcommerce_table.ajax.reload();     
                    },
                }).fail(function(xhr, status, q) {
                    Pace.stop();
                    $('#pos-loader').css('display', 'none')
                    // consoole.log(xhr.responseText)
                    swal({
                        title: 'Information',
                        text: xhr.responseText,
                        icon: 'info',
                        // button: false,
                    })
                });
            }
        });
        //Commented by Adri
    }

    $('#woocommerce_test_btn').click(function () {
        //ADRI
        // console.log('shopify test');
        $.ajax({
            method: 'GET',
            url: '/check-location-have-products',
            dataType: 'json',
            data: {
                location_id: $('#product_locations_woo_commerce').val(),
                type: 'woocommerce'
            },
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex')
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none')
                if(result.rc == 1) {
                    swal({
                        title: 'Information',
                        text: "If you change WOOCOMMERCE product location from "+result.location+" to "+$('#product_locations_woo_commerce').find('option:selected').text()+", all product in "+result.location+" will be moved to "+$('#product_locations_woo_commerce').find('option:selected').text()+"?",
                        icon: 'info',
                        buttons: {
                            cancel: "No",
                            confirm: "Yes"
                        }, 
                    }).then((confirmed) => {
                        if(confirmed) {
                            sync_woocommerce();
                        }
                    })
                } else if(result.rc == 2) {
                    swal({
                        title: 'Information',
                        text: result.rm,
                        icon: 'info',
                        // button: false,
                    })
                } else {                    
                    sync_woocommerce();
                }
            }
        }).fail(function(xhr, status, q) {
            Pace.stop();
            $('#pos-loader').css('display', 'none')
            // consoole.log(xhr.responseText)
            swal({
                title: 'Information',
                text: xhr.responseText,
                icon: 'info',
                // button: false,
            })
        });
    });

    function sync_woocommerce() {
        swal({
            title: 'Information',
            text: 'This Process May Take littler longer than regular sync process, Please do not CLOSE or REFRESH your browser during this process.',
            icon: 'info',
            buttons: {
                cancel: "CANCEL",
                confirm: "START SYNC"
            },                      
        }).then((confirmed) => {
            if (confirmed) {            
                $.ajax({
                    method: 'GET',
                    url: '/woocommerce-auth',
                    dataType: 'json',
                    data: {
                        product_locations: $('#product_locations_woo_commerce').val(),
                        checkmarks: $("input[name='checkmarks_woocommerce[]']:checked").serializeArray()
                    },
                    beforeSend: function() {
                        $('#pos-loader').css('display', 'inline-flex')
                        // swal('Information', 'This process may take litle bit long time, please do not close or refresh the browser', 'info')
                    },
                    success: function (result) {
                        Pace.stop();
                        $('#pos-loader').css('display', 'none')
                        // console.log(result)                         
                        var message = '<p>'+result.message;
                        var icon = 'info'
                        var title = 'Information'
                        if(result.data) {
                            var inserted = 0;
                            var updated = 0;
                            $.each(result.data, function(k, v) {
                                $.each(v, function(k1, v1) {
                                    console.log(v1)
                                    if(v1.status == 2) {
                                        updated++;
                                    } else {
                                        inserted++;
                                    }                        
                                })
                            })

                            message+= '<br>' + inserted + ' Products Imported and Created <br>' + updated + ' Products Updated and Synced</p>';

                            icon = 'success'
                            title = 'Success'
                        } 
                        var msg = document.createElement('div');
                        msg.innerHTML = message;
                        swal({
                            title: title,                            
                            content: msg,
                            icon: icon,
                            // buttons: true,
                            dangerMode: true,
                        })           
                        woocommerce_table.ajax.reload()    
                    },
                }).fail(function(xhr, status, q) {
                    Pace.stop();
                    $('#pos-loader').css('display', 'none')
                    // consoole.log(xhr.responseText)
                    swal({
                        title: 'Information',
                        text: xhr.responseText,
                        icon: 'info',
                        // button: false,
                    })
                });
                //Commented by Adri
            }
        });
    }

    $('#update_settings_btn').click(function() {
        swal({
            title: "ATTENTION",
            text: 'Are you sure you want to make this change and apply the settings?',  
            buttons: ['No', 'Yes'],
            icon: "info"          
        }).then((confirm) => {
            if(confirm) {
                var form = $("#omni_edit_form");                
                form.submit();
            }
        })
    })

    function get_input(val, tipe) {
        // var next = true;        
        if(defaultTab != tipe && val == '1') {
            var text = '';
            var defaultText = '';
            if(tipe == 'bigcommerce') {
                text = "Big Commerce";
            } else if(tipe == 'shopify') {
                text = "Shopify";
            } else if(tipe == 'woo_commerce') {
                text = "Woo Commerce";
            } else if(tipe == 'magento') {
                text = "Magento"
            }
            if(defaultTab == 'bigcommerce') {
                defaultText = "Big Commerce";
            } else if(defaultTab == 'shopify') {
                defaultText = "Shopify";
            } else if(defaultTab == 'woo_commerce') {
                defaultText = "Woo Commerce";
            } else if(defaultTab == 'magento') {
                defaultText = "Magento"
            }
            swal({
                title: 'ATTENTION',
                text: 'You can only have one E-Commerce account associated to your VH-POS subscription, Would you like to disable ' + defaultText + ' and start to sync with ' + text + ' ?', 
                icon: 'info',
                buttons: ['No', 'Yes']
            }).then((confirm) => {
                if(confirm) {                    
                    if(tipe == 'bigcommerce') {
                        defaultTab = 'bigcommerce';                  
                        $("#shopify_enable[value='0']").prop('checked', true).trigger('change');
                        $("#woo_commerce_enable[value='0']").prop('checked', true).trigger('change');
                        $("#magento_enable[value='0']").prop('checked', true).trigger('change');
                        get_input_data(0, 'shopify')
                        get_input_data(0, 'woo_commerce')
                        get_input_data(0, 'magento')
                        get_input_data(1, 'bigcommerce')
                        // $("#big_commerce_enable[value='1']").prop('checked', true).trigger('change');
                    } 
                    
                    if(tipe == 'shopify') {                        
                        // $("#shopify_enable[value='1']").prop('checked', true).trigger('change');
                        $("#big_commerce_enable[value='0']").prop('checked', true).trigger('change');
                        $("#woo_commerce_enable[value='0']").prop('checked', true).trigger('change');
                        $("#magento_enable[value='0']").prop('checked', true).trigger('change');
                        get_input_data(0, 'bigcommerce')
                        get_input_data(0, 'woo_commerce')
                        get_input_data(0, 'magento')
                        get_input_data(1, 'shopify')
                        defaultTab = 'shopify';
                    } 
                    if(tipe == 'woo_commerce') {                        
                        // $("#woo_commerce_enable[value='1']").prop('checked', true).trigger('change');
                        $("#shopify_enable[value='0']").prop('checked', true).trigger('change');
                        $("#big_commerce_enable[value='0']").prop('checked', true).trigger('change');
                        $("#magento_enable[value='0']").prop('checked', true).trigger('change');
                        get_input_data(0, 'shopify')
                        get_input_data(0, 'bigcommerce')
                        get_input_data(0, 'magento')
                        get_input_data(1, 'woo_commerce')
                        defaultTab = 'woo_commerce';
                    } 
                    if(tipe == 'magento') {                        
                        $("#woo_commerce_enable[value='0']").prop('checked', true).trigger('change');
                        // $("#woo_commerce_enable[value='1']").prop('checked', true).trigger('change');
                        $("#shopify_enable[value='0']").prop('checked', true).trigger('change');
                        $("#big_commerce_enable[value='0']").prop('checked', true).trigger('change');
                        get_input_data(0, 'shopify')
                        get_input_data(0, 'bigcommerce')
                        get_input_data(0, 'woo_commerce')
                        get_input_data(1, 'magento')
                        defaultTab = 'magento';
                    }                    
                } else {
                    if(tipe == 'bigcommerce') {
                        $("#big_commerce_enable[value='0']").prop('checked', true).trigger('change');                    
                    } else if(tipe == 'shopify') {                        
                        $("#shopify_enable[value='0']").prop('checked', true).trigger('change');
                    } else if(tipe == 'woo_commerce') {                        
                        $("#woo_commerce_enable[value='0']").prop('checked', true).trigger('change');
                    } else if(tipe == 'magento') {                        
                        $("#magento_enable[value='0']").prop('checked', true).trigger('change');
                    }
                }
            })            
        } else {
            get_input_data(val, tipe)
        }
    }

    function get_input_data(val, tipe) {
        if(val == '1') {                        
            if(tipe == 'bigcommerce') {
                // bigcommerce
                $('#big_commerce_api_url').css('display', 'block')
                $('#big_commerce_api_access_token').css('display', 'block')
                $('#big_commerce_api_key').css('display', 'block')
                $('#big_commerce_api_secret').css('display', 'block')
                $("#big_commerce_space").addClass('col-sm-3')
                $("#location_big_commerce").css('display', 'block')
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'block')    
                $('#woocommerce_test_btn').css('display', 'none')    
                $('.bigcommerce_table').removeClass('hide')
                $('.shopify_table').addClass('hide')
                $('.woocommerce_table').addClass('hide')
                
                // $('#shopify_enable').prop('change', false).trigger('click')
            }
            if(tipe == 'shopify') {
                // shopify
                $('#shopify_api_url').css('display', 'block')
                $('#shopify_api_access_token').css('display', 'block')
                $('#shopify_api_key').css('display', 'block')
                $('#shopify_api_secret').css('display', 'block')
                $('#shopify_space').addClass('col-sm-3')             
                $('#location_shopify').css('display', 'block')   
                $('#shopify_test_btn').css('display', 'block')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'none')
                $('.bigcommerce_table').addClass('hide')
                $('.shopify_table').removeClass('hide')
                $('.woocommerce_table').addClass('hide')
                // $('#shopify_enable').prop('change', false).trigger('click')
            }
            if(tipe == 'woo_commerce') {
                // woo commerce
                $('#woo_commerce_api_url').css('display', 'block')
                $('#woo_commerce_api_access_token').css('display', 'block')
                $('#woo_commerce_api_key').css('display', 'block')
                $('#woo_commerce_api_secret').css('display', 'block')
                $('#woo_commerce_space').addClass('col-sm-3')
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'block')
                $('.bigcommerce_table').addClass('hide')
                $('.shopify_table').addClass('hide')
                $('.woocommerce_table').removeClass('hide')
            }
            if(tipe == 'magento') {
                // magento
                $('#magento_api_url').css('display', 'block')
                $('#magento_api_access_token').css('display', 'block')
                $('#magento_api_key').css('display', 'block')
                $('#magento_api_secret').css('display', 'block')
                $('#magento_space').addClass('col-sm-3')
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('.bigcommerce_table').addClass('hide')
                $('.shopify_table').addClass('hide')
                $('.woocommerce_table').addClass('hide')
            }

            if($('.list-group-item.active').text() == 'Shopify') {
                $('#shopify_test_btn').css('display', 'block')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'none')
                $('.bigcommerce_table').addClass('hide')
                $('.shopify_table').removeClass('hide')
                $('.woocommerce_table').addClass('hide')
            }
            
            if($('.list-group-item.active').text() == 'BigCommerce') {
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'block')
                $('#woocommerce_test_btn').css('display', 'none')
                $('.bigcommerce_table').removeClass('hide')
                $('.shopify_table').addClass('hide')
                $('.woocommerce_table').addClass('hide')                
            }          

            if($('.list-group-item.active').text() == 'WooCommerce') {
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'block')
                $('.bigcommerce_table').addClass('hide')
                $('.shopify_table').addClass('hide')
                $('.woocommerce_table').removeClass('hide')
            }            
        } else {
            if(tipe == 'bigcommerce') {
                // big commerce
                $('#big_commerce_api_url').css('display', 'none')
                $('#big_commerce_api_access_token').css('display', 'none')
                $('#big_commerce_api_key').css('display', 'none')
                $('#big_commerce_api_secret').css('display', 'none')
                $("#big_commerce_space").removeClass('col-sm-3')
                $("#location_big_commerce").css('display', 'none')
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'none')
                $('.bigcommerce_table').addClass('hide')                
            }
            if(tipe == 'shopify') {
                // shopify
                $('#shopify_api_url').css('display', 'none')
                $('#shopify_api_access_token').css('display', 'none')
                $('#shopify_api_key').css('display', 'none')
                $('#shopify_api_secret').css('display', 'none')
                $('#shopify_space').removeClass('col-sm-3')   
                $('#location_shopify').css('display', 'none')             
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'none')                
                $('.shopify_table').addClass('hide')                
            }
            if(tipe == 'woo_commerce') {
                // woo commerce
                $('#woo_commerce_api_url').css('display', 'none')
                $('#woo_commerce_api_access_token').css('display', 'none')
                $('#woo_commerce_api_key').css('display', 'none')
                $('#woo_commerce_api_secret').css('display', 'none')
                $('#woo_commerce_space').removeClass('col-sm-3')
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'none')
                $('.woocommerce_table').addClass('hide')
            }
            if(tipe == 'magento') {
                // magento
                $('#magento_api_url').css('display', 'none')
                $('#magento_api_access_token').css('display', 'none')
                $('#magento_api_key').css('display', 'none')
                $('#magento_api_secret').css('display', 'none')
                $('#magento_space').removeClass('col-sm-3')
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'none')
                $('.bigcommerce_table').addClass('hide')
                $('.shopify_table').addClass('hide')
                $('.woocommerce_table').addClass('hide')
            }

            if($('.list-group-item.active').text() == 'Shopify') {
                $('#shopify_test_btn').css('display', 'none')
                $('#bigcommerce_test_btn').css('display', 'none')                
                $('.shopify_table').addClass('hide')                
            }

            if($('.list-group-item.active').text() == 'BigCommerce') {
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#shopify_test_btn').css('display', 'none')
                $('.bigcommerce_table').addClass('hide')            
            }

            if($('.list-group-item.active').text() == 'WooCommerce') {
                $('#bigcommerce_test_btn').css('display', 'none')
                $('#shopify_test_btn').css('display', 'none')
                $('#woocommerce_test_btn').css('display', 'none')                
                $('.woocommerce_table').addClass('hide')
            }
        }
    }

    function printLabelMultiple(e) {        
        e.preventDefault();
        var selected_rows = getSelectedRows();                        
        if(selected_rows.length > 0){
            var query = {
                products: selected_rows
            };
            // Buat URL query string
            let params = new URLSearchParams();
            selected_rows.forEach(p => params.append('products[]', p));
    
            // Redirect
            window.location.href = baseUrl + '/shopify/labels/multiple?' + params.toString();       
        } else {
            $('input#selected_products').val('');
            swal('@lang("lang_v1.no_row_selected")');
        }
    }

    function updateProductModal(sku, type) {
        $.ajax({
            url: baseUrl + '/shopify/update-product/modal/' + sku + '?type=' + type,
            dataType: 'html',
            success: function(result) {
                // console.log(result);
                $('.view_modal')
                    .html(result)
                    .modal('show');
                $('#refresh-competitive-price').attr('disabled', true);
            },
        });
    }

    function updateQuantityApi(e) {
        e.preventDefault();
        var sku = $('#sku').val()
        // var old_quantity = $('#old_quantity').val()
        var quantity = $('#quantity').val()
        $.ajax({
            method: 'GET',
            url: baseUrl + '/shopify/update-quantity-api/' + sku + '/' + quantity + '?credit=-10',
            dataType: 'json',
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex')
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none')
                $('.view_modal').modal('hide');
                if (result.errors) {
                    var errors = result.errors ? result.errors[0].message : 'Quantity failed to update'
                    swal({
                        title: 'Information',
                        text: errors,
                        icon: 'info',
                        // buttons: false,
                    })
                } else {
                    swal({
                        title: 'Success',
                        text: 'Update Quantity successfully',
                        icon: 'success',
                        // buttons: false,
                    })
                    shopify_table.ajax.reload()
                }
            },
        }).fail(function(xhr, status, q) {
            $('.view_modal').modal('hide');
            $('#pos-loader').css('display', 'none')
            // alert(xhr.responseText)            
            swal({
                title: 'Information',
                text: xhr.responseText,
                icon: 'info',
                // buttons: false,
            })
        });
    }

    function updatePriceApi(e) {
        e.preventDefault();
        var sku = $('#sku').val()
        var price = $('#price').val()
        $.ajax({
            method: 'GET',
            url: baseUrl + '/shopify/update-price-api/' + sku + '/' + price + '?credit=-10',
            dataType: 'json',
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex')
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none')
                $('.view_modal').modal('hide');
                if (result.errors) {
                    var errors = result.errors ? result.errors[0].message : 'Price failed to update'
                    swal({
                        title: 'Information',
                        text: errors,
                        icon: 'info',
                        // buttons: false,
                    })
                } else {
                    swal({
                        title: 'Success',
                        text: 'Update Price successfully',
                        icon: 'success',
                        // buttons: false,
                    })
                    shopify_table.ajax.reload()
                }
            },
        }).fail(function(xhr, status, q) {
            $('.view_modal').modal('hide');
            $('#pos-loader').css('display', 'none')
            // alert(xhr.responseText)            
            swal({
                title: 'Information',
                text: xhr.responseText,
                icon: 'info',
                // buttons: false,
            })
        });
    }

    function popupSelectedItems(e) {
        e.preventDefault()
        var selected_rows = getSelectedRows();
            
        if(selected_rows.length > 0){
            $.ajax({
                url: baseUrl + '/shopify/popupSelectedItems',
                data: {
                    selected_rows: selected_rows
                },
                dataType: 'html',
                success: function(result) {
                    // console.log(result);
                    $('.view_modal')
                        .html(result)
                        .modal('show');
                },
            });
        } else {
            $('input#selected_products').val('');
            swal('@lang("lang_v1.no_row_selected")');
        }
    }

    function syncSelected(e) {
        e.preventDefault()
        var selected_rows = getSelectedRows();
        if(selected_rows.length > 0){
            $.ajax({
                method: 'POST',
                url: baseUrl + '/shopify/send-to-shopify',
                data: {
                    selected_rows: selected_rows
                },
                dataType: 'json',
                beforeSend: function() {
                    $('#pos-loader').css('display', 'inline-flex')
                },
                success: function(result) {
                    // console.log(result);                    
                    $('#pos-loader').css('display', 'none')
                    if(result.rc == 200) {
                        var msg = '';
                        $.each(result.data, function(k,v) {
                            var send_result = 'failed Send To Shopify';
                            if(v.productId) {
                                send_result = 'Successfully Send To Shopify';
                            }
                            msg += v.product + ' - ' + send_result + '\n';
                        })

                        swal({
                            title: 'Success',
                            text: msg,
                            icon: 'success',
                        })
                        shopify_table.ajax.reload()
                    } else {
                        swal({
                            title: 'Failed',
                            text: result.rm,
                            icon: 'danger',
                        })
                    }
                },
            }).fail(function(xhr, status, q) {                
                $('#pos-loader').css('display', 'none')
                // alert(xhr.responseText)            
                swal({
                    title: 'Information',
                    text: xhr.responseText,
                    icon: 'info',
                    // buttons: false,
                })
            });;
        } else {
            $('input#selected_products').val('');
            swal('@lang("lang_v1.no_row_selected")');
        }
    }

    function updateOnAllShopify(e)
    {
        e.preventDefault();
        var form = document.getElementById('form-selected-items');
        var objData = new FormData(form);
        $.ajax({
            method: 'POST',
            url: baseUrl + '/shopify/updateOnAllShopify',
            data: objData,
            dataType: 'json',
            processData: false,     // << Prevent jQuery from processing the data
            contentType: false,     // << Prevent jQuery from setting Content-Type
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex')
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none')
                $('.view_modal').modal('hide');
                if(result.rc == 500) {
                    swal({
                        title: 'Failed',
                        text: result.message,
                        icon: 'danger',
                        // buttons: false,
                    })
                } else {
                    swal({
                        title: 'Success',
                        text: result.message,
                        icon: 'success',
                        // buttons: false,
                    })
                    shopify_table.ajax.reload()
                }
            },
        }).fail(function(xhr, status, q) {
            $('.view_modal').modal('hide');
            $('#pos-loader').css('display', 'none')
            // alert(xhr.responseText)            
            swal({
                title: 'Information',
                text: xhr.responseText,
                icon: 'info',
                // buttons: false,
            })
        });
    }

    function addToPrintQueue(e, id) {
        e.preventDefault();        
        var objData = new FormData();
        objData.append('reference_id', id);
        objData.append('reference_table', 'shopify_table');
        $.ajax({
            method: 'POST',
            url: baseUrl + '/labels/add-to-print-label-queue',
            data: objData,
            dataType: 'json',
            processData: false,     // << Prevent jQuery from processing the data
            contentType: false,     // << Prevent jQuery from setting Content-Type
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex')
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none')
                $('.view_modal').modal('hide');
                if(result.rc == 500) {
                    swal({
                        title: 'Failed',
                        text: result.rm,
                        icon: 'danger',
                        // buttons: false,
                    })
                } else if(result.rc == 1) {
                    // swal({
                    //     title: 'Success',
                    //     text: result.rm,
                    //     icon: 'success',
                    //     // buttons: false,
                    // })
                    localStorage.setItem('total_queue', result.total_queue);
                    $('#total_label_queue').html('('+result.total_queue+')');
                    $('#label-queue').css('display', 'inline-block');
                } else {
                    swal({
                        title: 'Information',
                        text: result.rm,
                        icon: 'info',
                        // buttons: false,
                    })
                }
            },
        }).fail(function(xhr, status, q) {
            $('.view_modal').modal('hide');
            $('#pos-loader').css('display', 'none')
            // alert(xhr.responseText)            
            swal({
                title: 'Information',
                text: xhr.responseText,
                icon: 'info',
                // buttons: false,
            })
        });
    }

    function popupPrintLabelsQueue(e) {
        e.preventDefault()
        $.ajax({
            url: baseUrl + '/labels/popupPrintLabelsQueue',
            data: {                                
                reference_table: 'shopify_table'
            },
            dataType: 'html',
            success: function(result) {
                // console.log(result);
                $('.view_modal')
                    .html(result)
                    .modal('show');
            },
        });
    }

    function removeItemPrintLabelsQueue(e, id) {
        e.preventDefault();

        var objData = new FormData();
        objData.append('reference_id', id);
        objData.append('reference_table', 'shopify_table');
        $.ajax({
            method: 'POST',
            url: baseUrl + '/labels/delete-item-print-label-queue',
            data: objData,
            dataType: 'json',
            processData: false,     // << Prevent jQuery from processing the data
            contentType: false,     // << Prevent jQuery from setting Content-Type
            beforeSend: function() {
                $('#pos-loader').css('display', 'inline-flex')
            },
            success: function(result) {
                $('#pos-loader').css('display', 'none')
                $('.view_modal').modal('hide');
                if(result.rc == 500) {
                    swal({
                        title: 'Failed',
                        text: result.rm,
                        icon: 'danger',
                        // buttons: false,
                    })
                } else if(result.rc == 1) {
                    // swal({
                    //     title: 'Success',
                    //     text: result.rm,
                    //     icon: 'success',
                    //     // buttons: false,
                    // })
                    localStorage.setItem('total_queue', result.total_queue);
                    $('#total_label_queue').html('('+result.total_queue+')');
                    $('#label-queue').css('display', 'inline-block');
                    $('.view-modal').modal('hide');
                    setTimeout(() => {                        
                        popupPrintLabelsQueue(e);
                    }, 500);
                } else {
                    swal({
                        title: 'Information',
                        text: result.rm,
                        icon: 'info',
                        // buttons: false,
                    })
                }
            },
        }).fail(function(xhr, status, q) {
            $('.view_modal').modal('hide');
            $('#pos-loader').css('display', 'none')
            // alert(xhr.responseText)            
            swal({
                title: 'Information',
                text: xhr.responseText,
                icon: 'info',
                // buttons: false,
            })
        });
    }

    function printLabelsQueue(e) {
        let productIds = $("input[name='products_label_queue[]']").map(function () {
            return $(this).val();
        }).get();

        var query = {
            products: productIds
        };
        // Buat URL query string
        let params = new URLSearchParams();
        // params.append('seller_id', seller_id);
        productIds.forEach(p => params.append('products[]', p));
        
        // Redirect
        window.location.href = baseUrl + '/shopify/labels/multiple?' + params.toString();   
    }
</script>
@endsection