@extends('layouts.app')
@section('title', __('lang_v1.omni_channel_services'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('lang_v1.omni_channel_services')</h1>
    <br>
    {{-- @include('layouts.partials.search_settings') --}}
</section>

<!-- Main content -->
<section class="content">
{!! Form::open(['url' => action([\App\Http\Controllers\OmniChannelServicesController::class, 'postShippingOmni']), 'method' => 'post', 'id' => 'omni_edit_form',
    'files' => true ]) !!}  
    <div class="row">
        <div class="col-xs-12">
       <!--  <pos-tab-container> -->
        <div class="col-xs-12 pos-tab-container">
            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 pos-tab-menu">
                <div class="list-group">
                    <a href="#" class="list-group-item text-center active">@lang('lang_v1.shipping_easy')</a>
                    <a href="#" class="list-group-item text-center">@lang('lang_v1.ship_station')</a>
                    <a href="#" class="list-group-item text-center">@lang('lang_v1.stamps.com')</a>                    
                </div>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 pos-tab">
                <!-- tab 1 start -->
                @include('business.partials.settings_shipping_easy')
                <!-- tab 1 end -->
                <!-- tab 2 start -->
                @include('business.partials.settings_ship_station')
                <!-- tab 2 end -->
                <!-- tab 3 start -->
                @include('business.partials.settings_stamps')
                <!-- tab 3 end -->
            </div>
        </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <button class="btn btn-danger pull-right" type="submit">@lang('business.update_settings')</button>
        </div>
    </div>    
{!! Form::close() !!}
</section>
<!-- /.content -->
@stop
@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        var bigenable = $("input[type='radio'][name='shipping_easy_enable']:checked").val()        
        var ship_stationenable = $("input[type='radio'][name='ship_station_enable']:checked").val()        
        var wooenable = $("input[type='radio'][name='stamps_enable']:checked").val()                      

        if(bigenable == '1') {
            // bigcommerce
            $('#shipping_easy_api_url').css('display', 'block')
            $('#shipping_easy_api_access_token').css('display', 'block')
            $('#shipping_easy_api_key').css('display', 'block')
            $('#shipping_easy_api_secret').css('display', 'block')
            $('#shipping_easy_space').addClass('col-sm-3')
        } else {
            // big commerce
            $('#shipping_easy_api_url').css('display', 'none')
            $('#shipping_easy_api_access_token').css('display', 'none')
            $('#shipping_easy_api_key').css('display', 'none')
            $('#shipping_easy_api_secret').css('display', 'none')
            $('#shipping_easy_space').removeClass('col-sm-3')
        }

        if(ship_stationenable == '1') {
            // ship_station
            $('#ship_station_api_url').css('display', 'block')
            $('#ship_station_api_access_token').css('display', 'block')
            $('#ship_station_api_key').css('display', 'block')
            $('#ship_station_api_secret').css('display', 'block')
            $('#ship_station_space').addClass('col-sm-3')
        } else {
            // ship_station
            $('#ship_station_api_url').css('display', 'none')
            $('#ship_station_api_access_token').css('display', 'none')
            $('#ship_station_api_key').css('display', 'none')
            $('#ship_station_api_secret').css('display', 'none')
            $('#ship_station_space').removeClass('col-sm-3')
        }

        if(wooenable == '1') {
            // woo commerce
            $('#stamps_api_url').css('display', 'block')
            $('#stamps_api_access_token').css('display', 'block')
            $('#stamps_api_key').css('display', 'block')
            $('#stamps_api_secret').css('display', 'block')
            $('#stamps_space').addClass('col-sm-3')
        } else {
            // woo commerce
            $('#stamps_api_url').css('display', 'none')
            $('#stamps_api_access_token').css('display', 'none')
            $('#stamps_api_key').css('display', 'none')
            $('#stamps_api_secret').css('display', 'none')
            $('#stamps_space').removeClass('col-sm-3')
        }
    })     

    function get_input(val, tipe) {        
        if(val == '1') {
            if(tipe == 'bigcommerce') {
                // bigcommerce
                $('#shipping_easy_api_url').css('display', 'block')
                $('#shipping_easy_api_access_token').css('display', 'block')
                $('#shipping_easy_api_key').css('display', 'block')
                $('#shipping_easy_api_secret').css('display', 'block')
                $('#shipping_easy_space').addClass('col-sm-3')
            }
            if(tipe == 'ship_station') {
                // ship_station
                $('#ship_station_api_url').css('display', 'block')
                $('#ship_station_api_access_token').css('display', 'block')
                $('#ship_station_api_key').css('display', 'block')
                $('#ship_station_api_secret').css('display', 'block')
                $('#ship_station_space').addClass('col-sm-3')
            }
            if(tipe == 'stamps') {
                // woo commerce
                $('#stamps_api_url').css('display', 'block')
                $('#stamps_api_access_token').css('display', 'block')
                $('#stamps_api_key').css('display', 'block')
                $('#stamps_api_secret').css('display', 'block')
                $('#stamps_space').addClass('col-sm-3')
            }
        } else {
            if(tipe == 'bigcommerce') {
                // big commerce
                $('#shipping_easy_api_url').css('display', 'none')
                $('#shipping_easy_api_access_token').css('display', 'none')
                $('#shipping_easy_api_key').css('display', 'none')
                $('#shipping_easy_api_secret').css('display', 'none')
                $('#shipping_easy_space').removeClass('col-sm-3')
            }
            if(tipe == 'ship_station') {
                // ship_station
                $('#ship_station_api_url').css('display', 'none')
                $('#ship_station_api_access_token').css('display', 'none')
                $('#ship_station_api_key').css('display', 'none')
                $('#ship_station_api_secret').css('display', 'none')
                $('#ship_station_space').removeClass('col-sm-3')
            }
            if(tipe == 'stamps') {
                // woo commerce
                $('#stamps_api_url').css('display', 'none')
                $('#stamps_api_access_token').css('display', 'none')
                $('#stamps_api_key').css('display', 'none')
                $('#stamps_api_secret').css('display', 'none')
                $('#stamps_space').removeClass('col-sm-3')
            }
        }
    }
</script>
@endsection