@extends('layouts.app')
@section('title', __('barcode.print_labels'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
<br>
    <h1>@lang('barcode.print_labels') @show_tooltip(__('tooltip.print_label'))</h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content no-print">
	{!! Form::open(['url' => '#', 'method' => 'post', 'id' => 'preview_setting_form', 'onsubmit' => 'return false']) !!}
	@component('components.widget', ['class' => 'box-primary', 'title' => __('product.add_product_for_labels')])
		{{-- <div class="row">
			<div class="col-sm-8">
				<div class="form-group">
					<div class="input-group">
						<span class="input-group-addon">
							<i class="fa fa-search"></i>
						</span>
						{!! Form::text('search_product', null, ['class' => 'form-control', 'id' => 'search_product_for_label', 'placeholder' => __('lang_v1.enter_product_name_to_print_labels'), 'autofocus']); !!}
					</div>
				</div>
			</div>
			<div class="col-sm-4" style="text-align: right;">
				<i class="fa fa-times text-danger label_remove_row cursor-pointer" aria-hidden="true" style="margin-top: 5px;"></i>
			</div>
		</div> --}}

		<div class="row">
			<div class="col-sm-12">
				<table class="table table-bordered table-striped table-condensed" id="product_table">
					<thead>
						<tr>
							<th>@lang( 'barcode.products' )</th>
							<th style="width: 20%">@lang( 'barcode.category_code' )</th>
							<th>@lang('barcode.product_price')</th>
							<th>@lang( 'barcode.no_of_labels' )</th>
							@if(request()->session()->get('business.enable_lot_number') == 1)
								<th>@lang( 'lang_v1.lot_number' )</th>
							@endif
							@if(request()->session()->get('business.enable_product_expiry') == 1)
								<th>@lang( 'product.exp_date' )</th>
							@endif
							{{-- <th>@lang('lang_v1.packing_date')</th> --}}
							<th>@lang('lang_v1.selling_price_group')</th>
						</tr>
					</thead>
					<tbody>
						@include('business.partials.shopify_show_table_rows', ['index' => 0])
					</tbody>
				</table>
			</div>
		</div>
	@endcomponent

	@component('components.widget', ['class' => 'box-primary', 'title' => __( 'barcode.info_in_labels' )])
		<div class="row">
			<div class="col-md-12">
				<table class="table table-bordered">
					<tr>
						<td>
							<div class="checkbox">
							    <label>
							    	<input type="checkbox" checked name="print[name]" value="1"> <b>@lang( 'barcode.print_name' )</b>
							    </label>
							</div>

							<div class="input-group">
      							<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
								<input type="text" class="form-control" 
									name="print[name_size]" id="product_name_size"
									value="{{$information_labels[0]->size ?? ''}}">
							</div>
						</td>

						<td>
							<div class="checkbox">
							    <label>
							    	<input type="checkbox" checked name="print[variations]" value="1"> <b>@lang( 'barcode.print_variations' )</b>
							    </label>
							</div>

							<div class="input-group">
      							<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
								<input type="text" class="form-control" 
									name="print[variations_size]" id="product_variation_size" 
									value="{{$information_labels[1]->size ?? ''}}">
							</div>
						</td>

						<td>
							<div class="checkbox">
							    <label>
							    	<input type="checkbox" checked name="print[price]" value="1" id="is_show_price"> <b>@lang( 'barcode.print_price' )</b>
							    </label>
							</div>

							<div class="input-group">
      							<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
								<input type="text" class="form-control" 
									name="print[price_size]" id="product_price_size" 
									value="{{$information_labels[2]->size ?? ''}}">
							</div>

						</td>

						<td>
							
							<div class="" id="price_type_div">
								<div class="form-group">
									{!! Form::label('print[price_type]', @trans( 'barcode.show_price' ) . ':') !!}
									<div class="input-group">
										<span class="input-group-addon">
											<i class="fa fa-info"></i>
										</span>
										{{-- {!! Form::select('print[price_type]', ['inclusive' => __('product.inc_of_tax'), 'exclusive' => __('product.exc_of_tax')], 'inclusive', ['class' => 'form-control']); !!} --}}
										{!! Form::select('print[price_type]', ['exclusive' => __('product.exc_of_tax')], 'inclusive', ['class' => 'form-control']); !!}
									</div>
								</div>
							</div>

						</td>
					</tr>

					<tr>
						<td>
							<div class="checkbox">
							    <label>
							    	<input type="checkbox" name="print[business_name]" value="1"> <b>@lang( 'barcode.print_business_name' )</b>
							    </label>
							</div>

							<div class="input-group">
      							<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
								<input type="text" class="form-control" 
									name="print[business_name_size]" id="business_name_size"
									value="{{$information_labels[3]->size ?? ''}}">
							</div>
						</td>

						<td>
							<div class="checkbox">
							    <label>
							    	<input type="checkbox" checked name="print[packing_date]" value="1"> <b>@lang( 'lang_v1.print_packing_date' )</b>
							    </label>
							</div>

							<div class="input-group">
      							<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
								<input type="text" class="form-control" 
									name="print[packing_date_size]" id="print_packing_date_size"
									value="{{$information_labels[4]->size ?? ''}}">
							</div>
						</td>

						<td>
							@if(request()->session()->get('business.enable_lot_number') == 1)
							
								<div class="checkbox">
								    <label>
								    	<input type="checkbox" checked name="print[lot_number]" value="1"> <b>@lang( 'lang_v1.print_lot_number' )</b>
								    </label>
								</div>

								<div class="input-group">
      							<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
									<input type="text" class="form-control" 
										name="print[lot_number_size]" id="print_lot_number_size"
										value="{{$information_labels[5]->size ?? ''}}">
								</div>
							@endif
						</td>

						<td>
							@if(request()->session()->get('business.enable_product_expiry') == 1)
								<div class="checkbox">
								    <label>
								    	<input type="checkbox" checked name="print[exp_date]" value="1"> <b>@lang( 'lang_v1.print_exp_date' )</b>
								    </label>
								</div>

								<div class="input-group">
      							<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
									<input type="text" class="form-control" 
										name="print[exp_date_size]" id="print_expiry_date_size"
										value="{{$information_labels[6]->size ?? ''}}">
								</div>
							@endif
						</td>
					</tr>
				</table>
			</div>

			<div style="display: none;">
			{!! Form::select('product_price', [$products[0]->price => $products[0]->price], !empty($default) ? $default->id : null, ['class' => 'form-control', 'id' => 'product_price']); !!}
			{!! Form::select('product_title', [$products[0]->title => $products[0]->title], !empty($default) ? $default->id : null, ['class' => 'form-control', 'id' => 'product_title']); !!}
			</div>

			<div class="col-sm-12">
				<hr/>
			</div>

			<div class="col-sm-4">
				<div class="form-group">
					{!! Form::label('price_type', @trans( 'barcode.barcode_setting' ) . ':') !!}
					<div class="input-group">
						<span class="input-group-addon">
							<i class="fa fa-cog"></i>
						</span>
						{!! Form::select('barcode_setting', $barcode_settings, !empty($default) ? $default->id : null, ['class' => 'form-control', 'id' => 'barcode_setting']); !!}
					</div>
				</div>
			</div>

			<div class="clearfix"></div>
			<div class="col-sm-2">				
				<button type="button" id="labels_update_settings" class="btn btn-primary btn-flat btn-block">@lang( 'messages.update' ) @lang( 'messages.settings' )</button>
			</div>
			<div class="col-sm-3 col-lg-offset-4">
				<button type="button" id="labels_preview" class="btn btn-primary pull-right btn-flat btn-block" rule-based="false">@lang( 'barcode.preview' )</button>
			</div>
			<div class="col-sm-3">
				<button type="button" id="labels_preview" class="btn btn-primary pull-right btn-flat btn-block" rule-based="true">@lang( 'barcode.rule_based_preview' )</button>
			</div>
		</div>
	@endcomponent
	{!! Form::close() !!}	
	<div class="col-sm-8 hide display_label_div">
		<h3 class="box-title">@lang( 'barcode.preview' )</h3>
		<button type="button" class="col-sm-offset-2 btn btn-success btn-block" id="print_label">Print</button>
	</div>
	<div class="clearfix"></div>
</section>

<!-- Preview section-->
<div id="preview_box">
</div>

@stop
@section('javascript')
	{{-- <script src="{{ asset('js/labels.js?v=' . $asset_v) }}"></script> --}}
  <script>
    
    $('i.label_remove_row').on('click', function(e) {
        $('table#product_table tbody').html('');
    });

    function label_remove_row(index) {
        $('#tr_row_index_'+index).remove();
    }

    $('#labels_update_settings').on('click', function() {
        var product_name_size = $('#product_name_size').val();
        var product_variation_size = $('#product_variation_size').val();
        var product_price_size = $('#product_price_size').val();
        var business_name_size = $('#business_name_size').val();
        var print_packing_date_size = $('#print_packing_date_size').val();
        var print_expiry_date_size = $('#print_expiry_date_size').val();
        var print_lot_number_size = $('#print_lot_number_size').val();
        var barcode_setting = $('#barcode_setting').val();
        $.ajax({
            method: 'POST',
            url: '/labels/update-settings',
            dataType: 'json',
            data: { product_name_size: product_name_size, product_variation_size: product_variation_size, product_price_size: product_price_size, business_name_size: business_name_size, print_packing_date_size: print_packing_date_size, print_expiry_date_size: print_expiry_date_size, print_lot_number_size: print_lot_number_size, barcode_setting: barcode_setting },
            success: function(result) {                
                if(result.rc == 1) {
                    toastr.success(result.rm);
                } else {
                    toastr.error(result.rm);
                }
            },
        });
    })

    $('button#labels_preview').click(function() {
        if ($('form#preview_setting_form table#product_table tbody tr').length > 0) {            
						var rule_based = $(this).attr('rule-based');
            var url = base_path + '/shopify/labels/show/preview?' + $('form#preview_setting_form').serialize();
						url += '&rule_based=' + encodeURIComponent(rule_based);
						// console.log(url);			            
						localStorage.removeItem('total_queue');
            window.open(url, 'newwindow');
        } else {
            swal(LANG.label_no_product_error).then(value => {
                $('#search_product_for_label').focus();
            });
        }
    });
  </script>
@endsection
