<div class="modal-dialog modal-xl" style="width: 70%;" role="document">
	<div class="modal-content">
		<div class="modal-header">
			<button type="button" class="close no-print" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title" id="modalTitle">{{$product->title}}</h4>
		</div>
		<div class="modal-body">
			<div class="row">
				<div class="col-sm-8">
					<div class="col-sm-4 invoice-col">
						<b>@lang('product.sku'):</b>
						{{$product->seller_sku }}<br>
						<b>@lang('product.brand'): </b>
						{{$product->brand ?? ' ' }}<br>
						<b>@lang('product.asin'): </b>
						{{$product->asin ?? ' ' }}<br>
						<b>@lang('product.store'): </b>
						{{$product->store ?? ' ' }}<br>
						<b>@lang('product.item_condition'): </b>
						{{$product->itemCondition ?? ' ' }}
					</div>

					<div class="col-sm-4 invoice-col">
						<b>@lang('product.category'): </b>
						{{$product->category ?? ' ' }}<br>
						<b>@lang('lang_v1.publisher'): </b>
						{{$product->manufacturer ?? ' ' }}<br>
						<b>@lang('lang_v1.product_group'): </b>
						{{$product->productGroup ?? ' ' }}<br>
						<b>@lang('lang_v1.type'): </b>
						{{$product->type ?? ' ' }}<br>
						<b>@lang('lang_v1.number_of_pages'): </b>
						{{ isset($product->numberOfPages) && $product->numberOfPages != -1 ? $product->numberOfPages : ' ' }}
					</div>

					<div class="col-sm-4 invoice-col">
						{{-- <b>@lang('lang_v1.material'): </b>
						{{$product->material ?? ' ' }}<br> --}}
						<b>@lang('product.price'): </b>
						{{$product->current_price ?? ' ' }}<br>
						<b>@lang('product.qty'): </b>
						{{$product->current_qty ?? ' ' }}<br>
						{{-- <b>@lang('lang_v1.part_number'): </b>
						{{$product->partNumber ?? ' ' }}<br> --}}
						<b>@lang('lang_v1.binding'): </b>
						{{$product->binding ?? ' ' }}<br>
						<b>@lang('lang_v1.item_type_keyword'): </b>
						{{$product->itemTypeKeyword ?? ' ' }}
					</div>

					<div class="clearfix"></div>
					<br>
					<div class="col-sm-12">
						<b>@lang('product.description'): </b>
						{!! $product->description !!}
					</div>
					<div class="clearfix"></div>
					<br><br>
					<div class="col-lg-12">
						<h3><i class="fa fa-microchip"></i> <span style="color: blue;">VH-AI Competitive Prices</span></h3>
					</div>
					<div class="col-lg-12 table-container" style="border: 3px solid #64a4ca;">						
						<div class="row p-0">
							<div class="col-lg-6">
								<h3 class="section-title-table-detail">Offers (New Condition)</h3>
							</div>
							<div class="col-lg-6" style="text-align: right; display: flex;">
								<h4 style="margin-top: 20px; margin-left: 50px;" class="red-cross-table-detail">Updated : {{ $product->updated_at_competitive_price ?? '' }}</h4>&nbsp;&nbsp;
								<button type="button" class="btn btn-primary no-print" style="margin-top: 10px" id="refresh-competitive-price" onclick="refreshCompetitivePrice('{{ $product->store }}', '{{ $product->asin }}', {{$product->id}})">
								<i class="fa fa-microchip"></i> Refresh</button>
							</div>
						</div>						
						<table class="w-100 table-detail fixed-table">
								<tr>
										<th class="th-detail">Condition</th>
										<th class="th-detail">Price (USD)</th>
										<th class="th-detail">Seller ID</th>
										<th class="th-detail">Fulfillment</th>
										<th class="th-detail">Prime Eligible</th>
										<th class="th-detail">Shipping</th>
								</tr>
								@if(!empty(json_decode($product->new_prices)))
									@foreach(json_decode($product->new_prices) as $newOffer)
										<tr>
												<td class="td-detail">{{ $newOffer->condition ?? '' }}</td>
												<td class="td-detail">{{ '$'.$newOffer->listingPrice->amount ?? '' }}</td>
												<td class="td-detail"><a href="https://www.amazon.com/sp?ie=UTF8&seller={{$newOffer->sellerId}}&asin={{$product->asin}}" target="_blank">{{ $newOffer->sellerId ?? '' }}</a></td>
												<td class="td-detail">{{ $newOffer->fulfillmentType ?? '' }}</td>
												@if($newOffer->primeDetails->eligibility == 'NONE') 
												<td class="td-detail"><span class="red-cross-table-detail">✗ {{ $newOffer->primeDetails->eligibility ?? '' }}</span></td>
												@else
												<td class="td-detail"><span class="green-check-table-detail">✔ {{ $newOffer->primeDetails->eligibility ?? '' }}</span></td>
												@endif
												<td class="td-detail">${{ $newOffer->shippingOptions[0]->price->amount ?? '' }}</td>
										</tr>
									@endforeach
								@endif
						</table>						

						<h3 class="section-title-table-detail">Offers (Used Condition)</h3>
						<table class="w-100 table-detail fixed-table">
								<tr>
										<th class="th-detail">Condition</th>
										<th class="th-detail">Price (USD)</th>
										<th class="th-detail">Seller ID</th>
										<th class="th-detail">Fulfillment</th>
										<th class="th-detail">Prime Eligible</th>
										<th class="th-detail">Shipping</th>
								</tr>
								@if(!empty(json_decode($product->used_prices)))
									@foreach(json_decode($product->used_prices) as $usedOffer)
										<tr>
											<td class="td-detail">{{ $usedOffer->condition ?? '' }} {{ $usedOffer->subCondition ?? '' }}</td>
											<td class="td-detail">{{ '$'.$usedOffer->listingPrice->amount ?? '' }}</td>
											<td class="td-detail"><a href="https://www.amazon.com/sp?ie=UTF8&seller={{$usedOffer->sellerId}}&asin={{$product->asin}}" target="_blank">{{ $usedOffer->sellerId ?? '' }}</a></td>
											<td class="td-detail">{{ $usedOffer->fulfillmentType ?? '' }}</td>
											@if($usedOffer->primeDetails->eligibility == 'NONE') 
											<td class="td-detail"><span class="red-cross-table-detail">✗ {{ $usedOffer->primeDetails->eligibility ?? '' }}</span></td>
											@else
											<td class="td-detail"><span class="green-check-table-detail">✔ {{ $usedOffer->primeDetails->eligibility ?? '' }}</span></td>
											@endif
											<td class="td-detail">${{ $usedOffer->shippingOptions[0]->price->amount ?? '' }}</td>
										</tr>
									@endforeach
								@endif
						</table>
					</div>
				</div>
				<div class="col-sm-4 col-md-4 invoice-col text-center">
					<div class="thumbnail">
						<img src="{{$product->image ? $product->image : asset('img/no_img.png') }}" alt="Product image" style="width: 100%; height: 100%">
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-primary no-print"
				aria-label="Print"
				onclick="$(this).closest('div.modal').printThis();">
				<i class="fa fa-print"></i> @lang( 'messages.print' )
			</button>
			<button type="button" class="btn btn-default no-print" data-dismiss="modal">@lang( 'messages.close' )</button>
		</div>
	</div>
</div>