@extends('layouts.app')
@section('title', __('report.barcode_print_history'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>{{ __('report.barcode_print_history')}}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('ir_barcode_user_id', __('user.user') . ':') !!}
                    <div class="input-group">
                        <span class="input-group-addon">
                            <i class="fa fa-user"></i>
                        </span>
                        {!! Form::select('ir_barcode_user_id', $users, null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all'), 'style' => 'width: 100%;']); !!}
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('ir_barcode_printed_date_filter', __('lang_v1.last_printed_date') . ':') !!}
                    {!! Form::text('ir_barcode_printed_date_filter', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly', 'style' => 'width: 100%;']); !!}
                </div>
            </div>
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <!-- <div class="table-responsive"> -->
                    <table class="table table-bordered table-striped" id="barcode_print_history_report_table">
                        <thead>
                            <tr>
                                <th>@lang('product.sku')</th>
                                <th>@lang('product.product_name')</th>
                                <th>@lang('barcode.category_code')</th>
                                <th>@lang('barcode.label_price')</th>
                                <th>@lang('user.user')</th>
                                <th>@lang('lang_v1.last_printed_date')</th>
                            </tr>
                        </thead>
                    </table>
                <!-- </div> -->
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
@endsection