@extends('layouts.app')
@section('title', __('lang_v1.card_transactions_report'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>{{ __('lang_v1.card_transactions_report')}}</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\App\Http\Controllers\CardTransactionsController::class, 'getCardTransactionsReport']), 'method' => 'get', 'id' => 'card_transactions_report_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                    {!! Form::label('search_retref', __('lang_v1.search_retref') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-search"></i>
                            </span>
                            <input type="hidden" value="" id="transaction_id">
                            {!! Form::text('search_retref', null, ['class' => 'form-control', 'id' => 'search_retref', 'placeholder' => __('lang_v1.search_retref_placeholder'), 'autofocus']); !!}
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.business_location').':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-map-marker"></i>
                            </span>
                            {!! Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required', 'style' => 'width: 100%;']); !!}
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('card_transaction_sr_date_filter', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'card_transaction_sr_date_filter', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    {!! Form::label('card_transaction_sr_start_time', __('lang_v1.time_range') . ':') !!}
                    @php
                        $startDay = Carbon::now()->startOfDay();
                        $endDay   = $startDay->copy()->endOfDay();
                    @endphp
                    <div class="form-group">
                        {!! Form::text('start_time', @format_time($startDay), ['style' => __('lang_v1.select_a_date_range'), 'class' => 'form-control width-50 f-left', 'id' => 'card_transaction_sr_start_time']); !!}
                        {!! Form::text('end_time', @format_time($endDay), ['class' => 'form-control width-50 f-left', 'id' => 'card_transaction_sr_end_time']); !!}
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#psr_detailed_tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-list" aria-hidden="true"></i> @lang('lang_v1.detailed')</a>
                    </li>
                    
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="psr_detailed_tab">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="card_transactions_report_table">
                                <thead>
                                    <tr>
                                        <th>@lang('sale.customer_name')</th>
                                        <th>@lang('lang_v1.ref_number')</th>
                                        <th>@lang('lang_v1.resptext')</th>
                                        <th>@lang('business.business_location')</th>
                                        <th>@lang('lang_v1.authcode')</th>
                                        <th>@lang('lang_v1.amount')</th>
                                        <th>@lang('lang_v1.expiry')</th>
                                        <th>@lang('lang_v1.card_type')</th>
                                        <th>@lang('lang_v1.entry_mode')</th>
                                        <th>@lang('lang_v1.transaction_date')</th>
                                        <th>@lang('lang_v1.transaction_date')</th>
                                        
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    

                    
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->
<div class="modal fade view_register" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
    <script type="text/javascript">
        $(
        '#card_transactions_report_form #location_id'
    ).change(function() {        
        $('.nav-tabs li.active').find('a[data-toggle="tab"]').trigger('shown.bs.tab');
    });
        $(document).ready( function() {
            // $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            //     var target = $(e.target).attr('href');
            //     if ( target == '#psr_by_cat_tab') {
            //         if(typeof product_sell_report_by_category_datatable == 'undefined') {
            //             product_sell_report_by_category_datatable = $('table#product_sell_report_by_category').DataTable({
            //                     processing: true,
            //                     serverSide: true,
            //                     ajax: {
            //                         url: '/reports/product-sell-grouped-by',
            //                         data: function(d) {
            //                             var start = '';
            //                             var end = '';
            //                             var start_time = $('#card_transaction_sr_start_time').val();
            //                             var end_time = $('#card_transaction_sr_end_time').val();
            //                             if ($('#card_transaction_sr_date_filter').val()) {
            //                                 start = $('input#card_transaction_sr_date_filter')
            //                                     .data('daterangepicker')
            //                                     .startDate.format('YYYY-MM-DD');
            //                                 end = $('input#card_transaction_sr_date_filter')
            //                                     .data('daterangepicker')
            //                                     .endDate.format('YYYY-MM-DD');

            //                                 start = moment(start + " " + start_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
            //                                 end = moment(end + " " + end_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
            //                             }
            //                             d.start_date = start;
            //                             d.end_date = end;
            //                             d.group_by = 'category';
            //                             d.category_id = $('select#psr_filter_category_id').val();
            //                             d.brand_id = $('select#psr_filter_brand_id').val();
            //                             d.customer_id = $('select#customer_id').val();
            //                             d.location_id = $('select#location_id').val();
            //                             d.customer_group_id = $('#psr_customer_group_id').val();
            //                         },
            //                     },
            //                     columns: [
            //                         { data: 'category_name', name: 'cat.name' },
            //                         { data: 'current_stock', name: 'current_stock', searchable: false, orderable: false },
            //                         { data: 'total_qty_sold', name: 'total_qty_sold', searchable: false },
            //                         { data: 'subtotal', name: 'subtotal', searchable: false },
            //                     ],
            //                     fnDrawCallback: function(oSettings) {
            //                         $('#footer_psr_by_cat_total_sell').text(
            //                             sum_table_col($('#product_sell_report_by_category'), 'row_subtotal')
            //                         );
            //                         $('#footer_psr_by_cat_total_sold').html(
            //                             __sum_stock($('#product_sell_report_by_category'), 'sell_qty')
            //                         );

            //                         $('#footer_psr_by_cat_total_stock').html(
            //                             __sum_stock($('#product_sell_report_by_category'), 'current_stock')
            //                         );
            //                         __currency_convert_recursively($('#product_sell_report_by_category'));
            //                     },
            //                 });
            //             } else {
            //                 product_sell_report_by_category_datatable.ajax.reload();
            //             }
            //         } else if ( target == '#psr_by_brand_tab') {
            //         if(typeof product_sell_report_by_brand_datatable == 'undefined') {
            //             product_sell_report_by_brand_datatable = $('table#product_sell_report_by_brand').DataTable({
            //                     processing: true,
            //                     serverSide: true,
            //                     ajax: {
            //                         url: '/reports/product-sell-grouped-by',
            //                         data: function(d) {
            //                             var start = '';
            //                             var end = '';
            //                             var start_time = $('#card_transaction_sr_start_time').val();
            //                             var end_time = $('#card_transaction_sr_end_time').val();
            //                             if ($('#card_transaction_sr_date_filter').val()) {
            //                                 start = $('input#card_transaction_sr_date_filter')
            //                                     .data('daterangepicker')
            //                                     .startDate.format('YYYY-MM-DD');
            //                                 end = $('input#card_transaction_sr_date_filter')
            //                                     .data('daterangepicker')
            //                                     .endDate.format('YYYY-MM-DD');

            //                                 start = moment(start + " " + start_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
            //                                 end = moment(end + " " + end_time, "YYYY-MM-DD" + " " + moment_time_format).format('YYYY-MM-DD HH:mm');
            //                             }
            //                             d.start_date = start;
            //                             d.end_date = end;
            //                             d.group_by = 'brand';
            //                             d.category_id = $('select#psr_filter_category_id').val();
            //                             d.brand_id = $('select#psr_filter_brand_id').val();
            //                             d.customer_id = $('select#customer_id').val();
            //                             d.location_id = $('select#location_id').val();
            //                             d.customer_group_id = $('#psr_customer_group_id').val();
            //                         },
            //                     },
            //                     columns: [
            //                         { data: 'brand_name', name: 'b.name' },
            //                         { data: 'current_stock', name: 'current_stock', searchable: false, orderable: false },
            //                         { data: 'total_qty_sold', name: 'total_qty_sold', searchable: false },
            //                         { data: 'subtotal', name: 'subtotal', searchable: false },
            //                     ],
            //                     fnDrawCallback: function(oSettings) {
            //                         $('#footer_psr_by_brand_total_sell').text(
            //                             sum_table_col($('#product_sell_report_by_brand'), 'row_subtotal')
            //                         );
            //                         $('#footer_psr_by_brand_total_sold').html(
            //                             __sum_stock($('#product_sell_report_by_brand'), 'sell_qty')
            //                         );

            //                         $('#footer_psr_by_cat_total_stock').html(
            //                             __sum_stock($('#product_sell_report_by_brand'), 'current_stock')
            //                         );
            //                         __currency_convert_recursively($('#product_sell_report_by_brand'));
            //                     },
            //                 });
            //             } else {
            //                 product_sell_report_by_brand_datatable.ajax.reload();
            //             }
            //         }
            //     });
            // 
        });
    </script>
@endsection