@extends('layouts.app')
@section('title', __('lang_v1.cash_drawer_report'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>Cash Drawer Opened</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    {{-- <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
                {!! Form::open(['url' => action([\App\Http\Controllers\CardTransactionsController::class, 'getCardTransactionsReport']), 'method' => 'get', 'id' => 'card_transactions_report_form' ]) !!}
                    <div class="col-md-3">
                        <div class="form-group">
                        {!! Form::label('search_retref', __('lang_v1.search_retref') . ':') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-search"></i>
                                </span>
                                <input type="hidden" value="" id="transaction_id">
                                {!! Form::text('search_retref', null, ['class' => 'form-control', 'id' => 'search_retref', 'placeholder' => __('lang_v1.search_retref_placeholder'), 'autofocus']); !!}
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            {!! Form::label('location_id', __('business.business_location').':') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-map-marker"></i>
                                </span>
                                {!! Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required']); !!}
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            {!! Form::label('card_transaction_sr_date_filter', __('report.date_range') . ':') !!}
                            {!! Form::text('date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'card_transaction_sr_date_filter', 'readonly']); !!}
                        </div>
                    </div>
                    <div class="col-md-3">
                        {!! Form::label('card_transaction_sr_start_time', __('lang_v1.time_range') . ':') !!}
                        @php
                            $startDay = Carbon::now()->startOfDay();
                            $endDay   = $startDay->copy()->endOfDay();
                        @endphp
                        <div class="form-group">
                            {!! Form::text('start_time', @format_time($startDay), ['style' => __('lang_v1.select_a_date_range'), 'class' => 'form-control width-50 f-left', 'id' => 'card_transaction_sr_start_time']); !!}
                            {!! Form::text('end_time', @format_time($endDay), ['class' => 'form-control width-50 f-left', 'id' => 'card_transaction_sr_end_time']); !!}
                        </div>
                    </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div> --}}
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#psr_detailed_tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-list" aria-hidden="true"></i> @lang('lang_v1.detailed')</a>
                    </li>
                    
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="psr_detailed_tab">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="cash_drawer_report_table">
                                <thead>
                                    <tr>
                                        <th>@lang('user.user')</th>
                                        <th>@lang('lang_v1.date')</th>
                                        <th>@lang('lang_v1.reason')</th>                                                                                
                                        <th>#</th>                                                                                
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                    

                    
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->
{{-- <div class="modal fade view_register" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div> --}}

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>    
@endsection