@extends('layouts.app')
@section('title', __('report.product_analyzer_history'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>{{ __('report.product_analyzer_history')}}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('ir_analyze_user_id', __('user.user') . ':') !!}
                    <div class="input-group">
                        <span class="input-group-addon">
                            <i class="fa fa-user"></i>
                        </span>
                        {!! Form::select('ir_analyze_user_id', $users, null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all'), 'style' => 'width: 100%;']); !!}
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('ir_analyze_printed_date_filter', __('product.analyze_date') . ':') !!}
                    {!! Form::text('ir_analyze_printed_date_filter', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly', 'style' => 'width: 100%;']); !!}
                </div>
            </div>
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            
            @component('components.widget', ['class' => 'box-primary'])
                <!-- <div class="table-responsive"> -->
                    <table class="table table-bordered table-striped" id="print_analyzer_history_report_table" style="width: 100%">
                        <thead>
                            <tr>
                                <th>@lang('product.isbn13')</th>
                                <th>@lang('product.title')</th>
                                <th>@lang('product.condition')</th>
                                <th>@lang('product.binding')</th>
                                <th>@lang('product.in_our_system')</th>
                                <th>@lang('product.total_quantity')</th>
                                <th>@lang('product.price')</th>
                                <th>@lang('user.user')</th>
                                <th>@lang('product.analyze_date')</th>
                            </tr>
                        </thead>
                    </table>
                <!-- </div> -->
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
@endsection