@section('content')
<div class="container">
    <h2>Sales & Traffic Report</h2>

    <div class="card mt-4">
        <div class="card-header">📊 Sales Summary</div>
        <div class="card-body">
            <p><strong>💰 Ordered Product Sales:</strong> ${{ number_format($data['sales']['orderedProductSales']['amount'], 2) }}</p>
            <p><strong>📦 Orders Shipped:</strong> {{ $data['sales']['ordersShipped'] }}</p>
            <p><strong>📊 Average Sales Per Order:</strong> ${{ number_format($data['sales']['averageSalesPerOrderItem']['amount'], 2) }}</p>
            <p><strong>📈 Average Selling Price:</strong> ${{ number_format($data['sales']['averageSellingPrice']['amount'], 2) }}</p>
            <p><strong>🔄 Refund Rate:</strong> {{ $data['sales']['refundRate'] }}%</p>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header">📈 Traffic Summary</div>
        <div class="card-body">
            <p><strong>🖥️ Browser Page Views:</strong> {{ number_format($data['traffic']['browserPageViews']) }}</p>
            <p><strong>📱 Mobile App Page Views:</strong> {{ number_format($data['traffic']['mobileAppPageViews']) }}</p>
            <p><strong>🏆 Buy Box Percentage:</strong> {{ $data['traffic']['buyBoxPercentage'] }}%</p>
            <p><strong>💬 Feedback Received:</strong> {{ $data['traffic']['feedbackReceived'] }}</p>
            <p><strong>❌ Negative Feedback:</strong> {{ $data['traffic']['negativeFeedbackReceived'] }}</p>
        </div>
    </div>
</div>
@endsection