@extends('layouts.app')
@inject('request', 'Illuminate\Http\Request')
@section('title', __('sale.pos_sale'))

@section('content')
{!! Form::open(['url' => action([\App\Http\Controllers\SellPosController::class, 'store']), 'method' => 'post', 'id' => 'add_pos_sell_form' ]) !!}
<section class="content no-print">
	<input type="hidden" id="amount_rounding_method" value="{{$pos_settings['amount_rounding_method'] ?? ''}}">
	@if(!empty($pos_settings['allow_overselling']))
		<input type="hidden" id="is_overselling_allowed" value="{{ $pos_settings['allow_overselling'] ?? '' }}">
	@endif
	@if(session('business.enable_rp') == 1)
        <input type="hidden" id="reward_point_enabled">
    @endif
    @php
		$is_discount_enabled = $pos_settings['disable_discount'] != 1 ? true : false;
		$is_rp_enabled = session('business.enable_rp') == 1 ? true : false;
	@endphp
	<div class="row mb-12">
		<div class="col-md-12">
			<div class="row" style="margin-left:-5px;">				
				@if(empty($pos_settings['hide_product_suggestion']) && !isMobile())
				<div class="col-md-5 vh-pos-rightside">
					@include('sale_pos.partials.pos_sidebar')
				</div>
				@endif
				<div class="@if(empty($pos_settings['hide_product_suggestion'])) col-md-7 @else col-md-10 col-md-offset-1 @endif pr-12">
					<div class="box box-solid mb-12 @if(!isMobile()) mb-40 @endif">
						<div class="box-body pb-0">
							{{-- {!! Form::hidden('location_id', $default_location->id ?? null , ['id' => 'location_id', 'data-receipt_printer_type' => !empty($default_location->receipt_printer_type) ? $default_location->receipt_printer_type : 'browser', 'data-default_payment_accounts' => $default_location->default_payment_accounts ?? '']); !!}  --}}
							{!! Form::hidden('location_id', $default_location->location_id ?? null , ['id' => 'location_id', 'data-receipt_printer_type' => !empty($default_location->receipt_printer_type) ? $default_location->receipt_printer_type : 'browser', 'data-default_payment_accounts' => $default_location->default_payment_accounts ?? '']); !!}
							<input type="hidden" name="default_location" id="default_location" value="{{ $default_location->id ?? '' }}">
							<input type="hidden" name="default_location_name" id="default_location_name" value="{{ $default_location->name ?? '' }}">
							<input type="hidden" name="default_picture" id="default_picture" value="{{ $default_picture ?? '' }}">
							<input type="hidden" name="promotion_slider_speed" id="promotion_slider_speed" value="{{ $promotion_slider_speed ?? 5 }}">
							<input type="hidden" name="cash_register_list_id" id="cash_register_list_id" value="{{ $default_cashier->id ?? '' }}">
							<input type="hidden" name="id_cash_register" id="id_cash_register" value="{{ $default_id_cash_register ?? '' }}">
							<input type="hidden" name="contact_id" id="id_contact" value="{{ $walk_in_customer['id'] ?? ''}}">
							<input type="hidden" name="required_signature" id="required_signature" value="{{ $default_location->required_signature ?? ''}}">
							<input type="hidden" name="promotion_max_price" id="promotion_max_price" value="{{ $default_location->promotion_max_price ?? '' }}">
							<!-- sub_type -->
							{!! Form::hidden('sub_type', isset($sub_type) ? $sub_type : null) !!}
							<input type="hidden" id="item_addition_method" value="{{$business_details->item_addition_method}}">
								@include('sale_pos.partials.pos_form')

								@include('sale_pos.partials.pos_form_totals')

								@include('sale_pos.partials.payment_modal')

								@if(empty($pos_settings['disable_suspend']))
									@include('sale_pos.partials.suspend_note_modal')
								@endif

								@if(empty($pos_settings['disable_recurring_invoice']))
									@include('sale_pos.partials.recurring_invoice_modal')
								@endif
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	@include('sale_pos.partials.pos_form_actions')	
	@if ($default_location->show_numpad == 1)	
		<div class="numpad_div col-xs-12 hide" id="product_numpad_div1" data-type="cash" style="			
			/* display: flex; */
			/* align-items: center; */
			/* justify-content: center; */
			/* padding-right: 25px; */
			position: absolute;
			">							
			<div class="form-group">									
				<div class="easy-numpad-number-container">
					<table id="product_numpad1">
						<thead>						
							<tr>
								
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">1</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">2</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">3</a></td>							
							</tr>
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">4</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">5</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">6</a></td>
							</tr>
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">7</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">8</a></td>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">9</a></td>
							</tr>						
							<tr>
								<td class="numPadCashOther" style="padding: 10px;" data-type="middle"><a href="#"  style="padding: 10px ; width: 90px !important; height: 70px !important; ">0</a></td>														
								<td style="padding: 10px;"><a href="#" class="numPadCashOtherClear" id="numPadCashOtherClear" style="padding: 10px ; width: 90px !important; height: 70px !important;">Clr</a></td>
								<td style="padding: 10px;"><a href="#" class="numPadCashOtherDel" id="numPadCashOtherDel" style="padding: 10px ; width: 90px !important; height: 70px !important;">DEL</a></td>									
							</tr>
							<tr>
								<td colspan="3" style="padding: 10px;"><a href="#" class="numPadCashAddProductClose" id="numPadCashAddProductClose" onclick="event.preventDefault(); $('#product_numpad_div1').addClass('hide')" style="padding: 10px !important; width: calc(100% + -10px); margin-top:2px; height: 50px;">CLOSE</a></td>									
							</tr>
						</thead>
					</table>
				</div>									
			</div>							
		</div>
	@endif
</section>

<!-- This will be printed -->
<section>
	@include('sale_pos.partials.suspend_note_modal')		
</section>
{!! Form::close() !!}
<section class="invoice print_section" id="receipt_section">
</section>
<div class="modal contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
	@include('contact.create', ['quick_add' => true])
</div>
@if(empty($pos_settings['hide_product_suggestion']) && isMobile())
	@include('sale_pos.partials.mobile_product_suggestions')
@endif
<!-- /.content -->
<div class="modal fade register_details_modal" tabindex="-1" role="dialog" 
	aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade close_register_modal" tabindex="-1" role="dialog" 
	aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade z_report_modal" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>
<!-- quick product modal -->
<div class="modal quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>

<div class="modal" id="expense_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
</div>

@include('sale_pos.partials.configure_search_modal')

@include('sale_pos.partials.recent_transactions_modal')

@include('sale_pos.partials.custom_sale_modal')

@include('sale_pos.partials.weighing_scale_modal')

@include('sale_pos.partials.modal_drawers_opening')

@include('sale_pos.partials.fix_label_price')

@stop
@section('css')
	<!-- include module css -->
    @if(!empty($pos_module_data))
        @foreach($pos_module_data as $key => $value)
            @if(!empty($value['module_css_path']))
                @includeIf($value['module_css_path'])
            @endif
        @endforeach
    @endif
	<link rel="stylesheet" href="{{asset('css/bootstrap-multiselect.css')}}">
@stop
@section('javascript')
	<script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/printer.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>
	{{-- @include('sale_pos.partials.keyboard_shortcuts') --}}

	<!-- Call restaurant module if defined -->
    @if(in_array('tables' ,$enabled_modules) || in_array('modifiers' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules))
    	<script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
    @endif
    <!-- include module js -->
    @if(!empty($pos_module_data))
	    @foreach($pos_module_data as $key => $value)
            @if(!empty($value['module_js_path']))
                @includeIf($value['module_js_path'], ['view_data' => $value['view_data']])
            @endif
	    @endforeach
	@endif	
	<script src="{{asset('js/bootstrap-multiselect.min.js')}}"></script>
@endsection