@extends('layouts.app')
@section('title', __('lang_v1.sell_return'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
	<h1>@lang('lang_v1.sell_return')</h1>
</section>

<!-- Main content -->
<section class="content no-print">

	{!! Form::hidden('location_id', $sell->location->id, ['id' => 'location_id', 'data-receipt_printer_type' => $sell->location->receipt_printer_type ]); !!}

	{!! Form::open(['url' => action([\App\Http\Controllers\SellReturnController::class, 'store']), 'method' => 'post', 'id' => 'sell_return_form' ]) !!}
	{!! Form::hidden('transaction_id', $sell->id); !!}
	<div class="box box-solid">
		<div class="box-header">
			<h3 class="box-title">@lang('lang_v1.parent_sale')</h3>
		</div>
		<div class="box-body">
			<div class="row">
				<div class="col-sm-4">
					<strong>@lang('sale.invoice_no'):</strong> {{ $sell->invoice_no }} <br>
					<strong>@lang('messages.date'):</strong> {{@format_date($sell->transaction_date)}}
					<input type="hidden" name="invoice_no_pos" id="invoice_no_pos" value="{{ $sell->invoice_no }}">
				</div>
				<div class="col-sm-4">
					<input type="hidden" name="customer_id" id="customer_id" value="{{$sell->contact->id}}">
					<strong>@lang('contact.customer'):</strong> {{ $sell->contact->name }} <br>
					<strong>@lang('business.business_location'):</strong> {{ $sell->location->name }}
				</div>
			</div>			
		</div>
	</div>
	<div class="box box-solid">
		<div class="box-body">
			<div class="row">
				<div class="col-sm-4">
					<div class="form-group">
						{!! Form::label('invoice_no', __('sale.invoice_no').':') !!}
						{!! Form::text('invoice_no', !empty($sell->return_parent->invoice_no) ? $sell->return_parent->invoice_no : null, ['class' => 'form-control']); !!}
					</div>
				</div>
				<div class="col-sm-3">
					<div class="form-group">
						{!! Form::label('transaction_date', __('messages.date') . ':*') !!}
						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-calendar"></i>
							</span>
							@php
							$transaction_date = !empty($sell->return_parent->transaction_date) ? $sell->return_parent->transaction_date : 'now';
							@endphp
							{!! Form::text('transaction_date', @format_datetime($transaction_date), ['class' => 'form-control', 'readonly', 'required']); !!}
						</div>
					</div>
				</div>		
				@if (!$disable_return)				
					<div class="col-sm-6">
						<div class="form-group">												
							<input class="icheckbox_square-blue" id="exchange_checkbox" name="exchange_checkbox" type="checkbox" value="1" style="margin-right: 3px;margin-bottom: 5px;" onclick="exchangeCheckbox(this)"> Exchange													
						</div>
					</div>				
				@endif	
				<div class="col-sm-12">
					<table class="table bg-gray" id="sell_return_table">
						<thead>
							<tr class="bg-green">
								<th>#</th>
								<th>@lang('product.product_name')</th>
								<th>@lang('lang_v1.payment_type')</th>
								<th>@lang('lang_v1.payment')</th>
								<th>@lang('sale.unit_price')</th>
								<th>@lang('lang_v1.sell_quantity')</th>
								<th>@lang('lang_v1.return_quantity')</th>
								<th>@lang('lang_v1.return_subtotal')</th>
							</tr>
						</thead>
						<tbody>
							@foreach($sell->sell_lines as $sell_line)
							{{-- @php
							$check_decimal = 'false';
							if($sell_line->children_type != 'modifier') {
								if($sell_line->product->unit->allow_decimal == 0){
									$check_decimal = 'true';
								}

								$unit_name = $sell_line->product->unit->short_name;

								if(!empty($sell_line->sub_unit)) {
									$unit_name = $sell_line->sub_unit->short_name;

									if($sell_line->sub_unit->allow_decimal == 0){
										$check_decimal = 'true';
									} else {
										$check_decimal = 'false';
									}
								}
							}

							@endphp --}}
							@php
								$check_decimal = 'false';
							@endphp
							<tr>
								<td>{{ $loop->iteration }}</td>
								<td>
									{{ $sell_line->product->Title }}
									{{-- $sell_line->product->name --}}
									{{-- @if( $sell_line->product->type == 'variable')
									- {{ $sell_line->variations->product_variation->name}}
									- {{ $sell_line->variations->name}}
									@endif --}}
									<br>
									{{-- $sell_line->variations->sub_sku --}}
									{{ $sell_line->product->SellerSku }}
								</td>								
								<td>
									@if ($sell_line->payment_type)
										@foreach ($sell_line->payment_type as $key_sell_line => $item_sell_line)
											@if (count($sell_line->payment_type) == ($key_sell_line + 1))
												{{ strtoupper($item_sell_line->method) }}
											@else
												{{ strtoupper($item_sell_line->method).', ' }}
											@endif
										@endforeach
									@else
										Payment Method Not Found
									@endif
								</td>								
								<td>
									@if (count($sell_line->payment_type) > 1)
										@foreach ($sell_line->payment_type as $key_sell_line => $item_sell_line)
											@if (count($sell_line->payment_type) == ($key_sell_line + 1))
												@if ($item_sell_line->is_return == 1)													
													{{ 'Change Return: '. -@num_format($item_sell_line->amount) }}
												@else													
													{{ strtoupper($item_sell_line->method).': '. @num_format($item_sell_line->amount) }}
												@endif
											@else
												@if ($item_sell_line->is_return == 1)
													{{ 'Change Return: '. -@num_format($item_sell_line->amount).', ' }}
												@else													
													{{ strtoupper($item_sell_line->method).': '. @num_format($item_sell_line->amount).', ' }}
												@endif												
											@endif
										@endforeach
									@else
										{{ @num_format((($sell_line->unit_price_inc_tax * $sell_line->quantity) + (($sell_line->unit_price_inc_tax * $sell_line->quantity) * ($sell->tax->amount/100) ) )) }}
									@endif
								</td>
								<td><span class="display_currency" data-currency_symbol="true">{{ $sell_line->unit_price_inc_tax }}</span></td>
								{{-- <td>{{ $sell_line->formatted_qty }} {{$unit_name}}</td> --}}
								<td>{{ $sell_line->formatted_qty }}</td>
								<td>
									<input type="text" name="return_products[{{$loop->index}}][quantity]" value="{{@format_quantity($sell_line->quantity_returned)}}" class="form-control input-sm input_number return_qty input_quantity" data-rule-min-value="0" data-msg-min-value="@lang('validation.custom-messages.quantity_not_available', ['qty' => $sell_line->formatted_qty, 'unit' => $unit_name ?? '' ])" data-rule-abs_digit="{{$check_decimal}}" data-msg-abs_digit="@lang('lang_v1.decimal_value_not_allowed')" data-rule-max-value="{{$sell_line->quantity}}" data-msg-max-value="@lang('validation.custom-messages.quantity_not_available', ['qty' => $sell_line->formatted_qty, 'unit' => $unit_name ?? '' ])">
									<input name="return_products[{{$loop->index}}][unit_price_inc_tax]" type="hidden" class="unit_price" value="{{@num_format($sell_line->unit_price_inc_tax)}}">
									<input name="return_products[{{$loop->index}}][sell_line_id]" type="hidden" value="{{$sell_line->id}}">
									@if ($sell_line->payment_type)
										@php
											$indexForeach = $loop->index;
										@endphp
										@foreach ($sell_line->payment_type as $key_sell_line => $item_sell_line)											
											<input name="return_products[{{$indexForeach}}][payment_method][{{$key_sell_line}}][method]" type="hidden" value="{{ strtoupper($item_sell_line->method) }}">			
											@if ($item_sell_line->is_return == 1)												
												<input name="return_products[{{$indexForeach}}][payment_method][{{$key_sell_line}}][amount]" type="hidden" value="{{ -@num_format($item_sell_line->amount) }}">
											@else											
												<input name="return_products[{{$indexForeach}}][payment_method][{{$key_sell_line}}][amount]" type="hidden" value="{{ @num_format($item_sell_line->amount) }}">
											@endif								
										@endforeach
									@endif
								</td>
								<td>
									<div class="return_subtotal"></div>
								</td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>
			<div class="row" style="display: none;">
				@php
				$discount_type = !empty($sell->return_parent->discount_type) ? $sell->return_parent->discount_type : $sell->discount_type;
				$discount_amount = !empty($sell->return_parent->discount_amount) ? $sell->return_parent->discount_amount : $sell->discount_amount;
				@endphp
				<div class="col-sm-4">
					<div class="form-group">
						{!! Form::label('discount_type', __( 'purchase.discount_type' ) . ':') !!}
						{!! Form::select('discount_type', [ '' => __('lang_v1.none'), 'fixed' => __( 'lang_v1.fixed' ), 'percentage' => __( 'lang_v1.percentage' )], $discount_type, ['class' => 'form-control']); !!}
					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group">
						{!! Form::label('discount_amount', __( 'purchase.discount_amount' ) . ':') !!}
						{!! Form::text('discount_amount', @num_format($discount_amount), ['class' => 'form-control input_number']); !!}
					</div>
				</div>
			</div>
			@php
			$tax_percent = 0;
			if(!empty($sell->tax)){
			$tax_percent = $sell->tax->amount;
			}
			@endphp
			{!! Form::hidden('tax_id', $sell->tax_id); !!}
			{!! Form::hidden('tax_amount', $sell->tax_amount, ['id' => 'tax_amount']); !!}
			{!! Form::hidden('tax_percent', $sell->tax->amount ?? 0 , ['id' => 'tax_percent']); !!}
			{!! Form::hidden('total_return_discount_amount', null, ['id' => 'total_return_discount_amount']) !!}
			<div class="row">
				<div class="col-sm-12 text-right">
					<strong>@lang('lang_v1.total_return_discount'):</strong>
					&nbsp;(-) <span id="total_return_discount"></span>
				</div>
				<div class="col-sm-12 text-right">
					<strong>@lang('lang_v1.total_return_tax') - @if(!empty($sell->tax))({{$sell->tax->name}} - {{$sell->tax->amount}}%)@endif : </strong>
					&nbsp;(+) <span id="total_return_tax">{{ $sell->tax_amount }}</span>
				</div>
				<div class="col-sm-12 text-right">
					<strong>@lang('lang_v1.return_total'): </strong>&nbsp;
					<span id="net_return">0</span>
					<input type="hidden" id="net_return_input">
				</div>
			</div>
			<br>
			<div class="row">
				@if (!$disable_return)
				<div class="col-sm-12">
					<button type="submit" id="complete_return_submit" class="btn btn-primary pull-right">@lang('messages.complete_return')</button>
				</div>
				@endif
			</div>
		</div>
	</div>

	@component('components.widget', ['class' => 'box-solid hide', 'id' => 'componen_exchange' ])
		<div class="col-sm-10 col-sm-offset-1">
			<input type="hidden" id="select_location_id" name="location_id" value="{{$default_location}}">
			<input type="hidden" name="status" id="status" value="final">
			<input type="hidden" name="is_direct_sale" value="1">
			{!! Form::hidden('types_of_service_price_group', null, ['id' => 'types_of_service_price_group']) !!}
			{!! Form::hidden('default_price_group', null, ['id' => 'default_price_group']) !!}
			<input type="hidden" name="tax_calculation_amount" id="tax_calculation_amount" 
			value="@if(empty($edit)) {{@num_format($business_details->tax_calculation_amount)}} @else {{@num_format($transaction->tax?->amount)}} @endif" data-default="{{$business_details->tax_calculation_amount}}">
			<div class="form-group">
				<div class="input-group" style="width: 100%;">
					<div class="input-group-btn hide">
						<button type="button" class="btn btn-default bg-white btn-flat" data-toggle="modal" data-target="#configure_search_modal" title="{{__('lang_v1.configure_product_search')}}"><i class="fas fa-search-plus"></i></button>
					</div>
					{!! Form::text('search_product', null, ['class' => 'form-control mousetrap', 'id' => 'search_product', 'placeholder' => __('lang_v1.search_product_placeholder'),					
					'disabled' => $default_location ? false : true,
					'autofocus' => $default_location ? false : true,
					]); !!}
					<span class="input-group-btn hide">
						<button type="button" class="btn btn-default bg-white btn-flat pos_add_quick_product" data-href="{{action([\App\Http\Controllers\ProductController::class, 'quickAdd'])}}" data-container=".quick_add_product_modal"><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
					</span>
				</div>
			</div>
		</div>

		<div class="row col-sm-12 pos_product_div" style="min-height: 0">

			<input type="hidden" name="sell_price_tax" id="sell_price_tax" value="{{$business_details->sell_price_tax}}">

			<!-- Keeps count of product rows -->
			<input type="hidden" id="product_row_count" 
				value="0">
			@php
				$hide_tax = '';
				if( session()->get('business.enable_inline_tax') == 0){
					$hide_tax = 'hide';
				}
			@endphp
			<div class="table-responsive">
			<table class="table table-condensed table-bordered table-striped table-responsive" id="pos_table">
				<thead>
					<tr>
						<th class="text-center">	
							@lang('sale.product')
						</th>
						<th class="text-center">
							@lang('sale.qty') 
						</th>
						@if(!empty($pos_settings['inline_service_staff']))
							<th class="text-center">
								@lang('restaurant.service_staff')
							</th>
						@endif
						<th class="@if(!auth()->user()->can('edit_product_price_from_sale_screen')) hide @endif">
							@lang('sale.unit_price')
						</th>
						<th class="@if(!auth()->user()->can('edit_product_discount_from_sale_screen')) hide @endif">
							@lang('receipt.discount')
						</th>
						<th class="text-center {{$hide_tax}}">
							@lang('sale.tax')
						</th>
						<th class="text-center {{$hide_tax}}">
							@lang('sale.price_inc_tax')
						</th>
						@if(!empty($common_settings['enable_product_warranty']))
							<th class="{{$hide_tax}}">@lang('lang_v1.warranty')</th>
						@endif
						<th class="text-center">
							@lang('sale.subtotal')
						</th>
						<th class="text-center"><i class="fas fa-times" aria-hidden="true"></i></th>
					</tr>
				</thead>
				<tbody></tbody>
			</table>
			</div>
			<div class="table-responsive">
			<table class="table table-condensed table-bordered table-striped">
				<tr>
					<td>
						<div class="pull-right">
						<b>@lang('sale.item'):</b> 
						<span class="total_quantity">0</span>
						&nbsp;&nbsp;&nbsp;&nbsp;
						<b>@lang( 'sale.sales_tax' ):</b>(+) 
						<span class="display_currency" id="order_tax">0</span>
						&nbsp;&nbsp;&nbsp;&nbsp;
						<b>@lang('sale.total'): </b>
						<input type="hidden" name="final_total" id="final_total_input" value="">
						<span class="total_payable_span" id="total_payable">0</span>						
						</div>
					</td>
				</tr>
			</table>
			</div>
		</div>
		<br>
		<div class="row">
			<div class="col-sm-12">
				<button type="submit" id="complete_exchange_submit" class="btn btn-primary pull-right" onclick="checkAmount(event)">@lang('messages.complete_exchange')</button>
			</div>
		</div>
	@endcomponent
	{!! Form::close() !!}

</section>
@stop
@section('javascript')
<script src="{{ asset('js/printer.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/sell_return.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
{{-- because using pos.js and need add bootstrap-multiselect  --}}
{{-- <script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script> --}}
{{-- <script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script> --}}
<script src="{{asset('js/bootstrap-multiselect.min.js')}}"></script>
@if(in_array('tables' ,$enabled_modules) || in_array('modifiers' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules))
	<script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
@endif
<script type="text/javascript">
	$(document).ready(function() {
		$('form#sell_return_form').validate();
		update_sell_return_total();		
		//Date picker
		// $('#transaction_date').datepicker({
		//     autoclose: true,
		//     format: datepicker_date_format
		// });
	});
	$(document).on('change', 'input.return_qty, #discount_amount, #discount_type', function() {
		update_sell_return_total()
	});

	function update_sell_return_total() {
		var net_return = 0;
		$('table#sell_return_table tbody tr').each(function() {
			var quantity = __read_number($(this).find('input.return_qty'));
			var unit_price = __read_number($(this).find('input.unit_price'));
			var subtotal = quantity * unit_price;
			$(this).find('.return_subtotal').text(__currency_trans_from_en(subtotal, true));
			net_return += subtotal;
		});
		var discount = 0;
		if ($('#discount_type').val() == 'fixed') {
			discount = __read_number($("#discount_amount"));
		} else if ($('#discount_type').val() == 'percentage') {
			var discount_percent = __read_number($("#discount_amount"));
			discount = __calculate_amount('percentage', discount_percent, net_return);
		}
		discounted_net_return = net_return - discount;
		$('#total_return_discount_amount').val(discount);

		var tax_percent = $('input#tax_percent').val();
		var total_tax = __calculate_amount('percentage', tax_percent, discounted_net_return);
		var net_return_inc_tax = total_tax + discounted_net_return;

		$('input#net_return_input').val(net_return_inc_tax);
		$('input#tax_amount').val(total_tax);
		$('span#total_return_discount').text(__currency_trans_from_en(discount, true));
		$('span#total_return_tax').text(__currency_trans_from_en(total_tax, true));
		$('span#net_return').text(__currency_trans_from_en(net_return_inc_tax, true));
	}

	if($('.payment_types_dropdown').length){
		$('.payment_types_dropdown').change();
	}
</script>
@endsection