@extends('layouts.vhai')
@section('content')
<div class="d-flex justify-content-between align-items-center">
    <div class="dropdown">
        <button class="btn btn-secondary dropdown-toggle" type="button" id="modeDropdown" data-bs-toggle="dropdown" aria-expanded="false" style="background-color: #00A67E;">
            Chat Mode
        </button>
        <ul class="dropdown-menu" aria-labelledby="modeDropdown">
            <li><a class="dropdown-item" href="#" data-mode="chat">Chat Mode</a></li>
            <li><a class="dropdown-item" href="#" data-mode="report">Report Mode</a></li>
        </ul>
    </div>
</div>

<script>
    $(document).on("click", ".dropdown-item", function(e) {
        e.preventDefault();
        var mode = $(this).data("mode");
        var chatCardHeader = $("#chat-card-header");
        var modeDropdown = $("#modeDropdown");

        if (mode === "chat") {
            chatCardHeader.css("background-color", "#00A67E");
            modeDropdown.css("background-color", "#00A67E");
            modeDropdown.text("Chat Mode");
        } else if (mode === "report") {
            chatCardHeader.css("background-color", "dodgerblue");
            modeDropdown.css("background-color", "dodgerblue");
            modeDropdown.text("Report Mode");
        }
    });
</script>
@endsection
<div class="card shadow-lg" style="border-radius: 15px; padding-top: 5px; box-shadow: 0 1rem 1rem rgba(0,0,0,.175) !important;">
    <div id="chat-card-header" class="card-header d-flex justify-content-between align-items-center p-3 text-white border-bottom-0"
        style="border-top-left-radius: 15px; border-top-right-radius: 15px; background-color: #00A67E;">
        <p class="mb-0 fw-bold text-center w-100">Ask VH-AI</p>
    </div>
    <div class="card-body" style="padding: 0px;">
        <div id="chat-box" style="height: 280px; background: white; border-radius: 10px; padding: 10px;" class="overflow-auto shadow-sm"></div>
        <div class="form-outline mt-3">
            <form id="ask-vhai-form">
                @csrf
                <div>
                    <textarea class="form-control" name="prompt" placeholder="Type your question..." style="border-radius: 10px;  resize: none;"></textarea>
                </div>
                <button type="submit" id="submit-btn" class="btn float-right mt-2 shadow-sm" style="display: none;">Send</button>
            </form>
        </div>
    </div>
</div>

<template id="user-message-box-template">
    <div class="d-flex flex-row justify-content-end mb-4">
        <div class="p-3 me-3 border shadow-sm" style="border-radius: 15px; background-color: #e0f7fa;">
            <p class="small mb-0" id="message-box-text"></p>
        </div>
        <!-- <img class="ml-2 rounded-circle" src="{{ asset('images/avatar-icon.png') }}" alt="avatar-icon" style="width: 30px; height: 30px;"> -->
    </div>
</template>

<template id="vhai-message-box-template">
    <div class="d-flex flex-row justify-content-start mb-4">
        <img src="{{ asset('images/AI.png') }}" alt="vh-ai-logo" class="mr-2 rounded-circle"
            style="width: 30px; height: 30px;">
        <div class="p-3 ms-3 shadow-sm" style="border-radius: 15px; background-color: rgba(0, 166, 126, .2);">
            <p class="small mb-0" id="message-box-text"></p>
        </div>
    </div>
</template>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function generateChatBoxMessage(isVHAIMessage, messageText) {
        // Get message template
        var template = (isVHAIMessage ? $("#vhai-message-box-template").html() : $("#user-message-box-template").html())
        var messageBox = $(template);
        messageBox.find('#message-box-text').text(messageText);
        $('#chat-box').append(messageBox);

        var chatBox = document.getElementById("chat-box");
        chatBox.scrollTop = chatBox.scrollHeight;
    }

    $(document).on("keydown", "textarea[name='prompt']", function(e) {
        if (e.key === "Enter" && !e.shiftKey) {
            e.preventDefault();
            $("#submit-btn").click();
        }
    });

    $(document).on("click", "#submit-btn", function(e) {
        e.preventDefault();

        var form = $("#ask-vhai-form");
        var formData = form.serialize();
        
        var textarea = form.find('textarea[name="prompt"]');
        generateChatBoxMessage(false, textarea.val());
        textarea.val('');
        formData += '&mode=' + $("#modeDropdown").text().trim();
        
        $.ajax({
            type: "post",
            url: '/vhai/ask',
            data: formData,
            success: function(data) {
                //generateChatBoxMessage(true, answer)
                //console.log("after /vhai/ask data:");
                //console.log(data);
                if (data.status === "success") {
                    if (data.data === "chat") {
                        generateChatBoxMessage(true, data.answer);
                    } else {
                        window.parent.postMessage({
                            type: 'showQueryModal',
                            data: data.data,
                            prompt: data.prompt,
                            answer: data.answer,
                            id: data.id
                        }, '*');
                        console.log("Event triggered with data");
                    }

                } else {
                    window.parent.postMessage({
                        type: 'showQueryModal',
                        error: data.error
                    }, '*');
                    console.log("Event triggered with error");
                    generateChatBoxMessage(true, "Sorry, I couldn't understand your question. Please try again.");
                }
            },
        });

    });
</script>