<?php

use App\Http\Controllers\AmazonController;
use App\Http\Controllers\ShopifyController;
use App\Http\Controllers\ApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/sync-amazon/{seller_id}', [AmazonController::class, 'syncWithEcommerce'])->middleware(['custom_auth', 'CheckUserLogin', 'SetSessionData']);
// Route::post('/sync-amazon', [AmazonController::class, 'syncWithEcommerce']);
Route::get('/get-all-webhook', [ShopifyController::class, 'webhookJson'])->middleware(['custom_auth', 'SetSessionData']);
// product create
Route::post('/shopify-webhook', [ShopifyController::class, 'shopifyWebhook'])->middleware(['custom_auth', 'SetSessionData']);
// product update
Route::post('/shopify-product-update-webhook', [ShopifyController::class, 'shopifyProductUpdateWebhook'])->middleware(['custom_auth', 'SetSessionData']);
// Route::get('/shopify-product-update-webhook', [ShopifyController::class, 'shopifyProductUpdateWebhook'])->middleware(['custom_auth', 'SetSessionData']);
// Route::put('/shopify-product-update-webhook', [ShopifyController::class, 'shopifyProductUpdateWebhook'])->middleware(['custom_auth', 'SetSessionData']);
// product sell
Route::post('/shopify-order-webhook', [ShopifyController::class, 'shopifyOrderWebhook'])->middleware(['custom_auth', 'SetSessionData']);

// mobile app login api
Route::post('/login', [ApiController::class, 'login']);
Route::get('/graph-image-keepa/{asin}', [ApiController::class, 'getGraphImageKeepa']);
Route::middleware(['auth:sanctum'])->group(function() {
    Route::post('/submit-data', [ApiController::class, 'submit_data']);
    Route::post('/logout', [ApiController::class, 'logout']);
});