<?php
use App\BusinessLocation;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\AccountReportsController;
use App\Http\Controllers\AccountTypeController;
use App\Http\Controllers\AmazonController;
use App\Http\Controllers\AmazonAuthController;
use App\Http\Controllers\EtsyController;
use App\Http\Controllers\Auth\LoginController;
// use App\Http\Controllers\Auth;
use App\Http\Controllers\BackUpController;
use App\Http\Controllers\BarcodeController;
use App\Http\Controllers\BigCommerceController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\BusinessController;
use App\Http\Controllers\BusinessLocationController;
use App\Http\Controllers\CashRegisterController;
use App\Http\Controllers\CashRegisterListController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CombinedPurchaseReturnController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\CustomerGroupController;
use App\Http\Controllers\DashboardConfiguratorController;
use App\Http\Controllers\DiscountController;
use App\Http\Controllers\DocumentAndNoteController;
use App\Http\Controllers\ExpenseCategoryController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\GroupTaxController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ImportOpeningStockController;
use App\Http\Controllers\ImportProductsController;
use App\Http\Controllers\ImportSalesController;
use App\Http\Controllers\Install;
use App\Http\Controllers\InvoiceLayoutController;
use App\Http\Controllers\InvoiceSchemeController;
use App\Http\Controllers\LabelsController;
use App\Http\Controllers\LedgerDiscountController;
use App\Http\Controllers\LocationSettingsController;
use App\Http\Controllers\ManageUserController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\NotificationTemplateController;
use App\Http\Controllers\OmniChannelServicesController;
use App\Http\Controllers\OpeningStockController;
use App\Http\Controllers\PrinterController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\PurchaseRequisitionController;
use App\Http\Controllers\PurchaseReturnController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\Restaurant;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SalesCommissionAgentController;
use App\Http\Controllers\SalesOrderController;
use App\Http\Controllers\SellController;
use App\Http\Controllers\SellingPriceGroupController;
use App\Http\Controllers\SellPosController;
use App\Http\Controllers\SellReturnController;
use App\Http\Controllers\ShopifyController; //PALIGU
use App\Http\Controllers\CardTransactionsController; //PALIGU
use App\Http\Controllers\QuickBooksController;
use App\Http\Controllers\ShopifyControllerUdb;
use App\Http\Controllers\StockAdjustmentController;
use App\Http\Controllers\StockTransferController;
use App\Http\Controllers\TaxonomyController;
use App\Http\Controllers\TaxRateController;
use App\Http\Controllers\TransactionPaymentController;
use App\Http\Controllers\TypesOfServiceController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VariationTemplateController;
use App\Http\Controllers\WalmartController;
use App\Http\Controllers\WarrantyController;
use App\Http\Controllers\WooCommerceController;
use App\VariationTemplate;
use Illuminate\Contracts\Session\Session;
use Illuminate\Support\Facades\Route;
use Twilio\Rest\Preview\TrustedComms\BusinessContext;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\VhAiController;
use App\Http\Controllers\VhaiFeedbackController;
use App\Http\Controllers\KeepaAsinsController;
use App\Http\Controllers\KeepaController;
use App\Http\Controllers\KeepaWebhookController;
use App\Http\Controllers\GoogleBooksController;
use App\Http\Controllers\MobileBarcodeScanner;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

include_once 'install_r.php';

// VHAI
Route::get('/vhai', [VhAiController::class, 'index'])->name('vhai.index');
Route::post('/vhai/ask', [VhAiController::class, 'ask'])->name('vhai.ask');
Route::post('/vhai-feedback', [VhaiFeedbackController::class, 'store'])->name('vhai.feedback.store');
Route::post('/vhai', [VhaiController::class, 'store']);
Route::get('/vhai/{id}', [VhaiController::class, 'show']);
Route::put('/vhai/{id}', [VhaiController::class, 'update']);
Route::delete('/vhai/{id}', [VhaiController::class, 'destroy']);
//

Route::middleware(['setData'])->group(function () {
    Route::get('/', function () {
        return view('welcome');
    });

    Auth::routes();

    // Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');

    Route::get('/business/register', [BusinessController::class, 'getRegister'])->name('business.getRegister');
    Route::post('/business/register', [BusinessController::class, 'postRegister'])->name('business.postRegister');
    Route::post('/business/register/check-username', [BusinessController::class, 'postCheckUsername'])->name('business.postCheckUsername');
    Route::post('/business/register/check-email', [BusinessController::class, 'postCheckEmail'])->name('business.postCheckEmail');

    Route::get('/invoice/{token}', [SellPosController::class, 'showInvoice'])
        ->name('show_invoice');
    Route::get('/quote/{token}', [SellPosController::class, 'showInvoice'])
        ->name('show_quote');

    Route::get('/pay/{token}', [SellPosController::class, 'invoicePayment'])
        ->name('invoice_payment');
    Route::post('/confirm-payment/{id}', [SellPosController::class, 'confirmPayment'])
        ->name('confirm_payment');
});

//Routes for authenticated users only
Route::middleware(['setData', 'auth', 'SetSessionData', 'language', 'timezone', 'AdminSidebarMenu', 'CheckUserLogin'])->group(function () {
    Route::get('pos/payment/{id}', [SellPosController::class, 'edit'])->name('edit-pos-payment');
    Route::get('service-staff-availability', [SellPosController::class, 'showServiceStaffAvailibility']);
    Route::get('pause-resume-service-staff-timer/{user_id}', [SellPosController::class, 'pauseResumeServiceStaffTimer']);
    Route::get('mark-as-available/{user_id}', [SellPosController::class, 'markAsAvailable']);

    Route::resource('purchase-requisition', PurchaseRequisitionController::class)->except(['edit', 'update']);
    Route::post('/get-requisition-products', [PurchaseRequisitionController::class, 'getRequisitionProducts'])->name('get-requisition-products');
    Route::get('get-purchase-requisitions/{location_id}', [PurchaseRequisitionController::class, 'getPurchaseRequisitions']);
    Route::get('get-purchase-requisition-lines/{purchase_requisition_id}', [PurchaseRequisitionController::class, 'getPurchaseRequisitionLines']);

    Route::get('/sign-in-as-user/{id}', [ManageUserController::class, 'signInAsUser'])->name('sign-in-as-user');

    Route::get('/home', [HomeController::class, 'index'])->name('home');
    Route::get('/home/get-totals', [HomeController::class, 'getTotals']);
    Route::get('/home/product-stock-alert', [HomeController::class, 'getProductStockAlert']);
    Route::get('/home/purchase-payment-dues', [HomeController::class, 'getPurchasePaymentDues']);
    Route::get('/home/sales-payment-dues', [HomeController::class, 'getSalesPaymentDues']);
    Route::post('/attach-medias-to-model', [HomeController::class, 'attachMediasToGivenModel'])->name('attach.medias.to.model');
    Route::get('/calendar', [HomeController::class, 'getCalendar'])->name('calendar');

    Route::post('/test-email', [BusinessController::class, 'testEmailConfiguration']);
    Route::post('/test-sms', [BusinessController::class, 'testSmsConfiguration']);
    Route::get('/business/settings', [BusinessController::class, 'getBusinessSettings'])->name('business.getBusinessSettings');
    Route::post('/business/update', [BusinessController::class, 'postBusinessSettings'])->name('business.postBusinessSettings');
    Route::get('/user/profile', [UserController::class, 'getProfile'])->name('user.getProfile');
    Route::post('/user/update', [UserController::class, 'updateProfile'])->name('user.updateProfile');
    Route::post('/user/update-password', [UserController::class, 'updatePassword'])->name('user.updatePassword');    

    Route::get('/login-management', [BusinessController::class, 'loginManagement']);
    Route::post('/login-management/update', [BusinessController::class, 'postBusinessLoginManagement'])->name('business.postBusinessLoginManagement');

    Route::resource('brands', BrandController::class);

    Route::resource('payment-account', 'PaymentAccountController');

    Route::resource('tax-rates', TaxRateController::class);

    Route::resource('units', UnitController::class);

    Route::resource('ledger-discount', LedgerDiscountController::class)->only('edit', 'destroy', 'store', 'update');

    Route::post('check-mobile', [ContactController::class, 'checkMobile']);
    Route::get('/get-contact-due/{contact_id}', [ContactController::class, 'getContactDue']);
    Route::get('/contacts/payments/{contact_id}', [ContactController::class, 'getContactPayments']);
    Route::get('/contacts/map', [ContactController::class, 'contactMap']);
    Route::get('/contacts/update-status/{id}', [ContactController::class, 'updateStatus']);
    Route::get('/contacts/stock-report/{supplier_id}', [ContactController::class, 'getSupplierStockReport']);
    Route::get('/contacts/ledger', [ContactController::class, 'getLedger']);
    Route::post('/contacts/send-ledger', [ContactController::class, 'sendLedger']);
    Route::get('/contacts/import', [ContactController::class, 'getImportContacts'])->name('contacts.import');
    Route::post('/contacts/import', [ContactController::class, 'postImportContacts']);
    Route::post('/contacts/check-contacts-id', [ContactController::class, 'checkContactId']);
    Route::get('/contacts/customers', [ContactController::class, 'getCustomers']);
    Route::resource('contacts', ContactController::class);

    Route::get('taxonomies-ajax-index-page', [TaxonomyController::class, 'getTaxonomyIndexPage']);
    Route::resource('taxonomies', TaxonomyController::class);

    Route::resource('variation-templates', VariationTemplateController::class);
    Route::post('variation-templates/check-name', [VariationTemplateController::class, 'postCheckVariationName']);

    Route::get('/products/download-excel', [ProductController::class, 'downloadExcel']);

    Route::get('/products/stock-history/{id}', [ProductController::class, 'productStockHistory']);
    Route::get('/delete-media/{media_id}', [ProductController::class, 'deleteMedia']);
    Route::post('/products/mass-deactivate', [ProductController::class, 'massDeactivate']);
    Route::get('/products/activate/{id}', [ProductController::class, 'activate']);
    Route::get('/products/view-product-group-price/{id}', [ProductController::class, 'viewGroupPrice']);
    Route::get('/products/add-selling-prices/{id}', [ProductController::class, 'addSellingPrices']);
    Route::post('/products/save-selling-prices', [ProductController::class, 'saveSellingPrices']);
    Route::post('/products/mass-delete', [ProductController::class, 'massDestroy']);
    Route::get('/products/view/{id}', [ProductController::class, 'view']);
    Route::get('/products/list', [ProductController::class, 'getProducts']);
    Route::get('/products/list-no-variation', [ProductController::class, 'getProductsWithoutVariations']);
    Route::post('/products/bulk-edit', [ProductController::class, 'bulkEdit']);
    Route::post('/products/bulk-update', [ProductController::class, 'bulkUpdate']);
    Route::post('/products/bulk-update-location', [ProductController::class, 'updateProductLocation']);
    Route::get('/products/get-product-to-edit/{product_id}', [ProductController::class, 'getProductToEdit']);
    Route::get('/products/product-analyzer', [ProductController::class, 'product_analyzer']); //ADRI
    Route::get('/products/product-analyzer-progress', [ProductController::class, 'checkProductAnalyzeProgress']); //ADRI
    Route::post('/products/store-product-analyzer', [ProductController::class, 'store_product_analyzer']); //ADRI

    Route::post('/products/get_sub_categories', [ProductController::class, 'getSubCategories']);
    Route::get('/products/get_sub_units', [ProductController::class, 'getSubUnits']);
    Route::post('/products/product_form_part', [ProductController::class, 'getProductVariationFormPart']);
    Route::post('/products/get_product_variation_row', [ProductController::class, 'getProductVariationRow']);
    Route::post('/products/get_variation_template', [ProductController::class, 'getVariationTemplate']);
    Route::get('/products/get_variation_value_row', [ProductController::class, 'getVariationValueRow']);
    Route::post('/products/check_product_sku', [ProductController::class, 'checkProductSku']);
    Route::post('/products/validate_variation_skus', [ProductController::class, 'validateVaritionSkus']); //validates multiple skus at once
    Route::get('/products/quick_add', [ProductController::class, 'quickAdd']);
    Route::post('/products/save_quick_product', [ProductController::class, 'saveQuickProduct']);
    Route::get('/products/get-combo-product-entry-row', [ProductController::class, 'getComboProductEntryRow']);
    Route::post('/products/toggle-woocommerce-sync', [ProductController::class, 'toggleWooCommerceSync']);
    Route::post('/products/save-state', [ProductController::class, 'saveStateList']);

    Route::resource('products', ProductController::class);
    
    Route::get('/toggle-subscription/{id}', 'SellPosController@toggleRecurringInvoices');
    Route::post('/sells/pos/get-types-of-service-details', 'SellPosController@getTypesOfServiceDetails');
    Route::get('/sells/subscriptions', 'SellPosController@listSubscriptions');
    Route::get('/sells/duplicate/{id}', 'SellController@duplicateSell');
    Route::get('/sells/drafts', 'SellController@getDrafts');
    Route::get('/sells/convert-to-draft/{id}', 'SellPosController@convertToInvoice');
    Route::get('/sells/convert-to-proforma/{id}', 'SellPosController@convertToProforma');
    Route::get('/sells/quotations', 'SellController@getQuotations');
    Route::get('/sells/draft-dt', 'SellController@getDraftDatables');
    Route::resource('sells', 'SellController')->except(['show']);
    Route::get('/sells/copy-quotation/{id}', [SellPosController::class, 'copyQuotation']);

    Route::post('/import-purchase-products', [PurchaseController::class, 'importPurchaseProducts']);
    Route::post('/purchases/update-status', [PurchaseController::class, 'updateStatus']);
    Route::get('/purchases/get_products', [PurchaseController::class, 'getProducts']);
    Route::get('/purchases/get_suppliers', [PurchaseController::class, 'getSuppliers']);
    Route::post('/purchases/get_purchase_entry_row', [PurchaseController::class, 'getPurchaseEntryRow']);
    Route::post('/purchases/check_ref_number', [PurchaseController::class, 'checkRefNumber']);
    Route::resource('purchases', PurchaseController::class)->except(['show']);

    Route::get('/toggle-subscription/{id}', [SellPosController::class, 'toggleRecurringInvoices']);
    Route::post('/sells/pos/get-types-of-service-details', [SellPosController::class, 'getTypesOfServiceDetails']);
    Route::get('/sells/subscriptions', [SellPosController::class, 'listSubscriptions']);
    Route::get('/sells/duplicate/{id}', [SellController::class, 'duplicateSell']);
    Route::get('/sells/drafts', [SellController::class, 'getDrafts']);
    Route::get('/sells/convert-to-draft/{id}', [SellPosController::class, 'convertToInvoice']);
    Route::get('/sells/convert-to-proforma/{id}', [SellPosController::class, 'convertToProforma']);
    Route::get('/sells/quotations', [SellController::class, 'getQuotations']);
    Route::get('/sells/draft-dt', [SellController::class, 'getDraftDatables']);
    Route::resource('sells', SellController::class)->except(['show']);

    Route::get('/import-sales', [ImportSalesController::class, 'index']);
    Route::post('/import-sales/preview', [ImportSalesController::class, 'preview']);
    Route::post('/import-sales', [ImportSalesController::class, 'import']);
    Route::get('/revert-sale-import/{batch}', [ImportSalesController::class, 'revertSaleImport']);

    Route::get('/sells/pos/get_product_row/{variation_id}/{location_id}', [SellPosController::class, 'getProductRow']);
    Route::post('/sells/pos/get_payment_row', [SellPosController::class, 'getPaymentRow']);
    Route::post('/sells/pos/card_pointe_authCard', [SellPosController::class, 'cardPointeAuthCard']); //PALIGU
    Route::post('/sells/pos/card_pointe_saveTransaction', [SellPosController::class, 'saveTransaction']); //PALIGU
    Route::post('/sells/pos/card_pointe_updateTransaction', [SellPosController::class, 'updateTransactionCardInvoice']); //ADRI
    Route::post('/sells/pos/get-reward-details', [SellPosController::class, 'getRewardDetails']);
    Route::get('/sells/pos/get-recent-transactions', [SellPosController::class, 'getRecentTransactions']);
    Route::get('/sells/pos/get-product-suggestion', [SellPosController::class, 'getProductSuggestion']);
    Route::get('/sells/pos/get-cash-registers-list', [SellPosController::class, 'getCashRegistersSuggestion']);
    Route::get('/sells/pos/get-featured-products/{location_id}', [SellPosController::class, 'getFeaturedProducts']);
    Route::get('/sells/pos/add_custom_product_row', [SellPosController::class, 'addCustomProductRow']);
    Route::get('/reset-mapping', [SellController::class, 'resetMapping']);
    Route::post('/sells/save-cash-drawer-opening', [SellPosController::class, 'saveCashDrawerOpenings']);
    Route::post('/sells/pos/label-price-save', [SellPosController::class, 'labelPriceSave']);
    
    Route::resource('pos', SellPosController::class);

    Route::get('/salesCustomerScreen', [SellPosController::class, 'salesCustomerScreen']);

    Route::resource('roles', RoleController::class);

    Route::resource('users', ManageUserController::class);

    Route::resource('group-taxes', GroupTaxController::class);

    Route::get('/barcodes/set_default/{id}', [BarcodeController::class, 'setDefault']);
    Route::get('/barcodes/popup-rule-based-settings', [BarcodeController::class, 'popupRuleBasedSettings']);
    Route::post('/barcodes/store-rule-based-settings', [BarcodeController::class, 'StoreRuleBasedPrintSettings']);
    Route::resource('barcodes', BarcodeController::class);

    //Invoice schemes..
    Route::get('/invoice-schemes/set_default/{id}', [InvoiceSchemeController::class, 'setDefault']);
    Route::resource('invoice-schemes', InvoiceSchemeController::class);

    //Print Labels
    Route::get('/labels/show', [LabelsController::class, 'show']);
    Route::get('/labels/add-product-row', [LabelsController::class, 'addProductRow']);
    Route::get('/labels/preview', [LabelsController::class, 'preview']);
    Route::post('/labels/update-settings', [LabelsController::class, 'updateSettings']);
    Route::post('/labels/add-to-print-label-queue', [LabelsController::class, 'addToPrintLabelQueue']);
    Route::post('/labels/delete-item-print-label-queue', [LabelsController::class, 'deleteItemPrintLabelQueue']);
    Route::get('/labels/popupPrintLabelsQueue', [LabelsController::class, 'popupPrintLabelsQueue']);
    Route::get('/labels/get-print-queue-count-by-user', [LabelsController::class, 'getPrintQueueCountByUser']);

    //Reports...
    Route::get('/reports/gst-purchase-report', [ReportController::class, 'gstPurchaseReport']);
    Route::get('/reports/gst-sales-report', [ReportController::class, 'gstSalesReport']);
    Route::get('/reports/get-stock-by-sell-price', [ReportController::class, 'getStockBySellingPrice']);
    Route::get('/reports/purchase-report', [ReportController::class, 'purchaseReport']);
    Route::get('/reports/sale-report', [ReportController::class, 'saleReport']);
    Route::get('/reports/service-staff-report', [ReportController::class, 'getServiceStaffReport']);
    Route::get('/reports/service-staff-line-orders', [ReportController::class, 'serviceStaffLineOrders']);
    Route::get('/reports/table-report', [ReportController::class, 'getTableReport']);
    Route::get('/reports/profit-loss', [ReportController::class, 'getProfitLoss']);
    Route::get('/reports/get-opening-stock', [ReportController::class, 'getOpeningStock']);
    Route::get('/reports/purchase-sell', [ReportController::class, 'getPurchaseSell']);
    Route::get('/reports/customer-supplier', [ReportController::class, 'getCustomerSuppliers']);
    Route::get('/reports/stock-report', [ReportController::class, 'getStockReport']);
    Route::get('/reports/stock-details', [ReportController::class, 'getStockDetails']);
    Route::get('/reports/tax-report', [ReportController::class, 'getTaxReport']);
    Route::get('/reports/tax-details', [ReportController::class, 'getTaxDetails']);
    Route::get('/reports/trending-products', [ReportController::class, 'getTrendingProducts']);
    Route::get('/reports/expense-report', [ReportController::class, 'getExpenseReport']);
    Route::get('/reports/stock-adjustment-report', [ReportController::class, 'getStockAdjustmentReport']);
    Route::get('/reports/register-report', [ReportController::class, 'getRegisterReport']);
    Route::get('/reports/sales-representative-report', [ReportController::class, 'getSalesRepresentativeReport']);
    Route::get('/reports/sales-representative-total-expense', [ReportController::class, 'getSalesRepresentativeTotalExpense']);
    Route::get('/reports/sales-representative-total-sell', [ReportController::class, 'getSalesRepresentativeTotalSell']);
    Route::get('/reports/sales-representative-total-commission', [ReportController::class, 'getSalesRepresentativeTotalCommission']);
    Route::get('/reports/stock-expiry', [ReportController::class, 'getStockExpiryReport']);
    Route::get('/reports/stock-expiry-edit-modal/{purchase_line_id}', [ReportController::class, 'getStockExpiryReportEditModal']);
    Route::post('/reports/stock-expiry-update', [ReportController::class, 'updateStockExpiryReport'])->name('updateStockExpiryReport');
    Route::get('/reports/customer-group', [ReportController::class, 'getCustomerGroup']);
    Route::get('/reports/product-purchase-report', [ReportController::class, 'getproductPurchaseReport']);
    Route::get('/reports/product-sell-grouped-by', [ReportController::class, 'productSellReportBy']);
    Route::get('/reports/product-sell-report', [ReportController::class, 'getproductSellReport']);
    Route::get('/reports/product-sell-report-with-purchase', [ReportController::class, 'getproductSellReportWithPurchase']);
    Route::get('/reports/product-sell-grouped-report', [ReportController::class, 'getproductSellGroupedReport']);
    Route::get('/reports/lot-report', [ReportController::class, 'getLotReport']);
    Route::get('/reports/purchase-payment-report', [ReportController::class, 'purchasePaymentReport']);
    Route::get('/reports/sell-payment-report', [ReportController::class, 'sellPaymentReport']);
    Route::get('/reports/product-stock-details', [ReportController::class, 'productStockDetails']);
    Route::get('/reports/adjust-product-stock', [ReportController::class, 'adjustProductStock']);
    Route::get('/reports/get-profit/{by?}', [ReportController::class, 'getProfit']);
    Route::get('/reports/items-report', [ReportController::class, 'itemsReport']);
    Route::get('/reports/get-stock-value', [ReportController::class, 'getStockValue']);
    Route::get('/reports/get-z-report', [ReportController::class, 'getZReport']);
    Route::get('/reports/card-transactions-report', [CardTransactionsController::class, 'getCardTransactionsReport']); //PALIGU
    Route::get('/reports/cash-drawer-report', [ReportController::class, 'getCashDrawerOpeningsReport']); //ADRI
    Route::get('/reports/sell-summary', [ReportController::class, 'getSellSummary']); //ADRI
    Route::get('/reports/barcode-print-history', [ReportController::class, 'getBarcodePrintHistory']); //ADRI
    Route::get('/reports/product-analyzer-history', [ReportController::class, 'getProductAnalyzerHistory']); //ADRI

    Route::get('business-location/activate-deactivate/{location_id}', [BusinessLocationController::class, 'activateDeactivateLocation']);

    //Business Location Settings...
    Route::prefix('business-location/{location_id}')->name('location.')->group(function () {
        Route::get('settings', [LocationSettingsController::class, 'index'])->name('settings');
        Route::post('settings', [LocationSettingsController::class, 'updateSettings'])->name('settings_update');
    });

    //Business Locations...
    Route::post('business-location/check-location-id', [BusinessLocationController::class, 'checkLocationId']);
    Route::resource('business-location', BusinessLocationController::class);
    Route::post('business-location/post-update/{id}', [BusinessLocationController::class, 'postUpdate']);

    //Invoice layouts..
    Route::resource('invoice-layouts', InvoiceLayoutController::class);

    Route::post('get-expense-sub-categories', [ExpenseCategoryController::class, 'getSubCategories']);

    //Expense Categories...
    Route::resource('expense-categories', ExpenseCategoryController::class);

    //Expenses...
    Route::resource('expenses', ExpenseController::class);
    Route::get('table_quickbooks', [ExpenseController::class, 'table_qb']);
    Route::get('table_trigger_qb', [OmniChannelServicesController::class, 'tableTriggerQb']);
    Route::get('table_customer_qb', [OmniChannelServicesController::class, 'tableCustomerQb']);
    Route::get('table_invoice_quickbooks', [OmniChannelServicesController::class, 'tableInvoiceQb']);
    Route::get('table_products_qb', [OmniChannelServicesController::class, 'tableProductsQb']);
    Route::post('/delete_trigger/{id}', [OmniChannelServicesController::class, 'destroyTrigger']);

    //Transaction payments...
    // Route::get('/payments/opening-balance/{contact_id}', 'TransactionPaymentController@getOpeningBalancePayments');
    Route::get('/payments/show-child-payments/{payment_id}', [TransactionPaymentController::class, 'showChildPayments']);
    Route::get('/payments/view-payment/{payment_id}', [TransactionPaymentController::class, 'viewPayment']);
    Route::get('/payments/add_payment/{transaction_id}', [TransactionPaymentController::class, 'addPayment']);    
    Route::get('/payments/pay-contact-due/{contact_id}', [TransactionPaymentController::class, 'getPayContactDue']);
    Route::post('/payments/pay-contact-due', [TransactionPaymentController::class, 'postPayContactDue']);
    Route::post('/payments/cancel-payment/{transaction_id}', [TransactionPaymentController::class, 'cancelPayment']);
    Route::resource('payments', TransactionPaymentController::class);

    //Printers...
    Route::resource('printers', PrinterController::class);

    Route::get('/stock-adjustments/remove-expired-stock/{purchase_line_id}', [StockAdjustmentController::class, 'removeExpiredStock']);
    Route::post('/stock-adjustments/get_product_row', [StockAdjustmentController::class, 'getProductRow']);
    Route::resource('stock-adjustments', StockAdjustmentController::class);

    Route::get('/cash-register/register-details', [CashRegisterController::class, 'getRegisterDetails']);
    Route::get('/cash-register/close-register/{id?}', [CashRegisterController::class, 'getCloseRegister']);
    Route::post('/cash-register/close-register', [CashRegisterController::class, 'postCloseRegister']);
    Route::resource('cash-register', CashRegisterController::class);
    
    Route::get('/cash-register/get-list/{id}', [CashRegisterController::class, 'getListCashRegister']);
    Route::resource('cash-register-list', CashRegisterListController::class);

    //Import products
    Route::get('/import-products', [ImportProductsController::class, 'index']);
    Route::post('/import-products/store', [ImportProductsController::class, 'store']);
    Route::get('/import-products/download-excel', [ImportProductsController::class, 'downloadExcel']);

    //Sales Commission Agent
    Route::resource('sales-commission-agents', SalesCommissionAgentController::class);

    //Stock Transfer
    Route::get('stock-transfers/print/{id}', [StockTransferController::class, 'printInvoice']);
    Route::post('stock-transfers/update-status/{id}', [StockTransferController::class, 'updateStatus']);
    Route::resource('stock-transfers', StockTransferController::class);

    Route::get('/opening-stock/add/{product_id}', [OpeningStockController::class, 'add']);
    Route::post('/opening-stock/save', [OpeningStockController::class, 'save']);

    //Customer Groups
    Route::resource('customer-group', CustomerGroupController::class);

    //Import opening stock
    Route::get('/import-opening-stock', [ImportOpeningStockController::class, 'index']);
    Route::post('/import-opening-stock/store', [ImportOpeningStockController::class, 'store']);

    //Sell return
    Route::get('validate-invoice-to-return/{invoice_no}', [SellReturnController::class, 'validateInvoiceToReturn']);
    Route::resource('sell-return', SellReturnController::class);
    Route::get('sell-return/get-product-row', [SellReturnController::class, 'getProductRow']);
    Route::get('/sell-return/print/{id}', [SellReturnController::class, 'printInvoice']);
    Route::get('/sell-return/add/{id}', [SellReturnController::class, 'add']);
    Route::get('/sell-return/inquiry-card-payment/{invoice_no_pos}', [SellReturnController::class, 'inquiryCardPayment']);

    //Backup
    Route::get('backup/download/{file_name}', [BackUpController::class, 'download']);
    Route::get('backup/delete/{file_name}', [BackUpController::class, 'delete']);
    Route::resource('backup', BackUpController::class)->only('index', 'create', 'store');

    Route::get('selling-price-group/activate-deactivate/{id}', [SellingPriceGroupController::class, 'activateDeactivate']);
    Route::get('export-selling-price-group', [SellingPriceGroupController::class, 'export']);
    Route::post('import-selling-price-group', [SellingPriceGroupController::class, 'import']);

    Route::resource('selling-price-group', SellingPriceGroupController::class);

    Route::resource('notification-templates', NotificationTemplateController::class)->only(['index', 'store']);
    Route::get('notification/get-template/{transaction_id}/{template_for}', [NotificationController::class, 'getTemplate']);
    Route::post('notification/send', [NotificationController::class, 'send']);

    Route::post('/purchase-return/update', [CombinedPurchaseReturnController::class, 'update']);
    Route::get('/purchase-return/edit/{id}', [CombinedPurchaseReturnController::class, 'edit']);
    Route::post('/purchase-return/save', [CombinedPurchaseReturnController::class, 'save']);
    Route::post('/purchase-return/get_product_row', [CombinedPurchaseReturnController::class, 'getProductRow']);
    Route::get('/purchase-return/create', [CombinedPurchaseReturnController::class, 'create']);
    Route::get('/purchase-return/add/{id}', [PurchaseReturnController::class, 'add']);
    Route::resource('/purchase-return', PurchaseReturnController::class)->except('create');

    Route::get('/discount/activate/{id}', [DiscountController::class, 'activate']);
    Route::post('/discount/mass-deactivate', [DiscountController::class, 'massDeactivate']);
    Route::resource('discount', DiscountController::class);

    Route::prefix('account')->group(function () {
        Route::resource('/account', AccountController::class);
        Route::get('/fund-transfer/{id}', [AccountController::class, 'getFundTransfer']);
        Route::post('/fund-transfer', [AccountController::class, 'postFundTransfer']);
        Route::get('/deposit/{id}', [AccountController::class, 'getDeposit']);
        Route::post('/deposit', [AccountController::class, 'postDeposit']);
        Route::get('/close/{id}', [AccountController::class, 'close']);
        Route::get('/activate/{id}', [AccountController::class, 'activate']);
        Route::get('/delete-account-transaction/{id}', [AccountController::class, 'destroyAccountTransaction']);
        Route::get('/edit-account-transaction/{id}', [AccountController::class, 'editAccountTransaction']);
        Route::post('/update-account-transaction/{id}', [AccountController::class, 'updateAccountTransaction']);
        Route::get('/get-account-balance/{id}', [AccountController::class, 'getAccountBalance']);
        Route::get('/balance-sheet', [AccountReportsController::class, 'balanceSheet']);
        Route::get('/trial-balance', [AccountReportsController::class, 'trialBalance']);
        Route::get('/payment-account-report', [AccountReportsController::class, 'paymentAccountReport']);
        Route::get('/link-account/{id}', [AccountReportsController::class, 'getLinkAccount']);
        Route::post('/link-account', [AccountReportsController::class, 'postLinkAccount']);
        Route::get('/cash-flow', [AccountController::class, 'cashFlow']);
    });

    Route::resource('account-types', AccountTypeController::class);

    //Restaurant module
    Route::prefix('modules')->group(function () {
        Route::resource('tables', Restaurant\TableController::class);
        Route::resource('modifiers', Restaurant\ModifierSetsController::class);

        //Map modifier to products
        Route::get('/product-modifiers/{id}/edit', [Restaurant\ProductModifierSetController::class, 'edit']);
        Route::post('/product-modifiers/{id}/update', [Restaurant\ProductModifierSetController::class, 'update']);
        Route::get('/product-modifiers/product-row/{product_id}', [Restaurant\ProductModifierSetController::class, 'product_row']);

        Route::get('/add-selected-modifiers', [Restaurant\ProductModifierSetController::class, 'add_selected_modifiers']);

        Route::get('/kitchen', [Restaurant\KitchenController::class, 'index']);
        Route::get('/kitchen/mark-as-cooked/{id}', [Restaurant\KitchenController::class, 'markAsCooked']);
        Route::post('/refresh-orders-list', [Restaurant\KitchenController::class, 'refreshOrdersList']);
        Route::post('/refresh-line-orders-list', [Restaurant\KitchenController::class, 'refreshLineOrdersList']);

        Route::get('/orders', [Restaurant\OrderController::class, 'index']);
        Route::get('/orders/mark-as-served/{id}', [Restaurant\OrderController::class, 'markAsServed']);
        Route::get('/data/get-pos-details', [Restaurant\DataController::class, 'getPosDetails']);
        Route::get('/orders/mark-line-order-as-served/{id}', [Restaurant\OrderController::class, 'markLineOrderAsServed']);
        Route::get('/print-line-order', [Restaurant\OrderController::class, 'printLineOrder']);
    });

    Route::get('bookings/get-todays-bookings', [Restaurant\BookingController::class, 'getTodaysBookings']);
    Route::resource('bookings', Restaurant\BookingController::class);

    Route::resource('types-of-service', TypesOfServiceController::class);
    Route::get('sells/edit-shipping/{id}', [SellController::class, 'editShipping']);
    Route::put('sells/update-shipping/{id}', [SellController::class, 'updateShipping']);
    Route::get('shipments', [SellController::class, 'shipments']);

    Route::post('upload-module', [Install\ModulesController::class, 'uploadModule']);
    Route::delete('manage-modules/destroy/{module_name}', [Install\ModulesController::class, 'destroy']);
    Route::resource('manage-modules', Install\ModulesController::class)
        ->only(['index', 'update']);
    Route::resource('warranties', WarrantyController::class);

    Route::resource('dashboard-configurator', DashboardConfiguratorController::class)
    ->only(['edit', 'update']);

    Route::get('view-media/{model_id}', [SellController::class, 'viewMedia']);

    //common controller for document & note
    Route::get('get-document-note-page', [DocumentAndNoteController::class, 'getDocAndNoteIndexPage']);
    Route::post('post-document-upload', [DocumentAndNoteController::class, 'postMedia']);
    Route::resource('note-documents', DocumentAndNoteController::class);
    Route::resource('purchase-order', PurchaseOrderController::class);
    Route::get('get-purchase-orders/{contact_id}', [PurchaseOrderController::class, 'getPurchaseOrders']);
    Route::get('get-purchase-order-lines/{purchase_order_id}', [PurchaseController::class, 'getPurchaseOrderLines']);
    Route::get('edit-purchase-orders/{id}/status', [PurchaseOrderController::class, 'getEditPurchaseOrderStatus']);
    Route::put('update-purchase-orders/{id}/status', [PurchaseOrderController::class, 'postEditPurchaseOrderStatus']);
    Route::resource('sales-order', SalesOrderController::class)->only(['index']);
    Route::get('get-sales-orders/{customer_id}', [SalesOrderController::class, 'getSalesOrders']);
    Route::get('get-sales-order-lines', [SellPosController::class, 'getSalesOrderLines']);
    Route::get('check-cash-register-open/{id}', [SellPosController::class, 'checkCashRegisterOpen']);
    Route::get('edit-sales-orders/{id}/status', [SalesOrderController::class, 'getEditSalesOrderStatus']);
    Route::put('update-sales-orders/{id}/status', [SalesOrderController::class, 'postEditSalesOrderStatus']);
    Route::get('reports/activity-log', [ReportController::class, 'activityLog']);
    Route::get('user-location/{latlng}', [HomeController::class, 'getUserLocation']);

    //shopify Controller
    Route::get('/shopify-auth', [ShopifyController::class, 'auth']); //PALIGU
    Route::get('/shopify/products', [ShopifyController::class, 'getShopifyTable']); //ADRI
    Route::get('/shopify/labels/{id}', [ShopifyController::class, 'labels']); //ADRI
    Route::get('/shopify/labels/show/preview', [ShopifyController::class, 'labelsPreview']); //ADRI
    Route::get('/shopify/update-product/modal/{sku}', [ShopifyController::class, 'updateProductModal']); //ADRI
    Route::get('/shopify/update-price-api/{sku}/{price}', [ShopifyController::class, 'updateShopifyProductPrice']); //ADRI
    Route::get('/shopify/popupSelectedItems', [ShopifyController::class, 'popupSelectedItems']); //ADRI
    Route::post('/shopify/updateOnAllShopify', [ShopifyController::class, 'updateOnAllShopify']); //ADRI
    Route::get('/shopify/update-quantity-api/{sku}/{quantity}', [ShopifyController::class, 'updateShopifyProductQuantity']); //ADRI
    Route::get('/shopify/product/preview/modal/{id}', [ShopifyController::class, 'getPreview']); //ADRI
    Route::get('/shopify/get-all-taxonomy-categories', [ShopifyController::class, 'getAllTaxonomyCategories']); //ADRI
    Route::get('/shopify/create-products-graphql', [ShopifyController::class, 'productCreateGraphQl']); //ADRI
    Route::get('/shopify/get-all-products-graphql', [ShopifyController::class, 'getAllShopifyProducts']); //ADRI
    Route::get('/shopify/get-all-collections-graphql', [ShopifyController::class, 'getAllShopifyCollections']); //ADRI
    Route::post('/shopify/store-product', [ShopifyController::class, 'StoreProduct']); //ADRI
    Route::get('/shopify/search-category', [ShopifyController::class, 'SearchCategory'])->name('ajax.search.categoryshopify'); //ADRI
    Route::get('/shopify/search-collections', [ShopifyController::class, 'SearchCollections'])->name('ajax.search.collectionshopify'); //ADRI
    Route::post('/shopify/send-to-shopify', [ShopifyController::class, 'SendToShopify']); //ADRI
    Route::get('/etsy/auth', [EtsyController::class, 'auth']); //PALIGU
    Route::get('/etsy/products', [EtsyController::class, 'fetchProducts']); //PALIGU
    Route::get('/shopify-udb-auth', [ShopifyControllerUdb::class, 'auth']); //PALIGU
    Route::post('/create-update-products', [ShopifyController::class, 'createUpdateProducts']); //Adri
    Route::get('/shopify/createShopifyProduct', [ShopifyController::class, 'createShopifyProduct'])->name('createShopifyProduct'); //Adri
    Route::get('/shopify/send-rank-below-ten-thousands-to-shopify', [ShopifyController::class, 'addProductRankBelowTenThousandsToCollectionBestSellers'])->name('addProductRankBelowTenThousandsToCollectionBestSellers'); //Adri
    Route::get('/shopify/send-rare-books-to-shopify', [ShopifyController::class, 'addProductHaveRareToCollectionRareBooks'])->name('addProductRankBelowTenThousandsToCollectionBestSellers'); //Adri
    Route::get('/shopify/send-signed-books-to-shopify', [ShopifyController::class, 'addProductHaveSignToCollectionSignedBooks'])->name('addProductRankBelowTenThousandsToCollectionBestSellers'); //Adri
    Route::get('/shopify/sendProductToAllShopify', [ShopifyController::class, 'sendProductToAllShopify']); //Adri
    Route::get('/shopify/getAllCollectionsAndProductsShopify/{store}', [ShopifyController::class, 'getAllCollectionsAndProductsShopify']); //Adri
    Route::get('/shopify/updateHandleProductShopify/{store}', [ShopifyController::class, 'updateHandleProductShopify']); //Adri
    Route::get('/shopify/testGraphQlBulk/{store}', [ShopifyController::class, 'testGraphQlBulk']); //Adri
    Route::get('/shopify/updatePrice15Percent/{store}', [ShopifyController::class, 'updatePrice15Percent']); //Adri
    //big-commerce controller
    Route::get('/bigcommerce-auth', [BigCommerceController::class, 'auth']); //ADRI
    //woo-commerce
    Route::get('/woocommerce-auth', [WooCommerceController::class, 'auth']); //ADRI
    // walmart
    Route::get('/walmart-auth', [WalmartController::class, 'auth']); //ADRI

    // amazon
    Route::get('/amazon-auth', [AmazonController::class, 'auth']); //ADRI
    Route::get('/amazon/orders', [AmazonController::class, 'getOrders']); //PALIGU
    Route::get('/amazon/updateAmazonTest', [AmazonController::class, 'updateAmazonTest']); //PALIGU -- WILL BE REMOVED
    Route::get('/amazon/products', [AmazonController::class, 'getProducts']); //PALIGU
    Route::get('/amazon/table/products/{sellerId}', [AmazonController::class, 'tableProducts']); //PALIGU
    Route::get('/amazon/product/preview/modal/{id}', [AmazonController::class, 'previewProduct']); //PALIGU
    Route::get('/amazon/labels/{id}', [AmazonController::class, 'labels']); //ADRI
    Route::get('/amazon/labels_multiple', [AmazonController::class, 'labelsMultiple']); //ADRI
    Route::get('/amazon/labels/show/preview', [AmazonController::class, 'labelsPreview']); //ADRI
    Route::get('/amazon/getProductDetails/{asin}/{isBarcodeScan}/{sellerId}', [AmazonController::class, 'getProductDetails']); //PALIGU
    Route::get('/amazon/getProductDetailByISBN/{isbn}/{sellerId}', [AmazonController::class, 'getProductDetailByISBN']); //PALIGU
    Route::get('/amazon/getProductDetailsNew/{sellerId}', [AmazonController::class, 'getProductDetailsNew']); //PALIGU
    Route::get('/amazon/getSellerListing/{sellerId}/{sku}', [AmazonController::class, 'getSellerListing']); //PALIGU
    Route::get('/amazon/requestInventoryReport/{sellerId}', [AmazonController::class, 'requestInventoryReport']); //PALIGU
    Route::get('/amazon/requestSellerPerformanceReport/{sellerId}', [AmazonController::class, 'requestSellerPerformanceReport']); //PALIGU
    Route::get('/amazon/getLatestFeedDocument/{sellerId}', [AmazonController::class, 'getLatestFeedDocument']); //PALIGU
    Route::get('/amazon/displayInventoryReport/{sellerId}', [AmazonController::class, 'displayInventoryReport']); //PALIGU
    Route::get('/amazon/getReportStatus/{reportId}', [AmazonController::class, 'getReportStatus']); //PALIGU
    Route::get('/amazon/updateSellerListingQuantity/{sellerId}/{sku}/{quantity}', [AmazonController::class, 'updateSellerListingQuantity']); //PALIGU
    Route::get('/amazon/updateSellerListingPrice/{sellerId}/{sku}/{price}', [AmazonController::class, 'updateSellerListingPrice']); //ADRI
    Route::get('/amazon/updateSellerListingPriceTest/{sellerId}/{sku}/{price}', [AmazonController::class, 'updateSellerListingPriceTest']); //PALIGU - WILL BE REMOVED
    Route::get('/amazon/updateSellerListingCondition/{sellerId}/{sku}/{condition}', [AmazonController::class, 'updateSellerListingCondition']); //ADRI
    Route::get('/amazon/create-amazon-product', [AmazonController::class, 'createAmazonProduct']); //ADRI
    Route::get('/amazon/getCompetitiveSummary/{sellerId}/{asin}', [AmazonController::class, 'getCompetitiveSummary']); //PALIGU
    Route::post('/amazon/createCompetitivePricesToDb', [AmazonController::class, 'createCompetitiveSummaryToDb']); //ADRI
    Route::get('/amazon/getFeaturedOfferExpectedPriceBatch/{sellerId}/{sellerSku}', [AmazonController::class, 'getFeaturedOfferExpectedPriceBatch']); //PALIGU
    Route::get('/amazon/salesAndTrafficByDate/{sellerId}/{startDate}/{endDate}/{aggregateBy}', [AmazonController::class, 'salesAndTrafficByDate']); //PALIGU
    Route::get('/amazon/checkSalesAndTrafficReport/{sellerId}/{startDate}/{endDate}/{aggregateBy}', [AmazonController::class, 'checkSalesAndTrafficReport'])->name('amazon.checkSalesAndTrafficReport'); // ADRI
    Route::get('/amazon/test-products', function() {
        $amazonService = new \App\Services\AmazonSpApiService();
        return $amazonService->getProducts();
    });
    Route::get('/amazon/checkDashboard/{sellerId}', [AmazonController::class, 'checkDashboard']); // ADRI
    Route::get('/amazon/update-amazon-table', [AmazonController::class, 'updateAmazonTable']);
    Route::get('/amazon/update-amazon-table-new', [AmazonController::class, 'updateAmazonTableNew']); //PALIGU - WILL BE REMOVED
    
    Route::get('/amazon/update-amazon-table-no-same-asin-sku', [AmazonController::class, 'UpdateAmazonTableSameAsinAndSkuDoesNotExists']); //Will be deleted UpdateAmazonTableSameAsinButNoSku
    
    Route::get('/amazon/authorize', [AmazonAuthController::class, 'redirectToAmazon'])->name('amazon.auth.redirect');
    Route::get('/amazon/callback', [AmazonAuthController::class, 'handleCallback'])->name('amazon.auth.callback');
    Route::get('/amazon/start-auth', [AmazonAuthController::class, 'showAuthorizationPage'])->name('amazon.auth.page');
    Route::get('/amazon/convert-amazon-to-shopify/{vendor}', [AmazonController::class, 'convertAmazonToShopify'])->name('amazon.convertAmazonToShopify');
    Route::get('/amazon/combine-amazon-products/{vendor}', [AmazonController::class, 'combineAmazonProducts'])->name('amazon.combineAmazonProducts');
    Route::get('/amazon/update-listing/modal/{sellerId}/{sku}/{title}', [AmazonController::class, 'updateListingModal'])->name('amazon.updateListingModal');
    Route::get('/amazon/popupSelectedItems', [AmazonController::class, 'popupSelectedItems']); // ADRI
    Route::get('/amazon/popupFindInAmazon', [AmazonController::class, 'popupFindInAmazon']); // ADRI
    Route::post('/amazon/updateOnAllAmazon', [AmazonController::class, 'updateOnAllAmazon']); // ADRI
    Route::get('/amazon/callApiKeepa/{asin}', [AmazonController::class, 'getApiKeepa']); // ADRI
    Route::get('/amazon/check-sync-progress', [AmazonController::class, 'checkSyncProgress'])->name('amazon.checkSyncProgress'); // ADRI
    Route::get('/amazon/add-progress-test', [AmazonController::class, 'addProgressTest'])->name('amazon.addProgressTest'); // ADRI
    Route::get('/amazon/test-create-product-using-feed', [AmazonController::class, 'createNewAmazonProductFeed']); // ADRI
    Route::get('/amazon/get-feed-status/{feedId}/{sellerId}', [AmazonController::class, 'getFeedStatus']); // ADRI
    Route::get('/amazon/get-all-product-types/{sellerId}', [AmazonController::class, 'getAllProductTypes']); // ADRI
    Route::get('/amazon/get-listing-items/{sellerId}', [AmazonController::class, 'getListingItems']); // ADRI
    Route::get('/check-job-status', [AmazonController::class, 'checkJobStatus'])->name('amazon.checkJobStatus'); // ADRI
    Route::get('/amazon/search-classifications', [AmazonController::class, 'SearchClassification'])->name('ajax.search.classificationAmazon'); //ADRI
    Route::get('/amazon/search-product-types', [AmazonController::class, 'SearchProductTypes'])->name('ajax.search.productTypeAmazon'); //ADRI
    Route::post('/amazon/store-product', [AmazonController::class, 'StoreProduct']); //ADRI
    Route::get('/amazon/products/list', [AmazonController::class, 'getProductsList']); //ADRI

    // Barcode Scanner
    Route::get('/barcode/scan', [MobileBarcodeScanner::class, 'showScanPage']);
    Route::post('/api/barcode/process', [MobileBarcodeScanner::class, 'processBarcode']);

    // Keepa
    Route::get('/keepa-auth', [KeepaController::class, 'auth']); //PALIGU
    Route::get('/keepa/product/{store}', [KeepaController::class, 'getAllProductsFromDB']); //PALIGU
    Route::post('/keepa/import', [KeepaController::class, 'import']); //PALIGU
    Route::get('/keepa/product/{store}/{asin}', [KeepaController::class, 'getProduct']); //PALIGU
    Route::get('/keepa/product/preview/modal/{id}', [KeepaController::class, 'view']); // ADRI
    Route::get('/keepa/labels/show/{id}', [KeepaController::class, 'labels']); // ADRI
    Route::get('/keepa/labels/preview', [KeepaController::class, 'labelsPreview']); // ADRI
    Route::get('/keepa/category/{category}', [KeepaController::class, 'allKeepaCategories']); //ADRI 
    Route::get('/keepa/product/api/{store}/{asin}', [KeepaController::class, 'getKeepaProduct']); //ADRI
    Route::post('/keepa/webhook', [KeepaWebhookController::class, 'handleWebhook']); //PALIGU
    Route::get('/keepa/asinList/{store}', [KeepaAsinsController::class, 'getKeepaAsins']); //PALIGU

    // Google Books
    Route::get('/googlebooks/{asin}', [GoogleBooksController::class, 'getBook']);

    // quickbooks
    Route::get('/quickbooks-auth', [QuickBooksController::class, 'auth']); //ADRI
    Route::get('/get_url_token_qb', [QuickBooksController::class, 'getUrlTokenQb']); //ADRI
    Route::get('/get-authorization-code', [QuickBooksController::class, 'getAuthorizationCode']); //ADRI
    Route::post('/void_or_delete_invoice_qb/{id}/{sync_token}', [QuickBooksController::class, 'voidDeleteQuickbooks']); //ADRI
    Route::post('/void_or_delete_all_sales_qb/{id}/{sync_token}', [QuickBooksController::class, 'voidDeleteAllSalesQuickbooks']); //ADRI
    Route::post('/update_invoice_qb', [QuickBooksController::class, 'updateInvoiceQb']); //ADRI
    Route::post('/update_all_sales_qb', [QuickBooksController::class, 'updateAllSalesQb']); //ADRI
    Route::get('/view_edit_invoice_qb', [QuickBooksController::class, 'viewEditInvoiceQb']); //ADRI 
    Route::get('/view_edit_all_sales_qb', [QuickBooksController::class, 'viewEditAllSalesQb']); //ADRI 
    Route::get('/get_data_all_sales_qb/{id}/{sync_token}', [QuickBooksController::class, 'getAllSalesDataQb']); //ADRI 

    // omni channels controller
    Route::get('/dashboard-vhomni', [OmniChannelServicesController::class, 'dashboard']);
    Route::get('/e-commerce-integration', [OmniChannelServicesController::class, 'geteCommerceIntegration']);
    Route::get('/marketplace-integration', [OmniChannelServicesController::class, 'getMarketplaceIntegration']);
    Route::get('/accounting-integration', [OmniChannelServicesController::class, 'getAccountingIntegration']);
    Route::get('/shipping-integration', [OmniChannelServicesController::class, 'getShippingIntegration']);
    Route::post('/post-omni-settings', [OmniChannelServicesController::class, 'postOmniSettings']);
    Route::post('/post-marketplace-omni', [OmniChannelServicesController::class, 'postMarketplaceOmni']);
    Route::post('/import-file-marketplace', [OmniChannelServicesController::class, 'importFileMarketplace']);
    Route::post('/post-accounting-omni', [OmniChannelServicesController::class, 'postAccountingOmni']);
    Route::post('/post-shipping-omni', [OmniChannelServicesController::class, 'postShippingOmni']);
    
    Route::get('/check-location-have-products', [OmniChannelServicesController::class, 'checkLocationHaveProducts']);
    Route::get('/trigger_action/{id}', [OmniChannelServicesController::class, 'getTriggerAction']);
    Route::post('/trigger_action_create', [OmniChannelServicesController::class, 'postTriggerAction']);
});

// Route::middleware(['EcomApi'])->prefix('api/ecom')->group(function () {
//     Route::get('products/{id?}', [ProductController::class, 'getProductsApi']);
//     Route::get('categories', [CategoryController::class, 'getCategoriesApi']);
//     Route::get('brands', [BrandController::class, 'getBrandsApi']);
//     Route::post('customers', [ContactController::class, 'postCustomersApi']);
//     Route::get('settings', [BusinessController::class, 'getEcomSettings']);
//     Route::get('variations', [ProductController::class, 'getVariationsApi']);
//     Route::post('orders', [SellPosController::class, 'placeOrdersApi']);
// });

//common route
Route::middleware(['auth'])->group(function () {
    Route::get('/logout', [App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');
});

Route::middleware(['setData', 'auth', 'SetSessionData', 'language', 'timezone'])->group(function () {
    Route::get('/load-more-notifications', [HomeController::class, 'loadMoreNotifications']);
    Route::get('/get-total-unread', [HomeController::class, 'getTotalUnreadNotifications']);
    Route::get('/purchases/print/{id}', [PurchaseController::class, 'printInvoice']);
    Route::get('/purchases/{id}', [PurchaseController::class, 'show']);
    Route::get('/download-purchase-order/{id}/pdf', [PurchaseOrderController::class, 'downloadPdf'])->name('purchaseOrder.downloadPdf');
    Route::get('/sells/{id}', [SellController::class, 'show']);
    Route::get('/sells/{transaction_id}/print', [SellPosController::class, 'printInvoice'])->name('sell.printInvoice');
    Route::get('/download-sells/{transaction_id}/pdf', [SellPosController::class, 'downloadPdf'])->name('sell.downloadPdf');
    Route::get('/download-quotation/{id}/pdf', [SellPosController::class, 'downloadQuotationPdf'])
        ->name('quotation.downloadPdf');
    Route::get('/download-packing-list/{id}/pdf', [SellPosController::class, 'downloadPackingListPdf'])
        ->name('packing.downloadPdf');
    Route::get('/sells/invoice-url/{id}', [SellPosController::class, 'showInvoiceUrl']);
    Route::get('/show-notification/{id}', [HomeController::class, 'showNotification']);
});

// sample open tab send data to previous tab
Route::get('/test-new-tab-session', function() {    
    return "<script>localStorage.setItem('quickbooks_token', JSON.stringify({rc: 200, msg: 'error'}));window.close();</script>";
});
