<?php

namespace App\Http\Controllers;

use App\Business;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\Transaction;
use App\Utils\ProductUtil;
use App\Variation;
use App\VariationLocationDetails;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;

use function PHPSTORM_META\map;

class AmazonController extends Controller
{
    protected $shopify;
    protected $shopify_udb;
    protected $productUtil;
    public $product_locations; 
    public $checkmarks; 

    public function __construct(ShopifyController $shopify, ShopifyControllerUdb $shopify_udb, ProductUtil $productUtil) {
        $this->shopify = $shopify;        
        $this->shopify_udb = $shopify_udb;        
        $this->productUtil = $productUtil;        
    }
    //
    public function auth(Request $request)
    {

        $this->product_locations = array($request->input('product_locations')); 
        $product_locations = array($request->input('product_locations')); 
        if(empty($product_locations)) {
            return response()->json([
                'message' => 'Location must be selected',
                'data' => null
            ]);
        }       
    
        $this->checkmarks = $request->input('checkmarks');
        $checkmarks = $request->input('checkmarks');
        // dd($checkmarks);
        if(empty($checkmarks)) {
            return response()->json([
                'message' => 'Please Selected Sync Item First',
                'data' => null
            ]);
        }

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('marketplace_settings')->first();

        $array_response = [
            'rc' => 200,
            'msg' => null
        ];

        $marketplace_settings = json_decode($business->marketplace_settings);
        if($marketplace_settings->amazon_api_url && $marketplace_settings->amazon_api_access_token && $marketplace_settings->amazon_api_key && $marketplace_settings->amazon_api_secret) {
            // $SHOPIFY_URL = getenv("SHOPIFY_URL");
            $AMAZON_URL = $marketplace_settings->amazon_api_url;
            // $AMAZON_CRED = getenv("AMAZON_CRED");        
            $AMAZON_CRED = $marketplace_settings->amazon_api_access_token;        
            $AMAZON_ID = $marketplace_settings->amazon_api_key;        
            $AMAZON_KEY = $marketplace_settings->amazon_api_secret;        
        } else {
            $AMAZON_URL = 'https://23.96.106.223:9091/api';
        }

        try {
            //code...
            $msg = null;
           
            $data = $this->get_data($AMAZON_URL, 'A2NODI4BBRA1B1');            
            $products = $this->save_products($data, 'A2NODI4BBRA1B1', 'USED BOOK DEPOT');  
            if($products['rc'] == 200) {                
                $msg = 'USED BOOK DEPOT Success';                
            } else {                
                $msg = 'USED BOOK DEPOT Data not found';                
            }
            if($products['rc'] == 200) {
                // $json_data2 = file_get_contents(public_path('A7YLKH07FY1LY.txt')); 
                // $data2 = json_decode($json_data2);
                $data2 = $this->get_data($AMAZON_URL, 'A7YLKH07FY1LY');              
                $products2 = $this->save_products($data2, 'A7YLKH07FY1LY', 'The Art of Savings'); 
                if($products2['rc'] == 200) {
                    $msg.= ', The Art of Savings Success';
                } else {
                    $msg.= ', The Art of Savings Data not found';                    
                }           
                if($products['rc'] == 200) {
                    // $json_data3 = file_get_contents(public_path('A13Y3JSUKFVTQ5.txt')); 
                    // $data3 = json_decode($json_data3);
                    $data3 = $this->get_data($AMAZON_URL, 'A13Y3JSUKFVTQ5');
                    $products3 = $this->save_products($data3, 'A13Y3JSUKFVTQ5', 'Pharos Bookstore');   
                    if($products3['rc'] == 200) {
                        $msg.= ', Pharos Bookstore Success';
                    } else {
                        $msg.= ', Pharos Bookstore Data not found';                    
                    }    
                }
            } 
            
            $array_response['msg'] = $msg;
            $body['amazon_checkbox'] = json_encode($checkmarks);
            $business = Business::find($business_id);         
            $business->fill($body);
            $business->save();
            if($array_response['rc'] == 200) {
                return response()->json([
                    'message' => 'Recevied Data ' . $msg,
                    'data' => null
                ]);
            } else {
                return response()->json([
                    'message' => 'Data Not Found',
                    'data' => null
                ]);
            }
        } catch (\Exception $err) {
            //throw $th;
            return response()->json([
                'message' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        }
    }

    public function get_data($url, $seller_id)
    {
        $ch = curl_init();

        // curl_setopt($ch, CURLOPT_URL, $url.'/inventory/sellerid='.$seller_id);        
        curl_setopt($ch, CURLOPT_URL, 'https://23.96.106.223:9091/api/Inventory?sellerid='.$seller_id);        
        curl_setopt($ch, CURLOPT_ENCODING, "");
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

        $headers = array();
        $headers[] = 'Accept: application/json';        
        $headers[] = 'Content-Type: application/json';
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        return json_decode($result, true);
    }

    public function save_products($data, $seller_id, $name)
    {
        DB::beginTransaction();
        $business_id = request()->session()->get('user.business_id');
        $business = Business::find($business_id);
        $amazon_checkbox = json_decode($business->amazon_checkbox);        
        $checkmarks_arr = [];
        foreach ($amazon_checkbox as $key => $val) {
            array_push($checkmarks_arr, $val->value);
        }
        /* $checkProductLocation = Product::join('variation_location_details as vld', 'vld.product_id', '=', 'products.id')
            ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id')
            ->whereNotNull('products.amazon_id')
            ->where('products.amazon_seller_id', $seller_id)
            ->select('products.id', 'products.name', 'bl.id as location_id', 'vld.variation_id')
            ->first();
        if(!empty($checkProductLocation)) {
            $deleteTransactions = DB::select("delete transactions from transactions join products on products.id = transactions.opening_stock_product_id and transactions.location_id = ? where products.amazon_id is not null", [$checkProductLocation->location_id]);                    
            $deleteVariationLocationDetails = DB::select("delete variation_location_details from variation_location_details join products on products.id = variation_location_details.product_id and variation_location_details.location_id = ? where products.amazon_id is not null", [$checkProductLocation->location_id]);                  
            DB::select("delete purchase_lines from purchase_lines join products on products.id = purchase_lines.product_id where products.amazon_id is not null");          
            DB::select("delete product_locations from product_locations join products on products.id = product_locations.product_id where products.amazon_id is not null");          
            DB::select("delete variations from variations join products on products.id = variations.product_id where products.amazon_id is not null");          
            DB::select("delete from products where amazon_id is not null");
        } */

        if($data) {
            $no = 0;
            $arr = [];
            $status = '';
            try {
                //code...
                foreach ($data as $key => $value) {
                    # code...
                    $checkProduct = Product::where('amazon_id', $value['productId'])->whereNull('shopify_id')->first();
                    if($checkProduct == null) {
                        $product = new Product();
                        if(in_array("name", $checkmarks_arr)) {
                            $product->name = $value['name'];
                        }
                        if(in_array("sku", $checkmarks_arr)) {
                            $product->sku = $value['sku'];
                        }
                        if(in_array("barcode", $checkmarks_arr)) {
                            $product->barcode = $value['sku'];
                        }
                        $product->type = 'single';
                        if(in_array("product_description", $checkmarks_arr)) {
                            $product->product_description = $value['description'];
                        }
                        $product->amazon_id = $value['productId'];
                        $product->amazon_seller_id = $seller_id;
                        $product->amazon_name = $name;
                        $product->amazon_asin = $value['asin1'];
                        $product->business_id = $business_id;
                        $product->enable_stock = 1;
                        $product->created_by = auth()->user()->id;
                        $product->save();
        
                        $product_variation = new ProductVariation();
                        $product_variation->name = "Default";
                        $product_variation->product_id = $product->id;
                        $product_variation->is_dummy = 0;
                        $product_variation->save();
        
                        $variation = new Variation();
                        $variation->name = 'Variation';
                        $variation->sub_sku = $value['sku'];
                        $variation->product_id = $product->id;
                        $variation->product_variation_id = $product_variation->id;
                        if(in_array('default_sell_price', $checkmarks_arr)) {
                            $variation->default_sell_price = $value['price'];
                            $variation->sell_price_inc_tax = $value['price'];
                        }
                        $variation->save();
        
                        $vld = new VariationLocationDetails();
                        $vld->product_id = $product->id;
                        $vld->product_variation_id = $product_variation->id;
                        $vld->variation_id = $variation->id;
                        $vld->location_id = 1;
                        $vld->qty_available = $value['quantity'];
                        $vld->save();
        
                        $transaction = new Transaction();
                        $transaction->business_id = $business_id;
                        $transaction->location_id = 1;
                        $transaction->type = 'opening_stock';
                        $transaction->status = 'received';
                        $transaction->is_quotation = 0;
                        $transaction->payment_status = 'paid';
                        $transaction->transaction_date = Carbon::now();
                        $transaction->total_before_tax = 0;
                        $transaction->tax_amount = 0;
                        $transaction->discount_amount = 0;
                        $transaction->rp_redeemed = 0;
                        $transaction->rp_redeemed_amount = 0;
                        $transaction->shipping_charges = 0;
                        $transaction->is_export = 0;
                        $transaction->round_off_amount = 0;
                        $transaction->additional_expense_value_1 = 0;
                        $transaction->additional_expense_value_2 = 0;
                        $transaction->additional_expense_value_3 = 0;
                        $transaction->additional_expense_value_4 = 0;
                        $transaction->final_total = 0;
                        $transaction->is_direct_sale = 0;
                        $transaction->is_suspend = 0;
                        $transaction->exchange_rate = 1;
                        $transaction->opening_stock_product_id = $product->id;
                        $transaction->created_by = auth()->user()->id;
                        $transaction->essentials_amount_per_unit_duration = auth()->user()->id;
                        $transaction->is_created_from_api = 1;
                        $transaction->rp_earned = 0;
                        $transaction->is_recurring = 0;
        
                        $transaction->save();
        
                        $purchase_lines = new PurchaseLine();
                        $purchase_lines->transaction_id = $transaction->id;
                        $purchase_lines->product_id = $product->id;
                        $purchase_lines->variation_id = $variation->id;
                        $purchase_lines->quantity = $value['quantity'];
                        $purchase_lines->purchase_price = 0;
                        $purchase_lines->save();
                    } else {
                        $product = Product::find($checkProduct->id);
                        if(in_array("name", $checkmarks_arr)) {
                            $product->name = $value['name'];
                        }
                        if(in_array("sku", $checkmarks_arr)) {
                            $product->sku = $value['sku'];
                        }
                        if(in_array("barcode", $checkmarks_arr)) {
                            $product->barcode = $value['sku'];
                        }                        
                        if(in_array("product_description", $checkmarks_arr)) {
                            $product->product_description = $value['description'];
                        }
                        // $product->name = $value['name'];
                        // $product->sku = $value['sku'];
                        $product->type = 'single';
                        // $product->product_description = $value['description'];
                        $product->amazon_id = $value['productId'];
                        $product->amazon_seller_id = $seller_id;
                        $product->amazon_name = $name;
                        $product->amazon_asin = $value['asin1'];
                        $product->business_id = $business_id;
                        $product->enable_stock = 1;
                        $product->created_by = auth()->user()->id;
                        $product->save();

                        $product_variation = ProductVariation::where('product_id', $product->id)->first();
                        $product_variation->name = "Default";
                        $product_variation->product_id = $product->id;
                        $product_variation->is_dummy = 0;
                        $product_variation->save();

                        $variation = Variation::where('product_id', $product->id)->where('product_variation_id', $product_variation->id)->first();
                        $variation->name = 'Variation';
                        $variation->sub_sku = $value['sku'];
                        $variation->product_id = $product->id;
                        $variation->product_variation_id = $product_variation->id;
                        if(in_array('default_sell_price', $checkmarks_arr)) {
                            $variation->default_sell_price = $value['price'];
                            $variation->sell_price_inc_tax = $value['price'];
                        }
                        $variation->save();
        
                        $vld = VariationLocationDetails::where('product_id', $product->id)->where('product_variation_id', $product_variation->id)->where('variation_id', $variation->id)->first();
                        $vld->product_id = $product->id;
                        $vld->product_variation_id = $product_variation->id;
                        $vld->variation_id = $variation->id;
                        $vld->location_id = 1;
                        $vld->qty_available = $value['quantity'];
                        $vld->save();                                
        
                        $purchase_lines = PurchaseLine::where('product_id', $product->id)->where('variation_id', $variation->id)->first();                        
                        $purchase_lines->product_id = $product->id;
                        $purchase_lines->variation_id = $variation->id;
                        $purchase_lines->quantity = $value['quantity'];
                        $purchase_lines->purchase_price = 0;
                        $purchase_lines->save();
                    }
                }
                DB::commit();
                return [
                    'rc' => 200,
                    'msg' => "Success"
                ];
            } catch (\Throwable $th) {
                //throw $th;                
                DB::rollBack();
                return [
                    'rc' => 500,
                    'msg' => "Something went wrong"
                ];
            }            
        }  else {        
            return [
                'rc' => 500,
                'msg' => "Data not found"
            ];   
        }
    }

    public function update_products($data, $seller_id, $name)
    {
        
        $business_id = request()->session()->get('user.business_id');
        /*
        if($data) {
            DB::beginTransaction();
            try {
                // UPDATE Queries
                DB::commit();
                return [
                    'rc' => 200,
                    'msg' => "Success"
                ];
            } catch (Exception $th) {
                DB::rollBack();
                return [
                    'rc' => 500,
                    'msg' => $th->getMessage()
                ];
            }   
            DB::commit();         
        }  else {        
            return [
                'rc' => 500,
                'msg' => "Data not found"
            ];   
        }
        */
    }

    public function syncWithEcommerce(Request $request, $seller_id) 
    {
        $data = $request->all();
        // $seller_id = $request->get('seller_id');        
        $business_id = auth()->user()->business_id;
        $business = Business::find($business_id);
        $e_commerce = json_decode($business->e_commerce_settings);
        $e_commerce_settings = json_decode($business->e_commerce_settings);
        // dd($e_commerce);
        $default_e_commerce = '';
        if($e_commerce->big_commerce_enable == 1) {
            $default_e_commerce = 'bigcommerce';
        } else if($e_commerce->shopify_enable == 1) {
            $default_e_commerce = 'shopify';
        } else if($e_commerce->woo_commerce_enable) {
            $default_e_commerce = 'woocomerrce';
        }        
        $amazon_option = json_decode($business->amazon_option);
        $create_option = false;
        $update_option = false;
        if($amazon_option) {
            if(property_exists($amazon_option, 'second_option')) {
                if(!empty($amazon_option->second_option)) {
                    foreach ($amazon_option->second_option as $key => $value) {
                        # code...
                        if($value == '21') {
                            $create_option = true;
                        } else if($value == '24') {
                            $update_option = true;
                        }
                    }
                }            
            }   
        }
        
        if(!empty($data)) {   

            $product_insert_array = [];     
            $product_update_array = [];
            $set_product_shopify_insert_array = [];
            $set_product_shopify_update_array = [];
            $inventory_item_id = null;
            $location_id = null;
            $available = null;
            $message = [];

            foreach ($data as $key => $value) {                
                // this is for demo or other servers except server ubd
                // $prd = Product::where('sku', $value['sku'])->where('shopify_id', $value['productId'])->first();
                $prd = Product::where('sku', $value['sku'])->whereNotNull('amazon_id')->first();                                
                // this is for server udb
                // $prd = Product::where('sku', $value['sku'])->where('used_book_id', $value['productId'])->orWhere('cheap_book_id', $value['productId])->first();

                if($prd == null) {
                    array_push($product_insert_array,$value);                    
                    // array_push($message,  [
                    //     'type' => 'Insert',
                    //     'product' => $value['sku']
                    // ]);
                } else {
                    array_push($product_update_array,$value);                    
                    // array_push($message,  [
                    //     'type' => 'Update',
                    //     'product' => $value['sku']
                    // ]);
                }         
                
                $prd_shopify = Product::where('sku', $value['sku'])->whereNotNull('shopify_id')->first();  
                // dd($prd, $prd_shopify);
                if($prd_shopify == null) {
                    if($create_option) {
                        array_push($set_product_shopify_insert_array, [
                            'id' => $value['productId'],
                            'title' => $value['name'],
                            "body_html"=> $value['description'],
                            "vendor"=> null,
                            "product_type"=> null,
                            "created_at"=> date('Y-m-dTH:i:s'),
                            "handle"=> null,
                            "updated_at"=> date('Y-m-dTH:i:s'),
                            "published_at"=> null,
                            "template_suffix"=> null,
                            "status"=> "active",
                            "published_scope"=> "web",
                            "tags"=> "",
                            "admin_graphql_api_id"=> "gid://shopify/Product/".$value['productId'],
                            "variants" => [
                                [
                                    "id" => $value['listingId'],
                                    "product_id"=> $value['productId'],
                                    "title"=> "Default Title",
                                    "price"=> $value['price'],
                                    "sku"=> $value['sku'],
                                    "position"=> 1,
                                    "inventory_policy"=> "deny",
                                    "compare_at_price"=> null,
                                    "fulfillment_service"=> "manual",
                                    "inventory_management"=> "shopify",
                                    "option1"=> "Default Title",
                                    "option2"=> null,
                                    "option3"=> null,
                                    "created_at"=> date('Y-m-dTH:i:s'),
                                    "updated_at"=> date('Y-m-dTH:i:s'),
                                    "taxable"=> true,
                                    "barcode"=> null,
                                    "grams"=> 0,
                                    "image_id"=> null,
                                    "weight"=> 0,
                                    "weight_unit"=> "lb",
                                    "inventory_item_id"=> $value['listingId'],
                                    "inventory_quantity"=> $value['quantity'],
                                    "old_inventory_quantity"=> $value['quantity'],
                                    "presentment_prices"=> [
                                        "price"=> [
                                            "amount"=> $value['price'],
                                            "currency_code"=> "USD"
                                        ],
                                        "compare_at_price"=> null
                                    ],
                                    "requires_shipping"=> true,
                                    "admin_graphql_api_id"=> "gid://shopify/ProductVariant/".$value["listingId"]
                                ]
                            ],
                            "options" => [
                                [
                                    "id"=> $value['listingId'],
                                    "product_id"=> $value['productId'],
                                    "name"=> "Title",
                                    "position"=> 1,
                                    "values"=> [
                                        "Default Title"
                                    ]
                                ]
                            ],
                            "images"=> [],
                            "image"=> null
                        ]);                        
                    }
                } else {
                    if($update_option) {
                        $get_product = $this->productUtil->getDetalProductShopify($prd_shopify->shopify_id, $e_commerce_settings);  
                        $inventory_item_id = $get_product['variants'][0]['inventory_item_id'];
                        $available = $value['quantity'];
                        $get_location = $this->productUtil->getInventoryLevelsShopify($inventory_item_id, $e_commerce_settings);
                        if(!empty($get_location)) {
                            $location_id = $get_location[0]['location_id'];                                           
                        }                          
                        array_push($set_product_shopify_update_array, [
                            'id' => $prd_shopify->shopify_id,
                            'title' => $value['name'],
                            "body_html"=> $value['description'],
                            "vendor"=> $get_product['vendor'],
                            "product_type"=> $get_product['product_type'],
                            "created_at"=> date('Y-m-dTH:i:s'),
                            "handle"=> $get_product['handle'],
                            "updated_at"=> date('Y-m-dTH:i:s'),
                            "published_at"=> $get_product['published_at'],
                            "template_suffix"=> $get_product['template_suffix'],
                            "status"=> "active",
                            "published_scope"=> "web",
                            "tags"=> $get_product['tags'],
                            "admin_graphql_api_id"=> "gid://shopify/Product/".$prd_shopify->shopify_id,
                            "variants" => [
                                [
                                    "id" => $get_product['variants'][0]['id'],
                                    "product_id"=> $prd_shopify->shopify_id,
                                    "title"=> "Default Title",
                                    "price"=> $value['price'],
                                    "sku"=> $value['sku'],
                                    "position"=> 1,
                                    "inventory_policy"=> "deny",
                                    "compare_at_price"=> $get_product['variants'][0]['compare_at_price'],
                                    "fulfillment_service"=> "manual",
                                    "inventory_management"=> "shopify",
                                    "option1"=> "Default Title",
                                    "option2"=> $get_product['variants'][0]['option2'],
                                    "option3"=> $get_product['variants'][0]['option3'],
                                    "created_at"=> date('Y-m-dTH:i:s'),
                                    "updated_at"=> date('Y-m-dTH:i:s'),
                                    "taxable"=> true,
                                    "barcode"=> $value['sku'],
                                    "grams"=> $get_product['variants'][0]['grams'],
                                    "image_id"=> $get_product['variants'][0]['image_id'],
                                    "weight"=> $get_product['variants'][0]['weight'],
                                    "weight_unit"=> "lb",
                                    "inventory_item_id"=> $get_product['variants'][0]['inventory_item_id'],
                                    "inventory_quantity"=> $value['quantity'],                                    
                                    "old_inventory_quantity"=> $get_product['variants'][0]['old_inventory_quantity'],                                    
                                    "presentment_prices"=> [
                                        "price"=> [
                                            "amount"=> $value['price'],
                                            "currency_code"=> "USD"
                                        ],
                                        "compare_at_price"=> null
                                    ],
                                    "requires_shipping"=> true,
                                    "admin_graphql_api_id"=> "gid://shopify/ProductVariant/".$get_product['variants'][0]['id']
                                ]
                            ],
                            "options" => [
                                [
                                    "id"=> $get_product['options'][0]['id'],
                                    "product_id"=> $prd_shopify->shopify_id,
                                    "name"=> "Title",
                                    "position"=> 1,
                                    "values"=> [
                                        "Default Title"
                                    ]
                                ]
                            ],
                            "images"=> $get_product['images'],
                            "image"=> $get_product['image'],
                            "inventory_item_id"=> $get_product['variants'][0]['inventory_item_id'],
                            "location_id"=> $location_id,
                            "available"=> $value['quantity'],
                        ]);                                                    
                    }
                }
            }

            // dd('seller_id: '.$seller_id, $product_insert_array, $product_update_array);
            
            if(!empty($product_insert_array)) {
                $this->save_products($product_insert_array, $seller_id, null);
            }   
            
            if(!empty($product_update_array)) {
                $this->save_products($product_update_array, $seller_id, null);
            }

            $checkmarks = [["name" => "checkmarks_amazon[]","value" => "name"],["name" => "checkmarks_amazon[]","value" => "product_description"],["name" => "checkmarks_amazon[]","value" => "category_id"],["name" => "checkmarks_amazon[]","value" => "brand_id"],["name" => "checkmarks_amazon[]","value" => "sku"],["name" => "checkmarks_amazon[]","value" => "barcode"],["name" => "checkmarks_amazon[]","value" => "default_sell_price"]];
            if(!empty($set_product_shopify_insert_array)){ //INSERT NEW PRODUCTS
                if($create_option) {                    
                    // except ubd
                    // $this->shopify->saveProducts($set_product_shopify_insert_array, null, [1], $checkmarks, $request);
                    $this->shopify->createUpdateProducts($request, $set_product_shopify_insert_array, 'create');
                    
                    // for ubd
                    // $this->shopify_udb->saveProducts($set_product_shopify_insert_array, null, [1], $checkmarks, $request->store, $request);
                    // $this->shopify_udb->createUpdateProducts($request, $set_product_shopify_insert_array, 'create');
                }
            }
                        
            if(!empty($set_product_shopify_update_array)){ //UPDATE PRODUCTS
                if($update_option) {
                    // $this->shopify->saveProducts($set_product_shopify_update_array, null, [1], $checkmarks, $request);
                    $this->shopify->createUpdateProducts($request, $set_product_shopify_update_array, 'update');
                }
            }
            

            $insert_count = count($product_insert_array);
            $update_count = count($product_update_array);


            return response([
                'product_inserted' => $insert_count,
                'product_updated' => $update_count
            ], 200);         

        } else {
            return response([
                'message' => 'Data not found'
            ], 500);  
        }
    }
}
