<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Business;
use App\Services\EtsyService;


class EtsyController extends Controller
{

    protected $etsyService;

    public function __construct(EtsyService $etsyService)
    {
        $this->etsyService = $etsyService;
    }

    public function fetchProducts()
    {
        $products = $this->etsyService->getProducts();

        return response()->json($products);
    }

    public function auth()
    {
        $this->etsyService->auth();
    }

    /*
    public function auth(Request $request)
    {
        // $product_locations = array($request->input('product_locations')); 
        // if(empty($product_locations)) {
        //   return response()->json([
        //     'message' => 'Location must be selected',
        //     'data' => null
        //   ]);
        // }       

        // $checkmarks = $request->input('checkmarks');
        // if(empty($checkmarks)) {
        //     return response()->json([
        //         'message' => 'Please Selected Sync Item First',
        //         'data' => null
        //     ]);
        // }

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->select('marketplace_settings')->first();

        $array_empty = [];
        $array_insert = [];

        // $marketplace_settings = json_decode($business->marketplace_settings);

        // if($marketplace_settings->walmart_api_url && $marketplace_settings->walmart_api_access_token && $marketplace_settings->walmart_api_key && $marketplace_settings->walmart_api_secret) {
        //   // $SHOPIFY_URL = getenv("SHOPIFY_URL");
        //   $WALMART_URL = $marketplace_settings->walmart_api_url;
        //   // $WALMART_CRED = getenv("WALMART_CRED");        
        //   $WALMART_CRED = $marketplace_settings->walmart_api_access_token;        
        //   $WALMART_ID = $marketplace_settings->walmart_api_key;        
        //   $WALMART_KEY = $marketplace_settings->walmart_api_secret;        
        // } else {
        //   return 'Url and Access Token Walmart Not Found';
        // }

        try {

            $get_token = $this->authorization();
            if (array_key_exists('access_token', $get_token)) {
                $session_token = $get_token['access_token'];
                $products = $this->fetchEtsyProducts();
                if ($products['totalItems'] > 0) {
                    $responseSaveProducts = $this->saveProducts();
                    array_push($array_insert, $responseSaveProducts);
                    if (array_key_exists('nextCursor', $get_token)) {
                        $products = $this->fetchEtsyProducts($get_token['nextCursor']);
                        $responseSaveProducts = $this->saveProducts();
                        array_push($array_insert, $responseSaveProducts);
                    }
                }
            }

            $body['etsy_checkbox'] = json_encode($checkmarks);
            $business = Business::find($business_id);
            $business->fill($body);
            $business->save();
            if (is_array($array_insert)) {
                return response()->json([
                    'message' => 'Recevied Data Success',
                    'data' => $array_insert
                ]);
            } else {
                return response()->json([
                    'message' => $array_insert,
                    'data' => null
                ]);
            }
        } catch (\Exception $err) {
            //throw $th;
            // dd($err);
            return response()->json([
                'message' => $err->getMessage(),
                // 'message' => __('messages.something_went_wrong'),
                'data' => null
            ]);
        }
    }
    */
    public static function authorization()
    {
        $url = "https://api.etsy.com/v3/public/oauth/token";
        $postFields = http_build_query([
            'grant_type'    => 'authorization_code',
            'client_id'     => env('ETSY_API_KEY'),
            'redirect_uri'  => env('ETSY_REDIRECT_URL'),
            'code'          => env('ETSY_ACCESS_TOKEN'),
            'code_verifier' => env('ETSY_CODE_VERIFIER'),
        ]);
        //dd($postFields);
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/x-www-form-urlencoded",
        ]);


        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        dd(json_decode($result, true));

        return json_decode($result, true);
    }

    function refreshAccessToken($refreshToken)
    {
        $url = "https://api.etsy.com/v3/public/oauth/token";
        $postFields = http_build_query([
            'grant_type'    => 'refresh_token',
            'client_id'     => env('ETSY_API_KEY'),
            'refresh_token' => $refreshToken,
        ]);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/x-www-form-urlencoded",
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }

    function fetchEtsyProducts()
    {
        $accessToken = env('ETSY_ACCESS_TOKEN'); // Use a valid token
        $shopId = env('ETSY_SHOP_ID');

        $url = "https://api.etsy.com/v3/application/shops/{$shopId}/listings/active";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer {$accessToken}",
            "x-api-key: " . env('ETSY_API_KEY'),
            "Accept: application/json",
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
