<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\KeepaAsins as KeepaAsinsModel;
use App\Services\KeepaService;

class KeepaAsinsController extends Controller
{
    protected $keepaService;

    public function __construct(KeepaService $keepaService)
    {
        $this->keepaService = $keepaService;
    }

    public function getKeepaAsins($store)
    {
        $asinData = $this->keepaService->getAsins($store);
        // Check if asin data is available
        if (empty($asinData)) {
            return response()->json(['error' => 'No ASINs found'], 404);
        }

        // Extract asin details
        $asins = explode("\n", $asinData);
        $asinList = [];
        foreach ($asins as $asin) {
            $asinList[] = [
                'business' => session('business'),
                'store' => $store,
                'asin' => $asin,
            ];
        }

        //check if any error or empty and save it to database if not exists
        foreach ($asinList as $asin) {
            $asinExists = KeepaAsinsModel::where('store', $asin['store'])
                ->where('asin', $asin['asin'])
                ->exists();
            if (!$asinExists) {
                KeepaAsinsModel::create($asin);
            }
        }

        return response()->json($asinData);
    }
    
}
