<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\KeepaService;
use App\Keepa;

class KeepaController extends Controller
{

    protected $keepaService;

    public function __construct(KeepaService $keepaService)
    {
        $this->keepaService = $keepaService;
    }

    public function getAllProductsFromDB($store){
        $products = Keepa::where('store', $store)->get();
        return response()->json($products);
    }

    public function getProduct($store, $asin)
    {
        $productData = $this->keepaService->getProduct($asin);

        // Check if product data is available
        if (!isset($productData['products']) || empty($productData['products'])) {
            return response()->json(['error' => 'Product not found'], 404);
        }

        $tokensLeft = $productData['tokensLeft'];
        $refillIn = $productData['refillIn'];
        $tokensConsumed = $productData['tokensConsumed'];
        
        // Extract product details
        $product = $productData['products'][0];

        $formattedProduct = [
            'store' => $store,
            'asin' => $product['asin'],
            'title' => $product['title'],
            'brand' => $product['brand'] ?? 'Unknown',
            'category' => $product['categoryTree'][0]['name'] ?? 'Unknown',
            'image' => explode(',', $product['imagesCSV'])[0] ?? null,
            'current_price' => $product['data']['price']['current'] ?? 'N/A',
            'highest_price' => $product['data']['price']['highest'] ?? 'N/A',
            'lowest_price' => $product['data']['price']['lowest'] ?? 'N/A',
            'productType' => $product['productType'] ?? null,
            'domainId' => $product['domainId'] ?? null,
            'trackingSince' => $product['trackingSince'] ?? null,
            'listedSince' => $product['listedSince'] ?? null,
            'lastUpdate' => $product['lastUpdate'] ?? null,
            'lastRatingUpdate' => $product['lastRatingUpdate'] ?? null,
            'lastPriceChange' => $product['lastPriceChange'] ?? null,
            'lastEbayUpdate' => $product['lastEbayUpdate'] ?? null,
            'lastStockUpdate' => $product['lastStockUpdate'] ?? null,
            'rootCategory' => $product['rootCategory'] ?? null,
            'categories' => $product['categories'] ?? [],
            'parentAsin' => $product['parentAsin'] ?? null,
            'parentAsinHistory' => $product['parentAsinHistory'] ?? [],
            'frequentlyBoughtTogether' => $product['frequentlyBoughtTogether'] ?? [],
            'eanList' => $product['eanList'] ?? [],
            'upcList' => $product['upcList'] ?? [],
            'manufacturer' => $product['manufacturer'] ?? null,
            'brandStoreName' => $product['brandStoreName'] ?? null,
            'brandStoreUrl' => $product['brandStoreUrl'] ?? null,
            'brandStoreUrlName' => $product['brandStoreUrlName'] ?? null,
            'productGroup' => $product['productGroup'] ?? null,
            'type' => $product['type'] ?? null,
            'partNumber' => $product['partNumber'] ?? null,
            'binding' => $product['binding'] ?? null,
            'scent' => $product['scent'] ?? null,
            'shortDescription' => $product['shortDescription'] ?? null,
            'activeIngredients' => $product['activeIngredients'] ?? null,
            'specialIngredients' => $product['specialIngredients'] ?? null,
            'itemForm' => $product['itemForm'] ?? null,
            'itemTypeKeyword' => $product['itemTypeKeyword'] ?? null,
            'recommendedUsesForProduct' => $product['recommendedUsesForProduct'] ?? null,
            'pattern' => $product['pattern'] ?? null,
            'specificUsesForProduct' => $product['specificUsesForProduct'] ?? [],
            'businessDiscount' => $product['businessDiscount'] ?? null,
            'lastBusinessDiscountUpdate' => $product['lastBusinessDiscountUpdate'] ?? null,
            'safetyWarning' => $product['safetyWarning'] ?? null,
            'productBenefit' => $product['productBenefit'] ?? null,
            'batteriesRequired' => $product['batteriesRequired'] ?? null,
            'batteriesIncluded' => $product['batteriesIncluded'] ?? null,
            'targetAudienceKeyword' => $product['targetAudienceKeyword'] ?? null,
            'style' => $product['style'] ?? null,
            'includedComponents' => $product['includedComponents'] ?? null,
            'material' => $product['material'] ?? null,
            'numberOfItems' => $product['numberOfItems'] ?? null,
            'numberOfPages' => $product['numberOfPages'] ?? null,
            'publicationDate' => $product['publicationDate'] ?? null,
            'releaseDate' => $product['releaseDate'] ?? null,
            'contributors' => $product['contributors'] ?? [],
            'languages' => $product['languages'] ?? [],
            'model' => $product['model'] ?? null,
            'color' => $product['color'] ?? null,
            'size' => $product['size'] ?? null,
            'edition' => $product['edition'] ?? null,
            'format' => $product['format'] ?? null,
            'features' => $product['features'] ?? [],
            'description' => $product['description'] ?? null,
            'hazardousMaterials' => $product['hazardousMaterials'] ?? [],
            'packageHeight' => $product['packageHeight'] ?? null,
            'packageLength' => $product['packageLength'] ?? null,
            'packageWidth' => $product['packageWidth'] ?? null,
            'packageWeight' => $product['packageWeight'] ?? null,
            'packageQuantity' => $product['packageQuantity'] ?? null,
            'itemHeight' => $product['itemHeight'] ?? null,
            'itemLength' => $product['itemLength'] ?? null,
            'itemWidth' => $product['itemWidth'] ?? null,
            'itemWeight' => $product['itemWeight'] ?? null,
            'availabilityAmazon' => $product['availabilityAmazon'] ?? null,
            'availabilityAmazonDelay' => $product['availabilityAmazonDelay'] ?? [],
            'buyBoxEligibleOfferCounts' => $product['buyBoxEligibleOfferCounts'] ?? [],
            'competitivePriceThreshold' => $product['competitivePriceThreshold'] ?? null,
            'suggestedLowerPrice' => $product['suggestedLowerPrice'] ?? null,
            'ebayListingIds' => $product['ebayListingIds'] ?? [],
            'isAdultProduct' => $product['isAdultProduct'] ?? null,
            'isHeatSensitive' => $product['isHeatSensitive'] ?? null,
            'isMerchOnDemand' => $product['isMerchOnDemand'] ?? null,
            'isHaul' => $product['isHaul'] ?? null,
            'launchpad' => $product['launchpad'] ?? null,
            'audienceRating' => $product['audienceRating'] ?? null,
            'ingredients' => $product['ingredients'] ?? null,
            'urlSlug' => $product['urlSlug'] ?? null,
            'returnRate' => $product['returnRate'] ?? null,
            'newPriceIsMAP' => $product['newPriceIsMAP'] ?? null,
            'isEligibleForTradeIn' => $product['isEligibleForTradeIn'] ?? null,
            'isEligibleForSuperSaverShipping' => $product['isEligibleForSuperSaverShipping'] ?? null,
            'fbaFees' => $product['fbaFees'] ?? null,
            'variableClosingFee' => $product['variableClosingFee'] ?? null,
            'referralFeePercentage' => $product['referralFeePercentage'] ?? null,
            'variations' => $product['variations'] ?? [],
            'coupon' => $product['coupon'] ?? [],
            'couponHistory' => $product['couponHistory'] ?? [],
            'promotions' => $product['promotions'] ?? [],
            'unitCount' => $product['unitCount'] ?? null,
            'stats' => $product['stats'] ?? null,
            'salesRankReference' => $product['salesRankReference'] ?? null,
            'salesRankReferenceHistory' => $product['salesRankReferenceHistory'] ?? [],
            'salesRanks' => $product['salesRanks'] ?? null,
            'lastSoldUpdate' => $product['lastSoldUpdate'] ?? null,
            'monthlySold' => $product['monthlySold'] ?? null,
            'monthlySoldHistory' => $product['monthlySoldHistory'] ?? [],
            'rentalDetails' => $product['rentalDetails'] ?? null,
            'rentalSellerId' => $product['rentalSellerId'] ?? null,
            'rentalPrices' => $product['rentalPrices'] ?? null,
            'reviews' => $product['reviews'] ?? null,
            'offers' => $product['offers'] ?? [],
            'liveOffersOrder' => $product['liveOffersOrder'] ?? [],
            'buyBoxSellerIdHistory' => $product['buyBoxSellerIdHistory'] ?? [],
            'buyBoxUsedHistory' => $product['buyBoxUsedHistory'] ?? [],
            'isRedirectASIN' => $product['isRedirectASIN'] ?? null,
            'isSNS' => $product['isSNS'] ?? null,
            'offersSuccessful' => $product['offersSuccessful'] ?? null,
            'csv' => $product['csv'] ?? []
        ];

        //check if any error or empty and save it to database if not exists
        if (!empty($formattedProduct) && !Keepa::where('asin', $formattedProduct['asin'])->exists()) {
            $formattedProduct = array_map(function($value) {
                return is_array($value) ? json_encode($value) : $value;
            }, $formattedProduct);

            Keepa::create($formattedProduct);
        }
        
        //return response()->json($formattedProduct);
        return response()->json($productData);
    }

    public function auth(Request $request)
    {
        // Our authentication logic can be here (if necessary)
    }
}
