<?php

namespace App\Http\Controllers;

use App\Business;
use App\BusinessLocation;
use App\Contact;
use App\Expense;
use App\Product;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;

use function PHPSTORM_META\map;

class OmniChannelServicesController extends Controller
{
    /**
     * Shows Omni Channel Services E-Commerce form
     *
     * @return \Illuminate\Http\Response
     */
    public function geteCommerceIntegration() {
        if (! auth()->user()->can('big_commerce.view', 'big_commerce.create', 'shopify.view', 'shopify.create', 'woo_commerce.view', 'woo_commerce.create', 'magento.view', 'magento.create')) {
            abort(403, 'Unauthorized action.');
        }        

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->first();
        $woo_commerce_checkbox = json_decode($business->woo_commerce_checkbox);    
        $shopify_checkbox = json_decode($business->shopify_checkbox);
        $big_commerce_checkbox = json_decode($business->big_commerce_checkbox);                        
        $business_locations = BusinessLocation::forDropdown($business_id, false, false);
        $reference_checkmarks = DB::table('checkmarks_vhomni')->get();                        

        $e_commerce_default['big_commerce_enable'] = 0;
        $e_commerce_default['shopify_enable'] = 0;
        $e_commerce_default['woo_commerce_enable'] = 0;
        $e_commerce_default['magento_enable'] = 0;
        
        $e_commerce_settings = empty($business->e_commerce_settings) ? $e_commerce_default : json_decode($business->e_commerce_settings, true);     
        // dd($e_commerce_settings);           
        $e_commerce_default['big_commerce_enable'] = $e_commerce_settings['big_commerce_enable'];
        $e_commerce_default['shopify_enable'] = $e_commerce_settings['shopify_enable'];
        $e_commerce_default['woo_commerce_enable'] = $e_commerce_settings['woo_commerce_enable'];
        $e_commerce_default['magento_enable'] = $e_commerce_settings['magento_enable'];

        $big_commerce_sync_settings = json_decode($business->big_commerce_sync_settings);
        $shopify_sync_settings = json_decode($business->shopify_sync_settings);
        $woo_commerce_sync_settings = json_decode($business->woo_commerce_sync_settings);
        // dd($woo_commerce_sync_settings, $big_commerce_sync_settings, $shopify_sync_settings);
        /* if(request()->getUri('https://demo.virtualhills.com/') || request()->getUri('https://ubdtx.virtualhills.com')) {
            return view('business.partials.settings_e_commerce_udb', compact('business', 'e_commerce_settings', 'e_commerce_default', 'business_locations', 'reference_checkmarks', 'woo_commerce_checkbox', 'shopify_checkbox', 'big_commerce_checkbox'));
        } else { */
            return view('business.partials.settings_e_commerce', compact('business', 'e_commerce_settings', 'e_commerce_default', 'business_locations', 'reference_checkmarks', 'woo_commerce_checkbox', 'shopify_checkbox', 'big_commerce_checkbox', 'big_commerce_sync_settings', 'shopify_sync_settings', 'woo_commerce_sync_settings'));
        // }
    }

    public function postOmniSettings(Request $request) {
        try {
            // dd($request->all());    
            $business_id = request()->session()->get('user.business_id');
            $business = Business::where('id', $business_id)->first();
            $e_commerce_settings = json_decode($business->e_commerce_settings);            
            // e-commerce integration settings        
            $e_commerce['big_commerce_enable'] = $request->input('big_commerce_enable') ? $request->input('big_commerce_enable') : $e_commerce_settings->big_commerce_enable ;
            $e_commerce['big_commerce_api_url'] = $request->input('big_commerce_api_url') ? $request->input('big_commerce_api_url') : $e_commerce_settings->big_commerce_api_url ;
            $e_commerce['big_commerce_api_access_token'] = $request->input('big_commerce_api_access_token') ? $request->input('big_commerce_api_access_token') : $e_commerce_settings->big_commerce_api_access_token ;
            $e_commerce['big_commerce_api_key'] = $request->input('big_commerce_api_key') ? $request->input('big_commerce_api_key') : $e_commerce_settings->big_commerce_api_key ;
            $e_commerce['big_commerce_api_secret'] = $request->input('big_commerce_api_secret') ? $request->input('big_commerce_api_secret') : $e_commerce_settings->big_commerce_api_secret ;
            $e_commerce['shopify_enable'] = $request->input('shopify_enable') ? $request->input('shopify_enable') : $e_commerce_settings->shopify_enable ;
            $e_commerce['shopify_api_url'] = $request->input('shopify_api_url') ? $request->input('shopify_api_url') : $e_commerce_settings->shopify_api_url ;
            $e_commerce['shopify_api_access_token'] = $request->input('shopify_api_access_token') ? $request->input('shopify_api_access_token') : $e_commerce_settings->shopify_api_access_token ;
            $e_commerce['shopify_api_key'] = $request->input('shopify_api_key') ? $request->input('shopify_api_key') : $e_commerce_settings->shopify_api_key ;
            $e_commerce['shopify_api_secret'] = $request->input('shopify_api_secret') ? $request->input('shopify_api_secret') : $e_commerce_settings->shopify_api_secret ;
            $e_commerce['woo_commerce_enable'] = $request->input('woo_commerce_enable') ? $request->input('woo_commerce_enable') : $e_commerce_settings->woo_commerce_enable ;
            $e_commerce['woo_commerce_api_url'] = $request->input('woo_commerce_api_url') ? $request->input('woo_commerce_api_url') : $e_commerce_settings->woo_commerce_api_url ;
            $e_commerce['woo_commerce_api_access_token'] = $request->input('woo_commerce_api_access_token') ? $request->input('woo_commerce_api_access_token') : $e_commerce_settings->woo_commerce_api_access_token ;
            $e_commerce['woo_commerce_api_key'] = $request->input('woo_commerce_api_key') ? $request->input('woo_commerce_api_key') : $e_commerce_settings->woo_commerce_api_key ;
            $e_commerce['woo_commerce_api_secret'] = $request->input('woo_commerce_api_secret') ? $request->input('woo_commerce_api_secret') : $e_commerce_settings->woo_commerce_api_secret ;
            $e_commerce['magento_enable'] = $request->input('magento_enable') ? $request->input('magento_enable') : $e_commerce_settings->magento_enable ;
            $e_commerce['magento_api_url'] = $request->input('magento_api_url') ? $request->input('magento_api_url') : $e_commerce_settings->magento_api_url ;
            $e_commerce['magento_api_access_token'] = $request->input('magento_api_access_token') ? $request->input('magento_api_access_token') : $e_commerce_settings->magento_api_access_token ;
            $e_commerce['magento_api_key'] = $request->input('magento_api_key') ? $request->input('magento_api_key') : $e_commerce_settings->magento_api_key ;
            $e_commerce['magento_api_secret'] = $request->input('magento_api_secret') ? $request->input('magento_api_secret') : $e_commerce_settings->magento_api_secret ;

            if($request->checkmarks_bigcommerce) {
                $arr = [];
                foreach ($request->checkmarks_bigcommerce as $key => $value) {
                    # code...
                    array_push($arr, [
                        'name' => 'checkmarks_bigcommerce[]',
                        'value' => $value,
                    ]);
                }   
                $business_details['big_commerce_checkbox'] = json_encode($arr);  
            }
            if($request->checkmarks_shopify) {
                $arrShop = [];
                foreach ($request->checkmarks_shopify as $key => $value) {
                    # code...
                    array_push($arrShop, [
                        'name' => 'checkmarks_shopify[]',
                        'value' => $value,
                    ]);
                }                     
                $business_details['shopify_checkbox'] = json_encode($arrShop);  
            }
            if($request->checkmarks_woocommerce) {
                $arrWoo = [];
                foreach ($request->checkmarks_woocommerce as $key => $value) {
                    # code...                    
                    array_push($arrWoo, [
                        'name' => 'checkmarks_woocommerce[]',
                        'value' => $value,
                    ]);
                }                                     
                $business_details['woo_commerce_checkbox'] = json_encode($arrWoo);  
            }

            $business_details['e_commerce_settings'] = json_encode($e_commerce);
            $business_details['big_commerce_sync_settings'] = $request->input('sync_settings_bigcommerce') ? json_encode($request->input('sync_settings_bigcommerce')) : null;
            $business_details['shopify_sync_settings'] = $request->input('sync_settings_shopify') ? json_encode($request->input('sync_settings_shopify')) : null;
            $business_details['woo_commerce_sync_settings'] = $request->input('sync_settings_woocommerce') ? json_encode($request->input('sync_settings_woocommerce')) : null;
            // dd($business_details);
            $business->fill($business_details);
            $business->save();
            $output = ['success' => 1,
                'msg' => __('business.settings_updated_success'),
            ];
        } catch (\Exception $e) {
            \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong'),
            ];
        }

        return redirect('e-commerce-integration')->with('status', $output);        
    }

    public function getMarketplaceIntegration() {
        if (!auth()->user()->can('etsy.view', 'etsy.create', 'amazon.view', 'amazon.create', 'warlmart.view', 'warlmart.create', 'ebay.view', 'ebay.create')) {
            abort(403, 'Unauthorized action.');
        }

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->first();
        // $woo_commerce_checkbox = json_decode($business->woo_commerce_checkbox);    
        // $shopify_checkbox = json_decode($business->shopify_checkbox);
        $walmart_checkbox = json_decode($business->walmart_checkbox);                        
        $amazon_checkbox = json_decode($business->amazon_checkbox);                     
        $etsy_checkbox = json_decode($business->etsy_checkbox);
        $business_locations = BusinessLocation::forDropdown($business_id, false, false);
        $reference_checkmarks = DB::table('checkmarks_vhomni')->get(); 

        $marketplace_default['walmart_enable'] = 0;
        $marketplace_default['etsy_enable'] = 0;
        $marketplace_default['amazon_enable'] = 0;
        $marketplace_default['ebay_enable'] = 0;
        
        $marketplace_settings = empty($business->marketplace_settings) ? $marketplace_default : json_decode($business->marketplace_settings, true);     
        // dd($marketplace_settings);           
        $marketplace_default['walmart_enable'] = $marketplace_settings['walmart_enable'];
        $marketplace_default['etsy_enable'] = $marketplace_settings['etsy_enable'];
        $marketplace_default['amazon_enable'] = $marketplace_settings['amazon_enable'];
        $marketplace_default['ebay_enable'] = $marketplace_settings['ebay_enable'];

        $marketplace_option = empty($business->walmart_option) ? null : json_decode($business->walmart_option);        
        $marketplace_option_amazon = empty($business->amazon_option) ? null : json_decode($business->amazon_option);
        $marketplace_option_etsy = empty($business->etsy_option) ? null : json_decode($business->etsy_option);
        
        // dd($marketplace_option, $marketplace_option_amazon);
        // $marketplace_settings = empty($business->marketplace_settings) ? $marketplace_default : json_decode($business->marketplace_settings, true);        

        return view('business.partials.settings_marketplace', compact('business', 'marketplace_settings', 'marketplace_default', 'business_locations', 'reference_checkmarks', 'walmart_checkbox', 'marketplace_option', 'amazon_checkbox', 'marketplace_option_amazon'));
    }

    public function postMarketplaceOmni(Request $request) {
        try {            
            $business_id = request()->session()->get('user.business_id');
            $business = Business::where('id', $business_id)->first();

            // marketplace integration settings        
            $marketplace['etsy_enable'] = $request->input('etsy_enable');
            $marketplace['etsy_api_url'] = $request->input('etsy_api_url');
            $marketplace['etsy_api_access_token'] = $request->input('etsy_api_access_token');
            $marketplace['etsy_api_key'] = $request->input('etsy_api_key');
            $marketplace['etsy_api_secret'] = $request->input('etsy_api_secret');
            $marketplace['amazon_enable'] = $request->input('amazon_enable');
            $marketplace['amazon_api_url'] = $request->input('amazon_api_url');
            $marketplace['amazon_api_access_token'] = $request->input('amazon_api_access_token');
            $marketplace['amazon_api_key'] = $request->input('amazon_api_key');
            $marketplace['amazon_api_secret'] = $request->input('amazon_api_secret');
            $marketplace['walmart_enable'] = $request->input('walmart_enable');
            $marketplace['walmart_api_url'] = $request->input('walmart_api_url');
            $marketplace['walmart_api_access_token'] = $request->input('walmart_api_access_token');
            $marketplace['walmart_api_key'] = $request->input('walmart_api_key');
            $marketplace['walmart_api_secret'] = $request->input('walmart_api_secret');
            $marketplace['ebay_enable'] = $request->input('ebay_enable');
            $marketplace['ebay_api_url'] = $request->input('ebay_api_url');
            $marketplace['ebay_api_access_token'] = $request->input('ebay_api_access_token');
            $marketplace['ebay_api_key'] = $request->input('ebay_api_key');
            $marketplace['ebay_api_secret'] = $request->input('ebay_api_secret');
            
            if($request->checkmarks_walmart) {
                $arr = [];
                foreach ($request->checkmarks_walmart as $key => $value) {
                    # code...
                    array_push($arr, [
                        'name' => 'checkmarks_walmart[]',
                        'value' => $value,
                    ]);
                }   
                $business_details['walmart_checkbox'] = json_encode($arr);  
            }
            
            if($request->checkmarks_amazon) {
                $arr = [];
                foreach ($request->checkmarks_amazon as $key => $value) {
                    # code...
                    array_push($arr, [
                        'name' => 'checkmarks_amazon[]',
                        'value' => $value,
                    ]);
                }   
                $business_details['amazon_checkbox'] = json_encode($arr);  
            }
            
            $business_details['marketplace_settings'] = json_encode($marketplace);
            $business_details['walmart_option'] = json_encode($request->input('value_marketplace'));
            $business_details['amazon_option'] = json_encode($request->input('value_marketplace_amazon'));            
            $business->fill($business_details);
            $business->save();
            $output = ['success' => 1,
                'msg' => __('business.settings_updated_success'),
            ];
        } catch (\Exception $e) {
            \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong'),
            ];
        }

        return redirect('marketplace-integration')->with('status', $output);        
    }    

    public function getAccountingIntegration() {
        if (! auth()->user()->can('big_commerce.view', 'big_commerce.create', 'shopify.view', 'shopify.create', 'woo_commerce.view', 'woo_commerce.create', 'magento.view', 'magento.create')) {
            abort(403, 'Unauthorized action.');
        }

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->first();

        $accounting_default['quickbooks_enable'] = 0;
        $accounting_default['zero_enable'] = 0;
        $accounting_default['myob_enable'] = 0;
        $business_locations = BusinessLocation::forDropdown($business_id, false, false);

        $transaction_type = Expense::groupBy('transaction_type')->pluck('transaction_type');
        $payee = Expense::whereNotNull('name')->groupBy('name')->pluck('name');
        $category = Expense::groupBy('split')->pluck('split');        
        $trigger = DB::table('trigger_actions')->whereNull('parent_id')->pluck('trigger_name', 'id');
        
        $accounting_settings = empty($business->accounting_settings) ? $accounting_default : json_decode($business->accounting_settings, true);        

        return view('business.partials.settings_accounting', compact('business', 'accounting_settings', 'transaction_type', 'payee', 'category', 'trigger', 'business_locations'));
    }

    public function postAccountingOmni(Request $request) {
        try {
            $business_id = request()->session()->get('user.business_id');
            $business = Business::where('id', $business_id)->first();

            // accounting integration settings        
            $accounting['quickbooks_enable'] = $request->input('quickbooks_enable');
            $accounting['quickbooks_api_url'] = $request->input('quickbooks_api_url');
            $accounting['quickbooks_api_access_token'] = $request->input('quickbooks_api_access_token');
            $accounting['quickbooks_api_key'] = $request->input('quickbooks_api_key');
            $accounting['quickbooks_api_secret'] = $request->input('quickbooks_api_secret');
            $accounting['zero_enable'] = $request->input('zero_enable');
            $accounting['zero_api_url'] = $request->input('zero_api_url');
            $accounting['zero_api_access_token'] = $request->input('zero_api_access_token');
            $accounting['zero_api_key'] = $request->input('zero_api_key');
            $accounting['zero_api_secret'] = $request->input('zero_api_secret');
            $accounting['myob_enable'] = $request->input('myob_enable');
            $accounting['myob_api_url'] = $request->input('myob_api_url');
            $accounting['myob_api_access_token'] = $request->input('myob_api_access_token');
            $accounting['myob_api_key'] = $request->input('myob_api_key');
            $accounting['myob_api_secret'] = $request->input('myob_api_secret');            

            $business_details['accounting_settings'] = json_encode($accounting);
            $business->fill($business_details);
            $business->save();
            $output = ['success' => 1,
                'msg' => __('business.settings_updated_success'),
            ];
        } catch (\Exception $e) {
            \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong'),
            ];
        }

        return redirect('accounting-integration')->with('status', $output);        
    }

    public function getShippingIntegration() {
        if (! auth()->user()->can('shipping_easy.view', 'shipping_easy.create', 'ship_station.view', 'ship_station.create', 'stamps.view', 'stamps.create')) {
            abort(403, 'Unauthorized action.');
        }

        $business_id = request()->session()->get('user.business_id');
        $business = Business::where('id', $business_id)->first();

        $shipping_default['shipping_easy_enable'] = 0;
        $shipping_default['ship_station_enable'] = 0;
        $shipping_default['stamps_enable'] = 0;
        
        $shipping_settings = empty($business->shipping_settings) ? $shipping_default : json_decode($business->shipping_settings, true);        

        return view('business.partials.settings_shipping', compact('business', 'shipping_settings'));
    }
    
    public function postShippingOmni(Request $request) {
        try {
            $business_id = request()->session()->get('user.business_id');
            $business = Business::where('id', $business_id)->first();

            // shipping integration settings        
            $shipping['shipping_easy_enable'] = $request->input('shipping_easy_enable');
            $shipping['shipping_easy_api_url'] = $request->input('shipping_easy_api_url');
            $shipping['shipping_easy_api_access_token'] = $request->input('shipping_easy_api_access_token');
            $shipping['shipping_easy_api_key'] = $request->input('shipping_easy_api_key');
            $shipping['shipping_easy_api_secret'] = $request->input('shipping_easy_api_secret');
            $shipping['ship_station_enable'] = $request->input('ship_station_enable');
            $shipping['ship_station_api_url'] = $request->input('ship_station_api_url');
            $shipping['ship_station_api_access_token'] = $request->input('ship_station_api_access_token');
            $shipping['ship_station_api_key'] = $request->input('ship_station_api_key');
            $shipping['ship_station_api_secret'] = $request->input('ship_station_api_secret');
            $shipping['stamps_enable'] = $request->input('stamps_enable');
            $shipping['stamps_api_url'] = $request->input('stamps_api_url');
            $shipping['stamps_api_access_token'] = $request->input('stamps_api_access_token');
            $shipping['stamps_api_key'] = $request->input('stamps_api_key');
            $shipping['stamps_api_secret'] = $request->input('stamps_api_secret');            

            $business_details['shipping_settings'] = json_encode($shipping);
            $business->fill($business_details);
            $business->save();
            $output = ['success' => 1,
                'msg' => __('business.settings_updated_success'),
            ];
        } catch (\Exception $e) {
            \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong'),
            ];
        }

        return redirect('shipping-integration')->with('status', $output);        
    }

    public function checkLocationHaveProducts(Request $request) {
        try {
            //code...
            $type = $request->type;
            $location_id = $request->location_id;
            $query = Product::join('variation_location_details as vld', 'vld.product_id', '=', 'products.id')
            ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id');
            
            if($type == 'shopify') {
                $query->whereNotNull('products.shopify_id');
            }
            if($type == 'bigcommerce') {
                $query->whereNotNull('products.big_commerce_id');
            }
            if($type == 'woocommerce') {
                $query->whereNotNull('products.woo_commerce_id');
            }
            if($type == 'walmart') {
                $query->whereNotNull('products.walmart_id');
            }
            
            $query->select('products.id', 'products.name', 'bl.name as location', 'bl.id as location_id', 'vld.variation_id');
                        
            if($query->first() == null) {
                return response()->json([
                    'rc' => 500,
                    'rm' => 'Products not found'
                ]);
            } else {
                if($query->first()->location_id != $location_id) {
                    return response()->json([
                        'rc' => 1,
                        'rm' => 'Found',
                        'location' => $query->first()->location
                    ]);
                } else {
                    return response()->json([
                        'rc' => 500,
                        'rm' => 'Products not found'
                    ]);
                }
            }
        } catch (\Exception $e) {
            //throw $th;
            return response()->json([
                'rc' => 2,
                'rm' => $e->getMessage()
            ]);
        }
    }

    public function getTriggerAction($id) {                
        $trigger_actions = DB::table('trigger_actions')
                    ->where('parent_id', $id)
                    ->select(['trigger_name', 'id'])
                    ->get();
        // $html = '<option value="">None</option>';
        $html = '<option value="">Choose an action</option>';
        if (! empty($trigger_actions)) {
            foreach ($trigger_actions as $tg) {
                $html .= '<option value="'.$tg->id.'">'.$tg->trigger_name.'</option>';
            }
        }
        echo $html;
        exit;
    }

    public function postTriggerAction(Request $request) {
        DB::beginTransaction();
        try {
            //code...
            $check = DB::table('trigger_actions_list')->where('trigger_id', $request->trigger)->first();
            if($check == null) {
                DB::table('trigger_actions_list')->insert([
                    'trigger_id' => $request->trigger,
                    'action_id' => $request->action
                ]);
            } else {
                return response()->json([
                    'rc' => 1,
                    'msg' => "You already have this trigger in your list"
                ]);
            }
            DB::commit();
            return response()->json([
                'rc' => 0,
                'msg' => "Trigger added successfully"
            ]);            
        } catch (\Throwable $th) {
            //throw $th;
            // dd($th);
            DB::rollBack();
            return $th;
        }
    }

    public function tableTriggerQb(Request $request) {
        if (request()->ajax()) {
            // dd($request->all());
            $trigger = DB::table('trigger_actions_list as tal')
                ->join('trigger_actions as ta', 'ta.id', '=', 'tal.trigger_id')
                ->join('trigger_actions as ta2', 'ta2.id', '=', 'tal.action_id') 
                ->select('ta.trigger_name', 'ta2.trigger_name as action_name', 'tal.id');
            /* if (! empty(request()->start_date) && ! empty(request()->end_date)) {
                $start = request()->start_date;
                $end = request()->end_date;
                $trigger->whereDate('date', '>=', $start)
                            ->whereDate('date', '<=', $end);
            }                
            if(! empty(request()->name) && $request->name != 'All') {
                $trigger->where('name', $request->name);
            }
            if(! empty($request->split) && $request->split != 'All') {            
                $trigger->where('split', $request->split);
            }
            if(! empty($request->transaction_type) && $request->transaction_type != 'All') {            
                $trigger->where('transaction_type', $request->transaction_type);
            } */
            return DataTables::of($trigger)
                    ->addColumn(
                        'action',
                        function($row) {
                            $html = '<div class="btn-group"><button type="button" class="btn btn-info dropdown-toggle btn-xs" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"> </i><span class="caret"></span><span class="sr-only">Toggle Dropdown</span></button><ul class="dropdown-menu dropdown-menu-left" role="menu">';
                            $html .=
                            '<li><a href="javascript:void(0)" onclick="delete_trigger('.$row->id.')" class="delete-product"><i class="fa fa-trash"></i> '.__('messages.delete').'</a></li>';
                            $html .= '</ul></div>';

                            return $html;
                        }
                    )
                    ->rawColumns(['action'])
                    ->make(true);
        }
    }

    public function tableCustomerQb(Request $request) {
        if (request()->ajax()) {
            // dd($request->all());
            $contacts = Contact::where('type', 'customer_quickbooks');
            /* if (! empty(request()->start_date) && ! empty(request()->end_date)) {
                $start = request()->start_date;
                $end = request()->end_date;
                $trigger->whereDate('date', '>=', $start)
                            ->whereDate('date', '<=', $end);
            }                
            if(! empty(request()->name) && $request->name != 'All') {
                $trigger->where('name', $request->name);
            }
            if(! empty($request->split) && $request->split != 'All') {            
                $trigger->where('split', $request->split);
            }
            if(! empty($request->transaction_type) && $request->transaction_type != 'All') {            
                $trigger->where('transaction_type', $request->transaction_type);
            } */
            return DataTables::of($contacts)
                    ->make(true);
        }
    }

    public function tableProductsQb(Request $request) {
        if(request()->ajax()) {
            $products = collect(DB::select("select p.name, p.sku, p.`type`, p.product_description, replace(JSON_EXTRACT(p.income_account_ref , '$.name'),'\"', '') as income_account_ref, v.default_sell_price, v.default_purchase_price, (CASE when p.tax_type = 'inclusive' then TRUE else false END) as taxable, vld.qty_available, p.alert_quantity from products as p join variations v on v.product_id = p.id join variation_location_details vld on vld.variation_id = v.id where p.`type` in ('service','inventory','noninventory')"));
            return DataTables::of($products)
                ->editColumn('taxable', function($row) {
                    if($row->taxable) {
                        return '<i class="fa fa-check"></i>';
                    } else {
                        return null;
                    }
                })
                ->make(true);
        }
    }

    public function destroyTrigger($id) 
    {
        DB::beginTransaction();
        try {
            //code...
            DB::table('trigger_actions_list')->where('id', $id)->delete();
            DB::commit();
            return response()->json([
                'rc' => 1,
                'msg' => "Trigger deleted successfully "
            ]);            
        } catch (\Throwable $th) {
            //throw $th;            
            DB::rollBack();
            return response()->json([
                'rc' => 500,
                'msg' => $th
            ]);
        }
    }

    public function tableInvoiceQb() {
        if(request()->ajax()) {
            $invoice = collect(DB::select("SELECT date_format(txn_date, '%m/%d/%y') as txn_date, invoice_no, replace(JSON_EXTRACT(customer_ref, '$.name'),'\"', '') as customer, total_amt, balance, date_format(due_date, '%m/%d/%y') as due_date, status, private_note, invoice_id, sync_token from invoice_quickbooks"));
            return DataTables::of($invoice)
                ->addColumn(
                    'action',
                    function($row) {
                        $html = '<div class="btn-group"><button type="button" class="btn btn-info dropdown-toggle btn-xs" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"> </i><span class="caret"></span><span class="sr-only">Toggle Dropdown</span></button><ul class="dropdown-menu dropdown-menu-left" role="menu">';
                        $html .=
                        '<li><a href="javascript:void(0)" onclick="view_edit_qb('.$row->invoice_id.', '.$row->sync_token.')" class="delete-product"><i class="fa fa-edit"></i> '.__('lang_v1.view_edit').'</a></li>';
                        if($row->private_note != 'Voided') {
                            $html .=
                            '<li><a href="javascript:void(0)" onclick="void_or_delete_invoice_qb('.$row->invoice_id.', '.$row->sync_token.', \'void\')" class="delete-product"><i class="fa fa-times-circle"></i> '.__('lang_v1.void').'</a></li>';
                        } else {
                            $html .= '';
                        }
                        $html .=
                        '<li><a href="javascript:void(0)" onclick="void_or_delete_invoice_qb('.$row->invoice_id.', '.$row->sync_token.', \'delete\')" class="delete-product"><i class="fa fa-trash"></i> '.__('messages.delete').'</a></li>';
                        $html .= '</ul></div>';
                        
                        return $html;
                    }
                )
                ->addColumn(
                    'status',
                    function($row) {
                        if(str_contains($row->private_note, 'Voided')) {
                            return 'Voided';
                        } else if($row->total_amt && $row->balance == 0) {
                            return '<i class="fa fa-check-circle" style="color: #2ca01c; font-size: 15px;"></i> Paid (Deposited)';
                        } else {
                            $origin = new DateTime($row->due_date);
                            $target = new DateTime();
                            $interval = $origin->diff($target);
                            if($interval->d == 0) {
                                return 'Due on '.date('m/d/Y', strtotime($row->due_date));
                            } else {
                                return '<i class="fa fa-info-circle" style="color: #ff9331; font-size: 15px;"></i> Overdue '.$interval->format('%a days');
                            }
                        }
                    }
                )
                ->rawColumns(['action', 'status'])
                ->make(true);

        }
    }
}
